//\/////
//\  overLIB AutoPositionMod Plugin
//\  This file requires overLIB 4.14 or later.
//\  Written by Dirk Koppers
//\/////
////////
// PRE-INIT
// Ignore these lines, configuration is below.
////////
if (typeof olInfo == 'undefined' || typeof olInfo.meets == 'undefined' || !olInfo.meets(4.14)) alert('overLIB 4.14 or later is required for the AutoPositionMod Plugin.');
else {
   registerCommands('nojustx,nojusty');
   ////////
   // DEFAULT CONFIGURATION
   // Settings you want everywhere are set here. All of this can also be
   // changed on your html page or through an overLIB call.
   ////////
   if (typeof ol_nojustx=='undefined') var ol_nojustx=0;
   if (typeof ol_nojusty=='undefined') var ol_nojusty=0;
   ////////
   // END OF CONFIGURATION
   // Don't change anything below this line, all configuration is above.
   ////////
   ////////
   // INIT
   ////////
   // Runtime variables init. Don't change for config!
   var o3_nojustx=0;
   var o3_nojusty=0;
   // PLUGIN FUNCTIONS
   ////////
   // Set runtime variables
   function setAutoPositionModVariables() {
      o3_nojustx = ol_nojustx;
      o3_nojusty = ol_nojusty;
   }
   // Parses AutoPositionMod Parameters
   function parseAutoPositionModExtras(pf,i,ar) {
      var k=i,v;
      if (k < ar.length) {
         if (ar[k]==NOJUSTX) { eval(pf +'nojustx=('+pf+'nojustx==0) ? 1 : 0'); return k; }
         if (ar[k]==NOJUSTY) { eval(pf +'nojusty=('+pf+'nojusty==0) ? 1 : 0'); return k; }
      }
      return -1;
   }

   function autoplaceLayer() {
      if (!o3_allowmove) {
         if (eval('o3_frame.'+docRoot)&&eval("typeof o3_frame."+docRoot+".clientWidth=='number'")&&eval('o3_frame.'+docRoot+'.clientWidth')) {
            innerX=eval('o3_frame.'+docRoot+'.clientWidth');
            innerY=eval('o3_frame.'+docRoot+'.clientHeight');
            fixX=0;
            fixY=0;
         }
         else if (o3_frame.innerWidth) {
            innerX=o3_frame.innerWidth;
            innerY=o3_frame.innerHeight;
            fixX=16;
            fixy=16;
         }
         overlibX = parseInt(o3_width);
         overlibY=(o3_aboveheight ? parseInt(o3_aboveheight) : (olNs4 ? over.clip.height : over.offsetHeight));
         scrolloffsetX = (olIe4) ? eval('o3_frame.'+docRoot+'.scrollLeft') : o3_frame.pageXOffset;
         scrolloffsetY = (olIe4) ? eval('o3_frame.'+docRoot+'.scrollTop') : o3_frame.pageYOffset;
      }
      if (o3_nojusty) {
         if ((innerX - (o3_x-scrolloffsetX) - o3_offsetx - fixX) < overlibX) {
            if (((o3_x-scrolloffsetX) - o3_offsetx) < overlibX) {
               if ((innerY - (o3_y-scrolloffsetY) - o3_offsety - fixY) < overlibY) {
                  if (((o3_y-scrolloffsetY) - o3_offsety) < overlibY) {
                     placeY = o3_y + o3_offsety;
                     placeX = justifyX();
                  }
                  else {
                     placeY = o3_y - o3_offsety - overlibY;
                     placeX = justifyX();
                  }
               }
               else {
                  placeY = o3_y + o3_offsety;
                  placeX = justifyX();
               }
            }
            else {
               placeX = o3_x - o3_offsetx - overlibX;
               placeY = justifyY();
            }
         }
         else {
            placeX = o3_x + o3_offsetx;
            placeY = justifyY();
         }
      }
      else if (o3_nojustx) {
         if ((innerY - (o3_y-scrolloffsetY) - o3_offsety - fixY) < overlibY) {
            if (((o3_y-scrolloffsetY) - o3_offsety) < overlibY) {
               if ((innerX - (o3_x-scrolloffsetX) - o3_offsetx - fixX) < overlibX) {
                  if (((o3_x-scrolloffsetX) - o3_offsetx) < overlibX) {
                     placeX = o3_x + o3_offsetx;
                     placeY = justifyY();
                  }
                  else {
                     placeX = o3_x - o3_offsetx - overlibX;
                     placeY = justifyY();
                  }
               }
               else {
                  placeX = o3_x + o3_offsetx;
                  placeY = justifyY();
               }
            }
            else {
               placeY = o3_y - o3_offsety - overlibY;
               placeX = justifyX();
            }
         }
         else {
            placeY = o3_y + o3_offsety;
            placeX = justifyX();
         }
      }
      else {
         placeX = justifyX();
         placeY = justifyY();
      }
      repositionTo(over, placeX, placeY);
   }

   function justifyX(){
      if (overlibX > innerX) {
         return scrolloffsetX;
      }
      else if ((innerX - (o3_x-scrolloffsetX) - o3_offsetx - fixX) < overlibX) {
         return scrolloffsetX + innerX - overlibX;
      }
      else {
         return o3_x + o3_offsetx;
      }
   }

   function justifyY(){
      if (overlibY > innerY) {
         return scrolloffsetY;
      }
      else if ((innerY - (o3_y-scrolloffsetY) - o3_offsety - fixY) < overlibY) {
         return scrolloffsetY + innerY - overlibY;
      }
      else {
         return o3_y + o3_offsety;
      }
   }


   ////////
   // PLUGIN REGISTRATIONS
   ////////
   registerRunTimeFunction(setAutoPositionModVariables);
   registerCmdLineFunction(parseAutoPositionModExtras);
   registerHook("placeLayer", autoplaceLayer, FREPLACE);
}

//   http://www.softcomplex.com/docs/get_window_size_and_scrollbar_position.html
//   function f_clientWidth() {
//      return f_filterResults (
//         window.innerWidth ? window.innerWidth : 0,
//         document.documentElement ? document.documentElement.clientWidth : 0,
//         document.body ? document.body.clientWidth : 0
//      );
//   }
//   function f_clientHeight() {
//      return f_filterResults (
//         window.innerHeight ? window.innerHeight : 0,
//         document.documentElement ? document.documentElement.clientHeight : 0,
//         document.body ? document.body.clientHeight : 0
//      );
//   }
//   function f_scrollLeft() {
//      return f_filterResults (
//         window.pageXOffset ? window.pageXOffset : 0,
//         document.documentElement ? document.documentElement.scrollLeft : 0,
//         document.body ? document.body.scrollLeft : 0
//      );
//   }
//   function f_scrollTop() {
//      return f_filterResults (
//         window.pageYOffset ? window.pageYOffset : 0,
//         document.documentElement ? document.documentElement.scrollTop : 0,
//         document.body ? document.body.scrollTop : 0
//      );
//   }
//   function f_filterResults(n_win, n_docel, n_body) {
//      var n_result = n_win ? n_win : 0;
//      if (n_docel && (!n_result || (n_result > n_docel)))
//         n_result = n_docel;
//      return n_body && (!n_result || (n_result > n_body)) ? n_body : n_result;
//   }


