####CODEHEADER###

&top;


# No editing is necessary
###############################################################################

###############################################################################
# TOP
# Determines what to do
###############################################################################
sub top {

   $REBUILDINDEX = "active" unless $default_skin_loaded;

   if ($admin_demo_mode) {
      &Error("$admin_demo_html");
   }

   $work_index = $data_directory . "/index.tmp";
   $work_categories = $data_directory . "/categories.tmp";

   $slash = '/';
   $step = $FORM{'step'};
   if (!$step) { $step = 1; }
   &get_date;


   if ($ENV{'HTTP_USER_AGENT'}) {
      if (!$is_admin) {
         if ($FORM{'ct'} && $FORM{'mct'}) {
            require "$libpath/crypt.pl";
            $my_current_time = &admin_encrypt($FORM{'ct'}, $secret_key);
            if ($my_current_time eq $FORM{'mct'}) {
               $elapsed = ($current_time - $FORM{'ct'}) / 86400; # 86400 sec = 1 day
               if ($elapsed > 1) {
                  &Error("Sorry, this direct link has expired.");
               }
               else {
                  require "$config_directory/post_config.pl";
                  if (-e "$data_directory/index_request.tmp") {
                     open (FILE,"$data_directory/index_request.tmp");
                     (@index_request)=<FILE>;
                     close(FILE);
                     $index_requests=@index_request;
                     if (($index_requests >= $index_requests_notification) && $index_requests_notification) {
                        $so_far_so_good = 1;
                     }
                  }
                  if ($so_far_so_good) {
                     $is_admin = 1;
                  }
                  else {
                     &Error("Sorry, the index was recently rebuild. There are not enough new rebuild requests made to allow rebuilding through a direct link.");
                  }
               }
            }
         }
      }
      if (!$is_admin) {
         &Error("Sorry , you do not have permission to rebuild the index.");
      }
      if ($FORM{'speedbuild'}) {
         $speedbuild = 1;
         &build_step_1;
         &build_step_2;
      }
      else {
         $new_layout = 1;
         &print_header;
         if (!$two_step_indexing) {
            &build_step_1;
            &build_step_2;
         }
         elsif ($step eq "1") {
            &build_step_1;
         }
         elsif ($step eq "2") {
            &build_step_2;
         }
      }
   }
   else {
      &build_step_1;
      &build_step_2;
   }

   &print_footer if $new_layout;
}


###############################################################################
# PRINT HEADER
# Prints the header
###############################################################################
sub print_header {

   if ($nph_supported) {
      print "HTTP/1.0 200 OK\n";
      print "Pragma: no-cache\n";
   }

   print "Content-type: text/html\n\n";


   if ($FORM{'log_out_option'}) {
      if ($new_layout && $two_step_indexing && ($step eq "1")) { # do nothing
      }
      else {
         $on_load_js = qq|<script language="javascript">function log_out() { location.href = "$imagefolio_url?admin=log_out"; }</script>|;
         $on_load = qq| onLoad="setTimeout('log_out()',3000)"|;
      }
   }

   print qq|
   <html>
   <head>
   <title>Rebuilding Indexes - Step $step of 2</title></head>
   <META HTTP-EQUIV= "expires"content = "-1">
   <META HTTP-EQUIV="Pragma" CONTENT="no-cache">
   <META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">$on_load_js
   <body bgcolor="#ffffff"$on_load>
   <form name=countform$step>|;

   if ($new_layout && $two_step_indexing) {
      print qq|<b>Rebuilding Indexes - Step $step of 2</b>|;
   }
}

###############################################################################
# PRINT FOOTER
# Prints the footer
###############################################################################
sub print_footer {
print qq|</pre>
</form>
</body>
</html>
|;
}

###############################################################################
# BUILD STEP 1
# Backs up the databases
###############################################################################
sub build_step_1 {
   $starttime = time();
   if ($new_layout && $two_step_indexing) {
      if ($FORM{'log_out_option'}) {
         $FORM{'log_out_option'} = "&log_out_option=1";
      }
      print "<h2>Backing Up Databases and Capturing Thumbnails and Categories</h2>";
      print "<a href=\"$buildurl&step=2$FORM{'log_out_option'}\"><b>On to Step 2</b></A> (please wait for page to load)<br><pre>";
      $boldB = "<b>";
      $boldE = "</b>";
   }
   elsif ($new_layout) {
      if ($FORM{'log_out_option'}) {
         $FORM{'log_out_option'} = qq| / <a href=\"$imagefolio_url?admin=log_out\">Log Out</a>|;
      }
      print "<b><a href=\"$adminurl\">Return to Admin Area</a> / <a href=\"$imagefolio_url\">Return to Gallery</a>$FORM{'log_out_option'}</b> (please wait for page to load)<br><pre>";
      $boldB = "<b>";
      $boldE = "</b>";
   }
   else {
      print "--------------------------------------------------------\n";
      print "---           R E B U I L D     I N D E X           ----\n";
      print "--------------------------------------------------------\n";
   }
   print "$date\n";
   print "--------------------------------------------------------\n";
   print "$boldB** Backing Up and Removing Old Databases . . .$boldE\n\n";
   &remove_old_backupfiles;
   &backup_data;
   print "--------------------------------------------------------\n";
   print "$boldB** Verifying Thumbnails and Categories . . .$boldE\n\n";
   &capturing_thumbnail_category_index;
   if ($new_layout && $two_step_indexing) {
      $stoptime = time();
      $elapsed = $stoptime - $starttime;
      print "\nDone! ($elapsed seconds)\n";
   }
   else {
      print "\n";
   }
}

###############################################################################
# BUILD STEP 2
# Backs up the databases
###############################################################################
sub build_step_2 {
   if ($new_layout && $two_step_indexing) {
      $starttime = time();
   }
   unless (-e $image_directory) {
      print "Fatal Error!\n";
      print "Searched for a directory at specified location:\n";
      print "    $image_directory\n";
      print "No directory found. Check settings.\n";
      exit;
   }
   if ($new_layout && $two_step_indexing) {
      if ($FORM{'log_out_option'}) {
         $FORM{'log_out_option'} = qq| / <a href=\"$imagefolio_url?admin=log_out\">Log Out</a>|;
      }
      print "<h2>Building Image and Category Index and clearing the search cache</h2>";
      print "<b><a href=\"$adminurl\">Return to Admin Area</a> / <a href=\"$imagefolio_url\">Return to Gallery</a>$FORM{'log_out_option'}</b> (please wait for page to load)<br>";
      print "<pre>$date\n";
   }
   print "--------------------------------------------------------\n";
   print "$boldB** Building Image Index . . .$boldE\n\n";
   &build_image_category_index;
   print "--------------------------------------------------------\n";
   print "$boldB** Removing Search Cache Files . . .$boldE\n";
   &remove_cache;
   if ($cache_page_age) {
      print "--------------------------------------------------------\n";
      print "$boldB** Removing Page Cache Files . . .$boldE\n";
      &remove_cached_pages;
   }
   $stoptime = time();
   $elapsed = $stoptime - $starttime;
   print "\nDone! ($elapsed seconds)\n";
}



###############################################################################
# Capturing thumbnails and categories
###############################################################################
sub capturing_thumbnail_category_index {

if ($new_layout) {
   print qq|Verified <input type="text" name="thumbcountver" value="0" size="7" maxlength="7" style="text-align:right"> thumbnails total.\nVerified <input type="text" name="catcountver" value="0" size="7" maxlength="7" style="text-align:right"> categories total.\n|;
}


$index_html = qq|<HTML><HEAD><TITLE>Forbidden</TITLE></HEAD><BODY>You do not have permission to access this directory.</BODY></HTML>|;

open(INDEXFILE,">$image_directory/index.html") or &Fatal("$image_directory/index.html");
print INDEXFILE $index_html;
close(INDEXFILE);
chmod(0777,"$image_directory/index.html");

@directories = ($image_directory);
$totaldir = 1;
$totalthumbs = 0;

for ($i=0; $i<$totaldir; $i++) {
   $directory = @directories[$i];
   $index_directory = $directory;
   $index_directory =~ s/\\/\//g;
   $index_directory =~ s/$image_directory\///g;
   opendir(DIR,$directory);
   @listings = readdir(DIR);
   closedir(DIR);

   foreach $listing (@listings) {
      next if (($listing eq ".") or ($listing eq "..") or ($listing =~ /_vti_cnf/i));
      $fullpath = $directory . $slash . $listing;
      if (-d $fullpath) {
         push(@directories,$fullpath);
         if ($directory eq $image_directory) {
            $catlist .= "$listing\t\n";
         }
         else {
            $catlist .= "$index_directory/$listing\t\n";
         }
         $totaldir++;
         if ($new_layout) {
            print qq|<SCRIPT LANGUAGE="JavaScript"><!--\nwindow.document.countform$step.catcountver.value=$totaldir - 1;\n// --></SCRIPT>|;
         }
         open(INDEXFILE,">$fullpath/index.html") or &Fatal("$fullpath/index.html");
         print INDEXFILE $index_html;
         close(INDEXFILE);
         chmod(0777,"$fullpath/index.html");
      }
      elsif ($directory ne $image_directory) {
         if ($listing =~ /^$mypattern/i) {
            $thumblist .= "$index_directory\|$listing\|\n";
            $totalthumbs++;
            if ($new_layout) {
               print qq|<SCRIPT LANGUAGE="JavaScript"><!--\nwindow.document.countform$step.thumbcountver.value=$totalthumbs;\n// --></SCRIPT>|;
            }
         }
         $dudirsize += -s $fullpath;
      }
   }
   $index_directory =~ s/\/$//g;
   $du_index .= int($dudirsize/1024) . "\t/$index_directory\n" if $dudirsize;
   $dutotalsize += $dudirsize;
   $dudirsize = ();
}

$du_index .= int($dutotalsize/1024) . "\tTotal\n";

open(DUCATEGORIES,">$disk_usage_file") or &Fatal("$disk_usage_file");
print DUCATEGORIES $du_index;
close(DUCATEGORIES);
chmod(0777,"$disk_usage_file");

# start of stats file

$statsline = qq|$totaldir\|$totalthumbs\|$date|;

open (KEYWORDSFILE,"$keywords_index");
my(@TotalKeywords)=<KEYWORDSFILE>;
$total_keywords = @TotalKeywords;
close(KEYWORDSFILE);

$work_statsfile = "$data_directory/stats.txt.tmp";
$statsfile = "$data_directory/stats.txt";

open(STATSFILE,">$work_statsfile") or &Fatal($work_statsfile);
if ($useflock) { flock(CATEGORIES, 2); }
print STATSFILE $statsline . "\|" . $total_keywords;
close(STATSFILE);
chmod(0777,"$work_statsfile");
rename ("$work_statsfile", "$statsfile") or &Fatal($statsfile);

# end of statsfile


   
my $index_check_file = "$data_directory/index_check.tmp";
if (-e $index_check_file) {
   open (LFILE,"$index_check_file");
   (@L_FILE)=<LFILE>;
   close(LFILE);

   open(LFILE,">$index_check_file") or &Fatal($index_check_file);
   print LFILE "@L_FILE[0]";
   close(LFILE);
   chmod(0777,"$index_check_file");
}


open(CATEGORIES,">$work_categories") or &Fatal($work_categories);
print CATEGORIES $catlist;
close(CATEGORIES);
chmod(0777,"$work_categories");

open(CATEGORIES,">$work_index") or &Fatal($work_index);
print CATEGORIES $thumblist;
close(CATEGORIES);
chmod(0777,"$work_index");

if (!$new_layout) {
   $totaldir = $totaldir - 1;
   print "Verified $totaldir categories total.\n";
   print "Verified $totalthumbs thumbnails total.\n\n";
}

}

###############################################################################
# Building image and category index
###############################################################################
sub build_image_category_index {

if ($using_mysql) {
   use DBI;

   print "Connecting to MySQL Database<br>";
   $dsn = "DBI:$mysql_db:$mysql_name:$mysql_host";  # data source name
   
   # Let's connect to the database
   $DBH = DBI->connect ($dsn, $mysql_username, $mysql_password) or &Error("Connection Error. Reason: " . $DBI::errstr . "\n.");

   print "Deleting existing database table<br>";   
   $DBH->do (qq{ DELETE FROM Metadata }) or &Error("Cannot delete table. Reason: " . $DBI::errstr . "\n."); # delete the table
}


require "$libpath/iptc.pl";

if (-e $indexfile && $if2_search) {
print "Saving existing keywords to memory...\n";
open (FILE,"$indexfile") or &Error("Can't Open $indexfile, is it created?: $!");
my(@stuff)=<FILE>;
$SIZE = @stuff;
close(FILE);

   for ($i=0;$i<=$SIZE;$i++) {
      my ($a, $b, $c, $d, $keywords) = split(/\|/, $stuff[$i]);
      $keywords =~ s/\n//g;
      if ($keywords) {
         $keywords =~ s/^\s+//g;               # Trim leading blanks...
         $keywords =~ s/\s+$//g;              # Trim trailing blanks...
         push(@keylines,"$b\|$a\|$keywords");
         $number_found++;
      }
   }

   if (!$number_found) { print "None found..."; }
   else { print "$number_found found..."; }
   print "Done!\n\n";
}


$start= "0";
$catlist = ();


open (FILE,"$work_index") or &Error("Can't open $work_index, reason : $!<br><b>Please run <a href=\"$buildurl\">Step 1</a> again.</b>");
(@THUMBS)=<FILE>;
close(FILE);

if ($new_layout) {
   print qq|Captured <input type="text" name="thumbcountcap" value="0" size="7" maxlength="7" style="text-align:right"> thumbnails, <input type="text" name="percentcountcap" value="0" size="3" maxlength="3" style="text-align:right">% of total.\n|;
}

@keylines = sort { lc($a) cmp lc($b) } @keylines;
@THUMBS = sort { lc($a) cmp lc($b) } @THUMBS;

$Number_Files = @THUMBS;
$totalthumbs = 0;
$dots = 0;


if ($Number_Files) {
   $percentage = ($Number_Files/100);
   $percentstep = 1;
   $smallpercentage = (100/$Number_Files);
}


open(ALLFILES,">$work_index") or &Fatal($work_index);
if ($useflock) { flock(ALLFILES, 2); }

#  $iptc_full_image_index=1;  # uncomment this if you are only using the large image for the IPTC info

   foreach (@ignore_keywords) {
      $ignore_keyword{lc($_)} = 1;
   }

   foreach $THUMB (@THUMBS) {
      $hits = "0";
      $rated = "0";
      $votes = "0";
      $filedate = ();
      $keywords1 = ();
      $custom18_user = ();
      $custom18_approve = ();
      ($thispath, $name) = split(/\|/, $THUMB);
      ($name_base) = $name =~ m,^(.*)\.\w+$,;
      $name_base =~ s/^$mypattern//g;
#      if ($display_top_hits) {
         my $countfile = qq|$image_directory/$thispath/$name_base.count|;
         if (-e $countfile) {
            open (FILE,"$countfile") or &Fatal("$countfile");
            while (<FILE>) {
               ($hits) = split(/\t/, $_);
               last;
            }
            close(FILE);
         }
#      }
#      if ($display_top_rates) {
         my $votefile = qq|$image_directory/$thispath/$name_base.vote|;
         if (-e $votefile) {
            open (FILE,"$votefile") or &Fatal("$votefile");
            while (<FILE>) {
               ($votes, $rated) = split(/\t/, $_);
               last;
            }
            close(FILE);
         }
#      }
      if ($number_found) {
         $keywords2 = ();
         for ($i=$start;$i<=$number_found;$i++) {
            my($category, $image, $words) = split(/\|/, $keylines[$i]);
            if ($image eq $name && $category eq $thispath) {
               $start = $i+1;
               $keywords2 = " $words ";
               last;
            }
         }
      }
      if ($name =~ /.jpg/i) {
         if ($iptc_full_image_index) {
            $name =~ s/^$mypattern//g;
         }
         $iptcstuff = ();
         $thumbimage = qq|$image_directory/$thispath/$name|;
         $iptcstuff = new Image::IPTCInfo("$thumbimage");
         if (defined($iptcstuff)){
            my %thiskeywordseen = ();
            foreach $key (sort keys %IPTCfields) {
               $iptcattr  = $IPTCfields{$key}[1];
               $iptcrule  = $IPTCfields{$key}[3];
               if ($iptcrule==2 or $iptcrule==3) {
                  if ($iptcattr eq 'keywords') {
                     $keywordsRef = $iptcstuff->Keywords();
                     if (defined($keywordsRef)) {
                        foreach $keyword (@$keywordsRef) {
                           $keyword =~ s/\+/ /g;
                           next if $ignore_keyword{lc($keyword)};
                           $keywords1 .= "$keyword ";
                           $keywordseen{lc($keyword)}++ unless $thiskeywordseen{lc($keyword)};
                           $thiskeywordseen{lc($keyword)}++;
                        }
                     }
                  }
                  else {
                     next if ($iptcattr eq 'custom18');
                     $iptcvalue = $iptcstuff->Attribute("$iptcattr");
                     if ($iptcvalue =~ /\S+/) {
                        @splitwords = split(/\s+/, $iptcvalue);
                        foreach $splitword (@splitwords) {
                           $splitword =~ s/\+/ /g;
                           next if $ignore_keyword{lc($splitword)};
                           $keywords1 .= "$splitword ";
                           $keywordseen{lc($splitword)}++ unless $thiskeywordseen{lc($splitword)};
                           $thiskeywordseen{lc($splitword)}++;
                        }
                     }
                  }
               }
            }
            if ($keywords1) {
               $keywords1 = " $keywords1";
            }
            $attribute_custom18 = $iptcstuff->Attribute('custom18');
            if ($attribute_custom18 !~ /\D/) {
               $custom18_date = $attribute_custom18;
            }
            else {
               ($custom18_date, $custom18_user, $custom18_email, $custom18_approve) = $attribute_custom18 =~ /\[(.*?)\]/g;
            }
            if ($save_upload_date) {
               if ($custom18_date) {
                  $filedate = $custom18_date;
               }
            }
         }
      }
      if ($iptc_full_image_index) {
         $name = qq|$mypattern$name|;
      }
      if (!$filedate) {
         ($filedate)  = (stat("$image_directory/$thispath/$name"))[9];
      }
      if ($votes > 0) {
         $rated = $rated * 100;
         $rated = sprintf("%04d%05d%06d", $rated, $votes, $hits);
      }
      else {
         $rated = "0";
      }
      if ($decode_charset) {
         $keywords1 = decode($decode_charset,$keywords1);
         $keywords2 = decode($decode_charset,$keywords2);
      }
      print ALLFILES "$name|$thispath|$filedate|$keywords1|$keywords2|$hits|$rated|$custom18_user|$custom18_approve|\n";

      if ($using_mysql) {
         $iptcdata = "$keywords1 $keywords2";
         $SQLName = $DBH->quote($name);
         $SQLCategory = $DBH->quote($thispath);
         $partial_name = $name;
         $partial_name =~ s/^$mypattern//g;
         $partial_name =~ s/\.jpg//ig;
         $splitpath = $thispath;
         $splitpath =~ s/\// /g;
         $splitpath =~ s/_/ /g;
         $iptcdata = qq|~ $iptcdata $partial_name $splitpath ~|;
         $SQLKeywords = $DBH->quote($iptcdata);
         $SQLDate = $DBH->quote($filedate);
         $Custom18_Date = $DBH->quote($custom18_date);
         $Custom18_User = $DBH->quote($custom18_user);
         $Custom18_Email = $DBH->quote($custom18_email);
         $Custom18_Approve = $DBH->quote($custom18_approve);
                
      
         $SQLHits = $DBH->quote($hits);
         $SQLRated = $DBH->quote($rated);
         $query = qq!
         INSERT INTO Metadata
           (category, filename, filedate, hits, rated, keywords,
           custom18_date, custom18_user, custom18_email, custom18_approve)
         VALUES
           ($SQLCategory, $SQLName, $SQLDate, $SQLHits, $SQLRated, $SQLKeywords, 
           $Custom18_Date, $Custom18_User, $Custom18_Email, $Custom18_Approve)
         !;
         $DBH->do ($query); 
         $iptcdata = "";      
      }


      if ($commandline) {
         print "Captured : $thispath - $name\n";
      }
      elsif ($speedbuild) {
         print ".";
         $dots++;
         if ($dots>=100) {
            print "\n";
            $dots = 0;
         }
      }
      elsif($new_layout) {
         $totalthumbs++;
         print qq|<SCRIPT LANGUAGE="JavaScript"><!--\nwindow.document.countform$step.thumbcountcap.value=$totalthumbs;\n// --></SCRIPT>|;
         if ($percentage>=1) {
            if ($totalthumbs > ($percentage*$percentstep)) {
               print qq|<SCRIPT LANGUAGE="JavaScript"><!--\nwindow.document.countform$step.percentcountcap.value=$percentstep;\n// --></SCRIPT>|;
               $percentstep++;
            }
         }
         else {
            $totalsmallpercentage = ($smallpercentage*$totalthumbs);
            ($totalsmallpercentage) = split(/\./,$totalsmallpercentage);
            print qq|<SCRIPT LANGUAGE="JavaScript"><!--\nwindow.document.countform$step.percentcountcap.value=$totalsmallpercentage;\n// --></SCRIPT>|;
         }
      }

      if (($thispath eq $oldpath) or !$oldpath) {
         push(@CATage,"$filedate");
         $totalimages++;
         my $elapsed = ($current_time - $filedate) / 86400;
         $totalnewimages++ if ($elapsed <= $new_date);
         $oldpath = $thispath;
      }
      else {
         @CATage = sort { $b <=> $a } @CATage;
         $catlist = $oldpath . "\t" . $totalimages . "\t" . @CATage[0] . "\t" . $totalnewimages . "\t\n";
         push(@CATline,"$catlist");
         @CATage = ();
         $oldpath = $thispath;
         push(@CATage,"$filedate");
         $totalimages = 1;
         $totalnewimages = 0;
         my $elapsed = ($current_time - $filedate) / 86400;
         $totalnewimages++ if ($elapsed <= $new_date);
      }
   }

if ($new_layout) {
   print qq|<SCRIPT LANGUAGE="JavaScript"><!--\nwindow.document.countform$step.percentcountcap.value=100;\n// --></SCRIPT>|;
}
elsif ($speedbuild) {
   print "\n";
}

if ($useflock) { flock(ALLFILES, 8); }
close(ALLFILES);
chmod(0777,"$work_index");

rename ("$work_index", "$indexfile") or &Fatal($indexfile);


if ($using_mysql) {
   END { $DBH and ($DBH->disconnect()); }
}



# this is the new global keywords section

open(FILE,">$keywords_index.temp");
flock(FILE, 2);

# KEYWORD THRESHOLD is located in the config.pl !!!
# $keyword_threshold = 3;

foreach $key (sort keys %keywordseen) {
   if ($keywordseen{$key} >= $keyword_threshold && length($key) > 2) {
      print FILE "$key\t$keywordseen{$key}\n";
      $total_keywords++;
   }
}
close(FILE);
chmod(0777,"$keywords_index.temp");
rename ("$keywords_index.temp", "$keywords_index") or &Fatal($keywords_index);

# end of global keywords





print "\nSuccessfully completed building of the Image Index.\n";
print "Captured $Number_Files thumbnails total.\n";
$Index_Size = -s $indexfile;

  if ($Index_Size < 1500) {
     $Index_Size = commify($Index_Size) . " bytes";
  }
  else {
     $Index_Size = int($Index_Size/1024);
     if ($Index_Size < 1500) {
        $Index_Size = commify($Index_Size) . " Kb";
     }
     else {
       $Index_Size = int($Index_Size/10.24);
       $Index_Size = ($Index_Size/100) . " Mb";
     }
  }

print "Image Index file is $Index_Size.\n\n";

print "--------------------------------------------------------\n";
print "$boldB** Building Category Index . . .$boldE\n\n";

@CATage = sort { $b <=> $a } @CATage;
$catlist = $oldpath . "\t" . $totalimages . "\t" . @CATage[0] . "\t" . $totalnewimages . "\t\n";
push(@CATline,"$catlist");

$totalcats = @CATline;

open (FILE,"$work_categories") or &Error("Can't Open $work_categories, reason: $!<br><b>Please run <a href=\"$buildurl\">Step 1</a> again.</b>");
(@CATS)=<FILE>;
close(FILE);

$Number_Cats = @CATS;

if ($new_layout) {
   print qq|Captured <input type="text" name="catcountcap" value="0" size="7" maxlength="7" style="text-align:right"> categories total.\n|;
}

@CATline = sort { lc($a) cmp lc($b) } @CATline;
@CATS = sort { lc($a) cmp lc($b) } @CATS;

$start = 0;
$Grand_Total = 0;
$catcount = 0;
$dots = 0;
$ducat_line = "";

foreach $CATS (@CATS) {
   ($tempcategory) = split(/\t/, $CATS);
   $found_cat = ();
   for ($i=$start;$i<$totalcats;$i++) {
      ($category, $thumbs, $catage) = split(/\t/, $CATline[$i]);
      if ($tempcategory eq $category) {
         $Grand_Total = $Grand_Total + $thumbs;
         $new_cat_line .= $CATline[$i];
         $start = $i+1;
         $found_cat = 1;
         last;
      }
   }
   if (!$found_cat) {
      $thumbs = 0;
      $new_cat_line .= $tempcategory . "\t0\t0\t\n" ;
   }

   $catcount++;













   if ($commandline) {
      print "Captured : $tempcategory : $thumbs thumbnails\n";
   }
   elsif ($speedbuild) {
      print ".";
      $dots++;
      if ($dots>=100) {
         print "\n";
         $dots = 0;
      }
   }
   elsif ($new_layout) {
      print qq|<SCRIPT LANGUAGE="JavaScript"><!--\nwindow.document.countform$step.catcountcap.value=$catcount;\n// --></SCRIPT>|;
   }
}

if ($speedbuild) {
   print "\n";
}




   #($du_cat_size_kb, $blah) = split(/	\//, $du_cat_size);
   #value was give in kb so lets convert to bytes, mb, and gb
   #$du_cat_size_bytes = $du_cat_size_kb * 1024;       #for bytes
   #$du_cat_size_mb = $du_cat_size_bytes / 1048576;    #for megabytes
   #$du_cat_size_gb = $du_cat_size_bytes / 1073741824; # for gigabytes
   #$du_cat_size_mb = sprintf("%.2f", $du_cat_size_mb);
   #$du_cat_size_gb = sprintf("%.2f", $du_cat_size_gb);




open(CATEGORIES,">$work_categories") or &Fatal($work_categories);
if ($useflock) { flock(CATEGORIES, 2); }
print CATEGORIES $new_cat_line;
if ($useflock) { flock(CATEGORIES, 8); }
close(CATEGORIES);
chmod(0777,"$work_categories");

rename ("$work_categories", "$catfile") or &Fatal($catfile);

print "\nSuccessfully completed building of the Category Index.\n";
print "Captured $Number_Cats categories total.\n";
$Cat_Size = -s $catfile;
  if ($Cat_Size < 1500) {
     $Cat_Size = commify($Cat_Size) . " bytes";
  }
  else {
     $Cat_Size = int($Cat_Size/1024);
     if ($Cat_Size < 1500) {
        $Cat_Size = commify($Cat_Size) . " Kb";
     }
     else {
       $Cat_Size = int($Cat_Size/10.24);
       $Cat_Size = ($Cat_Size/100) . " Mb";
     }
  }
print "Category Index file is $Cat_Size.\n\n";




}

###############################################################################
# BACUP DATA
# Backs up the databases
###############################################################################
sub backup_data {

   if (-e "$data_directory/backup/$sdate.index.txt") {
      print "Backup exists for today.. Skipping\n";
      print "Done.\n\n";
      return;
   }

   if (-e "$indexfile" && -e "$catfile") {
      eval { require File::Copy; };
      if (!$@) {
         print "Backing up image and category indexes using File::Copy...\n\n";
         &File::Copy::copy ("$indexfile", "$data_directory/backup/$sdate.index.txt") or &Error("Unable to copy image index. Reason: $!");
         &File::Copy::copy ("$catfile", "$data_directory/backup/$sdate.categories.txt") or &Error("Unable to copy category index. Reason: $!");
      }
      else {
         print "Backing up image and category indexes using standard copy method...\n\n";
         foreach (qw!index categories!) {
            open (TMP, "$data_directory/$_.txt") or &Error("Unable to open $data_directory/$_.txt: $!");
            open (TMPOUT, ">$data_directory/backup/$sdate.$_.txt") or &Error("Unable to open $data_directory/backup/$sdate.$_.txt Reason: $!");
            while (<TMP>) {
               print TMPOUT;
            }
            close TMP;
            close TMPOUT;
         }
      }
   }
   else { print "Nothing to backup\n"; }
}

###############################################################################
# REMOVE CACHE FILES
# Removes all the files in your cache directory so searches are now accurate
###############################################################################
sub remove_cache {

   opendir (CACHE, "$cache_directory/searches") or &Error("Unable to open cache directory $cache_directory/searches. Reason: $!");
   @cachefiles = readdir(CACHE);
   closedir (CACHE);
   $CACHESIZE = @cachefiles;

   $rc = 0;

   if ($CACHESIZE > 1) {
      foreach $cachefile (@cachefiles) {
         next if (($cachefile eq ".") or ($cachefile eq "..") or ($cachefile =~ /_vti_cnf/i) or ($cachefile =~ /.html$/i));
         $fullpath = $cache_directory . "/searches/" . $cachefile;
         unlink("$fullpath");  $rc++;
      }
   }
   print "\n$rc files removed.\n\n";

   if (-e "$data_directory/index_request.tmp") {
      unlink("$data_directory/index_request.tmp");
   }

}


###############################################################################
# Error
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{

local ($whoops) = @_;

print qq|
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$admin_font color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><$admin_font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$admin_font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$admin_font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
</body>
</html>
|;

exit;
}

###############################################################################
# GET DATE
# Gets the current date
###############################################################################
sub get_date {

   @days   = ('Sunday','Monday','Tuesday','Wednesday', 'Thursday','Friday','Saturday');
   @months = ('January','February','March','April','May','June','July',
              'August','September','October','November','December');

   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $time = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
   $year += 1900;
   $date = "$days[$wday], $months[$mon] $mday, $year at $time";

   $mon++;
   $sdate = sprintf "%04d-%02d-%02d-%02d-%02d-%02d", $year, $mon, $mday, $hour, $min, $sec;
   $last_backup_date = "$days[$wday], $months[$mon] $mday, $year";

}

###############################################################################
# FATAL
# Returns an error message if we were unable to build the index.
###############################################################################
sub Fatal {
   my ($message) = @_;
   print "Fatal Error! Cannot write to $message.\n";
   print "This script does not have permission to modify the file.\n";
   print "Build Module aborted.\n\n";
   print "Hint: Try: chmod 777\n";
   exit;
}

###############################################################################
# COMMIFY
# puts commas in those large numbers
###############################################################################
sub commify {
   my $text = reverse $_[0];
   $text =~ s/(\d\d\d)(?=\d)(?!\d*\.)/$1,/g;
   return scalar reverse $text;
}

###############################################################################
# REMOVE OLD BACKUP FILES
###############################################################################
sub remove_old_backupfiles {

   if (!$backup_expiration) {
      $backup_expiration = 1;
   }

   opendir (BACKUPFILES, "$data_directory/backup") or &Error("Can't Open $data_directory/backup: $!");
   @backup_files= grep { /.txt$/ } readdir(BACKUPFILES);
   closedir (BACKUPFILES);
   $backup_files_size = @backup_files;

   if ($backup_files_size > 1) {
     foreach $backup_file (@backup_files) { 
        if (-M "$data_directory/backup/$backup_file" > $backup_expiration) {
           unlink("$data_directory/backup/$backup_file");
        }
     }
   }
}

###############################################################################
# REMOVE OLD CACHED PAGES
###############################################################################
sub remove_cached_pages {

   opendir (CACHEDFILES, "$cache_directory/pages") or &Error("Can't Open $cache_directory/pages: $!");
   @cached_files= grep { /.html$/ } readdir(CACHEDFILES);
   closedir (CACHEDFILES);
   $cached_files_size = @cached_files;

   $rp = 0;

   if ($cached_files_size > 1) {
      foreach $cached_file (@cached_files) { 
         unlink("$cache_directory/pages/$cached_file");
         $rp++;
      }
   }
   print "\n$rp files removed.\n\n";
}

###############################################################################
# Error
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{
   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<html>
<head>
<title>Error</title>
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$font><font color="#ffffff"><strong>Error!</strong></font></font></td>
<td align=right nowrap><$font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
</body>
</html>
|;

exit;
}


1;