####CODEHEADER###

use File::Path;

###############################################################################
# ADD
# Add a new category
###############################################################################
sub add_category {

$ADDCATEGORY = "active";

if ($catstep eq "final") {

   if (!$catname) { &Error ("You must enter a Category Name."); }
   if (!$type) { &Error ("You must select a Category Type."); }

   $catname =~ s/^\s+//g;              # Trim leading blanks...
   $catname =~ s/\s+$//g;              # Trim trailing blanks...
   $catname =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $catname =~ s/\s+/_/g;              # Change spaces to underscores
   $newcatname = $catname;
   $newcatname =~ s/_/ /g;

   if ($type eq "main") {
      $createcat = "$image_directory/$catname";
      $pagetitle = "New Category Added";
      $comment = qq|<$admin_font><b>The category
      <font color=red>$newcatname</font> has been added.<b></font><br><br>|;
   }
   elsif ($type eq "sub") {
      if (!$category) { &Error ("You must select a Parent Category."); }
      $createcat = "$image_directory/$category/$catname";
      $pagetitle = "New Subcategory Added";
      $comment = qq|<$admin_font><b>The subcategory
      <font color=red>$newcatname</font> has been added in <font color=red>$category</font>.<b></font><br><br>|;
   }
   else { &Error ("Something strange happened here.  Please check your categories.pl or admin.cgi files for errors!"); }

   &check_dir ($catname, $createcat);

   unless ($admin_demo_mode) {
      mkdir ("$createcat", "0777") or &Error ("Unable to create category, $createcat.  Reason: $!");
      chmod(0777,"$createcat") or &Error ("Could not set permissions on category, $createcat.  Reason: $!");
   }

   $newcatdirect = $createcat;
   $newcatdirect =~ s/$image_directory\///g;

   unless ($admin_demo_mode) {
      open(CATEGORIES,">>$catfile") or &Error ("Could not open index file, $catfile.  Try rebuilding the index.  Reason: $!");
      if ($useflock) { flock(CATEGORIES, 2); }
      print CATEGORIES $newcatdirect . "\t" . "0" . "\n";;
      if ($useflock) { flock(CATEGORIES, 8); }
      close(CATEGORIES);
   }

   &show_new_category;
}
else { $pagetitle = "Add Category"; &show_new_category; }

}

###############################################################################
# SHOW NEW CATEGORY
# Shows the add a new category form
###############################################################################
sub show_new_category {

&get_header;
&get_catlist;

print qq|$comment

<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="categories.pl">
<input type=hidden name=cataction value="add">
<input type=hidden name=catstep value=final>

<center>
<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000"><tr><td>
<table border="0" width="100%" cellspacing=1 cellpadding=0>

<tr bgcolor="#ffcc00"><td colspan=2>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Add Category</b></font></td>
<td align=right><$admin_big_font><b>Step 1
of 1</b></font></td> </tr></table></td></tr>

<tr bgcolor="#eeeeee"><td width="50%" valign=top>
<table border=0 cellspacing=0 cellpadding=4 width="100%">

<tr><td nowrap><$admin_small_font><b>C A T E G O R Y&nbsp;
&nbsp;&nbsp;N A M E</b></font></td></tr><tr><td><input type=text name="catname"
size=35></td></tr>

<tr><td nowrap><$admin_small_font><b>C A T E G O R Y&nbsp;
&nbsp;&nbsp;T Y P E</b></font></td></tr><tr><td><input type=radio name="type"
value="main"><$admin_small_font>Main Category</font><br>
<input type=radio name="type" value="sub"><font face="Verdana,Arial,Helvetica"
size=1>Subcategory</font></td></tr>

</table>

</td><td width="50%" valign=top>
<table border=0 cellspacing=0 cellpadding=4 width="100%">
<tr><td nowrap><$admin_small_font><b>P A R E N T&nbsp;
&nbsp;&nbsp;C A T E G O R Y</b>&nbsp;&nbsp;(if Subcategory)</font></td></tr>
<tr><td>$catlist</td></tr></table>

</td></tr></table>

</td></tr></table>
<br><input type=submit value="Add New Category">
</center>
</form>
|;

&get_footer;
}

###############################################################################
# RENAME CATEGORY
# This one is difficult because we have to rename the category in four places:
# the directory itself, the captions file, in the image index, and the category
# index.
###############################################################################
sub rename_category {

$RENAMECATEGORY = "active";

if ($catstep eq "final") {

   if (!$catname) { &Error ("You must enter a New Category Name."); }
   if (!$category) { &Error ("You must select a Category to Rename."); }

   $catname =~ s/^\s+//g;              # Trim leading blanks...
   $catname =~ s/\s+$//g;              # Trim trailing blanks...
   $catname =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $catname =~ s/\s+/_/g;              # Change spaces to underscores

   @categories = split (/\//, $category);
   $replacetxt = pop @categories;

   $bounce = $category;
   $bounce =~ s/$replacetxt$/$catname/g;

   $renamecat = "$image_directory/$category";
   $newname = "$image_directory/$bounce";

   &check_dir ($catname, $newname);

   $pagetitle = "Category Renamed";
   $oldcatname = $category;
   $oldcatname =~ s/_/ /g;
   $newcatname = $bounce;
   $newcatname =~ s/_/ /g;

   $comment = qq|<$admin_font><b>The category
   <font color=red>$oldcatname</font> has been globally renamed.  The new category name is
   <font color=red>$newcatname</font>.<b></font><br><br>|;

   unless ($admin_demo_mode) {
         # FIRST WE RENAME THE DIRECTORY
            rename ("$renamecat", "$newname") or &Error ("Could not rename category, $renamecat.  Reason: $!");

         # SECOND, WE RENAME ALL INSTANCES OF THE OLD CATEGORY IN THE IMAGE INDEX

         open (FILE,"$indexfile") or &Error ("Could not open $indexfile, is it created.  Reason: $!");
         my(@LINES)=<FILE>;
         close(FILE);
         chomp @LINES;
         $SIZE=@LINES;

         open (INDEX,">$indexfile") or &Error ("Could not open $indexfile, is it created.  Reason: $!");
         if ($useflock) { flock(INDEX, 2); }

            for ($i=0;$i<=$SIZE;$i++) {
               $_=$LINES[$i];
               my ($filename, $path, $blah1, $iptc, $keywords, $blah2, $blah3) = split(/\|/, $_);

                 /^#/      and next;        # Skip comment Lines.
                 /^\s*$/   and next;        # Skip blank lines.

               if ($path =~ /^$category\//g or $path eq $category) {
                  $snicker = $path;
                  $snicker =~ s/^$category/$bounce/g;
                  print INDEX "$filename\|$snicker\|\$blah|$iptc|$keywords|$blah2|$blah3|\n";
               }
               else {
                  print INDEX $_ . "\n";
               }
            }

         if ($useflock) { flock(INDEX, 8); }
         close(INDEX);
         chmod(0777,"$indexfile") or &Error ("Could not set permissions on index, $indexfile.  Reason: $!");


         # THIRD, WE RENAME THE CAPTIONS AND THUMBNAIL CAPTIONS

            $ncat = $category;
            $ncat =~ s/\//\./g;           # Generate filename for our existing captions file
            $rncat = $bounce;
            $rncat =~ s/\//\./g;          # Generate filename for our new captions file
            @old_files = ();

            opendir (CACHE, "$data_directory") or &Error("Can't Open $data_directory: $!");
            @old_files = grep { /^$ncat\./i } readdir(CACHE);
            closedir (CACHE);

         foreach $old_file (@old_files) {
               $adding = $old_file;
               $adding =~ s/^$ncat//g;
               $new_file = $rncat . $adding;
               rename ("$data_directory/$old_file", "$data_directory/$new_file") or &Error ("Could not rename data file, $old_file.  Reason: $!");
               chmod(0777,"$data_directory/$new_file") or &Error ("Could not set permissions on data file, $new_file.  Reason: $!");
         }

# THIRD A, WE RENAME THE PRICE FILES

   $ncat = $category;
   $ncat =~ s/\//\./g;           # Generate filename for our existing captions file
   $rncat = $bounce;
   $rncat =~ s/\//\./g;          # Generate filename for our new captions file
   @old_files = ();

   opendir (CACHE, "$commercedata/prices");
   @old_files = grep { /^$ncat\./i } readdir(CACHE);
   closedir (CACHE);

foreach $old_file (@old_files) {
      $adding = $old_file;
      $adding =~ s/^$ncat//g;
      $new_file = $rncat . $adding;
      rename ("$commercedata/prices/$old_file", "$commercedata/prices/$new_file") or &Error ("Could not rename pricefile, $old_file.  Reason: $!");
      chmod(0777,"$commercedata/prices/$new_file") or &Error ("Could not set permissions on price file, $new_file.  Reason: $!");
}

         # FORTH, WE RENAME ALL INSTANCES OF THE OLD CATEGORY IN THE USER ACCESS DATABASE

            if ($using_multiuser_mod && ($admin_directory !~ /\//)){
               require "$libpath/users_access.pl";
               sub read_access_line {
                   my $split_line = shift;
                  &split_if_groupline($split_line);
                  if ($group_cat_access){
                     @users_cat = split(/::/,$group_cat_access);
                     $group_cat_access = ();
                     foreach $users_cat (@users_cat) {
                        if ($users_cat eq $category){
                           $access_found = 1;
                           $group_cat_access .= $bounce . "::";
                        }
                        else {
                           $group_cat_access .= $users_cat . "::";
                        }
                     }
                     $group_cat_access =~ s/::$//g;
                  }
                  if ($group_post_access){
                     @users_post = split(/::/,$group_post_access);
                     $group_post_access = ();
                     foreach $users_post (@users_post) {
                        if ($users_post eq $category){
                           $access_post_found = 1;
                           $group_post_access .= $bounce . "::";
                        }
                        else {
                           $group_post_access .= $users_post . "::";
                        }
                     }
                     $group_post_access =~ s/::$//g;
                  }
                  &populate_if_groupline;
                  $newgroupdb .= $if_groupline;
                  if ($readgroupdb) {$newgroupdb .= "\n";}
               }


               open (GROUPDB,"$groupdb") or &Error ("Could not open $groupdb, is it created.  Reason: $!");
               my (@LINES)=<GROUPDB>;
               close(GROUPDB);
               chomp @LINES;

               $readgroupdb = 1;
               foreach $accessfiledata (@LINES) {
                  &read_access_line($accessfiledata);
               }
               if ($access_cat_found or $access_post_found) {
                  open(GROUPDB, ">$groupdb");
                  if ($useflock) { flock(GROUPDB, 2); }
                  print GROUPDB "$newgroupdb";
                  close(GROUPDB);
                  chmod(0777,"$groupdb");
               }

               opendir (IDS, "$sessions_dir");
               my @sessions = grep { /\.user/ } readdir(IDS);
               closedir (IDS);
               $NUMSESSIONS = @sessions;

               if ($NUMSESSIONS > 1) {
                 $readgroupdb = ();
                 foreach $session (@sessions) {
                     $access_cat_found = ();
                     $access_post_found = ();
                     $newgroupdb = ();
                     open (SESSION,"$sessions_dir/$session");
                     my (@SESSIONLINE)=<SESSION>;
                     close(SESSION);
                     chomp @SESSIONLINE;
                     my ($userline, $groupline) = @SESSIONLINE[0] =~ /\[(.*?)\]/g;
                     &read_access_line($groupline);
                     if ($access_cat_found or $access_post_found) {
                        open(SESSION, ">$sessions_dir/$session");
                        if ($useflock) { flock(SESSION, 2); }
                        print SESSION "[$userline][$newgroupdb]\n";
                        close(SESSION);
                        chmod(0777,"$sessions_dir/$session");
                     }
                 }
               }

            }

         # FIVE, WE RENAME ALL INSTANCES OF THE OLD CATEGORY IN THE CATEGORY INDEX

         open (CATFILE,"$catfile") or &Error ("Could not open $catfile, is it created.  Reason: $!");
         my(@CATS)=<CATFILE>;
         close(CATFILE);
         chomp @CATS;
         $SIZE=@CATS;

         open (CATINDEX,">$catfile") or &Error ("Could not open $catfile, is it created.  Reason: $!");
         if ($useflock) { flock(CATINDEX, 2); }

            for ($i=0;$i<=$SIZE;$i++) {
               $_=$CATS[$i];
               my ($direct, $cnt, $catdate) = split(/\t/, $_);

                 /^#/      and next;        # Skip comment Lines.
                 /^\s*$/   and next;        # Skip blank lines.

               if ($direct =~ /^$category\//g or $direct eq $category) {
                  $doodle = $direct;
                  $doodle =~ s/^$category/$bounce/g;
                  print CATINDEX $doodle . "\t" . $cnt . "\t" . $catdate . "\t\n";
               }
               else {
                  print CATINDEX $_ . "\n";
               }
            }

         if ($useflock) { flock(CATINDEX, 8); }
         close(CATINDEX);
         chmod(0777,"$catfile") or &Error ("Could not set permissions on index file, $catfile.  Reason: $!");

         # SIX, AND FINALLY, WE RENAME ALL INSTANCES OF THE OLD CATEGORY DESCRIPTIONS
            if (-e $catdesc){
         open (CATFILE,"$catdesc") or &Error ("Could not open $catdesc, is it created.  Reason: $!");
         my(@CATS)=<CATFILE>;
         close(CATFILE);
         chomp @CATS;
         $SIZE=@CATS;

         open (CATINDEX,">$catdesc") or &Error ("Could not open $catdesc, is it created.  Reason: $!");
         if ($useflock) { flock(CATINDEX, 2); }

            for ($i=0;$i<=$SIZE;$i++) {
               $_=$CATS[$i];
               my ($direct, $cnt) = split(/\t/, $_);

                 /^#/      and next;        # Skip comment Lines.
                 /^\s*$/   and next;        # Skip blank lines.

               if ($direct =~ /^$category\//g or $direct eq $category) {
                  $doodle = $direct;
                  $doodle =~ s/^$category/$bounce/g;
                  print CATINDEX $doodle . "\t" . $cnt . "\n";
               }
               else {
                  print CATINDEX $_ . "\n";
               }
            }

         if ($useflock) { flock(CATINDEX, 8); }
         close(CATINDEX);
         chmod(0777,"$catdesc") or &Error ("Could not set permissions on index file, $catfile.  Reason: $!");
      }
   }

   &show_rename;
}
else { $pagetitle = "Rename Category"; &show_rename; }
}

###############################################################################
# SHOW RENAME
# Prints a form for the renaming of an existing category
###############################################################################
sub show_rename {

&get_header;
&get_catlist;

print qq|$comment
<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="categories.pl">
<input type=hidden name=cataction value="rename">
<input type=hidden name=catstep value=final>

<center>
<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000"><tr><td>
<table border="0" width="100%" cellspacing=1 cellpadding=0>

<tr bgcolor="#ffcc00"><td colspan=2>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Rename Category</b></font></td>
<td align=right><$admin_big_font><b>Step 1
of 1</b></font></td> </tr></table></td></tr>

<tr bgcolor="#eeeeee"><td width="50%" valign=top>
<table border=0 cellspacing=0 cellpadding=4 width="100%">

<tr><td nowrap><$admin_small_font><b>N E W&nbsp;&nbsp;
&nbsp;C A T E G O R Y&nbsp;&nbsp;&nbsp;N A M E</b></font></td></tr>
<tr><td><input type=text name="catname" size=35></td></tr>

</table>

</td><td width="50%" valign=top>
<table border=0 cellspacing=0 cellpadding=4 width="100%">
<tr><td nowrap><$admin_small_font><b>C A T E G O R Y&nbsp;
&nbsp;&nbsp;T O&nbsp;&nbsp;&nbsp;R E N A M E</b></font></td></tr>
<tr><td>$catlist</td></tr></table>

</td></tr></table>

</td></tr></table>
<br><input type=submit value="Rename Category">
</center>
</form>
|;

&get_footer;

}

###############################################################################
# DELETE CATEGORY
# Deletes a category an all associated images from the Web server.  Does not
# remove category from the database and user must Build the Image Index for
# this to take place.
###############################################################################
sub delete_category {

$DELETECATEGORY = "active";

if ($catstep eq "final") {

   if (!$category) { &Error ("You must select a category for deletion."); }

   $deletecat = "$image_directory/$category";
   $pagetitle = "Category Deleted";
   $newcatname = $category;
   $newcatname =~ s/_/ /g;
   my $added_coment = qq| You will need to re-Build your Image Index before this category can be completely deleted from the database.| unless $admin_demo_mode;
   $comment = qq|<$admin_font><b>The category
   <font color=red>$newcatname</font> has been deleted from your Web space.$added_coment</b></font><br><br>|;
   
   rmtree($deletecat) or &Error("Could not delete category, $category.  Reason: $!") unless $admin_demo_mode;
   &show_delete;
}


elsif ($catstep eq "2") {

   if (!$category) { &Error("You must select a category for deletion."); }
   $pagetitle = "Delete Category : Confirmation";
   &get_header;

print qq|
<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="categories.pl">
<input type=hidden name=cataction value="delete">
<input type=hidden name=catstep value=final>
<input type=hidden name=category value="$category">

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr>
<td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000">
<tr><td><table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$admin_font color="#ffffff"><strong>Warning!</strong>
</font></td></tr>

<tr bgcolor="#eeeeee">
<td><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$admin_font><b><font color="#ff0000">You
are about to delete the category '$category' and all of its associated
images.  Are you sure you want to do this?</font></b><br><br>If not, please
click the Cancel button below.<br><br></font></td></tr></table>

<center><nobr><$admin_font><INPUT TYPE="submit" VALUE="Yes, Delete It!">
&nbsp;<INPUT TYPE="button" VALUE="Cancel" onClick="history.go(-1)"></font></nobr></center>

</td></tr></table></td></tr></table></td></tr></table></form>|;

&get_footer;
}
else { $pagetitle = "Delete Category"; &show_delete; }
}

###############################################################################
# ADD CAT DESC
# Shows the form for adding category descriptions
###############################################################################
sub add_cat_desc {

$ADDDESCRIPTIONS = "active";

if ($catstep eq "final") {

   $catfound = "";
   my @LINES;

   $description =~ s/^\s+//g;              # Trim leading blanks...
   $description =~ s/\s+$//g;              # Trim trailing blanks...
   $description =~ s/\r\n/ /g;             # Change newline to a space.
   $description =~ s/\r//g;                # Remove Windows linefeed character.
   $description =~ s/\n/ /g;               # Change newline to a space.
   $description =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $description =~ s/\s+\s+/ /g;           # Change two spaces to one again.

   if (-e $catdesc) { 
      open (DESC,"<$catdesc");
      while (<DESC>) {
         chomp;
         next if /^\s*$/; # skip blank lines
         next if /^#/;    # skip comment lines
         push(@LINES, $_);
      }
      close(DESC);
   }

   $SIZE = @LINES;

   unless ($admin_demo_mode) {
      open (INDEX,">$catdesc") or &Error ("Could not open $catdesc.  Reason: $!");
      if ($useflock) { flock(INDEX, 2); }

      for ($i=0; $i<=$SIZE; $i++) {
         $_ = $LINES[$i];
         my ($catgname, $catgdesc) = split(/\t/, $_);

         if ($catgname eq $category) {
            $catfound = 1;
            print INDEX $category . "\t" . $description . "\n";
         }
         else {
            print INDEX $_ . "\n";
         }
      }

      if (!$catfound) { print INDEX $category . "\t" . $description . "\n"; }

      if ($useflock) { flock(INDEX, 8); }
      close(INDEX);
   }


   # here we open up catdesc.txt and save current results, then overwrite the file
   # with the new description

   $pagetitle = "Category Description Added";
   $newcatname = $category;
   $newcatname =~ s/_/ /g;
   $comment = qq|<$admin_font><b>The description for
   <font color=red>$newcatname</font> has been added successfully.<b></font><br><br>|;
   &show_add;
}
elsif ($catstep eq "2") {

   # here we open up catdesc.txt and check to see if a description already exists

   my $cat_desc;
   $newcategory = $category;
   $newcategory =~ s/_/ /g;
   $newcategory =~ s/\// \&gt; /g;

   if (-e $catdesc) { 
      open (DESC,"< $catdesc");
      while (<DESC>) {
         chomp;
         next if /^\s*$/; # skip blank lines
         next if /^#/;    # skip comment lines
         push(@desc, $_);
      }
      close(DESC);

      foreach $line (@desc) {
         my ($catname, $catdescription) = split(/\t/, $line);
         $catdescription =~ s/^\s+//g;    # trim leading blanks...
         $catdescription =~ s/\s+$//g;    # trim trailing blanks...
         next if (!$catdescription);      # skip line if no description
         if ($catname eq $category) { $cat_desc = $catdescription; last; }
      }
   }

   $pagetitle = "Add Category Descriptions : Enter Category Description";

   &get_header;

print qq|
<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="categories.pl">
<input type=hidden name=cataction value="adddesc">
<input type=hidden name=catstep value="final">
<input type=hidden name=category value="$category">

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Enter Category Description</b></font></td>
<td align=right><$admin_big_font><b>Step 2 of 2</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#ffffff"><td>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_small_font>$newcategory</font></td></tr></table>
</td></tr>

<tr bgcolor="#eeeeee">
<td align=center><textarea name=description cols=45 rows=6 wrap=virtual>$cat_desc</textarea></td>
</tr></table></td></tr></table>

<br><input type=submit value="Save Category Description">

</center>

</form>|;

   &get_footer;
}
else { $pagetitle = "Add Category Descriptions : Select a Category"; &show_add; }


}

sub batch_thumbnail {

   $BATCHTHUMBNAIL = "active";
   $pagetitle = "Batch Thumbnail : Select a Category";
   &get_header;
   &get_catlist;

   print qq|$comment
   <form method=get action="$imagefolio_url">
   <input type=hidden name=main value="imageBatch">
   <center>

   <table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

   <tr><td>

   <table border="0" width="100%" cellspacing=1 cellpadding=0>
   <tr bgcolor="#ffcc00"><td>

   <table border="0" width="100%" cellspacing=0 cellpadding=4>
   <tr><td><$admin_big_font><b>Select A Category</b></font></td>
   <td align=right><$admin_big_font><b>Step 1 of 2</b></font></td>
   </tr></table></td></tr>

   <tr bgcolor="#eeeeee"><td align=center>$catlist</td></tr></table></td></tr></table>

   <br><input type=submit value="Batch Thumbnail this Category">

   </center>

   </form>
   |;

   &get_footer;
}

sub build_index {

   $REBUILDINDEX = "active";
   $pagetitle = "Rebuild Index: Select a Category";
   &get_header;
#   &get_catlist;


   open (FILE,"$catfile") or &Error ("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   close(FILE);
   chomp @LINES;
   @LINES = sort { lc($a) cmp lc($b) } @LINES;

   $catlist = qq|<select name="category" onChange="if (this[this.selectedIndex].value) {window.document.menu.rebuild.value='Rebuild '+this[this.selectedIndex].value;} else {window.document.menu.rebuild.value='Rebuild All Categories';}"><optgroup label="Rebuild All Categories" style="background:#ffcc00;">Rebuild All Categories</optgroup><option value="" selected>All Categories</option><optgroup label="Rebuild Selected Category and Subcategories" style="background:#ffcc00;">Rebuild Selected Category and Subcategories</optgroup>|;

   foreach $LINE (@LINES) {
      $space = "";
      ($category, $imagecount) = split(/\t/, $LINE);
      @categories = split (/\//, $category);
      foreach $cat (@categories) {
         $space .= "......";
      }
      $newcategory = pop @categories;
      $newcategory = &get_clean_name($newcategory);
      $space =~ s/\.\.\.\.\.\.//;
      $catlist .= qq|<option value="$category">$space$newcategory|;
   }

   $catlist .= qq|</select>|;


   print qq|$comment

   <center>
   <form name=menu method=get action="$imagefolio_url">
   <input type=hidden name=admin value="build">
   <input type=hidden name=ct value="$current_time">
   <table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

   <tr><td>

   <table border="0" width="100%" cellspacing=1 cellpadding=0>
   <tr bgcolor="#ffcc00"><td>

   <table border="0" width="100%" cellspacing=0 cellpadding=4>
   <tr><td><$admin_big_font><b>Select A Category</b></font></td>
   <td align=right><$admin_big_font><b>Step 1 of 2</b></font></td>
   </tr></table></td></tr>

   <tr bgcolor="#eeeeee"><td align=center>$catlist</td></tr></table></td></tr></table>

   <br><input id=rebuild name=submit type=submit value="Rebuild All Categories">
   </form>
   <!--<form method=get action="$imagefolio_url">
   <input type=hidden name=admin value="build">
   <input type=hidden name=ct value="$current_time">
   <input type=submit value="Rebuild all categories ">
   </form>!-->
   </center>


   |;

   &get_footer;
}

###############################################################################
# SHOW ADD
# Shows the form for adding category descriptions
###############################################################################
sub show_add {
&get_header;
&get_catlist;

print qq|$comment
<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="categories.pl">
<input type=hidden name=cataction value="adddesc">
<input type=hidden name=catstep value="2">

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Select A Category</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 2</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>$catlist</td></tr></table></td></tr></table>

<br><input type=submit value="Add Description to Category">

</center>

</form>
|;

&get_footer;

}


###############################################################################
# SHOW DELETE
# Shows the category form so we can select a category for deletion
###############################################################################
sub show_delete {
&get_header;
&get_catlist;

print qq|$comment
<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="categories.pl">
<input type=hidden name=cataction value="delete">
<input type=hidden name=catstep value=2>

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Select A Category to Delete</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 2</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>$catlist</td></tr></table></td></tr></table>

<br><input type=submit value="Delete This Category">

</center>

</form>
|;
&get_footer;
}

###############################################################################
# CHECK DIR
# Make sure we have valid characters in the directory name before building it
###############################################################################
sub check_dir {
   my ($dirname, $dir) = @_;
   if ($dirname =~ /[$deny_chars]/i) {
      &Error("Invalid characters in category name '$dirname'. A Category cannot contain any of the following characters:<br> $deny_characters");
   }
    if (-e $dir) {
        &Error ("The category '$dirname' already exists, try using another!");
    }
    return $input;
}

1;
