####CODEHEADER###

use File::Copy;
&File::Copy::copy ("$data_directory/config/main.pl", "$data_directory/config/main_temp.pl");
chmod(0777,"$data_directory/config/main_temp.pl");
require "$data_directory/config/main_temp.pl";
unlink("$data_directory/config/main_temp.pl");
$CONFIGEDITOR = "active";

# 0 - boolean
# 1 - any number
# 2 - any number > 0
# 3 - string
# 4 - not null string

my %configs = (
	main_aa => ['site_title',			'WHAT IS THE NAME OF YOUR WEBSITE?', '', 4],
	main_aaa => ['homelink',			'WHAT IS THE URL OF YOUR HOMEPAGE?', 'If you do not want to show the "Home" button then leave this empty', 3],
	main_ab => ['admin_email',			'WHAT IS YOUR EMAIL?', '', 4],
	main_ac => ['smtp_server',			'WHAT IS YOUR SMTP SERVER ADDRESS?', 'If you use SMTP mail server then fill in your smtp server. For 99.9% of the Unix servers this is not needed.', 3],
	main_ad => [['using_postcard_mod', 'using_lightbox_mod', 'using_multiuser_mod', 'using_picturepost_mod', 'using_batch_thumbnail_mod'],
										'DO YOU HAVE ANY MODS INSTALLED?', '', [0, 0, 0, 0, 0]],
	main_ae => ['skin_name',			'WHAT IS THE NAME OF THE IMAGEFOLIO SKIN THAT YOU WOULD LIKE TO USE?', 'Make sure that the name you choose is exactly the same (case sensitive) as the name of a directory inside your "skins" directory. "classic" is for the classic ImageFolio look.', 4],
	main_af => ['cache_page_age',		'IMAGEFOLIO CACHING FEATURE', 'Here you can set the age of an ImageFolio cached page. 1 = 24 hours. 0 is disabled.', 1],
	main_ag => ['extensions',			'WHAT TYPES OF FILE EXTENSIONS CAN YOUR THUMBNAILS LINK TO?', '', 0],
	main_ah => ['useflock',				'DOES YOUR SERVER SUPPORT FLOCKING?', 'Most all Unix and Windows servers do.', 0],
	main_ai => ['mypattern',			'WHAT IS THE UNIQUE PATTERN YOU USE TO IDENTIFY THUMBNAIL IMAGES?', 'ImageFolio will scan a directory for thumbnail images by looking for this unique pattern at the beginning of your thumbnail image filename.  If it finds this pattern in a filename, it will display the image as a thumbnail image.  imageFolio will then check to see if there is another image in the same directory, that has the same name, but without the pattern.  If it finds a match, it will create a link from the thumbnail image to the larger image.  Type the unique pattern you will use for thumbnail filenames below.  Remember, you must use this pattern for all thumbnail images and it must be placed at the beginning of the image filename (i.e.  "tn_image6.jpg" and your unique pattern is "tn_"', 4],
	main_aj => [['use_fullsize', 'mypattern_fullsize', 'myextension_fullsize', 'download_link_under_preview', 'download_link_under_thumbnail'],
										'ARE YOU USING 3rd SET OF IMAGE?', 'If you are using a 3rd set of images (example: high-res image for download) then set "use_fullsize" to "yes" and also fill in the pattern and extension you use for them. It is a good idea to use a complex "mypattern_fullsize" that is not easy to guess.<p><font color="red">Note: You should not change the pattern and extension after you set them initially since that will result in showing all you high resolution files to show up in the gallery.</font><p>If you set "use_fullsize" to "yes" you can choose to have a download button undernetneath the thumbnails and/or the preview image.<p>Downloads of these full size files can be logged. Read "Log configuration" below.<p>If you set "myextension_fullsize" to "zip" then files that are uploaded through the browser or iBULC will automatically be zipped up. COMPRESS::ZLIB is required!!!!!! Check your serverinfo to determine if it is installed.', [0, 4, 4, 0, 0]],
	main_ak => ['download_from_temp',	'DOWNLOAD THROUGH SCRIPT OR TEMP DIR?', 'The downloads high res downloads can be served through the script or through the "temp" directory. Both will hide the real location of the files from the user. If the files are large and the user connection slow the download script might time out and cut off the file halfway. If that is the case then set "download_from_temp" to "yes". This will copy the high res file to the "temp" directory and then make it available to the user. Downloads will be removed after 6 hours.', 0],
	main_al => ['columns',				'HOW MANY COLUMNS DO YOU WANT FOR IMAGE DISPLAY?', '', 2],
	main_am => ['rows',					'HOW MANY ROWS DO YOU WANT TO LIST PER PAGE PER CATEGORY AND ON SEARCH', '', 2],
	main_an => ['pages_ahead_count',	'NEXT AND PREVIOUS LINKS', 'When a category or search results contains more images than fit on one thumbnail page, next and previous links will be displayed. Set the number of links for pages ahead you would like your gallery to display.', 1],
	main_ao => ['cat_columns',			'HOW MANY COLUMNS DO YOU WANT FOR CATEGORY DISPLAY?', '', 2],
	main_aoo => ['title_cut_off',		'CATEGORY CHARACTER CUT OFF IN TITLE LINKS', 'The current location links (<u>TOP</u> &gt; <u>Category</u> &gt; <u>Subcategory</u>) can become very large. To reduce the size you can cut of the categoy names. At how many characters should it cut of? 0 = disable', 1],
	main_ap => [['maxsubdirectory', 'subcat_ahead_count'],
										'HOW MANY SUBCATEGORIES DO YOU WANT TO LIST PER PAGE PER CATEGORY?', 'If you want to list all you subcategories per category on a single page then set "maxsubdirectory" to "0". Otherwise specify how many subcategories to display per page.', [1, 1]],
	main_aq => ['sortfiles',			'DO YOU WANT TO SORT THUMBNAILS BY DATE, OR ALPHABETICALLY?', '', 2],
	main_ar => ['record_counts',		'DO YOU WANT TO RECORD THE NUMBER OF TIMES EACH THUMBNAIL IMAGE IS CLICKED?', 'This will store download statistics in a separate file.  If you choose to display_fileinfo (below) and display_counts (below), you can display  the current number of downloads under each thumbnail image.', 0],
	main_as => ['display_fileinfo',		'DO YOU WANT TO DISPLAY FILE INFORMATION AT ALL?', '', 0],
	main_at => [['display_filename', 'display_filetype', 'display_filesize', 'display_date', 'display_hits', 'display_downloads', 'display_rates'],
										'WHAT INFO DO YOU WISH TO DISPLAY FOR FILE INFORMATION?', '', [0, 0, 0, 0, 0, 0, 0]],
	main_atk => ['eu_date_format',		'CHANGE DATE DISPLAY FORMAT TO EUROPEAN', 'Yes=DD/MM/YYYY, No=MM/DD/YYYY', 0],
	main_att => ['thumb_info_right',		'DO YOU WANT TO DISPLAY FILE INFORMATION TO THE RIGHT OF THE THUMBNAILS?', 'By default the info shows up below the thumbnails but if you have a lot of thumbnail captions then this might be better.', 0],
   main_au => ['display_counts',		'DO YOU WANT TO DISPLAY IMAGE COUNTS NEXT TO THE CATEGORY AND SUBCATEGORY NAMES?', '', 0],
	main_av => ['use_new_image',		'DO YOU WISH TO PLACE A "NEW" IMAGE NEXT TO A CATEGORY IF IT HAS BEEN MODIFIED IN THE PAST X NUMBER OF DAYS?', '', 0],
	main_aw => ['new_date',				'HOW MANY DAYS OLD IS CONSIDERED NEW?', 'See above. Specify a number in days. Requires rebuilding of the index for changes take effect', 2],
	main_aww => ['show_new_cats',		'DO YOU WISH TO SHOW NEW IMAGES OR NEW CATEGORIES WHEN USERS CLICK ON THE "NEW" ICON?', '', 0],
	main_ax => ['cache_date',			'HOW MANY DAYS DO YOU WANT TO KEEP CACHE FILES BEFORE THEY ARE AUTOMATICALLY DELETED AND REBUILT?', 'ImageFolio now caches search AND directory results.  This effectively speeds up searches and category listing by 200-300%. Please specify how long a cache file should be stored on your server. example:<br>1 = 1 day, 0.25 = 6 hours, 0.04 = 1 hour', 1],
	main_ay => ['alt_text',				'WHAT ALT TEXT WOULD YOU LIKE TO USE FOR THUMBNAIL IMAGES?', 'When the user moves his/her mouse over a thumbnail image, a text message can be displayed.  What message would you like that to be:', 4],

	main_ayy => ['use_textlinks',		'DO YOU WANT TO TO USE TEXTLINKS OR ICON LINKS FOR NAVIGATION IN YOUR GALLERY', '', 0],
	main_ayz => ['main_table_width',		'WHAT DO YOU WANT THE MAIN TABLE WIDTH OF IMAGEFOLIO SET TO', 'If you are modifying the templates to fit into a designated space or if you want to just change the width of ImageFolio, please enter the value either in pixels or percentage below.  If percentage, please use the % symbol at the end.', 4],
   
   main_az => ['auto_slideshow',		'DO YOU WANT TO USE THE AUTOMATED SLIDESHOW FEATURE?', '', 0],
	main_azz => ['ss_refresh',			'HOW OFTEN DO YOU WANT TO ROTATE YOUR SLIDESHOW IMAGES?', 'ImageFolio can act as an automated and/or manual slideshow on your full-size image pages.  The speed of the slideshow is determined by the number of seconds you define below.  If you want to use the slideshow you must place this tag %%%SLIDESHOW%%% after the </title> tag in your image.html template file.  If you do not want it, remove that same tag.', 2],
	main_ba => ['random_thumbnail',		'DO YOU WANT IMAGEFOLIO TO DISPLAY A RANDOM THUMBNAIL IMAGE NEXT TO EACH CATEGORY NAME, ON BOTH THE HOME PAGE AND SUBCATEGORY THUMBNAIL PAGES?', 'This will illustrate the category with a random thumbnail from within that directory.  Note:  Performance may be slow if you typically put more than 100 files in any single category.  Works best on smaller galleries.', 0],
	main_bb => [['display_new', 'display_random', 'display_top_hits', 'display_top_rates'],
										'DO YOU WANT TO USE THE NEW, RANDOM, TOP HITS AND TOP RATES BUTTONS IN YOUR GALLERY?', '', [0, 0, 0, 0]],
	main_bc => [['show_similar_link', 'clickable_search_words'],
										'DISPLAYING OF SEARCH WORDS ON THE IMAGE PAGE', 'The search/keywords are by default displayed on the image page. These search words are linked to new searches so customers can easy find similar images. Do you want these words linked to new searches?<p>These search words can also be linked to a "Show similar Images" link. Clicking this link will do an "OR" search with all the keywords.', [0, 0]],
	main_bd => ['search_exact_only',	'KEYWORD SEARCH ACCURACY?', 'If a user searches for "men" do you only want to return images that contain "men" and not "women" in the keywords? At the same time, if you have turned this on then ImageFolio will only search in the keywords. Matches in file and category names will be ignored!', 0],
	main_bda => ['ignore_keywords',	'IGNORE SEARCH KEYWORD?', 'This provides a list with keywords that will not be added to the search database.', 0],
   main_be => ['show_unique_only',		'SHOW UNIQUE IMAGES ONLY?', 'If the same image (based on name) is found in multiple categories do you want all those images to show or not. If you set this to "no" then only one of those imagse will show up!', 0],
#	main_bf => ['two_step_indexing',	'BUILDING OF THE DATEBASE IN HOW MANY STEPS?', 'By default the reindexing of the database happens in one step. If you are experiencing problems because it takes to long and your browser times out set "two_step_indexing" to "yes".', 0],
	main_bfa => ['keyword_threshold',	'BUILDING OF THE COMMON KEYWORD LIST?', 'How many times should a keyword be found before it is place in the common keyword list? Set this to "0" to disable the feature.', 1],
   main_bg => ['image_editor',			'IMAGE EDITOR?', 'Which image editor do you want to use for thumbnailing, watermarking, rotating?. This can be either "ic" (ImageConvert) or "im" (ImageMagick). Default = "ic".', 4],
	main_bh => ['user_sorting_choices',		'USER SORTING OPTIONS', 'Do you want to allow your vistors to sort the images with these options?', 0],
	main_bi => ['user_row_choices',			'USER THUMBNAIL ROWS','How many rows can the user choose from to display the thumbnail pages. Example choices 2, 3, 4', 0],
	main_bj => ['user_skin_choices',		'USER SKIN CHOICES', 'Which ImageFolio skins can the user choose from? Users will be able to choose from these skins to browse your site in the look that they prefer.', 0],
	main_bjj => ['thumb_info_layout',		'USER THUMBNAIL DISPLAY CHOICES', 'Do you want to give users the option to choose themselves if they want to see the thumbnail info below or to the right of the thumbnail?', 0],
	main_bjk => ['nav_switching',		'USER NAVIGATION TYPE CHOICES', 'Do you want to give users the option to choose themselves if they want to use icon or text links for navigation?', 0],
   main_bk => ['IPTCfields',				'WHAT IPTC TAGS DO YOU WANT TO USE?', '', 0],
   main_bkk => ['parse_single_iptc_fields',	'PARSE EACH IPTC FIELD INDIVIDUALLY', 'ImageFolio will by default create a nice looking table with all your IPTC field/values on your image.html template. However, if you set this to "Yes" then you can access each IPTC value individually. Examples:<br><li>To show your IPTC caption add %%%IPTC_CAPTION/ABSTRACT%%% to your image.html template.</li><li>To show your IPTC keywords add %%%IPTC_KEYWORDS%%% to your image.html template.</li><br>This is the rule for adding any of the IPTC tags: <b>%%%IPTC_</b> + uppercase "Type" + <b>%%%</b>', 0],
	main_bl => ['iptc_thumbnails_fields',	'WHAT IPTC TAGS DO YOU WANT TO USE ON YOUR THUMBNAIL PAGES?', '', 0],
	main_bll => ['iptc_thumbnails_popup_fields',	'WHAT IPTC TAGS DO YOU WANT TO USE AS MOUSE_OVER POPUPS ON YOUR THUMBNAIL PAGES?', '', 0],
	main_bm => ['save_upload_date', 		'USE UPLOAD DATE OR MODIFICATION DATE?', 'ImageFolio uses the creation date of a file as the "Upload Date". When you modify an IPTC caption the image will be recreated and so the "Upload Date" is reset. If you don\'t want this to happen set "save_upload_date" to "yes" and the the original upload date will be stored and used instead.', 0],
	main_bn => ['imageprotect',				'DO YOU WANT TO PROTECT YOUR PREVIEW IMAGES?', 'If you enable image protection the following methods are used to protect your image: Save pixel.gif image instead of preview image. Disable IE 6 ImageToolbar for direct downloading printing images Print Page protection. A blank page will be printed instead.', 0],
	main_bo => ['antileech',				'DO YOU WANT TO HIDE THE LINKS TO ALL OF YOUR THUMBNAILS AND IMAGES?', 'The following setting will take some more preventive steps to discourage your visitors from stealing your images. If set to "yes" ImageFolio will hide the URL to your images and people will not be able to find out where your images are located on your server by looking at the source code of that page. Even if the try to link to your images from their website by copy and pasting the URL to imageLeech.cgi, they will get a "403 Forbidden Access" image. Note that this does not prevent them from saving the image the other ways and uploading it to their own webserver.', 0],
	main_bp => ['gallery_root',				'WHAT IS THE NAME OF YOUR GALLERY ROOT DIRECTORY?', 'If you have the anti leech enabled we strongly recommend you rename the "gallery" directory (the one that sits in you "ImageFolio4_files" directory) to something that is hard to guess like "my_root_gallery" or "place_were_my_images_go". When you have done that also make the name change here. DEFAULT = "gallery"', 4],
	main_bq => ['watermark',				'WATERMARKING YOU IMAGES WITH A LOGO.', 'The best way to discourage users from stealing your images is to watermark them. Visitors can still save your images, but since they display your visible watermark it is evident that the image is not theirs. You can use programs like Photoshop for watermarking or if you have ImageMagick or ImageConvert installed on your server then ImageFolio can do it for you.', 0],
	main_br => ['overlay_image', 			'WHICH IMAGE DO YOU WANT TO USE FOR WATERMARKING?', 'We suggest you use a png image with opacity of 50% and a transparent background (Alpha channel). This will create the cleanest look. We can help you creating this perfect watermark for a small cost. The overlay image is located in your "$image_directory" directory.', 4],
	main_bs => ['watermark_cache',			'CACHING THE WATERMARKED IMAGES.', 'The image watermarking will be done "on-the-fly". This asks for certain processing time and resources. If you want to eliminate this as much as possible you can choose to have the already watermarked images stored in a cache. This is much more efficient but will ask more disk-space (only the fullsize images will be watermarked). If you set it to "no" then the images won\'t be cached at all and the cache directory get cleared (good if you have limited disk-space).', 0],
	main_bt => [['WaterMarkQuality', 'gravity'],
											'HOW DOES THE OVERLAY IMAGE NEED TO BE APPLIED TO YOU STORE IMAGES TO CREATE THE WATERMARKED IMAGE?', 'WaterMarkQuality is the jpg quality in percent.<p>gravity specifies where the watermark be placed on the image: North, NorthEast, NorthWest, South, SouthEast, SouthWest, East, West, or Center.', [2, 4]],
	main_bu => [['download_log', 'search_log', 'postcard_log', 'imageconvert_log'],
											'LOG CONFIGURATION', 'ImageFolio keeps various logs. Logs will only be created by actions of your users. If you are logged in as an administrator no logs will be updated to keep the logs "clean". Logs are written as a plain text file TAB delimited. You can give it any name here to prevent users from downloading your logs. PLEASE CHANGE THE NAMES!!!', [3, 3, 3, 3]],
	main_bv => [['if2_search', 'if2_caption', 'if2_thumbcaption'],
											'DID YOU UPGRADE FROM IMAGEFOLIO 2.x AND YOU WANT TO KEEP AND USE THE OLD DATABASE?', 'Please specify if you want to keep on using the old database system.', [0, 0, 0]],
	main_bw => ['pw_encryption',		'DO YOU WANT TO ENCRYPT PASSWORDS ON YOUR SERVER?', 'We suggest you set this to "yes" unless you are sure your server is secure and your user and admin databases are not accesible through the browser.', 0],
);

my $error_display;

sub skin_name_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'skin_name') {
		$skin_name = '';
	
		my $choice = $FORM{'skin_name'};
		
#		my $skins_dir = $base_if_path . "/skins";
      my $skins_dir = $base_skin_dir;

		opendir(SKINS, $skins_dir);
		my @skins = grep !/^\./, readdir SKINS;
		closedir(SKINS);

		foreach my $skin(@skins) {
			my $skin_dir = $skins_dir . '/' . $skin;
	
			next unless -e $skin_dir . '/config_skin.pl';
				
			if ($choice eq $skin) {
				$skin_name = $choice;
				
				last;
			}
		}
	}

	if ($skin_name eq '' || !$skin_name) {
		$error_display = 'You must choose a valid skin name from your skins directory!';
		
		return;
	}
	
	my $write = '$skin_name = \'' . $skin_name .  '\';' . "\n";
		
	return($write);
}

sub skin_name_edit {
#	my $skins_dir = $base_if_path . "/skins";
   my $skins_dir = $base_skin_dir;

	opendir(SKINS, $skins_dir);
	my @skins = grep !/^\./, readdir SKINS;
	closedir(SKINS);

	my $options;
	
	foreach my $skin(sort(@skins)) {
		my $skin_dir = $skins_dir . '/' . $skin;
	
		next unless -e $skin_dir . '/config_skin.pl';
	
		my $selected = '';
		
		$selected = ' selected' if $skin eq $skin_name;
		
		$options .= qq{<option value="$skin"$selected>$skin</option>};
	}

	my $display .= qq{
  <table border=0 cellspacing=1 cellpadding=5 width="400" bgcolor="#000000" align="center">
	<tr>
	  <td bgcolor="#dddddd" align=center>
	    <font face="Verdana,Arial,Helvetica" size="1"><b>skin_name</b></font></td>
	  </td>
	  <td bgcolor="#ffffff" align=center valign=top>
	    <select name="skin_name">
	    $options
	    </select>
	  </td>
	</tr>
  </table>
  	};
	
	return($display);	
}


sub cat_columns_edit {
	my $options;
	
	for (my $i = 1; $i < 4; $i++) {	
		my $selected = '';
		  
		$selected = ' selected' if $i == $cat_columns;
		
		$options .= qq{<option value="$i"$selected>$i</option>};
	}

	my $display .= qq{
  <table border=0 cellspacing=1 cellpadding=5 width="400" bgcolor="#000000" align="center">
	<tr>
	  <td bgcolor="#dddddd" align=center>
	    <font face="Verdana,Arial,Helvetica" size="1"><b>cat_columns</b></font></td>
	  </td>
	  <td bgcolor="#ffffff" align=center valign=top>
	    <select name="cat_columns">
	    $options
	    </select>
	  </td>
	</tr>
  </table>
  	};
	
	return($display);	
}

sub sortfiles_menu {
	my $display = qq{<table border=0 cellspacing=1 cellpadding=2 width="400" bgcolor="#000000" align="center">};

	my @choices = (0, 'By Date', 'Alphabetically', 'By Hits', 'By Rates', 'Random');

	my $name = $choices[$sortfiles];

	$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=middle width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>sortfiles</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$name</font></td></tr>};

	$display .= '</table>';
	
	return($display);
}

sub sortfiles_edit {
	my $options;
	
	my @choices = (0, 'By Date', 'Alphabetically', 'By Hits', 'By Rates', 'Random');
	
	for (my $i = 1; $i < 6; $i++) {	
		my $selected = '';
		  
		$selected = ' selected' if $i == $sortfiles;
		
		my $name = $choices[$i];
		
		$options .= qq{<option value="$i"$selected>$name</option>};
	}

	my $display .= qq{
  <table border=0 cellspacing=1 cellpadding=5 width="400" bgcolor="#000000" align="center">
	<tr>
	  <td bgcolor="#dddddd" align=center>
	    <font face="Verdana,Arial,Helvetica" size="1"><b>sortfiles</b></font></td>
	  </td>
	  <td bgcolor="#ffffff" align=center valign=top>
	    <select name="sortfiles">
	    $options
	    </select>
	  </td>
	</tr>
  </table>
  	};
	
	return($display);	
}

sub user_row_choices_menu {
	my $display = qq{<table border=0 cellspacing=1 cellpadding=2 width="400" bgcolor="#000000" align="center">};

	if (@user_row_choices) {
		my $fields = join(', ', @user_row_choices);
			
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=middle width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>user_row_choices</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$fields</font></td></tr>};
	} else {
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>user_row_choices</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><font color=red>DISABLED</font></font></td></tr>};
	}
	
	$display .= '</table>';
	
	return($display);
}

sub user_row_choices_edit {
	my $choices = join(', ', @user_row_choices);

	my $display .= qq{
  <table border=0 cellspacing=1 cellpadding=5 width="400" bgcolor="#000000" align="center">
	<tr>
	  <td bgcolor="#dddddd" align=center valign=middle width="50%">
	    <font face="Verdana,Arial,Helvetica" size="1"><b>user_row_choices</b></font></td>
	  </td>
	  <td bgcolor="#ffffff" align=center valign=top>
	    <input type="text" name="user_row_choices" value="$choices" size=30>
	  </td>
	</tr>
  </table>
  	};
	
	return($display);
}

sub user_row_choices_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'user_row_choices') {
		@user_row_choices = ();
	
		my $choices = $FORM{'user_row_choices'};
		
		$choices =~ s/\s+//g;
		
		return('@user_row_choices = ();' . "\n") if !$choices;

		my @choices = split(',', $choices);
		
		my %choices;
				
		foreach my $choice(@choices) {
			$choice += 0;
			
			if ($choice > 0) {
				$choices{$choice} = 1;
			}
		}
		
		@user_row_choices = sort(keys(%choices));
	}
	
	return('@user_row_choices = ();' . "\n") if !@user_row_choices;

   foreach my $user_row_choice (@user_row_choices) {
      push (@sort_user_row_choices, sprintf("%03d", $user_row_choice));
   }
   @user_row_choices = ();
   @sort_user_row_choices = sort { $a <=> $b } @sort_user_row_choices;

   foreach my $sort_user_row_choices (@sort_user_row_choices) {
      push (@user_row_choices, int($sort_user_row_choices));
   }

	
	my $write = '@user_row_choices = (' . join(", ", @user_row_choices) . ');' . "\n";
		
	return($write);
}

sub user_skin_choices_menu {
	my $display = qq{<table border=0 cellspacing=1 cellpadding=2 width="400" bgcolor="#000000" align="center">};

	if (@user_skin_choices) {
		my $fields = join(', ', @user_skin_choices);
			
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=middle width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>user_skin_choices</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$fields</font></td></tr>};
	} else {
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>user_skin_choices</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><font color=red>DISABLED</font></font></td></tr>};
	}
	
	$display .= '</table>';
	
	return($display);
}

sub user_skin_choices_edit {
#	my $skins_dir = $base_if_path . "/skins";
   my $skins_dir = $base_skin_dir;

	opendir(SKINS, $skins_dir);
	my @skins = grep !/^\./, readdir SKINS;
	closedir(SKINS);

	my $options;
	
	foreach my $skin(sort(@skins)) {
		my $skin_dir = $skins_dir . '/' . $skin;
	
		next unless -e $skin_dir . '/config_skin.pl';
	
		my $selected = '';
		
		foreach my $choice(@user_skin_choices) {
			if ($choice eq $skin) {
				$selected = ' selected';
				
				last;
			}
		}
		
		$options .= qq{<option value="$skin"$selected>$skin</option>};
	}

	my $display .= qq{
  <table border=0 cellspacing=1 cellpadding=5 width="400" bgcolor="#000000" align="center">
	<tr>
	  <td bgcolor="#dddddd" align=center valign=top>
	    <font face="Verdana,Arial,Helvetica" size="1"><b>user_skin_choices</b></font></td>
	  </td>
	</tr>
	<tr>
	  <td bgcolor="#ffffff" align=center valign=top>
	    <select name="user_skin_choices" size="6" multiple>
	    $options
	    </select>
	  </td>
	</tr>
  </table>
  	};
	
	return($display);	
	
}

sub user_skin_choices_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'user_skin_choices') {
		@user_skin_choices = ();
	
		my $choices = $FORM{'user_skin_choices'};
		
		return('@user_skin_choices = ();' . "\n") if !$choices;

		my @choices = split(',', $choices);
		
		
#		my $skins_dir = $base_if_path . "/skins";
      my $skins_dir = $base_skin_dir;

		opendir(SKINS, $skins_dir);
		my @skins = grep !/^\./, readdir SKINS;
		closedir(SKINS);

		foreach my $choice(@choices) {
			foreach my $skin(@skins) {
				my $skin_dir = $skins_dir . '/' . $skin;
	
				next unless -e $skin_dir . '/config_skin.pl';
				
				if ($choice eq $skin) {
					push(@user_skin_choices, $choice);
					
					last;
				}
			}
		}
	}

	return('@user_skin_choices = ();' . "\n") if !@user_skin_choices;
	
	my $write = '@user_skin_choices = (' . "'" . join("', '", @user_skin_choices) . "'" .  ');' . "\n";
		
	return($write);
}

sub iptc_thumbnails_fields_menu {
	my $display = qq{<table border=0 cellspacing=1 cellpadding=2 width="400" bgcolor="#000000" align="center">};

	if (@iptc_thumbnails_fields) {
		my $fields = join(', ', @iptc_thumbnails_fields);
			
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=middle width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>iptc_thumbnails_fields</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$fields</font></td></tr>};
	} else {
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>iptc_thumbnails_fields</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><font color=red>DISABLED</font></font></td></tr>};
	}
	
	$display .= '</table>';
	
	return($display);
}

sub iptc_thumbnails_popup_fields_menu {
	my $display = qq{<table border=0 cellspacing=1 cellpadding=2 width="400" bgcolor="#000000" align="center">};

	if (@iptc_thumbnails_popup_fields) {
		my $fields = join(', ', @iptc_thumbnails_popup_fields);
			
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=middle width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>iptc_thumbnails_popup_fields</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$fields</font></td></tr>};
	} else {
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>iptc_thumbnails_popup_fields</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><font color=red>DISABLED</font></font></td></tr>};
	}
	
	$display .= '</table>';
	
	return($display);
}

sub ignore_keywords_menu {
	my $display = qq{<table border=0 cellspacing=1 cellpadding=2 width="400" bgcolor="#000000" align="center">};

	if (@ignore_keywords) {
		my $fields = join(', ', @ignore_keywords);
			
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=middle width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>ignore_keywords</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$fields</font></td></tr>};
	} else {
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>ignore_keywords</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><font color=red>DISABLED</font></font></td></tr>};
	}
	
	$display .= '</table>';
	
	return($display);
}

sub iptc_thumbnails_fields_edit {
	my %codes = (%default_IPTCfields, %IPTCfields);
	
	my $options;
   my $do_none = ' selected';
	
	foreach my $code(sort(keys(%codes))) {
		my $type = $codes{$code}->[1];
		
		my $selected = '';
		
		foreach my $field(@iptc_thumbnails_fields) {
			if ($field eq $type) {
				$selected = ' selected';
				
				last;
			}
		}
      $do_none = () if $selected;
		
		$options .= qq{<option value="$code"$selected>$type</option>};
	}

	my $display .= qq{
  <table border=0 cellspacing=1 cellpadding=5 width="400" bgcolor="#000000" align="center">
	<tr>
	  <td bgcolor="#dddddd" align=center valign=top>
	    <font face="Verdana,Arial,Helvetica" size="1"><b>iptc_thumbnails_fields</b></font></td>
	  </td>
	</tr>
	<tr>
	  <td bgcolor="#ffffff" align=center valign=top>
	    <select name="iptc_thumbnails_fields" size="10" multiple>
        <option value=""$do_none>NONE</option>
	    $options
	    </select>
	  </td>
	</tr>
  </table>
  	};
	
	return($display);
}

sub iptc_thumbnails_popup_fields_edit {
	my %codes = (%default_IPTCfields, %IPTCfields);
	
	my $options;
   my $do_none = ' selected';
	
	foreach my $code(sort(keys(%codes))) {
		my $type = $codes{$code}->[1];
		
		my $selected = '';
		
		foreach my $field(@iptc_thumbnails_popup_fields) {
			if ($field eq $type) {
				$selected = ' selected';
				
				last;
			}
		}
      $do_none = () if $selected;
		
		$options .= qq{<option value="$code"$selected>$type</option>};
	}

	my $display .= qq{
  <table border=0 cellspacing=1 cellpadding=5 width="400" bgcolor="#000000" align="center">
	<tr>
	  <td bgcolor="#dddddd" align=center valign=top>
	    <font face="Verdana,Arial,Helvetica" size="1"><b>iptc_thumbnails_popup_fields</b></font></td>
	  </td>
	</tr>
	<tr>
	  <td bgcolor="#ffffff" align=center valign=top>
	    <select name="iptc_thumbnails_popup_fields" size="10" multiple>
        <option value=""$do_none>NONE</option>
	    $options
	    </select>
	  </td>
	</tr>
  </table>
  	};
	
	return($display);
}

sub ignore_keywords_edit {

   my $fields = join("\n", @ignore_keywords);

	my $display .= qq{
  <table border=0 cellspacing=1 cellpadding=5 width="400" bgcolor="#000000" align="center">
	<tr>
	  <td bgcolor="#dddddd" align=center valign=top>
	    <font face="Verdana,Arial,Helvetica" size="1"><b>ignore_keywords</b></font></td>
	  </td>
	</tr>
	<tr>
	  <td bgcolor="#ffffff" align=center valign=top>
	    <textarea name="ignore_keywords" rows="25" style="width: 100%;">$fields</textarea>
	  </td>
	</tr>
  </table>
  	};
	
	return($display);
}

sub iptc_thumbnails_fields_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'iptc_thumbnails_fields') {
		@iptc_thumbnails_fields = ();
	
		my $fields = $FORM{'iptc_thumbnails_fields'};
		
		return('@iptc_thumbnails_fields = ();' . "\n") if !$fields;
		
#		print "Content-type: text/plain\n\n$fields\n";

		my @fields = split(',', $fields);
		
		my %codes = (%default_IPTCfields, %IPTCfields);

		foreach my $field(@fields) {
			foreach my $code(sort(keys(%codes))) {
				my $type = $codes{$code}->[1];
			
				if ($code eq $field) {
					push(@iptc_thumbnails_fields, $type);
					
					last;
				}
			}
		}
		
	}
	
	return('@iptc_thumbnails_fields = ();' . "\n") if !@iptc_thumbnails_fields;
	
	my $write = '@iptc_thumbnails_fields = (' . "'" . join("', '", @iptc_thumbnails_fields) . "'" .  ');' . "\n";
		
	return($write);	
}

sub iptc_thumbnails_popup_fields_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'iptc_thumbnails_popup_fields') {
		@iptc_thumbnails_popup_fields = ();
	
		my $fields = $FORM{'iptc_thumbnails_popup_fields'};
		
		return('@iptc_thumbnails_popup_fields = ();' . "\n") if !$fields;
		
#		print "Content-type: text/plain\n\n$fields\n";

		my @fields = split(',', $fields);
		
		my %codes = (%default_IPTCfields, %IPTCfields);

		foreach my $field(@fields) {
			foreach my $code(sort(keys(%codes))) {
				my $type = $codes{$code}->[1];
			
				if ($code eq $field) {
					push(@iptc_thumbnails_popup_fields, $type);
					
					last;
				}
			}
		}
		
	}
	
	return('@iptc_thumbnails_popup_fields = ();' . "\n") if !@iptc_thumbnails_popup_fields;
	
	my $write = '@iptc_thumbnails_popup_fields = (' . "'" . join("', '", @iptc_thumbnails_popup_fields) . "'" .  ');' . "\n";
		
	return($write);	
}

sub ignore_keywords_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'ignore_keywords') {
		@ignore_keywords = ();
	
		my $fields = $FORM{'ignore_keywords'};
		
		return('@ignore_keywords = ();' . "\n") if !$fields;
		
#		print "Content-type: text/plain\n\n$fields\n";


      $fields =~ s/\n/ /g;
      $fields =~ s/\r/ /g;
      $fields =~ s/\,/ /g;
      $fields =~ s/\;/ /g;
      $fields =~ s/\'//g;

		my @fields = split(' ', $fields);
		
		foreach my $field(@fields) {
         next unless $field;
         push(@ignore_keywords, $field);
		}
		
	}
	
	return('@ignore_keywords = ();' . "\n") if !@ignore_keywords;
	
	my $write = '@ignore_keywords = (' . "'" . join("', '", @ignore_keywords) . "'" .  ');' . "\n";
		
	return($write);	
}

sub user_sorting_choices_menu {
	my $display = qq{<table border=0 cellspacing=1 cellpadding=2 width="400" bgcolor="#000000" align="center">};

	if (@user_sorting_choices) {
		my ($date, $name, $hits, $rates, $random) = @user_sorting_choices;
		
		$date = $date ? 'yes' : 'no';
		$name = $name ? 'yes' : 'no';
		$hits = $hits ? 'yes' : 'no';
		$rates = $rates ? 'yes' : 'no';
		$random = $random ? 'yes' : 'no';
		
		$display .= qq{
<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>By Date</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$date</font></td></tr>
<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>By Name</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$name</font></td></tr>
<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>By Hits</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$hits</font></td></tr>
<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>By Rates</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$rates</font></td></tr>
<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>By Random</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$random</font></td></tr>
		};
	} else {
		$display .= qq{<tr><td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>user_sorting_choices</b></font></td><td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><font color=red>DISABLED</font></font></td></tr>};
	}
	
	$display .= '</table>';
}

sub user_sorting_choices_edit {
	my $display = qq{<table border=0 cellspacing=1 cellpadding=5 width="500" bgcolor="#000000" align="center">};
	
	my @sorts = (0, 0, 0, 0, 0);
	
	@sorts = @user_sorting_choices if @user_sorting_choices;

	my @names = ('By Date', 'By Name', 'By Hits', 'By Rates', 'By Random');

	for (my $i = 0; $i < @sorts; $i++) {
		my $sort = $sorts[$i];
		my $name = $names[$i];

		my $yes_checked = $sort ? ' checked' : '';
		my $no_checked = $sort ? '' : ' checked';

		$display .= qq{
	                 <tr> 
	                   <td bgcolor="#dddddd" align=center width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>$name</b></font></td>
	                   <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><input type="radio" name="$name" value="1"$yes_checked>yes &nbsp; &nbsp; <input type="radio" name="$name" value="0"$no_checked>no</font></td>
	                 </tr>
		};
	}	

	$display .= '</table>';
	
	return($display);	
}

sub user_sorting_choices_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'user_sorting_choices') {
		my $date	= $FORM{'By Date'} ? 1 : 0;
		my $name	= $FORM{'By Name'} ? 1 : 0;
		my $hits	= $FORM{'By Hits'} ? 1 : 0;
		my $rates	= $FORM{'By Rates'} ? 1 : 0;
		my $random	= $FORM{'By Random'} ? 1 : 0;
		
		my $total = $date + $name + $hits + $rates + $random;
		
		if ($total) {
			@user_sorting_choices = ($date, $name, $hits, $rates, $random);
		} else {
			@user_sorting_choices = ();
			
			return('@user_sorting_choices = ();' . "\n");
		}
	}
	
	return('@user_sorting_choices = (' . join(', ', @user_sorting_choices) . ');' . "\n");
}

sub more_validation {
	my ($param, $value) = @_;
	
	if ($param eq 'cat_columns' && $value != 1 && $value != 2 && $value != 3) {
		$error_display = 'The only valid settings for cat_columns are 1, 2, or 3';
	} elsif ($param eq 'image_editor' && $value ne 'im' && $value ne 'ic') {
		$error_display = 'The only valid settings for image_editor are <b>im</b> or <b>ic</b>';
	} elsif ($param eq 'gravity' && $value ne 'North' && $value ne 'NorthEast' && $value ne 'NorthWest' && $value ne 'South' && $value ne 'SouthEast' && $value ne 'SouthWest' && $value ne 'East' && $value ne 'West' && $value ne 'Center') {	
		$error_display = 'The only valid settings for gravity are North, NorthEast, NorthWest, South, SouthEast, SouthWest, East, West, or Center';
	} elsif ($param eq 'sortfiles' && $value != 1 && $value != 2 && $value != 3 && $value != 4 && $value != 5) {
		$error_display = 'The only valid settings for sortfiles are 1, 2, 3, 4, or 5';
	}
}

sub update {
	my $section = $FORM{'section'};
	
	return if !$configs{$section};
	
	my $write = '';
	
	foreach my $key(sort(keys(%configs))) {
		my $config = $configs{$key};
		
		my ($params, $question, $info, $field_types) = @{$config};
		
		my $type = ref($params);
		
		$type = 'sub' if defined(&{$params . '_write'});
		
		$params = [$params] if !$type;
		
		$field_types = [$field_types] if !$type;
		
		if ($type eq 'sub') {
			$write .= &{$params . '_write'};
			
			return if $error_display;
		} else {
			my $field = 0;
		
			foreach my $param(@{$params}) {
				my $value = eval('$' . $param);
				
				my $field_type = $field_types->[$field];
				
				if ($key eq $section) {
					$value = $FORM{$param};
					
					if ($param eq 'myextension_fullsize' && lc($value) eq 'zip' && $use_fullsize) {
						my $compress_zlib = 0;
						
						eval "use Compress::Zlib";
						
						if ($@) {
							$error_display = 'You must have Compress::Zlib installed before you set myextension_fullsize to "zip"!';
								
							return;
						}
					}
															
					eval('$' . $param . '=' . "'" . $value . "'");
					
					if ($field_type < 3) { # if numeric field
						$value = $value + 0; # force value to a number
						
						if ($field_type == 0) {
							$value = $value ? 1 : 0; # if it's a boolean, go ahead and make it a one or zero
						} elsif ($field_type == 2) {
							# must be greater than 0, throw an error if it's not
							if ($value <= 0) {
								$error_display = "You must enter a positive number for $param!";
								
								return;
							}
						}
					} else { # if alpha field
						$value =~ s/^\s+//g;              # Trim leading blanks...
						$value =~ s/\s+$//g;              # Trim trailing blanks...
						$value =~ s/\s+\s+/ /g;           # Change two spaces to one.
					
						if ($field_type == 4 && ($value eq '' || !$value)) { 
							# throw error if null string
							
							$error_display = "$param cannot be empty!";
								
							return;
						}
					}
					
					eval('$' . $param . '=' . "'" . $value . "'");
					
					&more_validation($param, $value);
					
					return if $error_display;
				}
				
				$write .= "\$$param = '$value';\n";
				
				$field++;
			} 
		}
	}
   unless ($admin_demo_mode) {
      open(CONFIG, ">$data_directory/config/main.pl");
      flock(CONFIG, 2) if $useflock;
      print CONFIG "$write\n1;";
      flock(CONFIG, 8) if $useflock;
      close(CONIG);
      chmod(0777, "$data_directory/config/main.pl");
   }
}	

sub edit {
	my $section = $FORM{'section'};

	return if !$configs{$section};

	&get_header;

	print qq{
<center>
<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">
  <tr>
    <td>
      <table border="0" width="100%" cellspacing=1 cellpadding=0>
        <tr bgcolor="#ffcc00">
          <td>
            <table border="0" width="100%" cellspacing=0 cellpadding=4>
              <tr>
                <td><$admin_big_font><b>ImageFolio Configuration Editor</b></font></td>
                <td align=right><$admin_big_font><b>Edit</b></font></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr bgcolor="#ffffff">
          <td valign=top>
            <table border=0 cellspacing=1 cellpadding=5 width="100%">
	};
	
	my $config = $configs{$section};
		
	my ($params, $question, $info, $field_types) = @{$config};
		
	my $type = ref($params);
		
	$type = 'sub' if defined(&{$params . '_edit'});
		
	$params = [$params] if !$type;
	
	$field_types = [$field_types] if !$type;
				
	my $section = qq{
              <tr bgcolor="#eeeeee">
                <td bgcolor="#eeeeee" align=left>
                  <$admin_font><b>$question</b></font><br>
                  <$admin_font>$info<br></font><br>
                  <center><$admin_font color=red>$error_display</font></center>
                  <form method="post" action="$adminurl#$section">
                  <input type="hidden" name="admin" value="admin">
                  <input type="hidden" name="cgi" value="config_editor.pl">
                  <input type="hidden" name="section" value="$section">
                  <input type="hidden" name="uid" value="$FORM{'uid'}">
 	};
		
	if ($type eq 'sub') {
		$section .= &{$params . '_edit'};
	} else {
		$section .= qq{<table border=0 cellspacing=1 cellpadding=5 width="500" bgcolor="#000000" align="center">};
		
		my $field = 0;

		foreach my $param(@{$params}) {
			my $value = eval('$' . $param);
			
			my $field_type = $field_types->[$field];
			
			my $input = qq{<input type="text" name="$param" value="$value" size=30>};
			
			if ($field_type == 0) {
				my $yes_checked = $value ? ' checked' : '';
				
				my $no_checked = $value ? '' : ' checked';
				
				$input = qq{<input type="radio" name="$param" value="1"$yes_checked>yes &nbsp; &nbsp; <input type="radio" name="$param" value="0"$no_checked>no};
			}
					
			$section .= qq{
	                 <tr> 
	                   <td bgcolor="#dddddd" align=center width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>$param</b></font></td>
	                   <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$input</font></td>
	                 </tr>
			};
			
			$field++;
		}
			
		$section .= qq{</table>};
	}
		
	$section .= qq{<br><center><input type="submit" name="update" value="Update Configuration"> &nbsp; <input type="submit" name="cancel" value="Cancel"></form></center>
	                </td>
	              </tr>
	};

	print $section;
             
	print qq{
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
	};

	&get_footer;
	
	exit;
}

sub menu {
	$pagetitle = "Configuration Editor";
	
	my $error = &update if $FORM{'section'} && $FORM{'update'};

	&edit if $FORM{'section'} && ($FORM{'edit'} || $error_display);

	&get_header;
	

   $imagefolio_header_html =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $imagefolio_header_html =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $imagefolio_header_html =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $imagefolio_header_html =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $imagefolio_header_html =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;
   $imagefolio_header_html =~ s/%%%MAIN_TABLE_WIDTH%%%/100\%/ig;
   $imagefolio_footer_html =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $imagefolio_footer_html =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $imagefolio_footer_html =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $imagefolio_footer_html =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $imagefolio_footer_html =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;
   $imagefolio_footer_html =~ s/%%%MAIN_TABLE_WIDTH%%%/100\%/ig;

	print qq{
<center>
<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">
  <tr>
    <td>
      <table border="0" width="100%" cellspacing=1 cellpadding=0>
        <tr bgcolor="#ffcc00">
          <td>
            <table border="0" width="100%" cellspacing=0 cellpadding=4>
              <tr>
                <td><$admin_big_font><b>ImageFolio Configuration Editor</b></font></td>
                <td align=right><$admin_big_font><b>Menu</b></font></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr bgcolor="#ffffff">
          <td valign=top>
            <table border=0 cellspacing=1 cellpadding=15 width="100%">
              <tr bgcolor="#eeeeee">
                <td bgcolor="#eeeeee">
                  <table border=0 cellspacing=0 cellpadding=0 width="100%">
                    <tr>
                      <td align=left>
                        <a name="header">
                        <font face="Verdana,Arial,Helvetica" size="2"><A HREF="$adminurl&cgi=headerfooter.pl&section=header&uid=$FORM{'uid'}" class="roll2"><b>THE HTML CODE FOR THE HEADER THAT WILL BE ADDED TO ALL THE TEMPLATES</b><img src="$skin_url/images/edit.gif" align=right border=0 vspace=3 hspace=3></a></font><br>
                      </td>
                    </tr>
                    <tr>
                      <td align=center>
                        <br>
                        <table cellpadding=10 cellspacing=0 border=0 bgcolor="$body_bgcolor" align="center" width="100%">
                          <tr>
                            <td>
                              $imagefolio_header_html
                            </td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr bgcolor="#eeeeee">
                <td bgcolor="#eeeeee">
                  <table border=0 cellspacing=0 cellpadding=0 width="100%">
                    <tr>
                      <td align=left>
                        <a name="footer">
                        <font face="Verdana,Arial,Helvetica" size="2"><A HREF="$adminurl&cgi=headerfooter.pl&section=footer&uid=$FORM{'uid'}" class="roll2"><b>THE HTML CODE FOR THE FOOTER THAT WILL BE ADDED TO ALL THE TEMPLATES</b><img src="$skin_url/images/edit.gif" align=right border=0 vspace=3 hspace=3></a></font><br>
                      </td>
                    </tr>
                    <tr>
                      <td align=center>
                        <br>
                        <table cellpadding=10 cellspacing=0 border=0 bgcolor="$body_bgcolor" align="center" width="100%">
                          <tr>
                            <td>
                              $imagefolio_footer_html
                            </td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
	};
	
	foreach my $key(sort(keys(%configs))) {
		my $config = $configs{$key};
		
		my ($params, $question, $info, $field_types) = @{$config};
		
		my $type = ref($params);
		
		$type = 'sub' if defined(&{$params . '_menu'});
		
		$params = [$params] if !$type;
		
		$field_types = [$field_types] if !$type;
				
		my $section = qq{
              <tr bgcolor="#eeeeee">
                <td bgcolor="#eeeeee"><table border=0 cellspacing=0 cellpadding=0 width="100%"><tr><td align=left>
    		      <a name="$key">
                  <$admin_font><A HREF="$adminurl&cgi=config_editor.pl&section=$key&edit=yes&uid=$FORM{'uid'}" class="roll2"><b>$question</b><img src="$skin_url/images/edit.gif" align=right border=0 vspace=3 hspace=3></a></font><br>
                  <$admin_font>$info</font></td></tr><tr><td align=center>
 		};
		
		if ($type eq 'sub') {
			$section .= &{$params . '_menu'};
		} else {
			$section .= qq{<br><table border=0 cellspacing=1 cellpadding=2 width="400" bgcolor="#000000">};
			
			my $field = 0;

			foreach my $param(@{$params}) {
				my $value = eval('$' . $param);
				
				my $field_type = $field_types->[$field];
			
				$value = '<font color=red>DISABLED</font>' if !$value && $field_type == 3;
				
				if ($field_type == 0) {
					$value = $value ? 'yes' : 'no';
				}
		
				$section .= qq{
	                 <tr>
	                   <td bgcolor="#dddddd" align=center valign=top width="50%"><font face="Verdana,Arial,Helvetica" size="1"><b>$param</b></font></td>
	                   <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$value</font></td>
	                 </tr>
				};
				
				$field++;
			}
			
			$section .= qq{</table>};
		}
		
		$section .= qq{
	                </td></tr></table></td>
	              </tr>
		};

		print $section;
	}
              
	print qq{
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
	};

	&get_footer;
	
	exit;
}

sub extensions_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'extensions') {
		my %new_extensions;
	
		my %codes = (%default_extensions, %extensions);
	
		my @codes = reverse(sort(keys(%codes)));
		
		if ($FORM{'config_edit_new_extension_extension'}) {
			my $code = $FORM{'config_edit_new_extension_extension'};
			
			$FORM{$code . '_active'}	= 1;
			$FORM{$code . '_type'}		= $FORM{'config_edit_new_extension_type'};
			$FORM{$code . '_link'} 		= $FORM{'config_edit_new_extension_link'} + 0;
			$FORM{$code . '_tag'}		= $FORM{'config_edit_new_extension_tag'};
			$FORM{$code . '_target'}	= $FORM{'config_edit_new_extension_target'};
			$FORM{$code . '_icon'}		= $FORM{'config_edit_new_extension_icon'};
			
			@codes = (@codes, $code);
		}
		
		foreach my $code(@codes) {
			if ($FORM{$code . '_active'}) {
				my $extension	= $code;
				my $type		= $FORM{$code . '_type'};
				my $link		= $FORM{$code . '_link'} + 0;
				my $tag			= $FORM{$code . '_tag'};
				my $target		= $FORM{$code . '_target'};
				my $icon		= $FORM{$code . '_icon'};
				
				$extension =~ s/\s+//g;

				$type =~ s/^\s+//g;              # Trim leading blanks...
				$type =~ s/\s+$//g;              # Trim trailing blanks...
				$type =~ s/\s+\s+/ /g;           # Change two spaces to one.
				
				$link = $link ? 1 : 0;
				
				$tag =~ s/^\s+//g;              # Trim leading blanks...
				$tag =~ s/\s+$//g;              # Trim trailing blanks...
				$tag =~ s/\s+\s+/ /g;           # Change two spaces to one.


				$target = "_self" unless $target;
				$new_extensions{$extension} = [$type, $link, $tag, $target, $icon];
				
				if (!$extension) {
					$error_display = 'Extension cannot be blank!';
				} 
            elsif (!$type) {
					$error_display = "You must supply a <b>type</b> for the <b>$extension</b> extension!"
				} 
            elsif (!$icon) {
					$error_display = "You must supply an <b>icon</b> for the <b>$extension</b> extension!"
				}
			}
		}
		
		

		
		return if $error_display;
      %extensions = %new_extensions;
	}
	
	my $write = '';
		
	foreach my $key(sort(keys(%extensions))) {
		my ($type, $link, $tag, $target, $icon) = @{$extensions{$key}};
	
		$write .= "\n\t'$key' => ['$type', $link, '$tag', '$target', '$icon'],";
	}
	
	chop($write);
	
	$write = '%extensions = (' . $write . "\n" . ');' . "\n";

	return($write);
}

sub extensions_edit {
	my $extensions =  qq{
<table align=center>
  <tr>
    <td width=500>
<pre>
Explanation...
extension   - this is the file extension without the dot
type        - what you would like to call this type of file
link        - use HTML template (1) or link directly to file (0)
tag         - the name of the *.html file in your templates/media folder
              to use for displaying this file if link is set to '1'
target      - what is the target to use for your href tag
icon        - if no thumbnail is found, ImageFolio will substitute
              the thumbnail image with this file (stored in your
              'if_images/icons" directory)
              
*** NOTE ***
IF YOU DON'T WANT TO USE AN EXTENSION BELOW SIMPLY COMMENT IT OUT.
IF YOU WANT TO ADD ONE THAT IS NOT LISTED, THEN ADD IT AND CREATE YOUR
OWN ICON.  IMAGEFOLIO WILL WORK WITH ANY BINARY FILE.

## IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT ##
Disable the lines for the extensions that you don't plan to use by
putting unchecking the box in front of it. This will speed up your gallery! 
</pre>
    </td>
  </tr>
</table>		
	};
	
	$extensions .= qq{
<table border=0 cellspacing=1 cellpadding=5 bgcolor="#000000" align="center" width=400>
  <tr>
    <td bgcolor="#dddddd" align=center><br></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Extension</b></font></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Type</b></font></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Link</b></font></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Tag</b></font></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Target</b></font></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Icon</b></font></td>
  </tr>
	};
	
	%extensions = (%default_extensions, %extensions);
	
	foreach my $key(sort(keys(%extensions))) {
		my $info = $extensions{$key};
		
		my ($type, $link, $tag, $target, $icon, $disabled) = @{$info};	
		
		my $checked = $disabled ? '' : ' checked';
		
		my $color = $disabled ? 'ffffff' : 'ffcc00';
		
		my $link_checked = $link ? ' checked' : '';
		
		my $blank_select = $target eq '_blank' ? ' selected' : '';
		my $self_select = $target eq '_self' ? ' selected' : '';
		
		$extensions .= qq{
  <tr>
    <td bgcolor="#$color" align=center><input type="checkbox" name="$key\_active" value="1"$checked></td>
    <td bgcolor="#$color" align=center><font face="Verdana,Arial,Helvetica" size="1">$key</font></td>
    <td bgcolor="#$color" align=center><input type="text" name="$key\_type" value="$type" size=20></td>
    <td bgcolor="#$color" align=center><input type="checkbox" name="$key\_link" value="1"$link_checked></td>
    <td bgcolor="#$color" align=center><input type="text" name="$key\_tag" value="$tag" size=5></td>
    <td bgcolor="#$color" align=center><input type="text" name="$key\_target" value="$target" size=7></td>
   <td bgcolor="#$color" align=center><input type="text" name="$key\_icon" value="$icon" size=9></td>
  </tr>
		};
	}

	$extensions .= qq{
  <tr>
    <td bgcolor="#ffffff" align=center><br></td>
    <td bgcolor="#ffffff" align=center><input type="text" name="config_edit_new_extension_extension" size=5></td>
    <td bgcolor="#ffffff" align=center><input type="text" name="config_edit_new_extension_type" size=20></td>
    <td bgcolor="#ffffff" align=center><input type="checkbox" name="config_edit_new_extension_link" value="1"></td>
    <td bgcolor="#ffffff" align=center><input type="text" name="config_edit_new_extension_tag" size=5></td>
    <td bgcolor="#ffffff" align=center><input type="text" name="config_edit_new_extension_target" value="_self" size=7></td>
    <td bgcolor="#ffffff" align=center><input type="text" name="config_edit_new_extension_icon" size=9></td>
  </tr>
	};
	
	$extensions .= qq{</table>};
}

sub extensions_menu {
	my $extensions = qq{
<table border=0 cellspacing=1 cellpadding=2 bgcolor="#000000" align="center" width=400>
  <tr>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Extension</b></font></td>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Type</b></font></td>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Link</b></font></td>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Tag</b></font></td>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Target</b></font></td>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Icon</b></font></td>
  </tr>
	};
	
	foreach my $key(sort(keys(%extensions))) {
		my $info = $extensions{$key};
		
		my ($type, $link, $tag, $target, $icon, $disabled) = @{$info};	
		
		$link = $link ? 'yes' : 'no';
	
		$extensions .= qq{
  <tr>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$key</font></td>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$type</font></td>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$link</font></td>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$tag</font></td>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$target</font></td>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$icon</font></td>
  </tr>
		};
	}
	
	$extensions .= qq{</table>};

	
	return($extensions);
}

sub IPTCfields_write {
	my $section = $FORM{'section'};
	
	if ($configs{$section}->[0] eq 'IPTCfields') {
		my %new_fields;
	
		my %codes = (%default_IPTCfields, %IPTCfields);
	
		my @codes = reverse(sort(keys(%codes)));
		
		foreach my $code(@codes) {
			if ($FORM{$code . '_active'}) {
				my $bytes = $default_IPTCfields{$code}->[0];
				my $type = $default_IPTCfields{$code}->[1];
			
				my $name		= $FORM{$code . '_name'};
				my $display		= $FORM{$code . '_display'} + 0;
				
				$name =~ s/^\s+//g;              # Trim leading blanks...
				$name =~ s/\s+$//g;              # Trim trailing blanks...
				$name =~ s/\s+\s+/ /g;           # Change two spaces to one.
				
				$new_fields{$code} = [$bytes, $type, $name, $display];
				
				if (!$name) {
					$error_display = "You must supply a <b>name</b> for the <b>$type</b> field!"
				} elsif ($display != 1 && $display != 2 && $display != 3 && $display != 4) {
					$error_display = "<b>Display</b> must be 1, 2, 3, or 4 for the <b>$type</b> field!";
				}
			}
		}
		
		%IPTCfields = %new_fields;
		
		return if $error_display;
	}
	
	my $write = '';
		
	foreach my $key(sort(keys(%IPTCfields))) {
		my ($bytes, $type, $name, $display) = @{$IPTCfields{$key}};
	
		$write .= "\n\t'$key' => [$bytes, '$type', '$name', $display],";
	}
	
	chop($write);
	
	$write = '%IPTCfields = (' . $write . "\n" . ');' . "\n";

	return($write);
}

sub IPTCfields_edit {
	my $fields .= qq{
<table border=0 cellspacing=1 cellpadding=5 bgcolor="#000000" align="center" width=400>
  <tr>
    <td bgcolor="#dddddd" align=center><br></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Bytes</b></font></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Type</b></font></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Name</b></font></td>
    <td bgcolor="#dddddd" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1"><b>Display</b></font></td>
  </tr>
	};
	
	%IPTCfields = (%default_IPTCfields, %IPTCfields);
	
	foreach my $key(sort(keys(%IPTCfields))) {
		my $info = $IPTCfields{$key};
		
		my ($bytes, $type, $name, $display, $disabled) = @{$info};	
		
		my $checked = $disabled ? '' : ' checked';
		
		my $color = $disabled ? 'ffffff' : 'ffcc00';
		
		my $options;
		
		for (my $i = 1; $i < 5; $i++) {
			my $selected = $i == $display ? ' selected' : '';
			
			my $display_option = $display_options[$i];
			
			$options .= qq{<option value="$i"$selected>$display_option</option>};
		}
		
		$fields .= qq{
  <tr>
    <td bgcolor="#$color" align=center><input type="checkbox" name="$key\_active" value="1"$checked></td>
    <td bgcolor="#$color" align=center><font face="Verdana,Arial,Helvetica" size="1">$bytes</font></td>
    <td bgcolor="#$color" align=center><font face="Verdana,Arial,Helvetica" size="1">$type</font></td>
    <td bgcolor="#$color" align=center><input type="text" name="$key\_name" value="$name" size=20></td>
    <td bgcolor="#$color" align=center><select name="$key\_display">$options</select></td>
  </tr>
		};
	}

	$fields .= qq{</table>};
}

@display_options = (0, "Display Only", "Display and Search", "Search Only", "No Display or Search");

sub IPTCfields_menu {
	my $fields = qq{
<table border=0 cellspacing=1 cellpadding=2 bgcolor="#000000" align="center" width=400>
  <tr>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Bytes</b></font></td>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Type</b></font></td>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Name</b></font></td>
    <td bgcolor="#dddddd" align=center><font face="Verdana,Arial,Helvetica" size="1"><b>Display</b></font></td>
  </tr>
	};
	
	foreach my $key(sort(keys(%IPTCfields))) {
		my $info = $IPTCfields{$key};
		
		my ($bytes, $type, $name, $display) = @{$info};	
		
		my $display_option = $display_options[$display];
	
		$fields .= qq{
  <tr>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$bytes</font></td>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$type</font></td>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$name</font></td>
    <td bgcolor="#ffffff" align=center valign=top><font face="Verdana,Arial,Helvetica" size="1">$display_option</font></td>
  </tr>
		};
	}
	
	$fields .= qq{</table>};

	
	return($fields);
}

%default_extensions = ( 
      jpg       => ['JPEG Image',        1,  '',       '_self',  'JPG.jpg', 1],
      tif       => ['TIFF Image',        0,  '',       '_self',  'TIF.jpg', 1],
      mp3       => ['MP3 Audio',         1,  'mp3',    '_self',  'MP3.jpg', 1],
      mpg       => ['MPEG Video',        1,  'mpg',    '_self',  'MPG.jpg', 1],
      zip       => ['Zip File',          0,  '',       '_self',  'ZIP.jpg', 1],
      gif       => ['GIF Image',         1,  '',       '_self',  'GIF.jpg', 1],
      ra        => ['Real Audio',        0,  '',       '_self',  'RA.jpg' , 1],
      rm        => ['Real Movie',        0,  '',       '_self',  'RM.jpg' , 1],
      ram       => ['Real Media',        0,  '',       '_self',  'RM.jpg' , 1],
      wmv       => ['Windows Video',     1,  'mpg',    '_self',  'WMV.jpg', 1],
      mpeg      => ['MPEG Video',        1,  'mpg',    '_self',  'MPG.jpg', 1],
      mov       => ['QuickTime Movie',   1,  'mov',    '_self',  'MOV.jpg', 1],
      qt        => ['QuickTime Movie',   1,  'mov',    '_self',  'MOV.jpg', 1],
      avi       => ['AVI Video',         1,  'avi',    '_self',  'AVI.jpg', 1],
      swf       => ['Flash Movie',       1,  'swf',    '_self',  'SWF.jpg', 1],
      fla       => ['Flash Movie',       1,  'swf',    '_self',  'SWF.jpg', 1],
      au        => ['Audio File',        1,  'au',     '_self',  'AU.jpg' , 1],
      aif       => ['AIF Audio',         1,  'aif',    '_self',  'AIF.jpg', 1],
      mid       => ['MIDI Audio',        1,  'mid',    '_self',  'MID.jpg', 1],
      wma       => ['Windows Audio',     1,  'wma',    '_self',  'MP3.jpg', 1],
      wav       => ['WAV Audio',         1,  'wav',    '_self',  'WAV.jpg', 1],
      doc       => ['Word Document',     0,  '',       '_self',  'DOC.jpg', 1],
      xls       => ['Excel Spreadsheet', 0,  '',       '_self',  'XLS.jpg', 1],
      exe       => ['Windows Program',   0,  '',       '_self',  'EXE.jpg', 1],
      ppt       => ['PowerPoint Pres',   0,  '',       '_self',  'PPT.jpg', 1],
      wpd       => ['WordPerfect Doc',   0,  '',       '_self',  'WPD.jpg', 1],
      gz        => ['GNU Zip Archive',   0,  '',       '_self',  'GZ.jpg' , 1],
      tar       => ['UNIX Tar Archive',  0,  '',       '_self',  'TAR.jpg', 1],
      sit       => ['Stuffit Archive',   0,  '',       '_self',  'SIT.jpg', 1],
      bin       => ['MacBinary File',    0,  '',       '_self',  'BIN.jpg', 1],
      image     => ['Disk Image',        0,  '',       '_self',  'IMG.jpg', 1],
      ttf       => ['TrueType Font',     0,  '',       '_self',  'TTF.jpg', 1],
      fon       => ['Font File',         0,  '',       '_self',  'FON.jpg', 1],
      bmp       => ['Windows Bitmap',    0,  '',       '_self',  'BMP.jpg', 1],
      tiff      => ['TIFF Image',        0,  '',       '_self',  'TIF.jpg', 1],
      eps       => ['EPS Image',         0,  '',       '_self',  'EPS.jpg', 1],
      pdf       => ['Adobe Acrobat',         0,  '',   '_self',  'EPS.jpg', 1],
      ps        => ['EPS Image',         0,  '',       '_self',  'EPS.jpg', 1],
      pcd       => ['Kodak Photo CD',    0,  '',       '_self',  'PCD.jpg', 1],
      psd       => ['Photoshop Image',   0,  '',       '_self',  'PSD.jpg', 1],
      wmf       => ['Windows MetaFile',  0,  '',       '_self',  'WMF.jpg', 1],
      png       => ['PNG Image',         1,  '',       '_self',  'PNG.jpg', 1],
      pict      => ['Apple PICT Image',  0,  '',       '_self',  'EPS.jpg', 1],
      pct       => ['Apple PICT Image',  0,  '',       '_self',  'EPS.jpg', 1],
);

%default_IPTCfields = (
  a0 => ['2000', 'caption/abstract',                 'Caption',                 '1', 1],
  a1 => ['32',   'writer/editor',                    'Caption Writer',          '1', 1],
  a2 => ['256',  'headline',                         'Headline',                '2', 1],
  a3 => ['256',  'special instructions',             'Special Instructions',    '1', 1],
  a4 => ['9999', 'keywords',                         'Keywords',                '2', 1],
  a5 => ['128',  'copyright notice',                 'Copyright Notice',        '1', 1],
  a6 => ['32',   'credit',                           'Credit',                  '1', 1],
  a7 => ['32',   'source',                           'Source',                  '1', 1],
  a8 => ['64',   'object name',                      'Object Name',             '1', 1],
  a9 => ['10',   'date created',                     'Date Created',            '1', 1],
  b1 => ['32',   'by-line',                          'Byline (Photographer)',   '2', 1],
  b2 => ['32',   'by-line title',                    'Byline Title',            '1', 1],
  b3 => ['32',   'city',                             'City',                    '1', 1],
  b4 => ['32',   'province/state',                   'State',                   '1', 1],
  b5 => ['64',   'country/primary location name',    'Country',                 '1', 1],
  b8 => ['32',   'original transmission reference',  'Original Reference',      '1', 1],
  c1 => ['128',  'contact',                          'Contact',                 '1', 1],
  c2 => ['3',    'content location code',            'Content Location Code',   '1', 1],
  c3 => ['64',   'content location name',            'Content Location Name',   '1', 1],
  c4 => ['3',    'country/primary location code',    'Country Code',            '1', 1],
  c5 => ['10',   'digital creation date',            'Digital Creation Date',   '1', 1],
  c6 => ['8',    'digital creation time',            'Digital Creation Time',   '1', 1],
  c7 => ['64',   'edit status',                      'Edit Status',             '1', 1],
  c8 => ['8',    'editorial update',                 'Editorial Update',        '1', 1],
  c9 => ['10',   'expiration date',                  'Expiration Date',         '1', 1],
  d1 => ['8',    'expiration time',                  'Expiration Time',         '1', 1],
  d2 => ['32',   'fixture identifier',               'Fixture Identifier',      '1', 1],
  d3 => ['1',    'image orientation',                'Image Orientation',       '1', 1],
  d4 => ['16',   'image type',                       'Image Type',              '1', 1],
  d5 => ['16',   'language identifier',              'Language Identifier',     '1', 1],
  d6 => ['16',   'object cycle',                     'Object Cycle',            '1', 1],
  d7 => ['32',   'originating program',              'Originating Program',     '1', 1],
  d8 => ['10',   'program version',                  'Program Version',         '1', 1],
  d9 => ['10',   'reference date',                   'Reference Date',          '1', 1],
  e1 => ['8',    'reference number',                 'Reference Number',        '1', 1],
  e2 => ['10',   'reference service',                'Reference Service',       '1', 1],
  e3 => ['10',   'release date',                     'Release Date',            '1', 1],
  e4 => ['8',    'release time',                     'Release Time',            '1', 1],
  e5 => ['32',   'sub-location',                     'Sub-Location',            '1', 1],
  e6 => ['236',  'subject reference',                'Subject Reference',       '1', 1],
  e7 => ['8',    'time created',                     'Time Created',            '1', 1],
  e8 => ['1',    'urgency',                          'Urgency',                 '1', 1],
  e9 => ['128',  'custom1',                          'Custom 1',                '1', 1],
  f1 => ['128',  'custom2',                          'Custom 2',                '1', 1],
  f2 => ['128',  'custom3',                          'Custom 3',                '1', 1],
  f3 => ['128',  'custom4',                          'Custom 4',                '1', 1],
  f4 => ['128',  'custom5',                          'Custom 5',                '1', 1],
  f5 => ['128',  'custom6',                          'Custom 6',                '1', 1],
  f6 => ['128',  'custom7',                          'Custom 7',                '1', 1],
  f7 => ['128',  'custom8',                          'Custom 8',                '1', 1],
  f8 => ['128',  'custom9',                          'Custom 9',                '1', 1],
  f9 => ['128',  'custom10',                         'Custom 10',               '1', 1],
  g1 => ['128',  'custom11',                         'Custom 11',               '1', 1],
  g2 => ['128',  'custom12',                         'Custom 12',               '1', 1],
  g3 => ['128',  'custom13',                         'Custom 13',               '1', 1],
  g4 => ['128',  'custom14',                         'Custom 14',               '1', 1],
  g5 => ['128',  'custom15',                         'Custom 15',               '1', 1],
  g6 => ['128',  'custom16',                         'Custom 16',               '1', 1],
  g7 => ['128',  'custom17',                         'Custom 17',               '1', 1],
  g8 => ['128',  'custom18',                         'User',                    '1', 1],
  g9 => ['128',  'custom19',                         'Email',                   '1', 1],
  h1 => ['128',  'custom20',                         'URL',                     '1', 1]
);

1;