####CODEHEADER###

$DISKUSAGE = "active";

###############################################################################
# DISK USAGE
# Reports for displaying disk usage by category and total disk usage
###############################################################################

sub disk_usage {
   my $admin_ouptut;
   my $admin_title = "Disk Usage";

   if (-e $disk_usage_file) {
      ($dufiledate) = unix_to_date((stat("$disk_usage_file"))[9]);
      $dufiledate = qq{Generated On $dufiledate};
      
      open (FILE,"$disk_usage_file");
      my(@Usage)=<FILE>;
      close(FILE);


      foreach $Usage (@Usage) {
         chomp $Usage;
         my ($UsageKb, $IFCategory) = split(/\t/, $Usage);  
         $UsageBytes = $UsageKb * 1024;
         $UsageMb = $UsageBytes / 1048576;
         $UsageMb = sprintf("%.2f", $UsageMb);


         if ($bgcolortd eq "#dddddd") {
            $bgcolortd = "#eeeeee";
         }
         else {
            $bgcolortd = "#dddddd";
         }
         
         
         $CatLink = qq|<a href="$imagefolio_url?direct=$IFCategory" target="_blank">|;
      
         if ($IFCategory =~ /^Total/) {
            $UsageMb = "<b>$UsageMb MB</b>";
            $IFCategory = "<b>TOTAL DISK USAGE</b>";
            $CatLink = "";
            $bgcolortd = "#666666";
            $totalcolor = qq| color="#ffffff"|;
         }

         $usage_output .= qq{
         <tr>
           <td align=left width="100%" bgcolor="$bgcolortd"><$fe_admin_small_font$totalcolor>$CatLink$IFCategory</a></font></td>
           <td align=right bgcolor="$bgcolortd" nowrap><$fe_admin_small_font$totalcolor>$UsageMb</font></td>
         </tr>
         };
       
      }
   }
   
   if (!$usage_output) {
      $usage_output = qq{
      <tr>
        <td colspan=2 bgcolor="#ffffff"><$fe_admin_small_font>No data available.</font></td>
      </tr>
      };
   }
   
   $output = qq{
      <table width="100%" cellpadding="5" cellspacing="0" border="0">
         <tr>
           <td align="left" bgcolor="#666666"><$fe_admin_small_font color="#ffffff"><b>CATEGORY</b></font></td>
           <td align=right nowrap bgcolor="#666666"><$fe_admin_small_font color="#ffffff"><b>USAGE (MB)</b></font></td>
         </tr>$usage_output
      </table>
   };



&get_header;

print qq|
<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000"><tr><td>
<table border="0" width="100%" cellspacing=1 cellpadding=0>

<tr bgcolor="#ffcc00"><td>
<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Disk Usage</b></font></td>
<td align=right><$admin_big_font><b>$dufiledate</b></font></td> </tr></table></td></tr>

<tr><td>


$output

</td></tr></table></td></tr></table>

|;

&get_footer;

}


1;