####CODEHEADER###

   if ($using_picturepost_mod) {
      require "$config_directory/post_config.pl";
   }

###############################################################################
# VIEW GROUPS
# Shows a tabled listing of all groups and users within those groups
###############################################################################
sub view_groups {

$VIEWGROUPS = "active";

$pagetitle = "Showing All Users &amp; Groups";

   require "$libpath/crypt.pl";
   require "$db_link_path/$db_link_file";

if ($userstep == 2 && !$admin_demo_mode && $FORM{'ugc'} eq $COOKIE{'ugc'}) {
   foreach my $key (%FORM) {
      if ($key =~ /^ugc_/) {
         my ($user1, $user2) = split(/\,/, $FORM{$key});
         if ($user1 ne $user2) {
            my $user = $key;
            $user =~ s/^ugc_//g;
            $EDIT_USERS{$user}[0] = $user1;
            $EDIT_USERS{$user}[1] = $user2;
            $edit_userdb = 1;
         }
      }
   }
   if ($edit_userdb) {
      open (USERDB, "$userdb");
      my (@USERDB)=<USERDB>;
      close (USERDB);
      chomp @USERDB;
      my @USERDB_NAMES = split(/\t/, $USERDB[0]);
      my $cntun = 0;
      foreach my $USERDB_NAME (@USERDB_NAMES) {
         if ($USERDB_NAME eq $IF_VAL{'ifusername'}) {
            $ifusernameloc = $cntun;
         }
         elsif ($USERDB_NAME eq $IF_VAL{'ifgroup'}) {
            $ifgrouploc = $cntun;
         }
         $cntun++;
      }
      $accountline = "$USERDB[0]\n";
      my $SIZE = @USERDB;
      for ($i=1;$i<=$SIZE;$i++) {
         next unless $USERDB[$i];
         my @USERDB_VALUES = split(/\t/, $USERDB[$i]);
         if (defined $EDIT_USERS{$USERDB_VALUES[$ifusernameloc]}) {
            my $cnteu = 0;
            foreach my $USERDB_NAME (@USERDB_NAMES) {
               if ($USERDB_NAME eq $IF_VAL{'ifgroup'}){
                  if ($EDIT_USERS{$USERDB_VALUES[$ifusernameloc]}[1]) {
                     $accountline .= $EDIT_USERS{$USERDB_VALUES[$ifusernameloc]}[1] . "\t";
                  }
                  elsif ($USERDB_VALUES[$cnteu] eq $EDIT_USERS{$USERDB_VALUES[$ifusernameloc]}[0]) {
                     $accountline .= "\t";
                  }
                  else {
                     $accountline .= $EDIT_USERS{$USERDB_VALUES[$ifusernameloc]}[0] . "\t";
                  }
               }
               else {
                  $accountline .= "$USERDB_VALUES[$cnteu]\t";
               }
               $cnteu++;
            }
            $accountline =~ s/\t$/\n/ig;
         }
         else {
            $accountline .= "$USERDB[$i]\n";
         }
      }
      open(ADDUSERDB, ">$userdb");
      print ADDUSERDB $accountline;
      close(ADDUSERDB);
      chmod(0777, $userdb)
   }
}

&get_group_list_view;

print "Set-Cookie: ugc=$current_time; path=/;\n";
print "Content-type: text/html\n\n";

$admin_demo_html = () unless $admin_demo_mode;


print qq|
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd"><html>
<head>
	<title>$site_title : View Groups</title>
</head>
<body marginwidth=0 marginheight=0 topmargin=0 leftmargin=0 bottommargin=0 rightmargin=0>
$admin_demo_html
<form method=post action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="gallery_group.pl">
<input type=hidden name=useraction value="viewgroups">
<input type=hidden name=userstep value=2>
<input type=hidden name=ugc value=$current_time>
<center>
<table border=0 cellspacing=0 cellpadding=5 width="98%">
<tr><td valign=top align=left><$admin_font><b><big>$site_title</big><br>$pagetitle</b><br>
<a href="$imagefolio_url?admin=admin&uid=$FORM{'uid'}">Return to Admin Home</a></font><br></td>

<td align=right valign=top><$admin_font>$groupdb_lmd $userdb_lmd
$totalgroups total groups and $totalusers total users.</font><br></td>
</tr></table>
$grouplist
<br>
<center><input name="sdsdsd" type="button" value="Apply Group Changes" onClick="if(this.value == 'Apply Group Changes'){this.value = 'Applying Group Changes...';this.form.submit();}"></center>
</form>
</body>
</html>
|;

}

###############################################################################
# GET USER LIST
# Opens the user database and builds a select box of all users
###############################################################################
sub get_group_list_view {

   if (-e "$data_directory/userdiskspace.txt") {
      $diskspacetitle = qq|<td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Used</b></font></td>|;
      $comlumn = 7;
   }
   else {
      $comlumn = 6;
   }

   $totalusers = "0";


   my @rows = ();

   open (GROUPDB, "$groupdb");
      while (<GROUPDB>) {
         chomp;
         /^#/      and next;        # Skip comment Lines.
         /^\s*$/   and next;        # Skip blank lines.
         push(@rows, $_);
      }
   close (GROUPDB);

   @rows = sort { lc($a) cmp lc($b) } @rows;

   foreach $line (@rows) {
      &split_if_groupline($line);
      $yes_default = 1 if $group_default;
      $this_group_group_name = $group_group_name;
      foreach $line (@rows) {
         &split_if_groupline($line);
         my $selected = " selected" if $this_group_group_name eq $group_group_name;
         $GROUP_MENUS{"groups_$this_group_group_name"} .= qq|<option value="$group_group_name"$selected>$group_group_name</option>|;
      }
   }

   if ($yes_default) {
      foreach my $key (%GROUP_MENUS) {
         $GROUP_MENUS{$key} = qq|<option value="">None</option>| . $GROUP_MENUS{$key};
      }
      $missing_group = qq|<option value="">None</option>|;
   }

   $GROUP_MENUS{"groups_default"} = qq|<option value="" selected>None</option>|;
   foreach $line (@rows) {
      &split_if_groupline($line);
      $GROUP_MENUS{"groups_default"} .= qq|<option value="$group_group_name">$group_group_name</option>|;
      $missing_group .= qq|<option value="$group_group_name">$group_group_name</option>|;
   }

   open (USERDB, "$userdb");
   my (@USERDB)=<USERDB>;
   close (USERDB);
   chomp @USERDB;
   my @USERDB_NAMES = split(/\t/, $USERDB[0]);
   my $cntun = 0;
   foreach my $USERDB_NAME (@USERDB_NAMES) {
      if ($USERDB_NAME eq $IF_VAL{'ifusername'}) {
         $ifusernamecntun = $cntun;
      }
      elsif ($USERDB_NAME eq $IF_VAL{'ifuserpass'}) {
         $ifuserpasscntun= $cntun;
      }
      elsif ($USERDB_NAME eq $IF_VAL{'iffirstname'}) {
         $iffirstnamecntun= $cntun;
      }
      elsif ($USERDB_NAME eq $IF_VAL{'iflastname'}) {
         $iflastnamecntun= $cntun;
      }
      elsif ($USERDB_NAME eq $IF_VAL{'ifemail'}) {
         $ifemailcntun= $cntun;
      }
      elsif ($USERDB_NAME eq $IF_VAL{'ifgroup'}) {
         $ifgroupcntun= $cntun;
      }
      $cntun++;
   }
   if ($admin_demo_mode) {
      foreach (@USERDB_NAMES) {
         push (@DEMOUSERDB_NAMES, "*****");
      }
   }
   my $UDBSIZE = @USERDB;
   for ($i=1;$i<=$UDBSIZE;$i++) {
      next unless $USERDB[$i];
      $totalusers++;
      my @USERDB_VALUES = split(/\t/, $USERDB[$i]);
      if ($USERDB_VALUES[$ifgroupcntun]){
         $group_user_table = $USERDB_VALUES[$ifgroupcntun];
      }
      else {
         $group_user_table = "default";
      }
#      $GROUP_USERS{"users_$group_user_table"} .= qq|
#      <tr>
#        <td bgcolor="#ffffff" align=left valign=top colspan=5><$admin_small_font>$IF_VAL{'ifemail'} - $ifemailcntun</font></td>
#      </tr>
#      |;
      $USERDB_VALUES[$ifuserpasscntun] = &admin_decrypt($USERDB_VALUES[$ifuserpasscntun], $secret_key);
      if ($admin_demo_mode) {
         @USERDB_VALUES = @DEMOUSERDB_NAMES;
      }

      if ($GROUP_MENUS{"groups_$group_user_table"}) {
         $groupmenu = qq|<select name="ugc_$USERDB_VALUES[$ifusernamecntun]">$GROUP_MENUS{"groups_$group_user_table"}</select>|;
      }
      else {
         $groupmenu = qq|<select name="ugc_$USERDB_VALUES[$ifusernamecntun]"><option value="$USERDB_VALUES[$ifgroupcntun]" selected>$USERDB_VALUES[$ifgroupcntun]</option>$missing_group</select>|;
      }

      if ($diskspacetitle) {
         my $user = $USERDB_VALUES[$ifusernamecntun];
         $user =~ s/[$deny_chars]//g;
         $user =~ s/ /_/g;
         open (DATA, "$sessions_dir/$user/diskspace.txt");
         my $filesize = do { local $/, <DATA> };
         close DATA;
         if ($filesize) {
            if ($filesize < 1500) {
               $filesize = commify($filesize) . " bytes";
            }
            else { $filesize = int($filesize/1024);
               if ($filesize < 1500) {
                  $filesize = commify($filesize) . " Kb";
               }
               else { $filesize = int($filesize/1024);
                  if ($filesize < 1500) {
                     $filesize = commify($filesize) . " Mb";
                  }
                  else { $filesize = int($filesize/1000);
                     $filesize = commify($filesize) . " GB";
                  }
               }
            }
         }
         else {
            $filesize = "0 Mb";
         }
         $diskspacevalue = qq|<td bgcolor="#ffffff" align=left valign=middle><$admin_small_font>$filesize &nbsp;</font></td>|;
      }


      $GROUP_USERS{"users_$group_user_table"} .= qq|
      <tr>
         $diskspacevalue
        <td bgcolor="#ffffff" align=left valign=middle><$admin_small_font>$USERDB_VALUES[$ifusernamecntun] &nbsp;</font></td>
        <td bgcolor="#ffffff" align=left valign=middle><$admin_small_font>$USERDB_VALUES[$ifuserpasscntun] &nbsp;</font></td>
        <td bgcolor="#ffffff" align=left valign=middle><$admin_small_font><a href="mailto:$USERDB_VALUES[$ifemailcntun]">$USERDB_VALUES[$ifemailcntun]</a></font></td>
        <td bgcolor="#ffffff" align=left valign=middle><$admin_small_font>$USERDB_VALUES[$iffirstnamecntun] &nbsp;</font></td>
        <td bgcolor="#ffffff" align=left valign=middle><$admin_small_font>$USERDB_VALUES[$iflastnamecntun] &nbsp;</font></td>
        <td bgcolor="#ffffff" align=left valign=middle><input name="ugc_$USERDB_VALUES[$ifusernamecntun]" type="hidden" value="$USERDB_VALUES[$ifgroupcntun]">$groupmenu</td>
      </tr>
      |;
   }


   if (-e $groupdb) {
      ($date_groupdb) = unix_to_date((stat("$groupdb"))[9]);
      $groupdb_lmd = "Group DB last modified on $date_groupdb.<br>";
   }


   my $size = @rows;
   
   ################################

      if (-e $userdb) {
         ($date_userdb) = unix_to_date((stat("$userdb"))[9]);
         $userdb_lmd = "User DB last modified on $date_userdb.<br>";
      }



   $totalgroups = "0";

   $totalgroups = @rows;
   
   foreach $group (@rows) {
      &split_if_groupline($group);
      $this_default = "";
      if ($group_default) {
#         $found_default_group = 1;
         $this_default = " (default)";
         $group_results = qq|
         <br><table width="98%" border=0 cellspacing=1 cellpadding=6 bgcolor="#000000">
           <tr>
             <td align=left bgcolor="#ffcc00"><$admin_big_font><b>Default group ($group_group_name)</b></font></td>
           </tr>
           <tr>
             <td align=left bgcolor="#eeeeee">
         
         <$admin_font><b>Group Permissions</b></font><br>
         
         <table border=0 cellspacing=1 cellpadding=2 width="100%" bgcolor="#000000">
           <tr>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>View Preview</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Protect Preview</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>View Fullsize</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Upload Main Cats</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Add Categories</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Upload Approval</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Rename Files</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Move Files</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Delete Files</b></font></td>
           </tr>
           <tr>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_preview_view_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_preview_protect_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_full_size_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_upload_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_main_cat_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_upload_approval &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_ren_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_mov_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_del_per &nbsp;</font></td>
           </tr>
           <tr>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Describe Files</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Save Fullsize</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Add Cats</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Rename Cats</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Move Cats</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Delete Cats</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Cat Upload</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Describe Cats</b></font></td>
             <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Skin</b></font></td>
           </tr>
           <tr>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_desc_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_fs_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_add_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_ren_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_move_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_del_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_upload_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_desc_per &nbsp;</font></td>
             <td align=center bgcolor="#ffffff" valign=top><$admin_small_font>$group_skins_access</font></td>
           </tr>
         </table>
         <br>
         |; 

         $group_results =~ s/ 0 /No/g;
         $group_results =~ s/ 1 /<font color=red><b>Yes<\/b><\/font>/g;


         $user_results = qq|<$admin_font><b>Users</b><br>
         <table border=0 cellspacing=1 cellpadding=2 width="100%" bgcolor="#000000">
           <tr>
          $diskspacetitle
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Username</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Password</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Email Address</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>First Name</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Last Name</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left><$admin_small_font><b>Group</b></font></td>
           </tr>
         |;


         if ($GROUP_USERS{"users_default"}) {
            $user_results .= $GROUP_USERS{"users_default"};
            delete($GROUP_USERS{"users_default"});
         }
         else {
            $user_results .= qq|
            <tr>
              <td bgcolor="#ffffff" align=left valign=top colspan=$comlumn><$admin_small_font><b>
              <font color=red>None Found</font></b></font></td>
            </tr>
            |;
         }

         $user_results .= qq|</table></td></tr></table><br>|;

         $grouplist = qq|$group_results $user_results $grouplist|;
      }


      $group_results = qq|
      <br><table width="98%" border=0 cellspacing=1 cellpadding=6 bgcolor="#000000">
        <tr>
          <td align=left bgcolor="#ffcc00"><$admin_big_font><b>$group_group_name$this_default</b></font></td>
        </tr>
        <tr>
          <td align=left bgcolor="#eeeeee">
      
      <$admin_font><b>Group Permissions</b></font><br>
      
      <table border=0 cellspacing=1 cellpadding=2 width="100%" bgcolor="#000000">
        <tr>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>View Preview</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Protect Preview</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>View Fullsize</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Upload Main Cats</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Add Categories</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Upload Approval</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Rename Files</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Move Files</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Delete Files</b></font></td>
        </tr>
        <tr>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_preview_view_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_preview_protect_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_full_size_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_upload_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_main_cat_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_upload_approval &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_ren_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_mov_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_del_per &nbsp;</font></td>
        </tr>
        <tr>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Describe Files</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Save Fullsize</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Add Cats</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Rename Cats</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Move Cats</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Delete Cats</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Cat Upload</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Describe Cats</b></font></td>
          <td bgcolor="#dddddd" align=center valign=top><$admin_small_font><b>Skin</b></font></td>
        </tr>
        <tr>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_desc_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_media_fs_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_add_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_ren_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_move_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_del_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_upload_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font> $group_cat_desc_per &nbsp;</font></td>
          <td align=center bgcolor="#ffffff" valign=top><$admin_small_font>$group_skins_access</font></td>
        </tr>
      </table>
      <br>
      |; 

      $group_results =~ s/ 0 /No/g;
      $group_results =~ s/ 1 /<font color=red><b>Yes<\/b><\/font>/g;


      $user_results = qq|<$admin_font><b>Users</b><br>
      <table border=0 cellspacing=1 cellpadding=2 width="100%" bgcolor="#000000">
        <tr>
         $diskspacetitle
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Username</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Password</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Email Address</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>First Name</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Last Name</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left><$admin_small_font><b>Group</b></font></td>
        </tr>
      |;



      if ($GROUP_USERS{"users_$group_group_name"}) {
         $user_results .= $GROUP_USERS{"users_$group_group_name"};
         delete($GROUP_USERS{"users_$group_group_name"});
      }
      else {
         $user_results .= qq|
         <tr>
           <td bgcolor="#ffffff" align=left valign=top colspan=$comlumn><$admin_small_font><b>
           <font color=red>None Found</font></b></font></td>
         </tr>
         |;
      }

      $user_results .= qq|</table></td></tr></table><br>|;

      $grouplist .= qq|$group_results $user_results|;

      $this_default = "";
   }

   foreach my $key (sort keys %GROUP_USERS) {
      if ($key eq "users_default") {
         $groupname = "Default group";
         $groupfix = qq|set one of your current groups as default|;
      }
      else {
         $groupname = $key;
         $groupname =~ s/^users_//g;
         $groupfix = qq|create a new group called $groupname|;
      }
      $group_results = qq|
      <br><table width="98%" border=0 cellspacing=1 cellpadding=6 bgcolor="#000000">
        <tr>
          <td align=left bgcolor="#ffcc00"><$admin_big_font><b>$groupname</b></font></td>
        </tr>
        <tr>
          <td align=left bgcolor="#eeeeee">
      
      <$admin_font><b>Group Permissions</b></font><br>
      
      <table border=0 cellspacing=1 cellpadding=2 width="100%" bgcolor="#000000">
         <tr>
           <td bgcolor="#ffffff" align=left valign=top colspan=9><$admin_small_font><b>
           <font color=red>None Found (Users in this group won't be able to login. Please assign other groups to these users or $groupfix to give these users a new "home".)</font></b></font></td>
         </tr>
      </table>
      <br>
      |; 

      $user_results = qq|<$admin_font><b>Users</b><br>
      <table border=0 cellspacing=1 cellpadding=2 width="100%" bgcolor="#000000">
        <tr>
         $diskspacetitle
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Username</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Password</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Email Address</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>First Name</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left width="17%"><$admin_small_font><b>Last Name</b></font></td>
          <td bgcolor="#dddddd" valign=top align=left><$admin_small_font><b>Group</b></font></td>
        </tr>
      |;


      $user_results .= $GROUP_USERS{$key};

      $user_results .= qq|</table></td></tr></table><br>|;

      $grouplist .= qq|$group_results $user_results|;
   }



}

###############################################################################
# MODIFY USER
# Shows the modify a user form
###############################################################################
sub modify_group {

$MODIFYGROUP = "active";

if ($userstep eq "2") { &modify_group_step2; }
#elsif ($userstep eq "final") { &modify_group_final; }
else {
$pagetitle = "Modify Group - Select A Group";
&get_header;
&get_group_list;

print qq|$comment

<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="gallery_group.pl">
<input type=hidden name=useraction value="modify">
<input type=hidden name=userstep value=2>

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Select A Group</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 2</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>$grouplist</td></tr></table></td></tr></table>

<br><input type=submit value="Modify Group">

</center>

</form>
|;

&get_footer;
}
}

###############################################################################
# MODIFY USER STEP 2
# Shows a form to modify a single user's information
###############################################################################
sub modify_group_step2 {

$pagetitle = "Modify Group Account";
&get_header;
&get_user;
&category_list;
&content_list;
&find_skin_options;

if ($using_picturepost_mod && $main_users_cat) {
   $personal__view_cat_text1 = qq|<br>If you select [PERSONAL_CATEGORY] then each member of this group will only see their own category in the <b>$main_users_cat</b> category. The name of the subcategory will be the same as the username of this group member.|;
}

print qq|
<form method=post action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="gallery_group_setup.pl">
<input type=hidden name=newaction value="updategroup">
<input type=hidden name=action value="modified">
<input type=hidden name=ifgroup value="$ifgroup">
 
<center>


<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr>
<td align=center>

<table border=0 cellspacing=1 cellpadding=0 width="100%" bgcolor="#000000">
<tr bgcolor="#ffcc00"><td><table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Modify Group</b></font></td>
<td align=right><$admin_big_font><b>Step 2 of 2</b></font></td>
</tr></table></td>
</tr>

<tr bgcolor="#eeeeee">
<td align=center valign=middle>
<table border=0 cellspacing=0 cellpadding=10 width=600><tr>
<td align=center>

<table border=0 cellspacing=0 cellpadding=7 width="100%">

<tr><td align=right><$admin_font><b>Group name</b></font></td>
<td><input type=text maxlength=20 name="group_name" size=20 value="$group_group_name"></td>
<td nowrap><$admin_small_font>Min 5 characters, no spaces.</font></td></tr>

<tr><td align=right><$admin_font><b>Short Description</b></font></td>
<td colspan=2><textarea name="short_desc" rows="4" cols="30">$group_short_desc</textarea></td>
</tr>

<tr><td align=right><$admin_font><b>Default</b></font></td>
<td><input type="checkbox" name="default"$group_default_checked></td>
<td><$admin_small_font>New users that have setup their own account or users from bulletin boards will get the permissions of the default group.</font></td>

</tr>

<tr><td align=right><$admin_font><b>Skin Choices</b></font></td>
<td>$skin_choices</td>
<td><$admin_small_font>Select the skin you want to use for this group.</font></td>

</tr>

<tr><td align=right nowrap><$admin_font><b>View Categories</b></font></td>
<td>$pulldown_menu</td>
<td><$admin_small_font>Select the categories that this group can view. Hold down [CTRL] on Windows and [Apple] on Macintosh computers to select multiple.$personal__view_cat_text1</font></td>
</tr>


<!--<tr><td align=right nowrap><$admin_font><b>View Additional Content</b></font></td>
<td>$content_menu</td>
<td><$admin_small_font>Select the additional content that this group can view. Hold down [CTRL] on Windows and [Apple] on Macintosh computers to select multiple.</font></td>
</tr>-->

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3 align=center><$admin_font>Please set <b>Gallery Permissions</b> for this group:</font><br></td></tr>

<tr><td colspan=3 align=center>
<table border=0 cellspacing=0 cellpadding=0 width="500" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Allow this group to...</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Yes</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>No</b></font></td></tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>View preview image</b> ?</font><br><$admin_small_font>If set to "No" group can only view the thumbnails.</font></td>
<td align=center><input type=radio name="preview_view_per" value=1$preview_view_per_1></td>
<td align=center><input type=radio name="preview_view_per" value=0$preview_view_per_0></td>
</tr>|;

if ($imageprotect) {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Protect preview image</b> ?</font><br><$admin_small_font>Prevent downloading/printing of preview image.</font></td>
<td align=center><input type=radio name="preview_protect_per" value=1$preview_protect_per_1></td>
<td align=center><input type=radio name="preview_protect_per" value=0$preview_protect_per_0></td>
</tr>|;
}
else {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Protect preview image</b> ?</font><br><$admin_small_font>Prevent downloading/printing of preview image.</font></td>
<td align=center colspan=2><$admin_small_font>Disabled in config.pl</font></td>
</tr>|;
}


if ($watermark) {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Show watermarked preview</b> ?</font><br><$admin_small_font>Will show the watermarked preview image.</font></td>
<td align=center><input type=radio name="watermark_per" value=1$watermark_per_1></td>
<td align=center><input type=radio name="watermark_per" value=0$watermark_per_0></td>
</tr>|;
}
else {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Show watermarked preview</b> ?</font><br><$admin_small_font>Will show the watermarked preview image.</font></td>
<td align=center colspan=2><$admin_small_font>Disabled in config.pl</font></td>
</tr>|;
}

if ($use_fullsize) {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Full Size Permission</b> ?</font><br><$admin_small_font>If set to "Yes" group can download the full size file.</font></td>
<td align=center><input type=radio name="full_size_per" value=1$full_size_per_1></td>
<td align=center><input type=radio name="full_size_per" value=0$full_size_per_0></td>
</tr>|;
}
else {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Full Size Permission</b> ?</font><br><$admin_small_font>If set to "Yes" group can download the full size file.</font></td>
<td align=center colspan=2><$admin_small_font>Disabled in config.pl</font></td>
</tr>|;
}

print qq|</table></td></tr></table></td></tr>|;

if ($using_picturepost_mod) {
   &post_category_list;
   if ($main_users_cat) {
      $personal_cat_text1 = qq|<br>If you select [PERSONAL_CATEGORY] then each member of this group will get their own subcateogry within the <b>$main_users_cat</b> category. The name of the subcategory will be the same as the username of this group member.|;
      $personal_cat_text2 = qq|<br>Especially usefull if you have set [PERSONAL_CATEGORY]|;
   }
   else {
      $personal_cat_text2 = qq|<br>Especially usefull if you set "\$main_users_cat" in your post_config.pl|;
   }


   print qq|
<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3 align=center><$admin_font>Please set <b>Upload Permissions</b> for this group:</font><br></td></tr>
<tr><td colspan=3 align=center>
<table border=0 cellspacing=0 cellpadding=0 width="500" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Allow this group to...</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Yes</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>No</b></font></td></tr>

<tr bgcolor="#cccccc">
<td colspan=3><$admin_small_font><b>M E D I A&nbsp;&nbsp;&nbsp;&nbsp;P E R M I S S I O N S</b></font></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Upload Media</b> ?</font></td>
<td align=center><input type=radio name="media_upload_per" value=1$media_upload_per_1></td>
<td align=center><input type=radio name="media_upload_per" value=0$media_upload_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Upload Media to main categories</b> ?</font><br>
   <$admin_small_font>If set to "No", group can only upload files to subcategories.</font></td>
<td align=center><input type=radio name="media_main_cat_per" value=1$media_main_cat_per_1></td>
<td align=center><input type=radio name="media_main_cat_per" value=0$media_main_cat_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Upload approval required</b> ?</font><br>
   <$admin_small_font>If set to "Yes", uploaded files will only be viewable after you have approved them.</font></td>
<td align=center><input type=radio name="media_upload_approval" value=1$media_upload_approval_1></td>
<td align=center><input type=radio name="media_upload_approval" value=0$media_upload_approval_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Rename Media</b> ?</font></td>
<td align=center><input type=radio name="media_ren_per" value=1$media_ren_per_1></td>
<td align=center><input type=radio name="media_ren_per" value=0$media_ren_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Move Media</b> ?</font></td>
<td align=center><input type=radio name="media_mov_per" value=1$media_mov_per_1></td>
<td align=center><input type=radio name="media_mov_per" value=0$media_mov_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Delete Media</b> ?</font></td>
<td align=center><input type=radio name="media_del_per" value=1$media_del_per_1></td>
<td align=center><input type=radio name="media_del_per" value=0$media_del_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Add Keywords and Captions</b> ?</font></td>
<td align=center><input type=radio name="media_desc_per" value=1$media_desc_per_1></td>
<td align=center><input type=radio name="media_desc_per" value=0$media_desc_per_0></td>
</tr>|;

if ($use_fullsize) {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Save full size (3rd image)</b> ?</font></td>
<td align=center><input type=radio name="media_fs_per" value=1$media_fs_per_1></td>
<td align=center><input type=radio name="media_fs_per" value=0$media_fs_per_0></td>
</tr>|;
}
else {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Save full size (3rd image)</b> ?</font></td>
<td align=center colspan=2><$admin_small_font>Disabled in config.pl</font></td>
</tr>|;
}

print qq|

<tr bgcolor="#cccccc">
<td colspan=3><$admin_small_font><b>M E D I A&nbsp;&nbsp;&nbsp;&nbsp;M O D I F I C A T I O N&nbsp;&nbsp;&nbsp;&nbsp;P E R M I S S I O N S</b><br>Allow members of this group to rename/move/delete/keyword media uploaded by:</font></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>This member only</b></font></td>
<td align=center colspan=2><input type=radio name="media_mod_per" value=0$media_mod_per_0></td>
</tr>
<!--
<tr bgcolor="#ffffff">
<td><$admin_font><b>Any member of this group</b></font></td>
<td align=center colspan=2><input type=radio name="media_mod_per" value=2$media_mod_per_2></td>
</tr>
-->
<tr bgcolor="#ffffff">
<td><$admin_font><b>Anyone</b></font></td>
<td align=center colspan=2><input type=radio name="media_mod_per" value=1$media_mod_per_1></td>
</tr>

<tr bgcolor="#cccccc">
<td colspan=3><$admin_small_font><b>C A T E G O R Y&nbsp;&nbsp;&nbsp;&nbsp;P E R M I S S I O N S</b>
   $personal_cat_text2</font></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Add Categories</b> ?</font></td>
<td align=center><input type=radio name="cat_add_per" value=1$cat_add_per_1></td>
<td align=center><input type=radio name="cat_add_per" value=0$cat_add_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Rename Categories</b> ?</font></td>
<td align=center><input type=radio name="cat_ren_per" value=1$cat_ren_per_1></td>
<td align=center><input type=radio name="cat_ren_per" value=0$cat_ren_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Move Categories</b> ?</font></td>
<td align=center><input type=radio name="cat_move_per" value=1$cat_move_per_1></td>
<td align=center><input type=radio name="cat_move_per" value=0$cat_move_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Delete Categories</b> ?</font></td>
<td align=center><input type=radio name="cat_del_per" value=1$cat_del_per_1></td>
<td align=center><input type=radio name="cat_del_per" value=0$cat_del_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Upload Category Image</b> ?</font></td>
<td align=center><input type=radio name="cat_upload_per" value=1$cat_upload_per_1></td>
<td align=center><input type=radio name="cat_upload_per" value=0$cat_upload_per_0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Add Category Description</b> ?</font></td>
<td align=center><input type=radio name="cat_desc_per" value=1$cat_desc_per_1></td>
<td align=center><input type=radio name="cat_desc_per" value=0$cat_desc_per_0></td>
</tr>
</table></td></tr></table></td></tr>
   
<tr><td colspan=3>&nbsp;</td></tr>
<tr><td align=right nowrap><$admin_font><b>Upload Categories</b></font></td>
<td>$post_pulldown_menu</td>
<td><$admin_small_font>If you have set upload permission to "yes" then select the categories that this group can upload to. Hold down [CTRL] on Windows and [Apple] on Macintosh computers to select multiple. $personal_cat_text1</font></td>
</tr>
<tr><td colspan=3>&nbsp;</td></tr>|;

eval qq{ require "$libpath/zoomify.pl"; };
if ($using_zoomify) {
   print qq|<tr><td colspan=3 align=center><$admin_font>Please set <b>Zoomify Permissions</b> for this group:</font><br></td></tr><tr><td colspan=3 align=center>|;
   print &ifz_settings_table($group_group_name);
   print qq|</td></tr>|;
}

print qq|
<!--
<tr><td colspan=3 align=center><$admin_font>Please set <b>Commerce Purchase Permissions</b> for this group:</font><br></td></tr>

<tr><td colspan=3 align=center>
<table border=0 cellspacing=0 cellpadding=0 width="600" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Allow users to upgrade to this group.</b><br>Select none if only Administrators can upgrade accounts.</font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Select</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Cost ($currsymbol)</b></font></td></tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Free Upgrade.</b></font><br><$admin_small_font>Users can freely upgrade to this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=free></td>
<td align=center></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Weekly payment.</b></font><br><$admin_small_font>User needs to pay weekly to stay in this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=week></td>
<td align=center><input type=number size=6 name="upgrade_per_week" value=1.00></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Monthly payment.</b></font><br><$admin_small_font>User needs to pay monthly to stay in this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=month></td>
<td align=center><input type=number size=6 name="upgrade_per_month" value=5.00></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Yearly payment.</b></font><br><$admin_small_font>User needs to pay yearly to stay in this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=year></td>
<td align=center><input type=number size=6 name="upgrade_per_year" value=50.00></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>One payment.</b></font><br><$admin_small_font>After user pays he stays member of this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=once></td>
<td align=center><input type=number size=6 name="upgrade_per_once" value=100.00></td>
</tr>

</table></td></tr></table></td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3 align=center>
<table border=0 cellspacing=0 cellpadding=0 width="600" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Discounts applied to members of this group.</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Select</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Value (<select name="discount_type"><option value=p>%<option value=s>$currsymbol</select>)</b></font></font></td></tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>No Discount.</b></font><br><$admin_small_font>No discounts will be applied.</font></td>
<td align=center><input type=radio name="discount_per" value=no checked></td>
<td align=center></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Subtotal Based Discount.</b></font><br><$admin_small_font>Will be applied to subtotal of order. Example:<br>Value (%): 0=10,50=20<br>Result: 20% discount on orders over ${currsymbol}49.99, otherwise 10% discount.</font></td>
<td align=center><input type=radio name="discount_per" value=total></td>
<td align=center><input type=number size=20 name="discount_value_flat" value=></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Item Quantity Based Discount.</b></font><br><$admin_small_font>Will be applied to item total. Example:<br>Value ($currsymbol): 2=0.75,5=1.25<br>Result: 1 item = full prize, 2-4 items = ${currsymbol}0.75 off item prize, 5 or more items = ${currsymbol}1.25 off item prize</font></td>
<td align=center><input type=radio name="discount_per" value=qty></td>
<td align=center><input type=number size=20 name="discount_value_flat" value=></td>
</tr>


</table></td></tr></table></td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3 align=center><$admin_font>Please set <b>Commerce Sales Permissions</b> for this group:</font><br></td></tr>

<tr><td colspan=3>
<table border=0 cellspacing=0 cellpadding=0 width="600" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Allow members to sell their uploaded items.</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Select</b></font></td>
<td align=center width="10%" nowrap><$admin_font color="#ffffff"><b>Profit (%)</b></font></td></tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>No sales of items allowed.</b></font></td>
<td align=center><input type=radio name="sales_per" value=no checked></td>
<td align=center></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Sell items but profit goes 100% to store.</b></font></td>
<td align=center><input type=radio name="sales_per" value=yes></td>
<td align=center></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Sell items set by "Category Pricing" *</b></font><br><$admin_small_font>Members can sell the same products as the store.</font></td>
<td align=center><input type=radio name="sales_per" value=category></td>
<td align=center><input type=number size=3 name="sales_per_category" value=0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Sell custom items *</b></font><br><$admin_small_font>You will be asked to specify list of items after this group is created.</font></td>
<td align=center><input type=radio name="sales_per" value=custom></td>
<td align=center><input type=number size=3 name="sales_per_custom" value=0></td>
</tr>

</table></td></tr></table><$admin_small_font>* The set prices are considered minimum prices (think overhead). Everything a member puts on top of that the store will get a percentage of. Example: If a 4x6 is listed as ${currsymbol}0.40 and a member increases that price to ${currsymbol}1.00 and you have the store profit set to 20% then this will be the payout:<br>Store: ${currsymbol}0.40 + (${currsymbol}1.00 - ${currsymbol}0.40) * 20% = ${currsymbol}0.52<br>Owner: ${currsymbol}1.00 - ${currsymbol}0.52 = ${currsymbol}0.48</font></td></tr>


<tr><td colspan=3>&nbsp;</td></tr>
-->|;
}

print qq|
</table>

<br><input type=submit value="Modify Group">&nbsp;<input type=reset value="Cancel">

</td></tr></table></td></tr></table>



</td></tr></table>

</center>
</form>
|;

&get_footer;
}

###############################################################################
# DELETE USER
# Opens the user database and builds a select box of all users
###############################################################################
sub delete_group {

$DELETEGROUP = "active";

if ($userstep eq "final" && $ifgroup) {
   &get_user;
   unless ($admin_demo_mode){
      open (GROUPDB,">$groupdb") or &Error("Can't Open $groupdb: $!");
      if ($useflock) { flock(GROUPDB, 2); }
      print GROUPDB "$new_group_db";
      if ($useflock) { flock(GROUPDB, 8); }
      close(GROUPDB);
      eval qq{ require "$libpath/zoomify.pl"; };
      &ifz_write_settings($ifgroup, 1) if $using_zoomify;
   }
   $comment = qq|<$admin_font><b>The group <font color=red>$ifgroup</font> has been deleted.<b></font><br><br>|;
}

$pagetitle = "Delete Group - Select A Group";
&get_header;
&get_group_list;

print qq|$comment

<form method=get action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="gallery_group.pl">
<input type=hidden name=useraction value="delete">
<input type=hidden name=userstep value=final>

<center>

<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">

<tr><td>

<table border="0" width="100%" cellspacing=1 cellpadding=0>
<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Delete Group</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 1</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee"><td align=center>$grouplist</td></tr></table></td></tr></table>

<br><input type=submit value="Delete Group">

</center>

</form>
|;

&get_footer;
}

###############################################################################
# GET USER LIST
# Opens the user database and builds a select box of all users
###############################################################################
sub get_user {

   if ($useraction eq "modify" && $userstep eq "final") {
       $group_group_name =~ s/[$deny_chars]//g;
      $glength = length($group_group_name);
   }

   open (GROUPDB,"$groupdb") or &Error("Can't Open $groupdb: $!");
   my (@LINES)=<GROUPDB>;
   close(GROUPDB);
   chomp @LINES;

   @LINES = sort { lc($a) cmp lc($b) } @LINES;
   foreach $line (@LINES) {
      next unless $line;
      ($groupname) = split(/\|/, $line);
      if ($groupname eq $ifgroup) {
         &split_if_groupline($line);
      }
      else {
         $new_group_db .= "$line\n" ;
      }
   }

   if ($group_default)               {$group_default_checked    = " checked"; }
   if ($group_preview_view_per)      { $preview_view_per_1      = " checked"; } else { $preview_view_per_0      = " checked"; }
   if ($group_preview_protect_per)   { $preview_protect_per_1   = " checked"; } else { $preview_protect_per_0   = " checked"; }
   if ($group_watermark_per)         { $watermark_per_1         = " checked"; } else { $watermark_per_0         = " checked"; }
   if ($group_full_size_per)         { $full_size_per_1         = " checked"; } else { $full_size_per_0         = " checked"; }
   if ($group_media_upload_per)      { $media_upload_per_1      = " checked"; } else { $media_upload_per_0      = " checked"; }
   if ($group_media_main_cat_per)    { $media_main_cat_per_1    = " checked"; } else { $media_main_cat_per_0    = " checked"; }
   if ($group_media_upload_approval) { $media_upload_approval_1 = " checked"; } else { $media_upload_approval_0 = " checked"; }
   if ($group_media_ren_per)         { $media_ren_per_1         = " checked"; } else { $media_ren_per_0         = " checked"; }
   if ($group_media_mov_per)         { $media_mov_per_1         = " checked"; } else { $media_mov_per_0         = " checked"; }
   if ($group_media_del_per)         { $media_del_per_1         = " checked"; } else { $media_del_per_0         = " checked"; }
   if ($group_media_desc_per)        { $media_desc_per_1        = " checked"; } else { $media_desc_per_0        = " checked"; }
   if ($group_media_fs_per)          { $media_fs_per_1          = " checked"; } else { $media_fs_per_0          = " checked"; }
   if ($group_cat_add_per)           { $cat_add_per_1           = " checked"; } else { $cat_add_per_0           = " checked"; }
   if ($group_cat_ren_per)           { $cat_ren_per_1           = " checked"; } else { $cat_ren_per_0           = " checked"; }
   if ($group_cat_move_per)          { $cat_move_per_1          = " checked"; } else { $cat_move_per_0          = " checked"; }
   if ($group_cat_del_per)           { $cat_del_per_1           = " checked"; } else { $cat_del_per_0           = " checked"; }
   if ($group_cat_upload_per)        { $cat_upload_per_1        = " checked"; } else { $cat_upload_per_0        = " checked"; }
   if ($group_cat_desc_per)          { $cat_desc_per_1          = " checked"; } else { $cat_desc_per_0          = " checked"; }
   if ($group_media_mod_per==1)      { $media_mod_per_1         = " checked"; } elsif ($group_media_mod_per==2) { $media_mod_per_2         = " checked"; } else { $media_mod_per_0          = " checked"; }

}

###############################################################################
# GALLERY LIST
###############################################################################

sub category_list_old {
   $selected = ();

#   if (!-d "$image_directory/$main_users_cat" && $main_users_cat) {
#      mkdir ("$image_directory/$main_users_cat", "0777") or &Error("Unable to create category, $image_directory/$main_users_cat.  Reason: $!");
#      chmod(0777,"$image_directory/$main_users_cat") or &Error("Could not set permissions on category, $image_directory/$main_users_cat.  Reason: $!");
#   }

   opendir (DIR, $image_directory) or &Error("Error Reading Directory:", "$!");
   @files = readdir(DIR);
   closedir (DIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   @alldirectories = ();
   foreach $file (@files) {
      if ( -d "$image_directory/$file" ) {                   #make sure this really is a directory
         chop $file if ($file =~ /\/$/);
         next if $file =~ /^\.\.?$/;                         #weed out all .. directories
         next if $file =~ /_vti_cnf/i;                       #weed out front page directories
         push(@alldirectories, $file);
      }
   }
   $size = @alldirectories+1;
   @current_cat_access = split(/::/,$group_cat_access);
   if ($group_cat_access eq 'All') {
      $selected = " selected";
   }
   $pulldown_menu = qq|<select name="direct_permission" size="$size" multiple><option value="All"$selected> - All Categories</option>|;
   foreach $directory (@alldirectories) {
      $selected = "";
      foreach $each_cat_access (@current_cat_access) {
         if ($each_cat_access eq $directory) {
            $selected = " selected";
            last;
         }
      }
      $mydirectory = $directory;
      $mydirectory =~ s/_/ /g;
      $pulldown_menu .= qq|<option value="$directory"$selected> - $mydirectory</option>|;
   }
   $pulldown_menu .= qq|$catlist</select>|;
}

sub category_list {
   $selected = ();
   open (FILE,"$catfile") or &search_error("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   @LINES = sort(@LINES);
   close(FILE);
   chomp @LINES;
   $size = @LINES+1;


   @current_cat_access = split(/::/,$group_cat_access);
   foreach $each_cat_access (@current_cat_access) {
      $CAT_ACCESS{"$each_cat_access"} = 1;
   }

   if ($main_users_cat && $using_picturepost_mod) {
      $selected = " selected" if $CAT_ACCESS{'PERSONAL_CATEGORY'};
      $pulldown_menu = qq|<option value="PERSONAL_CATEGORY"$selected>[PERSONAL_CATEGORY]</option>|;
      $size = $size+1;
      $selected = ();
   }

   $size = 20 if $size > 20;


   $selected = " selected" if $group_cat_access eq 'All';

   $pulldown_menu = qq|<select name="direct_permission" size="$size" multiple><option value="All"$selected>All Categories</option>$pulldown_menu|;


   foreach $LINE (@LINES) {
      $selected = ();
      my $space = ();
      my ($category, $imagecount) = split(/\t/, $LINE);
      my @categories = split (/\//, $category);
      $mydirectory = get_clean_name(pop @categories);
      foreach my $cat (@categories) {
         $space .= "......";
      }
      $mydirectory = get_clean_name($mydirectory);
      $selected = " selected" if $CAT_ACCESS{"$category"};
      $pulldown_menu .= qq|<option value="$category"$selected>$space$mydirectory</option>|;
   }
   $pulldown_menu .= qq|</select>|;

}

sub content_list {
   $selected = ();

   @files = ();
   @additional_content = ();
   opendir (DIR, "$base_if_path/additional_content");
   @files = readdir(DIR);
   closedir (DIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   foreach $file (@files) {
      if (!-d "$base_if_path/additional_content/$file" && !-B "$base_if_path/additional_content/$file" && lc($file) ne "index.html") {
         chop $file if ($file =~ /\/$/);
         push(@additional_content, $file);
      }
   }
   if (!@additional_content) {
      $content_menu = qq|<$admin_font><i>No additional content available</i></font>|;
   }
   else {
      $size = @additional_content+2;
      @current_content_access = split(/::/,$group_content_access);
      if ($group_content_access eq 'All') {
         $selected_all = " selected";
      }
      elsif (!$group_content_access) {
         $selected_none = " selected";
      }
      $content_menu = qq|<select name="content_menu" size="$size" multiple><option value="All"$selected_all> - All Additional Content</option><option value=""$selected_none> - None Additional Content</option>|;
      foreach $content (@additional_content) {
         $selected = "";
         foreach $each_content_access (@current_content_access) {
            if ($each_content_access eq $content) {
               $selected = " selected";
               last;
            }
         }
         $content_menu .= qq|<option value="$content"$selected> - $content</option>|;
      }
      $content_menu .= qq|$catlist</select>|;
   }
#   $content_menu = ();
}

###############################################################################
# POST LIST
###############################################################################

sub post_category_list_old {

   @files = ();
   @alldirectories = ();
   opendir (DIR, $image_directory) or &Error("Error Reading Directory:", "$!");
   @files = readdir(DIR);
   closedir (DIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   foreach $file (@files) {
      if ( -d "$image_directory/$file" ) {                   #make sure this really is a directory
         chop $file if ($file =~ /\/$/);
         next if $file =~ /^\.\.?$/;                         #weed out all .. directories
         next if $file =~ /_vti_cnf/i;                       #weed out front page directories
         push(@alldirectories, $file);
      }
   }
   $size = @alldirectories+1;
   @current_post_access = split(/::/,$group_post_access);
   $selected = "";
   if ($main_users_cat) {
      if ($group_post_access eq 'PERSONAL_CATEGORY') {
         $selected = " selected";
      }
      $post_personal_cat = qq|<option value="PERSONAL_CATEGORY"$selected>- [PERSONAL_CATEGORY]</option>|;
      $size = $size+1;
      $selected = "";
   }
   if ($group_post_access eq 'All') {
      $selected = " selected";
   }
   $post_pulldown_menu = qq|<select name="post_direct_permission" size="$size" multiple><option value="All"$selected> - All Categories</option>|;
   $selected = "";
#   if ($group_post_access eq 'PERSONAL_CATEGORY') {
#      $selected = " selected";
#   }
#   $post_pulldown_menu .= qq|<option value="PERSONAL_CATEGORY"$selected>- [PERSONAL_CATEGORY]</option>|;
   $post_pulldown_menu .= $post_personal_cat;
   foreach $directory (@alldirectories) {
      $selected = "";
      foreach $each_post_access (@current_post_access) {
         if ($each_post_access eq $directory) {
            $selected = " selected";
            last;
         }
      }
      $mydirectory = $directory;
      $mydirectory =~ s/_/ /g;
      $post_pulldown_menu .= qq|<option value="$directory"$selected> - $mydirectory</option>|;
   }
   $post_pulldown_menu .= qq|$catlist</select>|;
}

sub post_category_list {
   $selected = ();
   open (FILE,"$catfile") or &search_error("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   @LINES = sort(@LINES);
   close(FILE);
   chomp @LINES;
   $size = @LINES+1;

   @current_post_access = split(/::/,$group_post_access);
   foreach $each_post_access (@current_post_access) {
      $POST_ACCESS{"$each_post_access"} = 1;
   }

   if ($main_users_cat) {
      $selected = " selected" if $POST_ACCESS{'PERSONAL_CATEGORY'};
      $post_pulldown_menu = qq|<option value="PERSONAL_CATEGORY"$selected>[PERSONAL_CATEGORY]</option>|;
      $size = $size+1;
      $selected = ();
   }


   $size = 20 if $size > 20;

   $selected = " selected" if $group_post_access eq 'All';

   $post_pulldown_menu = qq|<select name="post_direct_permission" size="$size" multiple><option value="All"$selected>All Categories</option>$post_pulldown_menu|;


   foreach $LINE (@LINES) {
      $selected = ();
      my $space = ();
      my ($category, $imagecount) = split(/\t/, $LINE);
      my @categories = split (/\//, $category);
      $mydirectory = get_clean_name(pop @categories);
      foreach my $cat (@categories) {
         $space .= "......";
      }
      $mydirectory = get_clean_name($mydirectory);
      $selected = " selected" if $POST_ACCESS{"$category"};
      $post_pulldown_menu .= qq|<option value="$category"$selected>$space$mydirectory</option>|;
   }
   $post_pulldown_menu .= qq|</select>|;

}

###############################################################################
# SKIN OPTIONS
###############################################################################
sub find_skin_options {

   @files = ();
   @skins = ();
   opendir (SKINDIR, "$base_if_path/skins") or &Error("Can't Open $midi_directory: $!");
   @files = readdir(SKINDIR);
   closedir (SKINDIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   foreach $file (@files) {
      if ( -d "$base_skin_dir/$file" ) {                   #make sure this really is a directory
         chop $file if ($file =~ /\/$/);
         next if $file =~ /^\.\.?$/;                         #weed out all .. directories
         next if $file =~ /_vti_cnf/i;                       #weed out front page directories
         push(@skins, $file);
      }
   }
   $size = @skins+1;

   $skin_choices = qq|<select name="skins" size="$size">|;
   $skin_selected = " selected" if !$group_skins_access;
   $skin_choices .= qq|<option value=""$skin_selected>- Default skin ($skin_name)</option>|;


   foreach $skin (@skins) {
      $skin_selected = ();
      if ($group_skins_access eq $skin) {
         $skin_selected = " selected";
      }
      $myskin = $skin;
      $myskin =~ s/_/ /g;
      $skin_choices .= qq|<option value="$skin"$skin_selected>- $myskin</option>|;
   }

   $skin_choices .= qq|</select>|;

}

###############################################################################
# GET USER LIST
# Opens the user database and builds a select box of all users
###############################################################################
sub get_group_list {
  my @rows = ();
   open (GROUPDB, "$groupdb");
      while (<GROUPDB>) {
         chomp;
         /^#/      and next;        # Skip comment Lines.
         /^\s*$/   and next;        # Skip blank lines.
         push(@rows, $_);
      }
   close (GROUPDB);

@rows = sort { lc($a) cmp lc($b) } @rows;
my $size = @rows;

$grouplist = qq|<select name="ifgroup" size=$size>|;

foreach $group (@rows) {
   &split_if_groupline($group);
   if ($group_default) {
      $this_default = " (default)";
   }
   $grouplist .= qq|<option value="$group_group_name">$group_group_name$this_default</option>|;
   $this_default = "";
}

   $grouplist .= qq|</select>|;
}

1;
