####CODEHEADER###

$ADDNEWGROUP = "active";



#require "$currdir/admin/init.pl";
require "$config_directory/users_config.pl";

#&parse_this_form;

   require "$libpath/users_access.pl";
   if ($using_picturepost_mod) {
      require "$config_directory/post_config.pl";
   }

   if (!$is_admin) {
      print "Content-type: text/html\n\n";
      print qq|<html><head><meta http-equiv="refresh" content="0 ;url=$adminurl"></head></html>|;
      exit;
   }

#if ($FORM{'action'}) { &step_two; }
#else                      { &category_list; &content_list; &find_skin_options; &step_one; }



###############################################################################
# STEP ONE
# called if we haven't added a user yet
###############################################################################
sub step_one {

$pagetitle = "Add New Group";

   &category_list;
   &content_list;
   &find_skin_options;


if (!-e "$groupdb") {
   open(GROUPDB,">$groupdb") or &Error("Can't Open Group Database: $!");
   print GROUPDB "";
   close(GROUPDB);
   chmod(0777,"$groupdb");

   $suggest_guest = qq|If you set the Group Name to &quot;$guest_username&quot; then people who have not logged in will receive these permissions. 
   Without a &quot;$guest_username&quot; account, everyone will see a login prompt before they can view the gallery.|;
}


&get_header;


if ($using_picturepost_mod && $main_users_cat) {
   $personal__view_cat_text1 = qq|<br>If you select [PERSONAL_CATEGORY] then each member of this group will only see their own category in the <b>$main_users_cat</b> category. The name of the subcategory will be the same as the username of this group member.|;
}


print qq|

<form method=post action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=cgi value="gallery_group_setup.pl">
<input type=hidden name=newaction value="addgroup">
<input type=hidden name=uid value="$FORM{'uid'}">


<center>


<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr>
<td align=center>

<table border=0 cellspacing=0 cellpadding=0 width="100%" bgcolor="#000000"><tr>
<td align=center valign=middle>

<table border=0 cellspacing=1 cellpadding=0 width="100%" bgcolor="#000000">


<tr bgcolor="#ffcc00"><td>

<table border="0" width="100%" cellspacing=0 cellpadding=4>
<tr><td><$admin_big_font><b>Gallery Group Setup</b></font></td>
<td align=right><$admin_big_font><b>Step 1 of 1</b></font></td>
</tr></table></td></tr>

<tr bgcolor="#eeeeee">
<td align=center>

<br><table border=0 cellspacing=0 cellpadding=7 width="600">


<tr><td align=right><$admin_font><b>Group name</b></font></td>
<td><input type=text maxlength=20 name="group_name" size=20></td>
<td><$admin_small_font>$suggest_guest</font></td></tr>

<tr><td align=right><$admin_font><b>Short Description</b></font></td>
<td colspan=2><textarea name="short_desc" rows="4" cols="30"></textarea></td>
</tr>

<tr><td align=right><$admin_font><b>Default</b></font></td>
<td><input type="checkbox" name="default"></td>
<td><$admin_small_font>New users that have setup their own account or users from bulletin boards will get the permissions of the default group.</font></td>

</tr>

<tr><td align=right><$admin_font><b>Skin Choices</b></font></td>
<td>$skin_choices</td>
<td><$admin_small_font>Select the skin you want to use for this group.</font></td>
</tr>

<tr><td align=right nowrap><$admin_font><b>View Categories</b></font></td>
<td>$pulldown_menu</td>
<td><$admin_small_font>Select the categories that this group can view. Hold down [CTRL] on Windows and [Apple] on Macintosh computers to select multiple.$personal__view_cat_text1</font></td>
</tr>

<!--<tr><td align=right nowrap><$admin_font><b>View Additional Content</b></font></td>
<td>$content_menu</td>
<td><$admin_small_font>Select the additional content that this group can view. Hold down [CTRL] on Windows and [Apple] on Macintosh computers to select multiple.</font></td>
</tr>-->

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3 align=center><$admin_font>Please set <b>Gallery Permissions</b> for this group:</font><br></td></tr>

<tr><td colspan=3 align=center>
<table border=0 cellspacing=0 cellpadding=0 width="600" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Allow this group to...</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Yes</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>No</b></font></td></tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>View preview image</b> ?</font><br><$admin_small_font>If set to "No" group can only view the thumbnails.</font></td>
<td align=center><input type=radio name="preview_view_per" value=1 checked></td>
<td align=center><input type=radio name="preview_view_per" value=0></td>
</tr>|;

if ($imageprotect) {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Protect preview image</b> ?</font><br><$admin_small_font>Prevent downloading/printing of preview image.</font></td>
<td align=center><input type=radio name="preview_protect_per" value=1 checked></td>
<td align=center><input type=radio name="preview_protect_per" value=0></td>
</tr>|;
}
else {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Protect preview image</b> ?</font><br><$admin_small_font>Prevent downloading/printing of preview image.</font></td>
<td align=center colspan=2><$admin_small_font>Disabled in config.pl</font></td>
</tr>|;
}

if ($watermark) {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Show watermarked preview</b> ?</font><br><$admin_small_font>Will show the watermarked preview image.</font></td>
<td align=center><input type=radio name="watermark_per" value=1 checked></td>
<td align=center><input type=radio name="watermark_per" value=0></td>
</tr>|;
}
else {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Show watermarked preview</b> ?</font><br><$admin_small_font>Will show the watermarked preview image.</font></td>
<td align=center colspan=2><$admin_small_font>Disabled in config.pl</font></td>
</tr>|;
}

if ($use_fullsize) {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Full Size Permission</b> ?</font><br><$admin_small_font>If set to "Yes" group can download the full size file.</font></td>
<td align=center><input type=radio name="full_size_per" value=1 checked></td>
<td align=center><input type=radio name="full_size_per" value=0></td>
</tr>|;
}
else {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Full Size Permission</b> ?</font><br><$admin_small_font>If set to "Yes" group can download the full size file.</font></td>
<td align=center colspan=2><$admin_small_font>Disabled in config.pl</font></td>
</tr>|;
}

print qq|</table></td></tr></table></td></tr>|;

if ($using_picturepost_mod) {
   &post_category_list;
   if ($main_users_cat) {
      $personal_cat_text1 = qq|<br>If you select [PERSONAL_CATEGORY] then each member of this group will get their own subcateogry within the <b>$main_users_cat</b> category. The name of the subcategory will be the same as the username of this group member.|;
      $personal_cat_text2 = qq|<br>Especially usefull if you have set [PERSONAL_CATEGORY]|;
   }
   else {
      $personal_cat_text2 = qq|<br>Especially usefull if you set "\$main_users_cat" in your post_config.pl|;
   }

   print qq|
<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3 align=center><$admin_font>Please set <b>Upload Permissions</b> for this group:</font><br></td></tr>
<tr><td colspan=3 align=center>
<table border=0 cellspacing=0 cellpadding=0 width="600" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Allow this group to...</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Yes</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>No</b></font></td></tr>

<tr bgcolor="#cccccc">
<td colspan=3><$admin_small_font><b>M E D I A&nbsp;&nbsp;&nbsp;&nbsp;P E R M I S S I O N S</b></font></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Upload Media</b> ?</font></td>
<td align=center><input type=radio name="media_upload_per" value=1 checked></td>
<td align=center><input type=radio name="media_upload_per" value=0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Upload Media to main categories</b> ?</font><br>
   <$admin_small_font>If set to "No", group can only upload files to subcategories.</font></td>
<td align=center><input type=radio name="media_main_cat_per" value=1 checked></td>
<td align=center><input type=radio name="media_main_cat_per" value=0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Upload approval required</b> ?</font><br>
   <$admin_small_font>If set to "Yes", uploaded files will only be viewable after you have approved them.</font></td>
<td align=center><input type=radio name="media_upload_approval" value=1 checked></td>
<td align=center><input type=radio name="media_upload_approval" value=0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Rename Media</b> ?</font></td>
<td align=center><input type=radio name="media_ren_per" value=1 checked></td>
<td align=center><input type=radio name="media_ren_per" value=0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Move Media</b> ?</font></td>
<td align=center><input type=radio name="media_mov_per" value=1 checked></td>
<td align=center><input type=radio name="media_mov_per" value=0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Delete Media</b> ?</font></td>
<td align=center><input type=radio name="media_del_per" value=1 checked></td>
<td align=center><input type=radio name="media_del_per" value=0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Add Keywords and Captions</b> ?</font></td>
<td align=center><input type=radio name="media_desc_per" value=1 checked></td>
<td align=center><input type=radio name="media_desc_per" value=0></td>
</tr>|;

if ($use_fullsize) {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Save full size (3rd image)</b> ?</font></td>
<td align=center><input type=radio name="media_fs_per" value=1 checked></td>
<td align=center><input type=radio name="media_fs_per" value=0></td>
</tr>|;
}
else {
   print qq|
<tr bgcolor="#ffffff">
<td><$admin_font><b>Save full size (3rd image)</b> ?</font></td>
<td align=center colspan=2><$admin_small_font>Disabled in config.pl</font></td>
</tr>|;
}




print qq|
<tr bgcolor="#cccccc">
<td colspan=3><$admin_small_font><b>M E D I A&nbsp;&nbsp;&nbsp;&nbsp;M O D I F I C A T I O N&nbsp;&nbsp;&nbsp;&nbsp;P E R M I S S I O N S</b><br>Allow members of this group to rename/move/delete/keyword media uploaded by:</font></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>This member only</b></font></td>
<td align=center colspan=2><input type=radio name="media_mod_per" value=0 checked></td>
</tr>
<!--
<tr bgcolor="#ffffff">
<td><$admin_font><b>Any member of this group</b></font></td>
<td align=center colspan=2><input type=radio name="media_mod_per" value=2></td>
</tr>
-->
<tr bgcolor="#ffffff">
<td><$admin_font><b>Anyone</b></font></td>
<td align=center colspan=2><input type=radio name="media_mod_per" value=1></td>
</tr>

<tr bgcolor="#cccccc">
<td colspan=3><$admin_small_font><b>C A T E G O R Y&nbsp;&nbsp;&nbsp;&nbsp;P E R M I S S I O N S</b>$personal_cat_text2</font></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Add Categories</b> ?</font></td>
<td align=center><input type=radio name="cat_add_per" value=1></td>
<td align=center><input type=radio name="cat_add_per" value=0 checked></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Rename Categories</b> ?</font></td>
<td align=center><input type=radio name="cat_ren_per" value=1></td>
<td align=center><input type=radio name="cat_ren_per" value=0 checked></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Move Categories</b> ?</font></td>
<td align=center><input type=radio name="cat_move_per" value=1></td>
<td align=center><input type=radio name="cat_move_per" value=0 checked></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Delete Categories</b> ?</font></td>
<td align=center><input type=radio name="cat_del_per" value=1></td>
<td align=center><input type=radio name="cat_del_per" value=0 checked></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Upload Category Image</b> ?</font></td>
<td align=center><input type=radio name="cat_upload_per" value=1></td>
<td align=center><input type=radio name="cat_upload_per" value=0 checked></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Add Category Description</b> ?</font></td>
<td align=center><input type=radio name="cat_desc_per" value=1></td>
<td align=center><input type=radio name="cat_desc_per" value=0 checked></td>
</tr>
</table></td></tr></table></td></tr>


<tr><td colspan=3>&nbsp;</td></tr>
<tr><td align=right nowrap><$admin_font><b>Upload Categories</b></font></td>
<td>$post_pulldown_menu</td>
<td><$admin_small_font>If you have set upload permission to "yes" then select the categories that this group can upload to. Hold down [CTRL] on Windows and [Apple] on Macintosh computers to select multiple.$personal_cat_text1</font></td>
</tr>

<tr><td colspan=3>&nbsp;</td></tr>|;

eval qq{ require "$libpath/zoomify.pl"; };
if ($using_zoomify) {
   print qq|<tr><td colspan=3 align=center><$admin_font>Please set <b>Zoomify Permissions</b> for this group:</font><br></td></tr><tr><td colspan=3 align=center>|;
   print &ifz_settings_table;
   print qq|</td></tr>|;
}

print qq|
<!--

<tr><td colspan=3 align=center><$admin_font>Please set <b>Commerce Purchase Permissions</b> for this group:</font><br></td></tr>

<tr><td colspan=3 align=center>
<table border=0 cellspacing=0 cellpadding=0 width="600" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Allow users to upgrade to this group.</b><br>Select none if only Administrators can upgrade accounts.</font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Select</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Cost ($currsymbol)</b></font></td></tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Free Upgrade.</b></font><br><$admin_small_font>Users can freely upgrade to this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=free></td>
<td align=center></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Weekly payment.</b></font><br><$admin_small_font>User needs to pay weekly to stay in this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=week></td>
<td align=center><input type=number size=6 name="upgrade_per_week" value=1.00></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Monthly payment.</b></font><br><$admin_small_font>User needs to pay monthly to stay in this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=month></td>
<td align=center><input type=number size=6 name="upgrade_per_month" value=5.00></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Yearly payment.</b></font><br><$admin_small_font>User needs to pay yearly to stay in this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=year></td>
<td align=center><input type=number size=6 name="upgrade_per_year" value=50.00></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>One payment.</b></font><br><$admin_small_font>After user pays he stays member of this group.</font></td>
<td align=center><input type=checkbox name="upgrade_per" value=once></td>
<td align=center><input type=number size=6 name="upgrade_per_once" value=100.00></td>
</tr>

</table></td></tr></table></td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3 align=center>
<table border=0 cellspacing=0 cellpadding=0 width="600" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Discounts applied to members of this group.</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Select</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Value (<select name="discount_type"><option value=p>%<option value=s>$currsymbol</select>)</b></font></font></td></tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>No Discount.</b></font><br><$admin_small_font>No discounts will be applied.</font></td>
<td align=center><input type=radio name="discount_per" value=no checked></td>
<td align=center></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Subtotal Based Discount.</b></font><br><$admin_small_font>Will be applied to subtotal of order. Example:<br>Value (%): 0=10,50=20<br>Result: 20% discount on orders over ${currsymbol}49.99, otherwise 10% discount.</font></td>
<td align=center><input type=radio name="discount_per" value=total></td>
<td align=center><input type=number size=20 name="discount_value_flat" value=></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Item Quantity Based Discount.</b></font><br><$admin_small_font>Will be applied to item total. Example:<br>Value ($currsymbol): 2=0.75,5=1.25<br>Result: 1 item = full prize, 2-4 items = ${currsymbol}0.75 off item prize, 5 or more items = ${currsymbol}1.25 off item prize</font></td>
<td align=center><input type=radio name="discount_per" value=qty></td>
<td align=center><input type=number size=20 name="discount_value_flat" value=></td>
</tr>


</table></td></tr></table></td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3 align=center><$admin_font>Please set <b>Commerce Sales Permissions</b> for this group:</font><br></td></tr>

<tr><td colspan=3>
<table border=0 cellspacing=0 cellpadding=0 width="600" bgcolor="#000000"><tr><td align=center valign=middle>
<table border=0 cellspacing=1 cellpadding=4 width="100%"><tr bgcolor="#ff0000">
<td width="80%"><$admin_font color="#ffffff"><b>Allow members to sell their uploaded items.</b></font></td>
<td align=center width="10%"><$admin_font color="#ffffff"><b>Select</b></font></td>
<td align=center width="10%" nowrap><$admin_font color="#ffffff"><b>Profit (%)</b></font></td></tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>No sales of items allowed.</b></font></td>
<td align=center><input type=radio name="sales_per" value=no checked></td>
<td align=center></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Sell items but profit goes 100% to store.</b></font></td>
<td align=center><input type=radio name="sales_per" value=yes></td>
<td align=center></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Sell items set by "Category Pricing" *</b></font><br><$admin_small_font>Members can sell the same products as the store.</font></td>
<td align=center><input type=radio name="sales_per" value=category></td>
<td align=center><input type=number size=3 name="sales_per_category" value=0></td>
</tr>

<tr bgcolor="#ffffff">
<td><$admin_font><b>Sell custom items *</b></font><br><$admin_small_font>You will be asked to specify list of items after this group is created.</font></td>
<td align=center><input type=radio name="sales_per" value=custom></td>
<td align=center><input type=number size=3 name="sales_per_custom" value=0></td>
</tr>

</table></td></tr></table><$admin_small_font>* The set prices are considered minimum prices (think overhead). Everything a member puts on top of that the store will get a percentage of. Example: If a 4x6 is listed as ${currsymbol}0.40 and a member increases that price to ${currsymbol}1.00 and you have the store profit set to 20% then this will be the payout:<br>Store: ${currsymbol}0.40 + (${currsymbol}1.00 - ${currsymbol}0.40) * 20% = ${currsymbol}0.52<br>Owner: ${currsymbol}1.00 - ${currsymbol}0.52 = ${currsymbol}0.48</font></td></tr>


<tr><td colspan=3>&nbsp;</td></tr>
-->|;

}

print qq|
</table>

<br><input type=submit value="Add Group"><br><br>

</td></tr></table></td></tr></table>

<br><br>


</td></tr></table><br>

</center>
</form>
|;

&get_footer;
}


###############################################################################
# STEP TWO
# add a username and password to the database
###############################################################################
sub step_two {

   if ($FORM{'action'} eq "modified") {
      $ADDNEWGROUP = "";
      $MODIFYGROUP = "active";
   }

   &parse_group_form;

   &load_these_values;

   $group_group_name =~ s/[$deny_chars]//g;
   $glength = length($group_group_name);

# WE MAKE SURE THAT THIS USERNAME IS AVAILABLE FIRST

   open (GROUPDB,"$groupdb") or &Error("Can't Open $groupdb: $!");
   my (@LINES)=<GROUPDB>;
   close(GROUPDB);
   chomp @LINES;

   if ($FORM{'action'} ne "modified") {
      foreach $line (@LINES) {
         my ($groupname) = split(/\|/, $line);
         if (lc($groupname) eq lc($group_group_name)) {
            print &Error('The groupname you requested is already in use.');
         }
      }
   }

   if    (!$group_group_name)  { print &Error('You must enter a groupname.');                       exit; }
#   elsif ($glength < 5)        { print &Error('Your groupname must be at least five characters.');  exit; }


# HERE WE SAVE ALL OF THE PERSONAL INFORMATION FOR THE USER IN THE USER'S DATABASE AND MAKE SURE THERE IS ONLY 1 DEFAULT

   &populate_if_groupline;
   $new_if_groupline = $if_groupline;
   $check_group_default = $group_default;


   opendir (GROUPSESSIONS, "$sessions_dir") || die "CCan't Open $sessions_dir: $!\n";
   my @group_sessions = grep { /\.group$/ } readdir(GROUPSESSIONS);
   closedir (GROUPSESSIONS);
   foreach (@group_sessions){
      $GROUPSESSIONS{$_} = 1;
   }

   if (($check_group_default) or ($FORM{'action'} eq "modified")) {
      open (GROUPDB,">$groupdb") or print &Error('Could not open the group database!') unless $admin_demo_mode;
      if ($useflock) {
         flock(GROUPDB, 2) unless $admin_demo_mode;
      }
      foreach $line (@LINES) {
         &split_if_groupline($line);
         if ($check_group_default) {
            $group_default = 0;
         }
         if ($FORM{'action'} eq "modified") {
            if ($FORM{'ifgroup'} eq $group_group_name) {
               if ($group_default && !$check_group_default) {
                  $no_default = "<br><br>Note: You currently have no default group. Users can not selfregister (or login through 3rd party software).";
               }
               &split_if_groupline($new_if_groupline);
               if ($FORM{'ifgroup'} ne $group_group_name) {
                  require "$db_link_path/$db_link_file";
                  open (USERDB, "$userdb");
                  my (@USERDB)=<USERDB>;
                  close (USERDB);
                  chomp @USERDB;
                  my @USERDB_NAMES = split(/\t/, $USERDB[0]);
                  my $cntun = 0;
                  foreach my $USERDB_NAME (@USERDB_NAMES) {
                     if ($USERDB_NAME eq $IF_VAL{'ifgroup'}) {
                        $ifgrouploc = $cntun;
                        last;
                     }
                     $cntun++;
                  }
                  if (defined $ifgrouploc) {
                     $accountline = "$USERDB[0]\n";
                     my $SIZE = @USERDB;
                     for ($i=1;$i<=$SIZE;$i++) {
                        next unless $USERDB[$i];
                        my @USERDB_VALUES = split(/\t/, $USERDB[$i]);
                        if ($USERDB_VALUES[$ifgrouploc] eq $FORM{'ifgroup'}) {
                           my $cnteu = 0;
                           foreach my $USERDB_NAME (@USERDB_NAMES) {
                              if ($cnteu == $ifgrouploc) {
                                 $accountline .= $group_group_name . "\t";
                              }
                              else {
                                 $accountline .= "$USERDB_VALUES[$cnteu]\t";
                              }
                              $cnteu++;
                           }
                           $accountline =~ s/\t$/\n/ig;
                        }
                        else {
                           $accountline .= "$USERDB[$i]\n";
                        }
                     }
                     open(ADDUSERDB, ">$userdb");
                     print ADDUSERDB $accountline;
                     close(ADDUSERDB);
                     chmod(0777, $userdb);
                  }
               }
            }
         }
         &populate_if_groupline;
         unless ($admin_demo_mode) {
            $GROUPSESSIONS{"$group_group_name.group"} = 0;
            print GROUPDB "$if_groupline\n";
            open (GROUPDBSESSION,">$sessions_dir/$group_group_name.group") or print &Error('Could not open the group session!');
            if ($useflock) { flock(GROUPDBSESSION, 2); }
            print GROUPDBSESSION "$if_groupline\n";
            if ($useflock) { flock(GROUPDBSESSION, 8); }
            close(GROUPDBSESSION);
            chmod(0777,"$sessions_dir/$group_group_name.group");
         }
      }
      if ($useflock) {
         flock(GROUPDB, 8) unless $admin_demo_mode;
      }
      close(GROUPDB) unless $admin_demo_mode;
      unless ($admin_demo_mode) {
         foreach $key (sort keys %GROUPSESSIONS) {
            unlink("$sessions_dir/$key") if $GROUPSESSIONS{$key};
         }
      }
   }


   if (!$check_group_default) {
      foreach $line (@LINES) {
         &split_if_groupline($line);
         $yes_default = 1 if $group_default;
      }
      $no_default = "<br><br>Note: You currently have no default group. Users can not selfregister (or login through 3rd party software)." unless $yes_default;
   }


   &split_if_groupline($new_if_groupline);

   unless ($admin_demo_mode) {
      if ($FORM{'action'} ne "modified") {
         open (GROUPDB,">>$groupdb") or print &Error('Could not open the group database!');
         if ($useflock) { flock(GROUPDB, 2); }
         print GROUPDB "$new_if_groupline\n";
         if ($useflock) { flock(GROUPDB, 8); }
         close(GROUPDB);
         chmod(0777,"$groupdb");
         open (GROUPDBSESSION,">$sessions_dir/$group_group_name.group") or print &Error('Could not open the group session!');
         if ($useflock) { flock(GROUPDBSESSION, 2); }
         print GROUPDBSESSION "$new_if_groupline\n";
         if ($useflock) { flock(GROUPDBSESSION, 8); }
         close(GROUPDBSESSION);
         chmod(0777,"$sessions_dir/$group_group_name.group");
      }
   }

   eval qq{ require "$libpath/zoomify.pl"; };

   if ($using_zoomify && !$admin_demo_mode) {
      &ifz_write_settings($FORM{'ifgroup'},'',$group_group_name);
   }



if (!$imageprotect) { $group_preview_protect_per = '0 (Disabled in config.pl)';}
if (!$watermark) { $group_watermark_per = '0 (Disabled in config.pl)';}
if (!$use_fullsize) {
   $group_full_size_per = '0 (Disabled in config.pl)';
   $group_media_fs_per  = '0 (Disabled in config.pl)';
}


if ($group_short_desc) {
    $desclength = length($group_short_desc);
    if ($desclength > 40) {
       @desc_words = split(/\s/,$group_short_desc);
       $desc_words_size = @desc_words;
       $new_short_desc = @desc_words[0];
       $temp_short_desc = @desc_words[0];
       for ($cnt=1; $cnt < $desc_words_size; $cnt++) {
          $temp_short_desc .= " @desc_words[$cnt]";
          $tempdesclength = length($temp_short_desc);
          if ($tempdesclength > 40) {
             $temp_short_desc = @desc_words[$cnt];
             $new_short_desc .= "<br>                                   @desc_words[$cnt]";
          }
          else {
             $new_short_desc .= " @desc_words[$cnt]";
          }
       }
    }
    else {
       $new_short_desc = $group_short_desc;
    }
}

&get_header;
print qq|
<center><font face="Verdana,Arial,Helvetica" size="+1"><b>Group \u$FORM{'action'} Successfully!</b></font>

<br><table border=0 cellspacing=0 cellpadding=10 width="600"><tr>

<td><$admin_font>
<b>This ImageFolio Group Account has been $FORM{'action'}.  Here is the information you provided. 
Please print or save this information for your records.$no_default</b></font><br><pre>

Group Gallery Access Information
===========================================================================
Group Name:                      = $group_group_name
Description:                     = $new_short_desc
Default                          = $group_default
Skin name                        = $group_skins_access
View category permission         = $show_cat_access
View preview image               = $group_preview_view_per
Protect preview image            = $group_preview_protect_per
Watermark preview image          = $group_watermark_per
Download full size image         = $group_full_size_per

Group Upload Access (Picture Post Mod required)
===========================================================================
Upload to cateories              = $show_post_access
Media upload permission          = $group_media_upload_per
Main category upload allowed     = $group_media_main_cat_per
Upload approval required         = $group_media_upload_approval
Media rename permission          = $group_media_ren_per
Media move permission            = $group_media_mov_per
Media delete permission          = $group_media_del_per
Media description permission     = $group_media_desc_per
Save original upload             = $group_media_fs_per
Media modification permission    = $group_media_mod_per
Add category permission          = $group_cat_add_per
Rename category permission       = $group_cat_ren_per
Move category permission         = $group_cat_move_per
Delete category permission       = $group_cat_del_per
Upload category image            = $group_cat_upload_per
Add category description         = $group_cat_desc_per


</pre><br>
</center>
|;

#View additional content          = $show_content_access

&get_footer;
}

###############################################################################
# ERROR
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{

   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$admin_font color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><$admin_font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$admin_font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$admin_font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
|;

exit;
}

###############################################################################
# LOAD VALUES
# created variables for our form information
###############################################################################
sub load_these_values {

   $group_group_name             = $FORM{'group_name'};
   $group_group_name =~ s/ /_/g;
   $group_short_desc             = $FORM{'short_desc'};
   if (!$FORM{'default'}) {
      $group_default             = '0';

   }
   else {
      $group_default             = '1';
   }
   $group_skins_access           = $FORM{'skins'};
   $group_preview_view_per       = $FORM{'preview_view_per'};
   $group_preview_protect_per    = $FORM{'preview_protect_per'};
   $group_watermark_per          = $FORM{'watermark_per'};
   $group_full_size_per          = $FORM{'full_size_per'};
   $group_media_upload_per       = $FORM{'media_upload_per'};
   $group_media_main_cat_per     = $FORM{'media_main_cat_per'};
   $group_media_upload_approval  = $FORM{'media_upload_approval'};
   $group_media_ren_per          = $FORM{'media_ren_per'};
   $group_media_mov_per          = $FORM{'media_mov_per'};
   $group_media_del_per          = $FORM{'media_del_per'};
   $group_media_desc_per         = $FORM{'media_desc_per'};
   $group_media_fs_per           = $FORM{'media_fs_per'};
   $group_cat_add_per            = $FORM{'cat_add_per'};
   $group_cat_ren_per            = $FORM{'cat_ren_per'};
   $group_cat_move_per           = $FORM{'cat_move_per'};
   $group_cat_del_per            = $FORM{'cat_del_per'};
   $group_cat_upload_per         = $FORM{'cat_upload_per'};
   $group_cat_desc_per           = $FORM{'cat_desc_per'};
   $group_media_mod_per          = $FORM{'media_mod_per'};

   $show_cat_access = $group_cat_access;
   $show_cat_access =~ s/::/, /g;
   $show_content_access = $group_content_access;
   $show_content_access =~ s/::/, /g;
   $show_post_access = $group_post_access;
   $show_post_access =~ s/::/, /g;


}

###############################################################################
# PARSE
# parses the form data
###############################################################################
sub parse_group_form {
   %FORM = ();
   foreach $pair (@formpairs) {
      ($name, $value) = split(/=/, $pair);
      $name =~ tr/+/ /;
      $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $value =~ s/<.*?>//g;
      $value =~ s/\"/\&quot\;/g;
      $value =~ s/\&/\&amp\;/g;
      $value =~ s/\.\.//;
      $value =~ s/<!--(.|\n)*-->//g;
      $value =~ s/<[\/]?[^>]*>//mig; #strip out any HTML
      $FORM{$name} = $value;
      if ($FORM{'direct_permission'}) {
         if (($FORM{'direct_permission'} eq 'All') or ($group_cat_access eq 'All')) {
            $group_cat_access = "All";
            $group_cat_access_all = 1;
         }
         elsif (!$group_cat_access_all) {
            my $this_direct_permission = ();
            my $skip_direct_permission = ();
            my @direct_permissions = split (/\//, $FORM{'direct_permission'});
            foreach my $direct_permission (@direct_permissions) {
               if ($DIRECT_PERMISSION{"${this_direct_permission}${direct_permission}"}) {
                  $skip_direct_permission = 1;
                  last;
               }
               $this_direct_permission .= "$direct_permission/";
            }
            $DIRECT_PERMISSION{$FORM{'direct_permission'}} = 1;
            $group_cat_access .= $FORM{'direct_permission'} . "::" unless $skip_direct_permission;
         }
         $FORM{'direct_permission'} = ();
      }
      elsif ($FORM{'content_menu'}) {
         if ($FORM{'content_menu'} eq 'All') {
            $group_content_access = "All";
            $group_content_access_all = 1;
         }
         elsif (!$group_content_access_all) {
            $group_content_access .= $FORM{'content_menu'} . "::";
         }
         $FORM{'content_menu'} = ();
      }
      elsif ($FORM{'post_direct_permission'}) {
         if (($FORM{'post_direct_permission'} eq 'All') or ($group_post_access eq 'All')) {
            $group_post_access = "All";
            $group_post_access_all = 1;
         }
#         elsif (!$group_post_access_all && (($FORM{'post_direct_permission'} eq 'PERSONAL_CATEGORY') or ($group_post_access eq 'PERSONAL_CATEGORY'))) {
#            $group_post_access = "PERSONAL_CATEGORY";
#         }
         elsif (!$group_post_access_all) {
            my $this_post_permission = ();
            my $skip_post_permission = ();
            my @post_direct_permissions = split (/\//, $FORM{'post_direct_permission'});
            foreach my $post_direct_permission (@post_direct_permissions) {
               if ($POST_PERMISSION{"${this_post_permission}${post_direct_permission}"}) {
                  $skip_post_permission = 1;
                  last;
               }
               $this_post_permission .= "$post_direct_permission/";
            }
            $POST_PERMISSION{$FORM{'post_direct_permission'}} = 1;
            $group_post_access .= $FORM{'post_direct_permission'} . "::" unless $skip_post_permission;
         }
         $FORM{'post_direct_permission'} = ();
      }
   }
   $group_cat_access      =~ s/::$//g;
   $group_content_access  =~ s/::$//g;
   $group_post_access     =~ s/::$//g;
}

###############################################################################
# GALLERY LIST
###############################################################################

sub category_list_old {

#   if (!-d "$image_directory/$main_users_cat" && $main_users_cat) {
#      mkdir ("$image_directory/$main_users_cat", "0777") or &Error("Unable to create category, $image_directory/$main_users_cat.  Reason: $!");
#      chmod(0777,"$image_directory/$main_users_cat") or &Error("Could not set permissions on category, $image_directory/$main_users_cat.  Reason: $!");
#   }

   @files = ();
   @alldirectories = ();
   opendir (DIR, $image_directory) or &Error("Error Reading Directory: $!");
   @files = readdir(DIR);
   closedir (DIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   foreach $file (@files) {
      if ( -d "$image_directory/$file" ) {                   #make sure this really is a directory
         chop $file if ($file =~ /\/$/);
         next if $file =~ /^\.\.?$/;                         #weed out all .. directories
         next if $file =~ /_vti_cnf/i;                       #weed out front page directories
         push(@alldirectories, $file);
      }
   }
   $size = @alldirectories+1;
   $pulldown_menu = qq|<select name="direct_permission" size="$size" multiple><option value="All" selected> - All Categories</option>|;
   foreach $directory (@alldirectories) {
      $mydirectory = $directory;
      $mydirectory =~ s/_/ /g;
      $pulldown_menu .= qq|<option value="$directory"> - $mydirectory</option>|;
   }
   $pulldown_menu .= qq|</select>|;
}

sub category_list {
   open (FILE,"$catfile") or &search_error("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   @LINES = sort(@LINES);
   close(FILE);
   chomp @LINES;
   $size = @LINES+1;

   if ($main_users_cat && $using_picturepost_mod) {
      $pulldown_menu = qq|<option value="PERSONAL_CATEGORY">[PERSONAL_CATEGORY]</option>|;
      $size = $size+1;
   }

   $size = 20 if $size > 20;

   $pulldown_menu = qq|<select name="direct_permission" size="$size" multiple><option value="All" selected>All Categories</option>$pulldown_menu|;

   foreach $LINE (@LINES) {
      my $space = ();
      my ($category, $imagecount) = split(/\t/, $LINE);
      my @categories = split (/\//, $category);
      $mydirectory = get_clean_name(pop @categories);
      foreach my $cat (@categories) {
         $space .= "......";
      }
      $mydirectory = get_clean_name($mydirectory);
      $pulldown_menu .= qq|<option value="$category">$space$mydirectory</option>|;
   }
   $pulldown_menu .= qq|</select>|;

}

sub content_list {

   @files = ();
   @additional_content = ();
   opendir (DIR, "$base_if_path/additional_content");
   @files = readdir(DIR);
   closedir (DIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   foreach $file (@files) {
      if (!-d "$base_if_path/additional_content/$file" && !-B "$base_if_path/additional_content/$file" && lc($file) ne "index.html") {
         chop $file if ($file =~ /\/$/);
         push(@additional_content, $file);
      }
   }
   if (!@additional_content) {
      $content_menu = qq|<$admin_font><i>No additional content available</i></font>|;
   }
   else {
      $size = @additional_content+2;
      $content_menu = qq|<select name="content_menu" size="$size" multiple><option value="All" selected> - All Additional Content</option><option value=""> - None Additional Content</option>|;
      foreach $content (@additional_content) {
         $content_menu .= qq|<option value="$content"> - $content</option>|;
      }
      $content_menu .= qq|</select>|;
   }
   
}


###############################################################################
# POST LIST
###############################################################################

sub post_category_list_old {

   @files = ();
   @alldirectories = ();
   opendir (DIR, $image_directory) or &Error("Error Reading Directory: $!");
   @files = readdir(DIR);
   closedir (DIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   foreach $file (@files) {
      if ( -d "$image_directory/$file" ) {                   #make sure this really is a directory
         chop $file if ($file =~ /\/$/);
         next if $file =~ /^\.\.?$/;                         #weed out all .. directories
         next if $file =~ /_vti_cnf/i;                       #weed out front page directories
         push(@alldirectories, $file);
      }
   }
   $size = @alldirectories+1;
   if ($main_users_cat) {
      $post_pulldown_menu = qq|<option value="PERSONAL_CATEGORY" selected>- [PERSONAL_CATEGORY]</option>|;
      $size = $size+1;
   }
   else {
      $post_selected = " selected";
   }
   $post_pulldown_menu = qq|<select name="post_direct_permission" size="$size" multiple><option value="All"$post_selected> - All Categories</option>$post_pulldown_menu|;
   foreach $directory (@alldirectories) {
      $mydirectory = $directory;
      $mydirectory =~ s/_/ /g;
      $post_pulldown_menu .= qq|<option value="$directory"> - $mydirectory</option>|;
   }
   $post_pulldown_menu .= qq|</select>|;
}

sub post_category_list {
   open (FILE,"$catfile") or &search_error("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   @LINES = sort(@LINES);
   close(FILE);
   chomp @LINES;
   $size = @LINES+1;

   if ($main_users_cat) {
      $post_pulldown_menu = qq|<option value="PERSONAL_CATEGORY" selected>[PERSONAL_CATEGORY]</option>|;
      $size = $size+1;
   }
   else {
      $post_selected = " selected";
   }

   $size = 20 if $size > 20;

   $post_pulldown_menu = qq|<select name="post_direct_permission" size="$size" multiple><option value="All"$post_selected>All Categories</option>$post_pulldown_menu|;


   foreach $LINE (@LINES) {
      my $space = ();
      my ($category, $imagecount) = split(/\t/, $LINE);
      my @categories = split (/\//, $category);
      $mydirectory = get_clean_name(pop @categories);
      foreach my $cat (@categories) {
         $space .= "......";
      }
      $mydirectory = get_clean_name($mydirectory);
      $post_pulldown_menu .= qq|<option value="$category">$space$mydirectory</option>|;
   }
   $post_pulldown_menu .= qq|</select>|;

}

###############################################################################
# SKIN OPTIONS
###############################################################################
sub find_skin_options {

   @files = ();
   @skins = ();
   opendir (SKINDIR, "$base_if_path/skins") or &Error("Can't Open $midi_directory: $!");
   @files = readdir(SKINDIR);
   closedir (SKINDIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   foreach $file (@files) {
      if ( -d "$base_skin_dir/$file" ) {                   #make sure this really is a directory
         chop $file if ($file =~ /\/$/);
         next if $file =~ /^\.\.?$/;                         #weed out all .. directories
         next if $file =~ /_vti_cnf/i;                       #weed out front page directories
         push(@skins, $file);
      }
   }
   $size = @skins+1;

   $skin_choices = qq|<select name="skins" size="$size">|;
   $skin_choices .= qq|<option value="" selected>- Default skin ($skin_name)</option>|;

   foreach $skin (@skins) {
#      if ($skin_name eq $skin) {
#         $skin_selected = " selected";
#      }
      $myskin = $skin;
      $myskin =~ s/_/ /g;
      $skin_choices .= qq|<option value="$skin"$skin_selected>- $myskin</option>|;
      $skin_selected = ();
   }

   $skin_choices .= qq|</select>|;

}

1;