####CODEHEADER###

   require "admin/init.pl";
   require "$config_directory/users_config.pl";
   require "$libpath/users_access.pl";
   require "$libpath/crypt.pl";

   if (!$is_admin) {
      print "Content-type: text/html\n\n";
      print qq|<html><head><meta http-equiv="refresh" content="0 ;url=$adminurl"></head></html>|;
      exit;
   }

&load_values;
if ($action eq "adduser") { &step_two; }
else                      { &group_list; &step_one; }
exit;

###############################################################################
# STEP ONE
# called if we haven't added a user yet
###############################################################################
sub step_one {

if (!-e "$userdb") {
   open(USERDB,">$userdb") or &Error("Can't Open User Database: $!");
   print USERDB "";
   close(USERDB);
   chmod(0777,"$userdb");
}

   print "Content-type: text/html\n\n";

print qq|
<html>
<head>
<title>ImageFolio Administration Gallery User Setup</title>

</head>

<body bgcolor="#ffffff">

<form method=post action="$user_setup_url">
<input type=hidden name="action" value="adduser">
<center>


<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr>
<td align=center>

<table border=0 cellspacing=0 cellpadding=0 width=600 bgcolor="#000000"><tr>
<td align=center valign=middle>

<table border=0 cellspacing=1 cellpadding=10 width=600 bgcolor="#000000"><tr bgcolor="#ffcc00">
<td align=center>

<table border=0 cellspacing=0 cellpadding=0 width="100%" bgcolor="#ffffff"><tr><td align=center>
<table border=0 cellspacing=1 cellpadding=0 width="100%"><tr bgcolor="#000000">
<td>&nbsp;&nbsp;<img src="$if_images_directory/logo.$ButtonExt" border=0 alt="ImageFolio Login" width=172 height=54></td>
</tr></table></td></tr></table>

<br>

<font face="Verdana,Arial,Helvetica" size="+1"><b>Gallery User Setup</b></font>


<br><table border=0 cellspacing=0 cellpadding=4 width="100%"><tr>

<td colspan=3>
<$admin_font>To <b>Add a New Gallery User</b> please enter
a username and password combination below.</font><br></td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td align=right><$admin_font><b>Username</b></font></td>
<td><input type=text maxlength=50 name="login" size=20></td>
<td nowrap><$admin_small_font>Min 5 characters, no spaces</font></td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3><$admin_font>A password is
required to login.  To make your administration area more secure, please use
a <b>mixed case combination of at least 5 letters and numbers.</b></font><br></td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td align=right><$admin_font><b>Password</b></font></td>
<td><input type=password maxlength=50 name="password" size=10></td>
<td nowrap><$admin_small_font>Min 5 characters</font></td></tr>

<tr><td align=right nowrap><$admin_font><b>Retype Password</b></font></td>
<td><input type=password maxlength=50 name="sec_password" size=10></td>
<td>&nbsp;</td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td colspan=3><$admin_font>Your <b>Name and Email Address
are required</b> to personalize your User Account.</font><br></td></tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td align=right><$admin_font><b>First Name</b></font></td>
<td colspan=2><input type=text maxlength=50 name="firstname" size=35></td>
</tr>

<tr><td align=right><$admin_font><b>Last Name</b></font></td>
<td colspan=2><input type=text maxlength=50 name="lastname" size=35></td>
</tr>

<tr><td align=right><$admin_font><b>Email Address</b></font></td>
<td colspan=2><input type=text maxlength=50 name="email" size=35></td>
</tr>

<tr><td colspan=3>&nbsp;</td></tr>

<tr><td align=right nowrap><$admin_font><b>Group Permission</b></font></td>
<td>$grouplist</td>
<td><$admin_small_font>Select the group permissions for this user.</font></td>
</tr>|;



print qq|
</table></td></tr></table></td></tr>


</table>

<br><input type=submit value="Add Access">

</td></tr></table></td></tr></table>

<br><br>

<br><br><hr size=1 noshade width=400>
<$admin_small_font>&copy; Copyright 1999-2007 BizSecure, Inc.<br></font>

</td></tr></table>

</center>
</form>
</body>
</html>
|;
}

sub group_list {
   open (GROUPDB, "$groupdb");
      while (<GROUPDB>) {
         chomp;
         /^#/      and next;        # Skip comment Lines.
         /^\s*$/   and next;        # Skip blank lines.
         push(@rows, $_);
      }
   close (GROUPDB);

@rows = sort { lc($a) cmp lc($b) } @rows;
my $size = @rows;

$grouplist = qq|<select name="ifgroup" size=$size>|;

foreach $group (@rows) {
   &split_if_groupline($group);
   if ($group_default) {
      $this_default = " (default)";
      $selected = " selected";
   }
   $grouplist .= qq|<option value="$group_group_name"$selected>$group_group_name$this_default</option>|;
   $this_default = "";
   $selected = "";
}

   $grouplist .= qq|</select>|;
}


###############################################################################
# STEP TWO
# add a username and password to the database
###############################################################################
sub step_two {

   $ifusername =~ s/[$deny_chars]//g;
   $plength = length($ifuserpass);
   $llength = length($ifusername);


# WE MAKE SURE THAT THIS USERNAME IS AVAILABLE FIRST

   open (FILE,"$userdb") or &Error("Can't Open $userdb: $!");
   my(@LINES)=<FILE>;
   close(FILE);
   chomp @LINES;

   foreach $line (@LINES) {
      ($username) = split(/\|/, $line);

      if (lc($username) eq lc($ifusername)) {
         print &Error('The Username you requested is already in use by another user.');
         exit;
      }
   }


   if    (!$ifusername)                 { print &Error('You must enter a Username.');                       exit; }
   elsif (!$ifemail)                    { print &Error('You must enter your Email Address.');               exit; }
   elsif (!$ifuserpass)                 { print &Error('You must enter a Password.');                       exit; }
   elsif (!$sec_password)               { print &Error('You must enter your Password twice.');              exit; }
   elsif ($sec_password ne $ifuserpass) { print &Error('Your Passwords do not match.');                     exit; }
   elsif ($plength < 5)                 { print &Error('Your Password must be at least five characters.');  exit; }
   elsif ($llength < 5)                 { print &Error('Your Username must be at least five characters.');  exit; }
   elsif (!$iffirstname)                { print &Error('You must enter your First Name.');                  exit; }
   elsif (!$iflastname)                 { print &Error('You must enter your Last Name.');                   exit; }
   elsif (!$ifgroup)                    { print &Error('You must select a group permission.');              exit; }


# BELOW WE CREATE A RANDOM DIGITAL ID FOR THE USER JUST IN CASE WE NEED TO USE IT LATER

   $ifuserid  = reverse time;
   $ifuserid  = substr($userid, 0, 4);
   $ifuserid  = $ifuserid * 1321;
   $ifuserid  = rand $ifuserid;

# HERE WE ENCRYPT THE PLAINTEXT PASSWORD

   $ifuserpass = &admin_encrypt($ifuserpass, $secret_key);

# HERE WE SAVE ALL OF THE PERSONAL INFORMATION FOR THE USER IN THE USER'S DATABASE

   &populate_if_userline;

   open (USERDB,">>$userdb") or print &Error('Could not open the user database!');
   if ($useflock) { flock(USERDB, 2); }
   print USERDB "$if_userline\n";
   if ($useflock) { flock(USERDB, 8); }
   close(USERDB);

   print "Content-type: text/html\n\n";

print qq|
<html>
<head>
<title>ImageFolio Administration User Added!</title>
</head>
<body bgcolor="#ffffff">

<center><font face="Verdana,Arial,Helvetica" size="+1"><b>User Added Successfully!</b></font>

<br><table border=0 cellspacing=0 cellpadding=10 width="600"><tr>

<td><$admin_font>
<b>This ImageFolio Access User Account has been added.  Here is the information you provided. 
Please print or save this information for your records.</b></font><br><pre>

User Authentication Information
==========================================================================
Name:               $iffirstname $iflastname
Email:              $ifemail
Username:           $ifusername
Password:           $sec_password
Login Location:     <a href="$imagefolio_url">$imagefolio_url</a>
Group Permission:   $ifgroup

</pre><br>

<table border=1 cellspacing=0 cellpadding=15 width="100%">
<tr><td align=center><$admin_font><a href="$imagefolio_url"><b>Login to Gallery</b></a><br><br>
<a href="$adminurl"><b>Login to Admin area</b></a></font></td>
</tr>
</table><br>
</td></tr></table>

</body>
</html>
|;
}

###############################################################################
# ERROR
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{

   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$admin_font color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><$admin_font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$admin_font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$admin_font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
|;

exit;
}

###############################################################################
# LOAD VALUES
# created variables for our form information
###############################################################################
sub load_values {
   $action       = $FORM{'action'};
   $ifuserpass   = $FORM{'password'};
   $sec_password = $FORM{'sec_password'};
   $iffirstname  = $FORM{'firstname'};
   $iflastname   = $FORM{'lastname'};
   $ifemail      = $FORM{'email'};
   $ifusername   = $FORM{'login'};
   $ifgroup      = $FORM{'ifgroup'};
}
