####CODEHEADER###

&get_total_disk_usage;
&get_cat_image_backup_stats;
&get_date;
&pretty_index_date;
&get_admin_group_users_stats;
&get_system_info;

if ($index_date) {
   $index_date .= " ago";
}
else {
   $index_date = "N/A";
}

###############################################################################
# GET TOTAL DISK USAGE
# Grabs our total disk usage
###############################################################################
sub get_total_disk_usage {

   if (-e $disk_usage_file) {
      
      open (FILE,"$disk_usage_file");
      my(@Usage)=<FILE>;
      close(FILE);


      foreach $Usage (@Usage) {
         chomp $Usage;
         my ($UsageKb, $IFCategory) = split(/\t/, $Usage);  

         if ($IFCategory =~ /^Total/) {
            $UsageBytes = $UsageKb * 1024;
            $UsageMb = $UsageBytes / 1048576;
            $UsageMb = sprintf("%.2f", $UsageMb);
            $total_disk_usage = commify($total_disk_usage);
            $total_disk_usage = $UsageMb . " MB";
         }      
      }
   }
   
   if (!$total_disk_usage) {
      $total_disk_usage = "N/A";
   }
}

###############################################################################
# GET CAT IMAGE BACKUP STATS
# Grabs the stats that were generated on the last rebuild index
# total categories, thumbs, and last backup date
###############################################################################
sub get_cat_image_backup_stats {

   $statsfile = "$data_directory/stats.txt";
   
   if (-e $statsfile) {   
      open (FILE,"$statsfile") or &Error("Can't Open $statsfile, is it created?: $!");
      while (<FILE>) {
         ($total_cats, $total_thumbs, $last_backup_date, $total_keywords) = split(/\|/, $_);
         ($last_backup_date, $time) = split(/ at/, $last_backup_date);
         last;
      }
      close(FILE);
      $total_cats = commify($total_cats);
      $total_thumbs = commify($total_thumbs);
      $total_keywords = commify($total_keywords);
      ($nothing, $last_backup_date, $backup_year) = split(/\, /, $last_backup_date);
      $last_backup_date .= ", " . $backup_year;
   }
   else {
      $total_cats = "N/A";
      $total_thumbs = "N/A";
      $last_backup_date = "N/A";
      $total_kewyords = "N/A";
   }
}


###############################################################################
# GET ADMIN GROUP USER STATS
# Grabs the total # of admins, groups, and users
###############################################################################
sub get_admin_group_users_stats {

   if (-e $groupdb) {
      open (FILE,"$groupdb") or &Error("Can't Open $groupdb, is it created?: $!");
      my(@StatGroups)=<FILE>;
      $total_groups = @StatGroups;
      close(FILE);
      $total_groups = commify($total_groups);
   }
   if (-e $userdb) {
      open (USERDB, "$userdb") or &Error("Can't Open $userdb, is it created?: $!");
       while (<USERDB>) {
         chomp;
         /^#/      and next;        # Skip comment Lines.
         /^\s*$/   and next;        # Skip blank lines.
         $total_users++;
      }
      close(FILE);
      $total_users-- if $total_users > 1;
      $total_users = commify($total_users);
   }
   if (-e $admindb) {
      open (FILE,"$admindb") or &Error("Can't Open $admindb, is it created?: $!");
      my(@StatAdmins)=<FILE>;
      $total_admins = @StatAdmins;
      close(FILE);
   }
   if (!$total_admins) { $total_admins = "N/A"; }
   if (!$total_users) { $total_users = "N/A"; }
   if (!$total_groups) { $total_groups = "N/A"; }
}


###############################################################################
# GET SYSTEM INFO
# Grabs the system information for this server
###############################################################################
sub get_system_info {
   $info_OS = $^O;
   if ($info_OS ne "MSWin32") {
#      if ($info_OSname = `uname -s`) {
#         $info_OS = $info_OSname;
#      }
      ($info_OSv) = split(/\:/, `uname -v`);
      #$if_os = `uname -s`;
      $if_proc_release = `uname -r`;
      $if_machine = `uname -m`;
      $if_processor = `uname -p`;
      ($if_proc_release, $nada) = split (/-/, $if_proc_release);
   }
   
   if (!$info_OS) { $info_OS = "N/A"; }
   if (!$if_machine) { $if_machine = "N/A"; }
   if (!$if_proc_release) { $if_proc_release = "N/A"; }
   if (!$if_processor) { $if_processor = "N/A"; }

}


###############################################################################
# GET DATE
# Grabs today's date
###############################################################################
sub get_date {
   @days = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
   @months = ('January','February','March','April','May','June','July',
              'August','September','October','November','December');

   ($sec,$min,$hour,$mday,$mon,$year,$wday) = localtime(time);
   if ($hour < 10) { $hour = "0$hour"; }
   if ($min < 10)  { $min  = "0$min";  }
   if ($sec < 10)  { $sec  = "0$sec";  }
   $year += 1900;
   $nowdate = "$months[$mon] $mday, $year";
   $nowtime = "$hour:$min:$sec";
}

1;