####CODEHEADER###

   sub setup_pass {
      #Choose a password to encrypt the critical data with. Leave blank for no encryption.
      $encryption_key = $secret_key;
   }

   sub setup_client {
      # This is the main configuration part. The information here will be used for the setup of the iBULC client as
      # outlined here: http://www.ibulc.com/developers/client_setup.shtml
      my $iB_version         = "1.62";
      my $iB_random          = time;
      my $iB_upload          = "$imagefolio_url?ifup=iBULC_upload_commerce";
      $iB_upload             =~ s/^https/http/ig unless $ENV{'HTTP_USER_AGENT'} =~ /win/i;
      my $iB_return          = "$imagefolio_url?direct=$category";
      my $iB_types           = $setup_types;
      my $iB_max             = 1024 * 1024 * 500;
      my $iB_original        = $setup_original;
      $iB_medium             = $setup_medium;
      $iB_small              = $setup_small;
      my $iB_field_value     = $setup_description;
      my $iB_field_name      = "Description";
      my $iB_cookie          = $setup_cookie;
#      my $iB_watermark       = "$base_if_url/$overlay_image";
      my $iB_watermark_gravity = "Center";
      my $iB_encryption      = crypt("$iB_types~$iB_max~$iB_original~$iB_medium~$iB_small~$iB_field_value~$iB_cookie~$iB_watermark", $encryption_key) if $encryption_key;
      $iB_encryption         =~ s/[^a-zA-Z0-9]//g;
      my $iB_packets         = "1";
      my $iB_bgcolor         = "eeeeee";
#      my $iB_stylesheet      = "http://www.yourdomain.com/iBULC/iBULC_stylesheet.css";
      my $iB_display         = "iframe";
      my $iB_custom_result   = "1";
      my $iB_wxh_info        = "1";
      # Now we put all this stuff together to get the iBULC setup query.
      my $iB_query = "iB_version=$iB_version;;iB_random=$iB_random;;iB_upload=$iB_upload;;iB_return=$iB_return;;iB_types=$iB_types;;iB_max=$iB_max;;iB_original=$iB_original;;iB_medium=$iB_medium;;iB_small=$iB_small;;iB_field_value=$iB_field_value;;iB_field_name=$iB_field_name;;iB_cookie=$iB_cookie;;iB_encryption=$iB_encryption;;iB_packets=$iB_packets;;iB_bgcolor=$iB_bgcolor;;iB_stylesheet=$iB_stylesheet;;iB_display=$iB_display;;iB_custom_result=$iB_custom_result;;iB_watermark=$iB_watermark;;iB_watermark_gravity=$iB_watermark_gravity;;iB_wxh_info=$iB_wxh_info";
      return $iB_query;
   }

   sub setup_upload {
      # Set the directory were the files should be uploaded to. Make sure it is writable (CHMODD 777).
      $uploaddir = $image_directory;
   }

#############################################################################################
########################################  END SETUP  ########################################
#############################################################################################

   require "$currdir/admin/init.pl";

#   require "$libpath/crypt.pl";
   if (!$is_admin) {die "only for admins";}

#   require "$libpath/iptc.pl";

   ($encryption_key,$uploaddir,$file1,$file2,$file3,$field,$fraudkey,$comparekey,%cookie);

   $CGITempFile::TMPDIRECTORY = $tempuploaddir if ($tempuploaddir && -d $tempuploaddir && -w $tempuploaddir && -r $tempuploaddir);
   $settings_file = "$data_directory/resize_settings.txt";
   use lib "./CPAN"; # Needed because some older version of IFC do not have that line in "crypt.pl" and would give problems when upgrading iBULC_upload.cgi

   $| = 1;
   use CGI qw(:standard);
#   &parse_cookies;
   &start;


###############################################################################
# START
# Loading the form with and then redirecting to the correct subroutine based
# on the input.
###############################################################################
   sub start {
      $query = new CGI;
      # The original file
      $file1 = $query->param("FILE1");
      # The medium resized file (jpg image)
      $file2 = $query->param("FILE2");
      # The small resized file (jpg image)
      $file3 = $query->param("FILE3");
      $field = $query->param("FIELD");
      $fraudkey = $query->param("FRAUD_KEY");
      $comparekey = $query->param("COMPARE_KEY");
      $admin_select = $query->param("admin_select");
      $uid = $query->param("uid");
      $uid = $COOKIE{'IF_UID'} unless $uid;
      $pw_encryption=1;

      print "Content-type: text/html\n\n";

      @resize_types = ("jpg","jpeg","tif","tiff","gif","png","psd","pdf","eps","bmp");
      @icon_types   = ("jpg","mid","mov","mp3","mpg","pcd","pdf","png","ppt","psd","ra","rm","sit","swf","tar","tif","ttf","wav","wmf","wpd","xls","zip","wmv","aif","ap","au","avi","bin","bmp","doc","eps","exe","fon","gif","gz","img");

      if ($file1 or $file2 or $file3) {
         # Doing the actual file upload
         &upload;
         $file1 = (); # Needed for win32 to remove the tempfile
         $file2 = (); # Needed for win32 to remove the tempfile
         $file3 = (); # Needed for win32 to remove the tempfile
      }
      elsif ($fraudkey && $comparekey) {
         # Comparing the encryption key.
         &fraud_check;
      }
      elsif ($admin_select) {
         $step = $query->param("step");
#         &get_session;
         if ($step == 2) {
            $category = $query->param("category");
            if (!$category) { &Error('You must select a Category.'); }
            &iBULC_iframe_2;
         }
         else {
            &iBULC_iframe;
         }
      }
      else {
         &create_ibulc_settings;
      }
   }

   sub create_ibulc_settings {
      &get_session;
      $media_select = $query->param("media_select");
      $category = $query->param("category");
      if (!$category) { &Error('You must select a Category.'); }
      if ($this_organisation) {
         $category = "$this_organisation/$category";
      }
      if ($media_select eq 'resize') {
          print qq|<html><head><title>iBULC setup</title><meta http-equiv="refresh" content="0;URL=$iBULC_uploaddurl&category=$category"></head><body></body></html>|;
          exit;
      }
      elsif (!$media_select or $media_select eq 'resize') {
         &setup_prev_thumb;
         $setup_description = qq|Creating previews + thumbnails and uploading to $category|;
         foreach (@resize_types) {
            $setup_types   .= "$_,";
         }
         $setup_types =~ s/,$//g;
         $setup_cookie      = qq|[IF_UID->$uid][category->$category]|;
      }
      else {
         &setup_pass;
         require "$libpath/crypt.pl";
         $media_resize = $query->param("resize_full");
         $media_icon   = $query->param("icon_full");
         if ($media_resize eq $media_select) {
            &setup_prev_thumb;
            $prev_thumb_text = " + previews + thumbnails";
            $prev_thumb_cookie = "[prev_thumb->1]";
         }
         elsif ($media_icon eq $media_select) {
            $prev_thumb_cookie = "[prev_icon->1]";
         }
         my $media_info = &admin_decrypt($media_select, $encryption_key);
         my ($df_desc, $df_secret, $df_ext, $df_price) = split(/\|/, $media_info);
         $setup_description = qq|Uploading $df_desc ($currsymbol$df_price)$prev_thumb_text to $category|;
         $setup_original    = "1";
         $setup_types       = $df_ext;
         $setup_cookie      = qq|[IF_UID->$uid][category->$category][digidl->$media_select]$prev_thumb_cookie|;
      }
      &setup_ibulc;
   }

   sub setup_prev_thumb {
      if (!$this_organisation) {
         my @reseize_settings = ("iw","ih","ic","iq","is","tw","th","tc","tq","ts");
         open (SETTINGS, ">$settings_file");
         foreach (@reseize_settings) {
            $RESIZE{$_} = $query->param($_);
            print SETTINGS "$_\t" . $RESIZE{$_} . "\n";
         }
         close (SETTINGS);
         chmod(0777,"$settings_file");
      }
      else {
         &get_resize_settings;
      }
#      $setup_medium = "medium_|$RESIZE{iw}|$RESIZE{ih}|$RESIZE{ic}|$RESIZE{iq}|$RESIZE{is}|1";
#      $setup_small  = "small_|$RESIZE{tw}|$RESIZE{th}|$RESIZE{tc}|$RESIZE{tq}|$RESIZE{ts}|0";

      eval qq{ require "$libpath/zoomify.pl"; };
      my %IFZ_CONFIG = &ifz_get_settings("$group_group_name") if $using_zoomify;
      if ($IFZ_CONFIG{'ifz_upload'}) {
         $IFZ_CONFIG{'ifz_size'} = 1 unless $IFZ_CONFIG{'ifz_size'};
         $setup_medium              = "medium_|$ImageDimensions|$ImageDimensions|0|$IFZ_CONFIG{'ifz_quality'}|$IFZ_CONFIG{'ifz_sharpening'}|1|$IFZ_CONFIG{'ifz_size'}";
      }
      else {
         $setup_medium          = "medium_|$ImageDimensions|$ImageDimensions|0|$ImageQuality|$ImageSharpness|1";
      }
      $setup_small           = "small_|$ThumbDimensions|$ThumbDimensions|0|$ThumbQuality|$ThumbSharpness|0";
   }

###############################################################################
# SETUP iBULC
# Getting the correct parameters for the setup of the iBULC client. 
###############################################################################
   sub setup_ibulc {

      &get_session;

      # Here will load the setup and URL encode the complete setup string to feed to the iBULC client.
      &setup_pass;
      $iBULC_uploadurl = $baseurl . "/admin/iBULC_upload.cgi" if !$iBULC_uploadurl; # Needed because some older version of IFC does not $iBULC_uploadurl defined and would give problems when upgrading iBULC_upload.cgi
      my $iB_query = &setup_client;
      $iB_query =~ s/([^a-zA-Z0-9])/"%" . sprintf("%2x", ord($1))/ge;

      # Here we print out a little HTML page. A JavaScript is include that checks if the iBULC client
      # is running. If it is running it forwards the user to his directory listing so that he can start
      # selecting files he wants to upload. If the iBULC client is not running then a message shows up
      # to start iBULC or download it if it was never installed before.

      print qq|<html>
      <head>
      <title>iBULC setup</title>
      <script language="JavaScript">
      setup = 0;
      function check_status(){
         if (setup) return;
         now = new Date();
         iBULC=document.createElement('img');
//       Begin: incompatible with Safari
//         iBULC=new Image();
//         iBULC.src='http://127.0.0.1:1125/images/dot.gif?'+now.getTime();
//       End: incompatible with Safari
         iBULC.onload=online;
         iBULC.src='http://127.0.0.1:1125/images/' + now.getTime() + '/dot.gif';
         if (!setup) {
            window.setTimeout("check_status()", 1000);
         }
      }
      function online() {
         setup = 1;
         window.focus();
         location.href = 'http://127.0.0.1:1125/setup/?$iB_query';
      }
      </script>
      </head>
      <body bgcolor="#FFFFFF" text="#000000" onLoad="check_status()">
      Currently you do not have the <a href="http://www.ibulc.com" target="_blank">internet Batch Up-Load
      Component</a> running. If you have downloaded it before then please run it now or download it here.<br><br>
      <center>
      <a href="http://download.ibulc.com/iBULCsetup-win.exe">Windows 98/ME/NT/2000/XP</a> or 
      <a href="http://download.ibulc.com/iBULCsetup-mac.dmg.gz">Mac OS X</a>
      </center>
      </body>
      </html>|;
   }

###############################################################################
# FRAUD CHECK
# Before iBULC starts uploading it will connect to your script and verify the
# encryption key. You need to return either TRUE or FALSE. This is only done
# once at the beginning of each upload session.
###############################################################################
   sub fraud_check {
      &setup_pass;
      $comparekey = crypt($comparekey, $encryption_key);
      $comparekey =~ s/[^a-zA-Z0-9]//g;
      if ($comparekey eq $fraudkey) {
         print "TRUE";
      }
      else {
         print "FALSE";
      }
   }

###############################################################################
# UPLOAD
# UPLOAD the files.
###############################################################################
   sub upload {

       my ($start_types,$start_max,$totalbytes,$bytesread,$buffer);

      # Read the encryption key
      &setup_pass;

      # Read the upload directory
      &setup_upload;

      # If the encryption key has been set then check with every upload if the
      # $comparekey still matches the $fraudkey. I know, this is overly paranoid
      # and is not really needed. It is just to make sure that your upload script
      # is not used by anything else then the iBULC uploader. If this part is ommitted
      # a user could in theory configure a standard browser upload button to use your
      # script to upload files. The other, simpler, way is to use cookies (which iBULC
      # support) to store login info but that is not as fool proof as this method.

      if ($encryption_key) {
         ($start_types, $start_max) = split(/\~/, $comparekey);
         $comparekey = crypt($comparekey, $encryption_key);
         $comparekey =~ s/[^a-zA-Z0-9]//g;
         if ($comparekey ne $fraudkey) {
            print "FRAUD_KEY and COMPARE_KEY do not match";
            exit;
         }
      }


      # Now it is time to do something with your "$iB_field_value" and "$iB_cookie" that you
      # specified in the setup. The iBULC client has returned that information and with CGI.pm
      # and the "get_cookies" routine we were were able to read those. So if you had setup iBULC
      # as follows:

      # $iB_field_value   = "whatever";
      # $iB_cookie        = "[TEST1->Test cookie value 1][TEST2->Test cookie value 2]";

      # Then those values can now be retrieved with

      # $field (has a value of "whatever").
      # $COOKIE{'TEST1'} (has a value of "Test cookie value 1").
      # $COOKIE{'TEST2'} (has a value of "Test cookie value 2").

      # START DO SOMETHING WHITH "FIELD" AND COOKIES ###################################
      #
      #
      #
      # Example: Here you can add code that creates a new directory based on the value of "$field".
      # Then you set "$uploaddir" to this new directory and the files will be stored in this
      # new directory.
      #
      #
      #
      # END DO SOMETHING WHITH "FIELD" AND COOKIES #####################################


      if ($file1) {
         if ($COOKIE{'digidl'}) {
            require "$libpath/crypt.pl";
            my $media_info = &admin_decrypt($COOKIE{'digidl'}, $encryption_key);
            ($df_desc, $df_secret, $df_ext, $df_price) = split(/\|/, $media_info);
            ($shortname, $extension) = &clean_file($file1);
            # If we received the first file then save it now.
            &save_file($file1, "$df_secret$shortname.$df_ext");
         }
         else {
            $no_convert = 1;
         }
      }
      if ($file2) {
         ($shortname, $extension) = &clean_file($file2);
         # If we received the second file then save it now. This will be a jpg image.
         &save_file($file2, "$shortname.$extension");
         require "$libpath/iptc.pl";
         if ($extension eq 'ifz') {
            if ($metafile = $query->param("META2")) {
               my $randomname = int(rand(1234567890)) + time;
               &save_file($metafile, '', "$tempuploaddir/$randomname.jpg");
               $source_iptc_info = new Image::IPTCInfo("$tempuploaddir/$randomname.jpg");
               unlink "$tempuploaddir/$randomname.jpg";
               $metafile = (); #needed for win32
            }
         }
         else {
            $source_iptc_info = new Image::IPTCInfo("$uploaddir/$COOKIE{'category'}/$shortname.$extension");
         }
      }
      if ($file3) {
         ($shortname, $extension) = &clean_file($file3);
         # If we received the third file then save it now. This will be a "jpg image.
         &save_file($file3, "$mypattern$shortname.$extension");
         if (defined($source_iptc_info)) {
            my @IPTC_attributes = ('caption/abstract','writer/editor','headline','special instructions','copyright notice','credit','source','object name','date created','by-line','by-line title','city','province/state','country/primary location name','original transmission reference','contact','content location code','content location name','country/primary location code','digital creation date','digital creation time','edit status','editorial update','expiration date','expiration time','fixture identifier','image orientation','image type','language identifier','object cycle','originating program','program version','reference date','reference number','reference service','release date','release time','sub-location','subject reference','time created','urgency','custom1','custom2','custom3','custom4','custom5','custom6','custom7','custom8','custom9','custom10','custom11','custom12','custom13','custom14','custom15','custom16','custom17','custom18','custom19','custom20');
            $createinfo = create Image::IPTCInfo("$uploaddir/$COOKIE{'category'}/$mypattern$shortname.$extension");
            $createinfo->ClearKeywords();
            $createinfo->ClearSupplementalCategories();
            my $keywordsRef = $source_iptc_info->Keywords();
            if ($keywordsRef) {
               foreach $keyword (@$keywordsRef) {
                  $createinfo->AddKeyword("$keyword");
               }
            }
            foreach $IPTC_attribute (@IPTC_attributes) {
               $iptcvalue = $source_iptc_info->Attribute("$IPTC_attribute");
               $createinfo->SetAttribute("$IPTC_attribute","$iptcvalue");
             }
            $createinfo->Save();
         }
      }

      # If you have set "$iB_custom_result=0" in the setup then make sure you print here "Done". Anything
      # else will show up as "Failed" in the iBULC client.
      if ($no_convert) {
         print "Could not create preview and thumbnail. Please upload in a different format";
      }
      elsif ($COOKIE{'prev_thumb'} && !$file2  && !$file2) {
         print "Could not create preview and thumbnail. Original file was uploaded.";
      }
      else {
         if ($COOKIE{'prev_icon'}) {
            require File::Copy;
            $icons_dir =~ s/$store_files_url/$store_files_path/g;
            my $used_icon = uc($df_ext) . ".jpg";
            &File::Copy::copy ("$icons_path/$used_icon", "$uploaddir/$COOKIE{'category'}/$mypattern$shortname.jpg") or print "(Could not copy default icon: $used_icon) ";
            &File::Copy::copy ("$icons_path/$used_icon", "$uploaddir/$COOKIE{'category'}/$shortname.jpg");
         }
         print "Done";
      }

   }

   sub clean_file {
      my $file = shift;
      $file =~ s!^.*(\\|\/)!!;
      my ($extension) = ($file =~ /\.([^.]+)$/);
      $extension = lc($extension);
      my ($base) = $file =~ m,^(.*)\.\w+$,;
      $base =~ s/ /_/g;
      $base =~ s/\.//g;
      my $deny_characters = qq|'/\\:*?"<>\|=&%\$^+;()[]{}#|;
      my $deny_chars = quotemeta ("$deny_characters");
      $base =~ s/[$deny_chars]//g;
      $base =~ s/^small_//g;
      $base =~ s/^medium_//g;
      $base =~ s/^$mypattern//g;
      $base =~ s/^$df_secret//g if $COOKIE{'digidl'};
      $base =~ s/^_//g;
      if (!$base) {
         $base = "novalidname";
      }
      return ($base, $extension);
   }

   sub save_file {
      my ($infile, $outfile, $file_path) = @_;
      my $file_path = "$uploaddir/$COOKIE{'category'}/$outfile" unless $file_path;
      my $totalbytes = 0;
      open (OUTFILE, ">$file_path");
      binmode OUTFILE;
      while ($bytesread = read($infile, $buffer, 2048)) {
         print OUTFILE $buffer; 
      }
      close (OUTFILE);
      chmod(0777,"$file_path");
   }

sub get_resize_settings {
   if (!-e $settings_file) {
      open (SETTINGS, ">$settings_file");
      print SETTINGS "iw\t500\n";
      print SETTINGS "ih\t500\n";
      print SETTINGS "ic\t\n";
      print SETTINGS "iq\t80\n";
      print SETTINGS "is\t10\n";
      print SETTINGS "tw\t120\n";
      print SETTINGS "th\t120\n";
      print SETTINGS "tc\t\n";
      print SETTINGS "tq\t80\n";
      print SETTINGS "ts\t10\n";
      close (SETTINGS);
      chmod(0777,"$settings_file");
   }
   open (FILE,"$settings_file");
   my (@SETTINGS)=<FILE>;
   close(FILE);
   chomp @SETTINGS;
   foreach (@SETTINGS) {
      my ($name, $value) = split(/\t/, $_);
      $RESIZE{$name} = $value;
   }
}

sub get_resize_table {
   $media_table = qq|
      <table border="0" cellpadding="2" cellspacing="1" bgcolor="#CCCCCC" width=400>
         <tr>
            <td bgcolor="#eeeeee">&nbsp;</td>
            <td align="center" bgcolor="#eeeeee"><$admin_small_font>Max<br>Width</font></td>
            <td align="center" bgcolor="#eeeeee"><$admin_small_font>Max<br>Height</font></td>
            <td align="center" bgcolor="#eeeeee" valign="bottom"><$admin_small_font>Crop</font></td>
            <td align="center" bgcolor="#eeeeee"><$admin_small_font>Quality<br>(0-100)</font></td>
            <td align="center" bgcolor="#eeeeee"><$admin_small_font>Sharpness<br>(0-100)</font></td>
         </tr>
         <tr>
            <td bgcolor="#eeeeee"><$admin_small_font><b>Preview:</b></font></td>
            <td align="center" bgcolor="#eeeeee"><input type="text" name="iw" size="4" maxlength="4" value=$RESIZE{iw}></td>
            <td align="center" bgcolor="#eeeeee"><input type="text" name="ih" size="4" maxlength="4" value=$RESIZE{ih}></td>
            <td align="center" bgcolor="#eeeeee"><input type="checkbox" name="ic" value=$RESIZE{ic}></td>
            <td align="center" bgcolor="#eeeeee"><input type="text" name="iq" size="3" maxlength="3" value=$RESIZE{iq}></td>
            <td align="center" bgcolor="#eeeeee"><input type="text" name="is" size="3" maxlength="3" value=$RESIZE{is}></td>
         </tr>
         <tr>
            <td bgcolor="#eeeeee"><$admin_small_font><b>Thumbnail:</b></font></td>
            <td align="center" bgcolor="#eeeeee"><input type="text" name="tw" size="4" maxlength="4" value=$RESIZE{tw}></td>
            <td align="center" bgcolor="#eeeeee"><input type="text" name="th" size="4" maxlength="4" value=$RESIZE{th}></td>
            <td align="center" bgcolor="#eeeeee"><input type="checkbox" name="tc" value=$RESIZE{tc}></td>
            <td align="center" bgcolor="#eeeeee"><input type="text" name="tq" size="3" maxlength="3" value=$RESIZE{tq}></td>
            <td align="center" bgcolor="#eeeeee"><input type="text" name="ts" size="3" maxlength="3" value=$RESIZE{ts}></td>
         </tr>
      </table>|;
}

sub get_downloads {
   &setup_pass;
   require "$libpath/crypt.pl";
   foreach (@resize_types) {
      $setup_types   .= "$_, ";
   }
   $setup_types =~ s/, $//g;
#   $media_table = "<$admin_small_font>Create previews + thumbnails from uploaded files ($setup_types)</font>" if !$media_table;

   $media_table_insert = qq|<tr>
         <td align="center"><$admin_small_font>&nbsp;</font</td>
         <td>$media_table</td>
      </tr>| if $media_table;

   $media_table = qq|
   <table border="0" cellpadding="2" cellspacing="0">
      <tr>
         <td align="center" bgcolor="#ffcc00"><$admin_small_font><b>UPLOAD</b></font></td>
         <td align="center" bgcolor="#ffcc00"><$admin_small_font><b>P&nbsp;R&nbsp;E&nbsp;V&nbsp;I&nbsp;E&nbsp;W&nbsp;&nbsp;&nbsp;+&nbsp;&nbsp;&nbsp;T&nbsp;H&nbsp;U&nbsp;M&nbsp;B&nbsp;N&nbsp;A&nbsp;I&nbsp;L</b></font></td>
      </tr>
      <tr>
         <td align="center"><input type="radio" name="media_select" value="resize" checked onClick="resize_box();"></td>
         <td><$admin_small_font>Create previews + thumbnails from uploaded files ($setup_types)</font><br></td>
      </tr>
      $media_table_insert
      <tr>
         <td align="center" bgcolor="#ffcc00"><$admin_small_font><b>UPLOAD</b></font></td>
         <td align="center" bgcolor="#ffcc00"><$admin_small_font><b>D&nbsp;I&nbsp;G&nbsp;I&nbsp;T&nbsp;A&nbsp;L&nbsp;&nbsp;&nbsp;&nbsp;D&nbsp;O&nbsp;W&nbsp;N&nbsp;L&nbsp;O&nbsp;A&nbsp;D&nbsp;S</b></font></td>
      </tr>|;

   my $this_category = $category;

   if ($this_organisation) {
      @categories = split (/\//, $this_organisation);
      foreach $cat (@categories) {
         $pricefile .= $cat . ".";
         if (lc($addcatprice_per) ne 'yes') {
            my $pricefilepath = "$commercedata/prices/" . $pricefile . "pl";
            if (-e "$pricefilepath"){
               require "$pricefilepath";
            }
         }
         else {
            %downloads = ();
         }
      }
   }

   @categories = split (/\//, $category);
   foreach $cat (@categories) {
      $pricefile .= $cat . ".";
      my $pricefilepath = "$commercedata/prices/" . $pricefile . "pl";
      if (-e "$pricefilepath"){
         $Tpricefilepath .= "<br>$pricefilepath";
         require "$pricefilepath";
      }
   }

   $upload_text = qq|Make the uploaded files available in the store for purchasing and downloading.|;
   $addcatprice_per = "Yes";

   if ($addcatprice_per eq "Yes") {
      $downloads_cnt = scalar(keys(%downloads));
      if ($downloads_cnt >= 1) {
         $edit_or_add = "edit";
      }
      else {
         $edit_or_add = "add";
      }
      $upload_text .= qq| Click <a href="$adminurl&uid=$uid&cgi=cat_price.pl&cataction=addprice&catstep=2&category=$category&fromiBULC=1" target="_parent">here</a> to $edit_or_add download options for <b>$category<b>.|;
   }

   $media_table .= qq|
      <tr>
         <td><$admin_small_font>&nbsp;</font></td>
         <td width=400><$admin_small_font>$upload_text</font></td>
      </tr>|;

   foreach $key (sort keys %downloads) {
      my $df_desc              =  $downloads{$key}[0];
      my $df_naming            =  $downloads{$key}[1];
      my $df_price             =  $downloads{$key}[2];
      ($df_secret, $df_ext) =  split(/filename./, $df_naming);

      my $radio_value = &admin_encrypt("$df_desc|$df_secret|$df_ext|$df_price", $encryption_key);
      $divcnt++;
      $js_resize_box = ();
      foreach (@resize_types) {
         if (lc($df_ext) eq $_) {
            $js_resize_box = qq|$divcnt,"resize_full","$radio_value","Create previews + thumbnails from uploaded $_ files."|;
            last;
         }
      }
      if (!$js_resize_box) {
         foreach (@icon_types) {
            if (lc($df_ext) eq $_) {
               $js_resize_box = qq|$divcnt,"icon_full","$radio_value","Add default icon for uploaded $_ files."|;
               last;
            }
         }
      }
      $media_table .= qq|
      <tr>
         <td align="center" valign="top"><input type="radio" name="media_select" value="$radio_value" onClick='resize_box($js_resize_box);'></td>
         <td><table border="0" cellpadding="2" cellspacing="1" bgcolor="#CCCCCC" width=400>
               <tr>
                 <td align="left" bgcolor="#eeeeee"><$admin_small_font>$df_desc</font></td>
                 <td align="left" bgcolor="#eeeeee" width=35><$admin_small_font>&nbsp;$df_ext&nbsp;</font></td>
                 <td align="left" bgcolor="#eeeeee" width=55><$admin_small_font>&nbsp;$currsymbol$df_price&nbsp;</font></td>
               </tr>
            </table><span id="div_$divcnt"></span></td>
      </tr>|;
   }

   $media_table .= qq|</table>|;
}

sub iBULC_iframe_2 {

   if (!$this_organisation) {
#      &get_resize_settings;
#      &get_resize_table;
   }
   &get_downloads if $salestype==1 or $salestype==4 or $salestype==5;
   if (!$media_table) {
      &create_ibulc_settings;
   }
   else {
      print qq|<html><head>
      <script type="text/javascript">
      <!--
      function resize_box(id,name,box,txt) {
         for (var c = 1; c <= $divcnt; c++) {
            resizediv='div_'+c;
            if (document.all) {
              document.all(resizediv).innerHTML = '';
            }
            else if (document.getElementById) {
              document.getElementById(resizediv).innerHTML = '';
            }
         }
         if (id) {
            resizediv='div_'+id;
            resize = '<table border="0" cellspacing="0" cellpadding="0"><tr><td><input type="checkbox" name="'+name+'" value="'+box+'" checked></td><td valign="middle"><$admin_small_font> '+txt+'</font></td></tr></table>';
            if (document.all) {
               document.all(resizediv).innerHTML = resize;
            }
            else if (document.getElementById) {
               document.getElementById(resizediv).innerHTML = resize;
            }
         }
      }
      // -->
      </script>
      </head>
      <body bgcolor="#eeeeee" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
      <form name="input" method="get" action="$imagefolio_url">
      <input type="hidden" name="ifup" value="iBULC_upload_commerce">
      <input type="hidden" name="uid" value="$uid">
      <input type="hidden" name="category" value="$category">
      <center>
         <br><br>
      $media_table
      <br><br><input type=submit value="   Next   >>   ">
      </center>
      </form></body></html>
      |;
   }
}


sub iBULC_iframe {
#   &get_session;
   &get_catlist;

   print qq|<html><body bgcolor="#eeeeee" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
   <form name="input" method="get" action="$imagefolio_url">
   <input type="hidden" name="ifup" value="iBULC_upload_commerce">
   <input type="hidden" name="uid" value="$uid">
   <input type="hidden" name="step" value="2">
   <input type="hidden" name="admin_select" value="1">
   <center>
   <table>
      <tr><td nowrap align="center"><$admin_small_font><br><br><br><b>U P L O A D&nbsp;&nbsp;&nbsp;L O C A T I O N</b></font></td></tr>
      <tr><td align="center">$catlist</td></tr>
   </table>
   <br><br><input type=submit value="   Next   >>   ">
   </center>
   </form></body></html>
   |;
}



###############################################################################
# PARSE THE COOKIES
# Parses the cookies and returns a hash with all the name value pairs.
###############################################################################
sub parse_cookies {
   if (defined($ENV{'HTTP_COOKIE'})) {
      @pairs = split(/; /, $ENV{'HTTP_COOKIE'});
      foreach $pair (@pairs) {
         ($name, $value) = split(/=/, $pair);
         $name =~ tr/+/ /;
         $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
         $value =~ tr/+/ /;
         $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
         if ($value) { $COOKIE{$name} = $value; }
      }
   }
}


###############################################################################
# GET CATLIST
# We read in the list of all of the categories from the categories.txt file
# which is built by build.pl and create a selection form
###############################################################################
sub get_catlist {
   open (FILE,"$catfile") or &Error ("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   @LINES = sort(@LINES);
   close(FILE);
   chomp @LINES;

   $catlist .= qq|<select name="category" size="11">|;

   foreach $LINE (@LINES) {
      $space = "";
      $star = "";
      ($category, $imagecount, $listcatpword) = split(/\t/, $LINE);
      $showcategory = $category;
      if ($this_organisation) {
          if ($showcategory =~ /^$this_organisation\//) {
             $showcategory =~ s/^$this_organisation\///g;
          }
          else {
             next;
          }
      }
      @categories = split (/\//, $showcategory);
      foreach $cat (@categories) {
         $space .= "......";
      }
      $newcategory = pop @categories;
      $newcategory =~ s/_/ /g;
      $space =~ s/\.\.\.\.\.\.//;
      $catlist .= qq|<option value="$showcategory">$space$newcategory$star|;
   }

   $catlist .= qq|</select>|;
}


#sub get_session {
#   my $sessionid = "$sessions_dir/${uid}.ifs";
#   if (!-e $sessionid) {
#      &Error ("Login incorrect");
#   }
#}


sub Error{
local ($whoops) = @_;

print qq|
<html>
<head>
<title>Error!</title>

<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="450" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="450"><tr bgcolor="000000">
<td nowrap><font face="Verdana,Arial,Helvetica" size="2" color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><font face="Verdana,Arial,Helvetica" size="2"><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><font face="Verdana,Arial,Helvetica" size="1"><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><font face="Verdana,Arial,Helvetica" size="2"><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>

</body>
</html>
|;

exit;
}

###############################################################################
# GET SESSION
# Gets the session and session file location
###############################################################################
sub get_session {
   if ($uid) {
     $sessionid = "$sessions_dir/$uid.ifs"; # second, we get the location
   }
   else {
     $sessionid = "111aaa.11a.ifs";            # give a bogus name if nonexistent
   }
   &check_file;
}

###############################################################################
# CHECK FILE
# checks to see if an id file exists before using it
###############################################################################
sub check_file {
   $exists = '1' if -e $sessionid;
   if ($exists eq '1') { &parse_session; }
   else                { die "no session"; }
}

###############################################################################
# PARSE SESSION
# Opens and reads a session file's contents
###############################################################################
sub parse_session {
   open (SESSION,"$sessionid") || print &Error('Unable to verify your identity.');
   my(@userdata)=<SESSION>;
   close(SESSION);

   foreach $userdata (@userdata) {
      @organisations = split(/\|/, $userdata);
      $addcatprice_per = $organisations[11];
      $this_organisation = $organisations[22];
      last;
   }
}

1;