####CODEHEADER###

   require "$currdir/admin/init.pl";
   use CGI qw(:standard);
   $CGITempFile::TMPDIRECTORY = $tempuploaddir;
   require "$libpath/crypt.pl";
   if ($use_im) {
      require "$libpath/imagemagick.pl";
   }
   else {
      require "$libpath/imageconvert.pl"; &load_ic;
   }
   if ($using_multiuser_mod) {
      $FORM{'admin'} = 1;
      require "$config_directory/users_config.pl";
      require "$libpath/users_access.pl";
      if (!$is_admin) {&start_multiuser_mod;}
   }
   require "$libpath/iptc.pl";
   &upload;


###############################################################################
# UPLOAD
# Uploads our pictures and calls our image editor if required
###############################################################################
sub upload {

   if ($admin_demo_mode) {
      &Error("$admin_demo_html");
   }

   &load_values;



   open (OUTFILE, ">$imgtoread") or &Error("Could not write $imgtoread.  Reason: $!"); 
   binmode OUTFILE;
   while ($bytesread = read($binary_image, $buffer, 1024)) {
      $totalbytes += $bytesread;
      print OUTFILE $buffer or &Error("Could not save $imgtoread.  Reason: $!"); 
   } 
   close (OUTFILE);

   if ($totalbytes > $max_size) {
      $sizedifference = $totalbytes - $max_size;
      $sizedifference = int($sizedifference/1000) . " Kb";
      $totalbytes = int($totalbytes/1000) . " Kb";
      $max_size = int($max_size/1000) . " Kb";
      unlink("$imgtoread");
      &Error("The maximum filesize is $max_size.  The filesize of your image is $totalbytes, which exceeds the max by $sizedifference.");
      $binary_image = (); # Needed for win32 to remove the tempfile
      exit;
   }
   elsif (!(-B "$imgtoread"))  {
      unlink("$imgtoread");
      &Error('The file you uploaded is not a binary file.  You must upload an image, such as GIF, JPEG, PNG, or TIFF.');
      $binary_image = (); # Needed for win32 to remove the tempfile
      exit;
   }

   $fullsizeextension = lc($extension);

   if ($extension =~ /jpg/i) {
      &add_user_info($imgtoread, $fullsizeextension);
   }
   &create_image;
   ($filedate)  = (stat("$filetowrite"))[9];
   &add_user_info($filetowrite, $fullsizeextension);
   &create_thumbnail;
   &add_user_info($thumbtowrite, $fullsizeextension);
   &update_index_files;
   if ($is_user) {&create_email; &create_imagethumb_cache;}
   if ($use_fullsize && (lc($myextension_fullsize) eq 'zip')) {
      require Archive::Zip;
      my $zip = Archive::Zip->new();
      my $zip_extension = lc ($extension);
      $zip->addFile( "$imgtoread", "$shortname.$zip_extension" );
      my $member = $zip->memberNamed("$shortname.$zip_extension");
      $member->desiredCompressionMethod( 0 );
      $zip->writeToFileNamed( "$uploaddir/${mypattern_fullsize}${shortname}.$myextension_fullsize" );
      chmod(0777,"$uploaddir/${mypattern_fullsize}${shortname}.$myextension_fullsize");
      $upimage = "${mypattern_fullsize}${shortname}.$myextension_fullsize";
      unlink("$imgtoread");
   }
   elsif (!$use_fullsize) {
      unlink("$imgtoread");
      $upimage = ();
   }
   if ($is_user) {
      $upimage = ();
   }
   print "Content-type: text/html\n";
   if ($fe_admin) {
#      if ($is_user && $group_media_desc_per) {
#         print "Location:$imagefolio_redirect_url?admin=caption_confirm_image&admin_directory=$category&admin_image1=$newimage&admin_image2=$newthumb\n\n";
#      }
#      else {
         print "Location:$imagefolio_redirect_url?admin=admin_upload_image&image1=$newimage&image2=$newthumb&image3=$upimage&admin_directory=$category\n\n";
#      }
   }
   else {
      print "Location:$imagefolio_redirect_url?admin=admin&cgi=images.pl&uid=$uid&imgaction=upload&image1=$newimage&image2=$newthumb&image3=$upimage&savecat=$category\n\n";
   }

   $binary_image = (); # Needed for win32 to remove the tempfile

}

###############################################################################
# LOAD VALUES
# Creates our thumbnail image
###############################################################################
sub load_values {
   $query = new CGI;
   $category = $query->param("admin_directory");
   if (!$category) {
      $category = $query->param("category");
   }
   $uploaddir = "$image_directory/$category";
   $binary_image = $query->param("FILE1");
   $uid = $query->param("uid");
   $fe_admin = $query->param("fe_admin");

   if (!$category)                   { &Error('You must select a Category.'); }
   elsif (!$binary_image)            { &Error('You must select a Picture for uploading.'); }
   elsif (!(-e $tempdir))            { &Error('Your temp directory does not exist.'); }
   elsif (!(-W $tempdir))            { &Error('Your temp directory is not writable.'); }
   elsif (!(-d $tempdir))            { &Error('Your temp directory is not a valid directory.'); }

   if (!$is_admin && !$is_user) {
      &Error("You do not have permission to upload files to this site.");
   }
   elsif ($is_user) {
      if (!$group_media_upload_per) {
         &Error("Sorry $ifusername, you do not have permission to upload files to this site.");
      }
      &compare_cat($category);
      if (!$group_media_fs_per) {
         $use_fullsize = 0;
      }
   }
   elsif ($is_admin) {
      @allow_extensions = ();
      foreach $key (keys %extensions) {
         push(@allow_extensions, $key);
      }
   }

   $image_to_upload = $binary_image;
   $image_to_upload =~ s!^.*(\\|\/)!!;
   ($extension) = ($image_to_upload =~ /\.([^.]+)$/);
   if (lc($extension) =~ /(jpg|tif|png|psd|pcd|bmp|gif)/i) {
      $pass_extension_check_1 = 1;
   }
   if ($use_fullsize && (lc($myextension_fullsize) ne 'zip')) {
      $tempdir = $uploaddir;
      if (lc($myextension_fullsize) =~ /(jpg|tif|png|psd|pcd|bmp|gif)/i) {
         $pass_extension_check_2 = 1;
      }
      if (lc($extension) eq lc($myextension_fullsize)) {
         $pass_extension_check_3 = 1;
      }
      if ($pass_extension_check_1 && !$pass_extension_check_2 && !$pass_extension_check_3) {
         $new_error_text = qq|ImageFolio is configured to use full size files with extension "$myextension_fullsize" only.<br>2 SOLUTIONS:<br>1) If you want to upload and save your original $image_to_upload file then please set \$myextension_fullsize = '$extension' in your config.pl.<br>2) If you don't want to keep your original $image_to_upload file then please set \$use_fullsize=0 in your config.pl|;
         &Error($new_error_text);
      }
      elsif ($pass_extension_check_1 && $pass_extension_check_2 && !$pass_extension_check_3) {
         $new_error_text = qq|ImageFolio is configured to use full size files with extension "$myextension_fullsize" only.<br>3 SOLUTIONS:<br>1) Upload a $myextension_fullsize image.<br>2) Set \$myextension_fullsize = '$extension' in your config.pl.<br>3) Set \$use_fullsize = 0 in your config.pl|;
         &Error($new_error_text);
      }
      elsif (!$pass_extension_check_1 && !$pass_extension_check_2) {
         $new_error_text = qq|You can not use ImageConvert/ImageMagick to upload your $image_to_upload file.<br>SOLUTION:<br> Set \$use_manual_file_upload = 1 in admin_config.pl and/or post_config.pl to use the manual upload function.|;
         &Error($new_error_text);
      }
      elsif (!$pass_extension_check_1 && $pass_extension_check_2) {
         $new_error_text = qq|ImageFolio is configured to use full size files with extension "$myextension_fullsize" only.<br>2 SOLUTIONS:<br>1) Upload a $myextension_fullsize image.<br>2) Set \$use_manual_file_upload = 1 in admin_config.pl and/or post_config.pl to upload $image_to_upload|;
         &Error($new_error_text);
      }
   }
   elsif ($use_fullsize && lc($myextension_fullsize) eq 'zip') {
      $tempdir = $uploaddir;
      foreach $allow_extension (@allow_extensions) {
         next if !exists($extensions{lc($allow_extension)});
         $my_allowed_extensions .= "$allow_extension, ";
         if (lc($allow_extension) eq lc($extension)) {
            $pass_extension_check_4 = 1;
         }
      }
      $my_allowed_extensions =~ s/\, $//g;
      if (!$pass_extension_check_4) {
         $new_error_text = qq|You can not upload a "$extension".<br>SOLUTION:<br>Only upload files with the following extensions: $my_allowed_extensions|;
         &Error($new_error_text);
      }
   }
   if (!$pass_extension_check_1) {
         $new_error_text = qq|You can not use ImageConvert/ImageMagick to upload your $image_to_upload file.<br>2 SOLUTIONS:<br>1) Set \$use_manual_file_upload = 1 in admin_config.pl and/or post_config.pl to use the manual upload function.<br>2) Upload a jpg or tif image|;
         &Error($new_error_text);
   }

   ($shortname) = $image_to_upload =~ m,^(.*)\.\w+$,;
   $shortname =~ s/ /_/g;
   $shortname =~ s/\.//g;
   $shortname =~ s/[$deny_chars]//g;
   $shortname =~ s/^$mypattern//g;
   $shortname =~ s/^$mypattern_fullsize//g;
   if (!$shortname) {
      $shortname = "novalidname";
   }
   $filetowrite = qq|$uploaddir/$shortname.jpg|;
   if (-e "$filetowrite") {
      if ($overwrite_if_exist) {
         $source_iptc_info = new Image::IPTCInfo("$filetowrite");
      }
      else {
         for ($ext=1; $ext<100; $ext++) {
            $testfile = $uploaddir . "/" . $shortname . $ext . ".jpg";
            unless (-e "$testfile") {
               $shortname = $shortname . $ext;
               last;
            }
         }
      }
   }

   if ($use_fullsize) {
      if (lc($myextension_fullsize) eq 'zip') {
         $upimage = "${mypattern_fullsize}${shortname}.$extension";
      }
      else {
         $upimage = "${mypattern_fullsize}${shortname}.$myextension_fullsize";
      }
   }
   else {
      $upimage = $shortname . "." . $extension;
   }
   $imgtoread = $tempdir . "/" . $upimage;

   undef $bytesread;
   undef $buffer;

}


sub add_user_info {
   my ($input, , $saveextension) = @_;
   @IPTC_attributes = ('caption/abstract','writer/editor','headline','special instructions','copyright notice','credit','source','object name','date created','by-line','by-line title','city','province/state','country/primary location name','original transmission reference','contact','content location code','content location name','country/primary location code','digital creation date','digital creation time','edit status','editorial update','expiration date','expiration time','fixture identifier','image orientation','image type','language identifier','object cycle','originating program','program version','reference date','reference number','reference service','release date','release time','sub-location','subject reference','time created','urgency','custom1','custom2','custom3','custom4','custom5','custom6','custom7','custom8','custom9','custom10','custom11','custom12','custom13','custom14','custom15','custom16','custom17','custom18','custom19','custom20');
   if (defined($source_iptc_info)) {
      $createinfo = create Image::IPTCInfo("$input");
      $createinfo->ClearKeywords();
      $createinfo->ClearSupplementalCategories();
      my $keywordsRef = $source_iptc_info->Keywords();
      if ($keywordsRef) {
         foreach $keyword (@$keywordsRef) {
            $createinfo->AddKeyword("$keyword");
         }
      }
      foreach $IPTC_attribute (@IPTC_attributes) {
         $iptcvalue = $source_iptc_info->Attribute("$IPTC_attribute");
         $createinfo->SetAttribute("$IPTC_attribute","$iptcvalue");
       }
      $createinfo->Save();
   }
   else {
      if (!$group_media_desc_per && !$is_admin) {
         my $iptc_info = new Image::IPTCInfo("$input");
         if (defined($iptc_info)){
            $createinfo = create Image::IPTCInfo("$input");
            $createinfo->ClearKeywords();
            $createinfo->ClearSupplementalCategories();
            foreach $IPTC_attribute (@IPTC_attributes) {
               $createinfo->SetAttribute("$IPTC_attribute","");
            }
         }
         else {
            $createinfo = create Image::IPTCInfo("$input");
         }
      }
      else {
         $createinfo = create Image::IPTCInfo("$input");
      }
      if ($ifemail && $ifusername) {
         $encrypt_email = &admin_encrypt($ifemail, $ifusername);
      }
      else {
         $encrypt_email = ();
      }
      $createinfo->SetAttribute('originating program','www.imagefolio.com');
      $createinfo->SetAttribute('program version','4.x');
      $createinfo->SetAttribute('custom18',"[$current_time][$ifusername][$encrypt_email][$group_media_upload_approval][$saveextension][]") if $is_user;
      $createinfo->SetAttribute('custom18',"[$current_time][][][][$saveextension][]") if $is_admin;
      $createinfo->Save();
   }

   if (!$source_iptc_info) {
      $source_iptc_info = new Image::IPTCInfo("$input");
   }
}

sub create_email {
   $encrypt_link = &admin_encrypt("$imagefolio_url?action=view&link=$category&image=$newimage&ota=1", $secret_key);
   $one_time_access = &admin_encrypt("$category/$newimage", $secret_key);
   if ($ifemail) {
      $from_email = $ifemail;
   }
   else {
      $from_email = $admin_email;
   }
   my $from_out = "$from_email";
   my $to_out = "$admin_email";
   my $cc_out = ();
   if (@picpost_moderators) {
      foreach $picpost_moderator (@picpost_moderators) {
         $my_picpost_moderator .= "$picpost_moderator,";
      }
      $my_picpost_moderator =~ s/,$//g;
      $bcc_out = $my_picpost_moderator;
   }
   $subject_out = "New Upload ($newimage)";
   if ($group_media_upload_approval) {
      $subject_out .= " ***Approval Required***";
      $message_out = qq|<b><$font><font color="#FF0000">TAKE ACTION!</font> This file needs approval before it is visible.</font></b><br><br>|;
      $approve_text = "approve/";
      $priority = 1;
   }
   else {
      $priority = 0;
   }
   my $type_out_0 = 'multipart/related';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
   my $data_out_0 = '';
   my $type_out_1 = 'text/html'; # blank 'text/plain' or 'text/html'
   my $data_out_1 = qq|<body><center>$message_out<table border="1" cellspacing="1" cellpadding="5">
                         <tr>
                           <td align="center" width="50%" valign="top" nowrap><$font><a href="$adminurl&start=$encrypt_link"><b>Admin view</b><br><br><img src="cid:$newthumb" border=0></a><br><br>After login you have administrator rights. You can<br>${approve_text}rename/caption/delete/move the file.</font></td>
                           <td align="center" width="50%" valign="top" nowrap><$font><a href="$imagefolio_url?action=view&link=$category&image=$newimage&ota=$one_time_access"><b>One time quick access</b><br><br><img src="cid:$newthumb" border=0></a><br><br>You have one time, quick access to this file only.<br>You can ${approve_text}delete the file.</font></td>
                         </tr>
                       </table></center></body>|;
   my $type_out_2 = 'image/jpeg'; # the type of attachment
   my $id_out = $newthumb;
   my $path_out = $filetowrite;
   &send_mime_email($from_out, $to_out, $cc_out, $bcc_out, $subject_out, $type_out_0, $data_out_0, $type_out_1, $data_out_1, $type_out_2, $id_out, $path_out, $priority);
}

sub create_imagethumb_cache {
   if (!$group_media_upload_approval) {
      $cachefilename = "thumb~USER~$ifusername~sort1~show_tn1";
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";
      open (TCACHE,">>$cacheloc");
      print TCACHE "blah|$newthumb|$category|$filedate|0|0|\n";
      close(TCACHE);
      chmod(0777,"$cacheloc");

      $cachefilename = "direct~$category";
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";
      open (TCACHE,">>$cacheloc");
      print TCACHE "blah|$newthumb|$category|$filedate|0|0|\n";
      close(TCACHE);
      chmod(0777,"$cacheloc");
   }
}

###############################################################################
# CREATE IMAGE
# Creates our full-size image
###############################################################################
sub create_image {

   $newimage = "$shortname.jpg";
   $filetowrite = "$uploaddir/$newimage";

   if (!$use_im) {
      &do_ic("\"$imgtoread\"", "\"$filetowrite\"", $ImageDimensions, $ImageQuality, $ImageSharpness, $ImageContrast, $ImageCustom, '', '', '', 'decr', '', '');
   }
   else {
      &do_im($imgtoread, $filetowrite, $ImageDimensions, $ImageQuality, $ImageSharpness, $ImageContrast);
   }
   chmod (0777, $filetowrite);
}

###############################################################################
# CREATE THUMBNAIL
# Creates our thumbnail image
###############################################################################
sub create_thumbnail {

   $newthumb = "$mypattern$shortname.jpg";
   $thumbtowrite = "$uploaddir/$newthumb";
   $ThumbCrop_im = ();
   $ThumbCrop_ic = ();

   if ($crop_thumb_width && $crop_thumb_height) {
      my ($ftw_width, $ftw_height) = imgsize("$filetowrite");
      if ($ftw_width && $ftw_height) {
         $width_factor = $ftw_width/$crop_thumb_width;
         $height_factor = $ftw_height/$crop_thumb_height;
         if ($width_factor > $height_factor) {
            $ThumbDimensions = $ftw_width/$height_factor;
            $ThumbCrop = ($ThumbDimensions-$crop_thumb_width)/2;
            ($ThumbCrop) = split(/\./,$ThumbCrop);
            $ThumbCrop_im = "${crop_thumb_width}x${crop_thumb_height}+${ThumbCrop}+0";
            $ThumbCrop_ic = "${ThumbCrop} 0 ${crop_thumb_width} ${crop_thumb_height}";
         }
         else {
            $ThumbDimensions = $ftw_height/$width_factor;
            $ThumbCrop = ($ThumbDimensions-$crop_thumb_height)/2;
            ($ThumbCrop) = split(/\./,$ThumbCrop);
            $ThumbCrop_im = "${crop_thumb_width}x${crop_thumb_height}+0+${ThumbCrop}";
            $ThumbCrop_ic = "0 ${ThumbCrop} ${crop_thumb_width} ${crop_thumb_height}";
         }
      }
   }

   if (!$use_im) {
      $ThumbCustom .= " -rmeta";
      &do_ic("\"$filetowrite\"", "\"$thumbtowrite\"", $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCustom, $ThumbCrop_ic, '', '', 'decr', '', '');
   }
   else {
      &do_im($filetowrite, $thumbtowrite, $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCrop_im);
   }
   chmod (0777, $thumbtowrite);
}

########################################################
# Error
# shows error message if form not filled out correctly
########################################################
sub ErrorOLD{
print "Content-type: text/html\n\n";
local ($whoops) = @_;

print qq|
<html>
<head>
<title>Error!</title>

<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="450" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="450"><tr bgcolor="000000">
<td nowrap><font face="Verdana,Arial,Helvetica" size="2" color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><font face="Verdana,Arial,Helvetica" size="2"><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><font face="Verdana,Arial,Helvetica" size="1"><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><font face="Verdana,Arial,Helvetica" size="2"><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>

</body>
</html>
|;
$binary_image = (); # Needed for win32 to remove the tempfile
exit;
}

###############################################################################
# SAVE DATA TO CATEGORIES.TXT FILE
###############################################################################
sub update_index_files {

   open (CATFILE, "$catfile");
   my(@catfiledata)=<CATFILE>;
   close(CATFILE);

   foreach $catfiledata (@catfiledata) {
      ($catpath, $catcount, $catage) = split(/\t/, $catfiledata);
      if ($catpath eq $category){
         $catcount++;
         ($catage)  = (stat("$filetowrite"))[9];
         $catlist .= $catpath . "\t" . $catcount . "\t" . $catage . "\t\n";
      }
      else {
         $catlist .= $catfiledata;
      }
   }

   open(CATFILE, ">$catfile");
   if ($useflock) { flock(CATFILE, 2); }
   print CATFILE $catlist;
   if ($useflock) { flock(CATFILE, 8); }
   close(CATFILE);

}
1;