####CODEHEADER###

   require "$currdir/admin/init.pl";
   use CGI qw(:standard);
   $CGITempFile::TMPDIRECTORY = $tempuploaddir;
   require "$libpath/crypt.pl";
   require "$libpath/if_web_get.pl";
   if ($using_multiuser_mod) {
      $FORM{'admin'} = 1;
      require "$config_directory/users_config.pl";
      require "$libpath/users_access.pl";
      if (!$is_admin) {&start_multiuser_mod;}
   }
   require "$libpath/iptc.pl";
   &upload;


###############################################################################
# UPLOAD
# Uploads our pictures and calls our image editor if required
###############################################################################
sub upload {

   if ($admin_demo_mode) {
      &Error("$admin_demo_html");
   }

   &load_values;

   $newimage = "$shortname.$extension";
   $newthumb = "${mypattern}$shortname.jpg";

   my $resultsfile = "$uploaddir/$newimage";


   open(RESULTS,">$resultsfile");
   print RESULTS $results;
   close(RESULTS);
   chmod(0777, $resultsfile);

   $filedate  = time;

   $thumbtowrite = "$uploaddir/$newthumb";

   if ($binary_image) {
      if ($use_im) {
         require "$libpath/imagemagick.pl";
      }
      else {
         require "$libpath/imageconvert.pl"; &load_ic;
      }
      open (OUTFILE, ">$thumbtowrite.JPEG");
      binmode OUTFILE;
      while ($bytesread = read($binary_image, $buffer, 1024)) {
         $totalbytes += $bytesread;
         print OUTFILE $buffer;
      } 
      close (OUTFILE);
      if (!$use_im) {
         $ThumbCustom .= " -rmeta";
         &do_ic("\"$thumbtowrite.JPEG\"", "\"$thumbtowrite\"", $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCustom, $ThumbCrop_ic, '', '', 'decr', '', '');
      }
      else {
         &do_im("$thumbtowrite.JPEG", $thumbtowrite, $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCrop_im);
      }
      chmod (0777, $thumbtowrite);
#      chmod (0777, "$thumbtowrite.JPEG");
      unlink("$thumbtowrite.JPEG");
      $binary_image = (); # Needed for win32 to remove the tempfile
   }

   if (!-e $thumbtowrite) {
      &if_web_get($GOT{'Thumbnail Url'},$thumbtowrite) if $GOT{'Thumbnail Url'};
   }

   if (!-e $thumbtowrite) {
      &Error('No thumbnail, add code to copy default icon');
   }

   &add_user_info($thumbtowrite);
   &update_index_files;

   print "Content-type: text/html\n";
   if ($fe_admin) {
#      if ($is_user && $group_media_desc_per) {
#         print "Location:$imagefolio_redirect_url?admin=caption_confirm_image&admin_directory=$category&admin_image1=$newimage&admin_image2=$newthumb\n\n";
#      }
#      else {
         print "Location:$imagefolio_redirect_url?admin=admin_upload_image&image1=$newimage&image2=$newthumb&image3=$upimage&admin_directory=$category\n\n";
#      }
   }
   else {
      print "Location:$imagefolio_redirect_url?admin=admin&cgi=images.pl&uid=$uid&imgaction=upload&image1=$newimage&image2=$newthumb&image3=$upimage&savecat=$category\n\n";
   }

}

###############################################################################
# LOAD VALUES
# Creates our thumbnail image
###############################################################################
sub load_values {
   $query = new CGI;
   $category = $query->param("admin_directory");
   $binary_image = $query->param("THUMB");
   if (!$category) {
      $category = $query->param("category");
   }
   $uploaddir = "$image_directory/$category";
   my $link_upload = $query->param("link_upload");
   $uid = $query->param("uid");
   $fe_admin = $query->param("fe_admin");

   if (!$category)                   { &Error('You must select a Category.'); }
   elsif (!$link_upload)             { &Error('You must enter a URL for uploading.'); }
   elsif (!(-e $tempdir))            { &Error('Your temp directory does not exist.'); }
   elsif (!(-W $tempdir))            { &Error('Your temp directory is not writable.'); }
   elsif (!(-d $tempdir))            { &Error('Your temp directory is not a valid directory.'); }

   if (!$is_admin && !$is_user) {
      &Error("You do not have permission to upload files to this site.");
   }
   elsif ($is_user) {
      if (!$group_media_upload_per) {
         &Error("Sorry $ifusername, you do not have permission to upload files to this site.");
      }
      &compare_cat($category);
      if (!$group_media_fs_per) {
         $use_fullsize = 0;
      }
   }
   elsif ($is_admin) {
      @allow_extensions = ();
      foreach $key (keys %extensions) {
         push(@allow_extensions, $key);
      }
   }

   $extension = 'emb';

#   foreach $allow_extension (@allow_extensions) {
#      next if !exists($extensions{lc($allow_extension)});
#      if ($extension eq lc($allow_extension)) {
#         $found_correct_media = 1;
#      }
#   }
#   if (!$found_correct_media) {
#      &Error("Sorry, are you not allowed to link to external content.");
#   }

   $use_link_upload = () unless exists($extensions{lc($extension)});
   &Error("Sorry, are you not allowed to link to external content.") unless $use_link_upload;

   $link_upload =~ s/^\s+//g;
   $link_upload =~ s/\s+$//g;
   $link_upload =~ s/([^a-zA-Z0-9])/"%" . sprintf("%2x", ord($1))/ge;


   for (1..5) {
      $got = &if_web_get("http://www.imagefolio.com/test/parse/?link=$link_upload");
      last if $got;
      sleep 1;
   }


#   my $got = &if_web_get("http://www.imagefolio.com/test/parse/?link=$link_upload");

#   if (!$got) {
#      sleep 1;
#      $got = &if_web_get("http://www.imagefolio.com/test/parse/?link=$link_upload");
#   }

   &Error("Sorry, could not connect at the moment, please try again later.") if !$got;

   my @gotpairs = split(/&/, $got);

   foreach my $gotpair (@gotpairs) {
     my ($name, $value) = split(/=/, $gotpair);
     $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $GOT{$name} = $value;
     $results .= "$name\t$value\n";
   }

   &Error($GOT{'Error'}) if $GOT{'Error'};

   $shortname = $GOT{'Title'};
   $shortname =~ s/ /_/g;
   $shortname =~ s/\.//g;
   $shortname =~ s/[$deny_chars]//g;
   $shortname =~ s/^$mypattern//g;
   $shortname =~ s/$mypattern_fullsize//g;
   if (!$shortname) {
      $shortname = "novalidname";
   }
   $filetowrite = qq|$uploaddir/$shortname.link|;
   if (-e "$filetowrite") {
#      if ($overwrite_if_exist) {
#         $source_iptc_info = new Image::IPTCInfo("$filetowrite");
#      }
#      else {
         for ($ext=1; $ext<100; $ext++) {
            my $testfile = $uploaddir . "/" . $shortname . $ext . ".link";
            unless (-e "$testfile") {
               $shortname = $shortname . $ext;
               last;
            }
         }
#      }
   }

}

###############################################################################
# ADD USER INFO AND IPTC TO FILE
###############################################################################
sub add_user_info {
   my $input = shift;
   @IPTC_attributes = ('caption/abstract','writer/editor','headline','special instructions','copyright notice','credit','source','object name','date created','by-line','by-line title','city','province/state','country/primary location name','original transmission reference','contact','content location code','content location name','country/primary location code','digital creation date','digital creation time','edit status','editorial update','expiration date','expiration time','fixture identifier','image orientation','image type','language identifier','object cycle','originating program','program version','reference date','reference number','reference service','release date','release time','sub-location','subject reference','time created','urgency','custom1','custom2','custom3','custom4','custom5','custom6','custom7','custom8','custom9','custom10','custom11','custom12','custom13','custom14','custom15','custom16','custom17','custom18','custom19','custom20');
   if (defined($source_iptc_info)) {
      $createinfo = create Image::IPTCInfo("$input");
      $createinfo->ClearKeywords();
      $createinfo->ClearSupplementalCategories();
      my $keywordsRef = $source_iptc_info->Keywords();
      if ($keywordsRef) {
         foreach $keyword (@$keywordsRef) {
            $createinfo->AddKeyword("$keyword");
         }
      }
      foreach $IPTC_attribute (@IPTC_attributes) {
         $iptcvalue = $source_iptc_info->Attribute("$IPTC_attribute");
         $createinfo->SetAttribute("$IPTC_attribute","$iptcvalue");
       }
      $createinfo->Save();
   }
   else {
      if (!$group_media_desc_per && !$is_admin) {
         my $iptc_info = new Image::IPTCInfo("$input");
         if (defined($iptc_info)){
            $createinfo = create Image::IPTCInfo("$input");
            $createinfo->ClearKeywords();
            $createinfo->ClearSupplementalCategories();
            foreach $IPTC_attribute (@IPTC_attributes) {
               $createinfo->SetAttribute("$IPTC_attribute","");
            }
         }
         else {
            $createinfo = create Image::IPTCInfo("$input");
         }
      }
      else {
         $createinfo = create Image::IPTCInfo("$input");
      }
      if ($ifemail && $ifusername) {
         $encrypt_email = &admin_encrypt($ifemail, $ifusername);
      }
      else {
         $encrypt_email = ();
      }
      if ($GOT{'Keywords'}) {
         my @iptc_default_keywords = split(/\ /, $GOT{'Keywords'});
          foreach my $keyword (@iptc_default_keywords) {
            $createinfo->AddKeyword("$keyword");
         }
      }
      if ($GOT{'Description'}) {
         $createinfo->SetAttribute('caption/abstract',$GOT{'Description'});
      }
      $createinfo->SetAttribute('originating program','www.imagefolio.com');
      $createinfo->SetAttribute('program version','4.x');
      $createinfo->SetAttribute('custom18',"[$current_time][$ifusername][$encrypt_email][$group_media_upload_approval][$extension][]") if $is_user;
      $createinfo->SetAttribute('custom18',"[$current_time][][][][$extension][]") if $is_admin;
      $createinfo->Save();
   }

   if (!$source_iptc_info) {
      $source_iptc_info = new Image::IPTCInfo("$input");
   }
}

###############################################################################
# CREATE EMAIL TO ADMIN
###############################################################################
sub create_email {
   $encrypt_link = &admin_encrypt("$imagefolio_url?action=view&link=$category&image=$newimage&ota=1", $secret_key);
   $one_time_access = &admin_encrypt("$category/$newimage", $secret_key);
   if ($ifemail) {
      $from_email = $ifemail;
   }
   else {
      $from_email = $admin_email;
   }
   my $from_out = "$from_email";
   my $to_out = "$admin_email";
   my $cc_out = ();
   if (@picpost_moderators) {
      foreach $picpost_moderator (@picpost_moderators) {
         $my_picpost_moderator .= "$picpost_moderator,";
      }
      $my_picpost_moderator =~ s/,$//g;
      $bcc_out = $my_picpost_moderator;
   }
   $subject_out = "New Upload ($newimage)";
   if ($group_media_upload_approval) {
      $subject_out .= " ***Approval Required***";
      $message_out = qq|<b><$font><font color="#FF0000">TAKE ACTION!</font> This file needs approval before it is visible.</font></b><br><br>|;
      $approve_text = "approve/";
      $priority = 1;
   }
   else {
      $priority = 0;
   }
   my $type_out_0 = 'multipart/related';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
   my $data_out_0 = '';
   my $type_out_1 = 'text/html'; # blank 'text/plain' or 'text/html'
   my $data_out_1 = qq|<body><center>$message_out<table border="1" cellspacing="1" cellpadding="5">
                         <tr>
                           <td align="center" width="50%" valign="top" nowrap><$font><a href="$adminurl&start=$encrypt_link"><b>Admin view</b><br><br><img src="cid:$newthumb" border=0></a><br><br>After login you have administrator rights. You can<br>${approve_text}rename/caption/delete/move the file.</font></td>
                           <td align="center" width="50%" valign="top" nowrap><$font><a href="$imagefolio_url?action=view&link=$category&image=$newimage&ota=$one_time_access"><b>One time quick access</b><br><br><img src="cid:$newthumb" border=0></a><br><br>You have one time, quick access to this file only.<br>You can ${approve_text}delete the file.</font></td>
                         </tr>
                       </table></center></body>|;
   my $type_out_2 = 'image/jpeg'; # the type of attachment
   my $id_out = $newthumb;
   my $path_out = $filetowrite;
   &send_mime_email($from_out, $to_out, $cc_out, $bcc_out, $subject_out, $type_out_0, $data_out_0, $type_out_1, $data_out_1, $type_out_2, $id_out, $path_out, $priority);
}

###############################################################################
# CREATE CACHE FILE
###############################################################################
sub create_imagethumb_cache {
   if (!$group_media_upload_approval) {
      $cachefilename = "thumb~USER~$ifusername~sort1~show_tn1";
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";
      open (TCACHE,">$cacheloc");
      print TCACHE "blah|$newthumb|$category|$filedate|0|0|\n";
      close(TCACHE);
      chmod(0777,"$cacheloc");

      $cachefilename .= "~$category";
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";
      open (TCACHE,">$cacheloc");
      print TCACHE "blah|$newthumb|$category|$filedate|0|0|\n";
      close(TCACHE);
      chmod(0777,"$cacheloc");
   }
}

###############################################################################
# SAVE DATA TO CATEGORIES.TXT FILE
###############################################################################
sub update_index_files {

   open (CATFILE, "$catfile");
   my(@catfiledata)=<CATFILE>;
   close(CATFILE);

   foreach $catfiledata (@catfiledata) {
      ($catpath, $catcount, $catage) = split(/\t/, $catfiledata);
      if ($catpath eq $category){
         $catcount++;
         ($catage)  = (stat("$filetowrite"))[9];
         $catlist .= $catpath . "\t" . $catcount . "\t" . $catage . "\t\n";
      }
      else {
         $catlist .= $catfiledata;
      }
   }

   open(CATFILE, ">$catfile");
   if ($useflock) { flock(CATFILE, 2); }
   print CATFILE $catlist;
   if ($useflock) { flock(CATFILE, 8); }
   close(CATFILE);

}


1;