####CODEHEADER###

require "$currdir/admin/init.pl";
if ($using_multiuser_mod) {
   require "$config_directory/users_config.pl";
   require "$libpath/users_access.pl";
}
require "$libpath/crypt.pl";

&load_values;
&step_two if $action;

print "Content-type: text/html\n\n";

#################### Step One Form ####################
print qq|
<html>
<head>
<title>ImageFolio Administrative Reset</title>
</head>
<body bgcolor="#ffffff">
<form method=post action="$imagefolio_url">
<input type=hidden name=admin value="reset">
<input type="hidden" name="action" value="reset">
<center>
<table border="0" cellspacing="20" cellpadding="0" width="600" bgcolor="#ffcc00">
	<tr bgcolor="#000000">
		<td>
			&nbsp;&nbsp;<img src="$if_images_directory/logo.$ButtonExt" border=0 alt="ImageFolio Login" width=172 height=54>
		</td>	
	</tr>
	<tr>	
		<td align="center">
			<font face="Verdana,Arial,Helvetica" size="+1"><b>Reset Administrator's Database</b></font>
		</td>
	</tr>	
	<tr>	
		<td>
			<$admin_font>
			<p align="justify">You should use this form if you have lost access to the administration area of ImageFolio. This could happen if you forget your admininstrator's password or if you have recently changed your <b>\$secret_key</b> value in <b>admin_config.pl</b></p>
			<p align="justify">To reset the administrator's password file back to the original values, simply copy the <b>\$secret_key</b> value from <b>Step 4</b> in <b>admin_config.pl</b> into the space provided below.</p>
			</font>
			<br>
		</td>
	</tr>
	<tr>
		<td>
         <table>
            <tr>
               <td><$admin_font><b>Secret Key</b></font></td>
		         <td><input type=text  name="secret" size=60></td>
	         </tr>
	         <tr>
		         <td>&nbsp;</td>
		         <td><$admin_small_font>Copy key exactly as it appears in admin_config.pl</font></td>
	         </tr>
         </table>
      </td>
   </tr>
	<tr>
		<td align="center">
			<input type=submit value="Reset Database"><br><$admin_font><b>WARNING:</b> THIS WILL RESET YOUR ADMIN, GROUP and USER DATABASE</font>
		</td>
	</tr>
</table>
<br><br>
<br><br>
<hr size=1 noshade width=400>
<$admin_small_font>&copy; Copyright 1999-2007 BizSecure, Inc.<br></font>
</center>
</form>
</body>
</html>
|;

exit;

###############################################################################
# STEP TWO
# resets the admin database
###############################################################################
sub step_two {

   &Error("The key you entered does not match the secret key in admin_config.pl. Please go back and double check the value you enterred.") if ($secret ne $secret_key);

   if ($secret eq $secret_key) {
      $defaultusername = 'Admin';
      $defaultpassword = 'ImageFolio';
      $encpassword = &admin_encrypt($defaultpassword, $secret_key); 
      open(ADMINDB, ">$admindb") or &Error("Can't open $admindb. Reason: $!");
      print ADMINDB "$defaultusername|$encpassword|043970559|admin\@imagefolio.com|ImageFolio|Administrator|Yes|Yes|Yes|Yes|Yes|Yes|Yes|Yes|Yes\n";
      close(ADMINDB);
      chmod(0777,"$admindb") or &Error ("Could not set permissions on $admindb.  Reason: $!");
      if ($using_multiuser_mod) {
         $group_group_name             = $guest_username;
         $group_short_desc             = 'ImageFolio guest account. Users who do not have logged in yet get these permissions. You can remove this group if you do not want free guest access.';
         $group_default                = '0';
         $group_preview_view_per       = '0';
         $group_preview_protect_per    = '1';
         $group_watermark_per          = '1';
         $group_full_size_per          = '0';
         $group_media_upload_per       = '0';
         $group_media_main_cat_per     = '1';
         $group_media_upload_approval  = '1';
         $group_media_ren_per          = '0';
         $group_media_mov_per          = '0';
         $group_media_del_per          = '0';
         $group_media_desc_per         = '0';
         $group_media_fs_per           = '0';
         $group_cat_add_per            = '0';
         $group_cat_ren_per            = '0';
         $group_cat_move_per           = '0';
         $group_cat_del_per            = '0';
         $group_cat_upload_per         = '0';
         $group_cat_desc_per           = '0';
         $group_cat_access             = 'All';
         $group_post_access            = 'All';
         $group_skins_access           = "$skin_name";
         &populate_if_groupline;
         open(USERDB, ">$userdb") or &Error("Can't open $userdb. Check permissions");
         print USERDB "";
         close(USERDB);
         chmod(0777,"$userdb") or &Error ("Could not set permissions on $userdb.  Reason: $!");
         open(GROUPDB, ">$groupdb") or &Error("Can't open $groupdb. Check permissions");
         print GROUPDB "$if_groupline\n";
         close(GROUPDB);
         chmod(0777,"$groupdb") or &Error ("Could not set permissions on $groupdb.  Reason: $!");
      }
   }

   print "Content-type: text/html\n\n";

print qq|
<html>
<head>
<title>ImageFolio Administrative Reset</title>
</head>
<body bgcolor="#ffffff">
<center>
<table border="0" cellspacing="20" cellpadding="0" width="600" bgcolor="#ffcc00">
	<tr bgcolor="#000000">
		<td>
			&nbsp;&nbsp;<img src="http://www.imagefolio.com/clients/if_images/logo.$ButtonExt" border=0 alt="ImageFolio Login" width=172 height=54>
		</td>	
	</tr>
	<tr>	
		<td align="center">
			<font face="Verdana,Arial,Helvetica" size="+1"><b>Administrator's Database Reset</font></b></font>
		</td>
	</tr>	
	<tr>	
		<td>
			<$admin_font>
			<p align="justify">The Administrator's Database was reset to the original values.</p>
			Username: <font color="ff0000"><b>$defaultusername</b></font><br>
			Password: <font color="ff0000"><b>$defaultpassword</b></font><br>
			<p align="justify">You can login to the <a href="$adminurl"><b>Administrative Area</b></a> using this username and password.</p>
			</font>
		</td>
	</tr>
	<tr>	
		<td>
			<$admin_font>
			<p align="justify">The first thing you need to do is add yourself as a new user, then delete the default username and password. Click on Add New User from the menu options inside your Administration Area. Add yourself and set all permissions to Yes. After you have been added, log in with your new username and password. Click on Delete User from the menu options to delete the default account.</p>
			</font>
			<br>
		</td>
	</tr>
</table>
<br><br>
<br><br>
<hr size=1 noshade width=400>
<$admin_small_font>&copy; Copyright 1999-2007 BizSecure, Inc.<br></font>
</center>
</body>
</html>
|;

exit;
}

###############################################################################
# ERROR
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{

   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$admin_font color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><$admin_font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$admin_font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$admin_font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
|;

exit;
}

###############################################################################
# LOAD VALUES
# created variables for our form information
###############################################################################
sub load_values {
   $action       = $FORM{'action'};
   $secret       = $FORM{'secret'};
}

