####CODEHEADER###

use HTML::Entities;

sub templates {
	my $skin = $FORM{'skin'};
	
	&Error("You must provide a valid skin name.") if !$skin;
	
	my $skins_dir = $base_skin_dir;
	
	my $skin_dir = "$skins_dir/$skin";

	&Error("$skin is not a valid skin name") if !-e "$skin_dir/config_skin.pl";
		
	my $template = $FORM{'template'};

	my $template_dir = "$skin_dir/templates";
	
	opendir(TEMPLATES, $template_dir);
	my @templates = readdir TEMPLATES;
	closedir(TEMPLATES);
	
	@templates = sort(@templates);
	
	my $files = '';
	
	foreach my $file(@templates) {
		next if $file !~ /\.html$/;
	
		my $selected = $file eq $template ? ' selected' : '';
			
		$files .= qq{<option value="$file"$selected>$file</option>};
	}


   my $container_dir = "$template_dir/container";
   
   opendir(CONTAINER, $container_dir);
   my @container_templates = readdir CONTAINER;
   closedir(CONTAINER);
   
   @container_templates = sort(@container_templates);
   
   foreach my $file(@container_templates) {
      next if $file !~ /\.html$/;

     $files .= qq{<option value=""></option><option value="">==== Container Pages ====</option>} unless $container_found;
     $container_found = 1;
      my $selected = "container/$file" eq $template ? ' selected' : '';
      $files .= qq{<option value="container/$file"$selected>$file</option>};
   }


   my $pages_dir = "$template_dir/pages";
   
   opendir(PAGES, $pages_dir);
   my @page_templates = readdir PAGES;
   closedir(PAGES);
   
   @page_templates = sort(@page_templates);
   
   foreach my $file(@page_templates) {
      next if $file !~ /\.html$/;

     $files .= qq{<option value=""></option><option value="">==== Extra Pages ====</option>} unless $pages_found;
     $pages_found = 1;
      my $selected = "pages/$file" eq $template ? ' selected' : '';
      $files .= qq{<option value="pages/$file"$selected>$file</option>};
   }
	
	$files .= qq{<option value=""></option><option value="">==== Media Files ====</option>};
	
	my $media_dir = "$template_dir/media";
	
	opendir(MEDIAS, $media_dir);
	my @media_templates = readdir MEDIAS;
	closedir(MEDIAS);
	
	@media_templates = sort(@media_templates);
	
	foreach my $file(@media_templates) {
		next if $file !~ /\.html$/;
		
		my $selected = "media/$file" eq $template ? ' selected' : '';
	
		$files .= qq{<option value="media/$file"$selected>$file</option>};
	}
	
	my $editor = qq{
<input type="hidden" name="admin" value="admin">
<input type="hidden" name="cgi" value="templates.pl">
<input type="hidden" name="skin" value="$skin">
<input type="hidden" name="uid" value="$FORM{'uid'}">
<select name="template" onChange="this.form.submit()">
<option value="">==== Select a Template ====</option>
$files
</select>
<br>
	};
	
	if ($template) {
		my $template_file = "$template_dir/$template";
		
		if (-e $template_file) {
			my $notice = '';
			my $update = $FORM{'update'};
			my $admin_area_html_data = $FORM{'admin_area_html_data'};
		
			if ($admin_area_html_data && $update) {
				$admin_area_html_data =~ s/\r\n/\n/g;
		
				unless ($admin_demo_mode) {
					open(FILE, ">$template_file")or &Error("Error saving template: $!");;
					flock(FILE, 2) if $useflock;
					print FILE "$admin_area_html_data";
					flock(FILE, 8) if $useflock;
					close(FILE);
					chmod(0777, "$template_file");
				
					$notice = 'Template File Updated';
				}
			}
			
			open(FILE, $template_file);
			my @template = <FILE>;
			close($template_file);
				
			my $html = join('', @template);
			
			$html = encode_entities($html);
			
			$editor .= qq{
<$admin_font><font color=red>$notice</font></font><br>
<textarea class="object" style="width:100%" name="admin_area_html_data" rows="20" wrap="off">$html</textarea><br><br>
<input type="button" value="Back" onClick="location='$adminurl&cgi=skins.pl&skin=$skin&edit=yes&uid=$FORM{'uid'}';"> &nbsp; <input type="submit" name="update" value="Update Template"> &nbsp; <input type="reset" value="Reset">
			};			
		}
	}
	
	&get_header;

	print qq{
<center>
<table border="0" width="100%" cellspacing=0 cellpadding=0 bgcolor="#000000">
  <tr>
    <td>
      <table border="0" width="100%" cellspacing=1 cellpadding=0>
        <tr bgcolor="#ffcc00">
          <td>
            <table border="0" width="100%" cellspacing=0 cellpadding=4>
              <tr>
                <td><$admin_big_font><b>ImageFolio Skins Manager</b></font></td>
                <td align=right><$admin_big_font><b>Template Editor</b></font></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr bgcolor="#ffffff">
          <td valign=top>
            <table border=0 cellspacing=1 cellpadding=15 width="100%">
  <tr bgcolor="#eeeeee">
    <td bgcolor="#eeeeee" align=center>
      <$admin_font><b>$skin</b></font>
    </td>
  </tr>
              <tr bgcolor="#eeeeee">
                <td bgcolor="#eeeeee" align="center">
                  <form method="post" action="$adminurl&cgi=templates.pl&skin=$skin" enctype="multipart/form-data">
                  $editor
	              </form>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
	};

	&get_footer;
	
	exit;
}

1;
