####CODEHEADER###

$THUMBNAILISLAND = "active";

###############################################################################
# STEP 1
# If we don't receive any information we display the list of categories
###############################################################################
sub create_tisland {

$pagetitle = "Create A Thumbnail Island";
&get_header;
&get_this_catlist;
&find_skin_options;

print qq|

<form method=post action="$imagefolio_url">
<input type=hidden name=admin value="admin">
<input type=hidden name=uid value="$FORM{'uid'}">
<input type=hidden name=cgi value="thumb_island.pl">
<input type=hidden name=thumbaction value="show">

<$admin_font>With a &quot;Thumbnail Island&quot;&#153; you can show any thumbnail from your ImageFolio gallery on any of your other web pages. 
You can select just 1 specific thumbnail or choose to display a random one. You can enter keywords and sort by date to show the 
latest thumbnail that fits a certain subject. The options are endless. This page will let you select which thumbnail should be shown 
and present you with the HTML code which you can copy and paste in to your existing web pages. Have fun!</font><br><br>

<center>

<table width="100%" border="0" cellspacing="1" cellpadding="5" bgcolor="#000000">
  <tr bgcolor="#ffcc00"> 
    <td colspan="2"><$admin_big_font><b>STEP 1: Which thumbnails</b></font></td>
  </tr>
        
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Select a category</b>. Choose which category the thumbnails 
      should come from. If you want thumbnails from all categories to be shown, select 
      &quot;All.&quot;</font> </td>
          
    <td>$catlist</td>
  </tr>
        
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Thumbnail</b>. If you only want to show 1 specific thumbnail 
      (for example if you want to promote it) then type in the name here. Be 
      sure that you have also selected the category where this thumbnail is located!</font></td>
          
    <td> 
      <input type="text" name="thumbnail">
      <$admin_small_font>Example: ${mypattern}myimage.jpg</font></td>
  </tr>
        
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Search</b>. If you did not enter a thumbnail above, which 
      one should be shown?</font></td>
          
    <td> 
      <table width="100%" border="0" cellspacing="0" cellpadding="2">
        <tr> 
          <td nowrap> 
            <input type="radio" name="search" value="RANDOM" checked>
            <$admin_small_font>RANDOM</font></td>
          <td nowrap><$admin_small_font>Show a random thumbnail</font></td>
        </tr>
        <tr> 
          <td nowrap> 
            <input type="radio" name="search" value="NEW">
            <$admin_small_font>NEW</font></td>
          <td nowrap><$admin_small_font>Show the latest/newest thumbnail</font></td>
        </tr>
        <tr> 
          <td nowrap> 
            <input type="radio" name="search" value="HITS">
            <$admin_small_font>HITS</font></td>
          <td nowrap><$admin_small_font>Show the thumbnail with the most hits</font></td>
        </tr>
        <tr> 
          <td nowrap> 
            <input type="radio" name="search" value="RATES">
            <$admin_small_font>RATES</font></td>
          <td nowrap><$admin_small_font>Show the thumbnail with the highest rating</font></td>
        </tr>
        <tr> 
          <td nowrap> 
            <input type="radio" name="search" value="USER">
            <$admin_small_font>USER</font></td>
          <td nowrap><$admin_small_font>Show a thumbnail from a specific user:</font><br>
            <input type="text" name="username">
          </td>
        </tr>
        <tr> 
          <td nowrap> 
            <input type="radio" name="search" value="KEYWORDS">
            <$admin_small_font>KEYWORDS</font></td>
          <td nowrap><$admin_small_font>Show a thumbnail matching these keywords:</font><br>
            <input type="text" name="keywords">
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <tr bgcolor="#ffcc00"> 
    <td colspan="2"><$admin_big_font><b>STEP 2: Sorting</b></font></td>
  </tr>
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Sort</b>. If you chose USER or KEYWORDS above, then how 
      would you like to sort the results?</font></td>
    <td> 
      <table width="100%" border="0" cellspacing="0" cellpadding="2">
        <tr> 
          <td nowrap> 
            <input type="radio" name="sort" value="5" checked>
            <$admin_small_font>RANDOM</font></td>
          <td nowrap><$admin_small_font>Show a random thumbnail from a search result.</font></td>
        </tr>
        <tr> 
          <td nowrap> 
            <input type="radio" name="sort" value="1">
            <$admin_small_font>NEW</font></td>
          <td nowrap><$admin_small_font>Show the latest/newest thumbnail from a search 
            result.</font></td>
        </tr>
        <tr> 
          <td nowrap> 
            <input type="radio" name="sort" value="3">
            <$admin_small_font>HITS</font></td>
          <td nowrap><$admin_small_font>Show the thumbnail with the most hits from 
            a search result.</font></td>
        </tr>
        <tr> 
          <td nowrap> 
            <input type="radio" name="sort" value="4">
            <$admin_small_font>RATES</font></td>
          <td nowrap><$admin_small_font>Show the thumbnail with the highest rating 
            from a search result.</font></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Thumbnail # used</b>. By default the first thumbnail will 
      be shown from the search/sort result. You can specify here if you want to 
      show the 2nd, 3rd, etc. number</font></td>
    <td> 
      <input type="text" name="show_tn" size="7" maxlength="7">
      <$admin_small_font>Number only</font></td>
  </tr>
  <tr bgcolor="#ffcc00"> 
    <td colspan="2"><$admin_big_font><b>STEP 3: Layout</b></font></td>
  </tr>
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Title.</b> Type in the title of your thumbnail island.</font></td>
    <td> 
      <input type="text" name="title" value="Your Title">
    </td>
  </tr>
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Background color</b>. This should be the background color 
      of the page that this thumbnail island is shown on.</font></td>
    <td># 
      <input type="text" name="bgcolor" size="6" maxlength="6" value="FFFFFF">
    </td>
  </tr>
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Skin</b>. Which skin do you want to use? Font, colors, 
      borders will be taken from this skin.</font></td>
    <td>$skin_choices</td>
  </tr>
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Iframe size</b>. This will be the size of the floating 
      iframe.</font></td>
    <td> 
      <table width="100%" border="0" cellspacing="0" cellpadding="2">
        <tr>
          <td width="20"><$admin_small_font>Width:</font></td>
          <td>
            <input type="text" name="width" size="3" maxlength="3" value="160">
            <$admin_small_font>pixels</font></td>
        </tr>
        <tr>
          <td width="20"><$admin_small_font>Height:</font></td>
          <td>
            <input type="text" name="height" size="3" maxlength="3" value="320">
            <$admin_small_font>pixels</font></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr bgcolor="#ffcc00"> 
    <td colspan="2"><$admin_big_font><b>STEP 4: Miscellaneous</b></font></td>
  </tr>
  <tr bgcolor="#eeeeee"> 
    <td valign="top"><$admin_font><b>Forum use</b>. If you want to use this Thumbnail Island 
      in a forum (to show the latest upload of a user for example) then check 
      this. The user will get a message that he/she has not uploaded an image yet, when 
      nothing is found.</font></td>
    <td> 
      <input type="checkbox" name="forum" value="1">
    </td>
  </tr>
</table>


<br><input type=submit value="Create my Thumbnail Island">

</center>

</form>
|;

&get_footer;
}

###############################################################################
# STEP 2
# Show the select box so the user can select an image for deletion
###############################################################################
sub show_tisland {

$pagetitle = "Thumbnail Island HTML code";
&get_header;


$thumb_query = ();

if ($FORM{'direct'}) {
   $FORM{'direct'} =~ s/([^a-zA-Z0-9])/'%' . sprintf("%2x", ord($1))/ge;
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "direct=$FORM{'direct'}";
}

if ($FORM{'thumbnail'}) {
   $FORM{'thumbnail'} =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "thumbnail=$FORM{'thumbnail'}";
}

if ($FORM{'search'} =~ /^USER/) {
   if ($FORM{'username'}) {
      if ($thumb_query) {
         $thumb_query .= "&";
      }
      $thumb_query .= "search=USER&username=$FORM{'username'}";
   }
   else {
      &Error ("You need to type in a username if you want to search for a user!");
   }
}
elsif ($FORM{'search'} eq 'KEYWORDS') {
   if ($FORM{'keywords'}) {
      $FORM{'keywords'} =~ s/([^a-zA-Z0-9])/'%' . sprintf("%2x", ord($1))/ge;
      if ($thumb_query) {
         $thumb_query .= "&";
      }
      $thumb_query .= "search=$FORM{'keywords'}";
   }
   else {
      &Error ("You need to type in a keyword if you want to search with a keyword!");
   }
}
else {
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "search=$FORM{'search'}";
   $FORM{'sort'} = ();
}

if ($FORM{'sort'}) {
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "sort=$FORM{'sort'}";
}

if ($FORM{'show_tn'}) {
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "show_tn=$FORM{'show_tn'}";
}

if ($FORM{'title'}) {
   $FORM{'title'} =~ s/([^a-zA-Z0-9])/'%' . sprintf("%2x", ord($1))/ge;
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "title=$FORM{'title'}";
}

if ($FORM{'bgcolor'}) {
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "bgcolor=$FORM{'bgcolor'}";
}

if ($FORM{'skin'}) {
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "skin=$FORM{'skin'}";
}

if ($FORM{'forum'}) {
   if ($thumb_query) {
      $thumb_query .= "&";
   }
   $thumb_query .= "forum=$FORM{'forum'}";
}

print qq|<center>
<table width="100%" border="0" cellspacing="1" cellpadding="5" bgcolor="#000000">
  <tr bgcolor="#ffcc00"> 
    <td><$admin_big_font><b>Result:</b></font></td>
  </tr>
  <tr bgcolor="#eeeeee">
   <td align=center><IFRAME width="$FORM{'width'}" height="$FORM{'height'}" src="$imagefolio_url?main=imageThumb&$thumb_query" scrolling="No" marginwidth=0 marginheight=0 frameborder="Yes"></IFRAME><br>
   <$admin_small_font>Note: the IFRAME border won't be shown on your version. It is shown here to give you an indication of it's size.</td>
  </tr>
  <tr bgcolor="#ffcc00"> 
    <td><$admin_big_font><b>HTML Source Code:</b></font></td>
  </tr>
  <tr bgcolor="#eeeeee">
   <td align=center>
   <textarea name="html_source" cols="80" rows="7"><IFRAME width="$FORM{'width'}" height="$FORM{'height'}" src="$imagefolio_url?main=imageThumb&$thumb_query" scrolling="No" marginwidth=0 marginheight=0 frameborder="No"></IFRAME></textarea><br>
   <$admin_small_font>Note: Copy and Paste this code in your existing HTML page.</td>
  </tr>
</table>
<br><INPUT TYPE="button" VALUE="Go Back" onClick="history.go(-1)"></center>|;



&get_footer;
}

###############################################################################
# GET CATLIST
# We read in the list of all of the categories from the categories.txt file
# which is built by build.pl and create a selection form
###############################################################################
sub get_this_catlist {
   open (FILE,"$catfile") or &Error ("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   close(FILE);
   chomp @LINES;
   @LINES = sort { lc($a) cmp lc($b) } @LINES;

$catlist .= qq|<select name="direct" size="8"><option value="" selected>All|;

   foreach $LINE (@LINES) {
      $space = "";
      ($category, $imagecount) = split(/\t/, $LINE);
      @categories = split (/\//, $category);
      foreach $cat (@categories) {
         $space .= "......";
      }
      $newcategory = pop @categories;
      $newcategory =~ s/_/ /g;
      $space =~ s/\.\.\.\.\.\.//;
      $catlist .= qq|<option value="$category">$space$newcategory|;
   }

$catlist .= qq|</select>|;
}

###############################################################################
# SKIN OPTIONS
###############################################################################
sub find_skin_options {

   @files = ();
   @skins = ();
   opendir (SKINDIR, "$base_if_path/skins") or &Error("Can't Open $midi_directory: $!");
   @files = readdir(SKINDIR);
   closedir (SKINDIR);
   @files = sort { lc($a) cmp lc($b) } @files;
   foreach $file (@files) {
      if ( -d "$base_skin_dir/$file" ) {                   #make sure this really is a directory
         chop $file if ($file =~ /\/$/);
         next if $file =~ /^\.\.?$/;                         #weed out all .. directories
         next if $file =~ /_vti_cnf/i;                       #weed out front page directories
         push(@skins, $file);
      }
   }
   $size = @skins + 1;

   $skin_choices = qq|<select name="skin" size="$size"><option value="" selected>- Default skin ($skin_name)</option>|;

   foreach $skin (@skins) {
      $myskin = $skin;
      $myskin =~ s/_/ /g;
      $skin_choices .= qq|<option value="$skin"$skin_selected>- $myskin</option>|;
      $skin_selected = ();
   }

   $skin_choices .= qq|</select>|;

}

1;
