####CODEHEADER###

require "$currdir/admin/init.pl";
use CGI qw(:standard);
$CGITempFile::TMPDIRECTORY = $tempuploaddir;
require "$libpath/crypt.pl";
if ($using_multiuser_mod) {
   $FORM{'admin'} = 1;
   require "$config_directory/users_config.pl";
   require "$libpath/users_access.pl";
   if (!$is_admin) {&start_multiuser_mod;}
}
&upload;


###############################################################################
# UPLOAD
# Uploads our pictures and calls our image editor if required
###############################################################################
sub upload {
   $query = new CGI;
   $category = $query->param("admin_directory");
   if (!$category) {
      $category = $query->param("category");
   }
   $uid = $query->param("uid");
   $fe_admin = $query->param("fe_admin");
   $uploaddir = "$image_directory/$category";
   $cat_image_upload = $query->param("cat_image_upload");
   $admin_skin = $query->param("admin_skin");
   $admin_skin_image = $query->param("admin_skin_image");
   $watermark_upload = $query->param("watermark_upload");

   if (!$category) {  &Error ("You must select a category!"); }

   if (!$is_admin && !$is_user) {
      &Error("You do not have permission to upload files to this site.");
   }
   elsif ($is_user) {
      if (!$group_media_upload_per) {
         &Error("Sorry $ifusername, you do not have permission to upload files to this site.");
      }
      &compare_cat($category) unless $watermark_upload;
      require "$libpath/crypt.pl";
   }
   elsif ($is_admin) {
      @allow_extensions = ();
      foreach $key (keys %extensions) {
         push(@allow_extensions, $key);
      }
   }

   $ucount = 1;

   if ($admin_demo_mode) {
      &Error("$admin_demo_html");
   }

   while ($ucount != 4) {

      $binary_image = $query->param("FILE$ucount");
      $wrong_tn_extension = ();
      $wrong_fs_extension = ();
      $found_correct_media = ();

      if ($binary_image) {

         $image_to_upload = $binary_image;
         ($extension) = ($image_to_upload =~ /\.([^.]+)$/);

         if (!$extension) {
            $extension = "jpg";
         }
         $extension = lc($extension);
         if (!$run_once) {
            $run_once = 1;
            $image_to_upload =~ s!^.*(\\|\/)!!;
            ($shortname) = $image_to_upload =~ m,^(.*)\.\w+$,;
            $shortname =~ s/ /_/g;
            $shortname =~ s/\.//g;
            $shortname =~ s/[$deny_chars]//g;
            $shortname =~ s/^$mypattern//g;
            $shortname =~ s/^$mypattern_fullsize//g;
            if (!$shortname) {
               $shortname = "novalidname";
            }
            $image_to_upload = $shortname . "." . $extension;
            $testfile = "$uploaddir/$image_to_upload";
            $tn_testfile = "$uploaddir/$mypattern$shortname.jpg";
            if ($overwrite_if_exist) {
               if (-e $testfile && ($extension eq 'jpg')) {
                  $source_iptc_info = new Image::IPTCInfo("$testfile");
               }
               elsif (-e $tn_testfile) {
                  $source_iptc_info = new Image::IPTCInfo("$tn_testfile");
               }
            }
            elsif (-e $testfile or -e $tn_testfile) {
               for ($ext=1; $ext<100; $ext++) {
                  $testfile = "$uploaddir/$shortname$ext.$extension";
                  $tn_testfile = "$uploaddir/$mypattern$shortname$ext.jpg";
                  if ((!-e "$testfile") && (!-e "$tn_testfile")) {
                     $shortname = $shortname . $ext;
                     last;
                  }
               }
            }
         }
         if ($ucount eq "1") {
            foreach $allow_extension (@allow_extensions) {
               next if !exists($extensions{lc($allow_extension)});
               if ($extension eq lc($allow_extension)) {
                  $found_correct_media = 1;
                  $found_tag_file = 1;
               }
               $my_allow_extension .= "$allow_extension, ";
            }
            if (!$found_correct_media) {
               $my_allow_extension =~ s/, $//g;
               &Error("Sorry, you can only upload files with the extesions: $my_allow_extension");
            }
            $image_to_upload = $shortname . "." . $extension;
            $email_image_name = $image_to_upload;
            $uploaded = "&image$ucount=$image_to_upload";
            $default_icon = $extension;
         }
         elsif ($ucount eq "2") {
            if ($extension ne 'jpg') {
               $wrong_tn_extension = 1;
               $uploaded .= "&wrong_tn_extension=$wrong_tn_extension";
            }
            else {
               $found_thumbnail = 1;
               $image_to_upload = $mypattern . $shortname . ".jpg";
               $uploaded .= "&image$ucount=$image_to_upload";
            }
         }
         elsif ($ucount eq "3") {
            if (lc($myextension_fullsize) eq 'zip') {
               foreach $allow_extension (@allow_extensions) {
                  next if !exists($extensions{lc($allow_extension)});
                  if ($extension eq lc($allow_extension)) {
                     $found_correct_media_2 = 1;
                  }
               }
               if (!$found_correct_media_2) {
                  $wrong_fs_extension = 1;
                  $uploaded .= "&wrong_fs_extension=$wrong_fs_extension";
               }
               else {
                  $image_to_upload = $mypattern_fullsize . $shortname . "." . $extension;
               }
            }
            elsif (lc($extension) ne lc($myextension_fullsize)) {
               $wrong_fs_extension = 1;
               $uploaded .= "&wrong_fs_extension=$wrong_fs_extension";
            }
            else {
               $image_to_upload = $mypattern_fullsize . $shortname . "." . $myextension_fullsize;
            }
            if (!$wrong_fs_extension && !$default_icon) {
               $default_icon = lc($myextension_fullsize);
            }
            if ($is_user) {
               if (!$group_media_fs_per) {
                  &Error("Sorry $ifusername, you do not have permission to upload a full resolution file to this site.");
               }
            }
            else {
               if (lc($myextension_fullsize) eq 'zip') {
                  $uploaded .= "&image$ucount=$mypattern_fullsize$shortname.$myextension_fullsize";
               }
               else {
                  $uploaded .= "&image$ucount=$image_to_upload";
               }
            }
         }
         if (!$wrong_fs_extension && !$wrong_tn_extension) {
            &write_file;
            if (($ucount eq "1" or $ucount eq "2") && $extension eq 'jpg') {
               &add_user_info("$uploaddir/$image_to_upload");
            }
         }
      }
      $ucount++;
      $binary_image = ();
   }

   if (!$found_thumbnail && $default_icon && !$cat_image_upload && !$admin_skin && !$admin_skin_image && !$watermark_upload) {
      $used_icon = $extensions{$default_icon}[4];
      require File::Copy;
      &File::Copy::copy ("$icons_path/$used_icon", "$uploaddir/$mypattern$shortname.jpg") or &Error("Unable to copy image $used_icon. Reason: $!");
      $image_to_upload = $mypattern . $shortname . ".jpg";
      $thumb_image = $image_to_upload;
      $uploaded .= "&image2=$image_to_upload";
      &update_index_files;
      &add_user_info("$uploaddir/$image_to_upload");
   }

   if ($is_user && $image_to_upload) {
      &create_email;
       &create_imagethumb_cache;
   }

   $binary_image = $query->param("cat_image") unless $image_to_upload;
   if ($binary_image) {
      if ($is_user) {
         if (!$group_cat_upload_per) {
            &Error("Sorry $ifusername, you do not have permission to upload a category image to this site.");
         }
         &compare_cat($category);
      }
      $image_to_upload = $binary_image;
      ($extension) = ($image_to_upload =~ /\.([^.]+)$/);
      if (lc($extension) ne 'jpg') {
         &Error("You need to upload a jpg image!");
      }
      $image_to_upload = "_category_image.jpg";
      &write_file;
   }

   $binary_image = $query->param("skin_upload") unless $image_to_upload;
   if ($binary_image && $is_admin) {
      $download = $query->param("download");
      $image_to_upload = $binary_image;
      $image_to_upload =~ s!^.*(\\|\/)!!;
      $uploaddir = $tempuploaddir;
      &write_file;
   }

   if ($watermark_upload) {
      $binary_image = $query->param("watermark_image");
      $image_to_upload = $binary_image;
      ($extension) = ($image_to_upload =~ /\.([^.]+)$/);
      if (lc($extension) ne 'png') {
         &Error("You need to upload a png watermark image!");
      }
      $image_to_upload = "_watermark.png";
      $uploaddir = "$sessions_dir/$ifusername";
      &write_file;
   }


   if (!$image_to_upload)            { &Error('You must select a Picture for uploading.'); }

   $newcategory = $category;
   $newcategory =~ s/_/ /g;

   print "Content-type: text/html\n";
   if ($admin_skin) {
      print "Location:$imagefolio_redirect_url?admin=admin&cgi=skins.pl&uid=$uid&manual=yes&download=$download&upload=$image_to_upload\n\n";
   }
   elsif ($fe_admin && $cat_image_upload) {
      print "Location:$imagefolio_redirect_url?admin=admin_image_category&cat_image=$image_to_upload&admin_directory=$category\n\n";
   }
   elsif ($fe_admin) {
      print "Location:$imagefolio_redirect_url?admin=admin_upload_image$uploaded&admin_directory=$category\n\n";
   }
   elsif ($admin_skin_image) {
      my $skin = $query->param('skin');
      my $image = $query->param('image');
      print "Location:$imagefolio_redirect_url?admin=admin&cgi=skins.pl&edit=yes&skin=$skin&section=images&uid=$uid&image=$image&upload=$image_to_upload\n\n";
   }
   elsif ($watermark_upload) {
      print "Location:$imagefolio_redirect_url?commerce=store&account=view\n\n";
   }
   else {
      print "Location:$imagefolio_redirect_url?admin=admin&cgi=images.pl&uid=$uid&imgaction=upload$uploaded&savecat=$newcategory\n\n";
   }

   $binary_image = (); # Needed for win32 to remove the tempfile

}

sub add_user_info {
   my $input = shift;
   require "$libpath/iptc.pl";
   @IPTC_attributes = ('caption/abstract','writer/editor','headline','special instructions','copyright notice','credit','source','object name','date created','by-line','by-line title','city','province/state','country/primary location name','original transmission reference','contact','content location code','content location name','country/primary location code','digital creation date','digital creation time','edit status','editorial update','expiration date','expiration time','fixture identifier','image orientation','image type','language identifier','object cycle','originating program','program version','reference date','reference number','reference service','release date','release time','sub-location','subject reference','time created','urgency','custom1','custom2','custom3','custom4','custom5','custom6','custom7','custom8','custom9','custom10','custom11','custom12','custom13','custom14','custom15','custom16','custom17','custom18','custom19','custom20');
   if (defined($source_iptc_info)) {
      $createinfo = create Image::IPTCInfo("$input");
      $createinfo->ClearKeywords();
      $createinfo->ClearSupplementalCategories();
      my $keywordsRef = $source_iptc_info->Keywords();
      if ($keywordsRef) {
         foreach $keyword (@$keywordsRef) {
            $createinfo->AddKeyword("$keyword");
         }
      }
      foreach $IPTC_attribute (@IPTC_attributes) {
         $iptcvalue = $source_iptc_info->Attribute("$IPTC_attribute");
         $createinfo->SetAttribute("$IPTC_attribute","$iptcvalue");
       }
      $createinfo->Save();
   }
   else {
      if (!$group_media_desc_per && !$is_admin) {
         my $iptc_info = new Image::IPTCInfo("$input");
         if (defined($iptc_info)){
            $createinfo = create Image::IPTCInfo("$input");
            $createinfo->ClearKeywords();
            $createinfo->ClearSupplementalCategories();
            foreach $IPTC_attribute (@IPTC_attributes) {
               $createinfo->SetAttribute("$IPTC_attribute","");
            }
         }
         else {
            $createinfo = create Image::IPTCInfo("$input");
         }
      }
      else {
         $createinfo = create Image::IPTCInfo("$input");
      }
      if ($ifemail && $ifusername) {
         $encrypt_email = &admin_encrypt($ifemail, $ifusername);
      }
      else {
         $encrypt_email = ();
      }
      my $fs_extension = $query->param("FILE3");
      if ($fs_extension) {
         ($fs_extension) = ($fs_extension =~ /\.([^.]+)$/);
      }
      $createinfo->SetAttribute('originating program','www.imagefolio.com');
      $createinfo->SetAttribute('program version','4.x');
      $createinfo->SetAttribute('custom18',"[$current_time][$ifusername][$encrypt_email][$group_media_upload_approval][$fs_extension][]") if $is_user;
      $createinfo->SetAttribute('custom18',"[$current_time][][][][$fs_extension][]") if $is_admin;
      $createinfo->Save();
   }

   if ($found_tag_file && !$source_iptc_info) {
      $source_iptc_info = new Image::IPTCInfo("$input");
   }

}

sub create_email {
   if (!$email_image_name) {
      $email_image_name = "$shortname.jpg";
   }
   if ($found_tag_file) {
      $if_tagfile = $extensions{$default_icon}[2];
   }
   $encrypt_link = &admin_encrypt("$imagefolio_url?action=view&link=$category&image=$email_image_name&tt=$if_tagfile&ota=1", $secret_key);
   $one_time_access = &admin_encrypt("$category/$email_image_name", $secret_key);
   if ($ifemail) {
      $from_email = $ifemail;
   }
   else {
      $from_email = $admin_email;
   }
   my $from_out = "$from_email";
   my $to_out = "$admin_email";
   my $cc_out = ();
   if (@picpost_moderators) {
      foreach $picpost_moderator (@picpost_moderators) {
         $my_picpost_moderator .= "$picpost_moderator,";
      }
      $my_picpost_moderator =~ s/,$//g;
      $bcc_out = $my_picpost_moderator;
   }
   $subject_out = "New Manual Upload ($email_image_name)";
   if ($group_media_upload_approval) {
      $subject_out .= " ***Approval Required***";
      $message_out = qq|<b><$font><font color="#FF0000">TAKE ACTION!</font> This file needs approval before it is visible.</font></b><br><br>|;
      $approve_text = "approve/";
      $priority = 1;
   }
   else {
      $priority = 0;
   }
   my $type_out_0 = 'multipart/related';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
   my $data_out_0 = '';
   my $type_out_1 = 'text/html'; # blank 'text/plain' or 'text/html'
   my $data_out_1 = qq|<body><center>$message_out<table border="1" cellspacing="1" cellpadding="5">
                         <tr>
                           <td align="center" width="50%" valign="top" nowrap><$font><a href="$adminurl&start=$encrypt_link"><b>Admin view</b><br><br><img src="cid:$email_image_name" border=0></a><br><br>After login you have administrator rights. You can<br>${approve_text}rename/caption/delete/move the file.</font></td>
                           <td align="center" width="50%" valign="top" nowrap><$font><a href="$imagefolio_url?action=view&link=$category&image=$email_image_name&tt=$if_tagfile&ota=$one_time_access"><b>One time quick access</b><br><br><img src="cid:$email_image_name" border=0></a><br><br>You have one time, quick access to this file only.<br>You can ${approve_text}delete the file.</font></td>
                         </tr>
                       </table></center></body>|;
   my $type_out_2 = 'image/jpeg'; # the type of attachment
   my $id_out = $email_image_name;
   my $path_out = "$uploaddir/$mypattern$shortname.jpg";
   &send_mime_email($from_out, $to_out, $cc_out, $bcc_out, $subject_out, $type_out_0, $data_out_0, $type_out_1, $data_out_1, $type_out_2, $id_out, $path_out, $priority);
}

sub create_imagethumb_cache {
   if (!$group_media_upload_approval) {
      $cachefilename = "thumb~USER~$ifusername~sort1~show_tn1";
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";
      open (TCACHE,">>$cacheloc");
      print TCACHE "blah|$thumb_image|$category|$current_time|0|0|\n";
      close(TCACHE);
      chmod(0777,"$cacheloc");

      $cachefilename = "direct~$category";
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";
      open (TCACHE,">>$cacheloc");
      print TCACHE "blah|$thumb_image|$category|$current_time|0|0|\n";
      close(TCACHE);
      chmod(0777,"$cacheloc");
   }
}

sub write_file {
   undef $bytesread;
   undef $buffer;
   open (OUTFILE, ">$uploaddir/$image_to_upload") or &Error ("Could not open \"$uploaddir/$image_to_upload\".  Reason: $!"); 
   binmode OUTFILE;
   while ($bytesread = read($binary_image, $buffer, 1024)) { 
      print OUTFILE $buffer or &Error ("Could not save \"$uploaddir/$image_to_upload\".  Reason: $!"); 
   }
   close (OUTFILE);
   if ($ucount eq "2") {
      &update_index_files;
      if ($found_thumbnail && $use_single_file_upload) {
         if ($use_im) {
            require "$libpath/imagemagick.pl";
         }
         else {
            require "$libpath/imageconvert.pl"; &load_ic;
         }

         $ThumbCrop_im = ();
         $ThumbCrop_ic = ();

         if ($crop_thumb_width && $crop_thumb_height) {
            my ($ftw_width, $ftw_height) = imgsize("$uploaddir/$image_to_upload");
            if ($ftw_width && $ftw_height) {
               $width_factor = $ftw_width/$crop_thumb_width;
               $height_factor = $ftw_height/$crop_thumb_height;
               if ($width_factor > $height_factor) {
                  $ThumbDimensions = $ftw_width/$height_factor;
                  $ThumbCrop = ($ThumbDimensions-$crop_thumb_width)/2;
                  ($ThumbCrop) = split(/\./,$ThumbCrop);
                  $ThumbCrop_im = "${crop_thumb_width}x${crop_thumb_height}+${ThumbCrop}+0";
                  $ThumbCrop_ic = "${ThumbCrop} 0 ${crop_thumb_width} ${crop_thumb_height}";
               }
               else {
                  $ThumbDimensions = $ftw_height/$width_factor;
                  $ThumbCrop = ($ThumbDimensions-$crop_thumb_height)/2;
                  ($ThumbCrop) = split(/\./,$ThumbCrop);
                  $ThumbCrop_im = "${crop_thumb_width}x${crop_thumb_height}+0+${ThumbCrop}";
                  $ThumbCrop_ic = "0 ${ThumbCrop} ${crop_thumb_width} ${crop_thumb_height}";
               }
            }
         }

         if (!$use_im) {
            &do_ic("\"$uploaddir/$image_to_upload\"", "\"$uploaddir/$image_to_upload\"", $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCustom, $ThumbCrop_ic, '', '', 'decr', '', '');
         }
         else {
            &do_im("$uploaddir/$image_to_upload", "$uploaddir/$image_to_upload", $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCrop_im);
         }

      }
   }
   elsif ($ucount eq "3" && (lc($myextension_fullsize) eq 'zip')) {
      require Archive::Zip;
      my $zip = Archive::Zip->new();
      my $zip_extension = lc ($extension);
      $zip->addFile( "$uploaddir/$image_to_upload", "$shortname.$zip_extension" );
      my $member = $zip->memberNamed("$shortname.$zip_extension");
      $member->desiredCompressionMethod( 0 );
      $zip->writeToFileNamed( "$uploaddir/${mypattern_fullsize}${shortname}.$myextension_fullsize" );
      chmod(0777,"$uploaddir/${mypattern_fullsize}${shortname}.$myextension_fullsize");
      unlink("$uploaddir/$image_to_upload") unless lc($image_to_upload) eq lc("$mypattern_fullsize$shortname.$myextension_fullsize");
   }
}

########################################################
# Error
# shows error message if form not filled out correctly
########################################################
sub ErrorOLD{
print "Content-type: text/html\n\n";
local ($whoops) = @_;

print qq|
<html>
<head>
<title>Error!</title>

<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$admin_font color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><$admin_font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$admin_font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$admin_font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>

</body>
</html>
|;
$binary_image = (); # Needed for win32 to remove the tempfile
exit;
}

###############################################################################
# SAVE DATA TO CATEGORIES.TXT FILE
###############################################################################
sub update_index_files {

   open (CATFILE, "$catfile");
   my(@catfiledata)=<CATFILE>;
   close(CATFILE);

   foreach $catfiledata (@catfiledata) {
      ($catpath, $catcount, $catage) = split(/\t/, $catfiledata);
      if ($catpath eq $category){
         $catcount++;
         ($catage)  = (stat("$uploaddir/$image_to_upload"))[9];
         $catlist .= $catpath . "\t" . $catcount . "\t" . $catage . "\t\n";
      }
      else {
         $catlist .= $catfiledata;
      }
   }

   open(CATFILE, ">$catfile");
   if ($useflock) { flock(CATFILE, 2); }
   print CATFILE $catlist;
   if ($useflock) { flock(CATFILE, 8); }
   close(CATFILE);

}
1;