####CODEHEADER###

# (1) #########################################################################
# WHAT IS THE FULL PATH TO YOUR USER DATABASES?
# Path to the text file containing usernames and encrypted passwords
# For extra security you should store this outside on your Web server if
# possible and rename the default to something else.

$admindb = "$data_directory/db/admin_user.db";

# (4) #########################################################################
# PLEASE PROVIDE A SECRET 'KEY' THAT WILL BE USED TO ENCRYPT PASSWORDS.
# Change the value of $secret_key to any combination of numbers, letters,
# symbols, or spaces.
# ***WARNING*** After you change the value of $secret_key you must run 
# http://www.yourdomain.com/cgi-bin/ImageFolio3/admin/reset.cgi
# to reset the password for the default Admin user.
# THIS WILL DELETE ADMIN, GROUP and USER DATABASE!!!!!
# Then, login to the admin area with username/password: Admin/ImageFolio
# Afterwards you should not change the secret key value or run reset.cgi
# unless it is absolutely necessary as it will DELETE ADMIN, GROUP and USER DATABASE

$secret_key = "A secret key for encrypting passwords";
#$secret_key = "Robby Gordon Rules";

# (5) #########################################################################
# DO YOU WANT TO USE COOKIES FOR EASIER LOGIN?
# If so, it will store a cookie on the computer of each user who accesses this
# interface so next time they log in they won't have to type in a username or
# a password. 1 - Yes, 0 - No

$use_cookies = 1;

# (6) #########################################################################
# AFTER WHAT PERIOD OF INACTIVITY SHOULD SESSION FILES BE DELETED?
# ImageFolio will delete old session files if they have not been used for a
# specific period of time.  This is good security for those who log in and then
# stop working for a while.  The system will automatically lock them out and
# they will have to log in again to continue working.  What length of time would
# you like this to be? example:  1 = 1 day., .25 = 6 hours,  .015 = 21 minutes

$session_expiration = '.25';

# (8) #########################################################################
# WHAT TYPE STYLES WOULD YOU LIKE TO USE FOR THE BASIC TEXT ON ADMIN PAGES?

$admin_font = 'font face="Verdana,Arial,Helvetica" size="2"';
$admin_small_font = 'font face="Verdana,Arial,Helvetica" size="1"';
$admin_big_font = 'font face="Arial,Helvetica" color="#000000" size=3';

# (10) #########################################################################
# HOW LONG KEEP YOUR BACKUPS?
# Here you can set how many days backups should be kept of your index.txt and
# categories.txt files that are located in your "data/backup" directory.
# The default value is 15 days.

$backup_expiration = 15;


# (11) #########################################################################
# REMIND ME TO REBUILD THE INDEX WHEN I LOG OUT?
# If you set this to "1" then you will be reminded to rebuild the index every time
# you log out. RECOMMENDED!

$remind_rebuild = 1;

#################################################################################
###        SECTION 2   ImageMagick configuration                          #######
#################################################################################


# (12) #########################################################################
# UPLOAD FILES

$iBULC_upload = 1;
#$use_single_file_upload = 1;    # (Automatic create thumbnails) IMAGEMAGICK OR IMAGECONVERT REQUIRED !
#$use_manual_file_upload = 1;    # (Manual upload files plus thumbnails)
#$use_link_upload = 1;

# (13) ########################################################################
# BATCH UPLOAD FILES
# You can ether choose to do client-side or server-side thumbnailing. For server-side
# thumbnailing IMAGEMAGICK OR IMAGECONVERT is required!

$iBULC_thumbnailing = 0;


# (14) #########################################################################
# Overwrite if filename allready exist?
# $overwrite_if_exist = 1;


# (15) #########################################################################
# KEEP THE ORIGINAL FILE?
# If you upload a high resolution "TIF" or "JPG" then ImageFolio will keep the
# origianal file if you have "$use_fullsize=1" in your config.pl. Make sure that
# the extension of the file you upload is the same (case sensitive) as the 
# "$myextension_fullsize" set in the config.pl otherwise users might not be able
# to open the file since ImageFolio WILL add that extension if it is not there!


# (16) ###################################################################
# WHAT IS THE FULL (ABSOLUTE) PATH TO YOUR 'temp' DIRECTORY.
# Create or designate a temporary directory!
# The 'temp' directory is used to store uploads temporarily.  Images are
# automatically deleted from this space. It's permissions must be set to 777.

$tempdir = "$base_if_path/temp";

# (17) ###################################################################
# WHAT IS THE MAXIMUM WIDTH OR HEIGHT FOR YOUR THUMBNAILS AND IMAGES
# Your images and thumbnails will be scaled in proportion.  The width or
# height, whichever is greater, will be scaled to the dimension supplied
# below.-- 130--500

$ThumbDimensions = 130;
$ImageDimensions = 700;

# (18) ###################################################################
# ALL IMAGES ARE SAVED AS JPEGs.  WHAT QUALITY WOULD YOU LIKE YOUR
# THUMBNAILS AND IMAGES TO BE SAVED IN?
# Choose a numberic value between 0 and 100.  Note that higher numbers
# mean better quality but larger file size.

$ThumbQuality = 70;
$ImageQuality = 85;

# (19) ###################################################################
# YOU CAN AUTOMATICALLY HAVE THE CONTRAST OF ALL THUMBNAILS AND IMAGES
# INCREASED BY SETTING THEIR VALUES BELOW.
# Specify a numeric value between 0 and 100.

$ThumbContrast = 5;
$ImageContrast = 5;

# (20) ###################################################################
# YOU CAN AUTOMATICALLY HAVE THE SHARPNESS OF ALL THUMBNAILS AND IMAGES
# INCREASED BY SETTING THEIR VALUES BELOW.
# Specify a numeric value between 0 and 100.
# ImageMagick around 0.7 is good
# ImageConvert around 10-30 good

$ThumbSharpness = '20';
$ImageSharpness = '10';

# (21) ###################################################################
# WHAT IS THE MAXIMUM FILE SIZE FOR AN IMAGE THAT A USER CAN UPLOAD?
# Put a value in bytes.  So, for 200 kb, you would put '200000'
# Please note that ImageFolio will automatically size this down, so keep
# this number fairly high.

$max_size = (1024 * 1024) * 1000; # (1024 * 1024) = 1 MB


# Modify brightness (-100...100)
# $ImageCustom .= " -brightness 10"; #EXAMPLE
# $ThumbCustom .= " -brightness 10";

# Enhance detail
# $ImageCustom .= " -edetail";
# $ThumbCustom .= " -edetail";

# Enhance edges (1...100)
# $ImageCustom .= " -eedge 10";
# $ThumbCustom .= " -eedge 10";

# Edge detect light/medium/heavy
# $ImageCustom .= " -edgedetect medium";
# $ThumbCustom .= " -edgedetect medium";

# Enhance focus
# $ImageCustom .= " -efocus";
# $ThumbCustom .= " -efocus";

# Emboss
# $ImageCustom .= " -emboss";
# $ThumbCustom .= " -emboss";

# Emboss more
# $ImageCustom .= " -embossmore";
# $ThumbCustom .= " -embossmore";

# Equalize
# $ImageCustom .= " -equalize";
# $ThumbCustom .= " -equalize";

# Modify gamma (0.01<->5.0)
# $ImageCustom .= " -gamma 1.0";
# $ThumbCustom .= " -gamma 1.0";

# Convert in Grey Scale (256, 128, 64, 32, 16, 8 or 4)
# $ImageCustom .= " -grey 256";
# $ThumbCustom .= " -grey 256";

# Negate
# $ImageCustom .= " -negate";
# $ThumbCustom .= " -negate";

# Reduce noise
# $ImageCustom .= " -noise reduce";
# $ThumbCustom .= " -noise reduce";

# Normalize
# $ImageCustom .= " -normalize";
# $ThumbCustom .= " -normalize";

# Shear
# $ImageCustom .= " -shear";
# $ThumbCustom .= " -shear";

# Slice
# $ImageCustom .= " -slice";
# $ThumbCustom .= " -slice";

# Soften (1...100)
# $ImageCustom .= " -soften 10";
# $ThumbCustom .= " -soften 10";

# Solarize (1...255)
# $ImageCustom .= " -solarize 25";
# $ThumbCustom .= " -solarize 25";

# Spread (1...32)
# $ImageCustom .= " -spread 3";
# $ThumbCustom .= " -spread 3";


# NO NEED TO MODIFY ANYTHING BELOW THIS LINE #################################
$allow_multiple_administrators = 1;

$admin_setup_url  = $imagefolio_url . "?admin=admin_user_setup";
$group_setup_url  = $imagefolio_url . "?admin=gallery_group_setup";
$buildurl         = $imagefolio_url . "?admin=build&ct=$current_time";
$adminurl         = $imagefolio_url . "?admin=admin";
$reseturl         = $imagefolio_url . "?admin=reset";
$imuploaddurl     = $imagefolio_url . "?ifup=imupload";
$iBULC_uploaddurl = $imagefolio_url . "?ifup=iBULC_upload";
$uploadurl        = $imagefolio_url . "?ifup=upload";
$uploadlinkurl    = $imagefolio_url . "?ifup=linkupload";


##

1;
