####CODEHEADER###


# (1) ###################################################################
# DO YOU WANT TO RECEIVE AN EMAIL EACH TIME SOMEONE SENDS A POSTCARD?
# If yes, you will receive a notification email each time someone sends
# out a postcard from your site.  You will also receive a link to view
# the postcard. 1- Yes, 0 - No

$receive_copy = 1;

# The Picture Post Mod also saves the name and email address of each
# person who submits an image. Read the "log configuration" in your 
# config.pl for more info.


# (2) ####################################################################
# HOW MANY DAYS DO YOU WANT TO STORE POSTCARDS?
# Postcards will automatically be deleted when someone sends a postcard
# if they are older than the number of days specified below.

$exp = '30';


# (3) ####################################################################
# AFTER A CARD HAS BEEN SENT, THE SENDER WILL SEE A PREVIEW OF THE CARD
# ALONG WITH THE STATEMENT BELOW.  HOW WOULD YOU LIKE THIS STATEMENT TO
# READ?
# Type any message below and note that any references surrounded by percent
# signs will be replaced by the script automatically.

$sent_message = qq|
<font face="Verdana,Arial,Helvetica" size=2><b>
Thank you %%%SENDER_NAME%%% for using our postcard system.<br>
Your card has been sent to <a href="mailto:%%%RECIPIENT%%%">%%%RECIPIENT%%%</a>!

<br><br>

<a href="%%%CARD_URL%%%">View Card</a><br>
<a href="%%%RETURN_URL%%%">Return to Site</a></b></font>
|;


# (4) ###################################################################
# WHEN A NOTIFICATION EMAIL IS SENT TO THE RECIPIENT OF THE POSTCARD, HOW
# WOULD YOU LIKE THE MESSAGE TO READ?
# Type any message below and note that any references surrounded by percent
# signs will be replaced by the script automatically.
# Note: it the sender chooses to sent a HTML postcard this message won't be sent
# but instead the postcard itself!

$notification_message = qq|
This is a notice to inform you that %%%SENDER_NAME%%% has sent you a postcard!

You can pick up your postcard at the following URL:

%%%CARD_URL%%%

If the above URL is not clickable, please copy and paste the Web address into your browser.

Your postcard was sent on %%%DATE%%% and will remain available for pickup for the next $exp days.

This email was sent to %%%RECIPIENT%%%.  If you are not the intended recipient, please disregard this email.

---------------
$site_title
$imagefolio_url

|;


# (5) ####################################################################
# WHAT FILE EXTENSION DO YOU WISH TO USE FOR POSTCARDS THAT ARE GENERATED
# BY THIS SCRIPT?
# Should be .htm, .html, or .shtml.  You would use .shtml if you require
# any type of SSI (Server Side Includes) on postcards.  Please note that
# there are two different templates, one for previewing and sending
# postcards (preview_card.html), and one that is actually viewed by the
# recipient of the postcard (send_card.html)  This extension is for
# send_card.html only.
#
# NOTE:  DO NOT CHANGE THE NAME OF THE send_card.html TEMPLATE ITSELF
# AS THE SCRIPT WILL GENERATE A COMPLETELY NEW HTML PAGE FOR EACH AND
# EVERY POSTCARD AUTOMATICALLY.

$cardext = '.html';

# (6) ####################################################################
# SEND CARD AS HTML EMAIL?
# Do you want to give users the option of sending the card as a HTML email?

$send_html_email = 1;


# NO NEED TO MODIFY ANYTHING BELOW THIS LINE #############################

# templates ##########

$createcard_template = $template_directory . "/create_card.html";
$send_template       = $template_directory . "/send_card.html";

# END OF CONFIGURATION ########################################################

$mod_name = "Postcard Mod";
$mod_version = $config_version;

1;


