####CODEHEADER###

###############################################################################
###############################################################################
#                                                                             #
#         SECTION 1 :        GENERAL CONFIGURATION                            #
#                                                                             #
###############################################################################
###############################################################################

# (1) ###################################################################
# WHAT ICONS AND TEXT WILL YOU BE USING?
# Please put a one (1) behind which you will be using. Choose between "Lightbox",
# "My Album", "Wishlist" and "Favorites". You can only select one of these.

$use_lightbox=1;
$use_my_album=0;
$use_wishlist=0;
$use_favorites=0;

# (2) ###################################################################
# DO YOU WANT TO USE DIFFERENT COLORS FOR THE CURRECT LIGHTBOX AND SAVED LIGHTBOX?
# The background color of the lightbox, where it says "Lightbox" or "Saved Lightbox",
# can be set here. This might be a good idea to show the difference to the
# site visitor. Default = '#000000' AND '#99000'

$current_bgcolor='#000000';
$saved_bgcolor='#990000';

# (3) ###################################################################
# DO YOU WANT TO SHOW THE TOTAL LIGHTBOX SIZE IN THE LIGHTBOX? (YES=1, NO=0)
# This shows the size in Kb or Mb of all files together

$showtotallightboxsize=1;

# (4) ###################################################################
# DO YOU WANT TO USE THE ZIP FEATURE IN THE LIGHTBOX? (YES=1, NO=0)
# This is a free lightbox add-on and currently in beta testing. Note that you need
# to have the modules Compress::Zlib and Archive::Zip installed on your server.
# Also, if you set $download_lightbox to 1, please specify how long a
# zipfile should be stored on your server. example: 0.25 = 6 hours, 0.04 = 1 hour
# Downloads can be logged. Read the "log configuration" in your config.pl.

$download_lightbox=1;
$zip_expiration = '0.04';

# (5) ###################################################################
# DO YOU WANT TO USE THE EMAIL FEATURE IN THE LIGHTBOX? (YES=1, NO=0)
# If you choose YES then continue with SECTION 2. If you choose NO then you are
# done now.

$email_lightbox=1;


# (6) ###################################################################
# GUEST LIGHTBOX ACCESS?
# You can email a lightbox to everyone (guests) with an email address. If you
# have the Multi User Mod installed you can deny guest access to you gallery.
# This will have as affect that a guest can not view a lightbox that is emailed
# to him. By setting this value to "1" you do give lightbox access regardless.

$guest_lightbox_access = 1;

# (7) ###################################################################
# DO YOU RUN MULTIPLE GALLERIES ON ONE DOMAIN?
# The lightbox uses a cookie to store the image info in. The name of the
# cookie is by default 'if_lightbox'. If you use more then one lightbox on one
# domain then they will all read the same cookie (if_lightbox) and that will mix
# up the contents of your lightbox. Please specify the name of the cookie
# for the second lightbox installation here.

$lightbox_cookie_name = 'if_lb_4';

##########################      END SECTION 1      ############################

###############################################################################
###############################################################################
#                                                                             #
#         SECTION 2 :        LIGHTBOX EMAIL CONFIGURATION                     #
#                                                                             #
###############################################################################
###############################################################################

# (8) ####################################################################
# HOW MANY DAYS DO YOU WANT TO STORE EMAILED LIGHTBOXES?
# Emailed lightboxes will automatically be deleted when someone emailes a lightbox
# if they are older than the number of days specified below.
# They take up very little space. Between 50 and 400 bytes with a maximum of 4Kb.

$exp = '90';

# (9) ###################################################################
# WHEN A NOTIFICATION EMAIL IS SENT TO THE RECIPIENT OF THE LIGHTBOX, HOW
# WOULD YOU LIKE THE MESSAGE TO READ?
# Type any message below and note that any references surrounded by percent
# signs will be replaced by the script automatically.

$notification_message = qq|%%%PERSONAL_MESSAGE%%%

------------------

You can view the %%%LIGHTBOX_TEXT%%% at the following URL:

%%%SAVED_URL%%%

This %%%LIGHTBOX_TEXT%%% was sent on %%%DATE%%% and will remain available for viewing for the next $exp days.

------------------

This %%%LIGHTBOX_TEXT%%% contains the following files:
%%%IMAGELIST%%%
------------------

%%%SITE_TITLE%%%
%%%IMAGEFOLIO_URL%%%
|;

$shared_notification_message = qq|%%%PERSONAL_MESSAGE%%%

------------------

You can view/edit this shared %%%LIGHTBOX_TEXT%%% at the following URL:

%%%SAVED_URL%%%

Any changes you make will viewable by all other who share this lightbox.

%%%SITE_TITLE%%%
%%%IMAGEFOLIO_URL%%%
|;

# (10) ###################################################################
# DO YOU WANT THAT SITE VISITORS CAN ONLY SEND LIGHTBOXES TO YOU? (YES=1, NO=0)

$limitsend=0;

# (11) ###################################################################
# DO YOU AS THE SITE OWNER WISH TO RECEIVE A COPY OF EACH EMAIL LIGHTBOX? (YES=1, NO=0)

$emailcopy=1;

# (12) ###################################################################
# WHEN A LIGHTBOX IS SEND, THIS IS THE MESSAGE THAT IS SHOWN TO TELL THE
# SENDER THAT IT WAS SUCCESSFULLY SENT
# Type any message below and note that any references surrounded by percent
# signs will be replaced by the script automatically. The <br> stands for linebreak.
# You can use any other HTML code in this message too.

$successfull_sent_message = qq|
Dear %%%SENDER_NAME%%% (%%%SENDER_EMAIL%%%),<br><br>
Your %%%LIGHTBOX_TEXT%%% was sent to %%%RECIPIENT%%% and saved as well.<br><br>
<a href="javascript:load('%%%SAVED_URL%%%')">Saved %%%LIGHTBOX_TEXT%%%</a><br><br>
You can bookmark this page for later viewing but it will be removed from our server
in %%%EXPIRE%%% days.<br><br>
Yours sincerely,<br><br>
Site Owner
|;

$successfull_shared_message = qq|
Dear %%%SENDER_NAME%%% (%%%SENDER_EMAIL%%%),<br><br>
Your shared %%%LIGHTBOX_TEXT%%% was sent to %%%RECIPIENT%%%.<br><br>
The recipient will be able to see your lightbox in live view. Any changes you make 
(or others with permission) will be vissable by this receipient.
<br><br>
Yours sincerely,<br><br>
Site Owner
|;

##########################      END SECTION 2      ############################

###############################################################################
#                 NO NEED TO MODIFY ANYTHING BELOW THIS LINE                  #
###############################################################################

sub load_lb_icons {
   if ($use_lightbox==1){
      $lightbox_name="Lightbox";
      $lightbox_text="lightbox";
      $lightbox_yes_gif="lightbox_yes.$ButtonExt";
      $lightbox_no_gif="lightbox_no.$ButtonExt";
      $lightbox_clear_gif="lightbox_clear.$ButtonExt";
      $lightbox_view_gif="lightbox_view.$ButtonExt";
   }
   elsif ($use_my_album==1){
      $lightbox_name="My Album";
      $lightbox_text="album";
      $lightbox_yes_gif="album_yes.$ButtonExt";
      $lightbox_no_gif="album_no.$ButtonExt";
      $lightbox_clear_gif="album_clear.$ButtonExt";
      $lightbox_view_gif="album_view.$ButtonExt";
   }
   elsif ($use_wishlist==1){
      $lightbox_name="Wishlist";
      $lightbox_text="wishlist";
      $lightbox_yes_gif="wishlist_yes.$ButtonExt";
      $lightbox_no_gif="wishlist_no.$ButtonExt";
      $lightbox_clear_gif="wishlist_clear.$ButtonExt";
      $lightbox_view_gif="wishlist_view.$ButtonExt";
   }
   elsif ($use_favorites==1){
      $lightbox_name="Favorites";
      $lightbox_text="favorites";
      $lightbox_yes_gif="favorites_yes.$ButtonExt";
      $lightbox_no_gif="favorites_no.$ButtonExt";
      $lightbox_clear_gif="favorites_clear.$ButtonExt";
      $lightbox_view_gif="favorites_view.$ButtonExt";
   }
}

$lightbox_send_url            = $imagefolio_url . "?main=lightbox_send";
$lightbox_zip_url             = $imagefolio_url . "?main=lightbox_zip";
$emailed_lightboxes_directory = $sessions_dir;
$emailed_lightboxes_ext = ".lightboxes_sent";
$shared_lightboxes_ext = ".lightboxes_shared";
$zipped_lightboxes_url = $tempdirurl;
$zipped_lightboxes_directory = $tempdir;
$zipped_lightboxes_ext = ".zip";

# END OF CONFIGURATION ########################################################

$mod_name = "Lightbox Mod";
$mod_version = $config_version;
$untitled_lightbox = "Untitled";

1;
