####CODEHEADER###

###############################################################################
###                              MANUAL CONFIGURATION                      ####
###############################################################################
# If you have problems getting ImageFolio's "zero config" to work then please
# fill in the correct values here (2 to 5)

# (2) #########################################################################
# WHAT IS THE ABSOLUTE PATH TO THE DIRECTORY CONTAINING imageFolio.cgi,
# imageRate.cgi, AND THE data, admin, config and if_lib DIRECTORIES?
# Type the full path below. (no trailing slash)

#$base_scripts_path = '/home/httpd/html/www.yourdomain.com/cgi-bin/ImageFolio43';

# (3) #########################################################################
# WHAT IS THE URL TO THE DIRECTORY CONTAINING imageFolio.cgi,
# imageRate.cgi, config.pl, AND THE data, templates, AND if_lib DIRECTORIES?
# Type the URL to the directory you defined above. (no trailing slash)

#$base_scripts_url = 'http://www.yourdomain.com/cgi-bin/ImageFolio43';

# (4) #########################################################################
# WHAT IS THE ABSOLUTE PATH TO THE IMAGEFOLIO DIRECTORY CONTAINING the directories:
# cache, gallery, if_images, temp.

#$base_if_path = '/home/httpd/html/www.yourdomain.com/ImageFolio43_files';

# (5) #########################################################################
# WHAT IS THE ABSOLUTE URL TO THE IMAGEFOLIO DIRECTORY CONTAINING the directories:
# cache, gallery, if_images, temp.

#$base_if_url = 'http://www.yourdomain.com/ImageFolio43_files';

###############################################################################
###                           END MANUAL CONFIGURATION                     ####
###############################################################################
# NO NEED TO MODIFY ANYTHING BELOW THIS LINE #################################

$SSL_support = 0;

if (!$base_if_url) {
   eval{
      require "$currdir/data/config/ifpaths.pl";
      my %PATHS = &get_paths;
      if ($PATHS{'currdir'} eq $currdir && $ENV{'QUERY_STRING'} !~ /resetpaths/) {
         foreach my $key (keys %PATHS) {
            $$key = $PATHS{$key};
         }
      }
   };
   if (!-d "$base_scripts_path" or !-d "$image_directory" or !$ENV{'HTTP_USER_AGENT'}) {
      unlink ("$currdir/data/config/ifpaths.pl") if $ENV{'HTTP_USER_AGENT'};
      $config_version = ();
      $imagefolio_files_directory = "ImageFolio43_files"; # Change this if you have renamed the default "ImageFolio43_files" directory.
      my @webroot = ('','html','httpdocs','htdocs','www','Documents','public_html','wwwroot'); # If you have your "cgi-bin" located outside of your webroot then make sure your webroot directory is listed. Default = ('', 'html', 'httpdocs', 'htdocs', 'www')
      foreach (@webroot) {
         &locate_ifdir($_);
         last if $base_if_url;
      }
      if (!$base_if_url) {
         print qq|Content-type: text/html\n\n<b> ImageFolio's zero config problem:</b><br><br>We could not locate the "$imagefolio_files_directory" directory on your server. There are two solutions:<br><br><b>1:</b> Change the value of <b>\$imagefolio_files_directory</b> in <b>pathsurls_config.pl</b> to match the correct name of the ImageFolio directory that contains the subdirectories <b>cache</b>, <b>gallery</b>, <b>if_images</b>, <b>temp</b>, etc.<br><br>or<br><br><b>2:</b> In your <b>pathsurls_config.pl</b> uncomment the 4 lines in the "MANUAL CONFIGURATION" and set them correctly.|;
         exit;
      }
   }
   $base_scripts_url       = "https://$ENV{'HTTP_HOST'}$part_base_scripts_url";
   $base_if_url            = "https://$ENV{'HTTP_HOST'}$part_base_if_url";
}
$currdir                   = $base_scripts_path;
# scripts and databases
$imagefolio_url            = "$base_scripts_url/$currscript";
$imagefolio_redirect_url   = $imagefolio_url;
$imagefolio_secure_url     = $imagefolio_url;
&SSL_urls if $SSL_support;
$admindir_directory        = $base_scripts_path . "/admin";
$config_directory          = $base_scripts_path . "/config";
$libpath                   = $base_scripts_path . "/if_lib";
$mainpath                  = $base_scripts_path . "/main";
$commercepath              = $base_scripts_path . "/commerce";
$db_link_path              = $libpath . "/db_link";
$cpanpath                  = $base_scripts_path . "/CPAN"; # Comprehensive Perl Archive Network (http://www.cpan.org/)
$lightbox_directory        = $base_if_path . "/lightbox";
$lightbox_url              = $base_if_url . "/lightbox";
$image_directory           = $base_if_path . "/" .$gallery_root;
$imageurl                  = $base_if_url . "/" .$gallery_root;
$data_directory            = $base_scripts_path . "/data"; # cannot be changed unless "data" replaced in this file and imageFolio.cgi, imageLeech.pl, imageZoomify.pl.
$commercedata              = $data_directory . "/commerce";
$leechdir                  = $data_directory . "/leech";
$logdir                    = $data_directory . "/logs";
$sessions_dir              = $data_directory . "/sessions";
$cache_directory           = $base_if_path . "/cache";
$cache_url                 = $base_if_url . "/cache";
$catdesc                   = $data_directory . "/catdesc.txt";
$indexfile                 = $data_directory . "/index.txt";
$catfile                   = $data_directory . "/categories.txt";
$disk_usage_file           = $data_directory . "/disk_usage.txt";
$tempdir                   = $base_if_path . "/temp";
$tempdirurl                = $base_if_url . "/temp";
$tempuploaddir             = $tempdir;
$base_skin_dir             = $base_if_path . "/skins";
$base_skin_url             = $base_if_url . "/skins";
$skin_dir                  = $base_skin_dir . "/" . $skin_name;
$skin_url                  = $base_skin_url . "/" . $skin_name;
$current_time              = time();
$image_cache_directory     = $cache_directory . "/images";
$image_cache_url           = $cache_url . "/images";
$new_imageurl              = $imageurl;
if ($antileech) {
   $imageurl               = $imagefolio_url . "?main=imageLeech&source=IF&ct=$current_time&file=";
   $imageurl               =~ s/^http\:/https\:/i if lc($ENV{'HTTPS'}) eq 'on';
}


# file and directory locations for Post Cards ##########
$cards_directory     = "$base_if_path/postcards";
$cards_url           = "$base_if_url/postcards";
$midi_directory      = "$cards_directory/midi";
$midi_url            = "$cards_url/midi";
$post_db             = "$cards_directory/post.db";

###############################################################################
# LOCATE IF FILES
# Routine for finding the directory with the ImageFolio files
###############################################################################
sub locate_ifdir {
   my $html_httpdocs_htdocs_www = shift;
   $html_httpdocs_htdocs_www .= "/" if $html_httpdocs_htdocs_www;
   $base_scripts_path = $currdir;
   ($base_scripts_url) = $ENV{'SCRIPT_NAME'} =~ m#^(.*)\/#;
   $part_base_scripts_url = $base_scripts_url;
   $base_scripts_url = "http://$ENV{'HTTP_HOST'}$base_scripts_url";
   $base_if_path = $base_scripts_path;
   for($i=1;$i<=3;$i++){
      if ($base_scripts_path eq ".") {
         $base_if_path .= "/..";
      }
      else {
         ($base_if_path) = $base_if_path =~ m#^(.*)\/(.*)#;
      }
      if (-d "$base_if_path/${html_httpdocs_htdocs_www}$imagefolio_files_directory") {
         $backpath = $i;
         last;
      }
   }
   if ($backpath) {
      $base_if_url = $base_scripts_url;
      $part_base_if_url = $part_base_scripts_url;
      for($i=1;$i<=$backpath;$i++){
         ($base_if_url) = $base_if_url =~ /(.*)\/(.*$)/;
         ($part_base_if_url) = $part_base_if_url =~ /(.*)\/(.*$)/;
      }
      $base_if_url .= "/$imagefolio_files_directory";
      $part_base_if_url .= "/$imagefolio_files_directory";
      $base_if_path .= "/${html_httpdocs_htdocs_www}$imagefolio_files_directory";
   }
   elsif (!$ENV{'HTTP_USER_AGENT'}) {
      $base_if_url = 1;
      $base_if_path = $base_scripts_path;
      for($i=1;$i<=3;$i++){
         $base_if_path .= "/..";
         if (-d "$base_if_path/${html_httpdocs_htdocs_www}$imagefolio_files_directory") {
            $base_if_path .= "/${html_httpdocs_htdocs_www}$imagefolio_files_directory";
            last;
         }
      }
   }
}

if (!$config_version && !$skip_path_file && $ENV{'HTTP_USER_AGENT'}) {
   &non_SSL_urls if $SSL_support;
   open(PATHS,">$data_directory/config/ifpaths.pl") or die("Could not create $data_directory/config/ifpaths.pl.  Reason: $!");
   print PATHS 'sub get_paths {' . "\n";
   print PATHS '   return (' . "\n";
   print PATHS '      currdir                   => "' . $currdir . "\",\n";
   print PATHS '      base_scripts_path         => "' . $base_scripts_path . "\",\n";
   print PATHS '      base_scripts_url          => "' . $base_scripts_url . "\",\n";
   print PATHS '      part_base_scripts_url     => "' . $part_base_scripts_url . "\",\n";
   print PATHS '      base_if_path              => "' . $base_if_path . "\",\n";
   print PATHS '      base_if_url               => "' . $base_if_url . "\",\n";
   print PATHS '      part_base_if_url          => "' . $part_base_if_url . "\",\n";
   print PATHS '      imagefolio_secure_url     => "' . $imagefolio_secure_url . "\",\n";
   print PATHS '      imagefolio_redirect_url   => "' . $imagefolio_redirect_url . "\",\n";
   print PATHS '      image_directory           => "' . $image_directory . "\",\n";
   print PATHS '      imageurl                  => "' . $imageurl . "\",\n";
   print PATHS '      tempdir                   => "' . $tempdir . "\",\n";
   print PATHS '      tempdirurl                => "' . $tempdirurl . "\",\n";
   print PATHS '      data_directory            => "' . $data_directory . "\",\n";
   print PATHS '      libpath                   => "' . $base_scripts_path . "/if_lib\",\n";
   print PATHS '      config_version            => "' . 4.3 . "\",\n";
   print PATHS '   );' . "\n";
   print PATHS "}\n";
   print PATHS "1;\n";
   close(PATHS);
   chmod(0777,"$data_directory/config/ifpaths.pl");
   &SSL_urls if $SSL_support;
}

sub SSL_urls {
   $imagefolio_secure_url     =~ s/^http\:/https\:/i;
   if (lc($ENV{'HTTPS'}) eq 'on') {
      $base_if_url             =~ s/^http\:/https\:/i;
      $imagefolio_redirect_url =~ s/^http\:/https\:/i;
   }
}

sub non_SSL_urls {
   $imagefolio_secure_url   =~ s/^https\:/http\:/i;
   $base_if_url             =~ s/^https\:/http\:/i;
   $imagefolio_redirect_url =~ s/^https\:/http\:/i;
   $imageurl                =~ s/^https\:/http\:/i;
   $tempdirurl              =~ s/^https\:/http\:/i;
}

1;