#!/usr/bin/perl

# This is a free script to be meant as an example. Although is it fully functionally it is recommended
# you modify it to fit your needs.


#############################################################################################
#######################################  BEGIN SETUP  #######################################
#############################################################################################

   sub setup_pass {
      #Choose a password to encrypt the critical data with. Leave blank for no encryption.
      $encryption_key = "password";
   }

   sub setup_client {
      # This is the main configuration part. The information here will be used for the setup of the iBULC client as
      # outlined here: http://www.ibulc.com/developers/client_setup.shtml
      my $iB_version             = "1.2";
      my $iB_random              = time;
      my $iB_upload              = "http://www.domain.com/cgi-bin/iBULC.cgi";
      my $iB_return              = "http://www.domain.com/cgi-bin/gallery.cgi?do=latest_uploads";
      my $iB_types               = "jpg,tif,pdf,psd,eps";
      my $iB_max                 = "1048576";
      my $iB_original            = "1";
      my $iB_medium              = "medium_|450|450|0|85|10|1";
      my $iB_small               = "small_|100|100|0|85|10|0";
      my $iB_field_value         = "whatever";
      my $iB_field_name          = "Input field";
      my $iB_cookie              = "[TEST1->Test cookie value 1][TEST2->Test cookie value 2]";
      my $iB_watermark           = "http://www.ibulc.com/images/iBULC_watermark.png";
      my $iB_encryption          = crypt("$iB_types~$iB_max~$iB_original~$iB_medium~$iB_small~$iB_field_value~$iB_cookie~$iB_watermark", $encryption_key) if $encryption_key;
      $iB_encryption             =~ s/[^a-zA-Z0-9]//g;
      my $iB_packets             = "1";
      my $iB_bgcolor             = "FFFFFF";
#     my $iB_stylesheet          = "http://www.yourdomain.com/iBULC/iBULC_stylesheet.css";
      my $iB_display             = "popup"; # blank, popup or iframe
      my $iB_custom_result       = "1";
      my $iB_language            = "English"; # English, Dutch or German
      my $iB_clock               = "Black"; # Set this to "White" if you are using a dark background color in your stylesheet.
      my $iB_watermark_gravity   = "Center";
      # Now we put all this stuff together to get the iBULC setup query.
      my $iB_query = "iB_version=$iB_version;iB_random=$iB_random;iB_upload=$iB_upload;iB_return=$iB_return;iB_types=$iB_types;iB_max=$iB_max;iB_original=$iB_original;iB_medium=$iB_medium;iB_small=$iB_small;iB_field_value=$iB_field_value;iB_field_name=$iB_field_name;iB_cookie=$iB_cookie;iB_encryption=$iB_encryption;iB_packets=$iB_packets;iB_bgcolor=$iB_bgcolor;iB_stylesheet=$iB_stylesheet;iB_display=$iB_display;iB_custom_result=$iB_custom_result;iB_language=$iB_language;iB_clock=$iB_clock;iB_watermark=$iB_watermark;iB_watermark_gravity=$iB_watermark_gravity";
      return $iB_query;
   }

   sub setup_upload {
      # Set the directory were the files should be uploaded to. Make sure it is writable (CHMODD 666).
      $uploaddir = '/home/httpd/www.yourdomain.com/html/temp_upload';
   }

#############################################################################################
########################################  END SETUP  ########################################
#############################################################################################

   eval {
      $| = 1;
      use CGI qw(:standard);
      &parse_cookies;
      &start;
   };

   if ($@) { print "Content-type: text/html\n\n<pre>Script Error: $@</pre>\n"; }
   exit;


###############################################################################
# START
# Loading the form with and then redirecting to the correct subroutine based
# on the input.
###############################################################################
   sub start {
      $query = new CGI;

      # Read the upload directory and set the temp dir to this dir as well.
      &setup_upload;
      $CGITempFile::TMPDIRECTORY = $uploaddir;

      # The original file
      $file1 = $query->param("FILE1");
      # The medium resized file (jpg image)
      $file2 = $query->param("FILE2");
      # The small resized file (jpg image)
      $file3 = $query->param("FILE3");
      $field = $query->param("FIELD");
      $fraudkey = $query->param("FRAUD_KEY");
      $comparekey = $query->param("COMPARE_KEY");

      print "Content-type: text/html\n\n";

      if ($file1 or $file2 or $file3) {
         # Doing the actual file upload
         &upload;
         $file1 = (); # Needed for win32 to remove the tempfile
         $file2 = (); # Needed for win32 to remove the tempfile
         $file3 = (); # Needed for win32 to remove the tempfile
      }
      elsif ($fraudkey && $comparekey) {
         # Comparing the encryption key.
         &fraud_check;
      }
      else {
         &setup_ibulc;
      }
   }

###############################################################################
# SETUP iBULC
# Getting the correct parameters for the setup of the iBULC client. 
###############################################################################
   sub setup_ibulc {


      # Here will load the setup and URL encode the complete setup string to feed to the iBULC client.
      &setup_pass;
      my $iB_query = &setup_client;
      $iB_query =~ s/([^a-zA-Z0-9])/"%" . sprintf("%2x", ord($1))/ge;

      # Here we print out a little HTML page. A JavaScript is include that checks if the iBULC client
      # is running. If it is running it forwards the user to his directory listing so that he can start
      # selecting files he wants to upload. If the iBULC client is not running then a message shows up
      # to start iBULC or download it if it was never installed before.

      print qq|<html>
      <head>
      <title>iBULC setup</title>
      <script language="JavaScript">
      setup = 0;
      function check_status(){
         now = new Date();
         iBULC=new Image();
         iBULC.onload=online;
         iBULC.src='http://127.0.0.1:1125/images/dot.gif?'+now.getTime();
         if (!setup) {
            window.setTimeout("check_status()", 1000);
         }
      }
      function online() {
         setup = 1;
         window.focus();
         location.href = 'http://127.0.0.1:1125/setup/?$iB_query';
      }
      </script>
      </head>
      <body bgcolor="#FFFFFF" text="#000000" onLoad="check_status()">
      Currently you do not have the <a href="http://www.ibulc.com" target="_blank">internet Batch Up-Load
      Component</a> running. If you have downloaded it before then please run it now or download it here.<br><br>
      <center>
      <a href="http://download.ibulc.com/iBULCsetup-win.exe">Windows 98/ME/NT/2000/XP</a> or 
      <a href="http://download.ibulc.com/iBULCsetup-mac.dmg.gz">Mac OS X</a>
      </center>
      </body>
      </html>|;
   }

###############################################################################
# FRAUD CHECK
# Before iBULC starts uploading it will connect to your script and verify the
# encryption key. You need to return either TRUE or FALSE. This is only done
# once at the beginning of each upload session.
###############################################################################
   sub fraud_check {
      &setup_pass;
      $comparekey = crypt($comparekey, $encryption_key);
      $comparekey =~ s/[^a-zA-Z0-9]//g;
      if ($comparekey eq $fraudkey) {
         print "TRUE";
      }
      else {
         print "FALSE";
      }
   }

###############################################################################
# UPLOAD
# UPLOAD the files.
###############################################################################
   sub upload {

       my ($start_types,$start_max,$totalbytes,$bytesread,$buffer);

      # Read the encryption key
      &setup_pass;

      # If the encryption key has been set then check with every upload if the
      # $comparekey still matches the $fraudkey. I know, this is overly paranoid
      # and is not really needed. It is just to make sure that your upload script
      # is not used by anything else then the iBULC uploader. If this part is ommitted
      # a user could in theory configure a standard browser upload button to use your
      # script to upload files. The other, simpler, way is to use cookies (which iBULC
      # support) to store login info but that is not as fool proof as this method.

      if ($encryption_key) {
         ($start_types, $start_max) = split(/\~/, $comparekey);
         $comparekey = crypt($comparekey, $encryption_key);
         $comparekey =~ s/[^a-zA-Z0-9]//g;
         if ($comparekey ne $fraudkey) {
            print "FRAUD_KEY and COMPARE_KEY do not match";
            exit;
         }
      }


      # Now it is time to do something with your "$iB_field_value" and "$iB_cookie" that you
      # specified in the setup. The iBULC client has returned that information and with CGI.pm
      # and the "parse_cookies" routine we were were able to read those. So if you had setup iBULC
      # as follows:

      # $iB_field_value   = "whatever";
      # $iB_cookie        = "[TEST1->Test cookie value 1][TEST2->Test cookie value 2]";

      # Then those values can now be retrieved with

      # $field (has a value of "whatever").
      # $COOKIE{'TEST1'} (has a value of "Test cookie value 1").
      # $COOKIE{'TEST2'} (has a value of "Test cookie value 2").

      # START DO SOMETHING WHITH "FIELD" AND COOKIES ###################################
      #
      #
      #
      # Example: Here you can add code that creates a new directory based on the value of "$field".
      # Then you set "$uploaddir" to this new directory and the files will be stored in this
      # new directory.
      #
      #
      #
      # END DO SOMETHING WHITH "FIELD" AND COOKIES #####################################

      if ($file1) {
         # If we received the first file then save it now.
         &save_file($file1);
      }
      if ($file2) {
         # If we received the second file then save it now. This will be a jpg image.
         &save_file($file2);
      }
      if ($file3) {
         # If we received the third file then save it now. This will be a "jpg image.
         &save_file($file3);
      }

      # If you have set "$iB_custom_result=0" in the setup then make sure you print here "Done". Anything
      # else will show up as "Failed" in the iBULC client.
      print "Done";
   }

   sub save_file {
      my $file = shift;
      my $file_path = "$uploaddir/$file";
      my $totalbytes = 0;
      open (OUTFILE, ">$file_path") or print "Failed to write $file. Reason: $!. ";
      binmode OUTFILE;
      while ($bytesread = read($file, $buffer, 2048)) {
         print OUTFILE $buffer; 
      }
      close (OUTFILE);
      chmod(0666,"$file_path");
   }

   sub parse_cookies {
      if (defined($ENV{'HTTP_COOKIE'})) {
         @pairs = split(/; /, $ENV{'HTTP_COOKIE'});
         foreach $pair (@pairs) {
            ($name, $value) = split(/=/, $pair);
            $name =~ tr/+/ /;
            $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
            $value =~ tr/+/ /;
            $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
            if ($value) { $COOKIE{$name} = $value; }
         }
      }
   }