####CODEHEADER###

require "$db_link_path/$db_link_file";

sub do_accounts {
#   &get_group_info;
   $FORM{'adminarea'} = () if !$is_admin;
   $cat_font = 'font face="Arial,Helvetica" size=3 color="#000000"' if $FORM{'adminarea'};
   if ($FORM{'account'} eq 'register') {
      if ($FORM{'step'} == 2) {
         &get_group_info($FORM{$IF_VAL{'ifgroup'}});
#         &get_group_info($FORM{'group'});
         &account_validate;
      }
      else {
         &get_group_info($FORM{'group'});
         &account_register;
      }
   }
   elsif ($FORM{'account'} eq 'edit') {
      if ($FORM{'adminarea'}) {
         $confirmed_guest = ();
         $ifusername = $ifusername_display = $FORM{'aa_edit'};
      }
      &account_edit;
   }
   elsif ($FORM{'account'} eq 'lostpw') {
      &account_lostpw;
   }
   elsif ($FORM{'account'} eq 'verify') {
      if ($FORM{'verify'}) {
         &account_activation_verify;
      }
      else {
         &account_activation_key;
      }
   }
   elsif ($FORM{'account'} eq 'convert') {
      &Error ("You will need to be logged in as an administror in order to convert the user DB.") unless $is_admin;
      &account_convert;
   }
   &account_template;
}


sub account_validate {
   if ($FORM{'refresh'}) {
      $retry = 1;
      &account_register;
   }
   else {
      foreach my $key (sort keys %DBfields) {
         my $visible   = $DBfields{$key}[1];
         my $required  = $DBfields{$key}[3];
         my $group     = $DBfields{$key}[8];
         next unless $visible && $required;
         if ($group){
            if ($show_group_form) {
               my (@groups) = split(/\,/, $group);
               foreach (@groups) {
                  if (lc($show_group_form) eq lc($_)) {
                     $group = 1;
                     last;
                  }
                  else {
                     $group = ();
                  }
               }
            }
            else {
               $group = ();
            }
            next unless $group;
         }
         if ($key eq $IF_VAL{'ifcaptcha'}) {
            require "$libpath/captcha.pl";
            my ($compare) = &captcha_decrypt($FORM{'captchacode'}, $user_session_id) =~ m,^(.*)\.\w+$,;
            if (lc($FORM{$key}) ne lc($compare)) {
               $retry = 1;
               last;
            }
            else {
               $captcha_validated = 1;
            }
         }
         elsif ($required && !$FORM{$key}){
            $retry = 1;
            last;
         }
         elsif ($required > 1 && length($FORM{$key}) < $required) {
            $retry = 1;
            last;
         }
      }
      if ($retry) {
         &account_register("Please fill in all the required fields.");
      }
      else {
#         die $captcha_validated;
#         if ($FORM{$IF_VAL{'ifcaptcha'}}) {
#            $FORM{$IF_VAL{'ifcaptcha'}} = ();
#            $skip_activation = 1;
#         }
         &account_verify;
      }
   }
}


sub account_verify {
   if (!-d "$data_directory/db/temp") {
      mkdir ("$data_directory/db/temp", "0777") or &Error ("Unable to create temp DB dir, $data_directory/db/temp.  Reason: $!");
      chmod(0777,"$data_directory/db/temp") or &Error ("Could not set permissions on temp DB dir, $data_directory/db/temp.  Reason: $!");
      open(INDEXFILE,">$data_directory/db/temp/index.html");
      print INDEXFILE qq|<HTML><HEAD><TITLE>Forbidden</TITLE></HEAD><BODY>You do not have permission to access this directory.</BODY></HTML>|;
      close(INDEXFILE);
      chmod(0777,"$data_directory/db/temp/index.html");
   }

   $FORM{'if_username'} = $FORM{$IF_VAL{'ifusername'}};
   require "$config_directory/admin_config.pl";
   &read_user_db;

#   $found_this_user = ();

   my $register_text = lc($DBfields{$IF_VAL{'ifusername'}}[2]);
   $register_text = qq|The $register_text "$FORM{$IF_VAL{'ifusername'}}" is already in use. Please choose another $register_text|;

   if($found_this_user) {
      $FORM{$IF_VAL{'ifusername'}} = ();
      $retry = 1;
      &account_register($register_text);
   }
   else {
      opendir (DL, "$data_directory/db/temp");
      my @temp_files= grep { /\.cgi$/ } readdir(DL);
      closedir (DL);

      $mainuserdb = $userdb;
      foreach my $temp_file (@temp_files) {
         if (-M "$data_directory/db/temp/$temp_file" > "1") {
            unlink("$data_directory/db/temp/$temp_file");
         }
         elsif (!$found_this_user) {
            $userdb = "$data_directory/db/temp/$temp_file";
            &read_user_db;
         }
      }
      $userdb = $mainuserdb;

      if($found_this_user) {
         $FORM{$IF_VAL{'ifusername'}} = ();
         $retry = 1;
         &account_register($register_text);
      }
      else {
         $FORM{$IF_VAL{'ifcaptcha'}} = ();
         $FORM{$IF_VAL{'ifuserpass'}} = &admin_encrypt($FORM{$IF_VAL{'ifuserpass'}}, $secret_key, 1);
         $FORM{$IF_VAL{'ifuserid'}}   = reverse time;
         $FORM{$IF_VAL{'ifuserid'}}   = substr($FORM{$IF_VAL{'ifuserid'}}, 0, 4);
         $FORM{$IF_VAL{'ifuserid'}}   = $FORM{$IF_VAL{'ifuserid'}} * 1321;
         $FORM{$IF_VAL{'ifuserid'}}   = rand $FORM{$IF_VAL{'ifuserid'}};
         $FORM{$IF_VAL{'ifuserid'}}   =~ s/\.//ig;
         $randtime = substr($FORM{$IF_VAL{'ifuserid'}}, 0, 6);
#         $FORM{$IF_VAL{'ifuserid'}}   = $current_time;
#         $randtime                    = $current_time;

         for my $key (sort { $DBfields{$a}[0] <=> $DBfields{$b}[0] } keys %DBfields) {
            $verify_name .= "$key\t";
            $verify_value .= "$FORM{$key}\t";
         }

         $verify_name =~ s/\t$//ig;
         $verify_value =~ s/\t$//ig;

         while (!$verifiedid) {
            $verify_file = "$data_directory/db/temp/$randtime.cgi";
            if (-e $verify_file) {
               $randtime++;
            }
            else {
               $verifiedid=1;
            }
         }

         open(VERIFY_FILE,">$verify_file") or &Error ("Could not open $verify_file file.  Reason $! \n");
         print VERIFY_FILE "$verify_name\n$verify_value\n";
         close(VERIFY_FILE);
         chmod(0777,"$verify_file");
         if ($FORM{'adminarea'} or $captcha_validated) {
            $FORM{'verify'} = $randtime;
            &account_activation_verify;
         }
         else {
            &account_send_verify;
         }
#         &account_send_verify;
      }
   }
}

sub account_register {
   my $comment = shift;
   $account_title = "Register";
   $account_action = qq|<input type="button" value="Cancel" onClick='location="$imagefolio_url"';> <input type="submit" value="Register">|;
   $step = 2;
   $account_table = qq|<table border=0 cellpadding=4 width="100%">|;
   $account_table .= qq|<tr><td class=register>&nbsp;</td><td nowrap class=register><font color="red"><b>$comment</b></font></td></tr>| if $comment;
   if ($FORM{'adminarea'}) {
      $DBfields{$IF_VAL{'ifgroup'}}[1] = 1
   }
   elsif ($group_input) {
      &Error ('There is no group field defined in your user database. Please add this line to your imagefolio.pl<br><input type=text size="50" value="IFGROUP => [\'0\', \'0\', \'Group\', \'0\', \'\', \'ifgroup\'],">') unless $IF_VAL{'ifgroup'};
      $account_table .= qq|<input type=hidden name="$IF_VAL{'ifgroup'}" value="$group_input">|;
   }
   for my $key (sort { $DBfields{$a}[0] <=> $DBfields{$b}[0] } keys %DBfields) {
      my $visible   = $DBfields{$key}[1];
      my $name      = $DBfields{$key}[2];
      my $required  = $DBfields{$key}[3];
      my $remark    = $DBfields{$key}[4];
      my $form_obj  = $DBfields{$key}[6];
      my $header    = $DBfields{$key}[7];
      my $group     = $DBfields{$key}[8];
      my $filter    = $DBfields{$key}[9];
      if ($group && $visible){
         if ($show_group_form) {
            my (@groups) = split(/\,/, $group);
            foreach (@groups) {
               if (lc($show_group_form) eq lc($_)) {
                  $visible = 1;
                  last;
               }
               else {
                  $visible = 0;
               }
            }
         }
         else {
            $visible = 0;
         }
      }
      if ($DBfields{$key}[7] && $visible){
         $account_table .= qq|<tr><td class=register>&nbsp;</td><td nowrap class=register><font size="+1">$DBfields{$key}[7]</font></td></tr>|;
      }
#      my $name_color = ();
      my $name_color_B = ();
      my $name_color_E = ();
#      my $remark_color = ();
      my $remark_color_B = ();
      my $remark_color_E = ();
      if ($required) {
         if ($retry && !$FORM{'refresh'}) {
            if (!$FORM{$key}) {
#               $name_color = qq|color="red"|;
               $name_color_B = qq|<font color="red">|;
               $name_color_E = qq|</font>|;
            }
            elsif ($required > 1 && length($FORM{$key}) < $required) {
#               $name_color = qq|color="red"|;
#               $remark_color = qq|color="red"|;
               $name_color_B = qq|<font color="red">|;
               $name_color_E = qq|</font>|;
               $remark_color_B = qq|<font color="red">|;
               $remark_color_E = qq|</font>|;
            }
         }
         $required = qq|<font color="red">*</font>|;
      }
      else {
         $required = ();
      }
      my ($form_type,$form_setting) = split(/\:/, $form_obj);

      if ($key eq $IF_VAL{'ifgroup'} && $FORM{'adminarea'}){
#            $form_obj = &group_list("$key", "$FORM{$key}");
            $form_obj = &group_list("$key", "$group_input");
      }
      elsif ($form_type eq 'TEXT') {
         $filter = qq| onKeyPress="return filterInput('$filter', event)"| if $filter;
         $form_obj = qq|<input type=text name="$key" size="$form_setting" value="$FORM{$key}"$filter>|;
      }
      elsif ($form_type eq 'PASSWORD') {
         $filter = qq| onKeyPress="return filterInput('$filter', event)"| if $filter;
         $form_obj = qq|<input type=password name="$key" size="$form_setting" value="$FORM{$key}"$filter>|;
      }
      elsif ($form_type eq 'TEXTAREA') {
         my ($width,$height) = split(/\-/, $form_setting);
         $form_obj = qq|<textarea name="$key" cols="$width" rows="$height">$FORM{$key}</textarea>|;
      }
      elsif ($form_type eq 'CHECKBOX') {
         if ($retry) {
            if ($FORM{$key}) {
               $form_setting = 'checked';
            }
            else {
               $form_setting = ();
            }
         }
         $form_obj = qq|<input name="$key" type="checkbox" value="1" $form_setting>|;
      }
      elsif ($form_type eq 'MENU') {
         my $onchange = ();
         if ($form_setting eq 'STATE') {
            $statecnt++;
            $form_type = $form_setting;
            $STATE_OBJ{"TEXT$statecnt"} = qq|<input type=text name="$key" size="30" value="$FORM{$key}">|;
            $form_setting = ();
            foreach my $statekey (sort keys %statecodes) {
               $form_setting .= "$statecodes{$statekey}[0],";
            }
            $form_setting =~ s/\,$//ig;
         }
         elsif ($form_setting eq 'COUNTRY') {
            $countrycnt++;
            $form_setting = ();
            foreach my $countrykey (sort keys %countrycodes) {
               my $checked = ();
               if ($FORM{$key}) {
                  if ($countrycodes{$countrykey}[0] eq $FORM{$key}) {
                     $checked = "*";
                     $onchange = $FORM{$key};
                  }
               }
               elsif ($countrycodes{$countrykey}[2]) {
                  $checked = "*";
                  $onchange = $countrycodes{$countrykey}[0];
               }
               $form_setting .= "$countrycodes{$countrykey}[0]$checked,";
            }
#            die $onchange;
            $form_setting =~ s/\,$//ig;
            if ($onchange eq "United States") {
               push(@stateobj, "MENU:$countrycnt");
               $onchange = qq| onChange="window.document.account.refresh.value=1;window.document.account.submit();"|;
            }
            else {
               push(@stateobj, "TEXT:$countrycnt");
               $onchange = qq| onChange="if (this[this.selectedIndex].value == 'United States') {window.document.account.refresh.value=1;window.document.account.submit();}"|;
            }
         }

#         if ($form_setting =~ /^STATE/) {
#            $form_type = $form_setting;
#            $FORM_OBJ{"TEXT$form_type"} = qq|<input type=text name="$key" size="30" value="$FORM{$key}">|;
#            $form_setting = ();
#            foreach $key (sort keys %statecodes) {
#               $form_setting .= "$statecodes{$key}[0],";
#            }
#            $form_setting =~ s/\,$//ig;
#         }
#         elsif ($form_setting =~ /^COUNTRY/) {
#            $form_setting = ();
#            foreach $key (sort keys %countrycodes) {
#               my $checked = ();
#               if ($countrycodes{$key}[2]) {
#                  $checked = "*";
#               }
#               $form_setting .= "$countrycodes{$key}[0]$checked,";
#            }
#            $form_setting =~ s/\,$//ig;
#         }
         $form_obj = qq|<select name="$key" $onchange>|;
         $form_obj .= qq|<option value="">| if $form_setting !~ /\*/;
         my @form_list = split(/\,/, $form_setting);
         foreach $form_value (@form_list) {
            my $selected;
            if ($retry) {
               $form_value =~ s/\*$//ig;
               if ($FORM{$key} eq $form_value) {
                  $selected = 'selected';
               }
            }
            elsif ($form_value =~ /\*$/) {
               $form_value =~ s/\*$//ig;
               $selected = 'selected';
            }
            $form_obj .= qq|<option value="$form_value" $selected>$form_value|;
         }
         $form_obj .= qq|</select>|;
         if ($form_type eq 'STATE'){
            $STATE_OBJ{"MENU$statecnt"} = $form_obj;
            $form_obj = "%%%STATE" . $statecnt . "%%%";
         }
      }
      if ($key eq $IF_VAL{'ifcaptcha'}) {
         require "$libpath/captcha.pl";
         $name = qq|<img border=0 |;
         if ($FORM{'step'} == 2) {
            my ($compare) = &captcha_decrypt($FORM{'captchacode'}, $user_session_id) =~ m,^(.*)\.\w+$,;
            if (lc($FORM{$key}) ne lc($compare) && !$FORM{'refresh'}) {
               $name = qq|<img border=1 style="border-color:red" |;
            }
         }
         else {
#            require "$libpath/captcha.pl";
            $FORM{'captchacode'} = &captcha_get_img($user_session_id);
         }
         $name .= qq|src="$imagefolio_url?captcha=$FORM{'captchacode'}"><input type=hidden name=captchacode value="$FORM{'captchacode'}">|;
         $required = ();
      }
      $account_table .= qq|<tr><td align=right nowrap class=register> $name_color_B$required <b>$name</b>  $name_color_E</td><td class=register>$form_obj $remark_color_B$remark$remark_color_E</td></tr>| if $visible;
   }
   $account_table .= qq|</table><input type=hidden name=refresh value="">|;
   foreach (@stateobj) {
      my ($type, $obj) = split(/\:/, $_);
      $account_table =~ s/%%%STATE$obj%%%/$STATE_OBJ{"$type$obj"}/ig;
   }
}

sub account_edit {
   if ($confirmed_guest or !$ifusername) {
      $FORM{'account'} = "";
      $account_title = "OK";
      $account_action = qq|<input type="button" value="   OK   " onClick='location="$imagefolio_url"';>|;
      $account_table = qq|<table border=0 cellpadding=4 width="100%">
         <tr>
           <td class=register>You have not signed in as a user yet. Please login 
           or create a new user account!</td>
         </tr>
      </table>|;
      &account_template;
   }
   $account_title = "Edit my account";
   $account_title = "Edit account" if $FORM{'adminarea'};
   $account_action = qq|<input type="button" value="Cancel" onClick='location="$imagefolio_url"';> <input type="submit" value="$account_title">|;
   $step = 2;
   if ($FORM{'step'}) {
      if ($FORM{'adminarea'}) {
         &get_group_info($FORM{$IF_VAL{'ifgroup'}});
      }
      else {
         &get_group_info($group_group_name);
      }
      if ($FORM{'refresh'}) {
         $retry = 1;
      }
      else {
         foreach my $key (sort keys %DBfields) {
            my $visible   = $DBfields{$key}[1];
            my $required  = $DBfields{$key}[3] if $key ne $IF_VAL{'ifusername'};
            my $group     = $DBfields{$key}[8];
            next unless $visible && $required;
            if ($group){
               if ($show_group_form) {
                  my (@groups) = split(/\,/, $group);
                  foreach (@groups) {
                     if (lc($show_group_form) eq lc($_)) {
                        $group = 1;
                        last;
                     }
                     else {
                        $group = ();
                     }
                  }
               }
               else {
                  $group = ();
               }
               next unless $group;
            }
            if ($key eq $IF_VAL{'ifcaptcha'}) {
               require "$libpath/captcha.pl";
               my ($compare) = &captcha_decrypt($FORM{'captchacode'}, $user_session_id) =~ m,^(.*)\.\w+$,;
               if (lc($FORM{$key}) ne lc($compare)) {
                  $retry = 1;
                  last;
               }
            }
            elsif ($required && !$FORM{$key}){
               $retry = 1;
               last;
            }
            elsif ($required > 1 && length($FORM{$key}) < $required) {
               $retry = 1;
               last;
            }
         }
         $edit_comment = qq|<tr><td class=register>&nbsp;</td><td nowrap class=register><font color="red"><b>Please fill in all the required fields.</b></font></td></tr>| if $retry;
      }
      unless ($retry) {
         $FORM{$IF_VAL{'ifcaptcha'}} = ();
         require "$config_directory/admin_config.pl";
         open (USERDB, "$userdb");
         my (@USERDB)=<USERDB>;
         close (USERDB);
         chomp @USERDB;
         my @USERDB_NAMES = split(/\t/, $USERDB[0]);
         my $cntun = 0;
         foreach my $USERDB_NAME (@USERDB_NAMES) {
            if ($USERDB_NAME eq $IF_VAL{'ifusername'}) {
               last;
            }
            else {
               $cntun++;
            }
         }
         $DBfields{$IF_VAL{'ifusername'}}[1] = ();
         $DBfields{$IF_VAL{'ifuserpass'}}[1] = () if $FORM{$IF_VAL{'ifuserpass'}} !~ /[^\*-\*]/;
         $accountline = "$USERDB[0]\n";
         $DBfields{$IF_VAL{'ifgroup'}}[1] = 1 if $FORM{'adminarea'};
         my $SIZE = @USERDB;
         for ($i=1;$i<=$SIZE;$i++) {
            next unless $USERDB[$i];
            my @USERDB_VALUES = split(/\t/, $USERDB[$i]);
            if (lc($USERDB_VALUES[$cntun]) eq lc($ifusername)) {
               my $cntuv = 0;
               my $new_accountline = ();
               foreach my $USERDB_NAME (@USERDB_NAMES) {
                  if ($DBfields{$USERDB_NAME} && $DBfields{$USERDB_NAME}[1]) {
                     if ($USERDB_NAME eq $IF_VAL{'ifuserpass'}){
                        $new_accountline .= &admin_encrypt($FORM{$USERDB_NAME}, $secret_key, 1) . "\t";
                     }
                     else {
                        $new_accountline .= "$FORM{$USERDB_NAME}\t";
                     }
                  }
                  else {
                     $new_accountline .= "$USERDB_VALUES[$cntuv]\t";
                  }
                  $cntuv++;
               }
#               die $user_sessionfile;
               $new_accountline =~ s/\t$/\n/ig;
#               open(ADDUSERDB, ">$user_sessionfile");
#               print ADDUSERDB $new_accountline;
#               close(ADDUSERDB);
#               chmod(0777,"$user_sessionfile");
               $accountline .= $new_accountline;
            }
            else {
               $accountline .= "$USERDB[$i]\n";
            }
         }
         unless ($admin_demo_mode) {
            open(ADDUSERDB, ">$userdb");
            print ADDUSERDB $accountline;
            close(ADDUSERDB);
            chmod(0777,"$userdb");
         }
         $FORM{'account'} = ();
         $step = "";
         $account_title = "Update Success";
         $account_action = qq|<input type="button" value="Go to gallery" onClick='location="$imagefolio_url"';>|;
         $account_table = qq|<table border=0 cellpadding=4 width="100%">
            <tr>
              <td class=register>Your account has been updated. Thank you!</td>
            </tr>
         </table>|;
         &account_template;
      }
   }
   else {
      if ($FORM{'adminarea'}) {
         &get_group_info($FORM{'group'});
      }
      else {
         &get_group_info($group_group_name);
      }
      open (USERDB, "$userdb");
      my (@USERDB)=<USERDB>;
      close (USERDB);
      chomp @USERDB;
      my @USERDB_NAMES = split(/\t/, $USERDB[0]);
      my $cntun = 0;
      foreach my $USERDB_NAME (@USERDB_NAMES) {
         if ($USERDB_NAME eq $IF_VAL{'ifusername'}) {
            last;
         }
         else {
            $cntun++;
         }
      }
      my $SIZE = @USERDB;
      for ($i=1;$i<=$SIZE;$i++) {
         next unless $USERDB[$i];
         my @USERDB_VALUES = split(/\t/, $USERDB[$i]);
         if (lc($USERDB_VALUES[$cntun]) eq lc($ifusername)) {
            my $cntuv = 0;
            foreach my $USERDB_NAME (@USERDB_NAMES) {
               if ($admin_demo_mode) {
                  $FORM{$USERDB_NAME} = "**********";
               }
               elsif ($USERDB_NAME eq $IF_VAL{'ifuserpass'}){
                  if ($FORM{'adminarea'}) {
                     $FORM{$USERDB_NAME} = &admin_decrypt($USERDB_VALUES[$cntuv], $secret_key, 1);
                  }
                  else {
                     my $x = 10;
                     $x = $DBfields{$USERDB_NAME}[3] if $DBfields{$USERDB_NAME}[3] > $x;
                     $FORM{$USERDB_NAME} = "*" x $x;
                  }
               }
               else {
                  $FORM{$USERDB_NAME} = $USERDB_VALUES[$cntuv];
               }
               $cntuv++;
            }
            last;
         }
      }
   }

   $account_table = qq|<table border=0 cellpadding=4 width="100%">$edit_comment|;
#   if ($group_input && !$FORM{'adminarea'}) {
#      &Error ('There is no group field defined in your user database. Please add this line to your imagefolio.pl<br><input type=text size="50" value="IFGROUP => [\'0\', \'0\', \'Group\', \'0\', \'\', \'ifgroup\'],">') unless $IF_VAL{'ifgroup'};
##      $account_table .= qq|<input type=hidden name="$IF_VAL{'ifgroup'}" value="$group_input">|;
#   }
   for my $key (sort { $DBfields{$a}[0] <=> $DBfields{$b}[0] } keys %DBfields) {
      my $visible   = $DBfields{$key}[1];
      my $name      = $DBfields{$key}[2];
      my $required  = $DBfields{$key}[3];
      my $remark    = $DBfields{$key}[4];
      my $form_obj  = $DBfields{$key}[6];
      my $header    = $DBfields{$key}[7];
      my $group     = $DBfields{$key}[8];
      my $filter    = $DBfields{$key}[9];
      if ($group && $visible){
         if ($show_group_form) {
            my (@groups) = split(/\,/, $group);
            foreach (@groups) {
               if (lc($show_group_form) eq lc($_)) {
                  $visible = 1;
                  last;
               }
               else {
                  $visible = 0;
               }
            }
         }
         else {
            $visible = 0;
         }
      }
      if ($DBfields{$key}[7] && $visible){
         $account_table .= qq|<tr><td class=register>&nbsp;</td><td nowrap class=register><font size="+1">$DBfields{$key}[7]</font></td></tr>|;
      }
#      my $name_color = ();
      my $name_color_B = ();
      my $name_color_E = ();
#      my $remark_color = ();
      my $remark_color_B = ();
      my $remark_color_E = ();
      if ($key eq $IF_VAL{'ifgroup'} && $FORM{'adminarea'}){
#            my $grouplist = &group_list("$key", "$FORM{$key}");
            my $grouplist = &group_list("$key", "$group_input");
            $account_table .= qq|<tr><td align=right nowrap class=register><b>$name</b> </td><td nowrap class=register align=left>$grouplist</td></tr>|;
      }
      elsif ($key eq $IF_VAL{'ifusername'}){
         $account_table .= qq|<tr><td align=right nowrap class=register><b>$name</b> </td><td nowrap class=register align=left>$ifusername_display</td></tr>| if $visible;
      }
      else {
         if ($required) {
            if ($retry && !$FORM{'refresh'}) {
               if (!$FORM{$key}) {
#                  $name_color = qq|color="red"|;
                  $name_color_B = qq|<font color="red">|;
                  $name_color_E = qq|</font>|;
               }
               elsif ($required > 1 && length($FORM{$key}) < $required) {
#                 $name_color = qq|color="red"|;
#                 $remark_color = qq|color="red"|;
                  $name_color_B = qq|<font color="red">|;
                  $name_color_E = qq|</font>|;
                  $remark_color_B = qq|<font color="red">|;
                  $remark_color_E = qq|</font>|;
               }
            }
            $required = qq|<font color="red">*</font>|;
         }
         else {
            $required = ();
         }

         my ($form_type,$form_setting) = split(/\:/, $form_obj);
         if ($form_type eq 'TEXT') {
            $filter = qq| onKeyPress="return filterInput('$filter', event)"| if $filter;
            $form_obj = qq|<input type=text name="$key" size="$form_setting" value="$FORM{$key}"$filter>|;
         }
         elsif ($form_type eq 'PASSWORD') {
            $filter = qq| onKeyPress="return filterInput('$filter', event)"| if $filter;
            $form_obj = qq|<input type=password name="$key" size="$form_setting" value="$FORM{$key}"$filter>|;
         }
         elsif ($form_type eq 'TEXTAREA') {
            my ($width,$height) = split(/\-/, $form_setting);
            $form_obj = qq|<textarea name="$key" cols="$width" rows="$height">$FORM{$key}</textarea>|;
         }
         elsif ($form_type eq 'CHECKBOX') {
#            if ($retry) {
               if ($FORM{$key}) {
                  $form_setting = 'checked';
               }
               else {
                  $form_setting = ();
               }
#            }
            $form_obj = qq|<input name="$key" type="checkbox" value="1" $form_setting>|;
         }
         elsif ($form_type eq 'MENU') {
            my $onchange = ();
            if ($form_setting eq 'STATE') {
               $statecnt++;
               $form_type = $form_setting;
               $STATE_OBJ{"TEXT$statecnt"} = qq|<input type=text name="$key" size="30" value="$FORM{$key}">|;
               $form_setting = ();
               foreach my $statekey (sort keys %statecodes) {
                  $form_setting .= "$statecodes{$statekey}[0],";
               }
               $form_setting =~ s/\,$//ig;
            }
            elsif ($form_setting eq 'COUNTRY') {
               $countrycnt++;
               $form_setting = ();
               foreach my $countrykey (sort keys %countrycodes) {
                  $form_setting .= "$countrycodes{$countrykey}[0],";
               }
               $form_setting =~ s/\,$//ig;
               if ($FORM{$key} eq "United States") {
                  push(@stateobj, "MENU:$countrycnt");
                  $onchange = qq| onChange="window.document.account.refresh.value=1;window.document.account.submit();"|;
               }
               else {
                  push(@stateobj, "TEXT:$countrycnt");
                  $onchange = qq| onChange="if (this[this.selectedIndex].value == 'United States') {window.document.account.refresh.value=1;window.document.account.submit();}"|;
               }
            }
            $form_obj = qq|<select name="$key"$onchange>|;
            $form_obj .= qq|<option value="">| if $form_setting !~ /\*/;
            my @form_list = split(/\,/, $form_setting);
            foreach $form_value (@form_list) {
               my $selected;
#               if ($retry) {
                  $form_value =~ s/\*$//ig;
                  if ($FORM{$key} eq $form_value) {
                     $selected = 'selected';
                  }
#               }
#               elsif ($form_value =~ /\*$/) {
#                  $form_value =~ s/\*$//ig;
#                  $selected = 'selected';
#               }
               $form_obj .= qq|<option value="$form_value" $selected>$form_value|;
            }
            $form_obj .= qq|</select>|;
            if ($form_type eq 'STATE'){
               $STATE_OBJ{"MENU$statecnt"} = $form_obj;
               $form_obj = "%%%STATE" . $statecnt . "%%%";
            }
         }
         if ($key eq $IF_VAL{'ifcaptcha'}) {
            require "$libpath/captcha.pl";
            $name = qq|<img border=0 |;
            if ($FORM{'step'} == 2) {
               my ($compare) = &captcha_decrypt($FORM{'captchacode'}, $user_session_id) =~ m,^(.*)\.\w+$,;
               if (lc($FORM{$key}) ne lc($compare) && !$FORM{'refresh'}) {
                  $name = qq|<img border=1 style="border-color:red" |;
               }
            }
            else {
   #            require "$libpath/captcha.pl";
               $FORM{'captchacode'} = &captcha_get_img($user_session_id);
            }
            $name .= qq|src="$imagefolio_url?captcha=$FORM{'captchacode'}"><input type=hidden name=captchacode value="$FORM{'captchacode'}">|;
            $required = ();
         }
         $account_table .= qq|<tr><td align=right nowrap class=register>$name_color_B$required <b>$name</b>  $name_color_E</td>
         <td class=register>$form_obj $remark_color_B$remark$remark_color_E</td></tr>| if $visible;
      }
   }
   $account_table .= qq|</table><input type=hidden name=refresh value="">|;
   foreach (@stateobj) {
      my ($type, $obj) = split(/\:/, $_);
      $account_table =~ s/%%%STATE$obj%%%/$STATE_OBJ{"$type$obj"}/ig;
   }
}

sub account_send_verify {
   my $account_message = qq|Dear $FORM{$IF_VAL{'iffirstname'}},\n\n|;
   $account_message .= qq|Your account for $site_title has been created. Make sure you activate it within 24 hours by clicking here:\n\n|;
   $account_message .= qq|$imagefolio_url?account=verify&verify=$randtime\n\n|;
   $account_message .= qq|Activation key: $randtime\n\n|;
   $account_message .= qq|------------------\n$site_title\n$imagefolio_url|;

   my $subject_out = "Verify your registration for $site_title";
   my $type_out_0 = 'text/plain';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
   my $data_out_0 = $notification_message;
   &send_mime_email($admin_email, $FORM{'EMAIL'}, '', '', $subject_out, $type_out_0, $account_message, '', '', '', '', '');
   &account_activation_key;
}

sub account_lostpw {
   if ($FORM{'step'}) {
      $FORM{'if_username'} = $FORM{$IF_VAL{'ifusername'}};
      require "$config_directory/admin_config.pl";
      &read_user_db;
#      $found_this_user = ();

      if($found_this_user) {
         $ifuserpass = &admin_decrypt($ifuserpass, $secret_key, 1);
         my $account_message = qq|Dear $iffirstname,\n\n|;
         $account_message .= qq|Your account for $site_title has been found. You can login here:\n\n|;
         $account_message .= qq|$imagefolio_url?login=1\n|;
         $account_message .= qq|Username: $ifusername\nPassword: $ifuserpass\n\n|;
         $account_message .= qq|------------------\n$site_title\n$imagefolio_url|;

         my $subject_out = "Login info for $site_title";
         my $type_out_0 = 'text/plain';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
         my $data_out_0 = $notification_message;
         &send_mime_email($admin_email, $ifemail, '', '', $subject_out, $type_out_0, $account_message, '', '', '', '', '');
         $account_table = "Your username and password have been sent to your email address.";
      }
      else {
         opendir (DL, "$data_directory/db/temp");
         my @temp_files= grep { /\.cgi$/ } readdir(DL);
         closedir (DL);

         foreach my $temp_file (@temp_files) {
            if (-M "$data_directory/db/temp/$temp_file" > "1") {
               unlink("$data_directory/db/temp/$temp_file");
            }
            elsif (!$found_this_user) {
               $userdb = "$data_directory/db/temp/$temp_file";
               &read_user_db;
               ($randtime) = split(/\./, $temp_file) if $found_this_user;
            }
         }

         if($found_this_user) {
            open(VERIFY_FILE,">>$userdb");
            print VERIFY_FILE "\n";
            close(VERIFY_FILE);
            chmod(0777,"$userdb");
            $FORM{$IF_VAL{'iffirstname'}} = $iffirstname;
            &account_send_verify;
         }
         else {
            $account_table = "<b>Error:</b> Invalid username!";
         }
      }
   }
   else {
      $step = 2;
      $FORM{'account'} = "lostpw";
      $account_title = "Request account password";
      $account_action = qq|<input type="button" value="Cancel" onClick='location="$imagefolio_url"';> <input type="submit" value="Request account password">|;
      my $display_un = lc($DBfields{$IF_VAL{'ifusername'}}[2]);
      my $display_pw = lc($DBfields{$IF_VAL{'ifuserpass'}}[2]);
      $account_table = qq|<table border=0 cellpadding=4 width="100%">
         <tr>
           <td colspan=2 align=left class=register>Please enter your $display_un. 
           We will send your $display_pw to the email address listed for your account.</td>
         </tr>
         <tr>
           <td align=right class=register><b>Username:</b></td>
           <td align=left class=register><input type=text name="$IF_VAL{'ifusername'}" size=20></td>
         </tr>
      </table>|;
   }
   &account_template;
}

sub account_activation_key {
   $FORM{'account'} = "verify";
   $account_title = "Activate your account";
   $account_action = qq|<input type="submit" value="Activate your account">|;
   $account_table = qq|<table border=0 cellpadding=4 width="100%">
      <tr>
        <td colspan=2 align=left class=register>Your account has been created. An activation 
         key has been sent to your email address. Please check your email for your activation key or click on 
         the link in the email to activate your account.<br><b>Please Note:</b> Your registration will be removed 
         in 24 hours if not activated.</td>
      </tr>
      <tr>
        <td align=right class=register><b>Activation key:</b></td>
        <td align=left><input type=text name="verify" size=15></td>
      </tr>
   </table>|;
   &account_template;
}

sub account_activation_verify {

   if (-e "$data_directory/db/temp/$FORM{'verify'}.cgi") {
      open (FILE,"$data_directory/db/temp/$FORM{'verify'}.cgi") or &Error ("Unable to open temp account file, temp$FORM{'verify'}.cgi.  Reason: $!");
      my(@LINES)=<FILE>;
      close(FILE);
      chomp @LINES;
      my @ACCOUNT_NAMES = split(/\t/, $LINES[0]);
      my @ACCOUNT_VALUES = split(/\t/, $LINES[1]);
      my $cnt = 0;
      foreach my $ACCOUNT_NAME (@ACCOUNT_NAMES) {
         $ACCOUNT{$ACCOUNT_NAME} = $ACCOUNT_VALUES[$cnt];
         $cnt++;
      }
      if (!-e "$userdb") {
         for my $key (sort { $DBfields{$a}[0] <=> $DBfields{$b}[0] } keys %DBfields) {
            $userdb_header .= "$key\t";
         }
         $userdb_header =~ s/\t$/\n/ig;
         open(USERDB,">$userdb") or &Error ("Could not open $userdb file.  Reason $! \n");
         print USERDB $userdb_header;
         close(USERDB);
         chmod(0777,"$userdb");
      }
      open(USERDB, "$userdb");
      my (@USERDB)=<USERDB>;
      close(USERDB);
      chomp @USERDB;
      my @USERDB_CURRENT = ();
      my @USERDB_NAMES = split(/\t/, $USERDB[0]);
      foreach my $USERDB_NAME (@USERDB_NAMES) {
         if ($DBfields{$USERDB_NAME} && $DBfields{$USERDB_NAME}[2]) {
            push(@USERDB_CURRENT, $USERDB_NAME);
         }
         else {
            $userdb_missing .= "$USERDB_NAME<br>";
         }
      }
      if ($userdb_missing) {
         if (@USERDB_CURRENT) {
            $userdb_missing =~ s/\<br\>$//ig;
            &Error("The following fields that are found in your database are missing in your database setup file:</b><br><br>$userdb_missing<br><br><b>Please add them now to your database configuration or click <a href=\"$imagefolio_url?account=convert&step=2&verify=$FORM{'verify'}\">here</a> to delete all these fields (including the values) from your database (tip: first make a backup of your user database).");
         }
         else {
            &Error("Your database has no database fields defined. Please click <a href=\"$imagefolio_url?account=convert&verify=$FORM{'verify'}\">here</a> to do so now (tip: first make a backup of your user database if you are upgrading from a previous version).");
         }
      }
      else {
#         if (@USERDB_NAMES == keys %DBfields) {
         my @name1 = @USERDB_NAMES;
         my @name2 = keys %DBfields;
         @name1 = sort { lc($a) cmp lc($b) } @name1;
         @name2 = sort { lc($a) cmp lc($b) } @name2;
         if (@name1 eq @name2) {
            foreach my $USERDB_NAME (@USERDB_NAMES) {
               $accountline .= "$ACCOUNT{$USERDB_NAME}\t";
            }
            $accountline =~ s/\t$/\n/ig;
            unless ($admin_demo_mode) {
               open(ADDUSERDB, ">>$userdb");
               print ADDUSERDB $accountline;
               close(ADDUSERDB);
            }
#            my $ACCOUNT = keys %ACCOUNT;
#            &Error("same: $ACCOUNT");
         }
         else {
            %DBfields2 = %DBfields;
            foreach my $USERDB_NAME (@USERDB_NAMES) {
               delete $DBfields2{$USERDB_NAME};
            }
#            my $DBfieldkeys = keys %DBfields;
#            my @DBfieldkeys = keys %DBfields;
#            my $DBfields2 = keys %DBfields2;
#            &Error("diff: $DBfields2");
            for my $key (sort { $DBfields2{$a}[0] <=> $DBfields2{$b}[0] } keys %DBfields2) {
               push(@USERDB_NAMES, $key);
            }
            foreach my $USERDB_NAME (@USERDB_NAMES) {
               $accountline .= "$USERDB_NAME\t";
            }
            $accountline =~ s/\t$/\n/ig;
            my $SIZE = @USERDB;
            for ($i=1;$i<=$SIZE;$i++) {
               next unless $USERDB[$i];
               $accountline .= "$USERDB[$i]";
               $accountline .= "\t" x keys %DBfields2;
               $accountline .= "\n";
            }
#            &Error("0: $USERDB[0]<br><br>1: $USERDB[1]<br><br>2: $USERDB[2]");
            foreach my $USERDB_NAME (@USERDB_NAMES) {
               $accountline .= "$ACCOUNT{$USERDB_NAME}\t";
            }
            $accountline =~ s/\t$/\n/ig;
            unless ($admin_demo_mode) {
               open(ADDUSERDB, ">$userdb");
               print ADDUSERDB $accountline;
               close(ADDUSERDB);
            }
         }

##        BEGIN SEND OUT EMAIL TO INFORM ADMIN
#         $cnt = 0;
#         my $account_message = "New account added:\n\n";
#         my $subject_out = "New account added";
#         foreach my $ACCOUNT_NAME (@ACCOUNT_NAMES) {
#            $account_message .= "$ACCOUNT_NAME: $ACCOUNT_VALUES[$cnt]\n";
#            $cnt++;
#         }
#        &send_mime_email($admin_email, $admin_email, '', '', $subject_out, 'text/plain', $account_message, '', '', '', '', '');
##        END SEND OUT EMAIL TO INFORM ADMIN

         unlink "$data_directory/db/temp/$FORM{'verify'}.cgi";
#         print "Content-type: text/html\nLocation:$imagefolio_redirect_url?login=1\n\n";
#         exit;
         $FORM{'account'} = ();
         if ($FORM{'adminarea'}) { #dirkdirk $DBfields{$key}[1] $DBfields{$IF_VAL{'ifgroup'}}[1] = 1 if $FORM{'adminarea'};
            $DBfields{$IF_VAL{'ifgroup'}}[1] = 1;
            $account_table = qq|<table border=0 cellpadding=4 cellspacing=0>|;
            $cnt = 0;
            foreach my $ACCOUNT_NAME (@ACCOUNT_NAMES) {
               if ($ACCOUNT_NAME eq $IF_VAL{'ifuserpass'}){
                  $ACCOUNT_VALUES[$cnt] = &admin_decrypt($ACCOUNT_VALUES[$cnt], $secret_key, 1);
               }
               $account_table .= qq|<tr><td class=register><b>$DBfields{$ACCOUNT_NAME}[2]</b></td><td class=register>$ACCOUNT_VALUES[$cnt]</td></tr>| if $DBfields{$ACCOUNT_NAME} && $DBfields{$ACCOUNT_NAME}[1];
               $cnt++;
            }
            $account_table .= qq|</table>|;
         }
         else {
            $account_title = "Sign In";
            $account_action = qq|<input type="submit" value="Sign In">|;
            $account_table = qq|<input type=hidden name=login value="2"><table border=0 cellpadding=4 width="100%">
              <tr>
                <td colspan=2 class=register>Your account has been activated. Please sign in 
                now to begin using it.</td>
              </tr>
              <tr>
                <td align=right class=register><b>$DBfields{$IF_VAL{'ifusername'}}[2]</b> </td>
                <td><input type=text name="if_username" size=25 value=""></td>
              </tr>
              <tr>
                <td align=right class=register><b>$DBfields{$IF_VAL{'ifuserpass'}}[2]</b> </td>
                <td><input type="password" name="if_password" size=25 value=""></td>
              </tr>
            </table>|;
         }
         &account_template;
      }
   }
   else {
      $FORM{'account'} = "verify";
      $account_title = "Activate your account";
      $account_action = qq|<input type="submit" value="Activate your account">|;
      $account_table = qq|<table border=0 cellpadding=4 width="100%">
         <tr>
           <td colspan=2 class=register><font color="red">The verification key you submitted is invalid or your account has already be activated.</font> To try again, check your email for the correct key and submit it here.</td>
         </tr>
         <tr>
           <td class=register><b>Activation key:</b></td>
           <td><input type=text size=15></td>
         </tr>
      </table>|;
      &account_template;
   }
}

sub account_convert {
   open (USERDB, "$userdb");
   my (@LINES)=<USERDB>;
   close (USERDB);
   chomp @LINES;
   my @USERDB_NAMES = split(/\t/, $LINES[0]);
   foreach my $USERDB_NAME (@USERDB_NAMES) {
      if ($DBfields{$USERDB_NAME} && $DBfields{$USERDB_NAME}[2]) {
         if ($FORM{'step'}) {
            $userdb_convert .= "$USERDB_NAME\t";
         }
         else {
            $userdb_converted = 1;
            last;
         }
      }
      elsif ($FORM{'step'}) {
         $userdb_not_converted = 1;
      }
   }
   if ($userdb_converted) {
      $FORM{'account'} = ();
      $account_title = "Go to gallery";
      $account_action = qq|<input type="button" value="Go to gallery" onClick='location="$imagefolio_url"';>|;
      $account_table = qq|<table border=0 cellpadding=4 width="100%">
         <tr>
           <td class=register>The user database was converted previously. Please make sure 
           it is working properly.</td>
         </tr>
      </table>|;
      &account_template;
   }
   elsif ($FORM{'step'}) {
      if ($userdb_not_converted) {
         $userdb_convert =~ s/\t$/\n/ig;
         $headerline = $userdb_convert;
         my $SIZE = @LINES;
         for ($i=1;$i<=$SIZE;$i++) {
            next unless $LINES[$i];
            my @USERDB_VALUES = split(/\t/, $LINES[$i]);
            my $cntv = 0;
            foreach my $USERDB_NAME (@USERDB_NAMES) {
               $userdb_convert .= "$USERDB_VALUES[$cntv]\t" if $DBfields{$USERDB_NAME} && $DBfields{$USERDB_NAME}[2];
               $cntv++;
            }
            $userdb_convert =~ s/\t$/\n/ig;
         }
      }
      else {
         $FORM{'account'} = ();
         $account_title = "Go to gallery";
         $account_action = qq|<input type="button" value="Go to gallery" onClick='location="$imagefolio_url"';>|;
         $account_table = qq|<table border=0 cellpadding=4 width="100%">
            <tr>
              <td class=register>The user database was previously converted. Please make sure 
           it is working properly.</td>
            </tr>
         </table>|;
         &account_template;
      }
   }
   else {
      for my $key (sort { $DBfields{$a}[0] <=> $DBfields{$b}[0] } keys %DBfields) {
         $userdb_convert .= "$key\t";
      }
      $userdb_convert =~ s/\t$/\n/ig;
#      &DBsubstitute;
      foreach my $row (@LINES) {
         &split_if_userline($row);
         for my $key (sort { $DBfields{$a}[0] <=> $DBfields{$b}[0] } keys %DBfields) {
            if ($DBfields{$key}[5]) {
               $userdb_convert .= "${$DBfields{$key}[5]}\t";
            }
            else {
               $userdb_convert .= "\t";
            }
         }
         $userdb_convert =~ s/\t$/\n/ig;
      }
   }
   my ($sec, $min, $hour, $day, $month, $year, $dweek, $dyear, $tz) = localtime(time);
   $year += 1900;
   $month++;
   my $backupid = sprintf "%04d%02d%02d%02d%02d%02d", $year, $month, $day, $hour, $min, $sec;
   require File::Copy;
   &File::Copy::copy ("$userdb", "$data_directory/backup/$backupid.userdb.txt");
#   die $userdb_convert;
   open(USERDB,">$userdb") or &Error("Could not open $userdb file.  Reason $! \n");
   print USERDB $userdb_convert;
   close(USERDB);
   chmod(0777,"$userdb");
   if ($FORM{'verify'}) {
      &account_activation_verify;
   }
   else {
      $FORM{'account'} = ();
      $account_title = "Go to gallery";
      $account_action = qq|<input type="button" value="Go to gallery" onClick='location="$imagefolio_url"';>|;
      $account_table = qq|<table border=0 cellpadding=4 width="100%">
         <tr>
           <td class=register>The user database was converted. Please make sure it is working properly.</td>
         </tr>
      </table>|;
      &account_template;
   }
}

sub get_group_info {
   $group_input = shift;
   @grouprows = ();
   my $found_group = ();
   open (GROUPDB, "$groupdb");
      while (<GROUPDB>) {
         chomp;
         /^#/      and next;        # Skip comment Lines.
         /^\s*$/   and next;        # Skip blank lines.
         push(@grouprows, $_);
      }
   close (GROUPDB);
   foreach my $line (@grouprows) {
      &split_if_groupline($line);
      if ($group_default) {
         $show_group_form = $group_group_name;
      }
      if (lc($group_input) eq lc($group_group_name)) {
         $group_input = $group_group_name;
         $found_group = 1;
      }
   }
   if ($found_group) {
      $show_group_form = $group_input;
   }
   else {
      $group_input = "";
   }
}

sub group_list {
   my ($FORMNAME, $GROUPNAME) = @_;
   my @rows = @grouprows;
#   open (GROUPDB, "$groupdb");
#      while (<GROUPDB>) {
#        chomp;
#         /^#/      and next;        # Skip comment Lines.
#         /^\s*$/   and next;        # Skip blank lines.
#         push(@rows, $_);
#      }
#   close (GROUPDB);

   @rows = sort { lc($a) cmp lc($b) } @rows;
   my $size = @rows;

#   my $accounttype = "edit" if $FORM{'account'} eq 'edit';

#   my $grouplist = qq|<select name="$FORMNAME" onchange="window.location='$imagefolio_url?adminarea=1&account=$FORM{'account'}&aa_edit=$FORM{'aa_edit'}&group='+this[this.selectedIndex].value;">|;
   my $grouplist = qq|<select name="$FORMNAME" onchange="window.document.account.refresh.value=1;window.document.account.submit();">|;

   if (!$GROUPNAME){
      $selected = " selected";
   }

   foreach my $line (@rows) {
      &split_if_groupline($line);
      if ($group_default) {
         $yes_default = 1;
         last;
      }
   }

    if ($yes_default) {
      $grouplist .= qq|<option value=""$selected>None (receives default group permissions)</option>|;
    }
    elsif ($FORM{'account'} ne 'register' && !$GROUPNAME) {
       $grouplist .= qq|<option value=""$selected>None (receives default group permissions)</option>|;
    }

   foreach my $group (@rows) {
      &split_if_groupline($group);
      $this_default = "";
      $selected = "";
      if ($group_default) {
         $this_default = " (default)";
      }
      if ($GROUPNAME eq $group_group_name) {
         $selected = " selected";
      }
      $grouplist .= qq|<option value="$group_group_name"$selected>$group_group_name$this_default</option>|;
   }

   $grouplist .= qq|</select>|;
   return $grouplist;
}

sub account_template {
   $account_table = qq{
       <script language="javascript">
       function filterInput(filter, evt){
       var keyCode, Char, inputField = '';
       if(filter == '')return true;
       if(window.event){
           keyCode = window.event.keyCode;
           evt = window.event;
       }else if (evt)keyCode = evt.which;
       else return true;
       inputField = evt.srcElement ? evt.srcElement : evt.target || evt.currentTarget;
       if((keyCode==null) || (keyCode==0) || (keyCode==8) || (keyCode==9) || (keyCode==13) || (keyCode==27) )return true;
       Char = String.fromCharCode(keyCode);
       if((filter.indexOf(Char) > -1)) return true;
       else return false;}</script>} . $account_table;

   if ($FORM{'adminarea'}) {
      require "$admindir_directory/accounts.pl";
      $template = &fe_admin_template;
   }
   else {
#      $account_template = $template_directory . "/accounts.html" if !$account_template;
      open (TEMPLATE,"$account_template") or &Error ("Could not open account_template: $account_template.  Reason $! \n");
       while (<TEMPLATE>) {
        if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_include($2); }
        elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_exec_include($2); }
        else { $template .= $_; }
      }
      close(TEMPLATE);
      require "$libpath/headerfooter.pl";

      if ($FORM{'group'}) {
         my $groupshow = lc($FORM{'group'});
         $groupshow =~ s/_/ /g;
         $template =~ s/%%%GROUPNAME%%%/\u$groupshow/ig;
      }
      else {
         $template =~ s/%%%GROUPNAME%%%/User/ig;
      }

      $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
      $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
      $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
      $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;

      $template =~ s/%%%SITE_TITLE%%%/$site_title/ig;
      $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
      $template =~ s/%%%IF_URL%%%/$imagefolio_url/ig;
      $template =~ s/%%%ACCOUNT_TITLE%%%/$account_title/ig;
      $template =~ s/%%%ACCOUNT_ACTION%%%/$account_action/ig;
      $template =~ s/%%%ACCOUNT_TABLE%%%/$account_table/ig;
      $template =~ s/%%%STEP%%%/$step/ig;
      $template =~ s/%%%ACTION%%%/$FORM{'account'}/ig;
#      $template =~ s/%%%COMMENT%%%/$comment/ig;
      $template =~ s/%%%BODY_BGCOLOR%%%/$body_bgcolor/ig;
      $template =~ s/%%%MAIN_TABLE_WIDTH%%%/$main_table_width/ig;
      $template =~ s/%%%(.*)%%%//ig;
   }
   print "Content-type: text/html\n\n";
   print $template;
   exit;
}



1;
