####CODEHEADER###

sub captcha_get_img {
   my $uniq = shift;
   opendir (CAP, "$base_if_path/captcha_images");
   my @images = grep { /(jpg|png|gif)$/i } readdir(CAP);
   closedir (CAP);
   my $image = $images[int(rand(eval(@images)))];
   $image = pop @images unless $image;
   return &captcha_encrypt($image, $uniq);
}

sub captcha_encrypt {
   my ($image,$uniq) = @_;
   $uniq = $guest_username unless $uniq;
   return &admin_encrypt($image, $uniq);
}

sub captcha_decrypt {
   my ($image,$uniq) = @_;
   $uniq = $guest_username unless $uniq;
   return &admin_decrypt($image, $uniq);
}

sub captcha_write_img {
   $FORM{'captcha'} =~ s/[$deny_chars]//g;
   $FORM{'captcha'} = &captcha_decrypt($FORM{'captcha'}, $user_session_id);
   return unless -e "$base_if_path/captcha_images/$FORM{'captcha'}";
   my ($extension) = ($FORM{'captcha'} =~ /\.([^.]+)$/);
   print "Cache-control: Private\n";
   print "Cache-Control: no-cache\n";
   print "Content-Type: image/$extension\n\n";
   binmode STDOUT;
   open (F, "$base_if_path/captcha_images/$FORM{'captcha'}");
   binmode(F);
   while (<F>) {
      print $_;
   }
   close(F);
}

1;