####CODEHEADER###

###############################################################################
# SETUP                                                                       #
# Use this area to include any variables that need to be supplied.            #
###############################################################################

# Define Plaform - NT, UNIX, or FREEBSD
# Here, use UNIX if anything other than FREEBSD or NT
$platform = "UNIX";

# The path to your password file
$password_file = "/home/httpd/html/www.domain.com/cgi-bin/dcforum/User_info/auth_user_file.txt";

# Dow you want to use the forum status of your user (i.e. normal/member/team/moderator/admin)
# to be used as the ImageFolio group? In that way you can create an ImageFolio group with
# different pemission for each of them. Example:
# admin can "Download + Upload + View"
# member can "Upload + View"
# normal can "View"
# If you don't want to use the forum status then set this to "0". In that case the "default"
# ImageFolio group will be used. Make sure though that you have 1 group set to "default"
# in the ImageFolio admin area.
# (1 = YES, 0 = NO)
$use_forum_status = "0";

# The url to the page so that user can register them selves (comment out if not used!)
$register_url = "http://www.domain.com/cgi-bin/dcforum/dcboard.cgi?az=user_register";

# The url to the page so that user can retrieve his lost password (comment out if not used!)
$lost_pw_url = "http://www.domain.com/cgi-bin/dcforum/dcboard.cgi?az=retrieve_password";

# The url to the control panel to maintain this user database (comment out if not used!)
$control_panel_url = "http://www.domain.com/cgi-bin/dcforum/dcadmin.cgi?az=admin_main&cat=user_manager";

###############################################################################
# DEFAULTS (do not modify these unless you have done so in dcforum.setup)
$split_delim = '\|';

%field_index = (
   'Password'  => 0,
   'Username'  => 1,
   'Group'     => 2,
   'Firstname' => 3,
   'Lastname'  => 4,
   'EMail'     => 5
);

###############################################################################
# END OF SETUP                                                                #
# Do not modify below this line unless you know what you are doing.           #
###############################################################################


###############################################################################
# READ USERS ACCESS DATABASE
###############################################################################

sub read_user_db {

   open (USERDB, "$password_file") or &Error("Could not open password file. Reason: $!");
   my (@LINES)=<USERDB>;
   close (USERDB);
   chomp @LINES;

   foreach $row (@LINES) {
      my @FIELDS = split(/[$split_delim]/, $row);
      if (lc(@FIELDS[$field_index{'Username'}]) eq lc($FORM{'if_username'})) {
         $found_this_user = 1;
         my $test_password = dcforum_crypt($FORM{'if_password'},@FIELDS[$field_index{'Password'}]);
         if ($test_password eq @FIELDS[$field_index{'Password'}]) {
            $found_this_pass = 1;
            $ifusername   = @FIELDS[$field_index{'Username'}];          # This is the username
            $ifemail      = @FIELDS[$field_index{'EMail'}];             # This is the email
            $iffirstname  = @FIELDS[$field_index{'Firstname'}];         # This is the first name
            $iflastname   = @FIELDS[$field_index{'Lastname'}];          # This is the last name
            if ($use_forum_status) {
               $ifgroup   = @FIELDS[$field_index{'Group'}];             # ImageFolio group
            }
            last;
         }
      }
   }

   sub dcforum_crypt {
      my ($arg1, $arg2) = @_;
      if (uc($platform) eq "FREEBSD") {
         $arg1 = crypt($arg1,substr($arg1,0,2));
      }
      elsif (uc($platform) eq "UNIX") {
         $arg1 = crypt($arg1,substr($arg2,0,2));
      }
      $arg1;
   }

}
1;