####CODEHEADER###

###############################################################################
# SETUP                                                                       #
# Use this area to include any variables that need to be supplied.            #
###############################################################################

# The path to your "Members" directory
$ubb_members_path = "/home/httpd/html/www.domain.com/ubbcgi/Members";

# The url to the page so that user can register them selves (comment out if not used!)
$register_url = "http://www.domain.com/ubbcgi/ultimatebb.cgi?ubb=agree";

# The url to the page so that user can retrieve his lost password (comment out if not used!)
$lost_pw_url = "http://www.domain.com/ubbcgi/ultimatebb.cgi?ubb=lost_password";

# The url to the control panel to maintain this user database (comment out if not used!)
$control_panel_url = "http://www.domain.com/ubbcgi/cp.cgi";


# Dow you want to use the forum status of your user (i.e. Administrator/Member/Junior_Member)
# to be used as the ImageFolio group? In that way you can create and ImageFolio group with
# different pemission for each of them. Example:
# Administrator can "Download + Upload + View"
# Member can "Upload + View"
# Junior_Member can "View"
# If you don't want to use the forum status then set this to "0". In that case the "default"
# ImageFolio group will be used. Make sure though that you have 1 group set to "default"
# in the ImageFolio admin area.
# (1 = YES, 0 = NO)

$use_forum_status = "0";

###############################################################################
# END OF SETUP                                                                #
# Do not modify below this line unless you know what you are doing.           #
###############################################################################



###############################################################################
# READ USERS ACCESS DATABASE
###############################################################################

# These are the steps that need to be followed to create your own script that reads your user database:
# 1) Check if the username ($FORM{'if_username'}) is correct.
# 2) If the username is correct set "$found_this_user = 1;"
# 3) Check is the password ($FORM{'if_password'}) is correct.
# 4) If the password is correct set:
#    $found_this_pass = 1;
#    $ifusername      = ?;   # This is the username
#    $ifemail         = ?;   # This is the email
#    $iffirstname     = ?;   # This is the first name
#    $iflastname      = ?;   # This is the last name
#    $ifgroup         = ?;   # If you leave this blank then the "default" ImageFolio group will be used. Otherwise
                             # fill in with the value of the ImageFolio Group permissions that should be used for
                             # this user. Example could be "Administrator" or "Member". In this case make sure
                             # you have an "Administrator" AND "Member" group created as an ImageFolio group.
                             # In the ImageFolio admin area you can now set the permission for these groups or/and
                             # for the default group. Permissions inlcude:
                             # Skin name
                             # Category access
                             # Category upload
                             # Preview permission
                             # Protect images
                             # Watermark images
                             # Much, MUCH more....

sub read_user_db {

   open (MEMBERSLIST, "$ubb_members_path/memberslist.cgi");
   my (@LINES)=<MEMBERSLIST>;
   close (MEMBERSLIST);
   chomp @LINES;

   foreach $line (@LINES) {
      if ($line =~ m/^$FORM{'if_username'}\|\!\!\|/) {
         ($MatchName, $ProfileNumber) = split(/\|\!\!\|/, $line);
         $found_this_user = 1;            # Make sure you set this to "1" when the username is correct.
         last;
      }
  }

  if ($ProfileNumber) {
     if (-e "$ubb_members_path/$ProfileNumber.cgi") {
         open (PROFILE, "$ubb_members_path/$ProfileNumber.cgi");
         my (@thisprofile)=<PROFILE>;
         close (PROFILE);
         chomp @thisprofile;
         if ($FORM{'if_password'} eq "$thisprofile[1]") {
            $found_this_pass = 1;                 # Make sure you set this to "1" when the password is correct.
            $ifusername      = $MatchName;        # This is the username
            $ifemail         = $thisprofile[2];   # This is the email
            $iffirstname     = ();                # This is the first name
            $iflastname      = ();                # This is the last name
            if ($use_forum_status) {
               $ifgroup      = $thisprofile[8];   # Forum status is ImageFolio group
            }
            else {
               $ifgroup      = ();                # "default" group is ImageFolio group
            }
         }
     }
  }

}
1;