#!/usr/bin/perl
###############################################################################
# BizDesign ImageFolio Professional Edition 4.0
###############################################################################
#
# VERSION       :  4.0
# LAST MODIFIED :  05/27/2005
#
#
###############################################################################
# Released by BizDesign, Inc.
# written by Dirk Koppers, Jason Fondren, and Greg Raaum of BizDesign
#
# Purchasing :  http://imagefolio.com/purchase/
# Support    :  http://imagefolio.com/forum/
# Phone      :  (214) 752-8767
# Email      :  sales@imagefolio.com
###############################################################################
# COPYRIGHT AND LICENSE INFORMATION :
#
# Copyright (c) 1999-2005 BizDesign, Inc. All rights reserved.
#
# Selling or distributing the code for this program without prior written
# consent is expressly forbidden.
#
# One licensed copy of the program may reside on a single server, in use by a
# single domain.  For each installed instance of the program, a separate
# license is required.
#
# Licensed users may alter or modify this software, at their own risk, of
# course.  They may also hire others to modify their own copy of the code, as
# long as the code is not transferred to or retained by the individual who is
# hired (unless he/she is also a license holder). Although license-holders
# may modify the code for their use, modified code may NOT be resold or
# distributed.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BIZDESIGN,
# INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# BizDesign, Inc. is not liable for any conduct associated with image gallery
# activity, nor for any binary media posted using this program, including but
# not imited to images, photographs, movies, and clipart.
#
# The user must assume the entire risk of using the program.  Although this
# program has been thoroughly tested on BizDesign's servers, BizDesign does not
# warrant that it works on all servers and will not be held liable for anything,
# including but not limited to, misusage, error, or loss of data.  ANY
# LIABILITY OF THE SELLER WILL BE LIMITED EXCLUSIVELY TO PRODUCT REPLACEMENT
# OR REFUND OF PURCHASE PRICE.  Use at your own risk!
###############################################################################
# Do not modify below this line unless you know what you are doing.
###############################################################################


###############################################################################
# SETUP #######################################################################
# Which file is being tested? Make sure you have filled in the setup part of
# the file that is being tested in that file itself!
###############################################################################
$db_link_file = 'mySQL.pl';
###############################################################################


eval {
   ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");   # Get the script location: UNIX
   ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");   # Get the script location: Windows

   &top;
};


if ($@) { print "Content-type: text/html\n\n<pre>Script Error: $@</pre>\n"; }

exit;

###############################################################################
# TOP
# Determines what to do
###############################################################################
sub top {

   $| = 1;
   &parse_form;

   if ($FORM{'login'}) {
      if(!$FORM{'if_username'})    { print &Error('You must enter a username.'); }
      elsif(!$FORM{'if_password'}) { print &Error('You must enter a password.'); }
      require "$db_link_file";
      &read_user_db;
      $ifgroup =~ s/ /_/g;
      &result_page;
   }
   else {
      &form_page;
   }
}


sub form_page {
print "Content-type: text/html\n\n";
print qq|
<html>
<head>
<title>ImageFolio DB user login test</title>
</head>
<body bgcolor="#ffffff">
<form method=get action="$ENV{'SCRIPT_NAME'}">
<input type=hidden name=login value="1">
Username: <input type=text name="if_username" size=25><br>
Password: <input type=text name="if_password" size=25><br>
<input type="submit" value="Test $db_link_file">
</form>
1) You can change the file that is being tested at beginning of this script (db_link_test.cgi)<br>
2) Make sure you have filled in the setup part of the file that is being tested in that file itself!
</body></html>|;
}

sub result_page {
print "Content-type: text/html\n\n";
   if ($found_this_user && $found_this_pass) {
      $my_status = "The user is logged in. Make sure ALL the required variables are filled in!";
   }
   elsif ($found_this_user) {
      $my_status = "The user was found but the password is incorrect.";
   }
   else {
      $my_status = "The user was not found in the database.";
   }

print qq|
<html>
<head>
<title>ImageFolio DB user login test</title>
</head>
<body bgcolor="#ffffff">
<pre>
\$db_link_file       = $db_link_file
\$found_this_user    = $found_this_user (This should be 1 when the username was found.) REQUIRED
\$found_this_pass    = $found_this_pass (This should be 1 when the password is correct.) REQUIRED
\$ifusername         = $ifusername (This should be the username as entered.) REQUIRED
\$ifemail            = $ifemail (The email of the user.) REQUIRED
\$iffirstname        = $iffirstname (The first name of the user.)
\$iflastname         = $iflastname (The last name of the user.)
\$ifgroup            = $ifgroup (The group to which this user belongs to. If left blank
                       then the "Default" ImageFolio group will be used.)



RESULT              = $my_status
</pre></body></html>|;
}

###############################################################################
# PARSE THE FORM
# Parses the form input and returns a hash with all the name
# value pairs.
###############################################################################
sub parse_form {
   my ($buffer, $pair, $name, $value);

   if ($ENV{'REQUEST_METHOD'} eq 'GET') {
     @pairs = split(/&/, $ENV{'QUERY_STRING'});
   }
   elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
     read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
     @pairs = split(/&/, $buffer);
   }

   PAIR: foreach $pair (@pairs) {
     ($name, $value) = split(/=/, $pair);
     $name =~ tr/+/ /;
     $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ s/\.\.//;
     $value =~ s/(<|\%\W*3\W*c|\&lt)\/?[^>]*(>|\%\W*3\W*e|\&gt)//mig; #strip out any HTML
     if ($FORM{$name} && ($value)) { $FORM{$name} = "$FORM{$name},$value"; }
     elsif ($value) { $FORM{$name} = $value; }
   }
}

###############################################################################
# Error
# shows error message if form not filled out correctly
###############################################################################
sub Error{
   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<html>
<head>
<title>Error</title>
</head>
<body bgcolor="#ffffff">
$whoops
</body>
</html>
|;

exit;
}