####CODEHEADER###

###############################################################################
# SETUP                                                                       #
# Use this area to include any variables that need to be supplied.            #
###############################################################################

# The path to your user database
$flattext_db = "/home/httpd/html/www.domain.com/flatext_userdata.txt";

# Which delimiter do you use.
# "\t" = TAB
# "\," = COMMA
# "\|" = PIPE
$delimiter = "\,";

# Which field contain these values. "1" means the first field, "2" the second, etc.
$ft_username             = "1"; # (Required)
$ft_password             = "2"; # (Required)
$ft_email                = "3"; # (Required)
$ft_firstname            = "4";
$ft_lastname             = "5";
$ft_group_permissions    = "6"; # If you leave this blank then the "default" ImageFolio group
                                # will be used. Otherwise fill in with the value of the
                                # ImageFolio Group permissions that should be used for this user.
                                # In the ImageFolio admin area you can now set the permission for
                                # these grousp or/and for the default group. Permissions inlcude:
                                # Skin name
                                # Category access
                                # Category upload
                                # Preview permission
                                # Protect images
                                # Watermark images
                                # Much, MUCH more....

# WEB INTERFACE SETUP ##############################################################
# The url to the page so that user can register them selves (comment out if not used!)
#$register_url = "http://www.domain.com/cgi-bin/registerme.cgi";

# The url to the page so that user can retrieve his lost password (comment out if not used!)
#$lost_pw_url = "http://www.domain.com/cgi-bin/findme.cgi";

# The url to the control panel to maintain this user database (comment out if not used!)
#$control_panel_url = "http://www.domain.com/cgi-bin/cp.cgi";

###############################################################################
# END OF SETUP                                                                #
# Do not modify below this line unless you know what you are doing.           #
###############################################################################



###############################################################################
# READ USERS ACCESS DATABASE
###############################################################################

sub read_user_db {

   open (USERDB, "$flattext_db") or &Error("Could not open flattext user database. Reason: $!");
   my (@LINES)=<USERDB>;
   close (USERDB);
   chomp @LINES;

   foreach $row (@LINES) {
      my @FIELDS = split(/[$delimiter]/, $row);
      if (lc(@FIELDS[$ft_username-1]) eq lc($FORM{'if_username'})) {
         $found_this_user = 1;
         if (lc(@FIELDS[$ft_password-1]) eq lc($FORM{'if_password'})) {
            $found_this_pass = 1;
            $ifusername   = @FIELDS[$ft_username-1];          # This is the username
            $ifemail      = @FIELDS[$ft_email-1];             # This is the email
            $iffirstname  = @FIELDS[$ft_firstname-1];         # This is the first name
            $iflastname   = @FIELDS[$ft_lastname-1];          # This is the last name
            if ($ft_group_permissions) {
               $ifgroup   = @FIELDS[$ft_group_permissions-1];  # ImageFolio group
            }
            last;
         }
      }
   }

}
1;