####CODEHEADER###

###############################################################################
# SETUP                                                                       #
# Use this area to include any variables that need to be supplied.            #
###############################################################################

# DATABASE SETUP ##############################################################
$sql_db                       = "mysql";       # Your SQL dbms                                            (Required)
$db_host                      = "localhost";   # The host name                                            (Required)
$db_name                      = "db_name";     # The database name                                        (Required)
$db_user_name                 = "root";        # Username to log into database                            (Required)
$db_password                  = "password";    # Password to allow above user to log into database        (Required)
$db_port                      = "3306";        # default = 3306                                           (Required)
$db_table                     = "user_table";  # Table name containing user records                       (Required)
$db_field_username            = "user";        # Name of the field that contains the user's login name    (Required)
$db_field_password            = "pass";        # Name of the field that contains the user's password name (Required)
$db_field_email               = "email";       # Name of the field that contains the user's email name    (Required)
$db_field_firstname           = "firstname";   # Name of the field that contains the user's first name
$db_field_lastname            = "lastname";    # Name of the field that contains the user's last name
$db_field_group_permissions   = "group";       # If you leave this blank then the "default" ImageFolio group
                                               # will be used. Otherwise fill in with the value of the
                                               # ImageFolio Group permissions that should be used for this user.
                                               # In the ImageFolio admin area you can now set the permission for
                                               # these grousp or/and for the default group. Permissions inlcude:
                                               # Skin name
                                               # Category access
                                               # Category upload
                                               # Preview permission
                                               # Protect images
                                               # Watermark images
                                               # Much, MUCH more....

# WEB INTERFACE SETUP ##############################################################
# The url to the page so that user can register them selves (comment out if not used!)
#$register_url = "http://www.domain.com/mySQL/registerme.cgi";

# The url to the page so that user can retrieve his lost password (comment out if not used!)
#$lost_pw_url = "http://www.domain.com/mySQL/findme.cgi";

# The url to the control panel to maintain this user database (comment out if not used!)
#$control_panel_url = "http://www.domain.com/mySQ/cp.cgi";

###############################################################################
# END OF SETUP                                                                #
# Do not modify below this line unless you know what you are doing.           #
###############################################################################

require 5.002;                               # We need at least Perl 5.002
use DBI;                                     # Require DBI library.

###############################################################################
# READ USERS ACCESS DATABASE
###############################################################################

sub read_user_db {

   $dbh=DBI->connect("DBI:$sql_db:$db_name:$db_host:$db_port",$db_user_name,$db_password) or die $DBI::errstr;

   $form_password                = $dbh->quote($FORM{'if_password'});
   $form_username                = $dbh->quote($FORM{'if_username'});

   $db_query  = "SELECT $db_field_username, $db_field_password, $db_field_email, MD5($form_password)"; #use PASSWORD($form_password) if you used mySQL to encrypt password
   $db_query .= ", $db_field_firstname"         if $db_field_firstname;
   $db_query .= ", $db_field_lastname"          if $db_field_lastname;
   $db_query .= ", $db_field_group_permissions" if $db_field_group_permissions;
   $db_query .= " FROM $db_table WHERE $db_field_username = $form_username";

   if ($dbh) {
      $sth = $dbh->prepare($db_query) or die $DBI::errstr;
      $sth->execute or die $DBI::errstr;
      @row = $sth->fetchrow_array;
      $found_this_user = 1 if @row;
      $sth->finish();
   }

   if ($found_this_user) {
      if (($row[1] eq $row[3])) {
         $found_this_pass = 1;
      }
      elsif (lc($row[1]) eq lc($FORM{'if_password'})) {
         $found_this_pass = 1;
      }
      $ifusername   = $row[0];  # This is the username
      $ifemail      = $row[2];  # This is the email
      $next_field   = 4;
      if ($db_field_firstname) {
         $iffirstname  = $row[$next_field];  # This is the first name
         $next_field++;
      }
      if ($db_field_lastname) {
         $iflastname  = $row[$next_field];  # This is the last name
         $next_field++;
      }
      if ($db_field_group_permissions) {
         $ifgroup  = $row[$next_field];  # This is the ImageFolio group
      }
   }
}
1;