####CODEHEADER###

$warning_font_color = "#ffffff";

###############################################################################
# FRONT END TOP
# Directs traffic to various front end admin functions
###############################################################################
sub fe_top {
	my $action = shift;
	&{$action};
}

###############################################################################
# NEW CATEGORY
# Interface for creating a new category
###############################################################################
sub new_category {
   if ($is_user && !$group_cat_add_per) {
      &Error("Sorry $ifusername, you do not have permission to create a new category.");
   }
   my $admin_ouptut;
   my $admin_directory = $FORM{'admin_directory'};
   my $admin_title = "Add A New Category";
   my $on_load = qq{onLoad="self.focus();document.forms[0].catname.focus()"};
#   if ($block_main_cat) {
#      $block_main_cat = ();
#   }
#   elsif (!$personal_category) {
#      $top_level = qq|<option value=""> - Top Level Directory -|;
#   }

   if ((!$block_main_cat && $allow_free_post_access) or $is_admin) {
      $top_level = qq|<option value="" > - Top Level Category - </option>|;
   }

   my $catlist = &get_fe_catlist($admin_directory);
   $admin_directory = $admin_directory_new if $admin_directory_new;

   $admin_output = qq{
      $block_main_cat_script2
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="admin_add">
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td align="center">
               <$fe_admin_small_font><font color="#ffffff"><b>L O C A T I O N</b></font></font><br>
               <select name="admin_directory"$block_main_cat_script1>
               $top_level
               $catlist
               </select>
            </td>
         </tr>
         <tr>
            <td align="center">
               <$fe_admin_small_font><font color="#ffffff"><b>C A T E G O R Y&nbsp;&nbsp;&nbsp;N A M E</b></font></font><br>
               <input type=text name="catname" size=35>
            </td>
         </tr>
         <tr>
            <td align="center"><input type=submit value="Add New Category"></td>
         </tr>
      </table>
      </form>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# DELETE CATEGORY
# Interface for deleting a category
###############################################################################
sub delete_category {
   $block_main_cat = 1 if $is_user && !$allow_free_post_access;
   if ($is_user && !$group_cat_del_per) {
      &Error("Sorry $ifusername, you do not have permission to delete a category.");
   }
   my $admin_ouptut;
   my $top_level;
   my $admin_directory = $FORM{'admin_directory'};
   my $admin_title = "Delete A Category";
   my $on_load = qq{onLoad="self.focus()"};
   my $catlist = &get_fe_catlist($admin_directory);
   $admin_directory = $admin_directory_new if $admin_directory_new;

   if (!$catlist_selected) {
      $top_level = qq|<option value="" > - Select Category</option>|;
   }

   $admin_output = qq{
      $block_main_cat_script2
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="delete_confirm">
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td align="center">
               <$fe_admin_small_font><font color="#ffffff"><b>C A T E G O R Y</b></font></font><br>
               <select name="admin_directory"$block_main_cat_script1>
               $top_level
               $catlist
               </select>
            </td>
         </tr>
         <tr>
            <td align="center"><input type=submit value="Delete Category"></td>
         </tr>
      </table>
      </form>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# DISK USAGE
# Reports for displaying disk usage by category and total disk usage
###############################################################################
sub disk_usage {
   #if ($is_user && !$group_cat_del_per) {
   #   &Error("Sorry $ifusername, you do not have permission to delete a category.");
   #}
   my $admin_ouptut;
   my $admin_title = "Disk Usage";
   my $on_load = qq{onLoad="self.focus()"};

   if (-e $disk_usage_file) {
      ($dufiledate) = unix_to_date((stat("$disk_usage_file"))[9]);
      $dufiledate = qq{
      <tr>
      <td align=center colspan=2 bgcolor="#eeeeee"><$fe_admin_small_font><b>
      Disk Usage Statistics Generated On $dufiledate</b></font></td>
      </tr>
      };

      open (FILE,"$disk_usage_file");
      my(@Usage)=<FILE>;
      close(FILE);

      foreach $Usage (@Usage) {
         chomp $Usage;
         my ($UsageKb, $IFCategory) = split(/\t/, $Usage);
         $UsageBytes = $UsageKb * 1024;
         $UsageMb = $UsageBytes / 1048576;
         $UsageMb = sprintf("%.2f", $UsageMb);

         $CatLink = qq|<a href="$imagefolio_url?direct=$IFCategory" target="_blank">|;

         if ($IFCategory =~ /^Total/) {
            $UsageMb = "<b>$UsageMb MB</b>";
            $IFCategory = "<b>TOTAL DISK USAGE</b>";
            $CatLink = "";
         }

         $usage_output .= qq{
         <tr>
           <td align=left width="100%" bgcolor="#ffffff"><$fe_admin_small_font>$CatLink$IFCategory</a></font></td>
           <td align=right bgcolor="#ffffff" nowrap><$fe_admin_small_font>$UsageMb</font></td>
         </tr>
         };
      }
   }

   if (!$usage_output) {
      $usage_output = qq{
      <tr>
        <td colspan=2 bgcolor="#ffffff"><$fe_admin_small_font>No data available.</font></td>
      </tr>
      };
   }

   $admin_output = qq{
      <table width="100%" cellpadding="4" cellspacing="1" border="0">
         $dufiledate
         <tr>
           <td align="left" bgcolor="#ffffff"><$fe_admin_small_font><b>CATEGORY</b></font></td>
           <td align=right nowrap bgcolor="#ffffff"><$fe_admin_small_font><b>USAGE (MB)</b></font></td>
         </tr>$usage_output
      </table>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# RENAME CATEGORY
# Interface for renaming a category
###############################################################################
sub rename_category {
   $block_main_cat = 1 if $is_user && !$allow_free_post_access;
   if ($is_user && !$group_cat_ren_per) {
      &Error("Sorry $ifusername, you do not have permission to rename a category.");
   }
   my $admin_ouptut;
   my $top_level;
   my $admin_directory = $FORM{'admin_directory'};
   my $admin_title = "Rename A Category";
   my $on_load = qq{onLoad="self.focus()"};
   my $catlist = &get_fe_catlist($admin_directory);
   $admin_directory = $admin_directory_new if $admin_directory_new;

   if (!$catlist_selected) {
      $top_level = qq|<option value="" > - Select Category</option>|;
   }

   $admin_output = qq{
      $block_main_cat_script2
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="admin_rename">
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td align="center">
               <$fe_admin_small_font><font color="#ffffff"><b>C A T E G O R Y</b></font></font><br>
               <select name="admin_directory"$block_main_cat_script1>
               $top_level
               $catlist
               </select>
            </td>
         </tr>
         <tr>
            <td align="center">
               <$fe_admin_small_font><font color="#ffffff"><b>N E W&nbsp;&nbsp;&nbsp;N A M E</b></font></font><br>
               <input type="text" name="new_name" size="35">
            </td>
         </tr>
         <tr>
            <td align="center"><input type=submit value="Rename Category"></td>
         </tr>
      </table>
      </form>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}


###############################################################################
# MOVE CATEGORY
# Interface for moving a category
###############################################################################
sub move_category {

   if ($is_user) {
      if (!$group_cat_move_per) {
         &Error("Sorry $ifusername, you do not have permission to move a category.");
      }
      if (!$allow_free_post_access) {
         $no_block = 1 if !$block_main_cat;
         $block_main_cat = 1;
      }
   }
   my $admin_ouptut;
   my $admin_directory = $FORM{'admin_directory'};
   my $admin_title = "Move A Category";
   my $on_load = qq{onLoad="self.focus();updateList();"};
   my $catlist = &get_fe_catlist($admin_directory);
   $admin_directory = $admin_directory_new if $admin_directory_new;

   if ((!$block_main_cat && $allow_free_post_access) or $is_admin) {
      $top_level = qq|<option value="" > - Top Level Category - </option>|;
      $tolist = '1';
   }
   else {
      $tolist = '0';
      $checktoList = qq| onChange="checktoList();"|;
      $checktoList_func = qq|if (!toList[i].value && toList[i].style) { toList[i].style.color = "#CCCCCC"; }|;
   }

   $admin_output = qq{
            <form method="get" action="$imagefolio_url" onSubmit="return submitIt()">
            <input type="hidden" name="admin" value="admin_move">
            $block_main_cat_script2
      <script language="javascript">
      <!--Start
      function checktoList() {
         var toList = document.forms[0].toList;
         var toListIndex = toList.selectedIndex;
         if (!toList[toListIndex].value) {
            alert("You can't select that category");
            var fromList = document.forms[0].admin_directory;
            var fromIndex = fromList.selectedIndex;
            var fromValue = fromList[fromIndex].value;
            if (fromValue) {
               location.href = "$imagefolio_url?admin=move_category&admin_directory="+fromValue;
            }
            else {
               location.href = location.href.split('#')[0];
            }
         }
      }
      function updateList() {
         var fromList = document.forms[0].admin_directory;
         var toList = document.forms[0].toList;
         var fromIndex = fromList.selectedIndex;
         var fromValue = fromList[fromIndex].value;

         if (!fromValue) {
//            skip_forward = 1;
            alert("You can't select this category");
            location.href = location.href.split('#')[0];
         }


         var fromRegex = new RegExp("^" + fromValue);
         var fromArray = fromValue.split("/");
         fromArray.length = fromArray.length-1;
         var parentValue = fromArray.join("/");

         toList.length = $tolist;

         for (i=0; i<fromList.length; i++) {
            if (!fromRegex.test(fromList[i].value)) {
               if (catlist[i]) {
                  fromListval = catlist[i];
               }
               else {
                  fromListval = fromList[i].value;
               }
               toList[toList.length] = new Option(fromList[i].text, fromListval);
            }
         }

         for (i=0; i<toList.length; i++) {
            if (toList[i].value == parentValue) { 
               toList.selectedIndex = i;
            }
            $checktoList_func
         }
      }
      function submitIt() {
         var fromList = document.forms[0].admin_directory;
         var toList = document.forms[0].toList;
         var fromIndex = fromList.selectedIndex;
         var fromValue = fromList[fromIndex].value;
         var fromArray = fromValue.split("/");
         fromArray.length = fromArray.length-1;
         var parentValue = fromArray.join("/");
         var toIndex = toList.selectedIndex;
         var toValue = toList[toIndex].value;
         if (toValue == parentValue) {
            alert("You must change the destination in order to move a category");
            return false;
         }
      return true;
      }
      // Stop-->
      </script>
            <table width="100%" cellpadding="8" cellspacing="10" border="0">
               <tr>
                  <td align="center">
                     <font face="Verdana,Arial,Helvetica" size="1" color="#ffffff"><b>C A T E G O R Y</b></font><br>
                     <select name="admin_directory" onChange="updateList();">
                     $catlist
                     </select>
                  </td>
                </tr>
                <tr>
                  <td align="center">
                     <font face="Verdana,Arial,Helvetica" size="1" color="#ffffff"><b>M O V E &nbsp;&nbsp;&nbsp; T O</b></font><br>
                     <select name="toList" size="5"$checktoList>
                     $top_level
                     </select>
                  </td>
               </tr>
               <tr>
                  <td align="center" colspan="2"><input type="submit" value="Move Category"></td>
               </tr>
            </table>
            </form>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# DELETE CONFIRM
# Confirmation for deleting a category
###############################################################################
sub delete_confirm {
   $block_main_cat = 1 if $is_user && !$allow_free_post_access;
   my $admin_ouptut;
   my $admin_directory = $FORM{'admin_directory'};
   if ($is_user) {
      if (!$group_cat_del_per) {
         &Error("Sorry $ifusername, you do not have permission to delete a category.");
      }
      &compare_cat($admin_directory);
   }
   my $admin_title = "Delete Confirmation";
   my $on_load = qq{onLoad="self.focus()"};

   &Error("No Category Selected") if (!$admin_directory);

   $admin_output = qq{
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="admin_delete">
      <input type="hidden" name="admin_directory" value="$admin_directory">
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td nowrap><$fe_admin_font color="#ffffff"><strong>Warning!</strong></font></td>
         </tr>
         <tr>
            <td>
               <$fe_admin_font><b><font color="$warning_font_color">You are about to delete the category '$admin_directory' and all of its associated images. Are you sure you want to do this?</font></b><br><br>If not, please click the Cancel button below.<br><br></font>
            </td>
         </tr>
         <tr>
            <td align="center"><INPUT TYPE="submit" VALUE="Yes, Delete It!">&nbsp;<INPUT TYPE="button" VALUE="Cancel" onClick="history.go(-1)"></td>
         </tr>
      </table>
      </form>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# DELETE
# Deletes a category
###############################################################################
sub admin_delete {

   my ($admin_ouptut, $i);
   my $admin_directory = $FORM{'admin_directory'};
   if ($is_user) {
      if (!$group_cat_del_per) {
         &Error("Sorry $ifusername, you do not have permission to delete a category.");
      }
      $personal_category_block = 1;
      &compare_cat($admin_directory);
      $cachereload = 1;
   }
   my $admin_title = "Category Deleted";

   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }

   &refresh_category_cache($admin_directory);

   my @get_parent = split(/\//, $admin_directory);
   pop @get_parent;
   my $parent = join("\/", @get_parent);
   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$parent'"};

   $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td align="center">
               <$fe_admin_font><font color="#ffffff"><b>The category <font color="$warning_font_color">$admin_directory</font> has been deleted.<br>
               <b>Please wait while your display is updated.</font></font>
            </td>
         </tr>
      </table>
   };

   my $deletecat = "$image_directory/$admin_directory";
   use File::Path;
   rmtree($deletecat) or &Error("Could not delete category, $admin_directory.  Reason: $!");

   open (CATFILE,"$catfile") or &Error ("Could not open $catfile, is it created.  Reason: $!");
   my(@CATS)=<CATFILE>;
   close(CATFILE);
   chomp @CATS;
   $SIZE=@CATS;

   open (CATINDEX,">$catfile") or &Error ("Could not open $catfile, is it created.  Reason: $!");
   if ($useflock) { flock(CATINDEX, 2); }
   for ($i=0;$i<=$SIZE;$i++) {
      $_=$CATS[$i];
      my ($direct, $cnt) = split(/\t/, $_);

      /^#/      and next;        # Skip comment Lines.
      /^\s*$/   and next;        # Skip blank lines.

      if ($direct =~ /^$admin_directory\//g or $direct eq $admin_directory) {
         next;
      } else {
         print CATINDEX $_ . "\n";
      }
   }

   if ($useflock) { flock(CATINDEX, 8); }
   close(CATINDEX);
   chmod(0777,"$catfile") or &Error ("Could not set permissions on index file, $catfile.  Reason: $!");

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# ADD
# Add a new category
###############################################################################
sub admin_add {
   my $admin_ouptut;
   my $admin_title;
   my $catname = $FORM{'catname'};
   my $admin_directory = $FORM{'admin_directory'};

   if (!$catname) { &Error("You must enter a Category Name."); }

   if ($is_user) {
      if (!$group_cat_add_per) {
         &Error("Sorry $ifusername, you do not have permission to create a new category.");
      }
      elsif ($block_main_cat && !$admin_directory) {
         &Error("Sorry $ifusername, you do not have permission to create a new category in this loaction.");
      }
      elsif ($personal_category && !$admin_directory) {
         &Error("Sorry $ifusername, you do not have permission to create a new category in this loaction.");
      }
      $group_media_main_cat_per = 1;
      &compare_cat($admin_directory);
      $cachereload = 1;
   }

   &refresh_category_cache($admin_directory);

   $catname =~ s/^\s+//g;              # Trim leading blanks...
   $catname =~ s/\s+$//g;              # Trim trailing blanks...
   $catname =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $catname =~ s/\s+/_/g;              # Change spaces to underscores
   $newcatname = $catname;
   $newcatname =~ s/_/ /g;

   if (!$admin_directory) {
      $createcat = "$image_directory/$catname";
      $admin_title = "New Category Added";

      $admin_output = qq{
         <table width="100%" cellpadding="8" cellspacing="10" border="0">
            <tr>
               <td align="center">
                  <$fe_admin_font><font color="#ffffff"><b>The category <font color="$warning_font_color">$newcatname</font> has been added.</b><br>
                  <b>Please wait while your display is updated.<br></font></font>
               </td>
            </tr>
         </table>
      };
   } 
   elsif ($admin_directory) {
      $createcat = "$image_directory/$admin_directory/$catname";
      $admin_title = "New Subcategory Added";

      $admin_output = qq{
         <table width="100%" cellpadding="8" cellspacing="10" border="0">
            <tr>
               <td align="center">
                  <$fe_admin_font><font color="#ffffff"><b>The subcategory <font color="$warning_font_color">$newcatname</font> has been added in <br>
                  <font color="$warning_font_color">$admin_directory</font>.<b></font><br>
                  <b>Please wait while your display is updated.<br></font></font>
               </td>
            </tr>
         </table>
      };
   } 
   else {
      &Error("Something strange happened here.  Please check your fe_admin.pl!");
   }

   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }

   &check_dir($catname, $createcat);

   mkdir ("$createcat", "0777") or &Error("Unable to create category, $createcat.  Reason: $!");
   chmod(0777,"$createcat") or &Error("Could not set permissions on category, $createcat.  Reason: $!");

   $newcatdirect = $createcat;
   $newcatdirect =~ s/$image_directory\///g;

   open(CATEGORIES,">>$catfile") or &Error ("Could not open catgory file, $catfile.  Try rebuilding the index.  Reason: $!");
   if ($useflock) { flock(CATEGORIES, 2); }
   print CATEGORIES $newcatdirect . "\t" . "0" . "\n";
   if ($useflock) { flock(CATEGORIES, 8); }
   close(CATEGORIES);

   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$newcatdirect'"};

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# LOGOUT
# Deletes the current session file for an effective logout
###############################################################################
sub log_out {
   if (-e "$sessions_dir/$admin_uid.admin") {
      unlink("$sessions_dir/$admin_uid.admin");
   }
   $full_query =~ s/admin=log_out&//ig;
   $full_query =~ s/admin=log_out//ig;
   if ($full_query) {
      $full_query = '?' . $full_query;
   }
   print "Location:$imagefolio_redirect_url$full_query\n\n";
   exit;
}

###############################################################################
# CHECK DIR
# Make sure we have valid characters in the directory name before building it
###############################################################################
sub check_dir {
   my ($dirname, $dir) = @_;
   if ($dirname =~ /[$deny_chars]/i) {
      &Error("Invalid characters in category name '$dirname'. A Category cannot contain any of the following characters:<br> $deny_characters");
   }
   if (-e $dir) {
      &Error("The category '$dirname' already exists, try using another!");
   }
   return $input;
}

###############################################################################
# BUILD DIRECTORY TREE
# Returns a string of the current category broken up 
# by section, with each part linked to the respective section.
###############################################################################
sub build_directory_tree {
   my $input = shift;
   my (@categories, $cat, $output, $i);
   my $gts = '&gt;';

   @categories = split (/\//, $input);

   unshift(@categories, 'Top');

   for ($i=0; $i<@categories; $i++) {
      $gts = '' if $i eq @categories-1;
      $cat = &get_clean_name($categories[$i]);
      $output .= qq{ <$font>$cat $gts</font> };
   }

   if ($name_image) {
      $output .= qq{ <$font> &gt; $name_image</font> };
   }

   return $output;
}

###############################################################################
# POPUP DISPLAY
# Puts together output info into the the admin_popup template
###############################################################################
sub popup_display {
   my ($admin_output, $admin_title, $on_load) = @_;
   my $admin_directory = $FORM{'admin_directory'};
   $admin_directory = $admin_directory_new if $admin_directory_new;
   $directory_tree = &build_directory_tree($admin_directory);

   open (TEMPLATE,"$admin_popup_template") or &Error("Could not open template $admin_popup_template.  Reason $!");
   while (<TEMPLATE>) {
      if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) {
      $template .= &ssi_include($2);
      } elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) {
         $template .= &ssi_exec_include($2);
      } else {
         $template .= $_;
      }
   }
   close(TEMPLATE);

   $template =~ s/%%%DIRECTORY_TREE%%%/$directory_tree/ig;
   $template =~ s/%%%ADMIN_OUTPUT%%%/$admin_output$select_options/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $template =~ s/%%%ADMIN_TITLE%%%/$admin_title/ig;
   $template =~ s/%%%ON_LOAD%%%/$on_load/ig;
   if ($cachereload) {
      $admin_jscript .= qq|<script language="javascript">document.cookie="cachereload=2\|1; path=/";</script>|;
      if ($index_requests_notification) {
         &rebuild_index_request_log;
      }
   }
   $template =~ s/%%%ADMIN_JSCRIPT%%%/$admin_jscript/ig;

   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;

   if ($is_admin) {
      $template =~ s/%%%ADMIN_MODE%%%/ &nbsp;&nbsp;***Admin Mode***/ig;
   }

   $template =~ s/%%%(.*)%%%//ig;

   print "Content-type: text/html\n\n";
   print $template;
   exit;
}


###############################################################################
# VERIFY SESSION
# Returns true or false value back to imageFolio.cgi
###############################################################################
sub verify_session {
   my $admin_uid = shift;
   require "$config_directory/admin_config.pl";
   &get_session;
   &check_file;
   return $exists;
}

###############################################################################
# GET SESSION
# Gets the session and session file location
###############################################################################
sub get_session {
   if ($admin_uid) {
      $unique = "$admin_uid";
      $sessionid = "$sessions_dir/$unique.admin";
   } else {
      $sessionid = "111aaa.11a.admin";
   }
}

###############################################################################
# CHECK FILE
# checks to see if an id file exists before using it
###############################################################################
sub check_file {
   $exists = '1' if -e $sessionid;
   if ($exists eq '1') { &parse_session; }
}

###############################################################################
# PARSE SESSION
# Opens and reads a session file's contents
###############################################################################
sub parse_session {
   open (SESSION,"$sessionid") or print &Error('Unable to verify your identity.');
   my(@userdata)=<SESSION>;
   close(SESSION);

   open(SESSION,">$sessionid") or print &Error('Unable to verify your identity.');
   if ($useflock) { flock(SESSION, 2); }
   foreach $userdata (@userdata) {
      ($userid, $firstname, $lastname, $email, $desc_per, $upload_per, $addcat_per, $rencat_per, $delcat_per, $build_per, $addusr_per, $modusr_per, $delusr_per, $demo_per) = split(/\|/, $userdata);
      print SESSION "$userid|$firstname|$lastname|$email|$desc_per|";
      print SESSION "$upload_per|$addcat_per|$rencat_per|$delcat_per|";
      print SESSION "$build_per|$addusr_per|$modusr_per|$delusr_per|$demo_per";
   }
   if ($useflock) { flock(SESSION, 8); }
   close(SESSION);
   $admin_demo_mode = 1 if ($demo_per eq "Yes");
}

###############################################################################
# CREATE TOOLS
# Creates the front end admin toolbar
###############################################################################
sub create_tools {
   $admin_popup_options = "width=500,height=350,scrollbars=no";

   $current = "&admin_directory=$current_cat" if $current_cat;

   $admin_tools = qq|
      <tr bgcolor="$main_header_bgcolor">
         <td align="center" nowrap valign="bottom" height=30>
   |;

   if ($use_textlinks) {
      $admin_tools .= qq|<table border=0 cellspacing=0 cellpadding=2 width="100%" bgcolor="#ffffcc"><tr><td align=center><span style="color: black"><$fe_admin_font><font size=1>\| |;

      if ($upload_per eq 'Yes') {
         $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')" title="Upload New Files" alt="Upload New Files">Upload Files</a> \|};
      }

      if ($desc_per eq 'Yes' && $is_admin) {
         $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=batch_action$current&batch_lbview=$FORM{'lbview'}&batch_lightbox=$FORM{'lightbox'}&batch_search=$FORM{'search'}','width=500,height=540,scrollbars=yes')" title="Batch IPTC" alt="Batch IPTC">Batch IPTC</a> \|};
      }

      if ($addcat_per eq 'Yes') {
         $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=new_category$current','$admin_popup_options')" title="Create New Category" alt="Create New Category">New Category</a> \|};
      }

      if ($delcat_per eq 'Yes') {
         $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=delete_category$current','$admin_popup_options')" title="Delete This Category" alt="Delete This Category">Delete Category</a> \|};
         $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=move_category$current','$admin_popup_options')" title="Move This Category" alt="Move This Category">Move Category</a> \|};
      }


      if ($rencat_per eq 'Yes') {
         $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=rename_category$current','$admin_popup_options')" title="Rename This Category" alt="Rename This Category">Rename Category</a> \|};
         $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=describe_category$current','$admin_popup_options')" title="Edit This Category Description" alt="Edit This Category Description">Category Description</a> \|};
         $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=image_category$current','$admin_popup_options')" title="Upload and Add Category Image" alt="Upload and Add Category Image">Category Image</a> \|};
      }

      $admin_tools .= qq{<br>\| <a style="color: black" href="$adminurl" title="ImageFolio Administration Menu" alt="ImageFolio Administration Menu">Admin Home</a> \|};

      if (($build_per eq 'Yes') && $remind_rebuild) {
         $admin_tools .= qq|<script language="javascript">
         function admin_logout() {
            rebuild = confirm("Do you want to rebuild the index before you log out? (OK = Yes   Cancel = No)");
            if (rebuild == true) {
               location.href = "$buildurl&log_out_option=1";
            }
            else {
               location.href = "$imagefolio_url?admin=log_out";
            }
         }</script> <a style="color: black" href="javascript:admin_logout();" alt="Admin Logout" title="Admin Logout">Logout</a> \||;
      }
      else {
         $admin_tools .= qq{ <a style="color: black" href="$imagefolio_url?admin=log_out" alt="Admin Logout" title="Admin Logout">Logout</a> \|};
      }

      if ($build_per eq 'Yes') {
         $admin_tools .= qq{ <a style="color: black" href="$buildurl" alt="Rebuild The Database/Index" title="Rebuild The Database/Index">Rebuild Index</a> \|};
      }

#      $admin_tools .= qq{ <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=disk_usage','width=650,height=400,scrollbars=yes')" alt="View Disk Usage" title="View Disk Usage">Disk Usage</a> \|};


      $admin_tools .= qq|</font></font></span></td></tr></table>|;
   }
   else {
      $widthheight = $admin_button_wh;
      $widthheight = " width=64 height=43" unless $widthheight;

      if ($upload_per eq 'Yes') {
         $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')"><img src="$if_images_directory/fe_admin_upload_media.$ButtonExt" border="0" vspace=5 title="Upload New Files" alt="Upload New Files"$widthheight></a> };
         $devider = 1;
      }

      if ($desc_per eq 'Yes' && $is_admin) {
         $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=batch_action$current&batch_lbview=$FORM{'lbview'}&batch_lightbox=$FORM{'lightbox'}&batch_search=$FORM{'search'}','width=500,height=540,scrollbars=yes')"><img src="$if_images_directory/fe_admin_batch_iptc.$ButtonExt" border="0" vspace=5 title="Batch IPTC" alt="Batch IPTC"$widthheight></a> };
         $devider = 1;
      }

      $admin_tools .= qq{<img src="$if_images_directory/fe_admin_div.$ButtonExt" border="0" vspace=5> } if $devider;


      if ($addcat_per eq 'Yes') {
         $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=new_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_new.$ButtonExt" border="0" vspace=5 title="Create New Category" alt="Create New Category"$widthheight></a> };
      }

      if ($delcat_per eq 'Yes') {
         $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=delete_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_delete.$ButtonExt" border="0" vspace=5 title="Delete This Category" alt="Delete This Category"$widthheight></a> };
         $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=move_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_move.$ButtonExt" border="0" vspace=5 title="Move This Category" alt="Move This Category"$widthheight></a> };
      }


      if ($rencat_per eq 'Yes') {
         $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=rename_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_rename.$ButtonExt" border="0" vspace=5 title="Rename This Category" alt="Rename This Category"$widthheight></a> };
         $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=describe_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_describe.$ButtonExt" border="0" vspace=5 title="Edit This Category Description" alt="Edit This Category Description"$widthheight></a> };
         $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=image_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_image.$ButtonExt" border="0" vspace=5 title="Upload and Add Category Image" alt="Upload and Add Category Image"$widthheight></a> };
      }

      $admin_tools .= qq{<img src="$if_images_directory/fe_admin_div.$ButtonExt" border="0" vspace=5> };
      $admin_tools .= qq{<a href="$adminurl"><img src="$if_images_directory/fe_admin_home.$ButtonExt" border="0" vspace=5 title="ImageFolio Administration Menu" alt="ImageFolio Administration Menu"$widthheight></a> };

      if (($build_per eq 'Yes') && $remind_rebuild) {
         $admin_tools .= qq|<script language="javascript">
         function admin_logout() {
            rebuild = confirm("Do you want to rebuild the index before you log out? (OK = Yes   Cancel = No)");
            if (rebuild == true) {
               location.href = "$buildurl&log_out_option=1";
            }
            else {
               location.href = "$imagefolio_url?admin=log_out";
            }
         }</script><a href="javascript:admin_logout();"><img src="$if_images_directory/fe_admin_logout.$ButtonExt" border="0" vspace=5 title="Admin Logout" alt="Admin Logout"$widthheight></a> |;
      }
      else {
         $admin_tools .= qq{<a href="$imagefolio_url?admin=log_out"><img src="$if_images_directory/fe_admin_logout.$ButtonExt" border="0" vspace=5 title="Admin Logout" alt="Admin Logout"$widthheight></a> };
      }

      if ($build_per eq 'Yes') {
         $admin_tools .= qq{<a href="$buildurl"><img src="$if_images_directory/fe_admin_database_index.$ButtonExt" border="0" vspace=5 title="Rebuild The Database/Index" alt="Rebuild The Database/Index"$widthheight></a> };
      }


#      $admin_tools .= qq{<a href="javascript:adminPopup('$imagefolio_url?admin=disk_usage','width=650,height=400,scrollbars=yes')"><img src="$if_images_directory/diskusage.$ButtonExt" border="0" vspace=5 title="View Disk Usage" alt="View Disk Usage"$widthheight></a> };


   }
   $admin_tools .= qq{
         </td>
      </tr>
   };

   $admin_tools .= qq|
      <tr bgcolor="$main_header_bgcolor">
         <td align="center">
            $admin_demo_html
         </td>
      </tr>
   | if $admin_demo_mode;

   return $admin_tools;
}

###############################################################################
# GET CATLIST
# We use File::Find to dig though the images directory
# recursively and create a selection form
###############################################################################
sub get_fe_catlist {
   my $admin_directory = shift;
   my ($category, $imagecount, $newcategory, @categories, $selected, $space, $force_select);

#   die "$group_post_access, $group_media_upload_per, $admin_directory";

#   if ($group_post_access =~ /^$main_users_cat\// && $group_media_upload_per && $admin_directory !~ /^$main_users_cat\//) {
#      $force_select = 1;
#   }


   open (FILE,"$catfile") or &Error ("Could not open category index, $catfile. Reason: $!");
   my(@LINES)=<FILE>;
   close(FILE);
   chomp @LINES;
   @LINES = sort { lc($a) cmp lc($b) } @LINES;
   $catlistcount = 0;

   foreach $LINE(@LINES) {
      $space = '';
      $selected = '';
      $cat_color = "000000";
      ($category) = split(/\t/, $LINE);
      next if !$category;
      if ($category eq $admin_directory) { $selected = " selected" };
      if ($personal_category) {
         if ($category eq $group_post_access){
            $newcategory = $group_post_access;
            if ($block_main_cat) {
               $cat_color = "CCCCCC";
               $selected = '';
               $category = '';
            }
         }
         elsif ($category =~ /^$group_post_access\//) {
            @categories = split (/\//, $category);
            foreach $cat(@categories) {
               $space .= "......";
            }
            $newcategory = pop @categories;
            $space =~ s/............//;
         }
         else {
            next;
         }
      }
      else {
         @categories = split (/\//, $category);
         foreach $cat(@categories) {
            $space .= "......";
         }
         $newcategory = pop @categories;
         $space =~ s/\.\.\.\.\.\.//;
         if ($allow_free_post_access && $block_main_cat && ($category !~ /\//)) {
            $cat_color = "CCCCCC";
            $selected = '';
            $category = '';
         }
         elsif ($is_user && !$allow_free_post_access){
            $found_post_cat = "";
            foreach $current_post_access (@current_post_access) {
               if (($category eq $current_post_access) or ($category =~ /^$current_post_access\//)) {
                  if ($block_main_cat && ($category eq $current_post_access)) {
                     $cat_color = "CCCCCC";
                     $selected = '';
                     $category = '';
                     $catlist_js .= qq|catlist[$catlistcount]="$current_post_access";| if $no_block;
                  }
                  elsif ($current_post_access =~ /^$admin_directory\// && !$select_option1) {
                     $select_option1 = $category;
                  }
                  elsif (!$select_option2) {
                     $select_option2 = $category;
                  }
                  $found_post_cat = 1;
                  last;
               }
               elsif ($current_post_access =~ /^$category\//) {
                  $cat_color = "CCCCCC";
                  $selected = '';
                  $category = '';
                  $found_post_cat = 1;
                  last;
               }
            }
            next if !$found_post_cat;
#            if (!$found_post_cat) {
#               $cat_color = "CCCCCC";
#               $selected = '';
#               $category = '';
#            }
         }
      }
      $newcategory = &get_clean_name($newcategory);
#      if ($force_select) {
#         $selected = " selected";
#         $force_select = ();
#      }
      $catlist_selected = 1 if $selected;
      $catlistcount++;
      $catlist .= qq|<option value="$category"$selected style="color: $cat_color;">$space$newcategory\n|;
   }
#   if (!$catlist_selected) {
#      $select_option1 = $select_option2 unless $select_option1;
#      $admin_jscript .= qq|<script language="javascript">document.forms[0].admin_directory.$select_option1.selected=true;</script>| if $select_option1;
#   }
#   $on_load_temp .= qq|onLoad="document.forms[0].admin_directory.options[4].selected=true"|;

$catlistcount++;
$admin_jscript .= qq|<script language="JavaScript">
var catlist= new Array($catlistcount)
$catlist_js
</script>|;

if (!$catlist_selected) {
   $select_option1 = $select_option2 unless $select_option1;
   if ($select_option1) {
      $catlist_selected = 1;
      $admin_directory_new = $select_option1;
      $select_options = qq|<script language="JavaScript">
         function And_This(){
            var fromList = document.forms[0].admin_directory;
            for (i=0; i<fromList.length; i++) {
               if (fromList[i].value == "$select_option1") {
                  document.forms[0].admin_directory.options[i].selected=true;
               }
            }
            if(oldFunction){
               oldFunction();
            }
         }
         function loadBody(){
            oldFunction = window.onload;
            window.onload = And_This;
         };
         loadBody();
         </script>|;
   }
}

   return $catlist;
}

###############################################################################
# ADD CATEGORY IMAGE
###############################################################################
sub image_category {
   if ($is_user && !$group_cat_upload_per) {
      &Error("Sorry $ifusername, you do not have permission to add a category image.");
   }
   my $admin_ouptut;
   my $admin_directory = $FORM{'admin_directory'};

   my $admin_title = "Add/Remove Category Image";
   my $on_load = qq{onLoad="self.focus()"};
   my $catlist = &get_fe_catlist($admin_directory);
   $admin_directory = $admin_directory_new if $admin_directory_new;
   my $cat_desc;
   my $top_level;

   if (!$catlist_selected) {
      $top_level = qq|<option value="" > - Select Category</option>|;
   }

   if ($is_user && $admin_directory) {
      $skip_error_message = 1;
      &compare_cat($admin_directory);
      if (!$approve_action) {
         print "Location:$imagefolio_redirect_url?admin=image_category\n\n";
         exit;
      }
   }

   $sp_chars_admin_directory = $admin_directory;
   $sp_chars_admin_directory =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;

   if (-e "$image_directory/$admin_directory/_category_image.jpg") { 
      if ($is_user) { $input_text = "category image";}
      else { $input_text = qq|<a href="$imageurl/$sp_chars_admin_directory/_category_image.jpg" target="_blank">_category_image.jpg</a>|;}
      $admin_output = qq|<$fe_admin_font><font color="#ffffff">This Category has currently a $input_text associated with it. Click <a href="$imagefolio_url?admin=admin_image_category&admin_directory=$admin_directory&delete_cat_image=1">here</a>
      to remove it or upload a new image to overwrite it.</font></font><br><br>|;
   }

   $admin_output = qq|
      <form method="POST" action="$uploadurl" ENCTYPE="multipart/form-data">
      <input type="hidden" name="fe_admin" value="1">
      <input type="hidden" name="cat_image_upload" value="1">
      $block_main_cat_script2
      <table width="100%" cellpadding="8" cellspacing="8" border="0">
         <tr>
            <td align="center">
               <table border=0 cellspacing=0 cellpadding=2 width="100%">
                  <tr>
                     <td align=center>$admin_output<br><$fe_admin_small_font><font color="#ffffff"><b>U P L O A D&nbsp;&nbsp;&nbsp;L O C A T I O N</b></font></font><br>
                     <select name="admin_directory" onChange="if(block_main_cat_value){block_main_cat();}if(!skip_forward){window.location='$imagefolio_url?admin=image_category&admin_directory=' + this[this.selectedIndex].value;}">
                     $top_level
                     $catlist
                     </select></br></br>
                     </td>
                  </tr>
                  <tr>
                     <td nowrap align=center><$fe_admin_small_font><font color="#ffffff"><b>U P L O A D&nbsp;&nbsp;&nbsp;C A T E G O R Y&nbsp;&nbsp;&nbsp;I M A G E</b> (Must be a <font color="$warning_font_color">jpg</font> image!)</font></font>
                     </td>
                  </tr>
                  <tr>
                     <td align=center><input type="file" name="cat_image"></td>
                  </tr>
               </table>
               <br>
               <br>
               <input type=submit value="Upload Category Image">
            </td>
         </tr>
      </table>
      </form>|;


   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# ADMIN CATEGOY IMAGE UPLOAD
###############################################################################
sub admin_image_category {
   my $admin_title = "Category Image Uploaded";
   $admin_title = "Category Image Deleted" if $FORM{'delete_cat_image'};
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }
   my $admin_directory = $FORM{'admin_directory'};
   my @admin_directory = split(/\//, $admin_directory);
   pop(@admin_directory);
   my $new_parent = join("/", @admin_directory);

   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$new_parent'"};

   if ($FORM{'delete_cat_image'}) {
      if ($is_user && $admin_directory) {
         &compare_cat($admin_directory);
         $cachereload = 1;
      }
      unlink("$image_directory/$admin_directory/_category_image.jpg") or &Error ("Could not remove _category_image.jpg.  Reason: $!");
      $comment = qq|<font color="$warning_font_color">_category_image.jpg</font> was deleted from the category <font color="$warning_font_color">$admin_directory</font>|;
   }
   else {
      $comment = qq|<font color="$warning_font_color">$FORM{"cat_image"}</font> was successfully uploaded to the category <font color="$warning_font_color">$admin_directory</font>|;
   }

   my $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td><$fe_admin_font><b>$comment<br><br>Please wait while your display is updated.</b></font>
            </td>
         </tr>
      </table>
   };

&popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# UPLOAD MEDIA
# Interface for uploading media
###############################################################################
sub upload_image {
   if ($is_user && !$group_media_upload_per) {
      &Error("Sorry $ifusername, you do not have permission to upload files to this site.");
   }
   elsif ($is_admin) {
      @allow_extensions = ();
      foreach $key (keys %extensions) {
         push(@allow_extensions, $key);
      }
   }
   my $admin_ouptut;
   my $admin_directory = $FORM{'admin_directory'};

   eval qq{ require "$libpath/zoomify.pl"; };
   if ($using_zoomify) {
      my %IFZ_CONFIG = &ifz_get_settings("$group_group_name");
      if ($IFZ_CONFIG{'ifz_upload'}) {
         $iBULC_upload = 1;
         $use_single_file_upload = ();
         $use_manual_file_upload = ();
      }
   }

   $use_link_upload = () unless exists($extensions{lc("emb")});

   if (!$FORM{'up_type'}) {
      if ($iBULC_upload) {
         $FORM{'up_type'} = "Batch";
      }
      elsif ($use_single_file_upload) {
         $FORM{'up_type'} = "Single";
      }
      elsif ($use_manual_file_upload) {
         $FORM{'up_type'} = "Manual";
      }
      elsif ($use_link_upload) {
         $FORM{'up_type'} = "Link";
      }
      else {
         &Error("Sorry $ifusername, the site is not configered to allow any type of upload.");
      }
   }

   $pre_title = "$FORM{'up_type'} ";

   my $admin_title = $pre_title . "Upload Media";
   my $on_load = qq{onLoad="self.focus()"};
   my $catlist = &get_fe_catlist($admin_directory);
   $admin_directory = $admin_directory_new if $admin_directory_new;

   $type_count = 0;

   if ($iBULC_upload) {
      $type_count++;
   }
   if ($use_single_file_upload) {
      $type_count++;
   }
   if ($use_manual_file_upload) {
      $type_count++;
   }
   if ($use_link_upload) {
      $type_count++;
   }

   if ($type_count == 2) {
      $type_width = "50%";
   }
   elsif ($type_count == 3) {
      $type_width = "33%";
   }
   elsif ($type_count == 4) {
      $type_width = "25%";
   }
   $upselection = ();

   $upload_animation = qq|
   <script language="javascript">
      var now = new Date();
      var uploadAnimation = new Image();
      uploadAnimation.src = '$if_images_directory/upload_in_progress.gif?'+now.getTime();
      function upload_progress_gif (whichform) {
         var agt=navigator.userAgent.toLowerCase();
         var is_major = parseInt(navigator.appVersion); 
         var is_ie   = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
         var is_ie3  = (is_ie && (is_major < 4));
         var is_ie4  = (is_ie && (is_major == 4) && (agt.indexOf("msie 5")==-1) && (agt.indexOf("msie 6") == -1)); 
         var is_ie5up  = (is_ie  && !is_ie3 && !is_ie4); 
         var is_nav  = ((agt.indexOf('mozilla')!=-1) && (agt.indexOf('spoofer')==-1) && (agt.indexOf('compatible') == -1) && (agt.indexOf('opera')==-1) && (agt.indexOf('webtv')==-1) && (agt.indexOf('hotjava')==-1) && (agt.indexOf("safari")==-1));
         var is_nav6up = (is_nav && (is_major >= 5));
         if (is_ie5up \|\| is_nav6up){
            for (i=1; i<whichform.elements.length; i++) {
               if (whichform.elements[i].type == 'file') {
                  whichform.elements[i].style.visibility="hidden";
               }
            }
            whichform.elements['admin_directory'].style.visibility="hidden";
            whichform.elements['submit'].style.visibility="hidden";
            if (is_ie5up){
               document.all['uploadingDiv'].style.visibility = "visible";
               setTimeout("document.all['uploadingDiv'].document.images['uploadImg'].src = uploadAnimation.src",10);
            }
            else{
               document.getElementById('uploadingDiv').style.visibility = "visible";
            }
         }
      }
   </script>|;

   if (lc($FORM{'up_type'}) eq "batch") {
      $submit_text = "Select Media";
      if ($is_admin) {
         $set_upload_date = qq|<tr><td align=center><table><tr><td><$fe_admin_small_font><font color="#ffffff"><b>Option 1:</b> Set the upload date to today minus <input type="text" name="set_upload_date" size="3" value="0"> days.</font></font></td></tr><!--<tr><td><$fe_admin_small_font><font color="#ffffff"><b>Option 2:</b> <input type="checkbox" name="IPTCupdate" value="1"> Check to upload only IPTC information from your files.</font></font></td></tr>-->|;
      }
      $submit_onclick = ();
      if ($type_count > 1) {
         my $batch_tab_on = qq|<font color="#ffffff"><b>BATCH UPLOAD</b></font>|;
         $upselection .= &on_tab($batch_tab_on);
         if ($use_single_file_upload) {
            my $single_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Single" class="roll"><$font>SINGLE UPLOAD</font></a></b>|;
            $upselection .= &off_tab($single_tab_off);
         }
         if ($use_manual_file_upload) {
            my $manual_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Manual" class="roll"><$font>MANUAL UPLOAD</font></a></b>|;
            $upselection .= &off_tab($manual_tab_off);
         }
         if ($use_link_upload) { #LINK STUFF
            my $link_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Link" class="roll"><$font>LINK UPLOAD</font></a></b>|;
            $upselection .= &off_tab($link_tab_off);
         }
      }
      $upload_form = qq|<table width="100%" cellpadding="8" cellspacing="8" border="0">
      <form method="POST" action="$iBULC_uploaddurl">
      <input type="hidden" name="fe_admin" value="1">
      <tr><td align="center"><table border=0 cellspacing=0 cellpadding=2 width="100%">
       <tr><td>&nbsp;</td></tr>$set_upload_date|;
   }
   elsif (lc($FORM{'up_type'}) eq "single") {
      $admin_jscript .= $upload_animation;
      $submit_text = "Upload Media";
      $submit_onclick = qq| onclick="upload_progress_gif(this.form);"|;
      if ($type_count > 1) {
         if ($iBULC_upload) {
            my $batch_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Batch" class="roll"><$font>BATCH UPLOAD</font></a></b>|;
            $upselection .= &off_tab($batch_tab_off);
         }
         my $single_tab_on = qq|<font color="#ffffff"><b>SINGLE UPLOAD</b></font>|;
         $upselection .= &on_tab($single_tab_on);
         if ($use_manual_file_upload) {
            my $manual_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Manual" class="roll"><$font>MANUAL UPLOAD</font></a></b>|;
            $upselection .= &off_tab($manual_tab_off);
         }
         if ($use_link_upload) {  #LINK STUFF
            my $link_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Link" class="roll"><$font>LINK UPLOAD</font></a></b>|;
            $upselection .= &off_tab($link_tab_off);
         }
      }
      foreach $allow_extension (@allow_extensions) {
         next if (lc($allow_extension) !~ /(jpg|tif|png|psd|pcd|bmp)/i);
         my $used_icon = $extensions{lc($allow_extension)}[4];
         if ($used_icon) {
            $my_allow_extension .= "$allow_extension</font>, <font color=white>";
         }
      }
      $my_allow_extension =~ s/\<\/font\>\, \<font color\=white\>$//g;

      if ($use_fullsize && (lc($myextension_fullsize) ne 'zip')) {
         $my_allow_extension = lc($myextension_fullsize);
      }

      my $media_text = qq| (Can only be a <font color="$warning_font_color">$my_allow_extension</font> image!)|;
      $upload_form = qq|<table width="100%" cellpadding="8" cellspacing="8" border="0">
      <form method="POST" action="$imuploaddurl" ENCTYPE="multipart/form-data">
      <input type="hidden" name="fe_admin" value="1">
      <tr><td align="center"><table border=0 cellspacing=0 cellpadding=2 width="100%">
      <tr><td align=left><$fe_admin_small_font><font color="#ffffff"><b>U P L O A D&nbsp;&nbsp;&nbsp;M E D I A</b>$media_text</font></font></td></tr>
      <tr><td align=left><input type="file" name="FILE1" size=40></td></tr>|;
   }
   elsif (lc($FORM{'up_type'}) eq "link") {  #LINK STUFF GOES IN HERE
      $admin_jscript .= $upload_animation;
      $submit_text = "Add External Media";
      $submit_onclick = qq| onclick="upload_progress_gif(this.form);"|;
      if ($type_count > 1) {
         if ($iBULC_upload) {
            my $batch_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Batch" class="roll"><$font>BATCH UPLOAD</font></a></b>|;
            $upselection .= &off_tab($batch_tab_off);
         }
         if ($use_single_file_upload) {
            my $single_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Single" class="roll"><$font>SINGLE UPLOAD</font></a></b>|;
            $upselection .= &off_tab($single_tab_off);
         }   
         if ($use_manual_file_upload) {
            my $manual_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Manual" class="roll"><$font>MANUAL UPLOAD</font></a></b>|;
            $upselection .= &off_tab($manual_tab_off);
         }  
         my $link_tab_on = qq|<font color="#ffffff"><b>LINK UPLOAD</b></font>|;
         $upselection .= &on_tab($link_tab_on);
      }
      $upload_form = qq|
      <table width="100%" cellpadding="8" cellspacing="8" border="0">
      <form method="POST" action="$uploadlinkurl" ENCTYPE="multipart/form-data">
      <input type="hidden" name="fe_admin" value="1">
      <tr><td align="center"><table border=0 cellspacing=0 cellpadding=2 width="100%">
      <tr><td align=left><$fe_admin_small_font><font color="#ffffff"><b>U R L</b> (Please enter the URL for this video)</font></font></td></tr>
      <tr><td align=left><input type="text" name="link_upload" size=40></td></tr>
      <tr><td align=left><$fe_admin_small_font><font color="#ffffff"><b>T H U M B N A I L</b> (Upload an optional thumbnail image)</font></font></td></tr>
      <tr><td align=left><input type="file" name="THUMB" size=40></td></tr>|;
   }
   else {
      $admin_jscript .= $upload_animation;
      $submit_text = "Upload Media";
      $submit_onclick = qq| onclick="upload_progress_gif(this.form);"|;
      if ($type_count > 1) {
         if ($iBULC_upload) {
            my $batch_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Batch" class="roll"><$font>BATCH UPLOAD</font></a></b>|;
            $upselection .= &off_tab($batch_tab_off);
         }
         if ($use_single_file_upload) {
            my $single_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Single" class="roll"><$font>SINGLE UPLOAD</font></a></b>|;
            $upselection .= &off_tab($single_tab_off);
         }
         my $manual_tab_on = qq|<font color="#ffffff"><b>MANUAL UPLOAD</b></font>|;
         $upselection .= &on_tab($manual_tab_on);
         if ($use_link_upload) {  #LINK STUFF
            my $link_tab_off = qq|<b><a href="$imagefolio_url?admin=upload_image&admin_directory=$FORM{'admin_directory'}&up_type=Link" class="roll"><$font>LINK UPLOAD</font></a></b>|;
            $upselection .= &off_tab($link_tab_off);
         }
      }
      foreach $allow_extension (@allow_extensions) {
         next if ($allow_extension =~ /^(ifz|emb)$/i);
         my $used_icon = $extensions{lc($allow_extension)}[4];
         if ($used_icon) {
            $my_allow_extension .= "$allow_extension</font>, <font color=white>";
         }
      }
      $my_allow_extension =~ s/\<\/font\>\, \<font color\=white\>$//g;
      $upload_form = qq|
      <table width="100%" cellpadding="8" cellspacing="8" border="0">
      <form method="POST" action="$uploadurl" ENCTYPE="multipart/form-data">
      <input type="hidden" name="fe_admin" value="1">
      <tr>
      <td align="center"><table border=0 cellspacing=0 cellpadding=2 width="100%">
      <tr><td align=left><$fe_admin_small_font><font color="#ffffff"><b>L I N K E D&nbsp;&nbsp;&nbsp;M E D I A</b> (Can only be a <font color="$warning_font_color">$my_allow_extension</font>)</font></font></td></tr>
      <tr><td align=left><input type="file" name="FILE1" size=40></td></tr>
      <tr><td align=left><$fe_admin_small_font><font color="#ffffff"><b>T H U M B N A I L&nbsp;&nbsp;&nbsp;I M A G E</b> (Must be a <font color="$warning_font_color">jpg</font> image!)</font></font></td></tr>
      <tr><td align=left><input type="file" name="FILE2" size=40></td></tr>|;
      if ($use_fullsize) {
         foreach $allow_extension (@allow_extensions) {
            next if ($allow_extension =~ /^(ifz|emb)$/i);
            my $used_icon = $extensions{lc($allow_extension)}[4];
            if ($used_icon) {
               $my_allow_extension .= "$allow_extension</font>, <font color=white>";
            }
         }
         $my_allow_extension =~ s/\<\/font\>\, \<font color\=white\>$//g;

         if ($use_fullsize && (lc($myextension_fullsize) ne 'zip')) {
            $my_allow_extension = lc($myextension_fullsize);
         }
         $upload_form .= qq|
         <tr><td align=left><$fe_admin_small_font><font color="#ffffff"><b>F U L L&nbsp;&nbsp;&nbsp;S I Z E&nbsp;&nbsp;&nbsp;D O W N L O A D&nbsp;&nbsp;&nbsp;F I L E</b> (Can only be a <font color="$warning_font_color">$my_allow_extension</font>)</font></font></td></tr>
         <tr><td align=left><input type="file" name="FILE3" size=40></td></tr>|;
      }
   }

   $admin_output = $block_main_cat_script2;




   sub off_tab {
      my $input = shift;
      my $tab = qq|<td align="center" width="$type_width" bgcolor="$main_table_border_color">
                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr> 
                        <td width="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>
                        <td bgcolor="$main_nav_bgcolor" width="100%" align="center"><$font>$input</font></td>
                        <td width="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>
                     </tr>
                     <tr>
                        <td colspan="3" height="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>
                     </tr>
                  </table>
               </td>|;
      return $tab;
   }

   sub on_tab {
      my $input = shift;
      my $tab = qq|<td align="center" width="$type_width"><$font>$input</font></td>|;
      return $tab;
   }



   if ($type_count > 1) {
      $admin_output .= qq|<table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
         $upselection
      </tr>
      </table>|;
   }


#  <IFRAME width="308" height="250" src="$if_images_directory/upload_in_progress.$ButtonExt" scrolling="No" marginwidth=0 marginheight=0 frameborder="No"></IFRAME>


   $uploading_div = qq|<div id="uploadingDiv" style="position:absolute; z-index:1; border: 0px; visibility: hidden"><table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="#999999">
     <tr>
       <td align="center"><br><br><img name="uploadImg" src="$if_images_directory/upload_in_progress.gif" width="308" height="250" border="0"><br></td>
     </tr>
   </table></div>|;

   $admin_output .= qq|$uploading_div$upload_form
      <tr><td align=center><br><$fe_admin_small_font><font color="#ffffff"><b>U P L O A D&nbsp;&nbsp;&nbsp;L O C A T I O N</b></font></font><br><select name="admin_directory" size=8$block_main_cat_script1>$catlist</select></td></tr>
      </table><br><input type="submit" name="submit" value="$submit_text"$submit_onclick></td></tr></form></table>|;

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# REPLACE MEDIA
# Interface for uploading media
###############################################################################
# sub replace_media {

#   my $admin_ouptut;
#   my $admin_directory = $FORM{'admin_directory'};
#   my @admin_images = ($FORM{'admin_image1'},$FORM{'admin_image2'});

#   if ($is_user) {
#      if (!$group_media_upload_per) {
#         &Error("Sorry $ifusername, you do not have permission to upload files to this site.");
#      }
#      require "$libpath/iptc.pl";
#      %IPTCfields = ();
#      foreach $admin_image (@admin_images) {
#         ($extension) = ($admin_image =~ /\.([^.]+)$/);
#         if (lc($extension) eq 'jpg' && !$custom18_user) {
#            $iptc_image = $admin_image;
#            $iptc_category = $admin_directory;
#            &iptc_create_table;
#         }
#         $image_selection .= qq|<input type="hidden" name="image_list" value="$admin_image">|;
#      }
#      if (($custom18_user ne $ifusername) or $confirmed_guest) {
#         if (!$custom18_user) {
#            $custom18_user = "server admin";
#         }
#         &Error("Sorry $ifusername, you do not have permission to replace files from $custom18_user.");
#      }
#   }
#   else {
#      @allow_extensions = ();
#      foreach $key (keys %extensions) {
#         push(@allow_extensions, $key);
#      }
#      foreach $admin_image (@admin_images) {
#         $image_selection .= qq|<input type="hidden" name="image_list" value="$admin_image">|;
#      }
#   }

#   if (!$FORM{'up_type'}) {
#      if ($use_single_file_upload) {
#         $FORM{'up_type'} = "Single";
#      }
#      elsif ($use_manual_file_upload) {
#         $FORM{'up_type'} = "Manual";
#      }
#      else {
#         $FORM{'up_type'} = "Single";
#      }
#   }

#   $pre_title = "$FORM{'up_type'} ";


#   my $admin_title = "Replace Media";
#   my $on_load = qq{onLoad="self.focus()"};
#   my $catlist = &get_fe_catlist($admin_directory);

#   $type_count = 0;

#   if ($use_single_file_upload) {
#      $type_count++;
#   }
#   if ($use_manual_file_upload) {
#      $type_count++;
#   }

#   if ($type_count == 2) {
#      $type_width = "50%";
#   }
#   elsif ($type_count == 3) {
#      $type_width = "33%";
#   }

#   $upselection = ();

#   if (lc($FORM{'up_type'}) eq "single") {
#      $submit_text = "Upload Media";
#      $submit_onclick = qq| onclick="upload_progress(this.form);"|;
#      if ($type_count > 1) {
#         my $single_tab_on = qq|<b>SINGLE UPLOAD</b>|;
#         $upselection .= &on_tab($single_tab_on);
#         if ($use_manual_file_upload) {
#            my $manual_tab_off = qq|<b><a href="$imagefolio_url?admin=replace_media&admin_directory=$FORM{'admin_directory'}&up_type=Manual" class="roll"><$font>MANUAL UPLOAD</font></a></b>|;
#            $upselection .= &off_tab($manual_tab_off);
#         }
#      }
#      foreach $allow_extension (@allow_extensions) {
#         next if (lc($allow_extension) !~ /(jpg|tif|png|psd|pcd|bmp)/i);
#         my $used_icon = $extensions{lc($allow_extension)}[4];
#         if ($used_icon) {
#            $my_allow_extension .= "$allow_extension</font>, <font color=red>";
#         }
#      }
#      $my_allow_extension =~ s/\<\/font\>\, \<font color\=red\>$//g;

#      if ($use_fullsize && (lc($myextension_fullsize) ne 'zip')) {
#         $my_allow_extension = lc($myextension_fullsize);
#      }

#      my $media_text = qq| (Can only be a <font color=red>$my_allow_extension</font> image!)|;
#      $upload_form = qq|<table width="100%" cellpadding="8" cellspacing="8" border="0">
#      <form method="POST" action="$imuploaddurl" ENCTYPE="multipart/form-data">
#      <input type="hidden" name="fe_admin" value="1">
#      <input type="hidden" name="fe_replace" value="1">
#      $image_selection
#      <tr><td align="center"><table border=0 cellspacing=0 cellpadding=2 width="100%">
#      <tr><td nowrap><$fe_admin_small_font><b>U P L O A D&nbsp;&nbsp;&nbsp;M E D I A</b>$media_text</font></td></tr>
#      <tr><td><input type="file" name="FILE1" size=40></td></tr>|;
#   }
#   else {
#      $submit_text = "Upload Media";
#      $submit_onclick = qq| onclick="upload_progress(this.form);"|;
#      if ($type_count > 1) {
#         if ($use_single_file_upload) {
#            my $single_tab_off = qq|<b><a href="$imagefolio_url?admin=replace_media&admin_directory=$FORM{'admin_directory'}&up_type=Single" class="roll"><$font>SINGLE UPLOAD</font></a></b>|;
#            $upselection .= &off_tab($single_tab_off);
#         }
#         my $manual_tab_on = qq|<b>MANUAL UPLOAD</b>|;
#         $upselection .= &on_tab($manual_tab_on);
#      }
#      foreach $allow_extension (@allow_extensions) {
#         my $used_icon = $extensions{lc($allow_extension)}[4];
#         if ($used_icon) {
#            $my_allow_extension .= "$allow_extension</font>, <font color=red>";
#         }
#      }
#      $my_allow_extension =~ s/\<\/font\>\, \<font color\=red\>$//g;
#      $upload_form = qq|
#      <table width="100%" cellpadding="8" cellspacing="8" border="0">
#      <form method="POST" action="$uploadurl" ENCTYPE="multipart/form-data">
#      <input type="hidden" name="fe_admin" value="1">
#      <input type="hidden" name="fe_replace" value="1">
#      $image_selection
#      <tr>
#      <td align="center"><table border=0 cellspacing=0 cellpadding=2 width="100%">
#      <tr><td nowrap><$fe_admin_small_font><b>L I N K E D&nbsp;&nbsp;&nbsp;M E D I A</b> (Can only be a <font color=red>$my_allow_extension</font>)</font></td></tr>
#      <tr><td><input type="file" name="FILE1" size=40></td></tr>
#      <tr><td nowrap><$fe_admin_small_font><b>T H U M B N A I L&nbsp;&nbsp;&nbsp;I M A G E</b> (Must be a <font color=red>jpg</font> image!)</font></td></tr>
#      <tr><td><input type="file" name="FILE2" size=40></td></tr>|;
#      if ($use_fullsize) {
#         foreach $allow_extension (@allow_extensions) {
#            my $used_icon = $extensions{lc($allow_extension)}[4];
#            if ($used_icon) {
#               $my_allow_extension .= "$allow_extension</font>, <font color=red>";
#            }
#         }
#         $my_allow_extension =~ s/\<\/font\>\, \<font color\=red\>$//g;

#         if ($use_fullsize && (lc($myextension_fullsize) ne 'zip')) {
#            $my_allow_extension = lc($myextension_fullsize);
#         }
#         $upload_form .= qq|
#         <tr><td nowrap><$fe_admin_small_font><b>F U L L&nbsp;&nbsp;&nbsp;S I Z E&nbsp;&nbsp;&nbsp;D O W N L O A D&nbsp;&nbsp;&nbsp;F I L E</b> (Can only be a <font color=red>$my_allow_extension</font>)</font></td></tr>
#         <tr><td><input type="file" name="FILE3" size=40></td></tr>|;
#      }
#   }

#   $admin_output = $block_main_cat_script2;




#   sub off_tab {
#      my $input = shift;
#      my $tab = qq|<td align="center" width="$type_width" bgcolor="$main_table_border_color">
#                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
#                     <tr> 
#                        <td width="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>
#                        <td bgcolor="$main_nav_bgcolor" width="100%" align="center"><$font>$input</font></td>
#                        <td width="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>
#                     </tr>
#                     <tr>
#                        <td colspan="3" height="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>
#                     </tr>
#                  </table>
#               </td>|;
#      return $tab;
#   }

#   sub on_tab {
#      my $input = shift;
#      my $tab = qq|<td align="center" width="$type_width"><$font><font color="#000000">$input</font></font></td>|;
#      return $tab;
#   }



#   if ($type_count > 1) {
#      $admin_output .= qq|<table width="100%" border="0" cellspacing="0" cellpadding="0">
#      <tr>
#         $upselection
#      </tr>
#      </table>|;
#   }


#  <IFRAME width="308" height="250" src="$if_images_directory/upload_in_progress.$ButtonExt" scrolling="No" marginwidth=0 marginheight=0 frameborder="No"></IFRAME>


#   $uploading_div = qq|<div id="uploadingDiv" style="position:absolute; z-index:1; border: 0px; visibility: hidden"><table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="#999999">
#     <tr>
#       <td align="center"><br><br><img name="uploadImg" src="$if_images_directory/upload_in_progress.$ButtonExt" width="308" height="250" border="0"><br><br><$font><font color="#FF9900"><b>UPLOAD IN PROGRESS...</b></font></font><br></td>
#     </tr>
#   </table></div>|;

#   $admin_output .= qq|$uploading_div$upload_form
#      <tr><td align=center><br><$fe_admin_small_font><b>U P L O A D&nbsp;&nbsp;&nbsp;L O C A T I O N</b></font><br><select name="admin_directory" size=8$block_main_cat_script1>$catlist</select></td></tr>
#      </table><br><input type="submit" name="submit" value="$submit_text"$submit_onclick></td></tr></form></table>|;

#   &popup_display($admin_output, $admin_title, $on_load);
#}

###############################################################################
# ADMIN UPLOAD MEDIA
# Interface for uploading media
###############################################################################
sub admin_upload_image {
   my $admin_ouptut;
   my $admin_directory = $FORM{'admin_directory'};
   my $admin_title = "Media Uploaded";

   if ($is_user) {
      $cachereload = 1;
   }

   &refresh_category_cache($admin_directory);

   $ucount = 1;
   while ($ucount != 4) {
      if ($FORM{"image$ucount"}) {
         if (!$run_once) {
            $run_once = 1;
            $comment = qq|<$fe_admin_font><b>The following files were upload and renamed if necessary:<br>|;
         }
         $comment .= qq|- <font color="$warning_font_color">$FORM{"image$ucount"}</font><br>|;
         ($extension) = ($FORM{"image$ucount"} =~ /\.([^.]+)$/);
         if (lc($extension) eq 'jpg') {
            $caption_option = 1;
         }
      }
      $ucount++;
   }
   if ($run_once) {
      $comment .= qq|to the category: <font color="$warning_font_color">$admin_directory</font>|;
      if ($FORM{'wrong_tn_extension'}) {
         $comment .= qq|<br>Note: Your uploaded thumbnail was not a jpg image and was replaced by a default icon.|;
         $time_delay = "4000";
      }
      if ($FORM{'wrong_tn_extension'}) {
         $comment .= qq|<br>Note: Your uploaded high resolution file was not a $myextension_fullsize file and was not saved.|;
         $time_delay = "4000";
      }
      $comment .= "</b></font>";
   }

   if (!$time_delay) {
      $time_delay = "2000";
   }

   if ($caption_option && ($is_admin or ($is_user && $group_media_desc_per))) {
      $caption_forward = qq|<script language="javascript">function add_caption() { location.href = "$imagefolio_url?admin=caption_confirm_image&admin_directory=$admin_directory&admin_image1=$FORM{'image1'}&admin_image2=$FORM{'image2'}&from_ul=1"; }</script>|;
      $on_load = qq{onLoad="self.focus();setTimeout('add_caption()',$time_delay)" onUnload="this.opener.location='$imagefolio_url?direct=$admin_directory'"};
   }
   else {
      $on_load = qq{onLoad="self.focus();setTimeout('self.close()',$time_delay)" onUnload="this.opener.location='$imagefolio_url?direct=$admin_directory'"};
   }

   my $admin_output = qq|
      $caption_forward
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td>$comment<br><br>
               <$fe_admin_font><b>Please wait while your display is updated.</b></font>
            </td>
         </tr>
      </table>
   |;


   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# MOVE
# Moves a category
###############################################################################
sub admin_move {
   my $admin_title = "Category Moved";
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }
   my $admin_directory = $FORM{'admin_directory'};
   if (!$admin_directory) { &Error ("You must select a Category to Move."); }
   elsif ($using_picturepost_mod){
      require "$config_directory/post_config.pl";
      if ($main_users_cat eq $admin_directory) {
         &Error("You can not move this category through your browser. You will need to change the value of \"\$main_users_cat\" in your post_config.pl and then rename the category trough FTP. After that rebuild the index!");
      }
   }

   my $new_parent = $FORM{'toList'};
   if (!$new_parent && ($block_main_cat or !$allow_free_post_access) && !$is_admin) { &Error ("You must select a destination Category."); }

   if ($is_user) {
      if (!$group_cat_move_per) {
         &Error("Sorry $ifusername, you do not have permission to move a category.");
      }
      elsif ($block_main_cat && !$new_parent) {
         &Error("Sorry $ifusername, you must select a destination Category.");
      }
      $personal_category_block = 1;
      &compare_cat($admin_directory);
      $personal_category_block = ();
      $group_media_main_cat_per = 1;
      &compare_cat($new_parent);
      $cachereload = 1;
   }

   &refresh_category_cache($admin_directory);
   &refresh_category_cache($new_parent);

   my @admin_directory = split (/\//, $admin_directory);
   my $from_name = pop(@admin_directory);

   my $slash = "/" if $new_parent;
   my $new_directory = $new_parent . "$slash" . $from_name;
   if ($new_directory eq $admin_directory) { &Error("You must select a new destination category."); }

   my $full_old = "$image_directory/$admin_directory";
   my $full_new = "$image_directory/$new_directory";

   &check_dir($from_name, $full_new);

   rename ("$full_old", "$full_new") or &Error("Could not move category, $from_name.  Reason: $!");

   &six_steps($admin_directory, $new_directory);


   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$new_directory'"};

   my $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td align="center">
               <$fe_admin_font><b>The category <font color="$warning_font_color">$from_name</font> has moved to <font color="$warning_font_color">$new_directory</font>.<br>
               <$fe_admin_font><b>Please wait while your display is updated.
            </td>
         </tr>
      </table>
   };

&popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# SIX STEPS
# Six easy steps to a happier, healthier category
###############################################################################
sub six_steps {
   my ($admin_directory, $new_directory) = @_;

# SECOND, WE RENAME ALL INSTANCES OF THE OLD CATEGORY IN THE IMAGE INDEX
   open (FILE,"$indexfile") or &Error("Could not open $indexfile, is it created.  Reason: $!");
   my(@LINES)=<FILE>;
   close(FILE);
   chomp @LINES;
   $SIZE=@LINES;

   open (INDEX,">$indexfile") or &Error ("Could not open $indexfile, is it created.  Reason: $!");
   if ($useflock) { flock(INDEX, 2); }
   for ($i=0; $i<=$SIZE; $i++) {
      $_ = $LINES[$i];
      my ($filename, $path, $blah1, $iptc, $keywords, $blah2, $blah3, $blah4, $blah5) = split(/\|/, $_);

      /^#/      and next;        # Skip comment Lines.
      /^\s*$/   and next;        # Skip blank lines.

      if ($path =~ /^$admin_directory\//g or $path eq $admin_directory) {
         $snicker = $path;
         $snicker =~ s/^$admin_directory/$new_directory/g;
         print INDEX "$filename\|$snicker\|\$blah|$iptc|$keywords|$blah2|$blah3|$blah4|$blah5|\n";
      } else {
         print INDEX $_ . "\n";
      }
   }
   if ($useflock) { flock(INDEX, 8); }
   close(INDEX);
   chmod(0777,"$indexfile") or &Error("Could not set permissions on index, $indexfile.  Reason: $!");

# THIRD, WE RENAME THE CAPTIONS AND THUMBNAIL CAPTIONS
   if ($if2_caption or $if2_thumbcaption) {
      $ncat = $admin_directory;
      $ncat =~ s/\//\./g;           # Generate filename for our existing captions file
      $rncat = $new_directory;
      $rncat =~ s/\//\./g;          # Generate filename for our new captions file
      @old_files = ();

      opendir (CACHE, "$data_directory") or &Error("Can't Open $data_directory: $!");
      @old_files = grep { /^$ncat\./i } readdir(CACHE);
      closedir (CACHE);

      foreach $old_file(@old_files) {
         $adding = $old_file;
         $adding =~ s/^$ncat//g;
         $new_file = $rncat . $adding;
         rename ("$data_directory/$old_file", "$data_directory/$new_file") or &Error("Could not rename data file, $old_file.  Reason: $!");
         chmod(0777,"$data_directory/$new_file") or &Error ("Could not set permissions on data file, $new_file.  Reason: $!");
      }
   }

# THIRD A, WE RENAME THE PRICE FILES

   $ncat = $admin_directory;
   $ncat =~ s/\//\./g;           # Generate filename for our existing captions file
   $rncat = $new_directory;
   $rncat =~ s/\//\./g;          # Generate filename for our new captions file
   @old_files = ();

   opendir (CACHE, "$commercedata/prices");
   @old_files = grep { /^$ncat\./i } readdir(CACHE);
   closedir (CACHE);

foreach $old_file (@old_files) {
      $adding = $old_file;
      $adding =~ s/^$ncat//g;
      $new_file = $rncat . $adding;
      rename ("$commercedata/prices/$old_file", "$commercedata/prices/$new_file") or &Error ("Could not rename pricefile, $old_file.  Reason: $!");
      chmod(0777,"$commercedata/prices/$new_file") or &Error ("Could not set permissions on price file, $new_file.  Reason: $!");
}

# FORTH, WE RENAME ALL INSTANCES OF THE OLD CATEGORY IN THE USER ACCESS DATABASE AND SESSIONS
   if ($using_multiuser_mod && ($admin_directory !~ /\//)){
      sub read_access_line {
         my $split_line = shift;
         &split_if_groupline($split_line);
         if ($group_cat_access){
            @users_cat = split(/::/,$group_cat_access);
            $group_cat_access = ();
            foreach $users_cat (@users_cat) {
               if ($users_cat eq $admin_directory){
                  $access_cat_found = 1;
                  $group_cat_access .= $new_directory . "::";
               }
               else {
                  $group_cat_access .= $users_cat . "::";
               }
            }
            $group_cat_access =~ s/::$//g;
         }
         if ($group_post_access){
            @users_post = split(/::/,$group_post_access);
            $group_post_access = ();
            foreach $users_post (@users_post) {
               if ($users_post eq $admin_directory){
                  $access_post_found = 1;
                  $group_post_access .= $new_directory . "::";
               }
               else {
                  $group_post_access .= $users_post . "::";
               }
            }
            $group_post_access =~ s/::$//g;
         }
         &populate_if_groupline;
         $newgroupdb .= "$if_groupline";
         if ($readgroupdb) {$newgroupdb .= "\n";}
      }

      open (GROUPDB,"$groupdb");
      my (@LINES)=<GROUPDB>;
      close(GROUPDB);
      chomp @LINES;
      $readgroupdb = 1;
      foreach $accessfiledata (@LINES) {
         &read_access_line($accessfiledata);
      }

      if ($access_cat_found or $access_post_found) {
         open(GROUPDB, ">$groupdb");
         if ($useflock) { flock(GROUPDB, 2); }
         print GROUPDB "$newgroupdb";
         close(GROUPDB);
         chmod(0777,"$groupdb");
      }

      opendir (IDS, "$sessions_dir");
      my @sessions = grep { /\.user/ } readdir(IDS);
      closedir (IDS);
      $NUMSESSIONS = @sessions;

      if ($NUMSESSIONS > 1) {
        $readgroupdb = ();
        foreach $session (@sessions) {
            $access_cat_found = ();
            $access_post_found = ();
            $newgroupdb = ();
            open (SESSION,"$sessions_dir/$session");
            my (@SESSIONLINE)=<SESSION>;
            close(SESSION);
            chomp @SESSIONLINE;
            my ($userline, $groupline) = @SESSIONLINE[0] =~ /\[(.*?)\]/g;
            &read_access_line($groupline);
            if ($access_cat_found or $access_post_found) {
               open(SESSION, ">$sessions_dir/$session");
               if ($useflock) { flock(SESSION, 2); }
               print SESSION "[$userline][$newgroupdb]\n";
               close(SESSION);
               chmod(0777,"$sessions_dir/$session");
            }
        }
      }

   }


# FIVE, WE RENAME ALL INSTANCES OF THE OLD CATEGORY IN THE CATEGORY INDEX
   open (CATFILE,"$catfile") or &Error ("Could not open $catfile, is it created.  Reason: $!");
   my(@CATS)=<CATFILE>;
   close(CATFILE);
   chomp @CATS;
   $SIZE=@CATS;

   open (CATINDEX,">$catfile") or &Error ("Could not open $catfile, is it created.  Reason: $!");
   if ($useflock) { flock(CATINDEX, 2); }
   for ($i=0;$i<=$SIZE;$i++) {
      $_=$CATS[$i];
      my ($direct, $cnt, $catdate) = split(/\t/, $_);

      /^#/      and next;        # Skip comment Lines.
      /^\s*$/   and next;        # Skip blank lines.

      if ($direct =~ /^$admin_directory\//g or $direct eq $admin_directory) {
         $doodle = $direct;
         $doodle =~ s/^$admin_directory/$new_directory/g;
         print CATINDEX $doodle . "\t" . $cnt . "\t" . $catdate . "\t\n";
      } else {
         print CATINDEX $_ . "\n";
      }
   }

   if ($useflock) { flock(CATINDEX, 8); }
   close(CATINDEX);
   chmod(0777,"$catfile") or &Error ("Could not set permissions on index file, $catfile.  Reason: $!");

# SIX, AND FINALLY, WE RENAME ALL INSTANCES OF THE OLD CATEGORY DESCRIPTIONS
   if (-e $catdesc){
      open (CATFILE,"$catdesc") or &Error ("Could not open $catdesc, is it created.  Reason: $!");
      my(@CATS)=<CATFILE>;
      close(CATFILE);
      chomp @CATS;
      $SIZE=@CATS;

      open (CATINDEX,">$catdesc") or &Error ("Could not open $catdesc, is it created.  Reason: $!");
      if ($useflock) { flock(CATINDEX, 2); }
      for ($i=0;$i<=$SIZE;$i++) {
         $_= $CATS[$i];
         my ($direct, $cnt) = split(/\t/, $_);

         /^#/      and next;        # Skip comment Lines.
         /^\s*$/   and next;        # Skip blank lines.

         if ($direct =~ /^$admin_directory\//g or $direct eq $admin_directory) {
            $doodle = $direct;
            $doodle =~ s/^$admin_directory/$new_directory/g;
            print CATINDEX $doodle . "\t" . $cnt . "\n";
         } else {
            print CATINDEX $_ . "\n";
         }
      }
      if ($useflock) { flock(CATINDEX, 8); }
      close(CATINDEX);
      chmod(0777,"$catdesc") or &Error ("Could not set permissions on file, $catfile.  Reason: $!");
   }
}

###############################################################################
# RENAME
# Renames a category
###############################################################################
sub admin_rename {
   $block_main_cat = 1 if $is_user && !$allow_free_post_access;
   my $admin_title = "Category Renamed";
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }
   my $admin_directory = $FORM{'admin_directory'};

   if ($is_user) {
      if (!$group_cat_ren_per) {
         &Error("Sorry $ifusername, you do not have permission to rename a category.");
      }
      $personal_category_block = 1;
      &compare_cat($admin_directory);
      $cachereload = 1;
   }

   if (!$admin_directory) { &Error ("You must select a Category to Rename."); }
   elsif ($using_picturepost_mod){
      require "$config_directory/post_config.pl";
      if ($main_users_cat eq $admin_directory) {
         &Error("You can not rename this category through your browser. You will need to change the value of \"\$main_users_cat\" in your post_config.pl and then rename the category trough FTP. After that rebuild the index!");
      }
   }

   my $new_name = $FORM{'new_name'};
   if (!$new_name) { &Error ("You must enter a New Category Name."); }

   &refresh_category_cache($admin_directory);

   $new_name =~ s/^\s+//g;              # Trim leading blanks...
   $new_name =~ s/\s+$//g;              # Trim trailing blanks...
   $new_name =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $new_name =~ s/\s+/_/g;              # Change spaces to underscores

   my @admin_directory = split (/\//, $admin_directory);
   my $old_name = pop(@admin_directory);
   my $new_directory = join('/', @admin_directory,$new_name);

   if ($new_directory eq $admin_directory) { &Error("You must enter a new category name."); }

   my $full_old = "$image_directory/$admin_directory";
   my $full_new = "$image_directory/$new_directory";

   &check_dir($new_name, $full_new);

   rename ("$full_old", "$full_new") or &Error("Could not rename category, $from_name.  Reason: $!");

   &six_steps($admin_directory, $new_directory);


   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$new_directory'"};

   my $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td align="center">
               <$fe_admin_font><b>The category <font color="$warning_font_color">$old_name</font> has been renamed <font color="$warning_font_color">$new_directory</font>.<br>
               <$fe_admin_font><b>Please wait while your display is updated.
            </td>
         </tr>
      </table>
   };

&popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# ADD DESCRIPTION
# Interface for adding a category description
###############################################################################
sub describe_category {
   if ($is_user && !$group_cat_desc_per) {
      &Error("Sorry $ifusername, you do not have permission to add a category caption.");
   }
   my $admin_ouptut;
   my $admin_directory = $FORM{'admin_directory'};

   my $admin_title = "Add Category Description";
   my $on_load = qq{onLoad="self.focus()"};
   my $catlist = &get_fe_catlist($admin_directory);
   $admin_directory = $admin_directory_new if $admin_directory_new;
   my $cat_desc;
   my $top_level;

   if (!$catlist_selected) {
      $top_level = qq|<option value="" > - Select Category</option>|;
   }

   if ($is_user && $admin_directory) {
      $skip_error_message = 1;
      &compare_cat($admin_directory);
      if (!$approve_action) {
         print "Location:$imagefolio_redirect_url?admin=describe_category\n\n";
         exit;
      }
   }

   if (-e $catdesc) { 
      open (DESC,"< $catdesc");
      while (<DESC>) {
         chomp;
         next if /^\s*$/; # skip blank lines
         next if /^#/;    # skip comment lines
         push(@desc, $_);
      }
      close(DESC);
      foreach $line (@desc) {
         my ($catname, $catdescription) = split(/\t/, $line);
         $catdescription =~ s/^\s+//g;    # trim leading blanks...
         $catdescription =~ s/\s+$//g;    # trim trailing blanks...
         next if (!$catdescription);      # skip line if no description
         if ($catname eq $admin_directory) { $cat_desc = $catdescription; last; }
      }
   }

   $admin_output = qq{
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="admin_describe">
      $block_main_cat_script2
      <table width="100%" cellpadding="8" cellspacing="8" border="0">
         <tr>
            <td align="center">
               <$fe_admin_small_font><font color="#ffffff"><b>C A T E G O R Y</b></font></font><br>
               <select name="admin_directory" onChange="if(block_main_cat_value){block_main_cat();}if(!skip_forward){window.location='$imagefolio_url?admin=describe_category&admin_directory=' + this[this.selectedIndex].value;}">
               $top_level
               $catlist
               </select>
            </td>
         </tr>
         <tr>
            <td align="center">
               <$fe_admin_small_font><font color="#ffffff"><b>D E S C R I P T I O N</b></font></font><br>
               <textarea name="description" cols="32" rows="4" wrap="virtual">$cat_desc</textarea>
            </td>
         </tr>
         <tr>
            <td align="center"><input type=submit value="Add Description"></td>
         </tr>
      </table>
      </form>
   };
   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# DESCRIBE
# Add description to a category
###############################################################################
sub admin_describe {
   my $admin_title = "Description Added";
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }

   my $admin_directory = $FORM{'admin_directory'};
   if (!$admin_directory) { &Error ("You must select a Category."); }

   if ($is_user) {
      if (!$group_cat_desc_per) {
         &Error("Sorry $ifusername, you do not have permission to add a category caption.");
      }
      &compare_cat($admin_directory);
      $cachereload = 1;
   }


   my $description = $FORM{'description'};

   $catfound = "";
   my @LINES;

   $description =~ s/^\s+//g;              # Trim leading blanks...
   $description =~ s/\s+$//g;              # Trim trailing blanks...
   $description =~ s/\r\n/ /g;             # Change newline to a space.
   $description =~ s/\r//g;                # Remove Windows linefeed character.
   $description =~ s/\n/ /g;               # Change newline to a space.
   $description =~ s/\s+\s+/ /g;           # Change two spaces to one.
   $description =~ s/\s+\s+/ /g;           # Change two spaces to one again.

   if (-e $catdesc) { 
      open (DESC,"<$catdesc");
      while (<DESC>) {
         chomp;
         next if /^\s*$/; # skip blank lines
         next if /^#/;    # skip comment lines
         push(@LINES, $_);
      }
      close(DESC);
   }

   $SIZE = @LINES;

   open (INDEX,">$catdesc") or &Error ("Could not open $catdesc.  Reason: $!");
   if ($useflock) { flock(INDEX, 2); }
   for ($i=0; $i<=$SIZE; $i++) {
      $_ = $LINES[$i];
      my ($catgname, $catgdesc) = split(/\t/, $_);
      if ($catgname eq $admin_directory) {
         $catfound = 1;
         print INDEX $admin_directory . "\t" . $description . "\n";
      } else {
         print INDEX $_ . "\n";
      }
   }

   if (!$catfound) { print INDEX $admin_directory . "\t" . $description . "\n"; }

   if ($useflock) { flock(INDEX, 8); }
   close(INDEX);

   $newcatname = $admin_directory;
   $newcatname =~ s/_/ /g;

   my @admin_directory = split(/\//, $admin_directory);
   pop(@admin_directory);
   my $new_parent = join("/", @admin_directory);


   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$new_parent'"};

   my $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td align="center">
               <$fe_admin_font><font color="#ffffff"><b>The description for<font color="$warning_font_color">$newcatname</font> has been added successfully.<b><br>
               <b>Please wait while your display is updated.</font></font>
            </td>
         </tr>
      </table>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# GET IMAGES
# get the selected images
###############################################################################
sub admin_get_images {

   @admin_images = ();

   if ($FORM{'admin_image2'} && -e "$image_directory/$admin_directory/$FORM{'admin_image2'}") {
      $name_image = $FORM{'admin_image2'};
      $name_image =~ s/^$mypattern//g;
   }
   if ($FORM{'admin_image1'} && -e "$image_directory/$admin_directory/$FORM{'admin_image1'}") {
      $name_image = $FORM{'admin_image1'};
   }

   $email_display_name = $name_image;

   &Error("No Image Selected") if (!$name_image);

   ($newimage) = $name_image =~ m,^(.*)\.\w+$,;

   $fullsize_name = qq|$mypattern_fullsize$newimage.$myextension_fullsize|;
   $data_name     = qq|$newimage.data|;
   $count_name    = qq|$newimage.count|;
   $vote_name     = qq|$newimage.vote|;

   # This is a little more work then just checking if the files exist but it is the only way
   # to guarantee the file names are correct on a win32 server. A win32 server is not case sensitive
   # and image extesions can be displayed in the wrong case. Not important but this just looks better!
   opendir(IMAGEDIR,"$image_directory/$admin_directory")or &Error("Error Reading Directory: $!");
   @files = grep /$newimage/i, readdir IMAGEDIR;
   closedir(IMAGEDIR);

   foreach $file (@files) {
      if (lc($file) eq lc($FORM{'admin_image1'})) {
         push(@admin_images, $file);
         $name_image = $file;
      }
      elsif (lc($file) eq lc($FORM{'admin_image2'})) {
         push(@admin_images, $file);
      }
      elsif (lc($file) eq lc($fullsize_name)) {
         push(@admin_images, $file);
      }
      elsif (lc($file) eq lc($data_name)) {
         push(@admin_images, $file);
      }
      elsif (lc($file) eq lc($count_name)) {
         push(@admin_images, $file);
      }
      elsif (lc($file) eq lc($vote_name)) {
         push(@admin_images, $file);
      }
   }

   foreach $admin_image (@admin_images) {
      if ($admin_image =~ /^$mypattern_fullsize/) {
         $my_admin_fake_image = $admin_image;
         $my_admin_fake_image =~ s/^$mypattern_fullsize/some_secret_code_17_/ig;
         $image_selection .= qq|<input type="hidden" name="admin_image" value="$my_admin_fake_image">|;
      }
      else {
         $image_selection .= qq|<input type="hidden" name="admin_image" value="$admin_image">|;
      }
      if ($is_user) {
         if (lc($admin_image) ne lc($FORM{'admin_image1'}) && lc($admin_image) ne lc($FORM{'admin_image2'})) {
            $skip_admin_image_list = 1;
         }
         else {
            $skip_admin_image_list = 0;
         }
      }
      elsif ($FORM{'admin'} eq 'caption_confirm_image') {
         ($extension) = ($admin_image =~ /\.([^.]+)$/);
         if ((lc($extension) ne 'jpg') or ($admin_image =~ /^$mypattern_fullsize/)) {
            $skip_admin_image_list = 1;
         }
         else {
            $skip_admin_image_list = 0;
         }
      }
      if (!$skip_admin_image_list) {
         ($filesize, $filedate) = (stat("$image_directory/$admin_directory/$admin_image"))[7,9];
         if ($filesize < 1500) {
            $filesize = commify($filesize) . " bytes";
         }
         else { $filesize = int($filesize/1024);
            if ($filesize < 1500) {
               $filesize = commify($filesize) . " Kb";
            }
            else { $filesize = int($filesize/10.24);
               $filesize = ($filesize/100) . " Mb";
            }
         }
         $filedate = unix_to_date($filedate); 
         if (!$is_user) {
            $sp_chars_url = "$imageurl/$admin_directory/$admin_image";
            $sp_chars_url =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;
            $a_href_o = qq|<a href="$sp_chars_url" target="_blank">|;
            $a_href_c = "</a>";
         }
         $admin_image_list .= qq|
            <tr bgcolor="#dddddd">
            <td bgcolor="#eeeeee" width="40%"><$fe_admin_font><b>$a_href_o<font color=black>$admin_image</font>$a_href_c</b></font></td>
            <td width="30%"><$fe_admin_font><font color=black>$filesize</font></font></td>
            <td width="30%"><$fe_admin_font><font color=black>$filedate</font></font></td>
            </tr>
         |;
      }
   }
}
###############################################################################
# DELETE CONFIRM IMAGE
# Confirmation for deleting a image
###############################################################################
sub delete_confirm_image {
   my $admin_ouptut;
   $admin_directory = $FORM{'admin_directory'};

   if ($is_user && !$one_time_access) {
      if (!$group_media_del_per) {
         &Error("Sorry $ifusername, you do not have permission to delete files on this site.");
      }
      @admin_images = ($FORM{'admin_image1'},$FORM{'admin_image2'});
      require "$libpath/iptc.pl";
      %IPTCfields = ();
      foreach $admin_image (@admin_images) {
         ($extension) = ($admin_image =~ /\.([^.]+)$/);
         if (lc($extension) eq 'jpg' && !$custom18_user) {
            $iptc_image = $admin_image;
            $iptc_category = $admin_directory;
            &iptc_create_table;
         }
         $image_selection .= qq|<input type="hidden" name="user_image_list" value="$admin_image">|;
      }
      if (($custom18_user ne $ifusername) or $confirmed_guest) {
         if (!$custom18_user) {
            $custom18_user = "server admin";
         }
         &Error("Sorry $ifusername, you do not have permission to delete files from $custom18_user.");
      }
   }
   elsif ($one_time_access) {
      if (!$FORM{'admin_image1'}) {
         $FORM{'admin_image1'} = $FORM{'admin_image2'};
         $FORM{'admin_image1'} =~ s/^$mypattern//ig;
      }
      $image_selection .= qq|<input type="hidden" name="admin_image1" value="$FORM{'admin_image1'}">|;
      $image_selection .= qq|<input type="hidden" name="user_image_list" value="$FORM{'admin_image1'}">|;
      $image_selection .= qq|<input type="hidden" name="user_image_list" value="$FORM{'admin_image2'}">|;
      $image_selection .= qq|<input type="hidden" name="ota" value="$FORM{'ota'}">|;
   }

   my $admin_title = "Delete File Confirmation";
   my $on_load = qq{onLoad="self.focus()"};

   &admin_get_images;

   if ($FORM{'user_owner'} && $FORM{'user_email'}) {
      &read_user_emails($FORM{'user_owner'});
      if ($custom18_email) {
         $FORM{'user_email'} = $custom18_email;
      }
      $FORM{'user_email'} = &admin_decrypt($FORM{'user_email'}, $FORM{'user_owner'});
      $my_reason = qq|<br><br><font color="#FFFFFF">If you like you can leave a reason for <a href="mailto:$FORM{'user_email'}">$FORM{'user_owner'}</a> why you are deleting these files.<br></font><textarea name="delete_reason" cols="45" rows="2"></textarea>|;
      $my_reason .= qq|<input type="hidden" name="email_display_name" value="$email_display_name"><input type="hidden" name="user_owner" value="$FORM{'user_owner'}"><input type="hidden" name="user_email" value="$FORM{'user_email'}">|;
   }

   $admin_output = qq{
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="admin_delete_image">
      <input type="hidden" name="admin_directory" value="$admin_directory">
      $image_selection
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td nowrap><$fe_admin_font color="#ffffff"><strong>Warning!</strong></font></td>
         </tr>
         <tr>
            <td>
               <$fe_admin_font><b><font color="$warning_font_color">You are about to delete the following files from category '$admin_directory':<br></font></font>
            </td>
         </tr>
         <tr>
            <td>
               <table border=0 cellspacing=1 cellpadding=2 width="100%">
                  <tr bgcolor="#999999">
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Filename</b></font></td>
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Filesize</b></font></td>
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Last Modified</b></font></td>
                  </tr>
                  $admin_image_list
              </table>
            </td>
         </tr>
         <tr>
            <td>
               <$fe_admin_font><b><font color="$warning_font_color">Are you sure you want to do this?</font>$my_reason</b><br></font>
            </td>
         </tr>
         <tr>
            <td align="center"><INPUT TYPE="submit" VALUE="Yes, Delete Files!"></td>
         </tr>
      </table>
      </form>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# DELETE IMAGES
# Deletes selected images
###############################################################################
sub admin_delete_image {
   my $admin_title = "Files Deleted";
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }
   my ($admin_ouptut, $i);
   my $admin_directory = $FORM{'admin_directory'};

   if ($is_user && !$one_time_access) {
      if (!$group_media_del_per) {
         &Error("Sorry $ifusername, you do not have permission to delete files on this site.");
      }

      require "$libpath/iptc.pl";
      %IPTCfields = ();
      @user_image_list = split (/,/, $FORM{'user_image_list'});
      foreach $admin_image (@user_image_list) {
         ($extension) = ($admin_image =~ /\.([^.]+)$/);
         if (lc($extension) eq 'jpg' && !$custom18_user) {
            $iptc_image = $admin_image;
            $iptc_category = $admin_directory;
            &iptc_create_table;
         }
      }
      if (($custom18_user ne $ifusername) or $confirmed_guest) {
         if (!$custom18_user) {
            $custom18_user = "server admin";
         }
         &Error("Sorry $ifusername, you do not have permission to delete files from $custom18_user.");
      }
      $cachereload = 1;

   }
   elsif ($one_time_access) {
      $cachereload = 1;
   }

   &refresh_category_cache($admin_directory);


   @admin_images = split (/,/, $FORM{'admin_image'});

   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$admin_directory'"};

   foreach $admin_image (@admin_images) {
      $admin_image =~ s/some_secret_code_17_/$mypattern_fullsize/ig;
      unlink("$image_directory/$admin_directory/$admin_image") or &Error ("Could not remove $admin_image.  Reason: $!");
      if ($admin_image =~ /^$mypattern/i) {
         &remove_from_category;
      }
      if ($is_user) {
         @user_image_list = split (/,/, $FORM{'user_image_list'});
         foreach $user_image_list (@user_image_list) {
            if (lc($user_image_list) eq lc($admin_image)) {
               $admin_image_list .= qq|$admin_image<br>|;
            }
         }
      }
      else {
         $admin_image_list .= qq|$admin_image<br>|;
      }
   }

   if ($FORM{'delete_reason'}) {
      if ($is_admin) {
         $cachereload = 1;
      }
      my $from_out = $admin_email;
      my $to_out = "$FORM{'user_owner'} <$FORM{'user_email'}>";
      my $cc_out = ();
      if (@picpost_moderators) {
         foreach $picpost_moderator (@picpost_moderators) {
            $my_picpost_moderator .= "$picpost_moderator,";
         }
         $my_picpost_moderator .= $admin_email;
         $bcc_out = $my_picpost_moderator;
      }
      else {
         $bcc_out = $admin_email;
      }
      my $subject_out = "Uploaded file removed! ($FORM{'email_display_name'})";
      my $type_out_0 = 'text/plain';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
      my $data_out_0 = qq|Site: $imagefolio_url\nUser: $FORM{'user_owner'}\nCategory: $FORM{'admin_directory'}\nFile: $FORM{'email_display_name'}\nReason: $FORM{'delete_reason'}\n|;
      my $priority = 0;
      &send_mime_email($from_out, $to_out, $cc_out, $bcc_out, $subject_out, $type_out_0, $data_out_0, $type_out_1, $data_out_1, $type_out_2, $id_out, $path_out, $priority);
   }

   $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td>
               <$fe_admin_font><font color="#ffffff"><b>The following files have been deleted:</b><br><font color="white">$admin_image_list</font>
               <b>Please wait while your display is updated.</b></font></font>
            </td>
         </tr>
      </table>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# DELETE IMAGES
# Deletes selected images
###############################################################################
sub admin_approve_image {
   my $admin_title = "File Approved";
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }
   if (!$one_time_access && !$is_admin) {
      &Error("Sorry, you do not have permission to approve files on this site.");
   }
   my ($admin_ouptut, $i);
   my $admin_directory = $FORM{'admin_directory'};
   my $category = $FORM{'admin_directory'};

   $admin_approve_image = 1;
   @admin_images = ($FORM{'admin_image1'},$FORM{'admin_image2'});

   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',1000)" onUnload="this.opener.location=this.opener.location.href.split('#')[0];"};

   require "$libpath/iptc.pl";
   require "$admindir_directory/iptc_keywords.pl";

   foreach $admin_image (@admin_images) {
      $admin_image_list = "$admin_image" if !$admin_image_list;
      ($extension) = ($admin_image =~ /\.([^.]+)$/);
      if (lc($extension) eq 'jpg') {
         $error_image = $admin_image;
         $createinfo = create Image::IPTCInfo("$image_directory/$admin_directory/$admin_image") or &Error ("Could not open $admin_directory/$error_image.  Reason: $!"); 
         &createinfo_final;
      }
   }

   $cachereload = 1;

if ($FORM{'user_email'} && $FORM{'user_owner'}) {
   &read_user_emails($FORM{'user_owner'});
   if ($custom18_email) {
      $FORM{'user_email'} = $custom18_email;
   }
   $FORM{'user_email'} = &admin_decrypt($FORM{'user_email'}, $FORM{'user_owner'});
   if (!$FORM{'admin_image1'}) {
      $FORM{'admin_image1'} = $FORM{'admin_image2'};
      $FORM{'admin_image1'} =~ s/^$mypattern//ig;
   }
   my $from_out = $admin_email;
   my $to_out = "$FORM{'user_owner'} <$FORM{'user_email'}>";
   my $cc_out = ();
   if (@picpost_moderators) {
      foreach $picpost_moderator (@picpost_moderators) {
         $my_picpost_moderator .= "$picpost_moderator,";
      }
      $my_picpost_moderator .= $admin_email;
      $bcc_out = $my_picpost_moderator;
   }
   else {
      $bcc_out = $admin_email;
   }
   my $subject_out = "Upload Approved! ($FORM{'admin_image1'})";
   my $type_out_0 = 'multipart/related';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
   my $data_out_0 = '';
   my $type_out_1 = 'text/html'; # blank 'text/plain' or 'text/html'
   my $data_out_1 = qq|<body><center><b><$font><font color="$warning_font_color">UPLOAD APPROVED!</font> $admin_image_list can be viewed below.</font></b><br><br><table border="1" cellspacing="1" cellpadding="5">
                         <tr>
                           <td align="center" valign="top" nowrap><$font><a href="$imagefolio_url?action=view&link=$admin_directory&image=$FORM{'admin_image1'}&tt=$FORM{'tt'}"><b>Click here</b><br><br><img src="cid:$FORM{'admin_image1'}" border=0></a><br></font></td>
                         </tr>
                       </table></center></body>|;
   my $id_out = $FORM{'admin_image1'};
   $type_out_2 = 'image/jpeg'; # the type of attachment
   if ($FORM{'admin_image2'}) {
      $path_out = "$image_directory/$admin_directory/$FORM{'admin_image2'}";
   }
   else {
      $default_icon = $extensions{lc($extension)}[4];
      $path_out = "$icons_path/$default_icon";
   }
   my $priority = 0;
   &send_mime_email($from_out, $to_out, $cc_out, $bcc_out, $subject_out, $type_out_0, $data_out_0, $type_out_1, $data_out_1, $type_out_2, $id_out, $path_out, $priority);
}

   $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td>
               <$fe_admin_font><b><font color="white">$admin_image_list</font> has been approved!</b><br><br>
               <b>Please wait while your display is updated.</b></font></font>
            </td>
         </tr>
      </table>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}


###############################################################################
# MOVE CONFIRM IMAGE
# Confirmation for deleting a image
###############################################################################
sub move_confirm_image {
   my $admin_ouptut;
   $admin_directory = $FORM{'admin_directory'};

   if ($is_user) {
      if (!$group_media_mov_per) {
         &Error("Sorry $ifusername, you do not have permission to move files on this site.");
      }
      @admin_images = ($FORM{'admin_image1'},$FORM{'admin_image2'});
      require "$libpath/iptc.pl";
      %IPTCfields = ();
      foreach $admin_image (@admin_images) {
         ($extension) = ($admin_image =~ /\.([^.]+)$/);
         if (lc($extension) eq 'jpg' && !$custom18_user) {
            $iptc_image = $admin_image;
            $iptc_category = $admin_directory;
            &iptc_create_table;
         }
         $image_selection .= qq|<input type="hidden" name="user_image_list" value="$admin_image">|;
      }
      if ((($custom18_user ne $ifusername) or $confirmed_guest) && !$group_media_mod_per) {
         if (!$custom18_user) {
            $custom18_user = "server admin";
         }
         &Error("Sorry $ifusername, you do not have permission to move files from $custom18_user.");
      }
   }

   my $admin_title = "Move File Confirmation";
   my $on_load = qq{onLoad="self.focus()"};

   &admin_get_images;

   if ($COOKIE{'Admin_selected'}) {
      $catlist = &get_fe_catlist($COOKIE{'Admin_selected'});
      $more_info = "<br>(The category you moved to last time is already selected)"
   }
   else {
      $catlist = &get_fe_catlist($admin_directory);
   }
   my $from_admin_directory = $admin_directory;
   $admin_directory = $admin_directory_new if $admin_directory_new;

   $admin_output = qq|
      $block_main_cat_script2
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="admin_move_image">
      <input type="hidden" name="from_admin_directory" value="$from_admin_directory">
      $image_selection
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td nowrap><$fe_admin_font color="#ffffff"><strong>Warning!</strong></font></td>
         </tr>
         <tr>
            <td>
               <$fe_admin_font><b><font color="$warning_font_color">You are about to move the following files from category '$from_admin_directory':<br></font></font>
            </td>
         </tr>
         <tr>
            <td>
               <table border=0 cellspacing=1 cellpadding=2 width="100%">
                  <tr bgcolor="#999999">
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Filename</b></font></td>
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Filesize</b></font></td>
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Last Modified</b></font></td>
                  </tr>
                  $admin_image_list
              </table>
            </td>
         </tr>
         <tr>
            <td align="center">
               <$fe_admin_font><b><font color="$warning_font_color">Please select the destination category:$more_info</font></b><br></font>
               <select name="admin_directory" size=8$block_main_cat_script1>
               $catlist
               </select>
            </td>
         </tr>
         <tr>
            <td align="center"><INPUT TYPE="submit" VALUE="Yes, Move Files!"></td>
         </tr>
      </table>
      </form>
   |;

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# MOVE IMAGES
# Moves selected images
###############################################################################
sub admin_move_image {
   my $admin_title = "Files Moved";
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }
   my ($admin_ouptut, $i);
   my $admin_directory = $FORM{'from_admin_directory'};
   my $new_directory = $FORM{'admin_directory'};

   if ($is_user) {
      if (!$group_media_mov_per) {
         &Error("Sorry $ifusername, you do not have permission to move files on this site.");
      }
      @user_image_list = split (/,/, $FORM{'user_image_list'});
      require "$libpath/iptc.pl";
      %IPTCfields = ();
      foreach $admin_image (@user_image_list) {
         ($extension) = ($admin_image =~ /\.([^.]+)$/);
         if (lc($extension) eq 'jpg' && !$custom18_user) {
            $iptc_image = $admin_image;
            $iptc_category = $admin_directory;
            &iptc_create_table;
         }
      }
      if ((($custom18_user ne $ifusername) or $confirmed_guest) && !$group_media_mod_per) {
         if (!$custom18_user) {
            $custom18_user = "server admin";
         }
         &Error("Sorry $ifusername, you do not have permission to move files from $custom18_user.");
      }

      &compare_cat($new_directory);
      $cachereload = 1;
   }

   if (!$new_directory) {
      &Error("Please choose a destination category.");
   }
   elsif ($admin_directory eq $new_directory) {
      &Error("Please choose a destination category that is different then the source category.");
   }

   &refresh_category_cache($admin_directory);
   &refresh_category_cache($new_directory);


   my @admin_images = split (/,/, $FORM{'admin_image'});
   my @rename_files = ();

   my $on_load = qq{onLoad="document.cookie='Admin_selected=$new_directory; path=/';self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$new_directory'"};

   foreach $admin_image (@admin_images) {
      $admin_image =~ s/some_secret_code_17_/$mypattern_fullsize/ig;

      my $full_old = "$image_directory/$admin_directory/$admin_image";
      my $full_new = "$image_directory/$new_directory/$admin_image";
      $error_full_old = $full_old;
      $error_full_old =~ s/$image_directory\///ig;

      if (-e $full_new) {
         &Error ("Could not move the selected file since a file with the same name already existist.");
      }
      else {
         $dbline = "$full_old\t$full_new";
         if ($admin_image =~ /^$mypattern/i) {
            $dbline .= "\t1";
         }
         push(@rename_files, $dbline);
         if ($is_user) {
            foreach $user_image_list (@user_image_list) {
               if (lc($user_image_list) eq lc($admin_image)) {
                  $admin_image_list .= qq|$admin_image<br>|;
               }
            }
         }
         else {
            $admin_image_list .= qq|$admin_image<br>|;
         }
      }
   }

   foreach $rename_file (@rename_files) {
      my ($full_old, $full_new, $thumb_included) = split(/\t/, $rename_file);
      $error_full_old = $full_old;
      $error_full_old =~ s/$image_directory\///ig;
      rename ("$full_old", "$full_new") or &Error("Could not move, $error_full_old.  Reason: $!");
      if ($thumb_included) {
         ($tempcatage)  = (stat("$full_new"))[9];
         &move_from_category;
      }
   }

   $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td>
               <$fe_admin_font><font color="#ffffff"><b>The following files have been moved to $new_directory:</b><br><font color="white">$admin_image_list</font>
               <b>Please wait while your display is updated.</b></font></font>
            </td>
         </tr>
      </table>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# MOVE CONFIRM IMAGE
# Confirmation for deleting a image
###############################################################################
sub rename_confirm_image {

   $admin_directory = $FORM{'admin_directory'};

   if ($is_user) {
      if (!$group_media_ren_per) {
         &Error("Sorry $ifusername, you do not have permission to rename files on this site.");
      }

      @admin_images = ($FORM{'admin_image1'},$FORM{'admin_image2'});
      require "$libpath/iptc.pl";
      %IPTCfields = ();
      foreach $admin_image (@admin_images) {
         ($extension) = ($admin_image =~ /\.([^.]+)$/);
         if (lc($extension) eq 'jpg' && !$custom18_user) {
            $iptc_image = $admin_image;
            $iptc_category = $admin_directory;
            &iptc_create_table;
         }
         $image_selection .= qq|<input type="hidden" name="user_image_list" value="$admin_image">|;
      }
      if (($custom18_user ne $ifusername) or $confirmed_guest) {
         if (!$custom18_user) {
            $custom18_user = "server admin";
         }
         &Error("Sorry $ifusername, you do not have permission to rename files from $custom18_user.");
      }

   }

   my $admin_ouptut;
   my $admin_title = "Rename File Confirmation";
   my $on_load = qq{onLoad="self.focus()"};

   &admin_get_images;

   $admin_output = qq{
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="admin_rename_image">
      <input type="hidden" name="admin_directory" value="$admin_directory">
      $image_selection
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td nowrap><$fe_admin_font color="#ffffff"><strong>Warning!</strong></font></td>
         </tr>
         <tr>
            <td>
               <$fe_admin_font><b><font color="$warning_font_color">You are about to rename the following files from category '$admin_directory':<br></font></font>
            </td>
         </tr>
         <tr>
            <td>
               <table border=0 cellspacing=1 cellpadding=2 width="100%">
                  <tr bgcolor="#999999">
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Filename</b></font></td>
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Filesize</b></font></td>
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Last Modified</b></font></td>
                  </tr>
                  $admin_image_list
              </table>
            </td>
         </tr>
         <tr>
            <td>
               <$fe_admin_font><b><font color="$warning_font_color">Please enter the new name without the extension:</font></b><br></font>
               <input type="text" name="new_name" size="35" value="$newimage">
            </td>
         </tr>
         <tr>
            <td align="center"><INPUT TYPE="submit" VALUE="Yes, Rename Files!"></td>
         </tr>
      </table>
      </form>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# RENAME IMAGES
# Renames selected images
###############################################################################
sub admin_rename_image {
   my $admin_title = "Files Renamed";
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }
   my ($admin_ouptut, $i);
   my $admin_directory = $FORM{'admin_directory'};

   my $new_name = $FORM{'new_name'};
   $new_name =~ s/ /_/g;
   $new_name =~ s/\.//g;

   if ($new_name =~ /[$deny_chars]/i) {
      &Error("Invalid characters in file name '$new_name'. A file name cannot contain any of the following characters:<br> $deny_characters");
   }

   @admin_images = split (/,/, $FORM{'admin_image'});
   my ($old_name) = @admin_images[0] =~ m,^(.*)\.\w+$,;
   $old_name =~ s/some_secret_code_17_/$mypattern_fullsize/ig;
   $old_name =~ s/^$mypattern//g;
   $old_name =~ s/^$mypattern_fullsize//g;
   my @rename_files = ();

   if ($is_user) {
      if (!$group_media_ren_per) {
         &Error("Sorry $ifusername, you do not have permission to rename files on this site.");
      }

      require "$libpath/iptc.pl";
      %IPTCfields = ();
      @user_image_list = split (/,/, $FORM{'user_image_list'});
      foreach $admin_image (@user_image_list) {
         ($extension) = ($admin_image =~ /\.([^.]+)$/);
         if (lc($extension) eq 'jpg' && !$custom18_user) {
            $iptc_image = $admin_image;
            $iptc_category = $admin_directory;
            &iptc_create_table;
         }
      }
      if (($custom18_user ne $ifusername) or $confirmed_guest) {
         if (!$custom18_user) {
            $custom18_user = "server admin";
         }
         &Error("Sorry $ifusername, you do not have permission to rename files from $custom18_user.");
      }
      $cachereload = 1;

   }

   &refresh_category_cache($admin_directory);

   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)" onUnload="this.opener.location='$imagefolio_url?direct=$admin_directory'"};

   foreach $admin_image (@admin_images) {
      $admin_image =~ s/some_secret_code_17_/$mypattern_fullsize/ig;

      $new_total_name = $admin_image;
      $new_total_name =~ s/$old_name/$new_name/g;

      my $full_old = qq|$image_directory/$admin_directory/$admin_image|;
      my $full_new = qq|$image_directory/$admin_directory/$new_total_name|;

      if (-e $full_new) {
         &Error ("Could not rename the selected files since $new_total_name already existist.");
      }
      else {
         my $dbline = "$full_old\t$full_new";
         push(@rename_files, $dbline);
         if ($is_user) {
            foreach $user_image_list (@user_image_list) {
               if (lc($user_image_list) eq lc($admin_image)) {
                  $admin_image_list .= qq|$new_total_name<br>|;
               }
            }
         }
         else {
            $admin_image_list .= qq|$new_total_name<br>|;
         }
      }
   }

   foreach $rename_file (@rename_files) {
      my ($full_old, $full_new) = split(/\t/, $rename_file);
      rename ("$full_old", "$full_new") or &Error("Could not rename, $full_old.  Reason: $!");
   }



   $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td>
               <$fe_admin_font><font color="#ffffff"><b>The following files have been renamed to:</b><br><font color="white">$admin_image_list</font>
               <b>Please wait while your display is updated.</b></font></font>
            </td>
         </tr>
      </table>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# CAPTION CONFIRM IMAGE
# Confirmation for captioning a image
###############################################################################
sub caption_confirm_image {

   $admin_directory = $FORM{'admin_directory'};

   if ($is_user) {
      if (!$group_media_desc_per) {
         &Error("Sorry $ifusername, you do not have permission to add captions to files on this site.");
      }

      @admin_images = ($FORM{'admin_image1'},$FORM{'admin_image2'});
      require "$libpath/iptc.pl";
      %IPTCfields_temp = %IPTCfields;
      %IPTCfields = ();
      foreach $admin_image (@admin_images) {
         ($extension) = ($admin_image =~ /\.([^.]+)$/);
         if (lc($extension) eq 'jpg' && !$custom18_user) {
            $iptc_image = $admin_image;
            $iptc_category = $admin_directory;
            &iptc_create_table;
         }
         $image_selection .= qq|<input type="hidden" name="user_image_list" value="$admin_image">|;
      }
      if ((($custom18_user ne $ifusername) or ($confirmed_guest && !$FORM{'from_ul'})) && !$group_media_mod_per) {
         if (!$custom18_user) {
            $custom18_user = "server admin";
         }
         &Error("Sorry $ifusername, you do not have permission to add captions to files from $custom18_user.");
      }
      %IPTCfields = %IPTCfields_temp;

   }

   my $admin_ouptut;
   my $admin_title = "Modify File Info";
   my $on_load = qq{onLoad="self.focus()"};

   &admin_get_images;

   require "$admindir_directory/iptc_keywords.pl";
   &get_keyform;

   if ($star_note) {
      $star_note = qq|<$fe_admin_small_font color="$warning_font_color">&nbsp;* <font color=white>Custom caption field set through the configuration.</font></font>|;
   }

   $admin_output = qq{
      <form method="get" action="$imagefolio_url">
      <input type="hidden" name="admin" value="admin_caption_image">
      <input type="hidden" name="admin_directory" value="$admin_directory">
      <input type="hidden" name="from_ul" value="$FORM{'from_ul'}">
      $image_selection
      <table border=0 cellpadding="4" cellspacing="" width="100%">
         <tr>
            <td>
               <table border=0 cellpadding="2" cellspacing="1" width="100%">
                  <tr>
                     <td colspan=3>
                        <$fe_admin_small_font color="$warning_font_color">
                        1) Captions are compatible with the <a href="$if_images_directory/iptc.html" target="_blank"><font color="$warning_font_color">IPTC</font></a> standard.<br>
                        2) Caption fields/settings can be added/removed/modified though config.pl.<br>
                        3) Captions will be added to the following JPG files:<br></font>
                     </td>
                  </tr>
                  <tr bgcolor="#999999">
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Filename</b></font></td>
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Filesize</b></font></td>
                     <td nowrap><$fe_admin_font color="#ffffff"><b>Last Modified</b></font></td>
                  </tr>
                  $admin_image_list
               </table>
            </td>
         </tr>
      </table>
      $keyform
      $star_note
      <br><br><div align="center"><INPUT TYPE="submit" VALUE="Yes, Add File Info!"></div>
      </form>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# CAPTION IMAGES
# Add captions to selected images
###############################################################################
sub admin_caption_image {
   my $admin_title = "File Info results";
   if ($admin_demo_mode) {
      &popup_display($admin_demo_html, $admin_title);
   }
   if ($is_user) {
      if (!$group_media_desc_per) {
         &Error("Sorry $ifusername, you do not have permission to add captions to files on this site.");
      }
   }

   $admin_directory = $FORM{'admin_directory'};
   my ($admin_ouptut, $i);

   @admin_images = split (/,/, $FORM{'admin_image'});

#   my $on_load = qq{onLoad="self.focus();" onUnload="this.opener.location='$imagefolio_url?direct=$admin_directory'"};
   my $on_load = qq{onLoad="self.focus();" onUnload="this.opener.location=this.opener.location.href.split('#')[0];"};

   require "$admindir_directory/iptc_keywords.pl";
   &keywords_final;
   $iptc_table_width           = qq|width="100%"|;
   &iptc_create_table;

   if ($is_user) {
      $admin_image_list = ();
      @user_image_list = split (/,/, $FORM{'user_image_list'});
      foreach $user_image_list (@user_image_list) {
         $admin_image_list .= qq|$user_image_list<br>|;
      }
      $cachereload = 1;
   }

   $admin_output = qq{
      <table width="100%" cellpadding="8" cellspacing="10" border="0">
         <tr>
            <td>
               <$fe_admin_font><font color="#ffffff"><b>Caption data saved successfully for:</b><br><font color="white">$admin_image_list</font>
               <b>This is the result:</b><br></font><$fe_admin_small_font>(The administrator needs to rebuild the index before the keywords are searchable)</font></font><br>
            </td>
         </tr>
         <tr>
            <td align=center>
               $iptc_table
            </td>
         </tr>
      </table>
      <div align="center">
         <INPUT TYPE="button" VALUE="Modify File Info" onClick="history.go(-1)">
         <INPUT TYPE="button" VALUE="Close Window" onClick="self.close()">
      </div>
   };

   &popup_display($admin_output, $admin_title, $on_load);
}

###############################################################################
# CREATE IMAGES TOOLS
# Creates the front end images under the thumbnails
###############################################################################
sub create_image_tools {
   if ($path) {
      $current = "&admin_directory=$path";
   }
   elsif ($FORM{'link'}) {
      $current = "&admin_directory=$FORM{'link'}";
   }

   $current .= "&admin_image1=$admin_image1"; #preview image
   $current .= "&admin_image2=$admin_image2"; #thumbnail image

   ($extension1) = ($admin_image1 =~ /\.([^.]+)$/);
   ($extension2) = ($admin_image2 =~ /\.([^.]+)$/);

   $create_image_tools = "";

   if ($use_textlinks) {
      $create_image_tools = qq|<table border=0 cellspacing=0 cellpadding=2><tr><td align=center nowrap bgcolor="#ffffcc"><span style="color: black"><font size=1 face="arial,helvetica">\||;
      if ($desc_per eq 'Yes') {
         $create_image_tools .= qq| <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=rename_confirm_image$current','width=500,height=500,scrollbars=no');" class=textnav onclick="setHref();">rename</a> \||;
         if ((lc($extension1) eq 'jpg' or lc($extension2) eq 'jpg')) {
            $create_image_tools .= qq| <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=caption_confirm_image$current','width=500,height=540,scrollbars=yes');" class=textnav onclick="setHref();">info</a> \||;
         }
      }
      if ($delcat_per eq 'Yes') {
         $create_image_tools .= qq| <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=delete_confirm_image$current','width=500,height=500,scrollbars=no');" class=textnav onclick="setHref();">delete</a> \||;
         $create_image_tools .= qq| <a style="color: black" href="javascript:adminPopup('$imagefolio_url?admin=move_confirm_image$current','width=500,height=540,scrollbars=yes');" class=textnav onclick="setHref();">move</a> \||;
      }
      if ($upload_per eq 'Yes' && $delcat_per eq 'Yes') {
         #$create_image_tools .= qq| <a href="javascript:adminPopup('$imagefolio_url?admin=replace_media$current','width=500,height=540,scrollbars=yes')" class=textnav>replace</a> \||;
      }
      $create_image_tools .= "</font></span></td></tr></table>";
   }
   else {
      if ($desc_per eq 'Yes') {
         $create_image_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=rename_confirm_image$current','width=500,height=500,scrollbars=no');" onclick="setHref();"><img src="$if_images_directory/pic_rename.$ButtonExt" border=0 alt="Rename" title="Rename"></a> |;
         if ((lc($extension1) eq 'jpg' or lc($extension2) eq 'jpg')) {
            $create_image_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=caption_confirm_image$current','width=500,height=540,scrollbars=yes');" onclick="setHref();"><img src="$if_images_directory/pic_caption.$ButtonExt" border=0 alt="Caption" title="Caption"></a> |;
         }
      }
      if ($delcat_per eq 'Yes') {
         $create_image_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=delete_confirm_image$current','width=500,height=500,scrollbars=no');" onclick="setHref();"><img src="$if_images_directory/pic_delete.$ButtonExt" border=0 alt="Delete" title="Delete"></a> |;
         $create_image_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=move_confirm_image$current','width=500,height=540,scrollbars=yes');" onclick="setHref();"><img src="$if_images_directory/pic_move.$ButtonExt" border=0 alt="Move" title="Move"></a> |;
      }
      if ($upload_per eq 'Yes' && $delcat_per eq 'Yes') {
         #$create_image_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=replace_media$current','width=500,height=540,scrollbars=yes')"><img src="$if_images_directory/pic_replace.$ButtonExt" border="0" alt="Replace" title="Replace"></a> |;
      }
   }

   return $create_image_tools;
}

###############################################################################
# REMOVE FROM CATEGORY
###############################################################################
sub remove_from_category {

   open (CATFILE, "$catfile");
   my(@catfiledata)=<CATFILE>;
   close(CATFILE);

   foreach $catfiledata (@catfiledata) {
      ($catpath, $catcount, $catage) = split(/\t/, $catfiledata);
      if ($catpath eq $FORM{'admin_directory'}){
         if ($catcount < 2) {
            $catcount = 0;
         }
         else {
            $catcount = $catcount - 1;
         }
         $catlist .= $catpath . "\t" . $catcount . "\t" . $catage . "\t\n";
      }
      else {
         $catlist .= $catfiledata;
      }
   }

   open(CATFILE, ">$catfile");
   if ($useflock) { flock(CATFILE, 2); }
   print CATFILE $catlist;
   if ($useflock) { flock(CATFILE, 8); }
   close(CATFILE);

}

###############################################################################
# MOVE FROM CATEGORY
###############################################################################
sub move_from_category {

   open (CATFILE, "$catfile");
   my(@catfiledata)=<CATFILE>;
   close(CATFILE);

   my $catlist =();

   foreach $catfiledata (@catfiledata) {
      ($catpath, $catcount, $catage) = split(/\t/, $catfiledata);
      if ($catpath eq $FORM{'admin_directory'}){
         if ($catcount < 2) {
            $catcount = 0;
         }
         else {
            $catcount = $catcount - 1;
         }
         $catlist .= $catpath . "\t" . $catcount . "\t" . $catage . "\t\n";
      }
      elsif ($catpath eq $FORM{'to_admin_directory'}){
         $catcount++;
         if ($tempcatage > $catage) {
            $catage = $tempcatage;
         }
         $catlist .= $catpath . "\t" . $catcount . "\t" . $catage . "\t\n";
      }
      else {
         $catlist .= $catfiledata;
      }
   }

   open(CATFILE, ">$catfile");
   if ($useflock) { flock(CATFILE, 2); }
   print CATFILE $catlist;
   if ($useflock) { flock(CATFILE, 8); }
   close(CATFILE);

}

sub rebuild_index_request_log {
   open (FILE,">>$data_directory/index_request.tmp");
   print FILE "1\n";
   close(FILE);
   chmod(0777,"$data_directory/index_request.tmp");

   open (FILE,"$data_directory/index_request.tmp");
   (@index_request)=<FILE>;
   close(FILE);
   $index_requests=@index_request;

   if ($index_requests >= $index_requests_notification) {
      $request_email = ($index_requests / $index_requests_notification);
      ($request_email, $deci) = split(/\./,$request_email);
      if (!$deci) {
         &send_index_request_email;
      }
   }
}

sub send_index_request_email {
   $my_current_time = &admin_encrypt($current_time, $secret_key);
   my $from_out = $admin_email;
   my $to_out = $admin_email;
   my $cc_out = ();
   if (@picpost_moderators) {
      foreach $picpost_moderator (@picpost_moderators) {
         $my_picpost_moderator .= "$picpost_moderator,";
      }
      $my_picpost_moderator =~ s/,$//g;
      $bcc_out = $my_picpost_moderator;
   }
   my $subject_out = "Rebuild Index Request";
   my $type_out_0 = 'text/plain';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
   my $data_out_0 = qq|Site: $imagefolio_url\n\Files have been added/moved/deleted $index_requests times without the index being rebuild. It is suggest that you rebuild the index now by clicking here:\n$buildurl&mct=$my_current_time\n\nNote: this direct link will expire in 24 hours.\n|;
   my $priority = 1;
   &send_mime_email($from_out, $to_out, $cc_out, $bcc_out, $subject_out, $type_out_0, $data_out_0, $type_out_1, $data_out_1, $type_out_2, $id_out, $path_out, $priority);
}

sub refresh_category_cache {
   my $input = shift;
   if ($input) {
      $input =~ s/[^0-9a-zA-Z\_]/~/g;
      if (-e "$cache_directory/searches/direct~$input") {
         unlink("$cache_directory/searches/direct~$input");
      }
      if (-e "$cache_directory/searches/direct~$input~sort5") {
         unlink("$cache_directory/searches/direct~$input~sort5");
      }
      if (-e "$cache_directory/searches/link~$input") {
         unlink("$cache_directory/searches/link~$input");
      }
      if (-e "$cache_directory/searches/link~$input~sort5") {
         unlink("$cache_directory/searches/link~$input~sort5");
      }
   }
}

###############################################################################
# BATCH ACTION
###############################################################################
sub batch_action {

   my $admin_ouptut;
   my $admin_directory = $FORM{'admin_directory'};

   my $admin_title = "Batch Action";
   my $on_load = qq{onLoad="self.focus()"};
   my $catlist = &get_fe_catlist($admin_directory);
   $admin_directory = $admin_directory_new if $admin_directory_new;
   my $cat_desc;
   my $top_level;

   if (!$catlist_selected) {
      $top_level = qq|<option value="" > - Select Category</option>|;
   }

   my $lb_cnt = 0;
   my @lb_x = ();

   foreach (@LIGHTBOXES) {
      next if !$_;
      my ($lb_name, $lb_content) = split(/\t/, $_);
      $lb_name = "$untitled_lightbox" if !$lb_name;
      push (@lb_x, "$lb_name\t$lb_cnt");
      $lb_cnt++;
   }

   @lb_x = sort { lc($a) cmp lc($b) } @lb_x;
   my $ligbox_list = ();

   foreach (@lb_x) {
      my ($lb_name, $lb_location) = split(/\t/, $_);
      next if $lb_name =~ /^share\=/;
      ($lb_name) = split(/\|/, $lb_name);
      my $selected = " selected" unless $lb_location;
      $ligbox_list .= qq|<option value="$lb_location" $selected>$lb_name|;
   }

   my $batch_lightbox_checked = " checked" if $FORM{'batch_lbview'} or $FORM{'batch_lightbox'};

   if ($is_admin) {
      $upload_session_file = "$sessions_dir/admin.$COOKIE{'IF_UID'}.upload";
   }
   elsif (!$confirmed_guest){
      $upload_session_file = "$sessions_dir/$ifusername/upload.user";
   }
   else {
      $upload_session_file = "$sessions_dir/$user_session_id.upload";
   }
   if (-e $upload_session_file) {
      my $batch_upload_checked = " checked" if $FORM{'batch_upload'};
      $batch_upload_option = qq|
                  <tr>
                     <td align=right><input type="radio" name="batch_source" value="Upload"$batch_upload_checked></td>
                     <td colspan=2><$fe_admin_small_font><font color="#ffffff">Last batch upload</font></font></td>
                  </tr>|;
   }

   if ($is_admin) {
      $search_session_file = "$sessions_dir/admin.$COOKIE{'IF_UID'}.search";
   }
   elsif (!$confirmed_guest){
      $search_session_file = "$sessions_dir/$ifusername/search.user";
   }
   else {
      $search_session_file = "$sessions_dir/$user_session_id.search";
   }
   open (CACHE, "$search_session_file");
   my $cachefile = do { local $/, <CACHE> };
   close CACHE;
   if (-e "$cache_directory/searches/$cachefile") {
      my $batch_search_checked = " checked" if $FORM{'batch_search'};
      $batch_search_option = qq|
                  <tr>
                     <td align=right><input type="radio" name="batch_source" value="Search"$batch_search_checked></td>
                     <td colspan=2><$fe_admin_small_font><font color="#ffffff">Last search result</font></font></td>
                  </tr>|;
   }



   $admin_output = qq|
      <form method="POST" action="$imagefolio_url">
      <input type="hidden" name="admin" value="batch_action_do">
      <input type="hidden" name="batch_type" value="IPTC">
      $block_main_cat_script2
      <table width="100%" cellpadding="8" cellspacing="8" border="0">
         <tr>
            <td align="center">
               <table border=0 cellspacing=0 cellpadding=6 width="100%">
                  <!--<tr>
                     <td colspan=3 align=center bgcolor="#666666"><$fe_admin_small_font><font color="#ffffff"><b>A C T I O N&nbsp;&nbsp;&nbsp;T Y P E</b></font></font><td>
                  </tr>
                  <tr>
                     <td align=right><input type="radio" name="batch_type" value="IPTC" checked></td>
                     <td colspan=2><$fe_admin_small_font><font color="#ffffff">Edit IPTC</font></font></td>
                  </tr>
                  <tr>
                     <td align=right><input type="radio" name="batch_type" value="Move"></td>
                     <td colspan=2><$fe_admin_small_font><font color="#ffffff">Move</font></font></td>
                  </tr>
                  <tr>
                     <td align=right><input type="radio" name="batch_type" value="Delete"></td>
                     <td colspan=2><$fe_admin_small_font><font color="#ffffff">Delete</font></font></td>
                  </tr>-->
                  <tr>
                     <td colspan=3 align=center bgcolor="#666666"><$fe_admin_small_font><font color="#ffffff"><b>S O U R C E</b></font></font><td>
                  </tr>
                  <tr>
                     <td align=right style="padding-bottom:0px;"><input type="radio" name="batch_source" value="Category" checked></td>
                     <td style="padding-bottom:0px;"><$fe_admin_small_font><font color="#ffffff">Category: </font></font></td>
                     <td style="padding-bottom:0px;"><select name="batch_directory"$block_main_cat_script1>
                     $top_level
                     $catlist
                     </select></td>
                  </tr>
                  <tr>
                     <td colspan=2 style="padding-top:0px;"></td>
                     <td style="padding-top:0px;"><input type="checkbox" name="subcategory" value="1" checked><$fe_admin_small_font><font color="#ffffff"> Include subcategories</font></font></td>
                  </tr>
                  <tr>
                     <td align=right><input type="radio" name="batch_source" value="Lightbox"$batch_lightbox_checked></td>
                     <td><$fe_admin_small_font><font color="#ffffff">$lightbox_name: </font></font></td>
                     <td><select name="batch_lightbox">
                     $ligbox_list
                     </select></td>
                  </tr>
                  $batch_search_option
                  $batch_upload_option
               </table>
               <br>
               <br>
               <input type=submit value="Next Step">
            </td>
         </tr>
      </table>
      </form>|;


   &popup_display($admin_output, $admin_title, $on_load);

}

###############################################################################
# BATCH ACTION DO
###############################################################################
sub batch_action_do {

   my $admin_ouptut;



   my $admin_title = "Batch $FORM{'batch_type'} Action";
   my $on_load = qq{onLoad="self.focus()"};
   my $filecount = ();
   my @thumbs = ();
   my $submit_button = ();
   my $batch_text = ();
   my $source_text = $FORM{'batch_source'};
   my $help_text = ();


   if ($FORM{'batch_source'} eq 'Category') {
      if ($FORM{'batch_directory'}) {
         if ($FORM{'subcategory'}) {
            my @batchdirectories = ("$image_directory/$FORM{'batch_directory'}");
            my $batchtotaldir = 1;
            for ($i=0; $i<$batchtotaldir; $i++) {
               $batchdirectory = @batchdirectories[$i];
               opendir(DIR,$batchdirectory);
               my @batchlistings = readdir(DIR);
               closedir(DIR);

               foreach my $batchlisting (@batchlistings) {
                  next if $batchlisting =~ /^\.\.?$/;
                  my $batchfullpath = "$batchdirectory/$batchlisting";
                  if (-d $batchfullpath) {
                     $batchtotaldir++;
                     push(@batchdirectories,$batchfullpath);
                  }
                  elsif ($batchlisting =~ /^$mypattern/) {
                     $batchfullpath =~ s/^$image_directory\///ig;
                     push(@thumbs, "$batchfullpath");
                  }
               }
            }
            $source_text .= " + Subcategories";
         }
         else {
            opendir (THUMBS, "$image_directory/$FORM{'batch_directory'}");
            my @files = grep { /^$mypattern/ } readdir(THUMBS);
            closedir (THUMBS);
            foreach (@files) {
               push(@thumbs, "$FORM{'batch_directory'}/$_");
            }
         }
         $filecount = @thumbs;
         $source_detail = qq|"$FORM{'batch_directory'}", $filecount files|;
         $thumbs = join('::', @thumbs);
      }
      else {
         &Error("Please select a category");
      }
   }
   elsif ($FORM{'batch_source'} eq 'Lightbox') {
      my ($lb_name, $lb_content) = split(/\t/, $LIGHTBOXES[$FORM{'batch_lightbox'}]);
      ($lb_name) = split(/\|/, $lb_name);
      $lb_name = "$untitled_lightbox" if !$lb_name;
      my @lb_cnt = $lb_content =~ /\[(.*?)\]/g;
      foreach (@lb_cnt) {
         my ($lbp, $lbi, $lbe) = split(/\|/, $_);
         push(@thumbs, "$lbp/$mypattern$lbi.jpg") if -e "$image_directory/$lbp/$mypattern$lbi.jpg";
      }
      $filecount = @thumbs;
      $source_detail = qq|"$lb_name", $filecount files|;
      $thumbs = join('::', @thumbs);
   }
   elsif ($FORM{'batch_source'} eq 'Search') {
      if ($is_admin) {
         $search_session_file = "$sessions_dir/admin.$COOKIE{'IF_UID'}.search";
      }
      elsif (!$confirmed_guest){
         $search_session_file = "$sessions_dir/$ifusername/search.user";
      }
      else {
         $search_session_file = "$sessions_dir/$user_session_id.search";
      }
      my ($saved_time) = (stat("$image_directory/$thispath/$name"))[9];
      open (CACHE, "$search_session_file");
      my $cachefile = do { local $/, <CACHE> };
      close CACHE;
      open (FILE,"$cache_directory/searches/$cachefile");
      my (@RESULTS)=<FILE>;
      close(FILE);
      chomp @RESULTS;
      my ($sec, $min, $hour, $day, $month, $year) = localtime($saved_time);
      if ($eu_date_format) {
         $source_detail = sprintf "%02d/%02d/%04d", $day, eval($month + 1), eval($year + 1900);
      }
      else {
         $source_detail = sprintf "%02d/%02d/%04d", eval($month + 1), $day, eval($year + 1900);
      }
      foreach (@RESULTS) {
         my ($blah, $searchi, $searchp) = split(/\|/, $_);
         push(@thumbs, "$searchp/$searchi") if -e "$image_directory/$searchp/$searchi";
      }
      $filecount = @RESULTS;
      $source_detail = qq|"$source_detail", $filecount files|;
      $thumbs = join('::', @thumbs);
   }
   elsif ($FORM{'batch_source'} eq 'Upload') {
      if ($is_admin) {
         $upload_session_file = "$sessions_dir/admin.$COOKIE{'IF_UID'}.upload";
      }
      elsif (!$confirmed_guest){
         $upload_session_file = "$sessions_dir/$ifusername/upload.user";
      }
      else {
         $upload_session_file = "$sessions_dir/$user_session_id.upload";
      }
      open (FILE,"$upload_session_file");
      my (@UPLOADS)=<FILE>;
      close(FILE);
      chomp @UPLOADS;
      my ($saved_id, $saved_time, $saved_files) = split(/\t/, $UPLOADS[0]);

      my ($sec, $min, $hour, $day, $month, $year) = localtime($saved_time);
      if ($eu_date_format) {
         $source_detail = sprintf "%02d/%02d/%04d", $day, eval($month + 1), eval($year + 1900);
      }
      else {
         $source_detail = sprintf "%02d/%02d/%04d", eval($month + 1), $day, eval($year + 1900);
      }

      my @upload_cnt = $saved_files =~ /\[(.*?)\]/g;
      foreach (@upload_cnt) {
         my ($uploadp, $iploadi) = split(/\|/, $_);
         push(@thumbs, "$uploadp/$mypattern$iploadi.jpg") if -e "$image_directory/$uploadp/$mypattern$iploadi.jpg";
      }
      $filecount = @upload_cnt;
      $source_detail = qq|"$source_detail", $filecount files|;
      $thumbs = join('::', @thumbs);
   }

   &Error ("We could not find a file in your selection!") unless $filecount > 0;

   if ($FORM{'batch_type'} eq 'IPTC') {
      require "$admindir_directory/iptc_keywords.pl";
      &get_keyform;
      $batch_text = $keyform;
      $submit_button = "Add IPTC to $filecount files";
      if ($star_note) {
         $star_note = qq|<$fe_admin_small_font color="$warning_font_color">&nbsp;* <font color=white>Custom caption field set through the configuration.</font></font>|;
      }
      $help_text = qq|
         <tr>
            <td><table cellspacing=0 cellpadding=2>
               <tr>
                  <td><input type=button value="Merge" class="type_merge"></td>
                  <td><$fe_admin_small_font><font color="#ffffff"> Input value will merge with existing value.</td>
               </tr>
               <tr>
                  <td><input type=button value="Replace" class="type_replace"></td>
                  <td><$fe_admin_small_font><font color="#ffffff"> Input value will replace existing value.<br>(An empty field will delete existing value.)</font></font><td>
               </tr>
            </table></td>
         </tr>|;
   }
   elsif ($FORM{'batch_type'} eq 'Move') {
   }
   elsif ($FORM{'batch_type'} eq 'Delete') {
   }

   $admin_output = qq|
      <style type="text/css">
      <!--
      .type_merge {
      font-family: helvetica,verdana,arial;
      font-size:11px;
      color:#ffffff;
      background-color:green;
      cursor: hand;
      width: 60px;
      }
      .type_replace {
      font-family: helvetica,verdana,arial;
      font-size:11px;
      color:#ffffff;
      background-color:blue;
      cursor: hand;
      width: 60px;
      }
      -->
      </style>
      <form method="POST" action="$imagefolio_url">
      <input type="hidden" name="admin" value="batch_action_run">
      <input type="hidden" name="thumbs" value="$thumbs">
      <input type="hidden" name="batch_source" value="$FORM{'batch_source'}">
      <input type="hidden" name="batch_directory" value="$FORM{'batch_directory'}">
      <input type="hidden" name="batch_type" value="$FORM{'batch_type'}">
      <table width="100%" cellpadding="0" cellspacing="0" border="0">
         <tr>
            <td>
               <table border=0 cellspacing=0 cellpadding=4 width="100%">
                  <tr>
                     <td><$fe_admin_small_font><font color="#ffffff">Source: $source_text ($source_detail)</font></font><td>
                  </tr>
                  $help_text
                </table>
               $batch_text
               $star_note
               <br>
               <br>
               <center><input type=submit value="$submit_button"></center>
            </td>
         </tr>
      </table>
      </form>|;


   &popup_display($admin_output, $admin_title, $on_load);

}

###############################################################################
# BATCH ACTION RUN
###############################################################################
sub batch_action_run {

   &Error("No access") unless $is_admin;

   my $admin_ouptut;

   my $admin_title = "Batch $FORM{'batch_type'} Action";
   my $on_load = qq{onLoad="self.focus();setTimeout('self.close()',2000)"};

   my @thumbs = split(/\::/, $FORM{'thumbs'});

   $admin_output = qq|
      <table width="100%" cellpadding="8" cellspacing="8" border="0">
         <tr>
            <td align="center"><div id="progress_header"></div><td>
         </tr>
         <tr>
            <td align="center"><div id="progress_content"></div><td>
         </tr>
      </table>|;

   $admin_jscript .= qq|<script language="JavaScript">function getIFobj(name){if(document.getElementById){if(document.getElementById(name)){this.obj=document.getElementById(name);this.style=document.getElementById(name).style;}else{this.obj="";this.style="";}}else if(document.all){if(document.all[name]){this.obj=document.all[name];this.style=document.all[name].style;}else{this.obj="";this.style="";}}else{this.obj="";this.style="";}}</script>|;

   $directory_tree = &build_directory_tree($admin_directory);

   open (TEMPLATE,"$admin_popup_template") or &Error("Could not open template $admin_popup_template.  Reason $!");
   while (<TEMPLATE>) {
      if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) {
      $template .= &ssi_include($2);
      } elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) {
         $template .= &ssi_exec_include($2);
      } else {
         $template .= $_;
      }
   }
   close(TEMPLATE);

   $template =~ s/%%%ON_LOAD%%%/%%%ON_LOAD%%%\> \<form name=\"progressform\"/ig;
   $template =~ s/\<\/body\>//ig;
   $template =~ s/\<\/html\>//ig;

   $template =~ s/%%%DIRECTORY_TREE%%%/$directory_tree/ig;
   $template =~ s/%%%ADMIN_OUTPUT%%%/$admin_output$select_options/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $template =~ s/%%%ADMIN_TITLE%%%/$admin_title/ig;
   $template =~ s/%%%ON_LOAD%%%/$on_load/ig;
   if ($cachereload) {
      $admin_jscript .= qq|<script language="javascript">document.cookie="cachereload=2\|1; path=/";</script>|;
      if ($index_requests_notification) {
         &rebuild_index_request_log;
      }
   }
   $template =~ s/%%%ADMIN_JSCRIPT%%%/$admin_jscript/ig;

   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;

   if ($is_admin) {
      $template =~ s/%%%ADMIN_MODE%%%/ &nbsp;&nbsp;***Admin Mode***/ig;
   }

   $template =~ s/%%%(.*)%%%//ig;

   print "Content-type: text/html\n\n";
   print $template;

   my $stepsize = 100 / @thumbs;
   my $stepcnt = 0;
   my $stepcurrent = 0;

   if ($FORM{'batch_type'} eq 'IPTC') {
      print qq|<script language="javascript">
      div = new getIFobj("progress_header");
      div.obj.innerHTML = '<$fe_admin_small_font><font color="#ffffff"><b>P R O C E S S I N G&nbsp;&nbsp;&nbsp;&nbsp;B A T C H&nbsp;&nbsp;&nbsp;&nbsp;I P T C</b></font></font>';
      div = new getIFobj("progress_content");
      div.obj.innerHTML = '<input type="text" value="0" size="3" maxlength="3" id="status" name="status" style="text-align:right"><$fe_admin_small_font><font color="#ffffff"> <b>% of total</b></font></font>';
      </script>|;
      $one_time_access = 1;
      require "$admindir_directory/iptc_keywords.pl";
      require "$libpath/iptc.pl";
      foreach (@thumbs) {
         $stepcnt++;
         if (int($stepcnt*$stepsize) > $stepcurrent) {
            $stepcurrent = int($stepcnt*$stepsize);
            print qq|<SCRIPT LANGUAGE="JavaScript">window.document.progressform.status.value=$stepcurrent;</SCRIPT>|;
         }
         ($category, $error_image) = $_ =~ /(.*)\/(.*$)/;
         $custom18_date, $custom18_user, $custom18_email, $custom18_approval, $custom18_file_type, $custom18_wxh = ();
         ($filedate)  = (stat("$image_directory/$category/$error_image"))[9];
         $createinfo = create Image::IPTCInfo("$image_directory/$category/$error_image") or next;
         &createinfo_final;
         $error_image =~ s/^$mypattern//ig;
         $createinfo = create Image::IPTCInfo("$image_directory/$category/$error_image") or next;
         &createinfo_final;
      }
   }
   elsif ($FORM{'batch_type'} eq 'Move') {
   }
   elsif ($FORM{'batch_type'} eq 'Delete') {
   }

   print qq|<SCRIPT LANGUAGE="JavaScript">window.document.progressform.status.value=100;</SCRIPT>|;

   print "</form></body></html>";

   exit;

}

1;