####CODEHEADER###

###############################################################################
# VIEW IMAGE
# Generates a page showing one image.  Results from the click on a linked
# thumbnail image.  The header and footer files used here are different than
# the ones for thumbnail pages generated by gen_image_table.
###############################################################################
sub view_image {

   $FORM{'tt'} = "ifz" if $FORM{'image'} =~ /\.ifz$/i;

   require "$libpath/iptc.pl";
   $this_alt = "$FORM{'image'}";

   if ($watermark && !$antileech) {
      $imageurl = $imagefolio_url . "?main=imageLeech&source=IF&ct=$current_time&file=";
      $imageurl =~ s/^http\:/https\:/i if lc($ENV{'HTTPS'}) eq 'on';
   }

   ($newimage) = $FORM{'image'} =~ m,^(.*)\.\w+$,;
   if ($record_counts) { &record_counts; }
   $fullsize_name = qq|$mypattern_fullsize$newimage.$myextension_fullsize|;
   $fullsize_file = qq|$image_directory/$FORM{'link'}/$fullsize_name|;

   $ratelink = qq|<a href="javascript:" onClick="window.open('$imagefolio_url?main=imageRate&direct=|;
   $ratelink .= qq|$FORM{'link'}&file=$FORM{'image'}','Rate','height=200,width=200');return false"><b>Rate It!</b></a>|;

   $newlink = $FORM{'link'};
   $newlink =~ s/\//\./g;
   if (!$hits)   { $hits = "0";     }
   if (!$votes)  { $votes = "0";    }
   if (!$rating) { $rating = "0.00"; }

   if    (-e "$image_directory/$FORM{'link'}/$mypattern$newimage.jpg") {$timage = qq|$mypattern$newimage.jpg|;}
   elsif (-e "$image_directory/$FORM{'link'}/$mypattern$newimage.JPG") {$timage = qq|$mypattern$newimage.JPG|;}
   elsif (-e "$image_directory/$FORM{'link'}/$mypattern$newimage.gif") {$timage = qq|$mypattern$newimage.gif|;}
   elsif (-e "$image_directory/$FORM{'link'}/$mypattern$newimage.GIF") {$timage = qq|$mypattern$newimage.GIF|;}

   $mediapath = "$image_directory/$FORM{'link'}/$FORM{'image'}";

   if ($FORM{'image'} =~/(\.jpg|\.gif|\.png)/i) {
      ($factorwidth, $factorheight) = imgsize("$mediapath");
#      my $media_info = image_info("$mediapath");
#      my $width = $media_info->{width};
#      my $height = $media_info->{height};
      if ($factorwidth && $factorheight && $imageprotect) {
         $wh_info = qq| width="$factorwidth" height="$factorheight"|;
      }
   }
   if ($wh_info) {
      $mediaurl = "$if_images_directory/pixel.gif";
      $mediaurl_bg = "$imageurl/$FORM{'link'}/$FORM{'image'}";
      $mediaurl_bg =~ s/([^a-zA-Z0-9$ignore_chars])/"%" . sprintf("%2x", ord($1))/ge;
      if ($FORM{'url'}) {
#         print "Content-type: text/html\n";
         print "Location:$mediaurl_bg\n\n";
         exit;
      }
   }
   else {
      $mediaurl = "$imageurl/$FORM{'link'}/$FORM{'image'}";
      $non_jpg_file_url = "$new_imageurl/$FORM{'link'}/$FORM{'image'}";
      if (!-e $mediapath) {
         $mediaurl = "$icons_dir/404.jpg";
         $mediaurl_404 = 1;
         $this_alt = "File not Found";
      }
      else {
         $mediaurl =~ s/([^a-zA-Z0-9$ignore_chars])/"%" . sprintf("%2x", ord($1))/ge;
         $non_jpg_file_url =~ s/([^a-zA-Z0-9$ignore_chars])/"%" . sprintf("%2x", ord($1))/ge;
      }
      if ($FORM{'url'}) {
#         print "Content-type: text/html\n";
         print "Location:$mediaurl\n\n";
         exit;
      }
   }

   if ($FORM{'search'}) {

      $query = $FORM{'search'};
      $query =~ s/([^a-zA-Z0-9\~])/"%" . sprintf("%2x", ord($1))/ge;

      if ($FORM{'search'} eq "NEW")      { $searchphrase = "Newly Added"; $sortfiles = 1; $display_sort = 1;}
      elsif ($FORM{'search'} eq "HITS") { $searchphrase = "Top Hits"; $sortfiles = 1; $display_sort = 3;}
      elsif ($FORM{'search'} eq "RATES") { $searchphrase = "Top Rates"; $sortfiles = 1; $display_sort = 4;}
      elsif ($FORM{'search'} eq "RANDOM") { $searchphrase = "Random"; $sortfiles = 5; $display_sort = 5;}
      elsif ($FORM{'search'} =~ /^USER~/) { ($blah, $search_user) = split(/~/, $FORM{'search'}); $searchphrase = "Uploads from $search_user"; }
      elsif ($FORM{'search'} eq "APPROVE") { $searchphrase = "Pending Approval"; $sortfiles = 1; $display_sort = 1;}
      else                        { $searchphrase = "Search Results"; }

      &get_nextprev_search_links;

      $newthisdirectory = "$searchphrase Display";

      if ($FORM{'tt'}) {
         $mediasrc = get_object($FORM{'tt'}, $mediaurl);
      }
      else {
         $mediasrc  = qq|<a href="$imagefolio_url?img=$FORM{'img'}|;
         $mediasrc .= qq|&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}">|;
         $mediasrc .= qq|<img src="$mediaurl" border=0 alt="$this_alt"$wh_info></a>|;
      }

      if ($FORM{'search'} eq "NEW" && $show_new_cats && $FORM{'cat'}) {
         if ($FORM{'cat'} =~ /\//) {
            my ($currcat, $lastcat) = $FORM{'cat'} =~ m#^(.*)\/(.*)#;
            $thisdir = get_clean_name($lastcat);
         }
         else {
            $thisdir = get_clean_name($FORM{'cat'});
         }
         $pagelinks = qq| <$font><A HREF="$imagefolio_url">Top</A> &gt; <a href="$imagefolio_url?search=$query&bool=$FORM{'bool'}">$searchphrase</a> &gt; <a href="$imagefolio_url?search=$query&img=$FORM{'img'}&cat=$FORM{'cat'}&bool=$FORM{'bool'}">$thisdir</a> &gt; $newimage</font>|;
      }
      else {
         $pagelinks = qq| <$font><A HREF="$imagefolio_url">Top</A> &gt; <a href="$imagefolio_url?search=$query&img=$FORM{'img'}&cat=$FORM{'cat'}&bool=$FORM{'bool'}">$searchphrase</a> &gt; $newimage</font>|;
      }
   }
   elsif ($FORM{'lbview'}) {

      &get_nextprev_lightbox_links;
      $newthisdirectory = "$lb_display";

      if ($FORM{'tt'}) {
         $mediasrc = get_object($FORM{'tt'}, $mediaurl);
      }
      else {
         $mediasrc  = qq|<a href="$imagefolio_url?lightbox=$FORM{'lbview'}">|;
         $mediasrc .= qq|<img src="$mediaurl" border=0 alt="$this_alt"$wh_info></a>|;
      }

      $pagelinks = qq| <$font><A HREF="$imagefolio_url">Top</A> &gt; <a href="$imagefolio_url?lightbox=$FORM{'lbview'}">$lightbox_name</a> &gt; $newimage</font>|;
   }
   else {
      &get_nextprev_image_links;

      $pagelinks = build_title_linked($FORM{'link'});

      if ($FORM{'tt'}) {
         $mediasrc = get_object($FORM{'tt'}, $mediaurl);
      }
      else {
         $mediasrc = qq|<a href="$imagefolio_url?direct=$FORM{'link'}&img=$FORM{'img'}">
         <img src="$mediaurl" border=0 alt="$this_alt"$wh_info></a>|;
      }
   }

   if ($wh_info) {
     $mediasrc = qq|<table border="0" cellspacing="0" cellpadding="0"><tr><td background="$mediaurl_bg">$mediasrc</td></tr></table>|;
  }

   $mediasrc = qq|<a name="ifztag" id="ifztag"></a><table border="0" cellspacing="8" cellpadding="0" id="ifz3" name="ifz3"><tr><td align="center">$mediasrc</td></tr>|;

   &find_size_date($FORM{'link'}, $FORM{'image'}, $timage);
   $filedate = unix_to_date($filedate);
   if (!$filesize_done) {
   if ($filesize < 1500) { $filesize = commify($filesize) . " bytes"; }
      else { $filesize = int($filesize/1024);
         if ($filesize < 1500) { $filesize = commify($filesize) . " Kb"; }
            else { $filesize = int($filesize/10.24);
                  $filesize = ($filesize/100) . " Mb";  }    }
   }

   $admin_image1 = $FORM{'image'} if !$mediaurl_404;
   $admin_image2 = $timage;

   &build_pull_down_menu;
   &build_nav;

if ($if2_caption) {
   if (-e "$data_directory/$newlink.captions.txt"){
     open (CAPTIONS,"$data_directory/$newlink.captions.txt");
     while (<CAPTIONS>) {
       my($filename, $description) = split(/\t/,$_);
       chomp $_;
       next if !$description;
       ($newfile) = $filename =~ m,^(.*)\.\w+$,;
       if ($newfile eq $newimage) {
         $image_caption = $description;
         last;
       }
     }
     close(CAPTIONS);
   }
}

   $iptc_category = $FORM{'link'};
   if ($timage) {
      $iptc_image = $timage;
   }
   else {
      $iptc_image = $FORM{'image'};
   }

   &iptc_create_table;

   if ($custom18_user && -e "$sessions_dir/$custom18_user/_watermark.png") {
      print "Set-Cookie: IFPro_userwm=$custom18_user; path=/;\n";
   }
   else {
      print "Set-Cookie: IFPro_userwm=; path=/;\n";
   }

   if ($is_admin) {
      my $plugunder = &create_image_tools;
      $mediasrc .= qq|<tr><td align="center">$plugunder</td></tr>|;
   }
   elsif ($is_user && $custom18_user) {
      $plugunder = qq|<SCRIPT LANGUAGE="JavaScript">|;
      $plugunder .= &create_user_image_tools($FORM{'link'});
      $plugunder .= qq|
         var this_guest = "$guest_username";
         var this_file = "$custom18_user";
         var block_rename_move ="$custom18_approval";
         if (IFPro_user_session) {
            per_array=IFPro_user_session.split("\|");
            if (this_file==per_array[1] && this_file != this_guest){
               if (usetextlinks == 1) {
                  document.writeln('<font size=1 face="arial,helvetica">');
               }
               if (per_array[2] == 1 && block_rename_move != 1) {
                  document.write(rename_me);
               }
               if (per_array[3] == 1) {
                  document.write(caption_me);
               }
               if (per_array[4] == 1) {
                  document.write(delete_me);
               }
               if (per_array[5] == 1 && block_rename_move != 1) {
                  document.write(move_me);
               }
               if (usetextlinks == 1) {
                  document.writeln('</font>');
               }
            }
         }
      </SCRIPT>|;
      $mediasrc .= qq|<tr><td align="center">$plugunder</td></tr>|;
      $plugunder = ();
   }

   if ($using_lightbox_mod){
      my ($base) = $FORM{'image'} =~ m,^(.*)\.\w+$,;
      my ($ext) = ($FORM{'image'} =~ /\.([^.]+)$/);
      my $inout = 1 if defined $LIGHTBOX{"$FORM{'link'}|$base|$ext"};
      my $plugunder= qq|<SCRIPT LANGUAGE="JavaScript">showItems("$base", "$FORM{'link'}", "$ext", "$inout");</SCRIPT>|;
      $mediasrc .= qq|<tr><td align="center">$plugunder</td></tr>|;
   }

   if ($show_similar && $show_similar_link) {
      $thumblinks .= qq|<a href="$imagefolio_url?img=0&cat=all&search=$show_similar&bool=or&numtolist=6" alt="Show similar $mystuff_plural" title="Show similar $mystuff_plural">Show similar $mystuff_plural</a><br>|;
   }


if ($imageprotect) {
   if (!$wh_info) {
      $if_javascript .= qq|<script language="JavaScript" src="$base_if_url/imageprotect.js"></script>\n|;
   }
   $if_javascript = qq|<META HTTP-EQUIV="imagetoolbar" CONTENT="no">$if_javascript|;
# Not supported by "Safari":
#   $if_javascript .= qq|<STYLE media="print">BODY {display:none}</STYLE>|;
}

if ($one_time_access or $is_admin) {
   $if_javascript .= qq|
      <style type="text/css">
      <!--
      .ab_delete {
      font-family: verdana,arial,helvetica;
      font-size:12px;
      color:#ffffff;
      font-weight:bold;
      background-color:#FF0000;
      }
      .ab_approve {
      font-family: verdana,arial,helvetica;
      font-size:12px;
      color:#ffffff;
      font-weight:bold;
      background-color:#00CC00;
      }
      -->
      </style>|;
   $current = "&admin_directory=$FORM{'link'}";
   $current .= "&admin_image1=$admin_image1"; #preview image
   $current .= "&admin_image2=$admin_image2"; #thumbnail image
   $current .= "&user_owner=$custom18_user"; #user
   if ($custom18_email && $custom18_user) {
      $current .= "&user_email=$custom18_email"; #user email
   }
   $current .= "&ota=$FORM{'ota'}";
   $current .= "&tt=$FORM{'tt'}";
   if ($custom18_approval) {
      $del_appr_button = qq|&nbsp;<input type=button value="&nbsp;&nbsp;Delete&nbsp;&nbsp;" class="ab_delete" onclick="javascript:adminPopup('$imagefolio_url?admin=delete_confirm_image$current','width=500,height=520,scrollbars=yes')">&nbsp;|;
      $del_appr_button .= qq|&nbsp;<input type=button value="&nbsp;Approve&nbsp;" class="ab_approve" onclick="javascript:adminPopup('$imagefolio_url?admin=admin_approve_image$current','width=500,height=320,scrollbars=no')">&nbsp;|;
      if ($is_admin or $config_cache_page_age) {
         $del_appr_button .= qq|<br><$font>Make sure you rebuild the index after you are done approving files.</font><br>|;
      }
   }
   elsif ($one_time_access) {
      $del_appr_button = qq|&nbsp;<input type=button value="&nbsp;&nbsp;Delete&nbsp;&nbsp;" class="ab_delete" onclick="javascript:adminPopup('$imagefolio_url?admin=delete_confirm_image$current','width=500,height=520,scrollbars=yes')">&nbsp;|;
   }
   if ($del_appr_button) {
      $mediasrc = qq|<center>$del_appr_button</center>$mediasrc|;
   }
}
elsif ($custom18_approval) {
   &Error('This file has not been approved for viewing yet!');
}


###############################################################################
# REMOVE OLD FILES
# Searches the temp directory for old files, and removes them from your web space
###############################################################################
#sub remove_old_files {
#   opendir (DL, "$tempdir");
#   @old_files= grep { /\d+/ } readdir(DL);
#   closedir (DL);
#   $OLDFILESSIZE = @old_files;
#
#   use File::Path;
#
#   if ($OLDFILESSIZE > 1) {
#      foreach $old_file (@old_files) {
#         if (-M "$tempdir/$old_file" > "0.25") {
#            if (-d "$tempdir/$old_file") {
#               rmtree("$tempdir/$old_file");
#            }
#            else {
#               unlink("$tempdir/$old_file");
#            }
#         }
#      }
#   }
#}
#$download_from_temp = 1;
#$tempdirurl         = $base_if_url . "/temp";

   if ($download_box && $FORM{'download'} == 1) {
      eval "use Archive::Zip qw(:CONSTANTS :ERROR_CODES);1;" or &Error("The download box feature requires the Compress::Zlib module");
      &remove_old_files;
      $temp_id = int(rand(1234567890)) + time;
      mkdir ("$tempdir/$temp_id", "0777") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
      chmod(0777,"$tempdir/$temp_id") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
      $zip = Archive::Zip->new("$fullsize_file") or $failed_download .= qq|<br><$font><font color=red>Failed to open zip: $!</font></font>|;
      @names = $zip->memberNames() or $failed_download .= qq|<br><$font><font color=red>Failed to read zip: $!</font></font>|;
      $status = $zip->extractMemberWithoutPaths("$names[0]","$tempdir/$temp_id/$names[0]");
      chmod(0777,"$tempdir/$temp_id/$names[0]");
      $work_file = "$tempdir/$temp_id/$names[0]";

      $title = qq|D  O  W  N  L  O  A  D|;
      $submit_button = qq|<input type=submit value="Download File">|;
      $hidden_fields = qq|<input type=hidden name="filepath" value="$temp_id/$names[0]"><input type=hidden name="action" value="view"><input type=hidden name="link" value="$FORM{'link'}"><input type=hidden name="image" value="$FORM{'image'}"><input type=hidden name="download" value="2">|;

      my $ic_output = `$data_directory/ic/imageConvert -info "$tempdir/$temp_id/$names[0]"`;

      if ($ic_output =~ /\: Failed/) {
#            $ic_output = "Can't read file";
         $ic_table .= "<tr><td><$font><b>Can't read file</b></font></td><td><$font>$failed_download</font></td></tr>";
      }
      else {
         ($blah, $ic_output) = split(/\: Success/, $ic_output);
         @ic_output = split(/\n/, $ic_output);
         foreach (@ic_output) {
            my ($field, $value) = split(/\:/, $_);
#            $font = qq|font face="Arial, Helvetica, sans-serif" size="1"|;
            $ic_table .= "<tr><td><$font><b>$field</b></font></td><td><$font>$value</font></td></tr>";
         }
      }

#      $ic_thumbnail = qq|<img src="$imageurl/$FORM{'link'}/$timage">|;
      $ic_thumbnail = qq|<img src="$imageurl/$FORM{'link'}/$FORM{'image'}" width=200>|;




#      $ic_output =~ s/\n/<br>/ig;


      print "Content-type: text/html\n\n";
      $download_box =~ s/%%%TITLE%%%/$title/ig;
      $download_box =~ s/%%%HIDDEN_FIELDS%%%/$hidden_fields/ig;
      $download_box =~ s/%%%SUBMIT_BUTTON%%%/$submit_button/ig;
      $download_box =~ s/%%%IMAGE_INFO%%%/$ic_table/ig;
      $download_box =~ s/%%%TUMBNAIL%%%/$ic_thumbnail/ig;
      print  $download_box;
      exit;
   }
   elsif ($FORM{'download'} == 2) {
      my $work_file = "$tempdir/$FORM{'filepath'}";
      my @work_name = split(/\//, $work_file);
      $work_name = pop @work_name;

      if ($FORM{'filetype'} ne 'original' && -B $work_file && ($work_file =~ /(.pct$|.pict$|.jpeg$|.tiff$|.eps$|.ps$|.jpg$|.tif$|.png$|.psd$|.pcd$|.bmp$|.gif$)/i)) {





         # this will correct any potential problem filenames
         my ($base) = $work_name =~ m,^(.*)\.\w+$,;
         my ($extension) = ($work_name =~ /\.([^.]+)$/);
         $newextension = $FORM{'filetype'};
#         $newbase = "$base-W$FORM{'filewidth'}H$FORM{'fileheight'}Q$FORM{'filequality'}S$FORM{'filesharpness'}C$FORM{'filecontrast'}";
         $newbase = $base;

         my $file_out = $work_file;

         $file_out =~ s/$base/$newbase/g;
         $file_out =~ s/$extension$/$newextension/g;
         $FORM{'filepath'} =~ s/$base/$newbase/g;
         $FORM{'filepath'} =~ s/$extension$/$newextension/g;

         my $fileformat = $FORM{'filetype'};
         if ($fileformat eq "jpg") { $fileformat = "jpeg"; }
         if ($fileformat eq "tif") { $fileformat = "tiff"; }

         my $ic_custom .= " -resize $FORM{'filewidth'} $FORM{'fileheight'}" if $FORM{'fileheight'} && $FORM{'filewidth'};
         my $filequality = $FORM{'filequality'} if $FORM{'filequality'};
         my $filesharpness = $FORM{'filesharpness'} if $FORM{'filesharpness'};
         my $filecontrast = $FORM{'filecontrast'} if $FORM{'filecontrast'};
#         $ic_custom .= " -keepcspace";
#         $ic_custom .= " -use_cie";

#         if (!$use_im) {
            require "$libpath/imageconvert.pl"; &load_ic;
            &do_ic("\"$work_file\"", "\"$file_out\"", $filedimensions, $filequality, $filesharpness, $filecontrast, $ic_custom, $ic_crop, $fileformat, $ic_rtype, $ic_rflag, $ic_wm_file, $ic_wm_gravity);
            chmod (0777, $file_out);
      }
      else {
         ($newbase) = $work_name =~ m,^(.*)\.\w+$,;
         ($newextension) = ($work_name =~ /\.([^.]+)$/);
      }


# ADD IMAGE REFORMATIING AND THEN SAVE THE FILE IN THE SAME LOCATION AND RESET THE NAME "$names[0]" to the new name.

# THESE ARE THE FORM FIELDS THAT ARE BEING PASSED:

#       $FORM{'filetype'}
#       $FORM{'imagewidth'}
#       $FORM{'imageheight'}
#       $FORM{'imagequality'}
#       $FORM{'filepath'}
#       $FORM{'imagesharpness'}

# IF NO VALUE IS CHOOSEN THEN DO NOT PASS ON THE COMMAND TO IMAGECONVERT SO THAT IT WILL NOT CHANGE THE DEFAULT SETTING

      $dl_url = "$tempdirurl/$FORM{'filepath'}";
      if (!$failed_download) {
         if (!$is_admin && $download_log) {
            &create_download_log;
         }
         if(open(SENDFILE, "$tempdir/$FORM{'filepath'}")) {
            if($image_directory =~ /\:/) {
               binmode(SENDFILE);
               binmode(STDOUT);
            }
            $FileSize = (stat("$tempdir/$FORM{'filepath'}"))[7];
#            ($Filename = $FORM{'filepath'}) =~  m!([^/^\\]*)$!;
            print "Content-Type: application/x-unknown\n";
#           print "Content-Type: application/octet-stream\n";
            print "Content-Length: $FileSize\n";
            print "Content-Disposition: attachment; filename=$newbase.$newextension\n\n";
            print while(<SENDFILE>);
            close(SENDFILE);
            if (!$is_admin && $download_log) {
               &create_download_log;
            }
         }
         else {
            print "Location:$dl_url\n\n";
         }
         exit;
      }
   }
   elsif ($FORM{'download'}) {
      if ($download_from_temp) {
         eval "use Archive::Zip qw(:CONSTANTS :ERROR_CODES);1;" or $donnotzip = 1;
         use File::Copy;
         &remove_old_files;
         my $temp_id = int(rand(1234567890)) + time;
         mkdir ("$tempdir/$temp_id", "0777") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
         chmod(0777,"$tempdir/$temp_id") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
         if ($donnotzip or $nozip_before_download) {
            &File::Copy::copy ("$fullsize_file", "$tempdir/$temp_id/$newimage.$myextension_fullsize") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
            chmod(0777,"$tempdir/$temp_id/$newimage.$myextension_fullsize") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
            if (lc($myextension_fullsize) eq 'jpg' && $remove_jpg_header_before_download) {
               &remove_iptc("$tempdir/$temp_id/$newimage.$myextension_fullsize","$tempdir/$temp_id/$newimage.$myextension_fullsize");
            }
            $dl_url = "$tempdirurl/$temp_id/$newimage.$myextension_fullsize";
         }
         elsif (lc($myextension_fullsize) eq 'zip') {
            if ($unzip_before_download) {
               my $zip = Archive::Zip->new("$fullsize_file") or $failed_download .= qq|<br><$font><font color=red>Failed to open zip: $!</font></font>|;
               my @names = $zip->memberNames() or $failed_download .= qq|<br><$font><font color=red>Failed to read zip: $!</font></font>|;
               my $status = $zip->extractMemberWithoutPaths("$names[0]","$tempdir/$temp_id/$names[0]");
               chmod(0777,"$tempdir/$temp_id/$names[0]");
               if ($names[0] =~ /\.jpg/i && $remove_jpg_header_before_download) {
                  &remove_iptc("$tempdir/$temp_id/$names[0]","$tempdir/$temp_id/$names[0]");
               }
               $dl_url = "$tempdirurl/$temp_id/$names[0]";
            }
            else {
               &File::Copy::copy ("$fullsize_file", "$tempdir/$temp_id/$newimage.$myextension_fullsize") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
               chmod(0777,"$tempdir/$temp_id/$newimage.$myextension_fullsize") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
               $dl_url = "$tempdirurl/$temp_id/$newimage.$myextension_fullsize";
            }
         }
         else {
            my $zip = Archive::Zip->new();
            $zip->addFile( $fullsize_file, "$newimage.$myextension_fullsize" );
            my $member = $zip->memberNamed( "$newimage.$myextension_fullsize" );
            $member->desiredCompressionMethod( 0 );
            die 'write error' if $zip->writeToFileNamed( "$tempdir/$temp_id/$newimage.zip" ) != AZ_OK;
            chmod(0777,"$tempdir/$temp_id/$newimage.zip") or $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
            $dl_url = "$tempdirurl/$temp_id/$newimage.zip";
         }

         if (!$failed_download) {
            if (!$is_admin && $download_log) {
               &create_download_log;
            }
            print "Content-Type: application/x-unknown\n";
            print "Location:$dl_url\n\n";
            exit;
         }
      }
      else {
         if(open(SENDFILE, $fullsize_file)) {
            if($image_directory =~ /\:/) {
               binmode(SENDFILE);
               binmode(STDOUT);
            }
            $FileSize = (stat($fullsize_file))[7];
            ($Filename = $fullsize_file) =~  m!([^/^\\]*)$!;
            if (lc($myextension_fullsize) eq 'zip'){
               print "Content-Type: application/x-zip\n";
            }
            else {
               print "Content-Type: application/x-unknown\n";
   #           print "Content-Type: application/octet-stream\n";
            }
            print "Content-Length: $FileSize\n";
            print "Content-Disposition: attachment; filename=$newimage.$myextension_fullsize\n\n";
            print while(<SENDFILE>);
            close(SENDFILE);
            if (!$is_admin && $download_log) {
               &create_download_log;
            }
            exit;
         }
         else {
            $failed_download = qq|<br><$font><font color=red>Failed to download: $!</font></font>|;
         }
      }
   }

   if (-e $fullsize_file && $use_fullsize) {
      if (lc($myextension_fullsize) eq 'zip' && $custom18_file_type){
         $display_name = "$newimage.$custom18_file_type";
      }
      else {
         $display_name = "$newimage.$myextension_fullsize";
      }
      if ($download_link_under_preview) {
         
         my $plugunder = "";


         if ($use_textlinks) {
            if ($download_box) {
               $plugunder = qq|<a href="javascript:;" onClick="popup('$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1&lbview=$FORM{'lbview'}',\'Download\',\'height=600,width=600');"><$font_dl_link>Download</font></a>|;
            }
            elsif (lc($myextension_fullsize) ne 'zip' && !$download_from_temp) {
               $plugunder = qq|<a href="javascript:;" onClick="if (confirm('Do you want to download the $filesize $uc_myextension_fullsize file? (OK = Yes   Cancel = No)')) {location='$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1&lbview=$FORM{'lbview'}';};return false;" alt="Download This File" title="Download This File"><$font_dl_link>Download</font></a>$failed_download|;
            }
            else {
               $plugunder = qq|<a href="javascript:;" onClick="location='$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1&lbview=$FORM{'lbview'}';return false;" alt="Download This File" title="Download This File"><$font_dl_link>Download</font></a>$failed_download|;
            }
         }
         else {
            if ($download_box) {
               $plugunder = qq|<a href="javascript:;" onClick="popup('$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1&lbview=$FORM{'lbview'}',\'Download\',\'height=600,width=600');"><img src="$if_images_directory/download2.$ButtonExt" border=0 alt="Download This File" title="Download This File"></a>|;
            }
            elsif (lc($myextension_fullsize) ne 'zip' && !$download_from_temp) {
               $plugunder = qq|<a href="javascript:;" onClick="if (confirm('Do you want to download the $filesize $uc_myextension_fullsize file? (OK = Yes   Cancel = No)')) {location='$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1&lbview=$FORM{'lbview'}';};return false;"><img src="$if_images_directory/download2.$ButtonExt" border=0  alt="Download This File" title="Download This File"></a>$failed_download|;
            }
            else {
               $plugunder = qq|<a href="javascript:;" onClick="location='$imagefolio_url?action=view&link=$FORM{'link'}&image=$FORM{'image'}&download=1&lbview=$FORM{'lbview'}';return false;"><img src="$if_images_directory/download2.$ButtonExt" border=0  alt="Download This File" title="Download This File"></a>$failed_download|;
            }
         }
         $mediasrc .= qq|<tr><td align="center">$plugunder</td></tr>|;
      }
   }
   else {
      $display_name = $FORM{'image'};
   }

   $mediasrc .= "</table>";


   if ($commerce_skin) {
      require "$commercepath/ifc_lib/image.pl";
      &calc_price_options;
   }

   if (-e "$image_directory/$FORM{'link'}/image.html") {
     open (TEMPLATE,"$image_directory/$FORM{'link'}/image.html") or &Error("Could not open template.  Reason $!");
   }
   else {
     open (TEMPLATE,"$image_template") or &Error("Could not open template.  Reason $!");
   }

   while (<TEMPLATE>) {
     if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_include($2); }
     elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_exec_include($2); }
     else { $template .= $_; }
   }
   close(TEMPLATE);

   require "$libpath/headerfooter.pl";

   if (-e "$image_directory/$FORM{'link'}/$newimage.data") {
     open (METADATA,"$image_directory/$FORM{'link'}/$newimage.data") or &Error("Could not open database.  Reason $!");
     LINE: while (defined ($line = <METADATA>)) {
      next LINE if ($line =~ /^\s*$/); # skip blank lines
      next LINE if ($line =~ /^#/);   # skip comment lines
      my ($fieldname, $fieldvalue) = split(/\t/, $line);
      $template =~ s/$fieldname/$fieldvalue/ig;
     }
     close(METADATA);
   }


   $template =~ s/%%%TEXTNAV%%%/$textnav/ig;
   
   if ($use_textlinks) {
      $template =~ s/%%%NAV%%%/<$font>$textnav<\/font>/ig;
   }
   else {
      $template =~ s/%%%NAV%%%/$nav/ig;      
   }



   if ($iptc_table && $embedinfo){
      $iptc_table .= "<br>";
   }
   $template =~ s/%%%TEXT_NEXT_PREVIOUS%%%/$text_next_previous/ig;
   $template =~ s/%%%IPTCTABLE%%%/$iptc_table $embedinfo/ig;
   $template =~ s/%%%FILENAME%%%/$display_name/ig;
   $template =~ s/%%%FILESIZE%%%/$filesize/ig;
   $template =~ s/%%%FILEDATE%%%/$filedate/ig;
   $template =~ s/%%%CAPTION%%%/$image_caption/ig;
   $template =~ s/%%%DIRECTORY%%%/$FORM{'link'}/ig;
   $template =~ s/%%%HITS%%%/$hits/ig;
   $template =~ s/%%%RATING%%%/$rating/ig;
   $template =~ s/%%%VOTES%%%/$votes/ig;
   $template =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $template =~ s/%%%IMAGE%%%/$mediasrc/ig;
   $template =~ s/%%%IMAGE_NAME%%%/$newimage/ig;
   $template =~ s/%%%SLIDESHOW%%%/$slideshow_tag/ig;
   $template =~ s/%%%CATEGORY%%%/$newthisdirectory/ig;
   $template =~ s/%%%SEARCH_INFO%%%/$searchinfo/ig;
   $template =~ s/%%%PAGELINKS%%%/$pagelinks/ig;
   $template =~ s/%%%TEXTPULLDOWN_MENU%%%/$textpulldown_menu/ig;
   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;

   if ($use_printbutton) {
      $template =~ s/%%%PRINTBUTTON_ADD_IMAGE%%%/<script language="Javascript">buy('$FORM{'image'}','$PrintButton{'add_image'}','thumbnail_url=$new_imageurl\/$FORM{'link'}\/$timage')<\/script>/ig;
      $template =~ s/%%%PRINTBUTTON_ADD_SELECTED%%%/<script language="Javascript">addtobasket("$PrintButton{'add_selected'}")<\/script>/ig;
   }

   $template =~ s/%%%THUMB_LINK%%%/$thumblinks/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;

   $template =~ s/%%%RATELINK%%%/$ratelink/ig;
   $template =~ s/%%%PULLDOWN_MENU%%%/$pulldown_menu/ig;
   $template =~ s/%%%SEARCH_BOX%%%/$search_box/ig;
   $template =~ s/%%%PREVIOUS_CATEGORY%%%/$previous_category/ig;
   $template =~ s/%%%NEXT_CATEGORY%%%/$next_category/ig;

   $template =~ s/%%%IF_JAVASCRIPT%%%/$if_javascript/ig;
   if ($parse_single_iptc_fields) {
      foreach my $key (sort keys %IPTCtag) {
         my $tag = "%%%IPTC_" . uc($key) . "%%%";
         $template =~ s/$tag/$IPTCtag{$key}/ig;
      }
   }
}

###############################################################################
# GET OBJECT
# retrieves the template for this media type and returns the $mediasrc tag
###############################################################################
sub get_object {
   my $file = shift;
   if ($file eq "emb") {

#      $emb_table_width           = qq|width="80%"|;
#      $emb_table_border_color    = qq|bgcolor="$main_table_border_color"|;
#      $emb_table_heading_bgcolor = qq|bgcolor="$main_header_bgcolor"|;
#      $emb_table_field_bgcolor   = qq|bgcolor="$main_nav_bgcolor"|;
#      $emb_table_value_bgcolor   = qq|bgcolor="$body_bgcolor"|;
#      $emb_table_field_font      = qq|$font|;
#      $emb_table_value_font      = qq|$font|;
#      $emb_table_header          = qq|<div style="height:22px;line-height:22px;"><$font><b>%%%TABLE_HEADER%%%</b></font></div>|;
#      $embedinfo = $emb_table_header;

      $embedinfo = $if_table_header;
      $embedinfo =~ s/%%%TABLE_HEADER%%%/LINK INFO/ig;
      $embedinfo = qq|<table border="0" cellspacing="1" cellpadding="3" $if_table_border_color $if_table_width><tr><td colspan="2" $if_table_heading_bgcolor align="center">$embedinfo</td></tr>|;
      open (FILE,"$mediapath") or &Error("Could not open $file.  $!");
      while (<FILE>) {
         chomp $_;
         my($field, $value) = split(/\t/,$_);
         if ($field eq 'Embed Code') {
            $value =~ s/\<object/\<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"/i if $value !~ /classid/i;
            $embedcode = qq|<script src="$base_if_url/objectload.js"></script><script type="text/javascript">write_object('$value');</script>|;
         }
         else {
            $embedinfo .= qq|<tr><td $if_table_field_bgcolor width="30%"><$if_table_field_font>$field</font></td><td $if_table_value_bgcolor width="70%"><$if_table_value_font>$value</font></td></tr>|;
         }
      }
      close(FILE);
      $embedinfo .= "</table>";
      return $embedcode;
   }
   elsif (-e "$media_template_directory/$file.html") {
     open (TEMPLATE,"$media_template_directory/$file.html") or &Error("Could not open $file.  $!");
     while (<TEMPLATE>) { $medtemplate .= $_; }
     close(TEMPLATE);
      if ($FORM{'tt'} eq 'ifz'){
         require "$libpath/zoomify.pl";
         &ifz_get_object;
         $antileech = ();
      }
   }
   elsif ($FORM{'tt'} eq 'ifz'){
      require "$libpath/zoomify.pl";
      $medtemplate = &ifz_get_template;
      &ifz_get_object;
      $antileech = ();
   }
   else {
     print "Location:$mediaurl\n\n";
     exit;
   }
   if (!$antileech) {
      $medtemplate =~ s/%%%FILE%%%/$non_jpg_file_url/ig;
   }
   else {
      $medtemplate =~ s/%%%FILE%%%/$mediaurl/ig;
   }
   $medtemplate =~ s/%%%DOWNLOAD_FILE%%%/$mediaurl/ig;
   $medtemplate =~ s/%%%NAME%%%/$newimage/ig;

   $medtemplate =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $medtemplate =~ s/%%%IMAGEFOLIO_URL%%%/$imagefolio_url/ig;
   $medtemplate =~ s/%%%BASE_IF_URL%%%/$base_if_url/ig;

   $medtemplate =~ s/%%%(.*)%%%//ig;
   return $medtemplate;
}

###############################################################################
# GET NEXTPREV SEARCH LINKS
# called from view_image to provide navigation to next and previous full-size
# images from a search result
###############################################################################
sub get_nextprev_search_links {


   if ($FORM{'search'} =~ /^mysql:/g) {
#       $searchphrase = "MySQL Search Result";
#       $newthisdirectory = $searchphrase;
      ($blah, $cachefile) = split(/\:/, $FORM{'search'});
#      $query = $FORM{'search'};
      $cacheloc = "$cache_directory/searches/$cachefile.mysql";
   }
   else {
      $cachefilename = "search~$FORM{'search'}";
      $cachefilename .= ".$FORM{'cat'}" if $FORM{'cat'};
      $cachefilename .= ".$FORM{'bool'}" if $FORM{'bool'};
      $cachefilename .= ".sort5" if ($sortfiles == 5);
      $cachefilename .= ".$group_group_name" if $group_group_name;
      $cachefilename .= ".is_admin" if $is_admin;
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";
   }


   @names = ();
   @idx = ();
   @LINES = ();
   open (FILE,"$cacheloc") or &Error("Our database was updated $index_date ago. Please click <a href=\"$imagefolio_url?search=$FORM{'search'}&cat=$FORM{'cat'}&bool=$FORM{'bool'}&img=$FORM{'img'}&tt=$FORM{'tt'}&from_link=$FORM{'link'}&image=$FORM{'image'}\">here</a> to run the search again since the result might have changed.");
   my(@LINES)=<FILE>;
   close(FILE);

   foreach (@LINES) {
      my ($blah,$name,$path,$filedate,$hits,$votes) = split(/\|/, $_);
      ($linkimage) = $name =~ m,^(.*)\.\w+$,;
      $linkimage =~ s/^$mypattern//g;
      foreach $key (keys %extensions) {
         $lckey = lc($key);
         $uckey = uc($key);
         $extfound = 0;
         if ( -e "$image_directory/$path/$linkimage.$lckey" ) {
            $extfound = 1;
            $mykey = $lckey;
            last;
         }
         elsif ( -e "$image_directory/$path/$linkimage.$uckey" ) {
            $extfound = 1;
            $mykey = $uckey;
            last;
         }
      }
      if ($extfound) {
         push(@names, "$linkimage.$mykey\t$path\t$filedate\t$hits\t$votes");
         if ($sortfiles == 3) {
            push(@idx, $hits);
         }
         elsif ($sortfiles == 4) {
            push(@idx, $votes);
         }
      }
   }

   if ($sortfiles == 2) {
      @names = sort { lc($a) cmp lc($b) } @names;
   }
   elsif (($sortfiles == 3) or ($sortfiles == 4)) {
      @names = @names[ sort { $idx[$b] <=> $idx[$a] } 0 .. $#idx ];
   }

   $SIZE=@names;
   $current_image = $FORM{'image'};
   $cnt = 0;


   if ($SIZE) {
     foreach (@names) {
       my ($ifname, $ifpath) = split(/\t/, $_);
       if (lc($ifname) eq lc($current_image) && lc($ifpath) eq lc($current_cat)) {
         $thiscount = ($cnt + 1);
         $nextcount = ($cnt + 1);
         $prevcount = ($cnt - 1);
         last;
       }
       $cnt++;
     }

   $searchinfo  = qq|$newimage from $newthisdirectory<br>|;
   $searchinfo .= qq|Image $thiscount of $SIZE|;

   $cnt = 0;

   if ($thiscount eq $SIZE) { $nextcount = 0; }

     foreach (@names) {
       my ($name, $path) = split(/\t/, $_);
       if ($cnt eq $nextcount) {
         $nextimage = $name;
         $nextpath = $path;
         ($extension) = ($nextimage =~ /\.([^.]+)$/);
         $if_tagfile =  $extensions{lc($extension)}[2];
         $next_page_link =  qq|$imagefolio_url?action=view&link=$nextpath&image=$nextimage&img=$FORM{'img'}&tt=$if_tagfile&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}|;
         if ($auto_slideshow && $FORM{'slideshow'}) {
            $slideshow_tag  = qq|<META HTTP-EQUIV="refresh" CONTENT="$ss_refresh ;URL=$imagefolio_url?|;
            $slideshow_tag .= qq|action=view&link=$nextpath&image=$nextimage&img=$FORM{'img'}&tt=|;
            $slideshow_tag .= qq|$if_tagfile&slideshow=1&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}">|;
            $stop_link =  qq|$imagefolio_url?action=view&link=$FORM{'link'}&image=$current_image&img=$FORM{'img'}&tt=$if_tagfile&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}|;
         }
       }
       if ($cnt eq $prevcount) {
         $previmage = $name;
         $prevpath = $path;
         ($extension) = ($previmage =~ /\.([^.]+)$/);
         $if_tagfile =  $extensions{lc($extension)}[2];
         $previous_page_link =  qq|$imagefolio_url?action=view&link=$prevpath&image=$previmage&img=$FORM{'img'}&tt=$if_tagfile&search=$query&cat=$FORM{'cat'}&bool=$FORM{'bool'}|;
       }
       last if $previmage && $nextimage;
       $cnt++;
     }
   }
   @names = ();
}

###############################################################################
# GET NEXTPREV IMAGE LINKS
# called from view_image to provide navigation to next and previous full-size
# images
###############################################################################
sub get_nextprev_image_links {

   $cachefilename = "link~$FORM{'link'}";
   $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
   $cachefilename .= "~sort5" if ($sortfiles == 5);
   $cacheloc = "$cache_directory/searches/$cachefilename";

   @names = ();
   @db_lines = ();
   @idx = ();

   if (-e "$cacheloc") { 
      if ((-M "$cacheloc" <= $cache_date) && !$force_cachereload) { 
         &get_link_cache;
      }
      else { 
         &creat_link_list;
      }
   }
   else {
      &creat_link_list;
   }

   sub creat_link_list {
      @idsort = ();
      opendir(IMAGEDIR,"$image_directory/$FORM{'link'}")or &Error("Error Reading Directory: $!");
      @files = readdir(IMAGEDIR);
      closedir(IMAGEDIR);

      foreach $file (@files) {
#         if ( -B "$image_directory/$FORM{'link'}/$file") {
            next if $file =~ /^$mypattern/i;
            next if $file =~ /^$mypattern_fullsize/i;
#            next if $file eq "_category_image.jpg";
            next if $file =~ /(index\.html|_category_image\.jpg|\.vote|\.count)$/i;
            ($extension) = ($file =~ /\.([^.]+)$/);
            next if !exists($extensions{lc($extension)});
            $filedate = ();
            $my_count = ();
            $my_votes = ();
            $my_rates = ();
            &find_size_date($FORM{'link'}, $file);
            my ($name_base) = $file =~ m,^(.*)\.\w+$,;
            my $countfile = qq|$image_directory/$FORM{'link'}/$name_base.count|;
            if (-e $countfile) {
               open (FILE,"$countfile");
               while (<FILE>) {
                  ($my_count) = split(/\t/, $_);
                  last;
               }
               close(FILE);
            }
            my $votefile = qq|$image_directory/$FORM{'link'}/$name_base.vote|;
            if (-e $votefile) {
               open (FILE,"$votefile");
               while (<FILE>) {
                  ($my_votes, $my_rates) = split(/\t/, $_);
                  last;
               }
               close(FILE);
            }
            push(@db_lines, "$filedate\t$file\t$my_count\t$my_rates\t$my_votes");
            push(@idsort, $name_base);
#         }
      }

      if (($sortfiles == 5) && @db_lines) {
          &shuffle_link(\@db_lines);
      }
      else {
         @db_lines = @db_lines[ sort { lc($idsort[$a]) cmp lc($idsort[$b]) } 0 .. $#idsort ];
      }

      open (CACHE,">$cacheloc") or &Error("Unable to create cache file at $cacheloc: $!");
      foreach $db_line (@db_lines) {
         print CACHE "$db_line\t\n";
      }
      close(CACHE);
      chmod(0777,"$cacheloc");
      @db_lines = ();
      &get_link_cache
   }

   sub get_link_cache {
      open (FILE,"$cacheloc") or &Error("Can't Open $cacheloc: $!");
      while (<FILE>) {
         my ($filedate, $file, $my_count, $my_rates, $my_votes) = split(/\t/, $_);
         push(@db_lines, "$filedate\t$file\t$my_count\t$my_rates\t$my_votes");
         if ($sortfiles == 3) {
            push(@idx, $my_count);
         }
         elsif ($sortfiles == 4) {
            push(@idx, $my_rates);
         }
      }
      close(FILE);
   }

   sub shuffle_link {
      my $db_lines = shift;
      my $l;
      for ($l = @$db_lines; --$l; ) {
         my $m = int rand ($l+1);
         next if $l == $m;
         @$db_lines[$l,$m] = @$db_lines[$m,$l];
      }
   }

   if ($sortfiles == 1) {
      @names = sort { $b <=> $a } @db_lines;
   }
   elsif (($sortfiles == 2) or ($sortfiles == 5)) {
      @names = @db_lines;
   }
   elsif (($sortfiles == 3) or ($sortfiles == 4)) {
      @names = @db_lines[ sort { $idx[$b] <=> $idx[$a] } 0 .. $#idx ];
   }

   $SIZE=@names;
   $current_image = $FORM{'image'};
   $cnt = 0;

   if ($SIZE) {
     foreach (@names) {
       my ($ifdate, $ifname) = split(/\t/, $_);
       if (lc($ifname) eq lc($current_image)) {
         $thiscount = ($cnt + 1);
         $nextcount = ($cnt + 1);
         $prevcount = ($cnt - 1);
         last;
       }
       $cnt++;
     }

   $searchinfo = qq|Displaying image $thiscount of $SIZE|;
   if ($auto_slideshow && $FORM{'slideshow'}) { $searchinfo .= qq|<br>$ss_refresh Second Slideshow Mode|; }
   else { $searchinfo .= qq|<br>Manual Slideshow Mode| unless $quickdisplay; }

   $cnt = 0;

   if ($thiscount eq $SIZE) { $nextcount = 0; }

     foreach (@names) {
       my ($nulldate, $name) = split(/\t/, $_);
       if ($cnt eq $nextcount) {
         $nextimage = $name;
         ($extension) = ($nextimage =~ /\.([^.]+)$/);
         $if_tagfile =  $extensions{lc($extension)}[2];
         $next_page_link =  qq|$imagefolio_url?action=view&link=$FORM{'link'}&image=$nextimage&img=$FORM{'img'}&tt=$if_tagfile|;
         if ($auto_slideshow && $FORM{'slideshow'}) {
            $slideshow_tag = qq|<META HTTP-EQUIV="refresh" CONTENT="$ss_refresh ;URL=$imagefolio_url?action=view&link=$FORM{'link'}&image=$nextimage&img=$FORM{'img'}&tt=$if_tagfile&slideshow=1">|;
            $stop_link =  qq|$imagefolio_url?action=view&link=$FORM{'link'}&image=$current_image&img=$FORM{'img'}&tt=$if_tagfile|;
         }
       }
       if ($cnt eq $prevcount) {
         $previmage = $name;
         ($extension) = ($previmage =~ /\.([^.]+)$/);
         $if_tagfile =  $extensions{lc($extension)}[2];
         $previous_page_link =  qq|$imagefolio_url?action=view&link=$FORM{'link'}&image=$previmage&img=$FORM{'img'}&tt=$if_tagfile|;
       }
       last if $previmage && $nextimage;
       $cnt++;
     }
   }
   @names = ();
}

###############################################################################
# GET NEXTPREV LIGHTBOX LINKS
# called from view_image to provide navigation to next and previous full-size
# images
###############################################################################
sub get_nextprev_lightbox_links {

   if ($FORM{'lbview'} eq 'view') {
      ($lb_display) = split(/\t/, @LIGHTBOXES[0]);
      ($lb_display) = split(/\|/, $lb_display);
      $lb_display = "$untitled_lightbox" if !$lb_display;
      $lb_display = "$lightbox_name : $lb_display";
      @files = @current_lightbox_content;
   }
   else {
      $savedlightbox = $FORM{'lbview'};
      $savedlightbox .= "$emailed_lightboxes_ext";
      if (-e "$emailed_lightboxes_directory/$savedlightbox"){
         open (LIGHTBOXES,"< $emailed_lightboxes_directory/$savedlightbox");
         while (<LIGHTBOXES>) {
            chomp;
            push(@lightboxcopy, $_);
          }
         close(LIGHTBOXES);
         my ($rawtempsubject, $cookie, $no_expire) = split(/\t/, $lightboxcopy[0]);
         @files = $cookie =~ /\[(.*?)\]/g;
         ($lb_display) = split(/\|/, $rawtempsubject);
         if ($no_expire) {
            $lightboxtype = "Saved";
         }
         else {
            $lightboxtype = "Emailed";
         }
         $lb_display = "$lightboxtype $lightbox_name : $lb_display";
      }
   }

   foreach $file (@files) {
     ($path, $linkimage, $extension) = split(/\|/, $file);
     $file = "$linkimage.$extension";
     if ( -e "$image_directory/$path/$file") {
       next if $file =~ /^$mypattern/i;
       next if $file =~ /^$mypattern_fullsize/i;
       next if $file eq "_category_image.jpg";
       next if !exists($extensions{lc($extension)});
       my $dbline = "$path\t$file";
       push(@names, $dbline);
     }
   }

   $SIZE=@names;
   $current_image = $FORM{'image'};
   $cnt = 0;



   if ($SIZE) {
     foreach (@names) {
       my ($ifpath, $ifname) = split(/\t/, $_);
       if (lc($ifname) eq lc($current_image) && lc($ifpath) eq lc($current_cat)) {
         $thiscount = ($cnt + 1);
         $nextcount = ($cnt + 1);
         $prevcount = ($cnt - 1);
#         $next_page_link = "yes";
         last;
       }
       $cnt++;
     }

      $searchinfo = qq|Displaying image $thiscount of $SIZE|;
      if ($auto_slideshow && $FORM{'slideshow'}) { $searchinfo .= qq|<br>$ss_refresh Second Slideshow Mode|; }
      else { $searchinfo .= qq|<br>Manual Slideshow Mode|; }

      $cnt = 0;

      if ($thiscount eq $SIZE) { $nextcount = 0; }

      foreach (@names) {
         my ($path, $name) = split(/\t/, $_);
         if ($cnt eq $nextcount) {
            $nextimage = $name;
            ($extension) = ($nextimage =~ /\.([^.]+)$/);
            $if_tagfile =  $extensions{lc($extension)}[2];
            $next_page_link =  qq|$imagefolio_url?action=view&link=$path&image=$nextimage&tt=$if_tagfile&lbview=$FORM{'lbview'}|;
            if ($auto_slideshow && $FORM{'slideshow'}) {
               $slideshow_tag = qq|<META HTTP-EQUIV="refresh" CONTENT="$ss_refresh ;URL=$imagefolio_url?action=view&link=$path&image=$nextimage&tt=$if_tagfile&slideshow=1&lbview=$FORM{'lbview'}">|;
               $stop_link =  qq|$imagefolio_url?action=view&link=$path&image=$current_image&tt=$if_tagfile&lbview=$FORM{'lbview'}|;
            }
         }
         if ($cnt eq $prevcount) {
            $previmage = $name;
            ($extension) = ($previmage =~ /\.([^.]+)$/);
            $if_tagfile =  $extensions{lc($extension)}[2];
            $previous_page_link =  qq|$imagefolio_url?action=view&link=$path&image=$previmage&tt=$if_tagfile&lbview=$FORM{'lbview'}|;
         }
         last if $previmage && $nextimage;
         $cnt++;
      }
   }
   @names = ();
}

###############################################################################
# REMOVE OLD FILES
# Searches the temp directory for old files, and removes them from your web space
###############################################################################
sub remove_old_files {

   opendir (DL, "$tempdir");
   @old_files= grep { /\d+/ } readdir(DL);
   closedir (DL);
   $OLDFILESSIZE = @old_files;

   use File::Path;

   if ($OLDFILESSIZE > 1) {
      foreach $old_file (@old_files) {
         if (-M "$tempdir/$old_file" > "0.25") {
            if (-d "$tempdir/$old_file") {
               rmtree("$tempdir/$old_file");
            }
            else {
               unlink("$tempdir/$old_file");
            }
         }
      }
   }
}

sub remove_iptc {
   my ($infile, $outfile) = @_;
   require "$libpath/imageconvert.pl"; &load_ic;
   &do_ic("\"$infile\"", "\"$outfile\"",'','90','','','-rmeta','','jpeg','quick','decr','','');
   chmod (0777, $outfile);
}
###############################################################################
# RECORD STATS
# Opens our stats database and updates or creates the hit counter
###############################################################################
sub record_counts {

   $votefile = "$image_directory/$FORM{'link'}/$newimage.vote";
   if (-e $votefile) {
      open (FILE,"$votefile") or &Error("Could not open $votefile.  $! \n");
      while (<FILE>) {
         ($votes, $rating) = split(/\t/, $_);
         last;
      }
      close(FILE);
   }

   @hits = ();

   $count_host = $ENV{'REMOTE_ADDR'};
   $count_host .= " DOWNLOAD" if $FORM{'download'};
   $countfile = "$image_directory/$FORM{'link'}/$newimage.count";
   if (-e $countfile) {
      open (FILE,"$countfile") or &Error("Could not open $countfile.  $!");
      (@hits)=<FILE>;
      close(FILE);
      chomp @hits;
      $SIZE=@hits;


      for ($i=0;$i<$SIZE;$i++) {
         $_=$hits[$i];
         if ($i==0) {
            ($hits, $time, $downloads) = split(/\t/, $_);
            $downloads = 0 if !$downloads;
            $hits++ if !$FORM{'download'};
            $downloads++ if $FORM{'download'};
            $new_countfile = $hits . "\t" . $time . "\t" . $downloads . "\t\n";
            $elapsed = ($current_time - $time) / 86400; # 86400 sec = 1 day
         }
         elsif ($elapsed > 1) {
            $new_countfile = $hits . "\t" . $current_time . "\t" . $downloads . "\t\n";
            last;
         }
         elsif ($_ eq $count_host) {
            $hits = $hits-1 if !$FORM{'download'};
            $downloads = $downloads-1 if $FORM{'download'};
            $no_permission = 1;
            last;
         }
         else {
            $new_countfile .= "$_\n";
         }
      }
   }
   else {
      $hits = 0;
      $downloads = 0;
      $hits = 1 if !$FORM{'download'};
      $downloads = 1 if $FORM{'download'};
      $new_countfile = $hits . "\t" . $current_time . "\t" . $downloads . "\t\n";
   }

   if (!$no_permission) {
      $new_countfile .= "$count_host\n";
      open (FILE,">$countfile");
      if ($useflock) { flock(FILE, 2); }
      print FILE $new_countfile;
      close(FILE);
      chmod(0777,"$countfile");
   }
}

sub create_download_log {
   if ($ifusername) {
      $log_user = $ifusername;
   }
   elsif ($is_admin) {
      $log_user = "Administrator";
   }
   else {
      $log_user = $guest_username;
   }
   $download_log = "$logdir/$download_log";
   if (! -e $download_log) {
      $log_file = "DOWNLOAD SYSTEM\tUSER\tIP\tDATE/TIME\tFILE(S)\n";
   }
   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $year += 1900;
   $mon++;
   $logdate = sprintf "%04d-%02d-%02d %02d:%02d:%02d", $year, $mon, $mday, $hour, $min, $sec;

   $log_file .= "File download\t$log_user\t$ENV{'REMOTE_ADDR'}\t$logdate\t$FORM{'link'}/$fullsize_name\n";

   open (FILE,">>$download_log") or &Error("Can't Open Download Log: $!");
   print FILE $log_file;
   close(FILE);
   chmod(0777,"$download_log");
}

1;

