####CODEHEADER###

sub load_ic {
   if ($FORM{'imageconvert'}) {
      require "$libpath/imageconvert_1.pl";
      if ($FORM{'imageconvert'} eq "install") {
         require "$libpath/imageconvert_2.pl";
      }
      &{"$FORM{'imageconvert'}_ic_in"};
   }
   else {
      my ($ic_installed, $ic_working, $ic_why) = split(/~/, &do_load_ic);
      if ($ic_working eq "No") {
         require "$libpath/imageconvert_1.pl";
         if ($is_admin) {
            $install_button = &install_ic_button;
         }
         if ($ic_installed eq "No") {
            &die_ic("<b>ImageConvert installation: First time install</b><br>ImageConvert is not installed yet. You will need to be logged in as an administrator to be able to install it.", $install_button);
         }
         else {
            &die_ic("<b>ImageConvert installation: Incomplete installation</b><br>ImageConvert seems to be installed but it is not working. Please install in again or contact <a href=\"mailto:support\@BizSecure.com\">support\@BizSecure.com</a>. You will need to be logged in as an administrator to reinstall it.<br><font color=\"#cccccc\" size=1>Error: Couldn't execute imageConvert ($ic_why)</font>", $install_button);
         }
      }
   }
}

sub do_ic {
   my ($ic_path_to_in, $ic_path_to_out, $ic_resize, $ic_quality, $ic_sharpen, $ic_contrast, $ic_custom, $ic_crop, $ic_out_format, $ic_rtype, $ic_rflag, $ic_wm_file, $ic_wm_gravity) = @_;
   if ($ic_sharpen > 0 && $ic_sharpen <= 1) {
      $ic_sharpen = 100-($ic_sharpen*100);
   }
   $ic_out_format = "jpeg" if !$ic_out_format;
   $ic_rtype = "linear" if !$ic_rtype;
#   $ic_rflag = "decr" if !$ic_rflag;
#   $ic_rflag = () if $ic_rflag eq "null";
   my $ic_system_call = "$data_directory/ic/imageConvert";
   $ic_system_call .= " -quiet" if !$imageconvert_log;
   $ic_system_call .= " -out $ic_out_format";
   $ic_system_call .= " -ratio";
   $ic_system_call .= " -truecolors";
   $ic_system_call .= " -resize $ic_resize $ic_resize" if $ic_resize;
   $ic_system_call .= " -crop $ic_crop" if $ic_crop;
   $ic_system_call .= " -rtype $ic_rtype";
   $ic_system_call .= " -rflag $ic_rflag" if $ic_rflag;
   $ic_system_call .= " -q $ic_quality" if $ic_quality;
   $ic_system_call .= " -sharpen $ic_sharpen" if $ic_sharpen;
   $ic_system_call .= " -contrast $ic_contrast" if $ic_contrast;
   $ic_system_call .= " -wmfile $ic_wm_file" if $ic_wm_file;
   $ic_system_call .= " -wmflag $ic_wm_gravity" if $ic_wm_gravity;
   $ic_system_call .= " $ic_custom" if $ic_custom;
   $ic_system_call .= " -o $ic_path_to_out";
   $ic_system_call .= " $ic_path_to_in";
   my $ic_output = `$ic_system_call`;
   &log_ic($ic_output) if $imageconvert_log;
   return $ic_output;
}

sub test_ic {
   my $ic_system_call = "$data_directory/ic/imageConvert -help";
   my $ic_test_output = `$ic_system_call`;
   if ($ic_test_output) {
      return "Yes";
   }
   else {
      $ic_test_output = `$ic_system_call 1>&1 2>&1`;
      return "No~$ic_test_output";
   }
}

sub log_ic {
   $ic_file = ();
   my(@ic_output) = split(/\n/, shift);
   $ic_log = "$logdir/$imageconvert_log";
   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $year += 1900;
   $mon++;
   $logdate = sprintf "%04d-%02d-%02d %02d:%02d:%02d", $year, $mon, $mday, $hour, $min, $sec;

   $ic_file .= "$logdate\n";

   for my $i (14..@ic_output){
      $ic_file .= "@ic_output[$i]\n";
   }

   open (FILE,">>$ic_log");
   print FILE $ic_file;
   close(FILE);
   chmod(0777,"$ic_log");
}

sub do_load_ic {
   if (-e "$data_directory/ic/ver.pl") {
      require "$data_directory/ic/ver.pl";
      $ENV{"$ic_ver"} = "$data_directory/ic";
      return "Yes~" . &test_ic;
   }
   else {
      return "No~No";
   }
}

1;
