####CODEHEADER###

use Image::Magick;

sub do_im {
   my ($im_path_to_in, $im_path_to_out, $im_resize, $im_quality, $im_sharpen, $im_contrast, $im_crop) = @_;
   $im_path_to_in .= '[0]' if $im_path_to_in =~ /pdf$/i;
   $ImageGeometry = $im_resize . 'x' . $im_resize . '>';
   if ($im_sharpen > 1 or !$im_sharpen) {
      $im_sharpen = (100-$im_sharpen)/100;
   }
   my $image = Image::Magick->new();
   $i = $image->Read($im_path_to_in);                                           &Error("Error Reading Image: $i") if $i;
#  $i = $image->Scale(geometry=>$ImageGeometry);                                &Error("Error Scaling Image: $i") if $i;
   $i = $image->Resize(geometry=>$ImageGeometry,blur=>$im_sharpen);             &Error("Error Resizing Image: $i") if $i;
   if ($im_crop) { $i = $image->Crop($im_crop);                                 &Error("Error cropping thumbnail: $i") if $i; }
   $i = $image->Set(quality=>$im_quality);                                      &Error("Error Setting Quality: $i") if $i;
   $i = $image->Set(colorspace=>'RGB');                                         &Error("Error Setting Colorspace: $i") if $i;
   if ($im_contrast)   { $i = $image->Contrast(sharpen=>$im_contrast);          &Error("Error Applying Contrast: $i") if $i; }
#  if ($im_sharpen)  { $i = $image->Sharpen(factor=>$im_sharpen);               &Error("Error Applying Sharpness: $i") if $i; }
   $i = $image->Write(filename=>$im_path_to_out);                               &Error("Error Writing Image: $i") if $i;
   undef $image;
   undef $i;
}



1;
