####CODEHEADER###

###############################################################################
# GEN KEYWORDS PAGE
# Generates a list of all the searchable keywords
###############################################################################
sub gen_keywords_page {

   @user_sorting_choices = ();
   @user_row_choices = ();
#   @user_skin_choices = ();
   $thumb_info_layout = ();
#   $nav_switching = ();

   $pagelinks = qq| <$font><A HREF="$imagefolio_url">Top</a> &gt; Common Keywords</font>|;
   &build_pull_down_menu;
   &build_nav;
   
   $site_title =~ s/\*\*\*Admin Mode\*\*\*// if $quickdisplay;
   $keyword_list = "";
   $keyword_select = "";

   if ($allow_free_access) {
      open (INDEX,"$keywords_index");
      (@Keywords)=<INDEX>;
      close(INDEX);
      chomp @Keywords;
   }
   else {
      foreach my $path (@current_cat_access) {
         $path =~ s/\//\.\+\./g;
         if (-e "$data_directory/gallery/$path/search_keywords.txt") {
            open (INDEX,"$data_directory/gallery/$path/search_keywords.txt");
            my(@pathwords)=<INDEX>;
            close(INDEX);
            chomp @pathwords;
            foreach my $pathword (@pathwords) {
               my ($keyword, $keycount) = split (/\t/, $pathword);
               $keywordseen{$keyword} += $keycount;
            }
         }
      }
      foreach my $key (sort keys %keywordseen) {
         push(@Keywords,"$key\t$keywordseen{$key}") if $keywordseen{$key} >= $keyword_threshold;
      }
   }



   @Keywords = sort { lc($a) cmp lc($b) } @Keywords;

#   $keyword_list = qq|<tr><td valign=top bgcolor="$main_table_border_color">
   $keyword_list = qq|<tr><td valign=top bgcolor="$thumb_table_bgcolor">
   <table border=0 cellspacing=1 cellpadding=3 width="100%">
     <tr bgcolor="$thumb_table_bgcolor">
       <td valign=top align=center width="20%"><$font><b>A-E</b></font></td>
       <td valign=top align=center width="20%"><$font><b>F-J</b></font></td>
       <td valign=top align=center width="20%"><$font><b>K-O</b></font></td>
       <td valign=top align=center width="20%"><$font><b>P-T</b></font></td>
       <td valign=top align=center width="20%"><$font><b>U-Z</b></font></td>     
     </tr>
     
   
   |;
   
   $keycounts = "0";
   
   foreach $Keyword (@Keywords) {
      my ($ifkeyword, $keywordcount) = split (/\t/, $Keyword);
      my $bool = "phrase" if $ifkeyword =~ / /;
      $cleankeyword = $ifkeyword;
      $cleankeyword =~ s/([^a-zA-Z0-9])/"%" . sprintf("%2x", ord($1))/ge;
      $klink = qq|a href="$imagefolio_url?img=0&bool=$bool&cat=all&search=$cleankeyword"|;
      if ($ifkeyword =~ /^(a|b|c|d|e)/i) {
        $ae_keyword_list .= qq|<$klink>$ifkeyword</a> ($keywordcount)<br>|;
        $keycounts++;
      }
      elsif ($ifkeyword =~ /^(f|g|h|i|j)/i) {
        $fj_keyword_list .= qq|<$klink>$ifkeyword</a> ($keywordcount)<br>|;
        $keycounts++;
      }
      elsif ($ifkeyword =~ /^(k|l|m|n|o)/i) {
        $ko_keyword_list .= qq|<$klink>$ifkeyword</a> ($keywordcount)<br>|;
        $keycounts++;
      }
      elsif ($ifkeyword =~ /^(p|q|r|s|t)/i) {
        $pt_keyword_list .= qq|<$klink>$ifkeyword</a> ($keywordcount)<br>|;
        $keycounts++;
      }
      elsif ($ifkeyword =~ /^(u|v|w|x|y|z)/i) {
        $uz_keyword_list .= qq|<$klink>$ifkeyword</a> ($keywordcount)<br>|;
        $keycounts++;
      }
   }


   @Keywords = ();

   $keyword_list .= qq|
   <tr bgcolor="$thumb_table_bgcolor">
   <td valign=top><$font>$ae_keyword_list<br>&nbsp;</font></td>
   <td valign=top><$font>$fj_keyword_list<br>&nbsp;</font></td>
   <td valign=top><$font>$ko_keyword_list<br>&nbsp;</font></td>
   <td valign=top><$font>$pt_keyword_list<br>&nbsp;</font></td>
   <td valign=top><$font>$uz_keyword_list<br>&nbsp;</font></td>
   </tr>
   </table></td></tr>
   |;
   
   $keycounts = "$keycounts common keywords found.<br>Estimated file counts shown in parenthesis.";
   
   open (TEMPLATE,"$keywords_template") or &Error("Could not open $keywords_template.  Reason $!");
   while (<TEMPLATE>) {
      if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_include($2); }
      elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_exec_include($2); }
      else { $template .= $_; }
   }
   close(TEMPLATE);
   require "$libpath/headerfooter.pl";

   $template =~ s/%%%PAGEQUERY%%%/Common Keywords/ig;
   $template =~ s/%%%SEARCH_INFO%%%/$keycounts/ig;

   $template =~ s/%%%TEXTNAV%%%/$textnav/ig;
   
   if ($use_textlinks) {
      $template =~ s/%%%NAV%%%/<$font>$textnav<\/font>/ig;
   }
   else {
      $template =~ s/%%%NAV%%%/$nav/ig;      
   }
   
   $template =~ s/%%%THUMBNAILS%%%/$keyword_list/ig;
   $template =~ s/%%%KEYWORDSELECT%%%/$keyword_select/ig;
   $template =~ s/%%%QUERY%%%/Common Keywords/ig;
   $template =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $template =~ s/%%%COUNTS%%%/$counts/ig;
   $template =~ s/%%%NAV%%%/$nav/ig;
   $template =~ s/%%%PAGELINKS%%%/$pagelinks/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $template =~ s/%%%JS_ROLLOVERS%%%/$jsrollovers/ig;
   $template =~ s/%%%COLUMN_WIDTH%%%/$cat_column_width/ig;
   $template =~ s/%%%TEXTPULLDOWN_MENU%%%/$textpulldown_menu/ig;
   $template =~ s/%%%PULLDOWN_MENU%%%/$pulldown_menu/ig;
   $template =~ s/%%%SEARCH_BOX%%%/$search_box/ig;

   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;

#   if ($is_admin) {
#      $if_javascript .= &admin_js_popup;
#      $admin_tools = &create_tools;
#      $template =~ s/%%%ADMIN_TOOLS%%%/$admin_tools/ig;
#   }

   $template =~ s/%%%IF_JAVASCRIPT%%%/$if_javascript/ig;

}


1;
