#!/usr/bin/perl
###CODEHEADER###

BEGIN {
   ($currdir, $currscript) = $0 =~ m#^(.*)[\\|/](.*)#;
    if (!$currdir) {
       $currdir = ".";
       $currscript = $0;
    }
    else {
       $currdir =~ s/\\/\//ig;
    }
};



eval {
   require "$currdir/main/imageZoomify.pl" if $ENV{'QUERY_STRING'} =~ /^ifz\=/;
   $| = 1;
   unshift (@INC, $currdir);
   use lib "$currdir/CPAN";
   require HTML::Entities;

   if (-e "$currdir/data/config/main.pl") {
      require "$currdir/data/config/main.pl";
      eval{require "$currdir/data/config/skins.pl";};
   }
   else {
      require "$currdir/if_lib/setup.pl";
      &do_setup;
   }
   if ($ENV{'QUERY_STRING'} =~ /^relay\=cart/) {
     $FORM{'commerce'} = 'cart';
     $FORM{'QUERY_STRING'} = $ENV{'QUERY_STRING'};
     $ENV{'QUERY_STRING'} = ();
     $ENV{'HTTP_USER_AGENT'} = 'IF_RELAY';
   }
   require "$currdir/config/pathsurls_config.pl";
   require "$libpath/error.pl";
   require "$config_directory/config.pl";
   if ($loginput) {
      $loginput = $current_time;
      foreach $key (sort keys %ENV) {
         $logenv .= "$key: $ENV{$key}\n";
      }
      open (FILE,">$data_directory/logs/${loginput}ENV.txt");
      print FILE $logenv;
      close(FILE);
      chmod(0777,"$data_directory/logs/${loginput}ENV.txt");
   }
   $full_query = $ENV{'QUERY_STRING'};

   if (($ifup) = $full_query =~ /^ifup\=(.*)/) {
      ($ifup, $ENV{'QUERY_STRING'}) = split(/\?/, $ifup) if $ifup =~ /\?/;
      ($ifup) = split(/\&/, $ifup);
      $ifup =~ s/\.\.//g;
      if (-e "$admindir_directory/$ifup.pl") {
         require "$admindir_directory/$ifup.pl";
      }
      else {
         die "Can't find upload script: $ifup";
      }
   }
   elsif (!$ENV{'HTTP_USER_AGENT'} or @ARGV) {
      require "$currdir/admin/commandline.pl";
   }
   else {
      if ($full_query =~ /^admin\=admin\&cgi\=templates\.pl/ or $full_query =~ /^admin\=admin\&cgi\=headerfooter\.pl/) {
         require "$admindir_directory/admin_parse.pl";
      }
      else {
         &parse_form;
      }
      if ($FORM{'lightbox'} eq 'update') {
#         close STDIN;
#         close STDOUT;
         require "$libpath/lightbox.pl";
         &update_lightbox;
      }
      elsif ($FORM{'admin'} =~ /^(admin|build)$/) {
         require "$admindir_directory/$FORM{'admin'}.pl";
      }
      elsif (-e "$commercepath/$FORM{'commerce'}.pl") {
         require "$commercepath/$FORM{'commerce'}.pl";
      }
      elsif (-e "$mainpath/$FORM{'main'}.pl") {
         require "$mainpath/$FORM{'main'}.pl";
      }
      else {
         require "$mainpath/imageFolio.pl";
      }
   }
};


if ($@) { print "Content-type: text/html\n\n<pre>Script Error: $@</pre>\n"; }

exit;

###############################################################################
# PARSE THE FORM
# Parses the form input and returns a hash with all the name
# value pairs.
###############################################################################
sub parse_form {
   my ($buffer, $pair, $name, $value);

   if ($ENV{'REQUEST_METHOD'} eq 'GET') {
     if ($FORM{'QUERY_STRING'} && $FORM{'QUERY_STRING'} =~ /&if_cart$/) {
        $ENV{'QUERY_STRING'} = $FORM{'QUERY_STRING'};
        $FORM{'QUERY_STRING'} = ();
     }
     @formpairs = split(/&/, $ENV{'QUERY_STRING'});
#     $post_query = $ENV{'QUERY_STRING'};
   }
   elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
     read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
     $cache_page_age = ();
     $post_query = $buffer if $ENV{'HTTP_USER_AGENT'} eq 'IF_RELAY' or $full_query =~ /^query\=1$/; # Needed for the PayPal code and user login
     @formpairs = split(/&/, $buffer);
   }

   foreach $pair (@formpairs) {
     ($name, $value) = split(/=/, $pair);
     $name =~ tr/+/ /;
     $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ s/\.\.//g;
     $value =~ s/\t//g;
     $value =~ s/\|//g;
     if ($FORM{'admin'} ne 'admin') {
         $value =~ s/(<|\%\W*3\W*c|\&lt)\/?[^>]*(>|\%\W*3\W*e|\&gt)//mig;
         $value =~ s/(<|\%\W*3\W*c|\&lt)//mig;
         $value =~ s/(>|\%\W*3\W*e|\&gt)//mig;
#         $value =~ s/(\(|\%28)//mig;
#         $value =~ s/(\)|\%29)//mig;
     }
     if ($FORM{$name} && ($value) && $name ne "uid") { $FORM{$name} = "$FORM{$name},$value"; }
     elsif ($value) { $FORM{$name} = $value; }
   }
   if ($FORM{'relay'} eq 'cart' && $ENV{'HTTP_USER_AGENT'} ne 'IF_RELAY') {  # Special code for 2checkout.
      $ENV{'HTTP_USER_AGENT'} = 'IF_RELAY'; 
   }
   if ($loginput && $FORM{'admin'} ne 'admin') {
      open (FILE,">$data_directory/logs/${loginput}FORM.txt");
      foreach $key (sort keys %FORM) {
         print FILE "$key: $FORM{$key}\n";
      }
      close(FILE);
      chmod(0777,"$data_directory/logs/${loginput}FORM.txt");
   }
   if (lc($FORM{'cat'}) eq 'all') {$FORM{'cat'} = ();}
   $current_cat = $FORM{'cat'} if $FORM{'cat'};
   $current_cat = $FORM{'direct'} if $FORM{'direct'};
   $current_cat = $FORM{'link'} if $FORM{'link'};
   if (($FORM{'search'} eq 'USER') && $FORM{'username'}) {
      $FORM{'username'} =~ s/[$deny_chars]//g;
      $FORM{'search'} = "USER~$FORM{'username'}";
   }
   ($current_cat_root) = split (/\//, $current_cat);
}

