

#require "$config_directory/mysql_config.pl";

die "should be using mysqlV2.pl";
   eval qq{require "DBI.pm";} or &Error("Could not load DBI.<br>Please install the perl DBI module.");

##################################################################
#   To install on win32:
#   1) In DOS prompt enter "ppm"
#   2) ppm> install DBI
#   3) ppm> install DBD-mysql
#
#   The latest version of ppm (version 4) starts in GUI mode and does not include the DBD-mysql module. So do this:
#
#   1) In DOS prompt enter "ppm-shell"
#   2) ppm> install DBI
#   3) ppm> install http://theoryx5.uwinnipeg.ca/ppms/DBD-mysql.ppd
#
#   Or you can use do this:
#
#   1) In DOS prompt enter "ppm-shell"
#   2) ppm> rep add uwinnipeg http://cpan.uwinnipeg.ca/PPMPackages/10xx/
#   3) ppm> rep 2 (assuming that the repository you just added is the #2)
#   4) ppm> install DBI
#   5) ppm> install DBD-mysql
##################################################################


#&mysql_connect("advsearch");
#&mysql_create_table("advsearch");
#&mysql_disconnect("advsearch");


sub mysql_config {
   my $input = shift;
   my ($mysql_table_name, %mysql_fields) = &{"config_$input"};
   my %mysql_required = ();
   $mysql_required{$_} = 1 foreach @{$mysql_fields{"REQUIRED"}};
   delete($mysql_fields{"REQUIRED"});
   %mysql_columns = ();
   my $mysql_columns_cnt = 0;
   foreach my $key (sort keys %mysql_fields) {
      $mysql_columns{$mysql_fields{$key}[0]}[0] = lc($mysql_fields{$key}[0]);
      $mysql_columns{$mysql_fields{$key}[0]}[0] =~ s/[^0-9a-zA-Z]/_/g;
      $mysql_columns{$mysql_fields{$key}[0]}[1] = $key;
      $mysql_columns_cnt++;
      $mysql_columns_cnt = sprintf "%03d", $mysql_columns_cnt;
      $mysql_columns{$mysql_fields{$key}[0]}[2] = "sort_$mysql_columns_cnt";
      delete($mysql_required{$mysql_fields{$key}[0]});
   }
   foreach my $key (keys %mysql_required) {
      $mysql_columns{$key}[0] = lc($key);
      $mysql_columns_cnt++;
      $mysql_columns_cnt = sprintf "%03d", $mysql_columns_cnt;
      $mysql_columns{$key}[2] = "sort_$mysql_columns_cnt";
   }
   return ($mysql_table_name, %mysql_fields);
}


sub mysql_connect {
   my $input = shift;
   $DBH = "DBH_$input";
   $$DBH = DBI->connect("DBI:$mysql_db:$mysql_name:$mysql_host", $mysql_username, $mysql_password) or &Error("Could not connect to database. Reason: " . $DBI::errstr);
}

sub mysql_create_table {
   my $input = shift;
   &mysql_connect($input) if $DBH ne "DBH_$input";
   my ($mysql_table_name, %mysql_fields) = &mysql_config($input);
   my $createT = ();
#   my %KEYS = ();
   &mysql_drop_table($input);
   foreach my $key (sort {$mysql_columns{$a}[2] cmp $mysql_columns{$b}[2]} keys %mysql_columns) {
      $createT .= "$mysql_columns{$key}[0] MEDIUMTEXT,";
      next;
      if (lc($mysql_fields{$mysql_columns{$key}[1]}[3]) eq 'text') {
         $createT .= "$mysql_columns{$key}[0] MEDIUMTEXT,";
      }
      elsif ($mysql_fields{$mysql_columns{$key}[1]}[3] =~ /^(number|date)$/i) {
         $createT .= "$mysql_columns{$key}[0] BIGINT,";
      }
      elsif (!$mysql_fields{$mysql_columns{$key}[1]}[3] && $key =~ /^(IF_DATE|IF_HITS|IF_RATES)$/i) {
         $createT .= "$mysql_columns{$key}[0] TINYINT,";
      }
      else {
         $createT .= "$mysql_columns{$key}[0] TEXT,";
      }
   }
   $createT =~ s/,$//;
   $$DBH->do(qq{CREATE TABLE $mysql_table_name (id SERIAL,$createT,PRIMARY KEY (id))}) or &Error("Could not create database table!<br>Rreason: " . $$DBH->errstr);
   return ($mysql_table_name, %mysql_fields);
}

sub mysql_get_columns {
   my $input = shift;
   my ($mysql_table_name, %mysql_fields) = &mysql_config($input);
   my @getC = ();
#   foreach my $key (sort {$mysql_columns{$a}[2] cmp $mysql_columns{$b}[2]} keys %mysql_columns) {
#      push (@getC,$key);
#   }
   push (@getC, $_) foreach (sort {$mysql_columns{$a}[2] cmp $mysql_columns{$b}[2]} keys %mysql_columns);
   return @getC;
}

sub mysql_insert_row {
   my ($input, $mysql_table_name, $fields, @values) = @_;
   &mysql_connect($input) if $DBH ne "DBH_$input";
   my $values = ();
   $values .= $$DBH->quote($_) . "," foreach @values;
   $values =~ s/,$//;
   $$DBH->do(qq{INSERT INTO $mysql_table_name ($fields) VALUES ($values);});
}

sub mysql_delete_row {
   my ($input, $where) = @_;
   &Error("Not allows to remove all DB fields. Create a new table instead.") unless $where;
   &mysql_connect($input) if $DBH ne "DBH_$input";
   my ($mysql_table_name, %mysql_fields) = &mysql_config($input);
   $$DBH->do(qq{DELETE FROM $mysql_table_name WHERE $where});
}

sub mysql_select {
   my ($input, $mysql_table_name, $where, $sort, @fields) = @_;
   &mysql_connect($input) if $DBH ne "DBH_$input";
   my $fields = join(', ', @fields);
   $sort = "ORDER BY $sort" if $sort;
   my $query = qq|SELECT $fields FROM $mysql_table_name WHERE $where $sort|;


   my $qry = $$DBH->prepare ($query) or &Error("Unable to query database. Reason: $DBI::errstr. Query: $query");
   $qry->execute or &Error("Unable to query database. Reason: $DBI::errstr. Query: $query");
   my @matrix = ();
   while (my @ary = $qry->fetchrow_array) {
      for my $m (0 .. $#ary) {
         $ary[$m] =~ s/ $//g;
         $ary[$m] =~ s/^ //g;
      }
      push(@matrix, [@ary]);
   }
   $qry->finish;
   return @matrix;


#   $$DBH->do(qq{SELECT $fields FROM $mysql_table_name WHERE $where $sort});
}

sub mysql_drop_table {
   my ($input) = @_;
   &mysql_connect($input) if $DBH ne "DBH_$input";
   my ($mysql_table_name, %mysql_fields) = &mysql_config($input);
   eval {$$DBH->do(qq{DROP TABLE $mysql_table_name});};
}

sub mysql_disconnect {
   my $input = shift;
   &mysql_connect($input) if $DBH ne "DBH_$input";
   $$DBH->disconnect or &Error("Could not disconnect from database. Reason: " . $DBI::errstr);
}


1;