####CODEHEADER###

###############################################################################
# SEARCH
# Performs the search on the image database created by build.pl
###############################################################################
sub search {

   require "$libpath/thumbnails.pl";

   if ($FORM{'search'} =~ /^mysql:/g) {
       $searchphrase = "MySQL Search Result";
       $newthisdirectory = $searchphrase;
      ($blah, $cachefile) = split(/\:/, $FORM{'search'});
      $query = $FORM{'search'};
      $cacheloc = "$cache_directory/searches/$cachefile.mysql";
      &search_cache if -e $cacheloc;
   }
   else {
      $using_mysql = ();
      $FORM{'search'} =~ s/\(//g;
      $FORM{'search'} =~ s/\)//g;
      $FORM{'search'} =~ s/\// /g;            # Replace frontslashes with a space
      $FORM{'search'} =~ s/\\/ /g;            # Replace backslashes with a space
      $FORM{'search'} =~ s/\|/ /g;            # Replace pipe characters with a space
      $FORM{'search'} =~ s/\,//g;
      $FORM{'search'} =~ s/^\s+//g;           # Trim leading blanks
      $FORM{'search'} =~ s/\s+$//g;           # Trim trailing blanks
      $FORM{'search'} =~ s/\s+\s+/ /g;        # Change two spaces to one.
      $FORM{'search'} =~ s/\s+\s+/ /g;        # Change two spaces to one again

      if ($FORM{'search'} eq "NEW") {
         $searchphrase = "Newly Added";
         $newthisdirectory = $searchphrase;
         $sortfiles = 1;
         $display_sort = 1;
         if ($show_new_cats) {
            $do_show_cat_search = 1;
            if (!$FORM{'cat'}) {
               require "$libpath/direct.pl";
               $force_cachereload = 1;
               $do_cat_search = 1;
            }
         }
      }
      elsif ($FORM{'mailing'}) {
         $FORM{'search'} eq "NEW";
         $searchphrase = "Mailing #: $FORM{'mailing'}";
         $newthisdirectory = $searchphrase;
         $sortfiles = 1;
         $display_sort = 1;
         $do_show_mail_search = 1;
         require "$libpath/direct.pl";
         $force_cachereload = 1;
         $do_mail_search = 1;
   #      $do_cat_search = 1;
      }
      elsif ($FORM{'search'} eq "HITS") {
         $searchphrase = "Top Hits";
         $newthisdirectory = $searchphrase . $pretty_date;
         $sortfiles = 1;
         $display_sort = 3;
      }
      elsif ($FORM{'search'} eq "RATES") {
         $searchphrase = "Top Ratings";
         $newthisdirectory = $searchphrase . $pretty_date;
         $sortfiles = 1;
         $display_sort = 4;
      }
      elsif ($FORM{'search'} eq "RANDOM") {
         $searchphrase = "Random Display";
         $newthisdirectory = $searchphrase;
         $sortfiles = 5;
         $display_sort = 5;
      }
      elsif ($FORM{'search'} =~ /^USER~/) {
         ($blah, $search_user) = split(/~/, $FORM{'search'});
         $searchphrase = "Uploads from $search_user";
         $newthisdirectory = $searchphrase;
      }
      elsif ($FORM{'search'} eq "APPROVE" && $is_admin) {
         $searchphrase = "Pending Approvals";
         $newthisdirectory = $searchphrase . $pretty_date;
         $sortfiles = 1;
         $display_sort = 1;
      }
      else {
         $searchphrase = "Search Results";
         $newthisdirectory = $searchphrase . " for " . $FORM{'search'};
      }

      $query = $FORM{'search'};
      $query =~ s/([^a-zA-Z0-9\~])/'%' . sprintf("%2x", ord($1))/ge;

      my $pos = $FORM{'img'};
      my($SIZE,$i);

      @results = ();
      @search = split(/\s+/, $FORM{'search'});

      if (!$FORM{'cat'}) { $cat = "all"; }
      else { $cat = $FORM{'cat'}; }
      if (!$FORM{'img'}) { $FORM{'img'} = "0"; }

      $cachefilename = "search~$FORM{'search'}";
      $cachefilename .= ".$FORM{'cat'}" if $FORM{'cat'};
      $cachefilename .= ".$FORM{'bool'}" if $FORM{'bool'};
      $cachefilename .= ".sort5" if ($sortfiles == 5);
      $cachefilename .= ".$group_group_name" if $group_group_name;
      $cachefilename .= ".is_admin" if $is_admin;
      $cachefilename =~ s/[^0-9a-zA-Z\_]/~/g;
      $cacheloc = "$cache_directory/searches/$cachefilename";

      if ($using_mysql) {
         if ($FORM{'search'} =~ /^USER~/) {
            if (-e "$cacheloc") { 
               if ((-M "$cacheloc" <= $cache_date) && !$force_cachereload) { &search_cache; }
               else { &search_index; }
            }
            else {
               &search_index;
            }
         }
         elsif ($FORM{'search'} eq "APPROVE" && $is_admin) {
            if (-e "$cacheloc") { 
               if ((-M "$cacheloc" <= $cache_date) && !$force_cachereload) { &search_cache; }
               else { &search_index; }
            }
            else {
               &search_index;
            }
         }
         else {
            require "$libpath/mysql.pl";
            if (-e "$cacheloc") { 
               if (-M "$cacheloc" <= $cache_date && !$force_cachereload) { &search_cache; }
               else { &search_db; }
            }
            else {
               &search_db;
            }
         }
      }
      else {
         if (-e "$cacheloc") { 
            if ((-M "$cacheloc" <= $cache_date) && !$force_cachereload) { &search_cache; }
            else { &search_index; }
         }
         else {
            &search_index;
         }
      }
   }


   &build_pull_down_menu;
   &get_page_number;
   if ($found) {
      &build_thumbnail_table;
      &build_nextprev_links;
   }
   if (!$is_admin && $search_log) {
      &log_searches;
   }
   &build_nav;
   &get_template;
}

###############################################################################
# SEARCH CACHE
# Pulls in the results from a previous search and saves a lot of time!!
###############################################################################
sub search_cache {
   @names = ();
   @LINES = ();
   $totalnames = ();
   $found = ();
   open (FILE,"$cacheloc") or &Error("Can't Open $cacheloc: $!");
   my(@LINES)=<FILE>;
   close(FILE);

   foreach (@LINES) {
      $found = 1;
      my ($blah,$name,$path,$filedate,$hits,$votes) = split(/\|/, $_);
      push(@names, "$name|$path|$filedate|$hits|$votes");
      if ($sortfiles == 3) {
         push(@idx, $hits);
      }
      elsif ($sortfiles == 4) {
         push(@idx, $votes);
      }
   }


   if ($sortfiles == 2) {
      @names = sort { lc($a) cmp lc($b) } @names;
   }
   elsif (($sortfiles == 3) or ($sortfiles == 4)) {
      @names = @names[ sort { $idx[$b] <=> $idx[$a] } 0 .. $#idx ];
   }

   $totalnames=@names;
   if (!$found && !$imageThumb_cgi) {
      if ($search_user) {
         &search_error("No uploads from $search_user were found.");
      }
      else {
         &search_error("No results matched your search.");
      }
      $num = "0";
   }
}

sub access_search {
   my ($db_line, $path) = @_;
   return if ($add_user_category && $path =~ /^$main_users_cat\//);
   if ($allow_free_access) {
      push(@results, $db_line);
      $kill++;
   }
   else {
      foreach $this_cat_access (@current_cat_access) {
         if ($path =~ /^$this_cat_access/i) {
            push(@results, $db_line);
            $kill++;
            last;
         }
      }
   }
}

sub access_search_CAT {
   my ($date, $path, $newfiles) = @_;
   return if ($add_user_category && $path =~ /^$main_users_cat\//);
   if ($allow_free_access) {
      push(@subdirectories, "$path|$newfiles|$date");
      push(@sortsubs, $date);
   }
   else {
      foreach $this_cat_access (@current_cat_access) {
         if ($path =~ /^$this_cat_access/i) {
            push(@subdirectories, "$path|$newfiles|$date");
            push(@sortsubs, $date);
            last;
         }
      }
   }
}

###############################################################################
# SEARCH INDEX
# Performs the actual searching of the index file (database)
###############################################################################
sub search_index {

   if ($do_mail_search) {
      open (MAILFILE,"$sessions_dir/$FORM{'mailing'}.mailing_sent") or &Error("Can't Open $FORM{'mailing'} file. Reason $!");
      my(@MAILFILE)=<MAILFILE>;
      close(MAILFILE);
      chomp @MAILFILE;
      my @mailingcats = split(/\,/, $MAILFILE[0]);
      foreach my $mailingcat (@mailingcats) {
         $MAILCAT{$mailingcat} = 1;
      }
      open (CATS,"$catfile") or &Error("Can't Open $catfile, is it created?: $!");
      my(@CATS)=<CATS>;
      close(CATS);
      chomp @CATS;
      foreach my $cat (@CATS) {
         my ($path,$files,$date,$newfiles) = split(/\t/, $cat);
         next unless $MAILCAT{$path};
         push(@subdirectories, "$path|$newfiles|$date");
         push(@sortsubs, $date);
      }
      if (@subdirectories) {
         @subdirectories = @subdirectories[ sort { $sortsubs[$b] <=> $sortsubs[$a] } 0 .. $#sortsubs ];
         $maxsubdirectory = ();
         $found = 1;
         $cat_columns = ();
         $direct_link = "$imagefolio_url?direct=";
         &build_subcategory_list;
      }
      else {
         &search_error("No Mailing Categories Found.");
      }
   }
   elsif ($do_cat_search) {
      open (CATS,"$catfile") or &Error("Can't Open $catfile, is it created?: $!");
      my(@CATS)=<CATS>;
      close(CATS);
      chomp @CATS;
      foreach my $cat (@CATS) {
         my ($path,$files,$date,$newfiles) = split(/\t/, $cat);
         if ($newfiles > 0) {
            if ($FORM{'cat'}) {
               if ($path =~ /^$FORM{'cat'}/ig) {
                  &access_search_CAT($date, $path, $newfiles);
               }
            }
            else {
               &access_search_CAT($date, $path, $newfiles);
            }
         }
      }
      if (@subdirectories) {
         @subdirectories = @subdirectories[ sort { $sortsubs[$b] <=> $sortsubs[$a] } 0 .. $#sortsubs ];
         $maxsubdirectory = ();
         $found = 1;
         $cat_columns = ();
         $direct_link = "$imagefolio_url?search=NEW&cat=";
         &build_subcategory_list;
      }
      else {
         &search_error("No New Categories Found.");
      }
   }
   else {

      open (FILE,"$indexfile") or &Error("Can't Open $indexfile, is it created?: $!");
      my(@LINES)=<FILE>;
      close(FILE);

      my ($index_time)  = (stat($indexfile))[9];

   #   if ($FORM{'search'} eq "RANDOM") { &shuffle(\@LINES); }
   #   else { @LINES = sort { lc($a) cmp lc($b) } @LINES; }

      $SIZE=@LINES;
   #   $totalnames = 0;
      $d = 0;
      $numwords = @search;

      if ($search_exact_only) {
         $searchspace = " ";
      }

      while ($d < $SIZE) {

         my ($name,$path,$filedate,$keywords1,$keywords2,$hits,$votes,$custom18_user,$custom18_approval) = split(/\|/, $LINES[$d]);
         my $matchcount;
         my $kill;
         my $searchable = "$name $path $keywords1 $keywords2";

         if ($custom18_approval && !$is_admin) {
               $d++;
               next;
         }

         foreach $search (@search) {

            if ($FORM{'search'} eq "NEW") {
               my $elapsed = ($index_time - $filedate) / 86400; # 86400 sec = 1 day
               if ($elapsed <= $new_date) {
                  my $dbline = "$filedate|$name|$path|$filedate|$hits|$votes|";
                  if ($FORM{'cat'}) {
                     if ($show_new_cats) {
                        if ($path eq $FORM{'cat'}) {
                           &access_search($dbline, $path);
                           last;
                        }
                     }
                     elsif ($path =~ /^$FORM{'cat'}/ig) {
                        &access_search($dbline, $path);
                        last;
                     }
                  }
                  else {
                     &access_search($dbline, $path);
                     last;
                  }
               }
            }
            elsif ($FORM{'search'} eq "HITS") {
               if ($hits > 0) {
                  my $dbline = "$hits|$name|$path|$filedate|$hits|$votes|";
                  if ($FORM{'cat'}) {
                     if ($path =~ /^$FORM{'cat'}/ig) {
                        &access_search($dbline, $path);
                        last;
                     }
                  }
                  else {
                     &access_search($dbline, $path);
                     last;
                  }
               }
            }
            elsif ($FORM{'search'} eq "RATES") {
               if ($votes > 0) {
                  my $dbline = "$votes|$name|$path|$filedate|$hits|$votes|";
                  if ($FORM{'cat'}) {
                     if ($path =~ /^$FORM{'cat'}/ig) {
                        &access_search($dbline, $path);
                        last;
                     }
                  }
                  else {
                     &access_search($dbline, $path);
                     last;
                  }
               }
            }
            elsif ($FORM{'search'} eq "RANDOM") {
               my $dbline = "$filedate|$name|$path|$filedate|$hits|$votes|";
               if ($FORM{'cat'}) {
                  if ($path =~ /^$FORM{'cat'}/ig) {
                     &access_search($dbline, $path);
                     last;
                  }
               }
               else {
                  &access_search($dbline, $path);
                  last;
               }
            }
            elsif ($search_user) {
               if ($search_user eq $custom18_user) {
                  my $dbline = "$filedate|$name|$path|$filedate|$hits|$votes|";
                  if ($FORM{'cat'}) {
                     if ($path =~ /^$FORM{'cat'}/ig) {
                        &access_search($dbline, $path);
                        last;
                     }
                  }
                  else {
                     &access_search($dbline, $path);
                     last;
                  }
               }
            }
            elsif ($FORM{'search'} eq "APPROVE" && $is_admin) {
               if ($custom18_approval) {
                  my $dbline = "$filedate|$name|$path|$filedate|$hits|$votes|";
                  if ($FORM{'cat'}) {
                     if ($path =~ /^$FORM{'cat'}/ig) {
                        &access_search($dbline, $path);
                        last;
                     }
                  }
                  else {
                     &access_search($dbline, $path);
                     last;
                  }
               }
            }
            elsif ($FORM{'bool'} eq "and") {  # bool = and
               if ($searchable =~ /$searchspace$search$searchspace/i) {
                  $matchcount++;
                  if ($matchcount >= $numwords) {
                     my $dbline = "$filedate|$name|$path|$filedate|$hits|$votes|";
                     if ($FORM{'cat'}) {
                        if ($path =~ /^$FORM{'cat'}/ig) {
                           &access_search($dbline, $path);
                           last;
                        }
                     }
                     else {
                        &access_search($dbline, $path);
                        last;
                     }
                  }
               }
            }
            elsif ($FORM{'bool'} eq "phrase") {  # bool = phrase
               if ($searchable =~ /$searchspace$FORM{'search'}$searchspace/i) {
                  my $dbline = "$filedate|$name|$path|$filedate|$hits|$votes|";
                  if ($FORM{'cat'}) {
                     if ($path =~ /^$FORM{'cat'}/ig) {
                        &access_search($dbline, $path);
                        last;
                     }
                  }
                  else {
                     &access_search($dbline, $path);
                     last;
                  }
               }
            }
            elsif ($searchable =~ /$searchspace$search$searchspace/i) {  # bool = or
               my $dbline = "$filedate|$name|$path|$filedate|$hits|$votes|";
               if ($FORM{'cat'}) {
                  if ($path =~ /^$FORM{'cat'}/ig) {
                     &access_search($dbline, $path);
                     last;
                  }
               }
               else {
                  &access_search($dbline, $path);
                  last;
               }
            }
            next if ($kill);
         }
         $d++;
      }
      @LINES = ();
      &cache_results;
   #   if (!$found) {
   #      if ($search_user) {
   #         &search_error ("No uploads from $search_user were found.");
   #      }
   #      else {
   #         &search_error ("No results matched your search.");
   #      }
   #      $num = "0";
   #   }
   #   @results = ();
   }
}

###############################################################################
# CACHE RESULTS
# Caches the search results to an external file so we don't have to perform
# any searching at all after the first page of thumbnails.
###############################################################################
sub cache_results {

   open (CACHE,">$cacheloc") or &Error("Unable to create cache file at $cacheloc: $!");

#   if (!$sortfiles) {
#      @results = sort { $b <=> $a } @results;
#   }


   if ($show_unique_only) {
      foreach (@results) {
         my ($blah,$name) = split(/\|/, $_);
         push(@results_sort, $name);
      }

      @results = @results[ sort { lc($results_sort[$a]) cmp lc($results_sort[$b]) } 0 .. $#results_sort ];

      my @temp_results = @results;
      @results = ();
      foreach (@temp_results) {
         my ($blah,$name) = split(/\|/, $_);
         if (!exists($found{lc($name)})){
            $found{lc($name)} = 1;
            push(@results, $_);
            
         }
      }
   }

   if (($sortfiles == 5) && @results) {
      &shuffle(\@results);
   }
   else {
      @results = sort { $b <=> $a } @results;
   }

   foreach (@results) {
#      my ($blah,$name,$path,$filedate,$keywords1,$keywords2,$hits,$votes,$custom18_user,$custom18_approval) = split(/\|/, $_);
#      my $dbline = "$name|$path|$filedate|$keywords1|$keywords2|$hits|$votes|$custom18_user|$custom18_approval|";
#      print CACHE $dbline . "\n";
      print CACHE "$_\n";
#      push(@names, $dbline);
#      if ($sortfiles == 1) {
#         push(@idx, $filedate);
#      }
#      elsif ($sortfiles == 3) {
#         push(@idx, $hits);
#      }
#      elsif ($sortfiles == 4) {
#         push(@idx, $votes);
#      }
   }
   close(CACHE);
   chmod(0777,"$cacheloc");

   if ($is_admin) {
      $search_session_file = "$sessions_dir/admin.$COOKIE{'IF_UID'}.search";
   }
   elsif (!$confirmed_guest){
      $search_session_file = "$sessions_dir/$ifusername/search.user";
   }
   else {
      $search_session_file = "$sessions_dir/$user_session_id.search";
   }
   $Pcacheloc = $cacheloc;
   $Pcacheloc =~ s/^$cache_directory\/searches\///g;
   open (FILE,">$search_session_file");
   print FILE $Pcacheloc;
   close(FILE);
   chmod(0777,"$search_session_file");

   if ($FORM{'from_link'}) {
      print "Location:$imagefolio_redirect_url?action=view&link=$FORM{'from_link'}&image=$FORM{'image'}&img=$FORM{'img'}&tt=$FORM{'tt'}&search=$FORM{'search'}&cat=$FORM{'cat'}&bool=$FORM{'bool'}\n\n";
      exit;
   }
   else {
      &search_cache;
   }

#   if ($sortfiles) {
#      if ($sortfiles == 1) {
#         @names = sort { $b <=> $a } @db_lines;
#      }
#      elsif ($sortfiles == 2) {
#         @names = @db_lines;
#      }
#      elsif (($sortfiles == 3) or ($sortfiles == 4)) {
#         @names = @db_lines[ sort { $idx[$b] <=> $idx[$a] } 0 .. $#idx ];
#      }
#      elsif ($sortfiles == 5) {
#         @names = @db_lines;
#         &shuffle_direct(\@names);
#      }
#  }


}


###############################################################################
# BUILD NEXTPREV LINKS
# Generate links to additional image pages and next/previous links if necessary
###############################################################################
sub build_nextprev_links {

   $num = $totalnames;
   $calc = int(($num / $numtolist)+ '0.99');
   if (!$numtolist)  { $numtolist = 8; }
   $base = $numtolist;
   $factor_min = $FORM{'img'} - ($pages_ahead_count * $numtolist);
   $factor_plus = $FORM{'img'} + ($pages_ahead_count * $numtolist);

   if (!$FORM{'img'} or $FORM{'img'} eq "0") {
      $FORM{'img'} = "0";
      $nextfactors = $numtolist;
      $nextlinks .= qq|(<b>1</b>) |;
      $thisfactor = 1;
   }
   elsif ($factor_min <= 0 ) {
      $nextlinks .= qq|<b><a href="$imagefolio_url?search=$query&img=0&cat=$FORM{'cat'}&bool=$FORM{'bool'}">1</a></b> |;
   }


   foreach $factor(2..$calc) { 
      $factors = (($base * $factor) - $base);

      if ($FORM{'img'} == $factors) {
         $nextfactor = $factor + 1;
         $nextfactors = (($base * $nextfactor) - $base);
         $prevfactor = $factor - 1;
         $prevfactors = (($base * $prevfactor) - $base);
         $thisfactor = $factor;
         $nextlinks .= qq|(<b>$factor</b>) |;
      }
      elsif (($factors >= $factor_min) && ($factors <= $factor_plus)) {
         $nextlinks .= qq|<b><a href="$imagefolio_url?search=$query&img=$factors&cat=$FORM{'cat'}&bool=$FORM{'bool'}">$factor</a></b> |;
      }

   $lastfactor = $factor;
   }

   if ($lastfactor > $thisfactor) {
      $next_page_link = "$imagefolio_url?search=$query&img=$nextfactors&cat=$FORM{'cat'}&bool=$FORM{'bool'}";
      $nextpage = qq|<a href="$next_page_link">Next [&gt;&gt;]</a>|;
   }
   else {
      $next_page_link = "";
      $nextpage = "";
   }

   if (!$FORM{'img'} or $FORM{'img'} eq "0") {
      $previous_page_link = "";
      $prevpage = "";
   }
   else {
      $previous_page_link = "$imagefolio_url?search=$query&img=$prevfactors&cat=$FORM{'cat'}&bool=$FORM{'bool'}";
      $prevpage = qq|<a href="$previous_page_link">[&lt;&lt;] Prev</a> |;
   }

   if ($num > $numtolist) { $page = "pages"; }
   else { $page = "page"; }

   if ($num == 1) { $image = "file"; }
   else { $image = "files"; }

   if ($most = $RESULTS) {
      if ($quickdisplay) {
         $pageinfo = qq|$num $image found|;
      }
      else {
         $pageinfo = qq|$num $image found on $calc $page.<br>Displaying $numtolist files per page.</font></b><br>|;
      }
   }
}


###############################################################################
# GET PAGE NUMBER
# Figures out where we are in the search results and uses that in the link bar
###############################################################################
sub get_page_number {

   $pagelinks  = qq|<$font><a href="$imagefolio_url">Top</a> &gt; |;
   if ($do_show_cat_search && $FORM{'cat'}) {
      if ($FORM{'cat'} =~ /\//) {
         my ($currcat, $lastcat) = $FORM{'cat'} =~ m#^(.*)\/(.*)#;
         $thisdir = get_clean_name($lastcat);
      }
      else {
         $thisdir = get_clean_name($FORM{'cat'});
      }
      $pagelinks .= qq|<a href="$imagefolio_url?search=$query&bool=$FORM{'bool'}">$searchphrase</a> &gt; |;
      if ($totalnames > $numtolist) {
         $pagelinks .= qq|<a href="$imagefolio_url?search=$query&img=0&cat=$FORM{'cat'}&bool=$FORM{'bool'}">$thisdir</a>|;
      }
      else {
         $pagelinks .= qq|$thisdir|;
      }
   }
   else {
      $pagelinks .= qq|$searchphrase|;
   }
#   else {
#      $pagelinks .= qq|<a href="$imagefolio_url?search=$query&img=0&cat=$FORM{'cat'}&bool=$FORM{'bool'}">$searchphrase</a>|;
#   }

   if ($totalnames > $numtolist) {
      if ($FORM{'img'}) { $imagecount = $FORM{'img'}; }
      else { $imagecount = "0"; }
      $pagenumber = int($imagecount / $numtolist);
      $pagenumber++;

      if ($pagenumber eq "1") { $pagelinks .= qq| &gt; Page 1</font>|; }
      else { $pagelinks .= qq| &gt; Page $pagenumber</font>|; }
   }
}

###############################################################################
# SHUFFLE
# Shuffles the array containing our index.txt file to display random images
###############################################################################
sub shuffle {
   my $results = shift;
   my $l;
   for ($l = @$results; --$l; ) {
      my $m = int rand ($l+1);
      next if $l == $m;
      @$results[$l,$m] = @$results[$m,$l];
   }
}

###############################################################################
# Error
# shows error message if form not filled out correctly
###############################################################################
sub search_error{

   $totalnames = 1;
   local ($whoops) = @_;

   $thumbimages = qq|<tr bgcolor="$thumb_table_bgcolor"><td><br><br><center>
   <font face="Verdana,Arial,Helvtica" size=2><b><font color="#ff0000">$whoops</font></b>
   <br>You may search again<br>or, <a href="javascript:history.go(-1);">return to
   the previous page</a>.</font><br><br><br></td></tr>|;

}

###############################################################################
# SEARCH LOG
# Logges the seaches in "data/loggedsearches.html"
###############################################################################
sub log_searches {
   $search_log = "$logdir/$search_log";
   if (! -e $search_log) {
      $log_page_contents = "QUERY\tCATEGORY\tBOOLEAN\tFOUND\tDATE/TIME\tUSER\tIP\n";
   }

   ($sec,$min,$hour,$mday,$mon,$year) = (localtime(time))[0,1,2,3,4,5];
   $time = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
   $year += 1900;
   $mon++;
   $datetime = sprintf "%04d-%02d-%02d %02d:%02d:%02d",  $year, $mon, $mday, $hour, $min, $sec;

   if ($ifusername) {
      $log_user = $ifusername;
   }
   elsif ($is_admin) {
      $log_user = "Administrator";
   }
   else {
      $log_user = $guest_username;
   }

   $log_page_contents .= "$FORM{'search'}\t$cat\t$FORM{'bool'}\t$num\t$datetime\t$log_user\t$ENV{'REMOTE_ADDR'}\n";

   open(SEARCH,">>$search_log") or &Error("Can't Open Search Log: $!");
   print SEARCH $log_page_contents;
   close(SEARCH);
   chmod(0777,"$search_log");
}


1;
