####CODEHEADER###

###############################################################################
# GEN IMAGE TABLE
# Makes the all important table containing images and image data
###############################################################################

foreach my $field (@iptc_thumbnails_fields) {
   $IPTC_THUMB_INFO{$field}=1;
}

foreach my $field (@iptc_thumbnails_popup_fields) {
   $IPTC_THUMB_POPUP{$field}=1;
}

push(@iptc_thumbnails_fields, @iptc_thumbnails_popup_fields);

if (@iptc_thumbnails_fields or $save_upload_date or $using_picturepost_mod or (lc($myextension_fullsize) eq 'zip')) {
   require "$libpath/iptc.pl";
}

sub get_template {

   open (TEMPLATE,"$thumb_template") or &Error("Could not open template.  Reason $!");
   while (<TEMPLATE>) {
     if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_include($2); }
     elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_exec_include($2); }
     else { $template .= $_; }
   }
   close(TEMPLATE);

   require "$libpath/headerfooter.pl";

   $template =~ s/%%%TEXTNAV%%%/$textnav/ig;
   
   if ($use_textlinks) {
      $template =~ s/%%%NAV%%%/<$font>$textnav<\/font>/ig;
   }
   else {
      $template =~ s/%%%NAV%%%/$nav/ig;      
   }
   
   $template =~ s/%%%QUERY%%%/$newthisdirectory/ig;
   $newthisdirectory =~ s/<[\/]?[^>]*>//mig;
   $template =~ s/%%%PAGEQUERY%%%/$newthisdirectory/ig;
   $template =~ s/%%%PAGELINKS%%%/$pagelinks/g;
   $template =~ s/%%%SUBCATEGORIES%%%/$subcatlinks/ig;
   $template =~ s/%%%PREVIOUS_PAGE%%%/$prevpage/ig;
   $template =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $template =~ s/%%%JS_ROLLOVERS%%%/$jsrollovers/ig;
   $template =~ s/%%%TEXTPULLDOWN_MENU%%%/$textpulldown_menu/ig;
   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;

   if ($totalnames >= 1) { $template =~ s/%%%THUMBNAILS%%%/$thumbimages/ig; }
   if ($totalnames > $numtolist) {
     $template =~ s/%%%PAGES_LINKED%%%/$nextlinks/ig;
     $template =~ s/%%%NEXT_PAGE%%%/$nextpage/ig;
   }
   $template =~ s/%%%SEARCH_INFO%%%/$pageinfo/ig;
   $template =~ s/%%%PULLDOWN_MENU%%%/$pulldown_menu/ig;
   $template =~ s/%%%SEARCH_BOX%%%/$search_box/ig;
   $template =~ s/%%%PREVIOUS_CATEGORY%%%/$previous_category/ig;
   $template =~ s/%%%NEXT_CATEGORY%%%/$next_category/ig;
   $template =~ s/%%%PRINTBUTTON_ADD_SELECTED%%%/<script language="Javascript">addtobasket("$PrintButton{'add_selected'}")<\/script>/ig if $use_printbutton;

#   if ($is_admin) {
#      $if_javascript .= &admin_js_popup;
#      if ($FORM{'direct'}) {
#         $admin_tools = &create_tools;
#         $template =~ s/%%%ADMIN_TOOLS%%%/$admin_tools/ig;
#      }
#   }

   $if_javascript .= qq|<script type="text/javascript" src="$base_if_url/overlib421/overlib.js"><!-- overLIB (c) Erik Bosrup --></script>|;

   $template =~ s/%%%IF_JAVASCRIPT%%%/$if_javascript/ig;

   if ($previous_category or $prevpage or $nextpage or $next_category) {
      $template =~ s/%%%BOTTOM_NAV_BEGIN%%%/-->/ig;
      $template =~ s/%%%BOTTOM_NAV_END%%%/<\!--/ig;
   }
}


sub get_thumbcaps {

   @thumbcaps = ();
   $newlink  = $path;
   $newlink  =~ s/\//\./g;
   $newcaplink = "$data_directory/$newlink.tcaptions.txt";

   if (-e $newcaplink && $if2_thumbcaption) {
      open (CAPTIONS,"< $newcaplink");
      while (<CAPTIONS>) {
         chomp;
         push(@thumbcaps, $_);
      }
      close(CAPTIONS);
   }
}

sub get_counts_rating {

   $hits = "0";
   $rated = "0.00";
   $downloads = "0";
   $votes = "0";
   $real_shortname = $shortname;
   $real_shortname =~ s/^$mypattern//g;

   $votefile = "$image_directory/$path/$real_shortname.vote";
   @vote = ();
   if (-e $votefile && $display_rates) {
      open (FILE,"$votefile") or &Error("Could not open $votefile. $!");
      while (<FILE>) {
         ($votes, $rated) = split(/\t/, $_);
         last;
      }
      close(FILE);
   }

   $countfile = "$image_directory/$path/$real_shortname.count";
   @hits = ();
   if (-e $countfile && ($display_hits or $found_downloads)) {
      open (FILE,"$countfile") or &Error("Could not open $countfile.  $!");
      while (<FILE>) {
         ($hits,$blah,$downloads) = split(/\t/, $_);
         last;
      }
      close(FILE);
   }
}

###############################################################################
# BUILD THUMBNAIL TABLE
# build $numtolist thumbnails on a page by reading the array names
###############################################################################
sub build_thumbnail_table {

#   $display_fileinfo = 1;

   if ($display_fileinfo) {
      if ($thumb_info_right) {
         $columns++ if int($columns/2)*2 != $columns;
         $thumb_info_below = ();
         $vthumbalign = "center";
         $vthumbinfoalign = "center";
         $cnt_factor = 2;
      }
      else {
         $thumb_info_below = 1;
         $vthumbalign = "bottom";
         $vthumbinfoalign = "top";
         $thmbrowspan = qq| rowspan="2"|;
         $cnt_factor = 1;
      }
   }
   else {
      $thumb_info_right = ();
      $thumb_info_below = ();
      $vthumbalign = "bottom";
   }

   $imgtable_width_all = int (100 / $columns);
   if ($imgtable_width_all*$columns != 100) {
      $imgtable_width_last = 100-($imgtable_width_all*$columns);
      $imgtable_width_last += $imgtable_width_all;
   }
   else {
      $imgtable_width_last = $imgtable_width_all;
   }
   $imgtable_width_all .= "%";
   $imgtable_width_last .= "%";

   $colspanrow =($columns + $columns) + 1;
   $count=0;
   $alt_text_temp = $alt_text;
   $adjCB = 1;
   $adjCE = 1;
   $adjTB = 1;
   $adjTE = 1;

   $thumbimages .= qq|<tr bgcolor="$thumb_table_border_color"><td align=center><table border="0" cellspacing=0 cellpadding=0 width="100%">|;
   $thumbimages .= qq|<tr bgcolor="$thumb_table_border_color"><td colspan="$colspanrow" height="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td></tr>|;


   if ($FORM{'direct'} or $FORM{'search'}) {
      $skip_next_save_upload_date = 1;
      $save_upload_date = 0;
   }
   if ($FORM{'lightbox'}) {
      $from_lb = "&lbview=$FORM{'lightbox'}";
   }

   my ($i);
   my $img = $FORM{'img'};
   my($most) = $img + $numtolist;
   $SIZE=@names;
   $RESULTS=@names;
   if ($most > $SIZE) { $most = $SIZE; }

   for ($cnt=$img; $cnt < $most; $cnt++) {
      $filesize_done = ();
      $fullsize_link = ();
      $image_checked = 1;
      if ($FORM{'direct'}) {
         ($nulldate, $name) = split(/\t/, $names[$cnt]);
      }
      elsif ($FORM{'search'}) {
         ($name, $path, $nulldate) = split(/\|/, $names[$cnt]);
         $linkimage_exp = 0;
         if (!-e "$image_directory/$path/$name"){
            $linkimage_exp = 1;
         }
      }
      elsif ($FORM{'lightbox'}) {
         ($path, $linkimage, $mykey) = split(/\|/, $names[$cnt]);
         $name = $linkimage . '.' . $mykey;
         $lckey = lc($mykey);
         $extfound = 0;
         $linkimage_exp = 0;
         if (-e "$image_directory/$path/$name"){
            if ($linkimage !~ /^$mypattern/i){
               $extfound = 1;
               if     (-e "$image_directory/$path/$mypattern$linkimage.jpg"){$name = qq|$mypattern$linkimage.jpg|;}
               elsif  (-e "$image_directory/$path/$mypattern$linkimage.JPG"){$name = qq|$mypattern$linkimage.JPG|;}
               elsif  (-e "$image_directory/$path/$mypattern$linkimage.gif"){$name = qq|$mypattern$linkimage.gif|;}
               elsif  (-e "$image_directory/$path/$mypattern$linkimage.GIF"){$name = qq|$mypattern$linkimage.GIF|;}
            }
         }
         else {
            $linkimage_exp = 1;
         }
      }

      if ($FORM{'direct'} or $FORM{'search'} or $imageThumb_cgi) {
         ($linkimage) = $name =~ m,^(.*)\.\w+$,;
         $linkimage =~ s/^$mypattern//g;

         foreach $key (keys %extensions) {
            $lckey = lc($key);
            $uckey = uc($key);
            $extfound = 0;
            $mykey = "";

            if ( -e "$image_directory/$path/$linkimage.$lckey" ) {
               $mykey = $lckey;
               $extfound = 1;
               last;
            }
            elsif ( -e "$image_directory/$path/$linkimage.$uckey" ) {
               $mykey = $uckey;
               $extfound = 1;
               last;
            }
         }
      }

      if ($extfound) {
         $if_filetype            =  $extensions{$lckey}[0];
         $if_link                =  $extensions{$lckey}[1];
         $if_tagfile             =  $extensions{$lckey}[2];
         $if_target              =  $extensions{$lckey}[3];
         $default_icon           =  $extensions{$lckey}[4];
         $linkimage             .= ".$mykey";
         $clink                  =  qq|</a>|;
         $newname                =  $linkimage;
         $admin_image1           =  $linkimage;
         $file_type              =  $if_filetype;
         $default_icon2          =  uc($default_icon);

         if ($imageThumb_cgi) {
            $if_target = "_parent";
         }
         if ($name =~ /^$mypattern/i) { 
            $imagesrc = "$imageurl/$path/$name";
            $admin_image2 = $name;
         }
         else { 
            if (-e "$skin_dir/images/icons/$default_icon") {
               $imagesrc = "$icons_dir/$default_icon";
            }
            else {
               $imagesrc = "$icons_dir/$default_icon2";
            }
            $admin_image2 = "";
         }
         if (($display_filesize or $display_date or $display_downloads) or ($showtotallightboxsize && $FORM{'lightbox'}) or ($use_fullsize && $download_link_under_thumbnail)) {
            &find_size_date($path, $admin_image1, $admin_image2);
            if ($skip_next_save_upload_date) {
               $filedate = $nulldate;
            }
            $filedate               = unix_to_date($filedate);            #convert unix time to a legible day
         }

         if ($no_preview_link) {
            $slink = qq|<a href="javascript:;" onClick="alert('Sorry, you do not have permission to use this feature');return false;"%%%OVERLIB_TEXT%%%>|;
         }
         elsif ($if_link == 1) {
            if ($FORM{'search'}) {
               $slink =  qq|<a href="$imagefolio_url?action=view&link=$path&image=|;
               $slink .= qq|$linkimage&img=$FORM{'img'}&search=$query&cat=$cat&tt=$if_tagfile&bool=$FORM{'bool'}" target="$if_target"%%%OVERLIB_TEXT%%%>|;
            }
            else {
               $slink =  qq|<a href="$imagefolio_url?action=view&link=$path&image=|;
               $slink .= qq|$linkimage&img=$FORM{'img'}&tt=$if_tagfile$from_lb" target="$if_target"%%%OVERLIB_TEXT%%%>|;
            }
         }
         else {
            $slink =  qq|<a href="$imagefolio_url?action=view&link=$path&image=$linkimage&url=1" target="$if_target"%%%OVERLIB_TEXT%%%>|;
         }
      }

      elsif ($linkimage_exp){
         $newname = $name;
         $file_type =  $extensions{$lckey}[0];
         $filesize = 'NaN';
         $filedate = 'NaN';
         $slink = ();
         $clink = ();
         $if_filetype = "File Not Found";
         $imagesrc = "$icons_dir/404.jpg";
         $image_checked = 0;
         $admin_image1 = ();
         $admin_image2 = ();
      }

      elsif (!$extfound && $name =~ /^$mypattern/i) {
         $file_type = "No Match Found";
         if (($display_filesize or $display_date or $display_downloads) or ($use_fullsize && $download_link_under_thumbnail)) {
            &find_size_date($path, $name);
            if ($skip_next_save_upload_date) {
               $filedate = $nulldate;
            }
            $filedate = &unix_to_date($filedate);            #convert unix time to a legible day
         }
         $slink = ();
         $clink = ();
         $newname = $name;
         $imagesrc = "$imageurl/$path/$name";
         $admin_image1 = ();
         $admin_image2 = $name;
      }

      if (! $linkimage_exp) {
         if (!$filesize_done) {
            $totalfilesize += $filesize;
            if ($filesize < 1500) {
               $filesize = &commify($filesize) . " bytes";
            }
            else { $filesize = int($filesize/1024);
               if ($filesize < 1500) {
                  $filesize = &commify($filesize) . " Kb";
               }
               else { $filesize = int($filesize/10.24);
                  $filesize = ($filesize/100) . " Mb";
               }
            }
         }
      }

      ($shortname) = $newname =~ m,^(.*)\.\w+$,;

      if ($if2_thumbcaption) {
         if ($FORM{'search'} or $FORM{'lightbox'} or $imageThumb_cgi) {
            &get_thumbcaps unless $quickdisplay;
         }
      }
      if ($display_hits or $display_rates or $found_downloads) {
         &get_counts_rating unless $quickdisplay;
      }

      if ($count==0){
         $thumb_image = qq|<tr bgcolor="$thumb_table_bgcolor"><td bgcolor="$thumb_table_border_color" width="1" rowspan="2"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>|;
         $thumb_info_below = qq|<tr bgcolor="$thumb_table_bgcolor">| if $thumb_info_below;
      }

      &show_thumbnail;
      $count++;

      if ($count==$columns) {
         if ($display_fileinfo) {
            $js_cell_adjust .= qq|adjTdo($adjCB, $adjCE, $adjTB, $adjTE);|;
         }
         $adjCB = $adjCE;
         $adjTB = $adjTE;

         $thumb_image .= qq|</tr>|;
         $thumb_info_below .= qq|</tr>| if $thumb_info_below;
         $thumbimages .= $thumb_image . $thumb_info_below;
         $thumbimages .= qq|<tr bgcolor="$thumb_table_border_color"><td colspan="$colspanrow" height="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td></tr>|;
         $count=0;
      }

      $i++;
   }      #end of foreach

   if ($count>0)  {
      if ($display_fileinfo) {
         $js_cell_adjust .= qq|adjTdo($adjCB, $adjCE, $adjTB, $adjTE);|;
      }
      while ($count < $columns) {
         if (($count + $cnt_factor) == $columns) {
            $imgtable_width = $imgtable_width_last;
         }
         else {
            $imgtable_width = $imgtable_width_all;
         }
         $count++;
         $thumb_image .= qq|<td width="$imgtable_width">&nbsp;</td>|;
         if ($thumb_info_right) {
            $count++;
            $thumb_image .= qq|<td width="$imgtable_width">&nbsp;</td>|;
         }
         $thumb_image .= qq|<td bgcolor="$thumb_table_border_color" width="1" rowspan="2"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>|;
         $thumb_info_below .= qq|<td width="$imgtable_width">&nbsp;</td>| if $thumb_info_below;
      }
      $thumb_image .= qq|</tr>|;
      $thumb_info_below .= qq|</tr>| if $thumb_info_below;
      $thumbimages .= $thumb_image . $thumb_info_below;
      $thumbimages .= qq|<tr bgcolor="$thumb_table_border_color"><td colspan="$colspanrow" height="1"><img src="$if_images_directory/pixel.gif" width="1" height="1"></td></tr>|;
   }
   $thumbimages .= qq|</table></td></tr>|;
   @names = ();


   $thumbimages .= qq|<script type="text/javascript">
      var oldFunction = null;
      function And_This(){
         if(oldFunction){
            oldFunction();
         }
         if (document.getElementById) {
            $js_cell_adjust
         }
      };
      function adjTdo(adjCB, adjCE, adjTB, adjTE) {
         var maxcellheight = 0;
         for (var i = adjCB; i < adjCE; i++) {
            var cellheight = document.getElementById('adjC'+i).offsetHeight;
            if (cellheight > maxcellheight){
               maxcellheight = cellheight;
            }
         }
         for (var i = adjTB; i < adjTE; i++) {
            document.getElementById('adjT'+i).style.height=maxcellheight+"px";
         }
      }
      function loadBody(){
         oldFunction = window.onload;
         window.onload = And_This;
      };
      loadBody();
      </script>| if $display_fileinfo;
#      die "display_fileinfo: $display_fileinfo";


}

###############################################################################
# SHOW THUMBNAIL
# this is where we show what each thumbnail will look like
# called from gen_image_table
###############################################################################
sub show_thumbnail {

   if ($imageThumb_cgi) {
      $thumb_info_below = 1;
      $thumb_info_right = ();
   }

   if (($count + $cnt_factor) == $columns) {
      $imgtable_width = $imgtable_width_last;
   }
   else {
      $imgtable_width = $imgtable_width_all;
   }

   $imagesrc =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;

   if ($imageThumb_cgi) {
      $thumb_image = ();
      $thumb_info_below = ();
      $thumbinfo_target = qq| target="_parent"|;
   }

   $thumbcaption = ();
   $fade_out = ();
   $alt_text = $alt_text_temp;

   if (-e $newcaplink && $if2_thumbcaption && !$quickdisplay) {
      foreach $thumbcap(@thumbcaps) {
         my($image_filename, $tcaption) = split(/\t/, $thumbcap);
         next if !$tcaption;
         ($new_image_filename) = $image_filename =~ m,^(.*)\.\w+$,;
         if ($new_image_filename eq $shortname) {
            $thumbcaption = $tcaption . "<br>";
            last;
         }
      }
   }

   if (@iptc_thumbnails_fields or $using_picturepost_mod or (lc($myextension_fullsize) eq 'zip')) {
      if ($admin_image2) {
         $iptc_thumnail_path = $admin_image2;
      }
      else {
         $iptc_thumnail_path = $name;
      }
      $iptc_thumnail_path = qq|$image_directory/$path/$iptc_thumnail_path|;
      &iptc_thumbnail;
      if ($custom18_file_type) {
         $file_type = $extensions{lc($custom18_file_type)}[0];
      }
      if ($custom18_approval) {
#         $display_fileinfo = 1;
         $alt_text_temp = $alt_text;
         if ($is_admin) {
            $fade_out = qq| style="opacity: .35; filter:alpha(opacity=35); -moz-opacity: .35;"|;
         }
         else {
            $slink = ();
            $clink = ();
            $fullsize_link = ();
            $imagesrc = "$icons_dir/AP.jpg";
            $alt_text = "Approval Pending";
         }
      }
   }

   if ($iptc_list2) {
      $iptc_list2 =~ s/\n/<br>/g;
      $iptc_list2 =~ s/\r//g;
      $iptc_list2 =~ s/<br><br>$//g;
      $iptc_list2 =~ s/<br>$//g;
      $iptc_list2 = qq|<table border="0" cellspacing="4" cellpadding="4" width="200"><tr bgcolor="$table_background_color"><td><$font>$iptc_list2</font></td></tr></table>|;
      $iptc_list2 = HTML::Entities::encode($iptc_list2);
      $iptc_list2 =~ s/\'/\\\'/ig;
      my $OVERLIB_TEXT = qq| onmouseover="return overlib('$iptc_list2',FULLHTML);" onmouseout="return nd();"|;
      $slink =~ s/%%%OVERLIB_TEXT%%%/$OVERLIB_TEXT/ig;
   }
   else {
      $slink =~ s/%%%OVERLIB_TEXT%%%//ig;
   }

   if ($linkimage =~ /\.emb$/i) {
     open (FILE,"$image_directory/$path/$linkimage");
     while (<FILE>) {
        chomp $_;
        my($field, $value) = split(/\t/,$_);
        if ($field eq 'Type') {
           $file_type = $value;
           last;
        }
     }
     close(FILE);
   }

   if ($thumb_info_right){
      $cell_id = qq| id="adjC$adjCE"|;
      $adjCE++;
   }

   $thumb_image .= qq|<td valign="$vthumbalign" align="center" width="$imgtable_width"$cell_id>|;
   $thumb_image .= qq|$slink<img src="$imagesrc" border=0 alt="$alt_text" vspace="4" hspace="4"$fade_out>$clink<br>|;

   if ($is_admin && $image_checked) {
      $thumb_image .= &create_image_tools;
   }
   elsif ($is_user && $custom18_user) {
      $thumb_image .= qq|<SCRIPT LANGUAGE="JavaScript">|;
      $thumb_image .=&create_user_image_tools($path);
      $thumb_image .= qq|
         var this_guest = "$guest_username";
         var this_file = "$custom18_user";
         var block_rename_move ="$custom18_approval";
         if (IFPro_user_session) {
            per_array=IFPro_user_session.split("\|");
            if (this_file==per_array[1] && this_file != this_guest){
               if (usetextlinks == 1) {
                  document.writeln(textlink_B);
               }
               if (per_array[2] == 1 && block_rename_move != 1) {
                  document.writeln(rename_me);
               }
               if (per_array[3] == 1) {
                  document.writeln(caption_me);
               }
               if (per_array[4] == 1) {
                  document.writeln(delete_me);
               }
               if (per_array[5] == 1 && block_rename_move != 1) {
                  document.writeln(move_me);
               }
               if (usetextlinks == 1) {
                  document.writeln(textlink_E);
               }
            }
         }
      </SCRIPT>|;
   }

   if ($using_lightbox_mod){
      $pixel_height = 4;
      my ($base) = $newname =~ m,^(.*)\.\w+$,;
      my ($ext) = ($newname =~ /\.([^.]+)$/);
      my $inout = 1 if defined $LIGHTBOX{"$path|$base|$ext"};
      $thumb_image .= qq|<SCRIPT LANGUAGE="JavaScript">showItems("$base", "$path", "$ext", "$inout");</SCRIPT>|;
   }
   else {
      $pixel_height = 1;
   }



   $thumb_image .= $fullsize_link;

   $thumb_image .= qq|<script language="Javascript">buy('$shortname','$PrintButton{'add_thumb'}','thumbnail_url=$imagesrc')</script>| if $use_printbutton;

   $thumb_image .= "</td>";



#   $thumb_info_below .= qq|<td width="$imgtable_width" valign=top align=center>|;

#   if (!$display_fileinfo) {
#      $thumb_info_below .= qq|<img src="$if_images_directory/pixel.gif" width="1" height="$pixel_height">|;
#   }

   

   if ($display_fileinfo) {


#       $js_cell_adjust .= qq|var adjC$row_cnt = document.getElementById('adjC$cell_cnt');|;


#       $js_cell_adjust .= qq|var row_$row_cnt = document.getElementById('cell_$row_cnt');alert(row_$row_cnt+" : "+row_$row_cnt.offsetHeight+" : "+row_$row_cnt.offsetWidth);|;

#      $js_cell_adjust .= qq|document.getElementById('C${row_cnt}T${table_id}').style.height=row_$row_cnt.offsetHeight+"px";|;

#      $js_cell_adjust .= qq|var table = document.getElementById('C${row_cnt}T${table_id}');table.setAttribute("height",300);|;


     $thumb_info = qq|<td width="$imgtable_width" valign="$vthumbinfoalign" align=center id="adjC${adjCE}">|;
     $ratelink = qq|a href="javascript:" onClick="window.open('$imagefolio_url?main=imageRate&direct=|;
     $ratelink .= qq|$path&file=$newname','Rate','height=200,width=200');return false"|;

     $thumb_info .= qq|<table width="100%" border="0" cellspacing="4" cellpadding="4" id="adjT${adjTE}"><tr bgcolor="$table_background_color"><td valign="$vthumbinfoalign"><$font>|;
     if ($custom18_approval) {
        $thumb_info .= qq|<b>Approval Pending</b><br>|;
        if (!$imageThumb_cgi) {
           $thumb_info .= qq|This file first needs to be approved before it can be accessed. We are reviewing it at the moment.<br>| unless $quickdisplay;
        }
     }
     if (!$custom18_approval or $is_admin) {
         my $show_name = length($shortname);
         if ($show_name > 26) {
            $show_name = substr($shortname, 0,26) . "...";
            $show_name =~ s/_/ /g;
         }
         else {
            $show_name = $shortname;
            $show_name =~ s/_/ /g;
         }
        if ($display_filename) { 
           if (!$quickdisplay) {$thumb_info .= qq|<b>$show_name</b><br>|;}
           else { $thumb_info .= qq|<center><b>$show_name</b></center><br>|;}
        }
        if ($iptc_list)             { $thumb_info .= qq|$iptc_list|; }
        if ($if2_thumbcaption)      { $thumb_info .= qq|$thumbcaption|; }
        if ($display_filetype)      { $thumb_info .= qq|$file_type<br>|;      }
        if ($display_hits)          { $thumb_info .= qq|Hits: $hits<br>|;  }
        if ($found_downloads)       { $thumb_info .= qq|Downloads: $downloads<br>|;  }
        if ($display_rates)         { $thumb_info .= qq|<$ratelink>Rating</a>: $rated<br>|; if ($FORM{'search'} eq 'RATES') { $thumb_info .= qq|($votes votes)<br>|; } }
        if ($display_filesize)      { $thumb_info .= qq|Size: $filesize<br>|;   }
        if ($display_date)          { $thumb_info .= qq|Added: $filedate<br>|;  }
     }
     $thumb_info .= qq|</font></td></tr></table></td>|;
     $thumb_info_below .= $thumb_info if $thumb_info_below;
     if ($thumb_info_right) {
        $thumb_image .= $thumb_info;
        $count++;
     }
     $adjCE++;
     $adjTE++;
   }

#   $thumb_info_below .= "</td>";


   if (!$imageThumb_cgi) {
      $thumb_image .= qq|<td bgcolor="$thumb_table_border_color" width="1"$thmbrowspan><img src="$if_images_directory/pixel.gif" width="1" height="1"></td>|;
   }
   else {
      $imagethumb = $thumb_image . "</tr><tr>" . $thumb_info;
   }

   $thumb_info = ();

}

1;