####CODEHEADER###

###############################################################################
# START UP OF MULTI USER MOD
###############################################################################
sub start_multiuser_mod {
   if ($FORM{'ota'}) {
      &one_time_access_login;
   }
   elsif ($COOKIE{'IFPro_user_session'} && $COOKIE{'IFPro_mem'}) {
      ($user_session_id) = split(/\|/, $COOKIE{'IFPro_user_session'});
      $user_sessionfile = "$sessions_dir/$user_session_id.user";
      if (-e "$user_sessionfile") {
         $is_user = 1;
      }
      else {
         print "Set-Cookie: IFPro_user_session=; path=/;\n";
         $user_session_id = int(rand(1234567890)) + time;
         $user_sessionfile = "$sessions_dir/$user_session_id.user";
      }
   }
   else {
      $user_session_id = int(rand(1234567890)) + time;
      $user_sessionfile = "$sessions_dir/$user_session_id.user";
   }
   if ($FORM{'login'} == 1) {
      &config_more;
      &login_1;
      exit;
   }
   elsif ($FORM{'login'} == 2) {
      &login_2;
   }
   elsif ($is_user) {
      if ($FORM{'admin'}) {
         $cache_page_age = ();
         require "$config_directory/admin_config.pl";
      }
      if (!$one_time_access) {
         &get_user_session;
      }
      $if_javascript .= qq|<script language="javascript" src="$base_if_url/cookie.js"></script><script language="javascript">var cookie=document.cookie; if(nameDefined(cookie,"IFPro_user_session")) {IFPro_user_session=getCookieValue(cookie,"IFPro_user_session");}else {IFPro_user_session="";}</script>|;
   }
   elsif (!$FORM{'account'}) {
      &check_guest;
   }
}


sub get_user_session {
   my $c_expire = gmtime(time + ($user_session_expiration * 24 * 60 * 60));
#   my $c_expire = gmtime($c_expire);
   print "Set-Cookie: IFPro_user_session=$COOKIE{'IFPro_user_session'}; path=/; expires=$c_expire;\n";
   open (SESSION, "$user_sessionfile");
   my (@LINES)=<SESSION>;
   close (SESSION);
   open (SESSION, ">$user_sessionfile");
   print SESSION "@LINES[0]";
   close(SESSION);
   chmod(0777,"$user_sessionfile");
   &split_if_sessionline(@LINES[0]);
   &translate_settings;
}


###############################################################################
# READ USERS ACCESS DATABASE
###############################################################################

sub get_group_per {
   open (GROUPDB,"$groupdb") or &Error("Can't Open $groupdb: $!");
   my (@LINES)=<GROUPDB>;
   close(GROUPDB);
   chomp @LINES;

#   if ($FORM{'lightbox'} or $FORM{'lbview'} or $FORM{'download'}) {
#      push(@LINES, "Guest||0|cool_blue|All|1|1|1|1|All|0|1|1|0|0|0|0|0|0|0|0|0|0|0||");
#   }

   foreach $groupline (@LINES) {
      &split_if_groupline($groupline);
      if ($ifgroup) {
         if (lc($group_group_name) eq lc($ifgroup)) {
            $group_short_desc = "$group_group_name group permissions";
            $found_group = 1;
            &populate_if_groupline;
            last;
         }
      }
      elsif ($group_default) {
         $group_short_desc = "Default group permissions";
         $found_group = 1;
         &populate_if_groupline;
         last;
      }
   }

}


###############################################################################
# READ USERS ACCESS DATABASE
###############################################################################

sub read_users_access {

   if(!$FORM{'if_username'})    { print &Error('You must enter a username.'); }
   elsif(!$FORM{'if_password'}) { print &Error('You must enter a password.'); }

   require "$db_link_path/$db_link_file";
   &read_user_db;

   if(!$found_this_user)     { print &Error("Sorry $FORM{'if_username'}, the username you entered is incorrect."); }
   elsif(!$found_this_pass)  { print &Error("Sorry $FORM{'if_username'}, the password you entered is incorrect."); }

   $ifgroup =~ s/ /_/g;
   $ifusername_display = $ifusername;
#   $ifusername_display = "$iffirstname $iflastname";
   $ifusername =~ s/[$deny_chars]//g;
   $ifusername =~ s/ /_/g;
   $ifuserid = $ifusername unless $ifuserid;
   $ifuserid =~ s/[^a-zA-Z0-9]//g;
   &populate_if_userline;

}

sub write_user_session {
   if (($group_post_access =~ /PERSONAL_CATEGORY/ && $group_media_upload_per) or $group_cat_access =~ /PERSONAL_CATEGORY/) {
      require "$config_directory/post_config.pl";
#     $group_post_access = "$main_users_cat/$ifusername";
#     $if_usersessionline =~ s/PERSONAL_CATEGORY/$group_post_access/ig;
      if (!-d "$image_directory/$main_users_cat") {
         mkdir ("$image_directory/$main_users_cat", "0777") or &Error("Unable to create category, $image_directory/$main_users_cat.  Reason: $!");
         chmod (0777,"$image_directory/$main_users_cat");
         open(CATEGORIES,">>$catfile") or &Error ("Could not open catgory file. Try rebuilding the index.  Reason: $!");
         if ($useflock) { flock(CATEGORIES, 2); }
         print CATEGORIES "$main_users_cat\t0\n";
         if ($useflock) { flock(CATEGORIES, 8); }
         close(CATEGORIES);
      }
      if (!-d "$image_directory/$main_users_cat/$ifusername") {
         mkdir ("$image_directory/$main_users_cat/$ifusername", "0777") or &Error("Unable to create category, $image_directory/$group_post_access.  Reason: $!");
         chmod (0777,"$image_directory/$main_users_cat/$ifusername");
#         chmod(0777,"$image_directory/$main_users_cat/$ifusername") or &Error("Could not set permissions on category, $image_directory/$group_post_access.  Reason: $!");
         open(CATEGORIES,">>$catfile") or &Error ("Could not open catgory file. Try rebuilding the index.  Reason: $!");
         if ($useflock) { flock(CATEGORIES, 2); }
         print CATEGORIES "$main_users_cat/$ifusername\t0\n";
         if ($useflock) { flock(CATEGORIES, 8); }
         close(CATEGORIES);
      }
   }
   open (SESSION,">$user_sessionfile") or &Error("Unable to write session, Reason: $!");
   print SESSION "$if_usersessionline\n";
   close(SESSION);
   chmod(0777,"$user_sessionfile");
}


sub update_user_emails {
   $ifuserid = $ifusername unless $ifuserid;
   $ifuserid =~ s/[^a-zA-Z0-9]//g;
   my $encrypt_ifusername = &admin_encrypt($ifusername, $ifuserid);
   my $encrypt_ifusername_display = &admin_encrypt($ifusername_display, $ifuserid);
   my $encrypt_ifemail = &admin_encrypt($ifemail, $ifuserid);
   if (-e $totaluserinfodb) {
      require $totaluserinfodb;
      if (exists($total_user_info{$ifuserid})){
         $db_ifusername          =  $total_user_info{$ifuserid}[0];
         $db_ifusername_display  =  $total_user_info{$ifuserid}[1];
         $db_ifemail             =  $total_user_info{$ifuserid}[2];
         if (($encrypt_ifusername ne $db_ifusername) or ($encrypt_ifusername_display ne $db_ifusername_display) or ($encrypt_ifemail ne $db_ifemail)) {
            $new_total_ui = qq|$ifuserid\t=> ['$encrypt_ifusername','$encrypt_ifusername_display','$encrypt_ifemail'],\n|;
         }
      }
      else {
         $new_total_ui = qq|$ifuserid\t=> ['$encrypt_ifusername','$encrypt_ifusername_display','$encrypt_ifemail'],\n|;
      }
      if ($new_total_ui) {
         open (U_INFO,$totaluserinfodb) or &Error("Can't Open $totaluserinfodb: $!");
         my (@U_INFO)=<U_INFO>;
         close(U_INFO);
         $i = ();
         open (U_INFO,">$data_directory/db/total_user_info.temp") or &Error("Can't create total_user_info.temp: $!");
         foreach (@U_INFO) {
            $i++;
            if ($i==2) {
               print U_INFO $new_total_ui;
            }
            my ($db_ifuserid) = split(/\t/, $_);
            if ($db_ifuserid ne $ifuserid) {
               print U_INFO $_;
            }
         }
#         print U_INFO "1;\n";
         close(U_INFO);
         chmod(0777,"$data_directory/db/total_user_info.temp");
#        unlink $totaluserinfodb;
         rename ("$data_directory/db/total_user_info.temp", "$totaluserinfodb") or &Error("Can't rename total_user_info.temp: $!");
      }
   }
   else {
      open (U_INFO,">$totaluserinfodb") or &Error("Can't create $totaluserinfodb: $!");
      print U_INFO "%total_user_info = (\n";
      print U_INFO "$ifuserid\t=> ['$encrypt_ifusername','$encrypt_ifusername_display','$encrypt_ifemail'],\n";
      print U_INFO ");\n1;\n";
      close(U_INFO);
      chmod(0777,"$totaluserinfodb");
   }
}


sub update_user_emails_2 {
   open (USEREMAILDB, "$useremaildb");
   my (@USEREMAILS)=<USEREMAILDB>;
   close (USEREMAILDB);
   chomp @USEREMAILS;

   my $encrypt_email = &admin_encrypt($ifemail, $ifusername);

   foreach (@USEREMAILS) {
      my ($my_username, $my_useremail) = split(/\t/, $_);
      if ($my_username eq $ifusername) {
         $found_user_in_emaildb = 1;
         if ($my_useremail ne $encrypt_email) {
            $new_useremaildb .= "$ifusername\t$encrypt_email\n";
            $replace_useremaildb = 1;
         }
      }
      else {
         $new_useremaildb .= "$my_username\t$my_useremail\n";
      }
   }

   if ($replace_useremaildb) {
      open (USEREMAILDB,">$useremaildb");
      print USEREMAILDB "$new_useremaildb";
      close(USEREMAILDB);
      chmod(0777,"$useremaildb");
   }
   elsif (!$found_user_in_emaildb) {
      open (USEREMAILDB,">>$useremaildb");
      print USEREMAILDB "$ifusername\t$encrypt_email\n";
      close(USEREMAILDB);
      chmod(0777,"$useremaildb");
   }
}

sub read_user_emails {
   my $input = shift;
   open (USEREMAILDB, "$useremaildb");
   my (@USEREMAILS)=<USEREMAILDB>;
   close (USEREMAILDB);
   chomp @USEREMAILS;

   foreach (@USEREMAILS) {
      my ($my_username, $my_useremail) = split(/\t/, $_);
      if (($my_username eq $input) && $my_useremail) {
         $custom18_email = $my_useremail;
      }
   }
}

###############################################################################
# DELETE SESSIONS
# old session files are deleted when a user logs in
###############################################################################
sub delete_user_sessions {

   # These are the "guests" sessions

   opendir (IDS, "$sessions_dir") or &Error('Unable to read session directory.');
   my @sessions = grep { /(\.user|\.cart|\.lightbox)$/ } readdir(IDS);
   closedir (IDS);
   $NUMSESSIONS = @sessions;

   if ($NUMSESSIONS > 1) {
     foreach $session (@sessions) {
        next if $session =~ /^admin\./;
        unlink("$sessions_dir/$session") if -M "$sessions_dir/$session" > 1;
     }
   }
}

###############################################################################
# SPLIT/POPULATE
###############################################################################

sub populate_if_sessionline { # used for the ImageFolio user session
   $if_usersessionline = "[$if_userline][$if_groupline]";
}
sub split_if_sessionline { # used for the ImageFolio user session
   my $input = shift;
   my ($userline, $groupline) = $input =~ /\[(.*?)\]/g;
   &split_if_userline($userline);
   &split_if_groupline($groupline);
}
sub populate_if_groupline { # used for the ImageFolio group database
   $if_groupline = "$group_group_name|$group_short_desc|$group_default|$group_skins_access|$group_cat_access|$group_preview_view_per|$group_preview_protect_per|$group_watermark_per|$group_full_size_per|$group_post_access|$group_media_upload_per|$group_media_main_cat_per|$group_media_upload_approval|$group_media_ren_per|$group_media_mov_per|$group_media_del_per|$group_media_desc_per|$group_media_fs_per|$group_cat_add_per|$group_cat_ren_per|$group_cat_move_per|$group_cat_del_per|$group_cat_upload_per|$group_cat_desc_per|$group_content_access|$group_media_mod_per|";
   $if_groupline =~ s/\n//g;
   $if_groupline =~ s/\r//g;
}
sub split_if_groupline { # used for the ImageFolio group database
   my $input = shift;
   ($group_group_name, $group_short_desc, $group_default, $group_skins_access, $group_cat_access, $group_preview_view_per, $group_preview_protect_per, $group_watermark_per, $group_full_size_per, $group_post_access, $group_media_upload_per, $group_media_main_cat_per, $group_media_upload_approval, $group_media_ren_per, $group_media_mov_per, $group_media_del_per, $group_media_desc_per, $group_media_fs_per, $group_cat_add_per, $group_cat_ren_per, $group_cat_move_per, $group_cat_del_per, $group_cat_upload_per, $group_cat_desc_per, $group_content_access, $group_media_mod_per) = split(/\|/,$input);
}
sub populate_if_userline { # used for the ImageFolio user database
   $if_userline = "$ifusername|$ifuserpass|$ifuserid|$ifemail|$iffirstname|$iflastname|$ifgroup|$ifusername_display|$ifcompnay|$ifaddress|$ifaddress2|$ifcity|$ifstate|$ifzipcode|$ifcountry|$ifphone|";
}
sub split_if_userline { # used for the ImageFolio user database
   my $input = shift;
   ($ifusername,$ifuserpass,$ifuserid,$ifemail,$iffirstname,$iflastname,$ifgroup,$ifusername_display,$ifcompnay,$ifaddress,$ifaddress2,$ifcity,$ifstate,$ifzipcode,$ifcountry,$ifphone) = split(/\|/,$input);
}


###############################################################################
# TRANSLATE SETTINGS TO THERE config.pl VALUES
###############################################################################
sub translate_settings {
   $skin_name = $group_skins_access if -e "$base_skin_dir/$group_skins_access/config_skin.pl";
   if (-e "$config_directory/config_group_${group_group_name}.pl") {
      require "$config_directory/config_group_${group_group_name}.pl";
   }
   if (-e "$config_directory/config_user_${ifusername}.pl") {
      require "$config_directory/config_user_${ifusername}.pl";
   }
   if ($current_cat) {
      if (-e "$image_directory/$current_cat_root/config_cat.pl") {
         require "$image_directory/$current_cat_root/config_cat.pl";
      }
   }
   if ($group_cat_access eq 'All') {
      $allow_free_access = 1;
   }

#$group_full_size_per = 1 if $FORM{'lightbox'} or $FORM{'lbview'};

# Not needed, user will be forwarded to login screen.
#   if (!$group_preview_view_per) {
#      $no_preview_link = 1;
#   }
   if ($group_cat_access =~ /PERSONAL_CATEGORY/) {
      require "$config_directory/post_config.pl";
      $group_cat_access =~ s/PERSONAL_CATEGORY/$main_users_cat\/$ifusername/ig;
      @current_cat_access = split(/::/,$group_cat_access);
   }
   elsif ($group_post_access =~ /PERSONAL_CATEGORY/ && !$allow_free_access) {
      @current_cat_access = split(/::/,$group_cat_access);
      require "$config_directory/post_config.pl";
      my $add_user_category = "$main_users_cat/$ifusername";
      foreach (@current_cat_access) {
         $add_user_category = () if $_ eq $main_users_cat;
      }
      if ($add_user_category) {
         push(@current_cat_access, $add_user_category);
         $group_cat_access .= "::$add_user_category";
      }
   }
   else {
      @current_cat_access = split(/::/,$group_cat_access);
   }
   @current_cat_access = sort(@current_cat_access);
   if ($current_cat) {
      foreach $this_cat_access (@current_cat_access) {
         if ($current_cat =~ /^$this_cat_access/i) {
            $found_correct_cat =1;
         }
      }
      if (!$found_correct_cat && !$allow_free_access) {
         if ($imageCard_cgi) {
            &Error("Sorry $ifusername, you do not have permission to send a card from this category.");
         }
         elsif ($FORM{'lbview'} && ($FORM{'lbview'} !~ /\D+/)) {
            require "$config_directory/lightbox_config.pl";
            $savedlightbox = $FORM{'lbview'};
            $savedlightbox .= "$emailed_lightboxes_ext";
            if (!-e "$emailed_lightboxes_directory/$savedlightbox"){
               &Error("Sorry $ifusername, this $lightbox_name does not exist.");
            }
         }
         else {
            print "Location:$imagefolio_redirect_url\n\n";
            exit;
         }
      }
   }
   if (!$use_fullsize) {
      $group_media_fs_per = ();
      $group_full_size_per = ();
   }
   if ($FORM{'admin'} && $group_media_fs_per) {
      $use_fullsize = 1;
   }
   elsif (!$group_full_size_per) {
      $use_fullsize = ();
   }
   if ($group_media_upload_per) {
      if ($group_post_access =~ /PERSONAL_CATEGORY/) {
         require "$config_directory/post_config.pl";
         $group_post_access =~ s/PERSONAL_CATEGORY/$main_users_cat\/$ifusername/ig;
      }
      @current_post_access = split(/::/,$group_post_access);
      foreach my $cpa (@current_post_access) {
         $CPA{$cpa} = 1;
      }
   }
   else {
      $group_media_mod_per = ();
   }
   if ($using_picturepost_mod && $FORM{'admin'}){
      require "$config_directory/post_config.pl";
      require "$libpath/fe_admin.pl";

      if ($group_post_access =~ /PERSONAL_CATEGORY/) {
         $group_post_access =~ s/PERSONAL_CATEGORY/$main_users_cat\/$ifusername/ig;
      }


#      if ($group_post_access =~ /PERSONAL_CATEGORY/) {
#         $group_post_access = "$main_users_cat/$ifusername";
#         $personal_category = 1;
#         if ($FORM{'image'} =~/(delete_category$|move_category$|rename_category$)/i) {
#            $block_main_cat = 1;
#            $split_symbol = "/";
##            $split_symbol = "$ifusername";
#         }
#      }
#      else {
         if ($group_post_access eq 'All') {
            $allow_free_post_access = 1;
         }
         if (!$group_media_main_cat_per) {
            $block_main_cat = 1;
#            $split_symbol = "/";
         }
#      }
#      if ($block_main_cat) {
#         $block_main_cat_script1 = qq| onChange="block_main_cat()"|;
#         $block_main_cat_script2 = qq|
#            <script language="JavaScript"><!--
#            var block_main_cat_value = 1;
#            function block_main_cat() {
#               var admin_directory = document.forms[0].admin_directory
#               var admin_directoryIndex = admin_directory.selectedIndex
#               var admin_directoryValue = admin_directory[admin_directoryIndex].value
#               array=admin_directoryValue.split("$split_symbol");
#               if (!array[1]) {
#                  skip_forward = 1;
#                  alert("You can't select a main category");
#                  location.href = location.href.split('#')[0];
#               }
#//               else {
#//                  location.href = "$imagefolio_url?admin=upload_image&admin_directory=" + admin_directoryValue;
#//               }
#            }
#            // -->
#            </script>|;
#      }
#      if ($block_main_cat) {
         $block_main_cat_script1 = qq| onChange="block_main_cat()"|;
         $block_main_cat_script2 = qq|
            <script language="JavaScript"><!--
            var block_main_cat_value = 1;
            function block_main_cat() {
               var admin_directory = document.forms[0].admin_directory
               var admin_directoryIndex = admin_directory.selectedIndex
               if (!admin_directory[admin_directoryIndex].value) {
                  skip_forward = 1;
                  alert("You can't select this category");
                  location.href = location.href.split('#')[0];
               }
            }
            // -->
            </script>|;
#      }
      
      if (!$group_media_fs_per) {
         $use_fullsize = 0;
      }
   }
   if ($FORM{'link'}) {
      if ($FORM{'download'} && !$group_full_size_per) {
         if ($FORM{'from_login'}) {
            &Error("Sorry $ifusername, you do not have permission to download this file.");
         }
         else {
            &config_more;
            $FORM{'start'} = &admin_encrypt("$full_query&from_login=1", $guest_username);
            &login_1;
            exit;
         }
      }
      elsif (!$group_preview_view_per) {
         if ($FORM{'lbview'} && ($FORM{'lbview'} !~ /\D+/)) {
            require "$config_directory/lightbox_config.pl";
            $savedlightbox = $FORM{'lbview'};
            $savedlightbox .= "$emailed_lightboxes_ext";
            if (!-e "$emailed_lightboxes_directory/$savedlightbox"){
               &Error("Sorry $ifusername, this $lightbox_name does not exist.");
            }
         }
         elsif ($FORM{'from_logout'}) {
            print "Location:$imagefolio_redirect_url\n\n";
            exit;
         }
         elsif ($FORM{'from_login'}) {
            &Error("Sorry $ifusername, you do not have permission to view this file.");
         }
         else {
            &config_more;
            $FORM{'start'} = &admin_encrypt("$full_query&from_login=1", $guest_username);
            &login_1;
            exit;
         }
      }
      if ($watermark && !$group_watermark_per) {
         $IFPro_nwm = "/$FORM{'link'}/$FORM{'image'}";
         $IFPro_nwm =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;
         print "Set-Cookie: IFPro_nwm=$IFPro_nwm; path=/;\n";
         if (!$imageCard_cgi) {
            $watermark = ();
         }
      }
      elsif ($COOKIE{'IFPro_nwm'}) {
         print "Set-Cookie: IFPro_nwm=; path=/;\n";
      }
      if ($imageprotect && !$group_preview_protect_per) {
#            $cache_page_age = ();
         $imageprotect = ();
      }
   }
   if ($FORM{'action'} eq 'ecard' && !$group_preview_view_per) {
      &Error("Sorry $ifusername, you do not have permission to send this file.");
   }
   if ($ifusername eq $guest_username) {
      $confirmed_guest = 1;
#      $email_lightbox=0;
   }
   if ($using_lightbox_mod){
      if (!$group_preview_view_per) {
            $slideshow_lightbox=0;
            $download_lightbox=0;
            $email_lightbox=0;
      }
      elsif ($group_preview_protect_per && !$group_full_size_per) {
         $download_lightbox=0;
      }
#      $lightbox_cookie_name = $lightbox_cookie_name . $ifusername;
#      $lightbox = $COOKIE{$lightbox_cookie_name};
   }
}

###############################################################################
# LOGIN 1
# Our login screen
###############################################################################
sub login_1 {

   open (TEMPLATE,"$login_template") or &Error("Could not open $login_template.  Reason: $!");
    while (<TEMPLATE>) {
     if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_include($2); }
     elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_exec_include($2); }
     else { $template .= $_; }
   }
   close(TEMPLATE);
   require "$libpath/headerfooter.pl";

   my $password_cookie = qq~<script language="JavaScript">
function saveuser() {
  var now = new Date();
  if (document.if_login.if_mem.checked) {
    var expire = new Date(now.getTime() + 365 * 24 * 60 * 60 * 1000);
    document.cookie = "if_login="+escape(document.if_login.if_username.value)+"|"+escape(document.if_login.if_password.value)+";expires="+expire.toGMTString();
  }
  else {
    document.cookie = "if_login=;expires="+now.toGMTString();
  }
}
function loaduser() {
  var if_login=ReadCookie("if_login").split("|");
  if (if_login[0]) {
    document.if_login.if_username.value = if_login[0];
    document.if_login.if_password.value = if_login[1];
    document.if_login.if_mem.checked = true;
  }
}
function ReadCookie(cookieName) {
  var theCookie=""+document.cookie;
  var ind=theCookie.indexOf(cookieName);
  if (ind==-1 || cookieName=="") return "";
  var ind1=theCookie.indexOf(';',ind);
  if (ind1==-1) ind1=theCookie.length;
  return unescape(theCookie.substring(ind+cookieName.length+1,ind1));
}
loaduser();
</script>~;

   my $remember_me = qq|<tr><td align=right class=login><b>Remember Me</b></td><td align=left><input type="checkbox" name="if_mem" value="1"></td></tr>$password_cookie| unless $user_force_signout;
   $template =~ s/%%%REMEMBER_ME%%%/$remember_me/ig;
   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;

   $template =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $template =~ s/%%%IF_URL%%%/$imagefolio_url/ig;
   $template =~ s/%%%START%%%/$FORM{'start'}/ig;
#   if ($user_registration == 2) {
      require "$db_link_path/$db_link_file";
      if ($db_link_file eq "imagefolio.pl") {
         open (GROUPDB,"$groupdb");
         my (@LINES)=<GROUPDB>;
         close(GROUPDB);
         chomp @LINES;
         foreach $line (@LINES) {
            &split_if_groupline($line);
            if ($group_default) {
               $yes_default = 1;
               last;
            }
         }
         $register_url = () unless $yes_default;
      }
      if ($lost_pw_url) {
         $lost_pw_url = qq|<a href="$lost_pw_url">Forgot your password?</a><br>|;
      }
      if ($register_url) {
         $register_url = qq|New users can register <a href="$register_url">here</a>.|;
      }
      $template =~ s/%%%SELF_REGISTER_LINK%%%/$lost_pw_url $register_url/ig;
#   }
   $template =~ s/%%%BODY_BGCOLOR%%%/$body_bgcolor/ig;
   $template =~ s/%%%MAIN_TABLE_WIDTH%%%/$main_table_width/ig;
   $template =~ s/%%%(.*)%%%//ig;

   print "Content-type: text/html\n\n";
   print $template;
}

###############################################################################
# LOGIN 2
# logs on the user
###############################################################################
sub login_2 {
   require "$config_directory/admin_config.pl";
   &read_users_access;
   &get_group_per;
   if ($found_group) {
      if ($is_admin){
         unlink("$sessions_dir/$admin_uid.admin");
         print "Set-Cookie: IF_UID=; path=/;\n";
         $is_admin = ();
      }
      if (!-d "$sessions_dir/$ifusername") {
         mkdir ("$sessions_dir/$ifusername", "0777") or &Error("Unable to create users session directory, Reason: $!");
         chmod (0777,"$sessions_dir/$ifusername");
      }
      $user_session_id = "$ifusername/session";
      $user_sessionfile = "$sessions_dir/$user_session_id.user";
      &populate_if_sessionline;
      &delete_user_sessions;
      &write_user_session;
      &split_if_sessionline($if_usersessionline);
      &translate_settings;
      my $ifpro_media_per = "|$ifusername|$group_media_ren_per|$group_media_desc_per|$group_media_del_per|$group_media_mov_per|";
      my $c_expire = gmtime(time + ($user_session_expiration * 24 * 60 * 60));
      print "Set-Cookie: IFPro_user_session=$user_session_id$ifpro_media_per; path=/; expires=$c_expire;\n";
#      print "Set-Cookie: IFPro_user_session=$user_session_id$ifpro_media_per; path=/;\n";
      if ($user_force_signout && !$FORM{'if_mem'}) {
         print "Set-Cookie: IFPro_mem=1; path=/;\n";
      }
      else {
         my $c_expire = gmtime(time + (365 * 24 * 60 * 60));
         print "Set-Cookie: IFPro_mem=1; path=/; expires=$c_expire;\n";
      }
      $is_user = 1;
      if ($ifemail) {
         &update_user_emails;
      }
      if ($FORM{'start'}) {
         $start_query .= &admin_decrypt($FORM{'start'}, $guest_username);
         $if_javascript .= qq|
         <SCRIPT LANGUAGE="JavaScript"><!--
         location.href = "$imagefolio_url?$start_query";
         // --></SCRIPT>
         |;
      }
#      elsif ($group_cat_access !~ /::/ && $group_cat_access ne 'All') {
#         $if_javascript .= qq|
#         <SCRIPT LANGUAGE="JavaScript"><!--
#         location.href = "$imagefolio_url?direct=$group_cat_access";
#         // --></SCRIPT>
#         |;
#      }
   }
   else { &Error('No group permissions could be found. Please contact the webmaster.'); }
}

###############################################################################
# CHECK GUEST LOGIN
# checks to see if you have setup a "guest" group account and logs the user in
# as guest if they did not login with a username/password yet.
###############################################################################
sub check_guest {
   $ifgroup = $guest_username;
   &get_group_per;
   if ($found_group) {
      $ifusername = $guest_username;
      $ifusername_display = $guest_username;
      &populate_if_userline;
      &populate_if_sessionline;
      &delete_user_sessions;
      &write_user_session;
      &split_if_sessionline($if_usersessionline);
      &translate_settings;
      my $ifpro_media_per = "|$ifusername|$group_media_ren_per|$group_media_desc_per|$group_media_del_per|$group_media_mov_per|";
      my $c_expire = gmtime(time + ($user_session_expiration * 24 * 60 * 60));
      print "Set-Cookie: IFPro_user_session=$user_session_id$ifpro_media_per; path=/; expires=$c_expire;\n";
#      print "Set-Cookie: IFPro_user_session=$user_session_id$ifpro_media_per; path=/;\n";
      print "Set-Cookie: IFPro_mem=1; path=/;\n";
      $if_javascript .= qq|<script language="javascript">IFPro_user_session="$user_session_id$ifpro_media_per";</script>|;
      $is_user = 1;
      if ($FORM{'admin'}) {
         $cache_page_age = ();
         require "$config_directory/admin_config.pl";
      }
   }
   else {
      if ($guest_lightbox_access && ($FORM{'lightbox'} or $FORM{'lbview'})) {
         $if_groupline = "$guest_username||0|$skin_name|All|1|1|1||All||1|1";
         $display_new       = 0;
         $display_random    = 0;
         $display_top_hits  = 0;
         $display_top_rates = 0;
         $using_postcard_mod = 0;
         $using_lightbox_mod = 0;
         $using_picturepost_mod = 0;
         $ifusername = $guest_username;
         $ifusername_display = $guest_username;
         &populate_if_userline;
         &populate_if_sessionline;
         &delete_user_sessions;
#         &write_user_session;
         &split_if_sessionline($if_usersessionline);
         &translate_settings;
         $is_user = 1;
      }
      else {
         if ($full_query) {
            $encrypt_full_query = &admin_encrypt($full_query, $guest_username);
         }
         print "Location:$imagefolio_redirect_url?ct=$current_time&login=1&start=$encrypt_full_query\n\n";
         exit;
      }
   }
}

###############################################################################
# CREATE TOOLS
# Creates the front end user admin toolbar
###############################################################################
sub create_user_tools {
   $current = "&admin_directory=$current_cat" if $current_cat;
   $admin_tools = ();
   $admin_popup_options = "width=500,height=350,scrollbars=no";
   if ($use_textlinks) {
      if ($group_cat_add_per) {
         $admin_tools .= qq| <a href="javascript:adminPopup('$imagefolio_url?admin=new_category$current','$admin_popup_options')" alt="Create New Category" title="Create New Category">New Category</a> \||;
      }
      if ($group_cat_del_per) {
         $admin_tools .= qq| <a href="javascript:adminPopup('$imagefolio_url?admin=delete_category$current','$admin_popup_options')" alt="Delete This Category" title="Delete This Category">Delete Category</a> \||;
      }
      if ($group_cat_move_per) {
         $admin_tools .= qq| <a href="javascript:adminPopup('$imagefolio_url?admin=move_category$current','$admin_popup_options')" alt="Move This Category" title="Move This Category">Move Category</a> \||;
      }
      if ($group_cat_ren_per) {
         $admin_tools .= qq| <a href="javascript:adminPopup('$imagefolio_url?admin=rename_category$current','$admin_popup_options')" alt="Rename This Category" title="Rename This Category">Rename Category</a> \||;
      }
      if ($group_cat_desc_per) {
         $admin_tools .= qq| <a href="javascript:adminPopup('$imagefolio_url?admin=describe_category$current','$admin_popup_options')" alt="Edit This Category Description" title="Edit This Category Description">Category Description</a> \||;
      }
      if ($group_cat_upload_per) {
         $admin_tools .= qq| <a href="javascript:adminPopup('$imagefolio_url?admin=image_category$current','$admin_popup_options')" alt="Upload and Add Category Image" title="Upload and Add Category Image">Category Image</a> \||;
      }
      if ($admin_tools) {
         if ($group_media_upload_per) {
            $admin_tools = qq| <a href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')" alt="Upload New Files" title="Upload New Files">Upload Files</a> \|$admin_tools|;
         }
         $admin_tools = qq|<tr bgcolor="$main_header_bgcolor"><td align="center" nowrap valign="bottom" height="30"><table border=0 cellspacing=0 cellpadding=2 width="100%" bgcolor="#ffffcc"><tr><td align=center><$fe_admin_font><font size=1>\|$admin_tools</font></font></td></tr></table></td></tr>|;
      }
      elsif ($group_media_upload_per) {
         $upload_button = qq| <a href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')" alt="Upload New Files" title="Upload New Files">Upload Files</a> \||;
         $upload_button_text_nav = qq| <a href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')" alt="Upload New Files" title="Upload New Files">Upload Files</a> \||;
         $upload_button_text_nav = qq| \| <a class=nav href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')" alt="Upload New Files" title="Upload New Files">Upload</a>| if $ifc;
      }

   }
   else {
      if ($group_cat_add_per) {
         $admin_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=new_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_new.$ButtonExt" border="0" alt="Create New Category" title="Create New Category"></a> |;
      }
      if ($group_cat_del_per) {
         $admin_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=delete_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_delete.$ButtonExt" border="0" alt="Delete This Category" title="Delete This Category"></a> |;
      }
      if ($group_cat_move_per) {
         $admin_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=move_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_move.$ButtonExt" border="0" alt="Move This Category" title="Move This Category"></a> |;
      }
      if ($group_cat_ren_per) {
         $admin_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=rename_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_rename.$ButtonExt" border="0" alt="Rename This Category" title="Rename This Category"></a> |;
      }
      if ($group_cat_desc_per) {
         $admin_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=describe_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_describe.$ButtonExt" border="0" alt="Edit This Category Description" title="Edit This Category Description"></a> |;
      }
      if ($group_cat_upload_per) {
         $admin_tools .= qq|<a href="javascript:adminPopup('$imagefolio_url?admin=image_category$current','$admin_popup_options')"><img src="$if_images_directory/fe_admin_category_image.$ButtonExt" border="0" alt="Upload and Add Category Image" title="Upload and Add Category Image"></a> |;
      }
      if ($admin_tools) {
         if ($group_media_upload_per) {
            $admin_tools = qq|<a href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')"><img src="$if_images_directory/fe_admin_upload_media.$ButtonExt" border="0" alt="Upload New Files" title="Upload New Files"></a> <img src="$if_images_directory/fe_admin_div.$ButtonExt" border="0"> $admin_tools|;
         }
         $admin_tools = qq|<tr bgcolor="$main_header_bgcolor"><td align="center" nowrap valign="bottom" height="30">$admin_tools</td></tr>|;
      }
      elsif ($group_media_upload_per) {
         $upload_button = qq|<a href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')"><img src="$if_images_directory/upload.$ButtonExt" border=0 alt="Upload New Files" title="Upload New Files"></a>|;
         $upload_button_text_nav = qq| <a href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')" alt="Upload New Files" title="Upload New Files">Upload Files</a> \||;
         $upload_button_text_nav = qq| \| <a class=nav href="javascript:adminPopup('$imagefolio_url?admin=upload_image$current','width=500,height=540,scrollbars=yes')" alt="Upload New Files" title="Upload New Files">Upload</a>| if $ifc;
      }
   }
   if ($upload_button_text_nav){
      $template =~ s/%%%UPLOAD_BUTTON_NEXT_NAV%%%/$upload_button_text_nav/ig;
   }
}

sub create_user_image_tools {
   my $input = shift;
   $current = "&admin_directory=$input"; #Category
   $current .= "&admin_image1=$admin_image1"; #preview image
   $current .= "&admin_image2=$admin_image2"; #thumbnail image
   $create_user_image_tools = "\n";
   if ($use_textlinks) {
      $create_user_image_tools .= qq|textlink_B = '<table border=0 cellspacing=0 cellpadding=2><tr><td align=center nowrap bgcolor="#ffffcc"><font size=1 face="arial,helvetica">\|';\n|;
      $create_user_image_tools .= qq|rename_me = " <a href=\\"javascript:adminPopup('$imagefolio_url?admin=rename_confirm_image$current','width=500,height=500,scrollbars=no');\\" class=textnav onclick=\\"setHref();\\">rename</a> \|";\n|;
      $create_user_image_tools .= qq|caption_me = " <a href=\\"javascript:adminPopup('$imagefolio_url?admin=caption_confirm_image$current','width=500,height=540,scrollbars=yes');\\" class=textnav onclick=\\"setHref();\\">info</a> \|";\n|;
      $create_user_image_tools .= qq|delete_me = " <a href=\\"javascript:adminPopup('$imagefolio_url?admin=delete_confirm_image$current','width=500,height=500,scrollbars=no');\\" class=textnav onclick=\\"setHref();\\">delete</a> \|";\n|;
      $create_user_image_tools .= qq|move_me = " <a href=\\"javascript:adminPopup('$imagefolio_url?admin=move_confirm_image$current','width=500,height=540,scrollbars=yes');\\" class=textnav onclick=\\"setHref();\\">move</a> \|";\n|;
      $create_user_image_tools .= qq|textlink_E = '</font></td></tr></table>';\n|;
   }
   else {
      $create_user_image_tools .= qq|rename_me = "<a href=\\"javascript:adminPopup('$imagefolio_url?admin=rename_confirm_image$current','width=500,height=500,scrollbars=no');\\" onclick=\\"setHref();\\"><img src=\\"$if_images_directory/pic_rename.$ButtonExt\\" border=0 alt=\\"Rename\\" title=\\"Rename\\"></a> ";\n|;
      $create_user_image_tools .= qq|caption_me = "<a href=\\"javascript:adminPopup('$imagefolio_url?admin=caption_confirm_image$current','width=500,height=540,scrollbars=yes');\\" onclick=\\"setHref();\\"><img src=\\"$if_images_directory/pic_caption.$ButtonExt\\" border=0 alt=\\"Caption\\" title=\\"Caption\\"></a> ";\n|;
      $create_user_image_tools .= qq|delete_me = "<a href=\\"javascript:adminPopup('$imagefolio_url?admin=delete_confirm_image$current','width=500,height=500,scrollbars=no');\\" onclick=\\"setHref();\\"><img src=\\"$if_images_directory/pic_delete.$ButtonExt\\" border=0 alt=\\"Delete\\" title=\\"Delete\\"></a> ";\n|;
      $create_user_image_tools .= qq|move_me = "<a href=\\"javascript:adminPopup('$imagefolio_url?admin=move_confirm_image$current','width=500,height=540,scrollbars=yes');\\" onclick=\\"setHref();\\"><img src=\\"$if_images_directory/pic_move.$ButtonExt\\" border=0 alt=\\"Move\\" title=\\"Move\\"></a> ";\n|;
   }
   return $create_user_image_tools
}

sub one_time_access_login {
   require "$config_directory/admin_config.pl";
   $one_time_access = &admin_decrypt($FORM{'ota'}, $secret_key);
   if ($FORM{'admin'} && $FORM{'admin_image1'}) {
      $ota_compare = "$FORM{'admin_directory'}/$FORM{'admin_image1'}";
   }
   elsif ($FORM{'admin'}) {
      $ota_compare = $FORM{'admin_image2'};
      $ota_compare =~ s/^$mypattern//ig;
      $ota_compare = "$FORM{'admin_directory'}/$ota_compare";
   }
   else {
      $ota_compare = "$FORM{'link'}/$FORM{'image'}";
   }
   if (lc($one_time_access) eq lc($ota_compare)) {
      $cache_page_age = ();
      $is_user = 1;
      $ifusername = "<i>One Time Access</i>";
      $ifusername_display = $ifusername;
      $group_skins_access = $skin_name;
      $group_cat_access = $current_cat_root;
      $group_preview_view_per = 1;
      $group_preview_protect_per = 1;
      $group_watermark_per = 1;
      $group_full_size_per = 1;
#      $group_post_access
#      $group_media_upload_per
#      $group_media_main_cat_per
#      $group_media_upload_approval
#      $group_media_ren_per
#      $group_media_mov_per
#      $group_media_del_per
#      $group_media_desc_per
#      $group_media_fs_per
#      $group_cat_add_per
#      $group_cat_ren_per
#      $group_cat_move_per
#      $group_cat_del_per
#      $group_cat_upload_per
#      $group_cat_desc_per
      &translate_settings;
   }
   else {
      $one_time_access = ();
      $user_session_id = int(rand(1234567890)) + time;
      $user_sessionfile = "$sessions_dir/$user_session_id.user";
   }
}
###############################################################################
# SHOW LOGIN INFO
# The login name is shown with a button to sign-in sign-out.
###############################################################################

sub show_login_info {
#   my $commerce_added = "commerce=store&" if $ifc;
   if (!$FORM{'from_login'}) {
      $from_login = qq|&from_login=1|;
      $ifusername_login_box = $ifusername_display;
   }
   if ($confirmed_guest) {
      if ($full_query) {
         $encrypt_full_query = &admin_encrypt("$full_query$from_login", $guest_username);
         $encrypt_full_query = '&start=' . $encrypt_full_query;
      }
      $sign_in_out_box =~ s/%%%SIGN_IN_OUT_LINK%%%/$imagefolio_url?${commerce_added}login=1$encrypt_full_query/i;
      if (!$use_textlinks) {
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT%%%/<img src="$if_images_directory\/sign_in.$ButtonExt" border=0>/i;
      }
      else {
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT%%%/<$font>Login<\/font>/i;
      }
      $sign_in_out_box =~ s/%%%SIGN_IN_OUT_BUTTON%%%/<img src="$if_images_directory\/sign_in.$ButtonExt" border=0>/i;
      $sign_in_out_box =~ s/%%%SIGN_IN_OUT_TEXT%%%/<$font>Login<\/font>/i;
      $ifusername_login_box = $ifusername_display;
   }
   elsif ($is_admin) {
      $ifusername = "Administrator";
      $ifusername_display = $ifusername;
      if ($full_query && !$FORM{'login'} && !$FORM{'ota'}) {
         $new_query = "&$full_query$from_login&from_logout=1";
      }
      if (($build_per eq 'Yes') && $remind_rebuild) {
         my $admin_signout_js = qq|
         function admin_signout() {
            rebuild = confirm("Do you want to rebuild the index before you sign out? (OK = Yes   Cancel = No)");
            if (rebuild == true) {
               location.href = "$buildurl&log_out_option=1";
            }
            else {
               location.href = "$imagefolio_url?admin=log_out$new_query";
            }
            return true;
         }|;
         my $admin_signout_link = "javascript:admin_signout();";
         $sign_in_out_box =~ s/%%%ADMIN_SIGNOUT_JS%%%/$admin_signout_js/i;
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT_LINK%%%/$admin_signout_link/i;
      }
      else {
          $sign_in_out_box =~ s/%%%SIGN_IN_OUT_LINK%%%/$imagefolio_url?admin=log_out$new_query/i;
      }
      if (!$use_textlinks) {
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT%%%/<img src="$if_images_directory\/sign_out.$ButtonExt" border=0>/i;
      }
      else {
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT%%%/<$font>Logout<\/font>/i;
      }
      $sign_in_out_box =~ s/%%%SIGN_IN_OUT_BUTTON%%%/<img src="$if_images_directory\/sign_out.$ButtonExt" border=0>/i;
      $sign_in_out_box =~ s/%%%SIGN_IN_OUT_TEXT%%%/<$font>Logout<\/font>/i;
      $ifusername_login_box = $ifusername_display;
   }
   else {
      if ($homelink) {
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT_LINK%%%/$homelink/i;
      }
      else {
#         if ($full_query && !$FORM{'login'} && !$FORM{'ota'}) {
#            $new_query = "?$full_query$from_login&log_out=1";
#         }
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT_LINK%%%/$imagefolio_url$new_query/i;
      }
      if (!$use_textlinks) {
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT%%%/<img src="$if_images_directory\/sign_out.$ButtonExt" border=0>/i;
      }
      else {
         $sign_in_out_box =~ s/%%%SIGN_IN_OUT%%%/<$font>Logout<\/font/i;
      }
      $sign_in_out_box =~ s/%%%SIGN_IN_OUT_BUTTON%%%/<img src="$if_images_directory\/sign_out.$ButtonExt" border=0>/i;
      $sign_in_out_box =~ s/%%%SIGN_IN_OUT_TEXT%%%/<$font>Logout<\/font>/i;
#      $ifusername_login_box = qq|<a href="$imagefolio_url?${commerce_added}account=edit"><$font>$ifusername_display</font></a>|;
      if ($user_registration == 1) {
         $ifusername_login_box = qq|<a href="$imagefolio_url?${commerce_added}account=edit"><$font>$ifusername_display</font></a>|;
      }
      else {
         $ifusername_login_box = qq|$ifusername_display|;
      }
   }
   $sign_in_out_box =~ s/%%%USER_NAME%%%/$ifusername_login_box/i;
   $sign_in_out_box =~ s/%%%FONT%%%/$font/ig;
}


sub compare_cat {
   my $input = shift;
   if ($allow_free_post_access) {
      if (!$group_media_main_cat_per && ($input =~ /\//i)) {
         $approve_action = 1;
      }
      elsif ($group_media_main_cat_per) {
         $approve_action = 1;
      }
   }
   else {

#      if (!$group_media_main_cat_per && !$personal_category) {
#         $sub_cat_check = "/";
#      }
#      elsif ($personal_category && $personal_category_block) {
#         $sub_cat_check = "/";
#      }
#      foreach $current_post (@current_post_access) {
#         $current_post .= $sub_cat_check;
#         if ($input =~ /^$current_post/i) {
#            $approve_action = 1;
#            last;
#         }
#      }

      foreach $current_post (@current_post_access) {
         if ($input =~ /^$current_post\//i) {
            $approve_action = 1;
            last;
         }
         elsif ($input eq $current_post && !$block_main_cat) {
            $approve_action = 1;
            last;
         }
      }

#      if ((!$group_media_main_cat_per && !$personal_category) or ($personal_category && $personal_category_block)) {
#         foreach $current_post (@current_post_access) {
#           if ($input =~ /^$current_post\//i) {
#              $approve_action = 1;
#              last;
#           }
#         }
#      }
#      else {
#         foreach $current_post (@current_post_access) {
#            if ($input eq $current_post or $input =~ /^$current_post\//i) {
#               $approve_action = 1;
#               last;
#            }
#         }
#      }
   }
   if (!$skip_error_message) {
      if (!$approve_action && $input) {
         &Error("Sorry $ifusername, you do not have access to the category \"$input\".");
      }
      elsif ($block_main_cat && !$input) {
         &Error("Sorry $ifusername, you must select a sub category.");
      }
   }
}

1;