####CODEHEADER###

if (!$commandline) {
   require "$currdir/if_lib/init.pl";
}
if ($use_im) {
   require "$libpath/imagemagick.pl";
}
else {
#      if (!$crop_thumb_width or !$crop_thumb_height) {
#         $fast_processing = 1;
#         $imageconvert_log = ();
#      }
   require "$libpath/imageconvert.pl"; &load_ic;
}
if (!$is_admin && $ENV{'HTTP_USER_AGENT'}) {
   &Error("Sorry , you do not have permission to create thumbnails.");
}
require "$libpath/iptc.pl";

#$autorotate = 0;
#
#$exif_rotation = { top_left   => [   0, ''  ],    # 1: no corr. needed
#                   top_right  => [   0, 'v' ],    # 2: flop (V)
#                   bot_right  => [ 180, ''  ],    # 3: 180
#                   bot_left   => [   0, 'h' ],    # 4: flip (H)
#                   left_top   => [  90, 'h' ],    # 5: flip 90
#                   right_top  => [  90, ''  ],    # 6: 90
#                   right_bot  => [  90, 'v' ],    # 7: flop 90
#                   left_bot   => [ 270, ''  ],    # 8: 270
#                 };

&top;


# No editing is necessary
###############################################################################

###############################################################################
# TOP
# Determines what to do
###############################################################################
sub top {
   $| = 1;
   &get_date;
   &doit;
}

###############################################################################
# DOIT
# Prints the HTML Results
###############################################################################
sub doit {

   if ($admin_demo_mode) {
      &Error("$admin_demo_html");
   }

   if ($FORM{'category'}) { $start_cat = "/$FORM{'category'}";}
   elsif ($FORM{'direct'}) { $start_cat = "/$FORM{'direct'}";}

   if ($use_fullsize && lc($myextension_fullsize) eq 'zip') {
      eval "use Archive::Zip qw(:CONSTANTS :ERROR_CODES);1;" or $use_fullsize = ();
   }
   elsif ($myextension_fullsize !~ /(jpg|tif|pdf|eps)/i) {
      $use_fullsize = ();
   }



   if (!$commandline) {
      print "Content-type: text/html\n\n";
      print qq|
      <html>
      <head>
      <title>ImageFolio Batch Thumbnail Mod</title></head>
      <body bgcolor="#ffffff">
      |;
   }





   $starttime = time();
   unless (-e $image_directory) {
      print "Fatal Error!\n";
      print "Searched for a directory at specified location:\n";
      print "    $image_directory\n";
      print "No directory found. Check settings.\n";
      exit;
   }
   if (!$commandline) {
      print "<h2>ImageFolio Batch Thumbnail Mod</h2>";
      print "<b><a href=\"$adminurl\">Return to Admin Area</a> / <a href=\"$buildurl\">Rebuild Index</a></b> (please wait for page to load)<br><pre>";
   }
   else {
      print "--------------------------------------------------------\n";
      print "---      B A T C H     T H U M B N A I L I N G      ----\n";
      print "--------------------------------------------------------\n";
   }
   print "$date\n";
   print "--------------------------------------------------------\n";
   print "** Processing Image Index . . .\n\n";
   &spider_directory;
   $stoptime = time();
   $elapsed = $stoptime - $starttime;
   print "\nDone! ($elapsed seconds)\n\n";
   if (!$commandline) {
      print "</pre></body></html>";
   }

}


###############################################################################
# SPIDER DIRECTORY
# Spiders the $image_directory and looks for images that need thumbnails built
###############################################################################
sub spider_directory {

   print "Spidering directory tree (${image_directory}${start_cat}) and gathering data...\n\n";

   @previewimages = ();
   @directories = ("${image_directory}${start_cat}");
   $totaldir = 1;
   $totalnames = "0";
   $totalzipnames = "0";

   for ($i=0; $i<$totaldir; $i++) {
      $directory = @directories[$i];
      $path = $directory;
      $path =~ s/^$image_directory\///;
      $in_pv_files = ();
      $in_fs_files = ();
      $total_pv_files = "0";
      $total_fs_files = "0";
      @neworigials = ();
      @newpreviews = ();
      @newthumbs = ();
      opendir(DIR,$directory);
      @listings = readdir(DIR);
      closedir(DIR);

      foreach $listing (@listings) {
         next if (($listing eq ".") or ($listing eq "..") or ($listing =~ /_vti_cnf/i));
         $fullpath = "$directory/$listing";
         $fullpath =~ s/\\/\//g;
         if (-d $fullpath) {
            if ($listing =~ /[\s]/i) {
               $listing =~ s/ /_/g;
               rename ("$fullpath", "$directory/$listing") or &Error ("Could not rename a category to $listing in order to remove the spaces, Reason: $!");
               $fullpath = "$directory/$listing";
            }
            if ($listing =~ /[$deny_chars]/i) {
               &Error("Invalid characters in category name '$listing'. A Category cannot contain any of the following characters:<br> $deny_characters");
            }
            push(@directories,$fullpath);
            $totaldir++;
         }
         elsif ($fullpath && ($listing !~ /^$mypattern/i) && ($listing !~ /^$mypattern_fullsize/i) && ($listing ne "_category_image.jpg")) {
            my ($base) = $listing =~ m,^(.*)\.\w+$,;
            $found_thumb = ();
            if ((-e "$directory/$mypattern$base.jpg") ||
                (-e "$directory/$mypattern$base.JPG") ||
                (-e "$directory/$mypattern$base.gif") ||
                (-e "$directory/$mypattern$base.GIF")) { $found_thumb = 1;
            }
            if (($recreate_thumbs or !$found_thumb) && ($listing =~ /(.jpg$|.tif$|.png$|.psd$|.pcd$|.bmp$|.gif$|.pdf$|.eps$)/i)){
               if ($fast_processing) {
                  my ($extension) = ($listing =~ /\.([^.]+)$/);
                  $extension = lc($extension);
                  $base =~ s/ /_/g;
                  $base =~ s/\.//g;
                  $base =~ s/[$deny_chars]//g;
                  if ($use_fullsize && !-e "$directory/$mypattern_fullsize$base.$myextension_fullsize") {
                     rename ("$fullpath", "$directory/batchtodo-$base.$myextension_fullsize");
                     push(@neworigials, "batchtodo-$base.$myextension_fullsize|$mypattern_fullsize$base.$myextension_fullsize");
                     push(@newpreviews, "preview-batchtodo-$base.jpg|$base.jpg|$mypattern$base.jpg");
                     $total_fs_files++;
                  }
                  else {
                     rename ("$fullpath", "$directory/preview-batchtodo-$base.jpg");
                     push(@newpreviews, "preview-batchtodo-$base.jpg|$base.$extension|$mypattern$base.jpg");
                  }
                  $total_pv_files++;
               }
               else {
                  push(@previewimages, "$path|$listing");
                  print "Captured : $path/$listing\n";
                  $totalnames++;
               }
            }
            elsif ($use_fullsize && lc($myextension_fullsize) eq 'zip') {
                  push(@zippreviewimages, "$path|$listing");
                  print "Captured : $path/$listing\n";
                  $totalzipnames++;
            }
         }
      }

      if ($fast_processing) {
         print "Processing $path: ";
         if ($total_fs_files) {
            &do_ic("$directory/batchtodo-*.$myextension_fullsize", "$directory/preview-%.jpg", $ImageDimensions, $ImageQuality, $ImageSharpness, $ImageContrast, $ImageCustom, '', '', '', 'decr', '', '');
            foreach $neworigial (@neworigials) {
               my ($old, $new) = split (/\|/, $neworigial);
               rename ("$directory/$old", "$directory/$new");
               chmod (0777, "$directory/$new");
            }
         }
         if ($use_fullsize) {
            print "$total_fs_files previews made, ";
         }
         if ($total_pv_files) {
            &do_ic("$directory/preview-batchtodo-*.jpg", "$directory/thumbnail-%.jpg", $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCustom, '', '', '', 'decr', '', '');
            foreach $newpreview (@newpreviews) {
               my ($old, $new, $thumb) = split (/\|/, $newpreview);
               rename ("$directory/$old", "$directory/$new");
               chmod (0777, "$directory/$new");
               rename ("$directory/thumbnail-$old", "$directory/$thumb");
               chmod (0777, "$directory/$thumb");
            }
         }
         print "$total_pv_files thumbnails made\n";
      }
   }

   if (!$fast_processing) {
      if ($totalnames eq "0") { print "Nothing available to thumbnail.\n";  }
      $i = ();
      $Number_Files = "0";
      if ($totalnames >= 1) {
         $ThumbCustom .= " -rmeta";
         print "\nCaptured $totalnames images to process.\n\n";
         print "Processing Images...\n";
         foreach $previewimage (@previewimages) {
            $source_iptc_info = undef;
            $thisrotation = ();
            my ($path, $file) = split (/\|/, $previewimage);
            my $filetoread = "$image_directory/$path/$file";
            my($camerainfo) = image_info("$filetoread");

            if (defined($camerainfo->{'Orientation'}) && $autorotate) {
#               print "Orientation: " . $exif_rotation->{$camerainfo->{'Orientation'}}[0] if exists $exif_rotation->{$camerainfo->{'Orientation'}};
               $thisrotation = " -rotate $exif_rotation->{$camerainfo->{'Orientation'}}[0]" if exists $exif_rotation->{$camerainfo->{'Orientation'}};
            }




#            ($filedate)  = (stat("$filetoread"))[9];
            $filedate = $current_time;
#            $filedate = time();
            my ($base) = $file =~ m,^(.*)\.\w+$,;
            ($extension) = ($file =~ /\.([^.]+)$/);
#           START DOES NOT WORK ON MOST *NIX SYSTEMS
#            if ($extension =~ /(jpg|tif)/i) {
#               chmod (0777, $filetoread);
#               &add_user_info($filetoread);
#            }
#           END DOES NOT WORK ON MOST *NIX SYSTEMS
            $base =~ s/ /_/g;
            $base =~ s/\.//g;
            $base =~ s/[$deny_chars]//g;
            if (!$base) {
               unlink ($filetoread);
               $Number_Files++;
               print "File deleted (invalid): $file - $path\n";
               next;
            }
            if ($use_fullsize) {
               $neworiginal = qq|$mypattern_fullsize$base.$myextension_fullsize|;
               $neworiginaltowrite = qq|$image_directory/$path/$neworiginal|;
               if (!-e $neworiginaltowrite) {
                  if (lc($myextension_fullsize) eq 'zip') {
                     my $zip = Archive::Zip->new();
                     my $zip_extension = lc ($extension);
                     $zip->addFile( "$filetoread", "$base.$zip_extension" );
                     my $member = $zip->memberNamed("$base.$zip_extension");
                     $member->desiredCompressionMethod( 0 );
                     $zip->writeToFileNamed( "$neworiginaltowrite" );
                     chmod (0777, $neworiginaltowrite);
                     &create_imagefile($filetoread, "$image_directory/$path/$mypattern$base.jpg");
                     chmod (0777, "$image_directory/$path/$mypattern$base.jpg");
                     unlink ($filetoread);
                     $filetoread = "$image_directory/$path/$base.jpg";
                     rename ("$image_directory/$path/$mypattern$base.jpg", $filetoread);
                  }
                  else {
                     rename ("$filetoread", "$neworiginaltowrite");
                     chmod (0777, $neworiginaltowrite);
                     $filetoread = "$image_directory/$path/$base.jpg";
                     &create_imagefile($neworiginaltowrite, $filetoread);
                     chmod (0777, $filetoread);
                  }
                  print "High Res saved : $neworiginal - $path\n";
                  print "Preview made : $base.jpg - $path\n";
               }
            }
            else {
               &create_imagefile($filetoread, "$image_directory/$path/$mypattern$base.jpg");
               chmod (0777, "$image_directory/$path/$mypattern$base.jpg");
               unlink $filetoread;
               $filetoread = "$image_directory/$path/$base.jpg";
               rename ("$image_directory/$path/$mypattern$base.jpg", $filetoread);
               print "Preview made : $base.jpg - $path\n";
            }
            &add_user_info($filetoread);
            $file = "$mypattern$base.jpg";
            $filetowrite = "$image_directory/$path/$file";
            &create_thumbnail($filetoread, $filetowrite);
            chmod (0777, $filetowrite);
            &add_user_info($filetowrite);
            $Number_Files++;
            print "Thumbnail made : $file - $path\n";
         }
         if ($Number_Files eq "0") { print "No images to processe.\n";}
         print "\nProcessed $Number_Files images total.\n\n";
      }
   }

   if ($use_fullsize && lc($myextension_fullsize) eq 'zip') {
      if ($totalzipnames eq "0") { print "Nothing available to compress.\n";  }
      $i = ();
      $Number_Files = "0";
      if ($totalzipnames >= 1) {
         print "\nCaptured $totalzipnames files to compress.\n\n";
         print "Processing Files...\n";
         require File::Copy;
         foreach $zippreviewimages (@zippreviewimages) {
            $source_iptc_info = undef;
            my ($path, $file) = split (/\|/, $zippreviewimages);
            my $filetoread = "$image_directory/$path/$file";
            $filedate = $current_time;
            my ($base) = $file =~ m,^(.*)\.\w+$,;
            ($extension) = ($file =~ /\.([^.]+)$/);
            my $used_icon = $extensions{$extension}[4];
            if ($used_icon) {
               $base =~ s/ /_/g;
               $base =~ s/\.//g;
               $base =~ s/[$deny_chars]//g;
               if (!$base) {
                  unlink ($filetoread);
                  $Number_Files++;
                  print "File deleted (invalid): $file - $path\n";
                  next;
               }
               $neworiginal = qq|$mypattern_fullsize$base.$myextension_fullsize|;
               $neworiginaltowrite = qq|$image_directory/$path/$neworiginal|;
               if (!-e $neworiginaltowrite) {
                  my $zip = Archive::Zip->new();
                  my $zip_extension = lc ($extension);
                  $zip->addFile( "$filetoread", "$base.$zip_extension" );
                  my $member = $zip->memberNamed("$base.$zip_extension");
                  $member->desiredCompressionMethod( 0 );
                  $zip->writeToFileNamed( "$neworiginaltowrite" );
                  chmod (0777, $neworiginaltowrite);
                  unlink ($filetoread);
                  &File::Copy::copy ("$icons_path/$used_icon", "$image_directory/$path/$mypattern$base.jpg");
                  chmod (0777, "$image_directory/$path/$mypattern$base.jpg");
                  &add_user_info("$image_directory/$path/$mypattern$base.jpg");
                  &File::Copy::copy ("$icons_path/$used_icon", "$image_directory/$path/$base.jpg");
                  chmod (0777, "$image_directory/$path/$base.jpg");
                  &add_user_info("$image_directory/$path/$base.jpg");
                  print "File compressed : $neworiginal - $path\n";
                  $Number_Files++;
               }
               else {
                  print "File skipped (already exist) : $neworiginal - $path\n";
               }
            }
            else {
               print "File skipped (file type undefined): $file - $path\n";
            }
         }
         print "\nCompressed $Number_Files files total.\n\n";
      }
   }
}

sub add_user_info {
   my $input = shift;
   @IPTC_attributes = ('caption/abstract','writer/editor','headline','special instructions','copyright notice','credit','source','object name','date created','by-line','by-line title','city','province/state','country/primary location name','original transmission reference','contact','content location code','content location name','country/primary location code','digital creation date','digital creation time','edit status','editorial update','expiration date','expiration time','fixture identifier','image orientation','image type','language identifier','object cycle','originating program','program version','reference date','reference number','reference service','release date','release time','sub-location','subject reference','time created','urgency','custom1','custom2','custom3','custom4','custom5','custom6','custom7','custom8','custom9','custom10','custom11','custom12','custom13','custom14','custom15','custom16','custom17','custom18','custom19','custom20');
   if (defined($source_iptc_info)) {
      $createinfo = create Image::IPTCInfo("$input");
      $createinfo->ClearKeywords();
      $createinfo->ClearSupplementalCategories();
      my $keywordsRef = $source_iptc_info->Keywords();
      if ($keywordsRef) {
         foreach $keyword (@$keywordsRef) {
            $createinfo->AddKeyword("$keyword");
         }
      }
      foreach $IPTC_attribute (@IPTC_attributes) {
         $iptcvalue = $source_iptc_info->Attribute("$IPTC_attribute");
         $createinfo->SetAttribute("$IPTC_attribute","$iptcvalue");
       }
      $createinfo->Save();
   }
   else {
      $createinfo = create Image::IPTCInfo("$input");
      $createinfo->SetAttribute('originating program','www.imagefolio.com');
      $createinfo->SetAttribute('program version','4.x');
      $createinfo->SetAttribute('custom18',"[$filedate][][][][$extension]");
      $createinfo->Save();
   }
   if (!$source_iptc_info) {
      $source_iptc_info = new Image::IPTCInfo("$input");
   }
}

###############################################################################
# CREATE IMAGE
# Creates our image
###############################################################################
sub create_imagefile {
   my ($file_in, $file_out) = @_;
   if (!$use_im) {
      &do_ic("\"$file_in\"", "\"$file_out\"", $ImageDimensions, $ImageQuality, $ImageSharpness, $ImageContrast, "$ImageCustom$thisrotation", '', '', '', 'decr', '', '');
   }
   else {
      &do_im($file_in, $file_out, $ImageDimensions, $ImageQuality, $ImageSharpness, $ImageContrast);
   }
   $thisrotation = ();
}

###############################################################################
# CREATE THUMBNAIL
# Creates our thumbnail image
###############################################################################
sub create_thumbnail {

   my ($file_in, $file_out) = @_;

   if ($crop_thumb_width && $crop_thumb_height) {
      my ($ftw_width, $ftw_height) = imgsize("$file_in");
      if ($ftw_width && $ftw_height) {
         $width_factor = $ftw_width/$crop_thumb_width;
         $height_factor = $ftw_height/$crop_thumb_height;
         if ($width_factor > $height_factor) {
            $ThumbDimensions = $ftw_width/$height_factor;
            $ThumbCrop = ($ThumbDimensions-$crop_thumb_width)/2;
            ($ThumbCrop) = split(/\./,$ThumbCrop);
            $ThumbCrop_im = "${crop_thumb_width}x${crop_thumb_height}+${ThumbCrop}+0";
            $ThumbCrop_ic = "${ThumbCrop} 0 ${crop_thumb_width} ${crop_thumb_height}";
         }
         else {
            $ThumbDimensions = $ftw_height/$width_factor;
            $ThumbCrop = ($ThumbDimensions-$crop_thumb_height)/2;
            ($ThumbCrop) = split(/\./,$ThumbCrop);
            $ThumbCrop_im = "${crop_thumb_width}x${crop_thumb_height}+0+${ThumbCrop}";
            $ThumbCrop_ic = "0 ${ThumbCrop} ${crop_thumb_width} ${crop_thumb_height}";
         }
      }
   }

   if (!$use_im) {
      &do_ic("\"$file_in\"", "\"$file_out\"", $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCustom, $ThumbCrop_ic, '', '', 'decr', '', '');
   }
   else {
      &do_im($file_in, $file_out, $ThumbDimensions, $ThumbQuality, $ThumbSharpness, $ThumbContrast, $ThumbCrop_im);
   }
}

###############################################################################
# GET DATE
# Gets the current date
###############################################################################
sub get_date {

   @days   = ('Sunday','Monday','Tuesday','Wednesday', 'Thursday','Friday','Saturday');
   @months = ('January','February','March','April','May','June','July',
              'August','September','October','November','December');
   @smonths = ('01','02','03','04','05','05','07','08','09','10','11','12');

   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $time = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
   $year += 1900;

   $date = "$days[$wday], $months[$mon] $mday, $year at $time";
   $sdate = "$smonths[$mon]-$mday-$year";
}

1;