####CODEHEADER###

   require "$currdir/if_lib/init.pl";
   require "$config_directory/card_config.pl";
   &top;


###############################################################################
# TOP
# Where we decide what needs to be done!
###############################################################################
sub top {
   $| = 1;   # flush output

   &load_values;

   if ($watermark && !$antileech) {
      $imageurl = $imagefolio_url . "?main=imageLeech&source=IF&ct=$current_time&file=";
      $imageurl =~ s/^http\:/https\:/i if lc($ENV{'HTTPS'}) eq 'on';
   }
#   if (lc($ButtonExt) eq "png") {
#      $if_js_code = qq|<SCRIPT LANGUAGE="JavaScript">pngfixgif = "$base_if_url/pixel.gif";</SCRIPT><style type="text/css">img { behavior: url("$base_if_url/pngbehavior.htc");}</style>|;
#   }

   $if_js_code = qq|<SCRIPT LANGUAGE="JavaScript">ButtonExt = '$ButtonExt';do_png_fix = 0;pngfixgif = new Image();pngfixgif.src = "$base_if_url/pixel.gif";</SCRIPT>|;
   $if_js_code .= qq|<SCRIPT LANGUAGE="JavaScript" SRC="$base_if_url/pngload.js"></SCRIPT><style type="text/css">img { behavior: url("$base_if_url/pngbehavior.htc");}</style>| if (lc($ButtonExt) eq "png");


   if    ($FORM{'action'} eq "ecard")   { &view_ecard;   }
   elsif ($FORM{'action'} eq "preview") { &preview_card; }
   elsif ($FORM{'action'} eq "send")    { &send_card;    }
}


###############################################################################
# PREVIEW CARD
# Gets the template, prints it out, provides a return link URL to go back and
# make changes
###############################################################################
sub preview_card {
   &check_input;
   &get_template;
   print "Content-type: text/html\n\n";
   print $template;
}

###############################################################################
# SEND CARD
# Verifies the input, deletes old cards, sends email, saves data, etc.
###############################################################################
sub send_card {

   &check_input;
   &get_date;
   &remove_old_cards;
   &get_card_url;

   &get_template;

   if (!$is_admin && $postcard_log) { &save_postcard_data; }

   print "Content-type: text/html\n\n";
   print $template;

   $template = ();
   $FORM{'action'} = ();
   &get_template;

   &send_email;

   open(CARD,">$postcard_file") or &Error("Could not open $postcard_file: $! ");
   print CARD $template;
   close CARD;
   chmod(0644,$postcard_file);

}


###############################################################################
# REMOVE OLD CARDS
# Searches the postcard directory for files older than $exp days, and removes
# them from your web space
###############################################################################
sub remove_old_cards {

   opendir (CARDS, "$cards_directory") or &Error("Could not open $cards_directory: $! ");
   @cards = grep { /$cardext/ } readdir(CARDS);
   closedir (CARDS);
   $CARDSIZE = @cards;

   if ($CARDSIZE > 1) {
     foreach $card (@cards) {
        if (-M "$cards_directory/$card" > $exp) {
           unlink("$cards_directory/$card") unless $card =~ /index/i;
        }
     }
   }
}

###############################################################################
# SEND EMAIL
# Sends notification email to the recipient
###############################################################################
sub send_email {

   $notification_message =~ s/%%%SENDER_NAME%%%/$sendername/ig;
   $notification_message =~ s/%%%RECIPIENT%%%/$cardrecipient/ig;
   $notification_message =~ s/%%%CARD_URL%%%/$postcard_url/ig;
   $notification_message =~ s/%%%DATE%%%/$date/ig;

   my $from_out = "$senderemail";
   my $to_out = $cardrecipient;
   my $cc_out = ();
   if ($receive_copy) {
      $bcc_out = $admin_email;
   }
   my $subject_out = "[postcard] $cardgreeting";
   if ($FORM{'html_email'}) {
      $type_out_0 = 'text/html';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
      $data_out_0 = $template;
      $template =~ s/%%HTML_EMAIL_LINK%%//ig;
      $data_out_0 =~ s/%%HTML_EMAIL_LINK%%/<br><$font>Click <a href="$postcard_url">here<\/a> for an online version of this card if you can't see and\/or hear it.<\/font>/ig;
      if ($antileech) {
         require "$libpath/crypt.pl";
         $encrypt_imageleech_link = &admin_encrypt("$cardurl", $image_directory);
         $template =~ s/%%SRC_FILE%%/$imageurl$cardurl&ldc=$encrypt_imageleech_link/ig;
         $data_out_0 =~ s/%%SRC_FILE%%/$imageurl$cardurl&ldc=$encrypt_imageleech_link/ig;
#         $template =~ s/%%SRC_FILE%%/$new_imageurl$cardurl/ig;
#         $data_out_0 =~ s/%%SRC_FILE%%/$new_imageurl$cardurl/ig;

#         $imageurl =~ s/&/&amp;/ig;
#         $mod_imageurl = $imageurl;
#         $mod_imageurl =~ s/\&/\&amp\;/ig;
#         $data_out_0 =~ s/$imageurl/$new_imageurl/ig;
#         $data_out_0 =~ s/Click/tttttttt/ig;
#         $data_out_0 .= qq|<br><input type="text" name="textfield" value="$imageurl" size="120"><br><input type="text" name="textfield" value="$mod_imageurl" size="120"><br><input type="text" name="textfield" value="$new_imageurl" size="120">|;
      }
   }
   else {
      $type_out_0 = 'text/plain';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
      $data_out_0 = $notification_message;
   }

   &send_mime_email($from_out,$to_out, $cc_out, $bcc_out, $subject_out, $type_out_0, $data_out_0, $type_out_1, $data_out_1, $type_out_2, $id_out, $path_out);
}

###############################################################################
# GET CARD URL
# Generates a unique number and generates the URL to our postcard
###############################################################################
sub get_card_url {
   $cardnum       = reverse time;
   $cardnum       = substr($userid, 0, 4);
   $cardnum       = $userid * 1321;
   $cardnum       = rand $userid;
   $cardnum       =~ s/\.//g;
   $postcard_file = "$cards_directory/$cardnum$cardext";
   $postcard_url  = "$cards_url/$cardnum$cardext";
}

###############################################################################
# GET TEMPLATE
# Looks in the category for an existing template, if it finds it, it uses it
# for the postcard, otherwise we get the default template
###############################################################################
sub get_template {

   $cardname = "send_card.html";
   $temp_to_use = $send_template;

   if (-e "$image_directory/$link/$cardname") {
      open (TEMPLATE,"$image_directory/$link/$cardname") or &Error("Could not open template.  Reason $!");
   }
   else {
      open (TEMPLATE,"$temp_to_use") or &Error("Could not open template.  Reason $!");
   }
   while (<TEMPLATE>) {
      if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_include($2); }
      elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_exec_include($2); }
      else { $template .= $_; }
   }
   close(TEMPLATE);
   require "$libpath/headerfooter.pl";

#   &protect;

   if ($cardgreeting1) { $cardgreeting = $cardgreeting1; }
   else { $cardgreeting = $cardgreeting2; }

   if ($FORM{'midi_choice'}) {
      if ($FORM{'midi_choice'} =~ /\.mp3$/i) {
         $audio_type = "audio/mp3";
      }
      else {
         $audio_type = "audio/midi";
      }
      $midi_background = qq|<EMBED src="$midi_url/$FORM{'midi_choice'}" type="$audio_type" hidden=true autostart=true loop=true height=1 width=1> </EMBED>|;
   }

   if ($FORM{'tt'}) {
     $mediasrc2 = get_object($FORM{'tt'}, $cardurl);
   }
   else {
      if ($FORM{'html_email'} && $antileech && !$FORM{'action'}) {
         $mediasrc2 = qq|<img src="%%SRC_FILE%%" border=0 alt="$cardgreeting">|;
      }
      else {
        $mediasrc2 = qq|<img src="$imageurl$cardurl" border=0 alt="$cardgreeting">|;
      }
   }

#   elsif ($FORM{'html_email'} && $antileech) {
#      $medtemplate =~ s/%%%FILE%%%/[SRC_FILE]/ig;
#      $medtemplate =~ s/%%%FILE%%%/$new_imageurl$cardurl/ig;
#   }

   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;
   $template =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $template =~ s/%%%IMAGE%%%/$mediasrc2/ig;
   $template =~ s/%%%CAPTION%%%/$cardcaption/ig;
#   $template =~ s/%%%PROTECT%%%/$protection/ig;
   $template =~ s/%%%IMAGE_NAME%%%/$cardid/ig;
   $template =~ s/%%%LINK%%%/$link/ig;
   $template =~ s/%%%PAGELINKS%%%/$pagelinks/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $template =~ s/%%%IMAGE_URL%%%/$cardurl/ig;
   $template =~ s/%%%ECARD_URL%%%/$imagefolio_url/ig;
   $template =~ s/%%%FONT_COLOR%%%/$cardfontcolor/ig;
   $template =~ s/%%%BG_COLOR%%%/$cardbgcolor/ig;
   $template =~ s/%%%BORDER_COLOR%%%/$cardbordercolor/ig;
   $template =~ s/%%%FONT%%%/$cardfont/ig;
   $template =~ s/%%%SENDER_NAME%%%/$sendername/ig;
   $template =~ s/%%%MESSAGE%%%/$cardmessage/ig;
   $template =~ s/%%%RECIPIENT%%%/$cardrecipient/ig;
   $template =~ s/%%%SENDER_EMAIL%%%/$senderemail/ig;
   $template =~ s/%%%GREETING%%%/$cardgreeting/ig;
   $template =~ s/%%%MIDI_BACKGROUND%%%/$midi_background/ig;
   $template =~ s/%%%IF_JS_CODE%%%/$if_js_code/ig;

   $sent_message =~ s/%%%SENDER_NAME%%%/$sendername/ig;
   $sent_message =~ s/%%%RECIPIENT%%%/$cardrecipient/ig;
   $sent_message =~ s/%%%RETURN_URL%%%/$returnurl/ig;
   $sent_message =~ s/%%%CARD_URL%%%/$postcard_url/ig;

   if ($FORM{'action'} eq "preview") {
      $template =~ s/%%%FORM%%%/$cform/ig;
   }
   elsif ($FORM{'action'} eq "send") {
      $template =~ s/%%%FORM%%%/$sent_message/ig;
   }
   elsif ($FORM{'html_email'}) {
      $template =~ s/%%%HTML_EMAIL_LINK%%%/%%HTML_EMAIL_LINK%%/ig;
   }
   $template =~ s/%%%BODY_BGCOLOR%%%/$body_bgcolor/ig;
   $template =~ s/%%%MAIN_TABLE_WIDTH%%%/$main_table_width/ig;
   $template =~ s/%%%(.*)%%%//ig;
}

###############################################################################
# VIEW ECARD
# Generates a page showing the image and a form to allow the user to send
# the image as a postcard to one or more recipients
###############################################################################
sub view_ecard {

   $newlink = $FORM{'link'};
   $newlink =~ s/\//\./g;
   ($newimage) = $FORM{'image'} =~ m,^(.*)\.\w+$,;

   $backlink = qq|$imagefolio_url?direct=$FORM{'link'}&img=$FORM{'img'}|;
   $card_image_url = qq|/$FORM{'link'}/$FORM{'image'}|;

   $card_image_url =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;

   $cardid = $FORM{'image'};
   $cardurl = $card_image_url;

   if ($FORM{'tt'}) {
      $mediasrc2 = get_object($FORM{'tt'}, $cardurl);
   }
   else {
      $mediasrc2 = qq|<img src="$imageurl$cardurl" border=0 alt="$FORM{'image'}">|;
   }


   if (-e "$data_directory/$newlink.captions.txt"){
      open (CAPTIONS,"$data_directory/$newlink.captions.txt");
      while (<CAPTIONS>) {
         my($filename, $description) = split(/\t/,$_);
         chomp $_;
         next if !$description;
         ($newfile) = $filename =~ m,^(.*)\.\w+$,;
         if ($newfile eq $newimage) {
            $image_caption = $description;
            last;
         }
      }
      close(CAPTIONS);
   }

   &find_midi_files;

   if (-e "$image_directory/$FORM{'link'}/create_card.html") {
      open (TEMPLATE,"$image_directory/$FORM{'link'}/create_card.html") or &Error("Could not open template.  Reason $!");
   }
   else {
      open (TEMPLATE,"$createcard_template") or &Error("Could not open template.  Reason $!");
   }

   while (<TEMPLATE>) {
      if (/<!--#include\s+(virtual|file)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_include($2); }
      elsif (/<!--#exec\s+(cgi)\s*=\s*"*([^"\s]*)"*\s*-->/i) { $template .= &ssi_exec_include($2); }
      else { $template .= $_; }
   }
   close(TEMPLATE);

   require "$libpath/headerfooter.pl";

   if ($iffirstname or $iflastname) {
      $template =~ s/%%%SENDER_NAME_VALUE%%%/$iffirstname $iflastname/ig;
   }
   else {
      $template =~ s/%%%SENDER_NAME_VALUE%%%/Enter your name/ig;
   }
   if ($ifemail) {
      $template =~ s/%%%SENDER_EMAIL_VALUE%%%/$ifemail/ig;
   }
   else {
      $template =~ s/%%%SENDER_EMAIL_VALUE%%%/Enter your e-mail address/ig;
   }

   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_header_bgcolor/ig;


   $template =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $template =~ s/%%%TT%%%/$FORM{'tt'}/ig;
   $template =~ s/%%%IMAGE%%%/$mediasrc2/ig;
   $template =~ s/%%%CAPTION%%%/$image_caption/ig;
#   $template =~ s/%%%PROTECT%%%/$protection/ig;
   $template =~ s/%%%IMAGE_NAME%%%/$newimage/ig;
   $template =~ s/%%%CATEGORY%%%/$newthisdirectory/ig;
   $template =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $template =~ s/%%%IMAGE_URL%%%/$card_image_url/ig;
   $template =~ s/%%%ECARD_URL%%%/$imagefolio_url/ig;
   $template =~ s/%%%LINK%%%/$FORM{'link'}/ig;
   $template =~ s/%%%MIDI_CHOICES%%%/$midi_choices/ig;
   $template =~ s/%%%RETURN_URL%%%/$ENV{'HTTP_REFERER'}/ig;
   $template =~ s/%%%IF_JS_CODE%%%/$if_js_code/ig;
   $template =~ s/%%%BODY_BGCOLOR%%%/$body_bgcolor/ig;
   $template =~ s/%%%MAIN_TABLE_WIDTH%%%/$main_table_width/ig;
   $template =~ s/%%%(.*)%%%//ig;

   print "Content-type: text/html\n\n";
   print $template;
}

###############################################################################
# CHECK INPUT
# Makes sure we have the proper information
###############################################################################
sub check_input {

   if    (!$cardrecipient)                { &Error('You must enter a Recipient Email Address.'); }
   elsif (!$senderemail)                  { &Error('You must enter your Email Address.');        }
   elsif (!$sendername)                   { &Error('You must enter your Name.');                 }
   elsif ($cardrecipient !~ /.*\@.*\..*/) { &Error('The Recipient Email Address is invalid.');   }
   elsif ($senderemail   !~ /.*\@.*\..*/) { &Error('Your Email Address is invalid.');            }
 
   $senderemail =~ s/^\s+//;
   $senderemail =~ s/\s+$//;
   $cardrecipient =~ s/^\s+//;
   $cardrecipient =~ s/\s+$//;
}


###############################################################################
# LOAD VALUES
# Preloads all of our variables
###############################################################################
sub load_values {

   $cardfontcolor     = $FORM{'cardfontcolor'};
   $cardbgcolor       = $FORM{'cardbgcolor'};
   $cardbordercolor   = $FORM{'cardbordercolor'};
   $cardfont          = $FORM{'cardfont'};
   $cardgreeting1     = $FORM{'cardgreeting1'};
   $cardgreeting2     = $FORM{'cardgreeting2'};
   $midi_choice       = $FORM{'midi_choice'};
   $sendername        = $FORM{'sendername'};
   $cardmessage       = $FORM{'cardmessage'};
   $cardrecipient     = $FORM{'cardrecipient'};
   $senderemail       = $FORM{'senderemail'};
   $cardid            = $FORM{'cardid'};
   $cardcaption       = $FORM{'cardcaption'};
   $cardurl           = $FORM{'cardurl'};
   $link              = $FORM{'link'};
   $returnurl         = $FORM{'returnurl'};

$cform = qq|
<table border=0>
<tr><td valign=top>
<form method=post action="$imagefolio_url">
<input type=hidden name=main value="imageCard">
<input type=hidden name=action value="send">
<input type=hidden name=cardfontcolor value="$FORM{'cardfontcolor'}">
<input type=hidden name=cardbgcolor value="$FORM{'cardbgcolor'}">
<input type=hidden name=cardbordercolor value="$FORM{'cardbordercolor'}">
<input type=hidden name=cardfont value="$FORM{'cardfont'}">
<input type=hidden name=cardgreeting1 value="$FORM{'cardgreeting1'}">
<input type=hidden name=cardgreeting2 value="$FORM{'cardgreeting2'}">
<input type=hidden name=midi_choice value="$FORM{'midi_choice'}">
<input type=hidden name=sendername value="$FORM{'sendername'}">
<input type=hidden name=cardmessage value="$FORM{'cardmessage'}">
<input type=hidden name=cardrecipient value="$FORM{'cardrecipient'}">
<input type=hidden name=senderemail value="$FORM{'senderemail'}">
<input type=hidden name=cardid value="$FORM{'cardid'}">
<input type=hidden name=cardcaption value="$FORM{'cardcaption'}">
<input type=hidden name=cardurl value="$FORM{'cardurl'}">
<input type=hidden name=link value="$FORM{'link'}">
<input type=hidden name=tt value="$FORM{'tt'}">
<input type=hidden name=returnurl value="$returnurl">
<input type=submit value="Send Postcard">
</form></td>|;
if ($send_html_email && !$FORM{'tt'}) {
$cform .= qq|
<td valign=top>
<form method=post action="$imagefolio_url">
<input type=hidden name=main value="imageCard">
<input type=hidden name=action value="send">
<input type=hidden name=cardfontcolor value="$FORM{'cardfontcolor'}">
<input type=hidden name=cardbgcolor value="$FORM{'cardbgcolor'}">
<input type=hidden name=cardbordercolor value="$FORM{'cardbordercolor'}">
<input type=hidden name=cardfont value="$FORM{'cardfont'}">
<input type=hidden name=cardgreeting1 value="$FORM{'cardgreeting1'}">
<input type=hidden name=cardgreeting2 value="$FORM{'cardgreeting2'}">
<input type=hidden name=midi_choice value="$FORM{'midi_choice'}">
<input type=hidden name=sendername value="$FORM{'sendername'}">
<input type=hidden name=cardmessage value="$FORM{'cardmessage'}">
<input type=hidden name=cardrecipient value="$FORM{'cardrecipient'}">
<input type=hidden name=senderemail value="$FORM{'senderemail'}">
<input type=hidden name=cardid value="$FORM{'cardid'}">
<input type=hidden name=cardcaption value="$FORM{'cardcaption'}">
<input type=hidden name=cardurl value="$FORM{'cardurl'}">
<input type=hidden name=link value="$FORM{'link'}">
<input type=hidden name=tt value="$FORM{'tt'}">
<input type=hidden name=returnurl value="$returnurl">
<input type=hidden name=html_email value="1">
<input type=submit value="Send HTML Postcard">
</form>
</td>|;
}
$cform .= qq|<td valign=top>
<form>
<INPUT TYPE="button" VALUE="Edit Postcard" onClick="history.go(-1)">
</form>
</td></tr></table>
|;

}

###############################################################################
# SAVE DATA
# Opens up the database file defined in post_config.pl and prints the name
# and email address of the person who submitted the picture
###############################################################################
sub save_postcard_data {
   if ($ifusername) {
      $log_user = $ifusername;
   }
   elsif ($is_admin) {
      $log_user = "Administrator";
   }
   else {
      $log_user = $guest_username;
   }
   $postcard_log = "$logdir/$postcard_log";
   if (! -e $postcard_log) {
      $log_page_contents = "SENDER NAME\tSENDER EMAIL\tRECIPIENT\tSENT FILE\tDATE/TIME\tUSER\tIP\n";
   }
   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $year += 1900;
   $mon++;
   $logdate = sprintf "%04d-%02d-%02d %02d:%02d:%02d", $year, $mon, $mday, $hour, $min, $sec;

   $log_image = $cardurl;
   $log_image =~ s/$imageurl\///ig;

   $log_page_contents .= "$sendername\t$senderemail\t$cardrecipient\t$log_image\t$logdate\t$log_user\t$ENV{'REMOTE_ADDR'}\n";

   open (FILE,">>$postcard_log") or &Error("Can't Open Postcard Log: $!");
   print FILE $log_page_contents;
   close(FILE);
   chmod(0777,"$postcard_log");
}

###############################################################################
# GET DATE
# Gets the current date
###############################################################################
sub get_date {

   @days   = ('Sunday','Monday','Tuesday','Wednesday', 'Thursday','Friday','Saturday');
   @months = ('January','February','March','April','May','June','July',
              'August','September','October','November','December');

   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $time = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
   $year += 1900;

   $date = "$days[$wday], $months[$mon] $mday, $year at $time";
}

###############################################################################
# PROTECT
# called from print_image_table if image protection is turned on.  Generates a
# javascript that presents the site visitor with an alert message if the right
# mouse button is used on the page.  Very simple, but effective.
###############################################################################
sub protect {
$protection = qq|

<!-- Powered by BizSecure ImageFolio - http://www.imagefolio.com -->

<script language="JavaScript1.1">
<!-- Begin
function right(e) {
if (navigator.appName == 'Netscape' && 
(e.which == 2 \|\| e.which == 3)) {
alert('$protection_message');
return false;
}
else if (navigator.appName == 'Microsoft Internet Explorer' && 
(event.button==2 \|\| event.button == 3)) {
alert('$protection_message');
return false;
}
return true;
}
document.onmousedown=right;
if (document.layers) window.captureEvents(Event.MOUSEDOWN);
window.onmousedown=right;
//  End -->
</script>
|; 
}

###############################################################################
# SSI EXEC INCLUDE
# Function to include an external cgi script called via SSI tags
###############################################################################
sub ssi_exec_include {
   my ($includefile) = shift;
   my $external;
   if ($includefile =~ /\.pl/i or $includefile =~ /\.cgi/i) { $external = `perl $includefile`; }
   $external =~ s/^Content-type:\s+text\/html\n//ig;
   $external =~ s/^Content-type:\s+text\/plain\n//ig;
   if ($external) { return $external; }
   else { return "Error processing $includefile.  Make sure this is a perl script and use absolute paths"; }
}

###############################################################################
# SSI INCLUDE
# Funtion to include an external page called via SSI tags
###############################################################################
sub ssi_include {
   my ($includefile) = shift;
   my $external;
   open (EXTERNAL,"$includefile") or &Error("Could not open $includefile.  You must use an absolute path $!");
   my(@filelines)=<EXTERNAL>;
   foreach $fileline (@filelines) { $external .= $fileline; }
   close(EXTERNAL);
   return $external;
}

###############################################################################
# ERROR
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{

   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>
<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>
<form><table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><font face="Verdana,Arial,Helvetica" size=2 color="#ffffff"><strong>Error!</strong></font></td>
<td align=right nowrap><font face="Verdana,Arial,Helvetica" size=2><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>
<tr bgcolor="#eeeeee"><td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%">
<tr><td><font face="Verdana,Arial,Helvetica" size=2><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table><center><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></center>
</td></tr></table></td></tr></table></td></tr></table>
</form>
|;
exit;
}

###############################################################################
# GET OBJECT
# retrieves the template for this media type and returns the $mediasrc tag
###############################################################################
sub get_object {
   my $file = shift;
   if ($file eq "emb") {
                  $FORM{'image'} = "$FORM{'cardid'}.$FORM{'tt'}" unless $FORM{'image'};
                  $mediapath = "$image_directory/$FORM{'link'}/$FORM{'image'}";

#      $emb_table_width           = qq|width="80%"|;
#      $emb_table_border_color    = qq|bgcolor="$main_table_border_color"|;
#      $emb_table_heading_bgcolor = qq|bgcolor="$main_header_bgcolor"|;
#      $emb_table_field_bgcolor   = qq|bgcolor="$main_nav_bgcolor"|;
#      $emb_table_value_bgcolor   = qq|bgcolor="$body_bgcolor"|;
#      $emb_table_field_font      = qq|$font|;
#      $emb_table_value_font      = qq|$font|;
#      $emb_table_header          = qq|<div style="height:22px;line-height:22px;"><$font><b>%%%TABLE_HEADER%%%</b></font></div>|;
#      $embedinfo = $emb_table_header;

      $embedinfo = $if_table_header;
      $embedinfo =~ s/%%%TABLE_HEADER%%%/LINK INFO/ig;
      $embedinfo = qq|<table border="0" cellspacing="1" cellpadding="3" $if_table_border_color $if_table_width><tr><td colspan="2" $if_table_heading_bgcolor align="center">$embedinfo</td></tr>|;
      open (FILE,"$mediapath") or &Error("Could not open $file.  $!");
      while (<FILE>) {
         chomp $_;
         my($field, $value) = split(/\t/,$_);
         if ($field eq 'Embed Code') {
            $value =~ s/\<object/\<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"/i if $value !~ /classid/i;
            $embedcode = qq|<script src="$base_if_url/objectload.js"></script><script type="text/javascript">write_object('$value');</script>|;
         }
         else {
            $embedinfo .= qq|<tr><td $if_table_field_bgcolor width="30%"><$if_table_field_font>$field</font></td><td $if_table_value_bgcolor width="70%"><$if_table_value_font>$value</font></td></tr>|;
         }
      }
      close(FILE);
      $embedinfo .= "</table>";
      return $embedcode;
   }
   elsif (-e "$media_template_directory/$file.html") {
     open (TEMPLATE,"$media_template_directory/$file.html") or &Error("Could not open $file.  $!");
     while (<TEMPLATE>) { $medtemplate .= $_; }
     close(TEMPLATE);
      if ($FORM{'tt'} eq 'ifz'){
                  $ifz_view_bar_disabled = 1;
                  $FORM{'image'} = "$FORM{'cardid'}.$FORM{'tt'}" unless $FORM{'image'};
                  $newimage = $FORM{'cardid'} unless $newimage;
                  $mediapath = "$image_directory/$FORM{'link'}/$FORM{'image'}";
         require "$libpath/zoomify.pl";
         &ifz_get_object;
         $antileech = ();
      }
   }
   elsif ($FORM{'tt'} eq 'ifz'){
                  $ifz_view_bar_disabled = 1;
                  $FORM{'image'} = "$FORM{'cardid'}.$FORM{'tt'}" unless $FORM{'image'};
                  $newimage = $FORM{'cardid'} unless $newimage;
                  $mediapath = "$image_directory/$FORM{'link'}/$FORM{'image'}";
      require "$libpath/zoomify.pl";
      $medtemplate = &ifz_get_template;
      &ifz_get_object;
      $antileech = ();
   }
   else {
     print "Location:$mediaurl\n\n";
     exit;
   }

   if ($FORM{'html_email'} && !$FORM{'action'} && $antileech) {
      $medtemplate =~ s/%%%FILE%%%/%%SRC_FILE%%/ig;
      $medtemplate =~ s/%%%DOWNLOAD_FILE%%%/%%SRC_FILE%%/ig;
   }
   else {
      $medtemplate =~ s/%%%FILE%%%/$imageurl$cardurl/ig;
      $medtemplate =~ s/%%%DOWNLOAD_FILE%%%/$imageurl$cardurl/ig;
   }

   $medtemplate =~ s/%%%NAME%%%/$cardid/ig;

   $medtemplate =~ s/%%%IFIMAGES%%%/$if_images_directory/ig;
   $medtemplate =~ s/%%%IMAGEFOLIO_URL%%%/$imagefolio_url/ig;
   $medtemplate =~ s/%%%BASE_IF_URL%%%/$base_if_url/ig;

   $medtemplate =~ s/%%%(.*)%%%//ig;
   return $medtemplate;
}

sub get_object_2 {
   my $file = shift;
   $medtemplate = ();
   if (-e "$media_template_directory/$file.html") {
     open (TEMPLATE,"$media_template_directory/$file.html") or &Error("Could not open $file.  $!");
     while (<TEMPLATE>) { 
       $medtemplate .= $_; }
     close(TEMPLATE);
   }
   if ($FORM{'html_email'} && !$FORM{'action'} && $antileech) {
      $medtemplate =~ s/%%%FILE%%%/%%SRC_FILE%%/ig;
      $medtemplate =~ s/%%%DOWNLOAD_FILE%%%/%%SRC_FILE%%/ig;
   }
   else {
      $medtemplate =~ s/%%%FILE%%%/$imageurl$cardurl/ig;
      $medtemplate =~ s/%%%DOWNLOAD_FILE%%%/$imageurl$cardurl/ig;
   }

   return $medtemplate;
}


###############################################################################
# FIND MIDI FILES
###############################################################################
sub find_midi_files {

   opendir (MIDIFILES, "$midi_directory");
   @midi_files= grep { /(\.midi|\.mid|\.mp3)$/i } readdir(MIDIFILES);
   closedir (MIDIFILES);
   @midi_files = sort { lc($a) cmp lc($b) } @midi_files;

   $midi_choices = qq|<select name="midi_choice"><option value="" selected>Select backgound music&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|;

   foreach $midi_file (@midi_files) {
      ($midi_name) = $midi_file =~ m,^(.*)\.\w+$,;
      $midi_name =~ s/_/ /g;
      $midi_choices .= qq|<option value="$midi_file">$midi_name|;
   }

   $midi_choices .= qq|</select>|;

}

1;