####CODEHEADER###

require "$currdir/if_lib/init.pl";
&top;


###############################################################################
# TOP
# Determines what to do
###############################################################################
sub top {

   $| = 1;

   if ($is_admin) {
      $site_title = "***Admin Mode*** $site_title";
      $admin_tools = &create_tools;
      $cache_page_age = ();
      $cache_date = ();
      $allow_free_access = 1;
      $full_size_per = 1;
      $one_time_access = $FORM{'ota'};
   }

   if ($COOKIE{'cachereload'}) {
      ($cachereload_direct, $cachereload_link) = split(/\|/, $COOKIE{'cachereload'});
      if ($FORM{'direct'} && $cachereload_direct) {
         $force_cachereload = 1;
         $cachereload_direct = $cachereload_direct - 1;
      }
      elsif ($FORM{'link'} && $cachereload_link) {
         $force_cachereload = 1;
         $cachereload_link = ();
      }
      if ($cachereload_direct or $cachereload_link) {
         print "Set-Cookie: cachereload=$cachereload_direct|$cachereload_link; path=/;\n";
      }
      else {
         print "Set-Cookie: cachereload=; path=/;\n";
      }
   }

   if (($FORM{'lightbox'} eq 'view') or ($FORM{'lbview'} eq 'view') or $FORM{'account'}) {
      $cache_page_age = ();
   }

   $cache_page_age = () if $using_lightbox_mod; # will need to be fixed

   if ($cache_page_age) {
      if (!$full_query && !-e "$cache_directory/pages/index.html") {
         my $index_page =  qq|<HTML><HEAD><TITLE>Forbidden</TITLE></HEAD><BODY BGCOLOR="#FFFFFF">Please rebuild your index to reset the page caching!.</BODY></HTML>|;
         open (FILE,">$cache_directory/pages/index.html");
         print FILE $index_page;
         close(FILE);
         chmod(0777,"$cache_directory/pages/index.html");
      }
      $full_query_save = $full_query;
      $full_query_save .= "~$group_group_name~$skin_name~${columns}x$rows~sort$sortfiles~$use_textlinks~$thumb_info_right";
      $full_query_save =~ s/[^0-9a-zA-Z\_]/~/g;
      $full_query_save =~ s/~x~[0-9]*~y~[0-9]*//g;
      $cache_page_path = $cache_directory . "/pages/$full_query_save.html";
      $cache_page_url = $cache_url . "/pages/$full_query_save.html";
   }

   if ($cache_page_age && (-e $cache_page_path) && (-M $cache_page_path < $cache_page_age) && !$force_cachereload) {
      open (CACHEPAGE,"$cache_page_path") or &Error("Could not open cachepage.  Reason $!");
      while (<CACHEPAGE>) {
         $template .= $_;
      }
      close(CACHEPAGE);
      if (!$allow_free_access or ($group_cat_access eq 'All')) {
         &A001100;
      }
      else {
         print "Content-type: text/html\n\n";
         print $template;
      }
      if (($FORM{'action'} eq "view") && $record_counts) { 
         require "$libpath/image.pl";
         ($newimage) = $FORM{'image'} =~ m,^(.*)\.\w+$,;
         &record_counts;
      }
#      print $cache_page_path;
   }
   else {
      &load_values;
      if ($FORM{'admin'} && ($is_admin or $is_user))                               {                                         &fe_top($FORM{'admin'}); $B001100=1;}
      elsif ($FORM{'link'})                                                        { require "$libpath/image.pl";            &view_image;            }
      elsif ($FORM{'lightbox'} or $FORM{'lbview'})                                 { require "$libpath/lightbox.pl";         &gen_image_table;       }
      elsif ($FORM{'direct'})                                                      { require "$libpath/direct.pl";           &gen_image_table;       }
      elsif ($FORM{'search'})                                                      { require "$libpath/search.pl";           &search;                }
      elsif ($FORM{'account'})                                                     { require "$libpath/accounts.pl";         &do_accounts;           }
      elsif ($FORM{'imageconvert'} && $is_admin)                                   { require "$libpath/imageconvert.pl";     &load_ic;               }
      elsif ($FORM{'globalkeywords'})                                              { require "$libpath/keywords.pl";         &gen_keywords_page;     }
      elsif ($FORM{'advsearch'})                                                   { require "$libpath/advsearch.pl";        &gen_advsearch_page;    }
      elsif ($FORM{'page'} && -e "$template_directory/pages/$FORM{'page'}.html")   { require "$libpath/page.pl";             &gen_external_page;     }
      elsif ($FORM{'mailing'} && -e "$sessions_dir/$FORM{'mailing'}.mailing_sent") { require "$libpath/search.pl";           &search;                }
      elsif ($FORM{'zoomify'})                                                     { if (-e "$libpath/zoomify.pl")         { require "$libpath/zoomify.pl"; &ifz_setup;}
                                                                                     else                                  { print "Content-type: text/html\n\n"; print "<center><font size=3><b>Zoomify ready</b></font></center>"; exit; }}
      elsif ($FORM{'captcha'})                                                     { require "$libpath/captcha.pl";           &captcha_write_img;    }
      else                                                                         { require "$libpath/home.pl";              &gen_home_page;        }

      if ($cache_page_age) {
         if ($allow_free_access && ($group_cat_access ne 'All')) {
            &A001100;
         }
         open (CACHEPAGE,">$cache_page_path");
         print CACHEPAGE $template;
         close(CACHEPAGE);
         chmod(0644,"$cache_page_path");
         if (!$allow_free_access or ($group_cat_access eq 'All')) {
            &A001100;
         }
      }
      elsif (!$B001100) {
         &A001100;
      }
   }
}


###############################################################################
# LOAD VALUES
# Establishes default values for commonly used variables
###############################################################################
sub load_values {
   my ($found, $i, $pos, $count, $cnt, $nav, $subcatlinks, $thumbimages, $template);

   if ($FORM{'direct'}) {
     if ( (!(-e "$image_directory/$FORM{'direct'}")) or(!(-d "$image_directory/$FORM{'direct'}")) or ($FORM{'direct'} =~ /\.\./) ) {
        @count_direct = split(/\//, $FORM{'direct'});
        if ($using_picturepost_mod && (@count_direct == 2)) {
           require "$config_directory/post_config.pl";
           if ($main_users_cat eq $current_cat_root) {
             print qq|Content-type: text/html\n\n<br><br><center><font face="Verdana,Arial,Helvtica" size=2>
             <font color="red"><b>No Files Found!</font>  @count_direct[1]</b> has not uploaded anything so nothing can be shown.<br><br>
             <a href="javascript:history.go(-1)"><b>Return to Previous Page</b></a><br><br><a href="$imagefolio_url"><b>$site_title</b></a></font></center>|;
             exit;
           }
           else {
             print qq|Content-type: text/html\n\n<br><br><center><font face="Verdana,Arial,Helvtica" size=2>
             <font color="red"><b>Error!</font>  $FORM{'direct'}</b> is not a valid category!<br><br>
             <a href="javascript:history.go(-1)"><b>Return to Previous Page</b></a></font></center>|;
             exit;
           }
        }
        else {
          print qq|Content-type: text/html\n\n<br><br><center><font face="Verdana,Arial,Helvtica" size=2>
          <font color="red"><b>Error!</font>  $FORM{'direct'}</b> is not a valid category!<br><br>
          <a href="javascript:history.go(-1)"><b>Return to Previous Page</b></a></font></center>|;
          exit;
        }
     }
     $thisdirectory = get_directory($FORM{'direct'});
     $newthisdirectory = get_clean_name($thisdirectory);
   }
   elsif ($FORM{'link'}) {
     if ($FORM{'link'} =~ /\.\./) {
       print qq|Content-type: text/html\n\n<br><br><center><font face="Verdana,Arial,Helvtica" size=2>
       <font color="red"><b>Error!</font>  $FORM{'link'}</b> is not a valid category!<br><br>
       <a href="javascript:history.go(-1)"><b>Return to Previous Page</b></a></font></center>|;
       exit;
     }
     $thisdirectory = get_directory($FORM{'link'});
     $newthisdirectory = get_clean_name($thisdirectory);
   }
}

1;