####CODEHEADER###

&top;


sub top {
   &read_config;
   $ignore_chars = quotemeta ("$ignore_characters");
   $file_url = $FORM{'file'};
   $file_url =~ s/([^a-zA-Z0-9$ignore_chars])/'%' . sprintf("%2x", ord($1))/ge;
   if ($FORM{'ldc'}) {
      unshift (@INC, "$cpanpath");
   }
   if (uc($FORM{'source'}) eq 'IF') {
      @images = split(/\//, $FORM{'file'});
      $image = pop @images;
      if ($image !~ /^$mypattern/ && $image ne "_category_image.jpg" && $watermark) {
         &remove_old_cache_files;
         ($data_directory) = split(/\/leech/, $overlay_image) if !$data_directory;
         if (defined($ENV{'HTTP_COOKIE'})) {
#            die $ENV{'HTTP_COOKIE'};
            @pairs = split(/; /, $ENV{'HTTP_COOKIE'});
            foreach $pair (@pairs) {
               ($name, $value) = split(/=/, $pair);
               if ($name eq 'IFPro_nwm') {
                  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
                  if (lc($value) eq lc($FORM{'file'})) {
                     $disable_wm = 1;
                  }
               }
               elsif ($name eq 'IFPro_userwm' && $value) {
                  $overlay_image = "$data_directory/sessions/$value/_watermark.png";
#                  die $overlay_image
               }
#               die;
            }
         }
         ($ext) = ($image =~ /\.([^.]+)$/);
         if (($ext =~ /(jpg|gif|png)/i) && !$disable_wm) {
            $in_file = $image_directory . $FORM{'file'};
            $leeching_file = $FORM{'file'};
            $leeching_file =~ s/[^0-9a-zA-Z\_\.]/~/g;
            if ($watermark_cache) {
               &watermark_check;
            }
            else {
               &watermark;
            }
         }
         elsif (!$antileech or $disable_wm){
            &leech_image;
         }
         else {
            &leech_check;
         }
      }
      else {
         &leech_check;
      }
   }
   else {
      &remove_old_cache_files;
      if (-e $FORM{'file'}) {
         $in_file = $FORM{'file'};
         $leeching_file = $FORM{'file'};
         $leeching_file =~ s/[^0-9a-zA-Z\_\.]/~/g;
         if ($watermark_cache) {
            &watermark_check;
         }
         else {
            &watermark;
         }
      }
      else {
         print "Location:$icons_dir/404.jpg\n\n";
         exit;
      }
   }

}


sub leech_check {
   if ($ENV{'HTTP_REFERER'} && $ENV{'HTTP_HOST'}) {
      $ENV{'HTTP_REFERER'} =~ s/www\.//g;
      $ENV{'HTTP_HOST'} =~ s/www\.//g;
      if ($ENV{'HTTP_REFERER'} =~ m|https?://([^/]*)$ENV{'HTTP_HOST'}|i) {
         &leech_image;
      }
      else{
         print "Location:$icons_dir/403.jpg\n\n";
         exit;
      }
   }
   elsif ($FORM{'ldc'}) {
      require "$libpath/crypt.pl";
      $leech_double_check = &admin_encrypt($file_url, $image_directory);
      if ($FORM{'ldc'} eq $leech_double_check) {
         $disable_leech = 1;
      }
   }
   else {
      $stoptime = time();
      $elapsed = $stoptime - $FORM{'ct'};
      if ($elapsed >= 0 && $elapsed < 3) {
         $disable_leech = 1;
      }
   }
   if ($disable_leech) {
      &leech_image;
   }
   else{
      print "Location:$icons_dir/403.jpg\n\n";
      exit;
   }
}

sub leech_image {
   $image_url = $imageurl . $file_url;
   print "Location:$image_url\n\n";
   exit;
}

sub read_config {
   require "$currdir/data/leech/leech.pl";
#   if (-e "data/leech/leech.pl") {
#      $leech_file = "data/leech/leech.pl" ;
#   }
#   else {
#      if ($0=~m#^(.*)(\\|/)#) { $currdir = $1; }
#      else { $currdir = `pwd`; chomp $currdir; }
#      $currdir =~ s/\\/\//ig;
#      $leech_file = $currdir . "/data/leech/leech.pl";
#   }
#   require "$leech_file";
   if (lc($ENV{'HTTPS'}) eq 'on') {
      $imageurl         =~ s/^http\:/https\:/i;
      $image_cache_url  =~ s/^http\:/https\:/i;
      $icons_dir        =~ s/^http\:/https\:/i;
   }
   else {
      $imageurl         =~ s/^https\:/http\:/i;
      $image_cache_url  =~ s/^https\:/http\:/i;
      $icons_dir        =~ s/^http\:/https\:/i;
   }

}

sub watermark_check {
   if (-e "$image_cache_directory/$leeching_file" && (-M "$image_cache_directory/$leeching_file" < -M $overlay_image)) {
      print "Location:$image_cache_url/$leeching_file\n\n";
      exit;
   }
   else{
      &watermark;
   }
}


sub watermark {
   if ($use_im) {
      require "$libpath/imagemagick.pl";
      &do_wm_im;
   }
   else {
      require "$libpath/imageconvert.pl";
      &do_wm_ic;
   }
}

sub do_wm_ic {
   my %gravityTable = (
      "north"     => "top-center",
      "northeast" => "top-right",
      "east"      => "center-right",
      "southeast" => "bottom-right",
      "south"     => "bottom-center",
      "southwest" => "bottom-left",
      "west"      => "center-left",
      "northwest" => "top-left",
   );
   if (exists($gravityTable{lc($gravity)})) {
      $watermark_gravity = $gravityTable{lc($gravity)};
   }
   else {
      $watermark_gravity = "center";
   }
   $return = &do_ic("\"$in_file\"", "\"$image_cache_directory/$leeching_file\"", '', $WaterMarkQuality, '', '', "-rmeta", '', '', '', '', "\"$overlay_image\"", "$watermark_gravity");
   chmod (0777, "$image_cache_directory/$leeching_file");
   print "Location:$image_cache_url/$leeching_file\n\n";
}

sub do_wm_im {

   my $i;

   my $watermark = Image::Magick->new();
   $i = $watermark->Read($overlay_image);
   die $i if $i;
   my $image = Image::Magick->new();
   $i = $image->Read($in_file);
   die $i if $i;
   $i = $image->Set(quality=>$WaterMarkQuality);
   die $i if $i;

   $i = $image->Composite(
       image       => $watermark,
       compose     => 'over',
       gravity     => $gravity);
   warn $i if $i;

   if ($watermark_cache) {
      $i = $image->Write(filename=>"$image_cache_directory/$leeching_file");
      die $i if $i;
      chmod (0777, "$image_cache_directory/$leeching_file");
      print "Location:$image_cache_url/$leeching_file\n\n";
   }
   else {
      print "Content-type: image/jpeg\r\n\r\n";
      $i = $image->Write('jpeg:-');
      die $i if $i;
   }

   undef $image;
   undef $watermark;
   undef $i;
}

###############################################################################
# REMOVE CACHE FILES
# Removes the files in your cache directory that are to old
###############################################################################
sub remove_old_cache_files {

   if (!$watermark_cache){
      opendir (CACHE, "$image_cache_directory") or &Error("Can't Open $image_cache_directory: $!");
      @old_cache_images = grep { /\.jpg$/i or /\.png$/i or /\.gif$/i} readdir(CACHE);
      closedir (CACHE);
      $old_cache_size = @old_cache_images;
      if ($old_cache_size > 1) {
         foreach $old_cache_image (@old_cache_images) {
            next if (!$use_im && -M "$image_cache_directory/$old_cache_image" < "0.01");
            unlink("$image_cache_directory/$old_cache_image");
         }
      }
   }
}


###############################################################################
# PARSE THE FORM
# Parses the form input and returns a hash with all the name
# value pairs.
###############################################################################
sub parse_form {
   my ($buffer, $pair, $name, $value);

   if ($ENV{'REQUEST_METHOD'} eq 'GET') {
     $full_query = $ENV{'QUERY_STRING'};
     @pairs = split(/&/, $ENV{'QUERY_STRING'});
   }
   elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
     read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
     $cache_page_age = ();
     @pairs = split(/&/, $buffer);
   }

   PAIR: foreach $pair (@pairs) {
     ($name, $value) = split(/=/, $pair);
     $name =~ tr/+/ /;
     $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ s/\.\.//;
#     $value =~ s/<[\/]?[^>]*>//mig; #strip out any HTML
#     $value =~ s/(<|\%\W*3\W*c|\&lt)\/?[^>]*(>|\%\W*3\W*e|\&gt)//mig; #strip out any HTML
     if ($FORM{$name} && ($value)) { $FORM{$name} = "$FORM{$name},$value"; }
     elsif ($value) { $FORM{$name} = $value; }
   }
#   if (lc($FORM{'cat'}) eq 'all') {$FORM{'cat'} = ();}
#   $current_cat = $FORM{'direct'} if $FORM{'direct'};
#   $current_cat = $FORM{'link'} if $FORM{'link'};
#   $current_cat = $FORM{'cat'} if $FORM{'cat'};
#   ($current_cat_root) = split (/\//, $current_cat);
}
1;