####CODEHEADER###

require "$currdir/if_lib/init.pl";
&top;


###############################################################################
# TOP
# Determines what to do
###############################################################################
sub top {
   $| = 1;   # flush output

   
   if ($FORM{'rate'}) { &rate; }
   else { &gen_rate_page; }
}

###############################################################################
# GEN RATE PAGE
# Shows a form from which a user can rate a file
###############################################################################
sub gen_rate_page {

   my $template;

   open (TEMPLATE,"$rating_template") or &Error("Could not open template. $!");
   while (<TEMPLATE>) { $template .= $_; }
   close(TEMPLATE);

   $template =~ s/%%%FILE%%%/$FORM{'file'}/ig;
   $template =~ s/%%%CATEGORY%%%/$FORM{'direct'}/ig;
   $template =~ s/%%%SCRIPT_URL%%%/$imagefolio_url/ig;

   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;
   $template =~ s/%%%BODY_BGCOLOR%%%/$body_bgcolor/ig;
   print "Content-type: text/html\n\n";
   print $template;
}

###############################################################################
# RATE
# Displays a thank you msg.
###############################################################################
sub rate {

   my $template;

   &save_ratings;

   open (TEMPLATE,"$rated_template") or &Error("Could not open template.  $!");
   while (<TEMPLATE>) { $template .= $_; }
   close(TEMPLATE);

   $template =~ s/%%%FILE%%%/$FORM{'file'}/ig;
   $template =~ s/%%%RATING%%%/$FORM{'rate'}/ig;

   $template =~ s/%%%MAIN_TABLE_BORDER_COLOR%%%/$main_table_border_color/ig;
   $template =~ s/%%%MAIN_HEADER_BGCOLOR%%%/$main_header_bgcolor/ig;
   $template =~ s/%%%MAIN_NAV_BGCOLOR%%%/$main_nav_bgcolor/ig;
   $template =~ s/%%%MAIN_HEADER_FONT%%%/$main_header_font/ig;
   $template =~ s/%%%BODY_BGCOLOR%%%/$body_bgcolor/ig;
   print "Content-type: text/html\n\n";
   print $template;
}

###############################################################################
# SAVE RATINGS
# Saves a vote to the database
###############################################################################
sub save_ratings {

   if ($FORM{'rate'} > 10) {
      $FORM{'rate'} = "10";
      $FORM{'rate'} = pad_0($FORM{'rate'});
   }

   ($image_name) = $FORM{'file'} =~ m,^(.*)\.\w+$,;
   $image_name =~ s/^$mypattern//g;

   $host = $ENV{'REMOTE_ADDR'};

   if ($is_user && !$confirmed_guest) {
      $host = $ifusername;
   }


   $votefile = "$image_directory/$FORM{'category'}/$image_name.vote";

   if (-e $votefile) {
      open (FILE,"$votefile") or &Error("Could not open $votefile.  $!");
      my(@COUNTS)=<FILE>;
      close(FILE);
      chomp @COUNTS;
      $SIZE=@COUNTS;

      for ($i=0;$i<=$SIZE;$i++) {
         $_=$COUNTS[$i];
         if ($i==0) {
            my ($votes, $rating, $total_rating) = split(/\t/, $_);
            if (!$votes) { $votes = '0'; $rating = '0'; $total_rating ='0';}
            elsif (!$total_rating) { $total_rating = $votes * $rating; $total_rating = pad_0($total_rating);}
            $votes ++;
            $total_rating += $FORM{'rate'};
            $rating = $total_rating / $votes;
            $rating = pad($rating);
            $found = 1;
            $new_votefile = $votes . "\t" . $rating . "\t" . $total_rating . "\t\n";
         }
         else {
            if ($_ =~ /$host/) {
               $no_permission = 1;
            }
            $new_votefile .= $_;
         }
      }
      $new_votefile .= $host . "\n";
   }
   else {
      $rating = pad($FORM{'rate'});
      $new_votefile = "1\t" . $rating . "\t" . $FORM{'rate'} . "\t\n";
      $new_votefile .= $host . "\n";
   }

   if ($no_permission &&!$is_admin) {
      &Error("Your vote has not been registered. You already have voted for this file in the past. Sorry.")
   }
   else {
      open (INDEX,">$votefile") or &Error("Could not open $votefile.  $!");
      if ($useflock) { flock(INDEX, 2); }
      print INDEX "$new_votefile";
      close(INDEX);
      chmod(0777,"$votefile");
   }

}

#####################################################################
# Pad
# Makes sure we have two little digits after the period in currencies
#####################################################################
sub pad {
   my $number = shift;
   $number2 = sprintf("%.2f", $number);
   return $number2;
}

sub pad_0 {
   my $number = shift;
   $number2 = sprintf("%.0f", $number);
   return $number2;
}

###############################################################################
# Error
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{
   local ($whoops) = @_;

print qq|
<html>
<head>
<title>Error</title>
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="180" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="100%">

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$font><b><font color="#ff0000">$whoops</font></b></font></td>
</tr></table>

<center><$font><INPUT TYPE="button" VALUE=" Close " onClick="self.close()"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
</body>
</html>
|;

exit;
}

1;