#!/usr/bin/perl
####CODEHEADER_ZOOMIFY###

eval {
   $| = 1;
   our %IFZ_CONFIG;
   unless ($IFZ_CONFIG{'config_version'}) {
      ($IFZ_CONFIG{'currdir'}) = $0 =~ m#^(.*)[\\|/](.*)#;
      if ($IFZ_CONFIG{'currdir'}) {
         $IFZ_CONFIG{'currdir'} =~ s/\\/\//ig;
      }
      else {
         $IFZ_CONFIG{'currdir'} = ".";
      }
      $IFZ_CONFIG{'errorlog'} = "$IFZ_CONFIG{'currdir'}/data/logs/ZoomifyLog.txt";
      $IFZ_CONFIG{'custom404jpg'} = "$IFZ_CONFIG{'currdir'}/ifz_404.jpg";
      eval {
         require "$IFZ_CONFIG{'currdir'}/data/config/ifpaths.pl";
         %IFZ_CONFIG = &get_paths;
         $IFZ_CONFIG{'errorlog'} = "$IFZ_CONFIG{'data_directory'}/logs/ZoomifyLog.txt";
         $IFZ_CONFIG{'custom404jpg'} = "$IFZ_CONFIG{'base_if_path'}/zoomify/ifz_404.jpg";
      };
      $IFZ_CONFIG{'printheader'} = 1 unless ($ENV{'MOD_PERL'} && !$ENV{'PERL_SEND_HEADER'});
   }
};

# BEGIN Code required for Zoomify upgraders
if ($IFZ_CONFIG{'config_version'} < "4.3" && $ENV{'QUERY_STRING'} !~ /^ifz\=/ && !$IFZ_CONFIG{'cache'} && !$ENV{'MOD_PERL'} && -e "$currdir/Zoomify_scripts_if4/zoomify_if4.pl") {
   eval {
      require "$currdir/Zoomify_scripts_if4/zoomify_if4.pl";
   };
   if ($@) {
      print "Content-type: text/html\n\n<pre>Script Error: $@</pre>\n";
      exit;
   }
}
# END Code required for Zoomify upgraders

if ($ENV{'QUERY_STRING'} =~ /^ifz\=/ && $IFZ_CONFIG{'config_version'}) {
   eval {
      $| = 1;
      my (%IFZ_MAIN, %IFZ_QUERY);
      $IFZ_CONFIG{'cache'} = 1;
      foreach (split(/;/, $ENV{'QUERY_STRING'})) {
        ($IFZ_QUERY{'name'}, $IFZ_QUERY{'value'}) = split(/=/, $_);
        $IFZ_QUERY{'value'} =~ tr/+/ /;
        $IFZ_QUERY{'value'} =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $IFZ_QUERY{'value'} =~ s/\.\.//g;
        $IFZ_MAIN{"QS-$IFZ_QUERY{'name'}"} = $IFZ_QUERY{'value'} if $IFZ_QUERY{'value'};
      }
      $IFZ_MAIN{'QS-ifz'} = "$IFZ_CONFIG{'image_directory'}/$IFZ_MAIN{'QS-ifz'}";
      if (-e "$IFZ_MAIN{'QS-ifz'}.ifz") {
         $IFZ_MAIN{'file'} = "$IFZ_MAIN{'QS-ifz'}.ifz";
      }
      elsif (-e "$IFZ_MAIN{'QS-ifz'}.IFZ") {
         $IFZ_MAIN{'file'} = "$IFZ_MAIN{'QS-ifz'}.IFZ";
      }
      else {
         if ($IFZ_MAIN{'QS-q'} eq "/ImageProperties.xml") {
            if ($IFZ_CONFIG{'printheader'}) {
               print "Cache-Control: no-cache\n";
               print "Content-type: text/xml\n\n";
            }
            print qq|<IMAGE_PROPERTIES WIDTH="256" HEIGHT="200" NUMTILES="1" VERSION="1.8" TILESIZE="256" />|;
         }
         else {
            if (!-e $IFZ_CONFIG{'custom404jpg'}) {
               opendir(SKINDIR,"$IFZ_CONFIG{'base_if_path'}/skins");
               while ($IFZ_MAIN{'skin'} = readdir(SKINDIR)) {
                  if (-e "$IFZ_CONFIG{'base_if_path'}/skins/$IFZ_MAIN{'skin'}/images/icons/404.jpg") {
                     $IFZ_CONFIG{'custom404jpg'} = "$IFZ_CONFIG{'base_if_path'}/skins/$IFZ_MAIN{'skin'}/images/icons/404.jpg";
                     last;
                  }
               }
               closedir(SKINDIR);
            }
            if (-e $IFZ_CONFIG{'custom404jpg'}) {
               if ($IFZ_CONFIG{'printheader'}) {
                  print "Cache-Control: no-cache\n";
                  print "Content-Type: image/jpeg\n\n";
               }
               binmode STDOUT;
               open (F, "<$IFZ_CONFIG{'custom404jpg'}");
               binmode(F);
               while (<F>) {
                  print $_;
               }
               close(F);
            }
            &errorlog($IFZ_CONFIG{'errorlog'},"$IFZ_MAIN{'QS-ifz'}.ifz could not be found.\n") if $IFZ_CONFIG{'errorlog'};
         }
      }
      if ($IFZ_MAIN{'file'}) {
         ($IFZ_MAIN{'filedate'}) = (stat($IFZ_MAIN{'file'}))[9];
         my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime($IFZ_MAIN{'filedate'});
         $IFZ_MAIN{'modheader'} = sprintf "%s, %02d %s %4d %02d:%02d:%02d GMT",("Sun","Mon","Tue","Wed","Thu","Fri","Sat")[$wday],$mday,("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec")[$mon],1900+$year,$hour,$min,$sec;
         if (($ENV{'HTTP_IF_NONE_MATCH'} eq $IFZ_MAIN{'filedate'} or $ENV{'HTTP_IF_MODIFIED_SINCE'} eq $IFZ_MAIN{'modheader'}) && $IFZ_CONFIG{'printheader'}) {
            print "Status: 304 Not Modified\n";
            if ($IFZ_MAIN{'QS-q'} eq "/ImageProperties.xml") {
               print "Content-type: text/xml\n\n";
            }
            else {
               print "Content-type: image/jpeg\n\n";
            }
         }
         else {
            open (F, "<$IFZ_MAIN{'file'}");
            binmode(F);
            seek F, -12, 2;
            while (<F>) {
               $IFZ_MAIN{'index'} .= $_;
            }
            seek F, eval(-$IFZ_MAIN{'index'}), 2;
            $IFZ_MAIN{'index'} = ();
            while (<F>) {
               $IFZ_MAIN{'index'} .= $_;
            }
            close(F);
            $IFZ_MAIN{'index'} = [split(/;/, $IFZ_MAIN{'index'})];
            if ($IFZ_MAIN{'QS-q'} eq "/ImageProperties.xml") {
               $IFZ_MAIN{'xml'} = [split(/,/, $IFZ_MAIN{'index'}[0])];
               if ($IFZ_CONFIG{'printheader'}) {
                  print "Last-Modified: $IFZ_MAIN{'modheader'}\n";
                  print "ETag: $IFZ_MAIN{'filedate'}\n";
                  print "Content-type: text/xml\n\n";
               }
               print qq|<IMAGE_PROPERTIES WIDTH="$IFZ_MAIN{'xml'}[0]" HEIGHT="$IFZ_MAIN{'xml'}[1]" NUMTILES="$IFZ_MAIN{'xml'}[2]" VERSION="$IFZ_MAIN{'xml'}[3]" TILESIZE="$IFZ_MAIN{'xml'}[4]" />|;
            }
            else {
               $IFZ_MAIN{'QS-q'} = "/TileGroup0/0-0-0.jpg" unless $IFZ_MAIN{'QS-q'} =~ /^\/TileGroup/ && $IFZ_MAIN{'QS-q'} =~ /\.jpg$/;
               $IFZ_MAIN{'QS-q'} =~ s/^\/TileGroup//g;
               ($IFZ_MAIN{'group'}, $IFZ_MAIN{'image'}) = split(/\//,$IFZ_MAIN{'QS-q'});
               $IFZ_MAIN{'group'} *= 256;
               for my $i ($IFZ_MAIN{'group'} .. eval($IFZ_MAIN{'group'} + 256)) {
                  ($IFZ_MAIN{'tile'}, $IFZ_MAIN{'position'}) = split(/=/, $IFZ_MAIN{'index'}[$i]);
                  if ($IFZ_MAIN{'image'} eq "$IFZ_MAIN{'tile'}.jpg"){
                     ($IFZ_MAIN{'nexttile'}, $IFZ_MAIN{'nextposition'}) = split(/=/, $IFZ_MAIN{'index'}[eval($i+1)]);
                     open (F, "<$IFZ_MAIN{'file'}");
                     binmode(F);
                     seek F, $IFZ_MAIN{'position'}, 0;
                     read(F, $IFZ_MAIN{'jpeg'}, eval($IFZ_MAIN{'nextposition'} - $IFZ_MAIN{'position'}));
                     close(F);
                     if ($IFZ_CONFIG{'printheader'}) {
                        print "Last-Modified: $IFZ_MAIN{'modheader'}\n";
                        print "ETag: $IFZ_MAIN{'filedate'}\n";
                        print "Content-Length: " . eval($IFZ_MAIN{'nextposition'} - $IFZ_MAIN{'position'}) . "\n";
                        print "Content-type: image/jpeg\n\n";
                     }
                     binmode STDOUT;
                     print $IFZ_MAIN{'jpeg'};
                     last;
                  }
               }
            }
         }
      }
   };
   if ($@) {
      print "Content-type: text/html\n\n" if $IFZ_CONFIG{'printheader'};
      print "<pre>Script Error: $@</pre>\n";
      &errorlog($IFZ_CONFIG{'errorlog'},$@) if $IFZ_CONFIG{'errorlog'};
   }
   exit;
}

sub errorlog {
   my ($errorlog , $error) = @_;
   open (FILE,">$errorlog");
   print FILE "=== SCRIPT ERROR ===\n$error\n=== QUERY STRING ===\n$ENV{'QUERY_STRING'}\n\n=== ENV ===\n";
   foreach (sort keys %ENV) {
      print FILE "$_: $ENV{$_}\n";
   }
   close FILE;
   chmod(0777,"$errorlog");
}


1;
