####CODEHEADER###

require "$currdir/if_lib/init.pl";
&top;


###############################################################################
# TOP
# Determines what to do
###############################################################################
sub top {
   $|++;   # flush output

   if (!$email_lightbox) {
      print "Content-type: text/plain\n\nYou have no access to this feature!\n";
      exit;
   }

   if ($FORM{'share'}) {
      $SEND{'type'} = "share";
      $SEND{'subject'} = "Shared ";
      $successfull_sent_message = $successfull_shared_message;
      $notification_message = $shared_notification_message;
   }
   else {
      $SEND{'type'} = "send";
#      $SEND{'subject'} = "subject";
   }

   if ($FORM{'send'}) { &wassend; }
   else { &gen_sendlightbox_page; }
}

###############################################################################
# GEN SEND LIGHTBOX PAGE
# Shows a form from which a user can rate a file
###############################################################################
sub gen_sendlightbox_page {

   my $cnt_comp = "0";
   foreach (@LIGHTBOXES) {
      next if !$_;
      if ($FORM{'location'} == $cnt_comp) {
         if ($_ =~ /^share\=/) {
            my ($share_user, $lightboxnum) = split(/\t/, $_);
            my ($blah, $owner) = split(/\=/, $share_user);
            if ($owner =~ /^admin./){
               $shared_lightbox_file = "$sessions_dir/$lightboxnum$shared_lightboxes_ext";
            }
            else {
               $shared_lightbox_file = "$sessions_dir/$owner/$lightboxnum$shared_lightboxes_ext";
            }
            open (TEMPSHAREDLIGHTBOX, $shared_lightbox_file);
            my (@TEMPSHAREDLIGHTBOX)=<TEMPSHAREDLIGHTBOX>;
            close (TEMPSHAREDLIGHTBOX);
            chomp @TEMPSHAREDLIGHTBOX;
            $_ = $TEMPSHAREDLIGHTBOX[0];
         }
         ($lb_subject) = split(/\t/, $_);
         ($lb_subject) = split(/\|/, $lb_subject);
         last;
      }
      $cnt_comp++;
   }

   $sender_field = $iffirstname;
   if ($iffirstname) {
      $sender_field .= " $iflastname";
   }
   if ($FORM{'share'}) {
      # radio boxes for
#      $no_expire_option = qq|<tr><td valign=top><input type="checkbox" name="no_expire" value=1><$font><font size=2>Add/Remove permission</font><br>If checked, users can add/remove files from this $lightbox_text, otherwise they will just get a "live view" of this shared $lightbox_text.</font><br></td></tr>|;
   }
   elsif ($is_admin) {
      $no_expire_option = qq|<tr><td valign=top><input type="checkbox" name="no_expire" value=1><$font><font size=2>No expiration</font><br>Sent $lightbox_text will expire in $exp days. Check this to have no expiration date. Also, this sent $lightbox_name won't be added to the recipient's own $lightbox_text list.</font><br></td></tr>|;
   }
print "Content-type: text/html\n\n";
print qq|
<html>
<head>
<title>\u$SEND{'type'} $lightbox_name</title>
</head>
<body bgcolor="$body_bgcolor" onLoad="self.focus();"><center>
<form method=get action="$imagefolio_url">
<input type=hidden name="main" value="lightbox_send">
<input type=hidden name="send" value="1">
<table border=0 width="100%" cellspacing="2" cellpadding="1">|;

if ($limitsend==1){
   print qq|<input type=hidden name="recipient" value="$admin_email">|;
}
else {
   print qq|<tr bgcolor="$main_nav_bgcolor">
      <td><$font><font size=2><b>&nbsp;Enter recipient's email(s)</b></font></font></td>
    </tr>
    <tr> 
      <td valign=top><textarea name="recipient" rows="2" style="width: 100%;"></textarea></td>
    </tr>|;
}
   print qq|<tr bgcolor="$main_nav_bgcolor">
      <td><$font><font size=2><b>&nbsp;Enter your name</b></font></font></td>
    </tr>
    <tr> 
      <td valign=top><input type=text name="sendername" maxlength=76 size=30 value="$sender_field" style="width: 100%;"></td>
    </tr>
    <tr bgcolor="$main_nav_bgcolor"> 
      <td><$font><font size=2><b>&nbsp;Enter your email</b></font></font></td>
    </tr>
    <tr>
      <td valign=top><input type=text name="senderemail" maxlength=76 size=30 value="$ifemail" style="width: 100%;"><br><input type="checkbox" name="checkbox"><$font><font size=2>Send a copy to yourself</font></font></td>
    </tr>|;
#if (!$FORM{'share'}) {
    print qq|<tr bgcolor="$main_nav_bgcolor">
      <td><$font><font size=2><b>&nbsp;Enter subject of $lightbox_text</b></font></font></td>
    </tr>
    <tr> 
      <td valign=top><input type=text name="subject" maxlength=76 size=30 value="$lb_subject" style="width: 100%;"></td>
    </tr>|;
#}
    print qq|<tr bgcolor="$main_nav_bgcolor">
      <td><$font><font size=2><b>&nbsp;Enter message to recipient(s)</b></font></font></td>
    </tr>
    <tr> 
      <td valign=top><textarea name="message" cols=30 rows=5 maxlength="255" wrap="VIRTUAL" style="width: 100%;"></textarea></td>
    </tr>
    <tr> 
      <td align=center align="center"><input type=hidden value="$FORM{'share'}" name="share"><input type=hidden value="$FORM{'location'}" name="location"><input type=submit value="\u$SEND{'type'} $lightbox_name &#34;$lb_subject&#34;"" name="submit"></td>
    </tr>
    $no_expire_option
  </table>
  </form>
</center>
</body>
</html>

|;

}

###############################################################################
# WAS SEND
# Displays a thank you msg.
###############################################################################
sub wassend {

&send_lightbox;
$successfull_sent_message =~ s/%%%RECIPIENT%%%/$receipient_list/ig;
$successfull_sent_message =~ s/%%%SENDER_NAME%%%/$FORM{'sendername'}/ig;
$successfull_sent_message =~ s/%%%SENDER_EMAIL%%%/$FORM{'senderemail'}/ig;
$successfull_sent_message =~ s/%%%SAVED_URL%%%/$saved_lightbox_url/ig;
$successfull_sent_message =~ s/%%%LIGHTBOX_TEXT%%%/$lightbox_text/ig;
$successfull_sent_message =~ s/%%%EXPIRE%%%/$exp/ig;

$target=qq|$imagefolio_url?lightbox=view|;
$sorry = qq~
function right(e) {
if (navigator.appName == 'Netscape' && (e.which == 2 || e.which == 3)) {
alert('Sorry, not allowed.');
return false;
}
else if (navigator.appName == 'Microsoft Internet Explorer' && (event.button==2 || event.button == 3)) {
alert('Sorry, not allowed.');
return false;
}
return true;
}
document.onmousedown=right;
if (document.layers) window.captureEvents(Event.MOUSEDOWN);
window.onmousedown=right;
~;

print "Content-type: text/html\n\n";
print qq|
<html>
<head>
<title>\u$SEND{'type'} $lightbox_name</title>
<SCRIPT language="JavaScript">
function supressError() {
    return true;
}

function load(url) {
    window.onerror = supressError;
    opener.location.href = url;
}

$sorry

</SCRIPT>
</head>
<body bgcolor="$body_bgcolor" onLoad="self.focus();">
<$font><font size=2>$successfull_sent_message
<div align="center"><br><br><a href="javascript:window.close()"><$font><font size=2>Close this window</font></font></a></div>
</font></font>
</body>
</html>
|;
}

###############################################################################
# SEND LIGHTBOX
#
###############################################################################
sub send_lightbox {

   &check_input;
   &get_date;
   &remove_old_lightboxes;
   &get_saved_lightbox_url;
   if ($FORM{'share'}) {
      $LIGHTBOXES[0] = $SHAREDLIGHTBOX[0][0] if $SHAREDLIGHTBOX[0][0];
      my $cnt_comp = "0";
      foreach (@LIGHTBOXES) {
         next if !$_;
         if ($FORM{'location'} == $cnt_comp) {
            if ($_ =~ /^share\=/) {
               ($share_user, $lightboxnum) = split(/\t/, $_);
               $oldshare = 1;
            }
            last;
         }
         $cnt_comp++;
      }
      if ($is_admin) {
         $share_user = "share=admin.$userid" unless $share_user;
         $saved_lightbox_file = qq|$sessions_dir/$lightboxnum$shared_lightboxes_ext|;
      }
      else {
         $share_user = "share=$ifusername" unless $share_user;
         $saved_lightbox_file = qq|$sessions_dir/$ifusername/$lightboxnum$shared_lightboxes_ext|;
      }
      $saved_lightbox_url = qq|$imagefolio_url?lightbox=$lightboxnum&$share_user|;
      if (!$oldshare) {
         my $cnt_comp = "0";
         foreach (@LIGHTBOXES) {
            next if !$_;
            if ($FORM{'location'} == $cnt_comp) {
               $new_lightbox_file .= "$share_user\t$lightboxnum\n";
               $lightboxcookie = "$_\n"
            }
            else {
               $new_lightbox_file .= "$_\n"
            }
            $cnt_comp++;
         }
         open (LIGHTBOX, ">$lightbox_file");
         print LIGHTBOX "$new_lightbox_file";
         close (LIGHTBOX);
         chmod(0777,"$lightbox_file");
      }


#      $lightbox_file = "$sessions_dir/admin.$userid.lightbox";
#      $lightbox_file = "$sessions_dir/$ifusername/lightbox.user";

   }
   else {
      &gen_imagelist;
   }
   if (!$oldshare) {
      open(LIGHTBOXES,">$saved_lightbox_file") or &Error("Could not open $lightbox_text file.  Reason $!");
      print LIGHTBOXES $lightboxcookie;
      close(LIGHTBOXES);
      chmod(0777,"$saved_lightbox_file");
  }
   &send_email;
}

###############################################################################
# CHECK INPUT
# Makes sure we have the proper information
###############################################################################
sub check_input {
   if    (!$FORM{'recipient'})                    { &Error('You must enter a Recipient Email Address.');                 }
#   elsif (!$FORM{'subject'} && $FORM{'share'})    { &Error("You must enter a lc($SEND{'subject'}) for this shared $lightbox_text."); }
   elsif (!$FORM{'senderemail'})                  { &Error('You must enter your Email Address.');                        }
   elsif (!$FORM{'sendername'})                   { &Error('You must enter your Name.');                                 }
#   elsif ($FORM{'recipient'} !~ /.*\@.*\..*/)     { &Error('The Recipient Email Address is invalid.');                   }
   elsif ($FORM{'senderemail'}   !~ /.*\@.*\..*/) { &Error('Your Email Address is invalid.');                            }
}


###############################################################################
# GET DATE
# Gets the current date
###############################################################################
sub get_date {

   @days   = ('Sunday','Monday','Tuesday','Wednesday', 'Thursday','Friday','Saturday');
   @months = ('January','February','March','April','May','June','July',
              'August','September','October','November','December');

   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $time = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
   $year += 1900;

    $date = "$days[$wday], $months[$mon] $mday, $year at $time";
}

###############################################################################
# GENERATE IMAGELIST
#
###############################################################################
sub gen_imagelist {

   my $cnt_comp = "0";
   foreach (@LIGHTBOXES) {
      next if !$_;
      if ($FORM{'location'} == $cnt_comp) {
         if ($_ =~ /^share\=/) {
            my ($share_user, $lightboxnum) = split(/\t/, $_);
            my ($blah, $owner) = split(/\=/, $share_user);
            if ($owner =~ /^admin./){
               $shared_lightbox_file = "$sessions_dir/$lightboxnum$shared_lightboxes_ext";
            }
            else {
               $shared_lightbox_file = "$sessions_dir/$owner/$lightboxnum$shared_lightboxes_ext";
            }
            open (TEMPSHAREDLIGHTBOX, $shared_lightbox_file);
            my (@TEMPSHAREDLIGHTBOX)=<TEMPSHAREDLIGHTBOX>;
            close (TEMPSHAREDLIGHTBOX);
            chomp @TEMPSHAREDLIGHTBOX;
            $_ = $TEMPSHAREDLIGHTBOX[0];
         }
         ($blah, $rawlightbox) = split(/\t/, $_);
         last;
      }
      $cnt_comp++;
   }


   $formsubject = $FORM{'subject'};
   $formsubject =~ s/%%%//ig;
#   $rawlightbox = $COOKIE{$lightbox_cookie_name};
   if ($formsubject!~/\w+/){$lightboxcookie=$untitled_lightbox;}
   else {
      $formsubject =~ s/[$deny_chars]//g;
      $formsubject =~ s/^\s+//g;           # Trim leading blanks
      $formsubject =~ s/\s+$//g;           # Trim trailing blanks
      $formsubject =~ s/\s+\s+/ /g;        # Change two spaces to one.
      $formsubject =~ s/\s+\s+/ /g;        # Change two spaces to one again
      $lightboxcookie = $formsubject;
    }
   $lightboxcookie .= qq|\|$FORM{'senderemail'}\|$FORM{'sendername'}|;

# from <a href="mailto:$FORM{'senderemail'}">$FORM{'sendername'}</a>


   $lightboxcookie .= "\t$rawlightbox";
   $lightboxcookie .= "\t$FORM{'no_expire'}" if $is_admin;

   @rawtext = $rawlightbox =~ /\[(.*?)\]/g;

   foreach $rawtext (@rawtext) {
     @cells = split(/\|/,$rawtext);
     $imagelist .= qq|$cells[0]/$cells[1].$cells[2]
|;
      }
 }

###############################################################################
# REMOVE OLD LIGHTBOXES
# Searches the emailed lightbox directory for files older than $exp days, and removes
# them from your web space
###############################################################################
sub remove_old_lightboxes {

opendir (LIGHTBOXES, "$emailed_lightboxes_directory") or &Error("Can't Open $emailed_lightboxes_directory: $!");
@emailed_lightbox= grep { /$emailed_lightboxes_ext/ } readdir(LIGHTBOXES);
closedir (LIGHTBOXES);
$LIGHTBOXSIZE = @emailed_lightbox;

   if ($LIGHTBOXSIZE > 1) {
     foreach $emailed_lightbox (@emailed_lightbox) { if (-M "$emailed_lightboxes_directory/$emailed_lightbox" > $exp) { unlink("$emailed_lightboxes_directory/$emailed_lightbox"); } }
   }
}

###############################################################################
# GET LIGHTBOXES URL
# Generates a unique number and generates the URL to our emailed lightbox
###############################################################################
sub get_saved_lightbox_url {
$lightboxnum  = reverse time;
$lightboxnum  = substr($userid, 0, 4);
$lightboxnum  = $userid * 1321;
$lightboxnum  = rand $userid;
$lightboxnum =~ s/\.//g;

$saved_lightbox_file = qq|$emailed_lightboxes_directory/$lightboxnum$emailed_lightboxes_ext|;
$saved_lightbox_url = qq|$imagefolio_url?lightbox=$lightboxnum|;
}

###############################################################################
# SEND EMAIL
# Sends notification email to the recipient
###############################################################################
sub send_email {
   $notification_message =~ s/%%%PERSONAL_MESSAGE%%%/$FORM{'message'}/ig;
   $notification_message =~ s/%%%SAVED_URL%%%/$saved_lightbox_url/ig;
   $notification_message =~ s/%%%DATE%%%/$date/ig;
   $notification_message =~ s/%%%SITE_TITLE%%%/$site_title/ig;
   $notification_message =~ s/%%%IMAGEFOLIO_URL%%%/$imagefolio_url/ig;
   $notification_message =~ s/%%%LIGHTBOX_TEXT%%%/$lightbox_text/ig;
   $notification_message =~ s/%%%IMAGELIST%%%/$imagelist/ig;

   my $from_out = "$FORM{'senderemail'}";
   $FORM{'recipient'} = $admin_email if $limitsend;
   if ($FORM{'checkbox'}) {
      $cc_out = "$FORM{'senderemail'}";
   }
   if ($emailcopy) {
      $bcc_out = $admin_email;
   }
   my $subject_out = "[$SEND{'subject'}$lightbox_text] $FORM{'subject'}";
   my $type_out_0 = 'text/plain';  # 'text/plain' or 'text/html' or 'multipart/mixed' or 'multipart/related'
   my $data_out_0 = $notification_message;

   $FORM{'recipient'} =~ s/\n/ /g;
   $FORM{'recipient'} =~ s/\r/ /g;
   $FORM{'recipient'} =~ s/\,/ /g;
   $FORM{'recipient'} =~ s/\;/ /g;

   my @recipients = split(/\ /,$FORM{'recipient'});

   foreach (@recipients) {
      next unless $_;
      next if ($FORM{'recipient'} !~ /.*\@.*\..*/);
      $receipient_list .= $_ . ", ";
      $to_out = $_;
      &send_mime_email($from_out, $to_out, $cc_out, $bcc_out, $subject_out, $type_out_0, $data_out_0, $type_out_1, $data_out_1, $type_out_2, $id_out, $path_out);
   }
   $receipient_list =~ s/\, $//g;


}

1;