####CODEHEADER###

   require "$currdir/if_lib/init.pl";

   if (!$download_lightbox) {
      print "Content-type: text/plain\n\nYou have no access to this feature!\n";
      exit;
   }


   my $cnt_comp = "0";
   foreach (@LIGHTBOXES) {
      next if !$_;
      if ($FORM{'location'} == $cnt_comp) {
         if ($_ =~ /^share\=/) {
            my ($share_user, $lightboxnum) = split(/\t/, $_);
            my ($blah, $owner) = split(/\=/, $share_user);
            if ($owner =~ /^admin./){
               $shared_lightbox_file = "$sessions_dir/$lightboxnum$shared_lightboxes_ext";
            }
            else {
               $shared_lightbox_file = "$sessions_dir/$owner/$lightboxnum$shared_lightboxes_ext";
            }
            open (TEMPSHAREDLIGHTBOX, $shared_lightbox_file);
            my (@TEMPSHAREDLIGHTBOX)=<TEMPSHAREDLIGHTBOX>;
            close (TEMPSHAREDLIGHTBOX);
            chomp @TEMPSHAREDLIGHTBOX;
            $_ = $TEMPSHAREDLIGHTBOX[0];
         }
         ($blah, $rawlightbox) = split(/\t/, $_);
         ($zippedlightboxnum) = split(/\|/, $blah);
         $zippedlightboxnum =~ s/\ /\_/g;
         last;
      }
      $cnt_comp++;
   }

   &load_Archive_Zip;
   &remove_old_zipfiles;
   &get_zipped_lightbox_url;
   &gen_zipfile;
   if (!$is_admin && $download_log) {
    &create_download_log;
   }

   &do_download;

sub load_Archive_Zip {
   use Archive::Zip qw(:CONSTANTS :ERROR_CODES);
}

sub create_download_log {
   if ($ifusername) {
      $log_user = $ifusername;
   }
   elsif ($is_admin) {
      $log_user = "Administrator";
   }
   else {
      $log_user = $guest_username;
   }
   $download_log = "$logdir/$download_log";
   if (! -e $download_log) {
      $log_file = "DOWNLOAD SYSTEM\tUSER\tIP\tDATE/TIME\tFILE(S)\n";
   }
   ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
   $year += 1900;
   $mon++;
   $logdate = sprintf "%04d-%02d-%02d %02d:%02d:%02d", $year, $mon, $mday, $hour, $min, $sec;

   $log_file .= "$lightbox_name download\t$log_user\t$ENV{'REMOTE_ADDR'}\t$logdate\t$log\n";

   open (FILE,">>$download_log") or &Error("Can't Open Download Log: $!");
   print FILE $log_file;
   close(FILE);
   chmod(0777,"$download_log");
}

###############################################################################
# GENERATE THUMBNAILS
#
###############################################################################
sub gen_zipfile {

   my $zip = Archive::Zip->new();
#   my $lightbox = $COOKIE{$lightbox_cookie_name};
   my $checkusername = $COOKIE{'IFPro_user_session'};
   @textinfo = $rawlightbox =~ /\[(.*?)\]/g;


   foreach $textinfo (@textinfo) {
      @cells = split(/\|/,$textinfo);
      $folder=$cells[0];
      $name=$cells[1];
      $name =~ s/^$mypattern//g;
      $end=$cells[2];

      $fullsize_file = qq|$image_directory/$folder/$mypattern_fullsize$name.$myextension_fullsize|;
      if (-e $fullsize_file && (($group_full_size_per && $is_user) or (!$is_user && $use_fullsize))) {

         if (lc($myextension_fullsize) eq 'zip') {
            my $fullsize_zipfile = Archive::Zip->new();
            $fullsize_zipfile->read($fullsize_file);
#            my @member_names = $fullsize_zipfile->memberNames();
#            my $cnt = 0;
            foreach my $member ($fullsize_zipfile->members()) { 
#               $member->fileName("$lightbox_name/$folder/$member_names[$cnt]");
#               my $current_name = $member->fileName();
               $member->fileName("$lightbox_name/$folder/" . $member->fileName());
               $zip->addMember( $member );
#               $cnt++;
            }
         }
         else {
            $image = $fullsize_file;
            $name = qq|$lightbox_name/$folder/$name.$myextension_fullsize|;
            $zip->addFile( $image, $name );
         }
         $log .= "$folder/$mypattern_fullsize$name.$myextension_fullsize\t";
      }
      else {
         if ($end =~ /^(ifz|emb)$/i) {
            if (-e "$image_directory/$folder/$mypattern$name.jpg") {
               $end = "jpg";
            }
            elsif (-e "$image_directory/$folder/$mypattern$name.JPG") {
               $end = "JPG";
            }
            $image = qq|$image_directory/$folder/$mypattern$name.$end|;
         }
         else {
            $image = qq|$image_directory/$folder/$name.$end|;
         }
         if (-e $image){
            $log .= "$folder/$name.$end\t";
            $name = qq|$lightbox_name/$folder/$name.$end|;
            $zip->addFile( $image, $name );
         }
      }
   }
#   $zip->addFile( "c:/tree.jpg", "tree.jpg" );
   die 'write error' if $zip->writeToFileNamed( $zipped_lightbox_file ) != AZ_OK;
   chmod(0777,"$zipped_lightbox_file");

#my $zip = Archive::Zip->new();

#my $status = $zip->read($fullsize_file);
#$status = $zip->writeToFileNamed($zipped_lightbox_file);

}

###############################################################################
# REMOVE OLD ZIPPED LIGHTBOXES
# Searches the zipped lightbox directory for files older than 1 day, and removes
# them from your web space
###############################################################################
sub remove_old_zipfiles {

opendir (ZIPFILES, "$zipped_lightboxes_directory") or &Error("Can't Open $zipped_lightboxes_directory: $!");
@zipped_lightbox= grep { /$zipped_lightboxes_ext/ } readdir(ZIPFILES);
closedir (ZIPFILES);
$ZIPPEDLIGHTBOXSIZE = @zipped_lightbox;

   if ($ZIPPEDLIGHTBOXSIZE > 1) {
     foreach $zipped_lightbox (@zipped_lightbox) { if (-M "$zipped_lightboxes_directory/$zipped_lightbox" > $zip_expiration) { unlink("$zipped_lightboxes_directory/$zipped_lightbox") unless $zipped_lightbox =~ /index/i; } }
   }
}

###############################################################################
# GET ZIPFILES URL
# Generates a unique number and generates the URL to our postcard
###############################################################################
sub get_zipped_lightbox_url {
   if ($zippedlightboxnum eq "$untitled_lightbox") {
      $zippedlightboxnum  = reverse time;
      $zippedlightboxnum  = substr($userid, 0, 4);
      $zippedlightboxnum  = $userid * 1321;
      $zippedlightboxnum  = rand $userid;
      $zippedlightboxnum =~ s/\.//g;
   }

$zipped_lightbox_file = "$zipped_lightboxes_directory/$zippedlightboxnum$zipped_lightboxes_ext";
$zipped_lightbox_url = "$zipped_lightboxes_url/$zippedlightboxnum$zipped_lightboxes_ext";
}

###############################################################################
# DISPLAY MACINTOSH DOWNLOAD PAGE
# Macintosh treat downloads different the Unix/PC computers.
###############################################################################
sub do_download {
my ($blah, $main_header_font_color) = split(/color\=/, $main_header_font);
($main_header_font_color) = split(/(\ |\>)/, $main_header_font_color);
$main_header_font_color =~ s/\"//ig;
print "Content-type: text/html\n\n";
print qq|<html>
<head>
<title>D  O  W  N  L  O  A  D</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.dowload {  font-family: Arial, Helvetica, sans-serif; font-size: 14pt; font-weight: bold; color: $main_header_font_color; float: right; clip:     rect(   )}
-->
</style>
</head>

<body bgcolor="$main_header_bgcolor" onload="location.href='$zipped_lightbox_url'">
<div id="Layer1" style="position:absolute; left:0; top:0; width:345; height:25; z-index:1"> 
  <div align="right" class="dowload">D&nbsp;&nbsp; O&nbsp;&nbsp; W&nbsp;&nbsp; N&nbsp;&nbsp; 
  L&nbsp;&nbsp; O&nbsp;&nbsp; A&nbsp;&nbsp; D</div>
</div>
<div id="Layer2" style="position:absolute; left:25px; top:25px; width:300px; height:200px; z-index:2; background-color:#FFFFFF; layer-background-color:#FFFFFF; border: 1px none #000000"> 
  <table width="100%" border="0" cellpadding="5">
    <tr>
      <td><font face="Arial, Helvetica, sans-serif" size="2">Downloading of your 
        files should start within seconds...</font>
        <ol>
          <li> <font face="Arial, Helvetica, sans-serif" size="2">If the download 
            does not start by itself click <a href="$zipped_lightbox_url">here</a>
            to download the file manually.</font></li>
          <li><font face="Arial, Helvetica, sans-serif" size="2">You will need 
            a program like <a href="http://www.stuffit.com/expander" target="_blank">StuffIt&nbsp;Expander</a> 
            (free) to open the zip-file.</font></li>
        </ol>
  <CENTER>
          <font face="Arial, Helvetica, sans-serif" size="2"><a href="javascript:window.close()">Close 
            this window</a> </font>          </CENTER></td>
    </tr>
  </table>
</div>
</body>
</html>|;
}

###############################################################################
# Error
# shows error message if form not filled out correctly
###############################################################################
sub ErrorOLD{
   print "Content-type: text/html\n\n";
   local ($whoops) = @_;

print qq|
<html>
<head>
<title>Error</title>
<script language="JavaScript">
<!--
function help(){
window.alert("Help\\n\\nThis error message is displayed either because I was not able to understand your input or your input was incorrect.");
}
//-->
</script>

</head>

<body bgcolor="#ffffff" marginwidth=0 marginheight=0 topmargin=0 leftmargin=0>

<form>

<table border=0 cellspacing=0 cellpadding=0 width="100%" height="100%"><tr><td valign=middle align=center>
<table border=2 cellspacing=0 cellpadding=0 width="350" bgcolor="#000000"><tr><td>
<table border=0 cellspacing=0 cellpadding=3 width="350"><tr bgcolor="000000">
<td nowrap><$font><font color="#ffffff"><strong>Error!</strong></font></font></td>
<td align=right nowrap><$font><b><INPUT TYPE="button" VALUE=" ? " onClick="help()">&nbsp;<INPUT TYPE="button" VALUE=" X " onClick="history.go(-1)"></b></font></td></tr>

<tr bgcolor="#eeeeee">
<td colspan=2><table border=0 cellspacing=0 cellpadding=5 width="100%"><tr>
<td><$font><b><font color="#ff0000">$whoops</font></b><br><br>If the button below does not take you back, please use your browser's back button to go back and try again.<br><br></font></td>
</tr></table>

<center><$font><INPUT TYPE="button" VALUE="     OK     " onClick="history.go(-1)"></font></center>

</td></tr></table></td></tr></table></td></tr></table>
</form>
</body>
</html>
|;

exit;
}
1;